#include "xsciter.h"
#include "xevent.h"
#include "xgraphics.h"

namespace tis {

  /*static bool notify1(VM* c, value cb, value val = 0) {
    if( !cb ) return false;
    if( CsMethodP(cb) ) {
      TRY
      {
        tis::auto_scope _(c, tis::CsMethodNamespace(cb) );
        if(val)
          return TRUE_VALUE == CsCallFunction(CsCurrentScope(c),cb,1,val);
        else
          return TRUE_VALUE == CsCallFunction(CsCurrentScope(c),cb,0);
      }
      CATCH_ERROR_NE
      {
        CsHandleUnhandledError(c);
        return false;
      }
    }
    return false;
  }

  bool pubsub::notify(VM* c, wchars name, value p)
  {
    bool r = false;
    {
      auto_state<bool> _(notifying,true);
      for(int n = 0; n < list.size(); ++n )  {
        pubsub::item& it = list[n];
        if(it.name() == name) {
          if(notify1(c,it.callback,p))
            r = true;
          if(it.once)
            it.callback = 0;
        }
      }
    }
    if(!notifying)
      for(int n = list.last_index(); n >= 0; --n )
        if( !list[n].callback )
          list.remove(n);
    return r;
  }*/

  value clipboard_format_sym(html::clipboard::clipboard_format cf);
  //value clipboard_data_value(xvm *c, html::clipboard::data *pd);

  static value CSF_preventDefault(xvm *c) {
    value obj;
    CsParseArguments(c, "V*", &obj, c->eventDispatch);

    xview *pv = static_cast<xview *>(CsCObjectValue(obj));

    if (!pv || !pv->pevt) return UNDEFINED_VALUE;

    pv->pevt->cmd |= html::EVENT_HANDLED;
    return TRUE_VALUE;
  }

  static value CSF_match(xvm *c) {
    value  obj;
    wchars name, selector;
    CsParseArguments(c, "V=*S#|S#", &obj, c->eventDispatch, &name.start,
                     &name.length, &selector.start, &selector.length);

    xview *pv = static_cast<xview *>(CsCObjectValue(obj));

    if (!pv || !pv->pevt) return UNDEFINED_VALUE;

    html::subscription sub(0, name, selector);
    html::helement principal;

    return pv->pevt->match(*pv, sub, principal) ? TRUE_VALUE : FALSE_VALUE;
  }

  static value CsGetExchangeData(xvm *c, value sym, html::clipboard::data *pd) {
    if (!pd) return NULL_VALUE;
    if (sym == clipboard_format_sym(html::clipboard::cf_text)) {
      html::clipboard::text_item *pi = pd->get<html::clipboard::text_item>();
      if (pi) return CsMakeString(c, pi->val);
    }

    else if (sym == clipboard_format_sym(html::clipboard::cf_html)) {
      html::clipboard::html_item *pi = pd->get<html::clipboard::html_item>();
      if (pi) {
        // tool::string      uri;
        // tool::array<byte> data;
        // pi->get_html(data,uri);
        // pi->get_url(uri);
        CsPush(c, CsMakeString(c, u8::cvt(pi->val)));
        value url  = CsMakeString(c, pi->url);
        value html = CsPop(c);
        CS_RETURN2(c, url, html);
      }
    }

    else if (sym == clipboard_format_sym(html::clipboard::cf_picture)) {
      html::clipboard::image_item *pi = pd->get<html::clipboard::image_item>();
      if (pi)
        return image_object(c, pi->image);
    }

    else if (sym == clipboard_format_sym(html::clipboard::cf_hyperlink)) {
      html::clipboard::link_item *pi = pd->get<html::clipboard::link_item>();
      if (pi) {
        CsPush(c, CsMakeString(c, pi->caption));
        value url     = CsMakeString(c, pi->url);
        value caption = CsPop(c);
        CS_RETURN2(c, caption, url);
      }
    }

    else if (sym == clipboard_format_sym(html::clipboard::cf_file)) {
      html::clipboard::file_item *pi = pd->get<html::clipboard::file_item>();
      if (pi) {
        array<tool::value> list;
        pi->filenames.each([&list](tool::ustring s) -> bool {
          list.push(tool::value(s));
          return false;
        });
        return value_to_value(c, tool::value::make_array(list()));
      }
    } else if (sym == clipboard_format_sym(html::clipboard::cf_json)) {
      html::clipboard::json_item *pi = pd->get<html::clipboard::json_item>();
      if (pi) {
        ustring     jsdata = u8::cvt(pi->val());
        auto        chars  = jsdata();
        tool::value v      = xjson::parse(chars, false);
        return value_to_value(c, v);
      }
    }
    return NULL_VALUE;
  }

  static value CSF_keyPressed(xvm *c) {
    int_t keyCode = 0;
    CsParseArguments(c, "**|i", &keyCode);
    return html::event::get_key_state(keyCode) ? TRUE_VALUE : FALSE_VALUE;
  }
  

  static value CSF_exchangeData(xvm *c) {
    value obj, p = 0;
    CsParseArguments(c, "V=*|V", &obj, c->eventDispatch, &p);

    xview *pv = static_cast<xview *>(CsCObjectValue(obj));
    if (!pv || !pv->pevt) return UNDEFINED_VALUE;

    if (pv->pevt->event_group() != html::HANDLE_EXCHANGE)
      return UNDEFINED_VALUE;

    html::event_exchange *pevb = (html::event_exchange *)pv->pevt;
    //  return (pevb->data)? clipboard_data_value( c, pevb->data ) : NULL_VALUE;

    if (p == 0) {
      value items = CsMakeVector(c, 0);
      PROTECT(items);
      auto cb = [c, &p, &items](html::clipboard::clipboard_format cf) -> bool {
        CsVectorPush(c, items, clipboard_format_sym(cf));
        return true;
      };
      pevb->data->available_formats(cb);
      return items;
    } else if (CsSymbolP(p))
      return CsGetExchangeData(c, p, pevb->data);
    // else if( p1 == CsSymbolOf("put") )
    //  return CSF_clipboardPut(c);
    else {
      CsUnexpectedTypeError(c, p, "exchange data type");
      return UNDEFINED_VALUE;
    }

    // html::event_exchange* pevb = ( html::event_exchange*) pv->pevt;
    // return (pevb->data)? clipboard_data_value( c, pevb->data ) : NULL_VALUE;
  }

  static value scrollAxisSym(html::event_scroll *pse) {
    static value sym_vertical   = CsSymbolOf(CHARS("vertical"));
    static value sym_horizontal = CsSymbolOf(CHARS("horizontal"));
    return pse->vertical ? sym_vertical : sym_horizontal;
  }

  /* methods */
  static c_method methods[] = {
      C_METHOD_ENTRY_X("preventDefault", CSF_preventDefault),
      C_METHOD_ENTRY_X("stopPropagation", CSF_preventDefault),
      C_METHOD_ENTRY_X("match", CSF_match),
      C_METHOD_ENTRY_X("exchangeData", CSF_exchangeData),
      C_METHOD_ENTRY_X("keyPressed", CSF_keyPressed),

      C_METHOD_ENTRY_X(0, 0)};

  /* constants */
  static constant constants[] = {
      CONSTANT_ENTRY_X("SINKING", int_value(html::EVENT_SINKING)),
      CONSTANT_ENTRY_X("HANDLED", int_value(html::EVENT_HANDLED)),

      CONSTANT_ENTRY_X("MOUSE_ENTER", int_value(html::MOUSE_ENTER)),
      CONSTANT_ENTRY_X("MOUSE_LEAVE", int_value(html::MOUSE_LEAVE)),
      CONSTANT_ENTRY_X("MOUSE_MOVE", int_value(html::MOUSE_MOVE)),
      CONSTANT_ENTRY_X("MOUSE_UP", int_value(html::MOUSE_UP)),
      CONSTANT_ENTRY_X("MOUSE_DOWN", int_value(html::MOUSE_DOWN)),
      CONSTANT_ENTRY_X("MOUSE_DCLICK", int_value(html::MOUSE_DCLICK)),
      CONSTANT_ENTRY_X("MOUSE_CLICK", int_value(html::MOUSE_CLICK)),
      CONSTANT_ENTRY_X("MOUSE_WHEEL", int_value(html::MOUSE_WHEEL)),
      CONSTANT_ENTRY_X("MOUSE_TICK", int_value(html::MOUSE_TICK)),
      CONSTANT_ENTRY_X("MOUSE_IDLE", int_value(html::MOUSE_IDLE)),
      CONSTANT_ENTRY_X("MOUSE_CHECK", int_value(html::MOUSE_CHECK)),
      CONSTANT_ENTRY_X("MOUSE_DRAG_REQUEST",
                       int_value(html::MOUSE_DRAG_REQUEST)),

      CONSTANT_ENTRY_X("DRAGGING", int_value(html::DRAGGING)),
      CONSTANT_ENTRY_X("DROP", int_value(html::DROP)),
      CONSTANT_ENTRY_X("DRAG_REQUEST", int_value(html::DRAG_REQUEST)),
      CONSTANT_ENTRY_X("DRAG_ENTER", int_value(html::DRAG_ENTER)),
      CONSTANT_ENTRY_X("DRAG_LEAVE", int_value(html::DRAG_LEAVE)),

      CONSTANT_ENTRY_X("KEY_DOWN", int_value(html::KEY_DOWN)),
      CONSTANT_ENTRY_X("KEY_UP", int_value(html::KEY_UP)),
      CONSTANT_ENTRY_X("KEY_CHAR", int_value(html::KEY_CHAR)),

      CONSTANT_ENTRY_X("SCROLL_HOME", int_value(html::SCROLL_HOME)),
      CONSTANT_ENTRY_X("SCROLL_END", int_value(html::SCROLL_END)),
      CONSTANT_ENTRY_X("SCROLL_STEP_PLUS", int_value(html::SCROLL_STEP_PLUS)),
      CONSTANT_ENTRY_X("SCROLL_STEP_MINUS", int_value(html::SCROLL_STEP_MINUS)),
      CONSTANT_ENTRY_X("SCROLL_PAGE_PLUS", int_value(html::SCROLL_PAGE_PLUS)),
      CONSTANT_ENTRY_X("SCROLL_PAGE_MINUS", int_value(html::SCROLL_PAGE_MINUS)),
      CONSTANT_ENTRY_X("SCROLL_POS", int_value(html::SCROLL_POS)),
      CONSTANT_ENTRY_X("SCROLL_SLIDER_PRESSED", int_value(html::SCROLL_SLIDER_PRESSED)),
      CONSTANT_ENTRY_X("SCROLL_SLIDER_RELEASED", int_value(html::SCROLL_SLIDER_RELEASED)),
      CONSTANT_ENTRY_X("SCROLL_CORNER_PRESSED", int_value(html::SCROLL_CORNER_PRESSED)),
      CONSTANT_ENTRY_X("SCROLL_CORNER_RELEASED", int_value(html::SCROLL_CORNER_RELEASED)),

      CONSTANT_ENTRY_X("LOST_FOCUS", int_value(html::LOST_FOCUS)),
      CONSTANT_ENTRY_X("GOT_FOCUS", int_value(html::GOT_FOCUS)),
      CONSTANT_ENTRY_X("FOCUS_IN", int_value(html::FOCUS_IN)),
      CONSTANT_ENTRY_X("FOCUS_OUT", int_value(html::FOCUS_OUT)),

      CONSTANT_ENTRY_X("BUTTON_CLICK", int_value(html::BUTTON_CLICK)),
      CONSTANT_ENTRY_X("BUTTON_PRESS", int_value(html::BUTTON_PRESS)),
      CONSTANT_ENTRY_X("BUTTON_STATE_CHANGED",
                       int_value(html::BUTTON_STATE_CHANGED)),
      CONSTANT_ENTRY_X("EDIT_VALUE_CHANGING",
                       int_value(html::EDIT_VALUE_CHANGING)),
      CONSTANT_ENTRY_X("EDIT_VALUE_CHANGED",
                       int_value(html::EDIT_VALUE_CHANGED)),
      CONSTANT_ENTRY_X("SELECT_SELECTION_CHANGED",
                       int_value(html::SELECT_SELECTION_CHANGED)),
      CONSTANT_ENTRY_X("SELECT_SELECTION_CHANGING",
                       int_value(html::SELECT_SELECTION_CHANGING)),
      CONSTANT_ENTRY_X("SHOW_POPUP", int_value(html::SHOW_POPUP)),

      CONSTANT_ENTRY_X("SELECT_VALUE_CHANGED", int_value(html::SELECT_VALUE_CHANGED)),
      CONSTANT_ENTRY_X("SELECT_STATE_CHANGED", int_value(html::SELECT_VALUE_CHANGED)),
      CONSTANT_ENTRY_X("HYPERLINK_CLICK", int_value(html::HYPERLINK_CLICK)),

      CONSTANT_ENTRY_X("CLICK", int_value(html::CLICK)),
      CONSTANT_ENTRY_X("CHANGE", int_value(html::CHANGE)),

      CONSTANT_ENTRY_X("ACTIVATE_CHILD", int_value(html::ACTIVATE_CHILD)),
      CONSTANT_ENTRY_X("POPUP_REQUEST", int_value(html::POPUP_REQUEST)),
      CONSTANT_ENTRY_X("POPUP_READY", int_value(html::POPUP_READY)),
      CONSTANT_ENTRY_X("POPUP_DISMISSED", int_value(html::POPUP_DISMISSED)),
      CONSTANT_ENTRY_X("POPUP_DISMISSING", int_value(html::POPUP_DISMISSING)),
      CONSTANT_ENTRY_X("MENU_ITEM_ACTIVE", int_value(html::MENU_ITEM_ACTIVE)),
      CONSTANT_ENTRY_X("MENU_ITEM_CLICK", int_value(html::MENU_ITEM_CLICK)),
      CONSTANT_ENTRY_X("CONTEXT_MENU_REQUEST",
                       int_value(html::CONTEXT_MENU_REQUEST)),
      CONSTANT_ENTRY_X("CONTEXT_MENU_SETUP",
                       int_value(html::CONTEXT_MENU_SETUP)),
      CONSTANT_ENTRY_X("VISUAL_STATUS_CHANGED",
                       int_value(html::VISUAL_STATUS_CHANGED)),
      CONSTANT_ENTRY_X("DISABLED_STATUS_CHANGED",
                       int_value(html::DISABLED_STATUS_CHANGED)),
      CONSTANT_ENTRY_X("UI_STATE_CHANGED", int_value(html::UI_STATE_CHANGED)),
      CONSTANT_ENTRY_X("MEDIA_CHANGED", int_value(html::MEDIA_CHANGED)),
      CONSTANT_ENTRY_X("INPUT_LANGUAGE_CHANGED",
                       int_value(html::INPUT_LANGUAGE_CHANGED)),
      CONSTANT_ENTRY_X("CONTENT_MODIFIED", int_value(html::CONTENT_MODIFIED)),

      CONSTANT_ENTRY_X("ELEMENT_COLLAPSED", int_value(html::ELEMENT_COLLAPSED)),
      CONSTANT_ENTRY_X("ELEMENT_EXPANDED", int_value(html::ELEMENT_EXPANDED)),

      CONSTANT_ENTRY_X("FORM_SUBMIT", int_value(html::FORM_SUBMIT)),
      CONSTANT_ENTRY_X("FORM_RESET", int_value(html::FORM_RESET)),
      CONSTANT_ENTRY_X("FORM_VALUE_CHANGED",
                       int_value(html::FORM_VALUE_CHANGED)),

      CONSTANT_ENTRY_X("DRAGGING_MOVE", int_value(html::DRAGGING_MOVE)),
      CONSTANT_ENTRY_X("DRAGGING_COPY", int_value(html::DRAGGING_COPY)),

      CONSTANT_ENTRY_X("DOCUMENT_COMPLETE", int_value(html::DOCUMENT_COMPLETE)),

      CONSTANT_ENTRY_X("HISTORY_PUSH", int_value(html::HISTORY_PUSH)),
      CONSTANT_ENTRY_X("HISTORY_DROP", int_value(html::HISTORY_DROP)),
      CONSTANT_ENTRY_X("HISTORY_NEXT", int_value(html::HISTORY_NEXT)),
      CONSTANT_ENTRY_X("HISTORY_PRIOR", int_value(html::HISTORY_PRIOR)),
      CONSTANT_ENTRY_X("HISTORY_STATE_CHANGED",
                       int_value(html::HISTORY_STATE_CHANGED)),

      CONSTANT_ENTRY_X("CLOSE_POPUP", int_value(html::CLOSE_POPUP)),
      CONSTANT_ENTRY_X("REQUEST_TOOLTIP", int_value(html::TOOLTIP_REQUEST)),
      CONSTANT_ENTRY_X("TOOLTIP_REQUEST", int_value(html::TOOLTIP_REQUEST)),

      CONSTANT_ENTRY_X("ANIMATION", int_value(html::ANIMATION)),
      CONSTANT_ENTRY_X("SWIPE", int_value(html::SWIPE)),

      CONSTANT_ENTRY_X("VIDEO_INITIALIZED", int_value(html::VIDEO_INITIALIZED)),
      CONSTANT_ENTRY_X("VIDEO_STARTED", int_value(html::VIDEO_STARTED)),
      CONSTANT_ENTRY_X("VIDEO_STOPPED", int_value(html::VIDEO_STOPPED)),
      // CONSTANT_ENTRY_X("VIDEO_PLAYING", int_value(html::VIDEO_PLAYING )),

      CONSTANT_ENTRY_X("CUSTOM", int_value(html::CUSTOM)),

      CONSTANT_ENTRY_X("CONTENT_CHANGED", int_value(html::CONTENT_CHANGED)),

      CONSTANT_ENTRY_X("X_DRAG_ENTER", int_value(html::X_DRAG_ENTER)),
      CONSTANT_ENTRY_X("X_DRAG_LEAVE", int_value(html::X_DRAG_LEAVE)),
      CONSTANT_ENTRY_X("X_DRAG", int_value(html::X_DRAG)),
      CONSTANT_ENTRY_X("X_DROP", int_value(html::X_DROP)),
      CONSTANT_ENTRY_X("X_PASTE", int_value(html::X_PASTE)),
      CONSTANT_ENTRY_X("X_DRAG_REQUEST", int_value(html::X_DRAG_REQUEST)),
      CONSTANT_ENTRY_X("X_DRAG_CANCEL", int_value(html::X_DRAG_CANCEL)),
      CONSTANT_ENTRY_X("X_WILL_ACCEPT_DROP", int_value(html::X_WILL_ACCEPT_DROP)),

      CONSTANT_ENTRY_X("GESTURE_REQUEST", int_value(html::GESTURE_REQUEST)),
      CONSTANT_ENTRY_X("GESTURE_ZOOM", int_value(html::GESTURE_ZOOM)),
      CONSTANT_ENTRY_X("GESTURE_PAN", int_value(html::GESTURE_PAN)),
      CONSTANT_ENTRY_X("GESTURE_ROTATE", int_value(html::GESTURE_ROTATE)),
      CONSTANT_ENTRY_X("GESTURE_TAP1", int_value(html::GESTURE_TAP1)),
      CONSTANT_ENTRY_X("GESTURE_TAP2", int_value(html::GESTURE_TAP2)),

      CONSTANT_ENTRY_X("GESTURE_STATE_BEGIN",
                       int_value(html::GESTURE_STATE_BEGIN)),
      CONSTANT_ENTRY_X("GESTURE_STATE_END", int_value(html::GESTURE_STATE_END)),
      CONSTANT_ENTRY_X("GESTURE_STATE_INERTIA",
                       int_value(html::GESTURE_STATE_INERTIA)),

      CONSTANT_ENTRY_X("GESTURE_FLAG_ZOOM", int_value(html::GESTURE_FLAG_ZOOM)),
      CONSTANT_ENTRY_X("GESTURE_FLAG_ROTATE",
                       int_value(html::GESTURE_FLAG_ROTATE)),
      CONSTANT_ENTRY_X("GESTURE_FLAG_PAN_VERTICAL",
                       int_value(html::GESTURE_FLAG_PAN_VERTICAL)),
      CONSTANT_ENTRY_X("GESTURE_FLAG_PAN_HORIZONTAL",
                       int_value(html::GESTURE_FLAG_PAN_HORIZONTAL)),
      CONSTANT_ENTRY_X("GESTURE_FLAG_TAP1", int_value(html::GESTURE_FLAG_TAP1)),
      CONSTANT_ENTRY_X("GESTURE_FLAG_TAP2", int_value(html::GESTURE_FLAG_TAP2)),
      CONSTANT_ENTRY_X("GESTURE_FLAG_PAN_WITH_GUTTER",
                       int_value(html::GESTURE_FLAG_PAN_WITH_GUTTER)),
      CONSTANT_ENTRY_X("GESTURE_FLAG_PAN_WITH_INERTIA",
                       int_value(html::GESTURE_FLAG_PAN_WITH_INERTIA)),
      CONSTANT_ENTRY_X("GESTURE_FLAGS_ALL", int_value(html::GESTURE_FLAGS_ALL)),

      CONSTANT_ENTRY_X("COMMAND_EXEC", int_value(html::event_command::EXEC)),
      CONSTANT_ENTRY_X("COMMAND_QUERY", int_value(html::event_command::CHECK)),

      CONSTANT_ENTRY_X("MOUSE", int_value(html::HANDLE_MOUSE)),
      CONSTANT_ENTRY_X("KEY", int_value(html::HANDLE_KEY)),
      CONSTANT_ENTRY_X("FOCUS", int_value(html::HANDLE_FOCUS)),
      CONSTANT_ENTRY_X("SCROLL", int_value(html::HANDLE_SCROLL)),
      CONSTANT_ENTRY_X("TIMER", int_value(html::HANDLE_TIMER)),
      CONSTANT_ENTRY_X("SIZE", int_value(html::HANDLE_SIZE)),
      CONSTANT_ENTRY_X("DRAW", int_value(html::HANDLE_DRAW)),
      CONSTANT_ENTRY_X("DATA_ARRIVED", int_value(html::HANDLE_DATA_ARRIVED)),
      CONSTANT_ENTRY_X("BEHAVIOR_EVENT",
                       int_value(html::HANDLE_BEHAVIOR_EVENT)),
      CONSTANT_ENTRY_X("METHOD_CALL", int_value(html::HANDLE_METHOD_CALL)),
      CONSTANT_ENTRY_X("COMMAND", int_value(html::HANDLE_COMMAND)),
      CONSTANT_ENTRY_X("EXCHANGE", int_value(html::HANDLE_EXCHANGE)),

      // CONSTANT_ENTRY_X("VK_LBUTTON",     int_value(KB_LBUTTON  )),
      // CONSTANT_ENTRY_X("VK_RBUTTON",     int_value(KB_RBUTTON  )),
      // CONSTANT_ENTRY_X("VK_CANCEL",     int_value(KB_CANCEL  )),
      // CONSTANT_ENTRY_X("VK_MBUTTON",     int_value(KB_MBUTTON  )),
      CONSTANT_ENTRY_X("VK_BACK", int_value(KB_BACK)),
      CONSTANT_ENTRY_X("VK_TAB", int_value(KB_TAB)),
      //CONSTANT_ENTRY_X("VK_CLEAR", int_value(KB_CLEAR)),
      CONSTANT_ENTRY_X("VK_RETURN", int_value(KB_RETURN)),
      CONSTANT_ENTRY_X("VK_ENTER", int_value(KB_RETURN)),
      CONSTANT_ENTRY_X("VK_SHIFT", int_value(KB_SHIFT)),
      CONSTANT_ENTRY_X("VK_CONTROL", int_value(KB_CONTROL)),
      CONSTANT_ENTRY_X("VK_SHORTCUT", int_value(KB_SHORTCUT)),

      CONSTANT_ENTRY_X("VK_MENU", int_value(KB_MENU)),
      // CONSTANT_ENTRY_X("VK_PAUSE",     int_value(KB_PAUSE  )),
      CONSTANT_ENTRY_X("VK_CAPITAL", int_value(KB_CAPITAL)),
      // CONSTANT_ENTRY_X("VK_KANA",       int_value(KB_KANA  )),
      // CONSTANT_ENTRY_X("VK_HANGUL",     int_value(KB_HANGUL  )),
      // CONSTANT_ENTRY_X("VK_JUNJA",     int_value(KB_JUNJA  )),
      // CONSTANT_ENTRY_X("VK_FINAL",     int_value(KB_FINAL  )),
      // CONSTANT_ENTRY_X("VK_HANJA",     int_value(KB_HANJA  )),
      // CONSTANT_ENTRY_X("VK_KANJI",     int_value(KB_KANJI  )),
      CONSTANT_ENTRY_X("VK_ESCAPE", int_value(KB_ESCAPE)),
      // CONSTANT_ENTRY_X("VK_CONVERT",     int_value(KB_CONVERT  )),

      CONSTANT_ENTRY_X("VK_PLUS", int_value(KB_PLUS)), 
      CONSTANT_ENTRY_X("VK_MINUS", int_value(KB_MINUS)),
      CONSTANT_ENTRY_X("VK_RBRACKET", int_value(KB_RIGHTBRACKET)),
      CONSTANT_ENTRY_X("VK_LBRACKET", int_value(KB_LEFTBRACKET)),
      CONSTANT_ENTRY_X("VK_SEMICOLON", int_value(KB_SEMICOLON)),
      CONSTANT_ENTRY_X("VK_BACKSLASH", int_value(KB_BACKSLASH)),
      CONSTANT_ENTRY_X("VK_COMMA", int_value(KB_COMMA)),
      CONSTANT_ENTRY_X("VK_SLASH", int_value(KB_SLASH)),
      CONSTANT_ENTRY_X("VK_QUOTE", int_value(KB_QUOTE)),

      CONSTANT_ENTRY_X("VK_SPACE", int_value(KB_SPACE)),
      CONSTANT_ENTRY_X("VK_PRIOR", int_value(KB_PRIOR)),
      CONSTANT_ENTRY_X("VK_NEXT", int_value(KB_NEXT)),
      CONSTANT_ENTRY_X("VK_END", int_value(KB_END)),
      CONSTANT_ENTRY_X("VK_HOME", int_value(KB_HOME)),
      CONSTANT_ENTRY_X("VK_LEFT", int_value(KB_LEFT)),
      CONSTANT_ENTRY_X("VK_UP", int_value(KB_UP)),
      CONSTANT_ENTRY_X("VK_RIGHT", int_value(KB_RIGHT)),
      CONSTANT_ENTRY_X("VK_DOWN", int_value(KB_DOWN)),
      //CONSTANT_ENTRY_X("VK_SELECT", int_value(KB_SELECT)),
      //CONSTANT_ENTRY_X("VK_PRINT", int_value(KB_PRINT)),
      //CONSTANT_ENTRY_X("VK_EXECUTE", int_value(KB_EXECUTE)),
      //CONSTANT_ENTRY_X("VK_SNAPSHOT", int_value(KB_SNAPSHOT)),
      CONSTANT_ENTRY_X("VK_INSERT", int_value(KB_INSERT)),
      CONSTANT_ENTRY_X("VK_DELETE", int_value(KB_DELETE)),
      //CONSTANT_ENTRY_X("VK_HELP", int_value(KB_HELP)),
      // CONSTANT_ENTRY_X("VK_SLEEP",     int_value(KB_SLEEP  )),
      CONSTANT_ENTRY_X("VK_NUMPAD0", int_value(KB_NUMPAD0)),
      CONSTANT_ENTRY_X("VK_NUMPAD1", int_value(KB_NUMPAD1)),
      CONSTANT_ENTRY_X("VK_NUMPAD2", int_value(KB_NUMPAD2)),
      CONSTANT_ENTRY_X("VK_NUMPAD3", int_value(KB_NUMPAD3)),
      CONSTANT_ENTRY_X("VK_NUMPAD4", int_value(KB_NUMPAD4)),
      CONSTANT_ENTRY_X("VK_NUMPAD5", int_value(KB_NUMPAD5)),
      CONSTANT_ENTRY_X("VK_NUMPAD6", int_value(KB_NUMPAD6)),
      CONSTANT_ENTRY_X("VK_NUMPAD7", int_value(KB_NUMPAD7)),
      CONSTANT_ENTRY_X("VK_NUMPAD8", int_value(KB_NUMPAD8)),
      CONSTANT_ENTRY_X("VK_NUMPAD9", int_value(KB_NUMPAD9)),
      CONSTANT_ENTRY_X("VK_MULTIPLY", int_value(KB_MULTIPLY)),
      CONSTANT_ENTRY_X("VK_ADD", int_value(KB_ADD)),
      CONSTANT_ENTRY_X("VK_SEPARATOR", int_value(KB_SEPARATOR)),
      CONSTANT_ENTRY_X("VK_SUBTRACT", int_value(KB_SUBTRACT)),
      CONSTANT_ENTRY_X("VK_DECIMAL", int_value(KB_DECIMAL)),
      CONSTANT_ENTRY_X("VK_DIVIDE", int_value(KB_DIVIDE)),
      CONSTANT_ENTRY_X("VK_F1", int_value(KB_F1)),
      CONSTANT_ENTRY_X("VK_F2", int_value(KB_F2)),
      CONSTANT_ENTRY_X("VK_F3", int_value(KB_F3)),
      CONSTANT_ENTRY_X("VK_F4", int_value(KB_F4)),
      CONSTANT_ENTRY_X("VK_F5", int_value(KB_F5)),
      CONSTANT_ENTRY_X("VK_F6", int_value(KB_F6)),
      CONSTANT_ENTRY_X("VK_F7", int_value(KB_F7)),
      CONSTANT_ENTRY_X("VK_F8", int_value(KB_F8)),
      CONSTANT_ENTRY_X("VK_F9", int_value(KB_F9)),
      CONSTANT_ENTRY_X("VK_F10", int_value(KB_F10)),
      CONSTANT_ENTRY_X("VK_F11", int_value(KB_F11)),
      CONSTANT_ENTRY_X("VK_F12", int_value(KB_F12)),
      /*CONSTANT_ENTRY_X("VK_F13", int_value(KB_F13)),
      CONSTANT_ENTRY_X("VK_F14", int_value(KB_F14)),
      CONSTANT_ENTRY_X("VK_F15", int_value(KB_F15)),
      CONSTANT_ENTRY_X("VK_F16", int_value(KB_F16)),
      CONSTANT_ENTRY_X("VK_F17", int_value(KB_F17)),
      CONSTANT_ENTRY_X("VK_F18", int_value(KB_F18)),
      CONSTANT_ENTRY_X("VK_F19", int_value(KB_F19)),
      CONSTANT_ENTRY_X("VK_F20", int_value(KB_F20)),
      CONSTANT_ENTRY_X("VK_F21", int_value(KB_F21)),
      CONSTANT_ENTRY_X("VK_F22", int_value(KB_F22)),
      CONSTANT_ENTRY_X("VK_F23", int_value(KB_F23)),
      CONSTANT_ENTRY_X("VK_F24", int_value(KB_F24)),*/

      CONSTANT_ENTRY_X("VK_A", int_value(KB_A)),
      CONSTANT_ENTRY_X("VK_S", int_value(KB_S)),
      CONSTANT_ENTRY_X("VK_D", int_value(KB_D)),
      CONSTANT_ENTRY_X("VK_F", int_value(KB_F)),
      CONSTANT_ENTRY_X("VK_H", int_value(KB_H)),
      CONSTANT_ENTRY_X("VK_G", int_value(KB_G)),
      CONSTANT_ENTRY_X("VK_Z", int_value(KB_Z)),
      CONSTANT_ENTRY_X("VK_X", int_value(KB_X)),
      CONSTANT_ENTRY_X("VK_C", int_value(KB_C)),
      CONSTANT_ENTRY_X("VK_V", int_value(KB_V)),
      CONSTANT_ENTRY_X("VK_B", int_value(KB_B)),
      CONSTANT_ENTRY_X("VK_Q", int_value(KB_Q)),
      CONSTANT_ENTRY_X("VK_W", int_value(KB_W)),
      CONSTANT_ENTRY_X("VK_E", int_value(KB_E)),
      CONSTANT_ENTRY_X("VK_R", int_value(KB_R)),
      CONSTANT_ENTRY_X("VK_Y", int_value(KB_Y)),
      CONSTANT_ENTRY_X("VK_T", int_value(KB_T)),
      CONSTANT_ENTRY_X("VK_1", int_value(KB_1)),
      CONSTANT_ENTRY_X("VK_2", int_value(KB_2)),
      CONSTANT_ENTRY_X("VK_3", int_value(KB_3)),
      CONSTANT_ENTRY_X("VK_4", int_value(KB_4)),
      CONSTANT_ENTRY_X("VK_6", int_value(KB_6)),
      CONSTANT_ENTRY_X("VK_5", int_value(KB_5)),
      CONSTANT_ENTRY_X("VK_9", int_value(KB_9)),
      CONSTANT_ENTRY_X("VK_7", int_value(KB_7)),
      CONSTANT_ENTRY_X("VK_8", int_value(KB_8)),
      CONSTANT_ENTRY_X("VK_0", int_value(KB_0)),
      CONSTANT_ENTRY_X("VK_O", int_value(KB_O)),
      CONSTANT_ENTRY_X("VK_U", int_value(KB_U)),
      CONSTANT_ENTRY_X("VK_I", int_value(KB_I)),
      CONSTANT_ENTRY_X("VK_P", int_value(KB_P)),
      CONSTANT_ENTRY_X("VK_L", int_value(KB_L)),
      CONSTANT_ENTRY_X("VK_J", int_value(KB_J)),
      CONSTANT_ENTRY_X("VK_K", int_value(KB_K)),
      CONSTANT_ENTRY_X("VK_N", int_value(KB_N)),
      CONSTANT_ENTRY_X("VK_M", int_value(KB_M)),

      CONSTANT_ENTRY_X("COMMAND_AVAILABLE",
                       int_value(html::behavior::CMD_AVAILABLE)),
      CONSTANT_ENTRY_X("COMMAND_SELECTED",
                       int_value(html::behavior::CMD_SELECTED)),
      CONSTANT_ENTRY_X("COMMAND_DISABLED",
                       int_value(html::behavior::CMD_DISABLED)),

      CONSTANT_ENTRY_X(0, 0)};

  void destroy_event(xview *c, value obj) { ; }

#define PROP(name, expr)                                                       \
  static value CSF_##name(xvm *c, value obj) {                                 \
    xview *v = static_cast<xview *>(CsCObjectValue(obj));                      \
    if (!v || !v->pevt) return UNDEFINED_VALUE;                                \
    return expr;                                                               \
  }

  PROP(sinking,
       ((v->pevt->cmd & html::EVENT_SINKING) == 0) ? TRUE_VALUE : FALSE_VALUE)
  PROP(buttons, CsMakeInteger(v->pevt->get_mouse_buttons()))
  PROP(keyCode, CsMakeInteger(v->pevt->get_key_code()))

  PROP(ctrlKey, ((v->pevt->get_alt_state() & html::ALT_CONTROL) != 0)
                    ? TRUE_VALUE
                    : FALSE_VALUE)
  PROP(shiftKey, ((v->pevt->get_alt_state() & html::ALT_SHIFT) != 0)
                     ? TRUE_VALUE
                     : FALSE_VALUE)
  PROP(altKey, ((v->pevt->get_alt_state() & html::ALT_ALT) != 0) ? TRUE_VALUE : FALSE_VALUE)
#ifdef USE_TOUCH
  PROP(isTouch, ((v->pevt->get_alt_state() & html::ALT_TOUCH) != 0) ? TRUE_VALUE : FALSE_VALUE)
#endif

  PROP(shortcutKey, ((v->pevt->get_alt_state() & html::ALT_SHORTCUT) != 0)
                        ? TRUE_VALUE
                        : FALSE_VALUE)
  PROP(commandKey, ((v->pevt->get_alt_state() & html::ALT_COMMAND) != 0)
                       ? TRUE_VALUE
                       : FALSE_VALUE)
  PROP(extendedKey, ((v->pevt->get_alt_state() & html::ALT_EXTENDED) != 0)
                        ? TRUE_VALUE
                        : FALSE_VALUE)

  PROP(mainButton, (v->pevt->get_mouse_buttons() & html::MAIN_BUTTON)
                       ? TRUE_VALUE
                       : FALSE_VALUE)
  PROP(propButton, (v->pevt->get_mouse_buttons() & html::PROP_BUTTON)
                       ? TRUE_VALUE
                       : FALSE_VALUE)
  PROP(target,
       (v->pevt->target) ? element_object(c, v->pevt->target) : NULL_VALUE)
  PROP(type, CsMakeInteger(v->pevt->cmd))
  PROP(group, (v->evt_group) ? v->evt_group : UNDEFINED_VALUE)
  PROP(source, (v->pevt->event_source())
                   ? element_object(c, v->pevt->event_source())
                   : NULL_VALUE)
  // PROP(owner      ,(v->pevt->event_source())?
  // element_object(c,v->pevt->event_source()): NULL_VALUE )
  PROP(reason, CsMakeInteger(v->pevt->event_reason()))
  PROP(data, value_to_value(c, v->pevt->event_data()))
  PROP(result, value_to_value(c, v->pevt->event_result()))
  PROP(command, string_to_value(c, v->pevt->event_command_of()))
  PROP(wheelDelta, v->pevt->cmd_no_flags() == html::MOUSE_WHEEL
                       ? CsMakeFloat(v->pevt->get_wheel_delta())
                       : UNDEFINED_VALUE)
  PROP(x, CsMakeInteger(v->pevt->get_pos().x))
  PROP(y, CsMakeInteger(v->pevt->get_pos().y))

  // PROP(xRoot      ,CsMakeInteger(v->pevt->get_pos().x +
  // (v->pevt->target?v->pevt->target->doc_pos(*v).x:0)))  PROP(yRoot
  // ,CsMakeInteger(v->pevt->get_pos().y +
  // (v->pevt->target?v->pevt->target->doc_pos(*v).y:0)))
  PROP(xRoot,
       CsMakeInteger(v->pevt->get_view_pos().x -
                     (v->pevt->target ? v->pevt->target->doc()->view_pos(*v).x
                                      : 0)))
  PROP(yRoot,
       CsMakeInteger(v->pevt->get_view_pos().y -
                     (v->pevt->target ? v->pevt->target->doc()->view_pos(*v).y
                                      : 0)))
  PROP(xView, CsMakeInteger(v->pevt->get_view_pos().x))
  PROP(yView, CsMakeInteger(v->pevt->get_view_pos().y))
  PROP(xScreen,
       CsMakeInteger(v->pevt->get_view_pos().x + v->client_screen_pos().x))
  PROP(yScreen,
       CsMakeInteger(v->pevt->get_view_pos().y + v->client_screen_pos().y))
  PROP(scrollPos, CsMakeInteger(v->pevt->get_scroll_pos()))
  PROP(scrollAxis, v->pevt->event_group() == html::HANDLE_SCROLL
                       ? scrollAxisSym((html::event_scroll *)v->pevt)
                       : UNDEFINED_VALUE)
  PROP(cancel, CsMakeBoolean(v->pevt->is_canceled()))
  PROP(isOnIcon, v->pevt->get_on_icon() ? TRUE_VALUE : FALSE_VALUE)

  static value CSF_dragging(xvm *c, value obj) {
    xview *v = static_cast<xview *>(CsCObjectValue(obj));
    if (!v || !v->pevt) return UNDEFINED_VALUE;
    if (v->pevt->event_group() == html::HANDLE_MOUSE) {
      html::event_mouse *pevb = (html::event_mouse *)v->pevt;
      return (pevb->dragging) ? element_object(c, pevb->dragging) : NULL_VALUE;
    } else if (v->pevt->event_group() == html::HANDLE_EXCHANGE) {
      html::event_exchange *pevb = (html::event_exchange *)v->pevt;
      //return (pevb->data) ? clipboard_data_value(c, pevb->data) : NULL_VALUE;
      return value_to_value(c, pevb->data_value());
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_wheelDeltas(xvm *c, value obj) {
    xview *v = static_cast<xview *>(CsCObjectValue(obj));
    if (!v || !v->pevt) return UNDEFINED_VALUE;
    if (v->pevt->event_group() == html::HANDLE_MOUSE && v->pevt->cmd_no_flags() == html::MOUSE_WHEEL) {
      html::event_mouse *pevb = (html::event_mouse *)v->pevt;
      sizef dd = pevb->wheel_delta_xy();
      CS_RETURN2(c, CsMakeFloat(dd.x), CsMakeFloat(dd.y));
    }
    return UNDEFINED_VALUE;
  }

  static value CSF_device(xvm *c, value obj) {
    xview *v = static_cast<xview *>(CsCObjectValue(obj));
    if (!v || !v->pevt) return UNDEFINED_VALUE;

    switch (v->pevt->get_event_source()) {
      case html::ES_KEYBOARD: return CsSymbolOf(CHARS("keyboard"));
      case html::ES_MOUSE: return CsSymbolOf(CHARS("mouse"));
      case html::ES_TOUCH: return CsSymbolOf(CHARS("touch"));
      case html::ES_PEN: return CsSymbolOf(CHARS("pen"));
      case html::ES_TOUCHPAD: return CsSymbolOf(CHARS("touchpad"));
    };

    return UNDEFINED_VALUE;
  }


//  PROP(draggingMode,
//       v->pevt->event_group() == html::HANDLE_MOUSE
//           ? CsMakeInteger(((html::event_mouse *)v->pevt)->dragging_mode)
//           : UNDEFINED_VALUE)

    static value CSF_draggingMode(xvm *c, value obj) 
    {
      xview *v = static_cast<xview *>(CsCObjectValue(obj));
      if (!v || !v->pevt) return UNDEFINED_VALUE;

      uint dd_mode = 0;
      if (v->pevt->get_dragging_mode(dd_mode))
        return CsMakeInteger(dd_mode);
      return UNDEFINED_VALUE;
    }


  static value CSF_draggingDataType(xvm *c, value obj) {
    xview *v = static_cast<xview *>(CsCObjectValue(obj));
    if (!v || !v->pevt) return UNDEFINED_VALUE;

    if (v->pevt->event_group() == html::HANDLE_EXCHANGE) {
      html::event_exchange *pevb = (html::event_exchange *)v->pevt;
      return (pevb->data && pevb->data->get_default())
                 ? clipboard_format_sym(pevb->data->get_default()->data_type)
                 : NULL_VALUE;
    }
    return UNDEFINED_VALUE;
  }

  PROP(deltaX, v->pevt->event_group() == html::HANDLE_GESTURE
                   ? CsMakeInteger(((html::event_gesture *)v->pevt)->delta_xy.x)
                   : UNDEFINED_VALUE)
  PROP(deltaY, v->pevt->event_group() == html::HANDLE_GESTURE
                   ? CsMakeInteger(((html::event_gesture *)v->pevt)->delta_xy.y)
                   : UNDEFINED_VALUE)
  PROP(deltaV, v->pevt->event_group() == html::HANDLE_GESTURE
                   ? CsMakeFloat(((html::event_gesture *)v->pevt)->delta_v)
                   : UNDEFINED_VALUE)

  static void CSF_set_source(xvm *c, value obj, value val) {
    xview *v = static_cast<xview *>(CsCObjectValue(obj));
    if (!v || !v->pevt) return;

    if (val == NULL_VALUE) {
      v->pevt->event_source(0);
      return;
    }
    html::element *pb = element_ptr(c, val);
    if (pb)
      v->pevt->event_source(pb);
    else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, val,
                        "only Element or null");
  }

  static void CSF_set_reason(xvm *c, value obj, value val) {
    xview *v = static_cast<xview *>(CsCObjectValue(obj));
    if (!v || !v->pevt) return;
    if (CsIntegerP(val))
      v->pevt->event_reason(CsIntegerValue(val));
    else
      CsThrowKnownError(c, CsErrUnexpectedTypeError, val, "integer");
  }

  static void CSF_set_data(xvm *c, value obj, value val) {
    xview *v = static_cast<xview *>(CsCObjectValue(obj));
    if (!v || !v->pevt) return;
    v->pevt->event_data(value_to_value(c, val));
  }

  static void CSF_set_result(xvm *c, value obj, value val) {
    xview *v = static_cast<xview *>(CsCObjectValue(obj));
    if (!v || !v->pevt) return;
    v->pevt->event_result(value_to_value(c, val));
  }

  static void CSF_set_keyCode(xvm *c, value obj, value val) {
    xview *v = static_cast<xview *>(CsCObjectValue(obj));
    if (!v || !v->pevt) return;
    if (v->pevt->event_group() == html::HANDLE_KEY) {
      html::event_key *pevb = (html::event_key *)v->pevt;
      if (CsIntegerP(val))
        pevb->key_code = CsIntegerValue(val);
      else if (CsStringP(val) && CsStringSize(val))
        pevb->key_code = CsStringAddress(val)[0];
      else
        CsThrowKnownError(c, CsErrUnexpectedTypeError, val,
                          "only Integer or String(1)");
    }
  }

  static void CSF_set_cursor(xvm *c, value obj, value val) {
    xview *v = static_cast<xview *>(CsCObjectValue(obj));
    if (!v || !v->pevt) return;
    if (v->pevt->event_group() == html::HANDLE_MOUSE) {
      html::event_mouse *pevb = (html::event_mouse *)v->pevt;
      if (CsStringP(val) || CsSymbolP(val)) {
        ustring              sval = value_to_string(val);
        tool::value          vval = tool::value(sval);
        handle<html::cursor> ct;
        if (cursor_value(html::element_context(v->doc()), ct, tool::slice<tool::value>(vval)) && ct.is_defined())
          pevb->cursor = ct;
      } else
        CsThrowKnownError(c, CsErrUnexpectedTypeError, val,
                          "String, cursor name");
    }
  }

  static value CSF_cursor(xvm *c, value obj, value val) {
/*    xview *v = static_cast<xview *>(CsCObjectValue(obj));
    if (!v || !v->pevt) return;
    if (v->pevt->event_group() == html::HANDLE_MOUSE) {
      html::event_mouse *pevb = (html::event_mouse *)v->pevt;
      if (CsStringP(val) || CsSymbolP(val)) {
        ustring              sval = value_to_string(val);
        tool::value          vval = tool::value(sval);
        handle<html::cursor> ct;
        if (cursor_value(v->doc(), ct, tool::slice<tool::value>(vval)) && ct.is_defined())
          pevb->cursor = ct;
      }
      else
        CsThrowKnownError(c, CsErrUnexpectedTypeError, val,
          "String, cursor name");
    }*/
    return UNDEFINED_VALUE;
  }


  static void CSF_set_cancel(xvm *c, value obj, value val) {
    xview *v = static_cast<xview *>(CsCObjectValue(obj));
    if (!v || !v->pevt) return;
    v->pevt->cancel_event(CsToBoolean(c, val) == TRUE_VALUE);
  }

  static void CSF_set_dragging(xvm *c, value obj, value val) {
    xview *v = static_cast<xview *>(CsCObjectValue(obj));
    if (!v || !v->pevt) return;

    if (v->pevt->event_group() == html::HANDLE_MOUSE) {
      html::event_mouse *pevb = (html::event_mouse *)v->pevt;
      html::element *    pb   = element_ptr(c, val);
      if (pb) pevb->dragging = pb;
    }
  }

  static void CSF_set_draggingMode(xvm *c, value obj, value val) {
    xview *v = static_cast<xview *>(CsCObjectValue(obj));
    if (!v || !v->pevt) return;
    if (CsIntegerP(val))
      v->pevt->set_dragging_mode((uint)CsIntegerValue(val));
  }

  /* properties */
  static vp_method properties[] = {
      VP_METHOD_ENTRY_X("sinking", CSF_sinking, 0),
      VP_METHOD_ENTRY_X("buttons", CSF_buttons, 0),
      VP_METHOD_ENTRY_X("keyCode", CSF_keyCode, CSF_set_keyCode),
      VP_METHOD_ENTRY_X("ctrlKey", CSF_ctrlKey, 0),
      VP_METHOD_ENTRY_X("shiftKey", CSF_shiftKey, 0),
      VP_METHOD_ENTRY_X("altKey", CSF_altKey, 0),
#ifdef USE_TOUCH
      VP_METHOD_ENTRY_X("isTouch", CSF_isTouch, 0),
#endif
      VP_METHOD_ENTRY_X("shortcutKey", CSF_shortcutKey, 0),
      VP_METHOD_ENTRY_X("commandKey", CSF_commandKey, 0),
      VP_METHOD_ENTRY_X("extendedKey", CSF_extendedKey, 0),

      VP_METHOD_ENTRY_X("mainButton", CSF_mainButton, 0),
      VP_METHOD_ENTRY_X("propButton", CSF_propButton, 0),
      VP_METHOD_ENTRY_X("target", CSF_target, 0),
      VP_METHOD_ENTRY_X("type", CSF_type, 0),
      VP_METHOD_ENTRY_X("group", CSF_group, 0),
      VP_METHOD_ENTRY_X("source", CSF_source, CSF_set_source),
      VP_METHOD_ENTRY_X("owner", CSF_source, CSF_set_source),
      VP_METHOD_ENTRY_X("reason", CSF_reason, CSF_set_reason),
      VP_METHOD_ENTRY_X("flags", CSF_reason, CSF_set_reason),
      VP_METHOD_ENTRY_X("data", CSF_data, CSF_set_data),
      VP_METHOD_ENTRY_X("wheelDelta", CSF_wheelDelta, 0),
      VP_METHOD_ENTRY_X("wheelDeltas", CSF_wheelDeltas, 0),
      VP_METHOD_ENTRY_X("x", CSF_x, 0),
      VP_METHOD_ENTRY_X("y", CSF_y, 0),
      VP_METHOD_ENTRY_X("xRoot", CSF_xRoot, 0),
      VP_METHOD_ENTRY_X("yRoot", CSF_yRoot, 0),
      VP_METHOD_ENTRY_X("xView", CSF_xView, 0),
      VP_METHOD_ENTRY_X("yView", CSF_yView, 0),
      VP_METHOD_ENTRY_X("xScreen", CSF_xScreen, 0),
      VP_METHOD_ENTRY_X("yScreen", CSF_yScreen, 0),
      VP_METHOD_ENTRY_X("scrollPos", CSF_scrollPos, 0),
      VP_METHOD_ENTRY_X("cancel", CSF_cancel, CSF_set_cancel),
      VP_METHOD_ENTRY_X("isOnIcon", CSF_isOnIcon, 0),
      VP_METHOD_ENTRY_X("dragging", CSF_dragging, CSF_set_dragging),
      VP_METHOD_ENTRY_X("draggingMode", CSF_draggingMode, CSF_set_draggingMode),
      VP_METHOD_ENTRY_X("draggingDataType", CSF_draggingDataType, 0),
      VP_METHOD_ENTRY_X("deltaX", CSF_deltaX, 0),
      VP_METHOD_ENTRY_X("deltaY", CSF_deltaY, 0),
      VP_METHOD_ENTRY_X("deltaV", CSF_deltaV, 0),
      VP_METHOD_ENTRY_X("scrollAxis", CSF_scrollAxis, 0),
      VP_METHOD_ENTRY_X("result", CSF_result, CSF_set_result),
      VP_METHOD_ENTRY_X("command", CSF_command, 0),
      VP_METHOD_ENTRY_X("cursor", CSF_cursor, CSF_set_cursor),
      VP_METHOD_ENTRY_X("device", CSF_device, 0),

      VP_METHOD_ENTRY_X(0, 0, 0)};

  static bool EventPrint(xvm *c, value val, stream *s) {
    s->put_str("[event:");

    xview *v = static_cast<xview *>(CsCObjectValue(val));

    if (v && v->pevt)
      CsPrint(c, v->evt_group, s);
    else
      s->put_str("unknown");
    s->put(']');
    return true;
  }

  void xvm::init_event_class() {

    dispatch *pd = CsEnterCPtrObjectType(CsGlobalScope(this), "Event",methods, properties, constants);

    /* create the 'Event' type */
    if (!pd) CsInsufficientMemory(this);

    pd->print = (print_t)EventPrint;

    pd->destroy = (destructor_t)destroy_event;

    eventDispatch = pd;
  }


} // namespace tis
