#ifndef __win_views_h__
#define __win_views_h__

#include "tool/tool.h"

#if defined(WINDOWLESS)
  #error "shall not be included"
#endif 

#include "sdk-headers.h"
#include "win-application.h"
#include "gool/gool.h"
#include "html/html.h"
#include "html/html-behaviors.h"
#include "d2d/d2d-graphics.h"
#if defined(SCITER)
  #include "xdom/xview.h"
#elif defined(SCITERJS)
  #include "xdomjs/xview.h"
#endif

#include "win-ime.h"
#if defined(SYSTEM_DD_SUPPORT)
#include "win-dd-target.h"
#endif
#include "win-registry.h"

// extern tool::bytes get_resource( const wchar* res_id, const wchar*
// res_type_id);

//#define OBJID_FOCUS_ELEMENT 1

namespace mswin {
  using namespace tool;
  using namespace gool;
  using namespace html;

//#define MOUSE_TICK_TIMER_ID_0 0xFFFFFFAF
//#define MOUSE_TICK_TIMER_ID_1 0xFFFFFFAE
//#define MOUSE_LEAVE_TIMER_ID 0xFFFFFFAD
//#define MOUSE_HOVER_TIMER_ID 0xFFFFFFAB
#define IDLE_TIMER_ID 0xFFFFFFAC
#define ANIMATION_FRAME_TIMER_ID 0xFFFFFFAA
#define FRAME_CLASS_NAME TEXT("H-SMILE-FRAME")
#define DIALOG_CLASS_NAME TEXT("H-SMILE-DIALOG")
#define CHILD_CLASS_NAME TEXT("H-SMILE-CHILD")
#define POPUP_CLASS_NAME TEXT("H-SMILE-POPUP")
#define POPUP_CLASS_NAME_TRANSPARENT TEXT("H-SMILE-POPUP-TRANSPARENT")

  extern uint WM_GETWINDOWBLOCK;
  //extern uint WM_UPDATELAYERED;
  extern uint WM_TRAY_CALLBACK;
  //extern uint WM_POSTED_CALLBACK;

  //#ifdef USE_D2D
  //  typedef d2d::graphics graphics;
  //#else
  //  typedef gdi::graphics graphics;
  //#endif

  class popup;
  class window;

  struct window_controls : public behavior::window_frame_ctl {
    LONG original_style;
    LONG original_style_ex;
    bool original_is_layered;

    FRAME_TYPE ftype;

    window_controls() : original_style(), original_style_ex(), original_is_layered(), ftype() {}

    void setup(window *pw, FRAME_TYPE on);
    void reset(window *pw);
  };

#ifdef USE_TOUCH
  bool EnableTouchpadInput(HWND hwnd);
#endif

  class window
#if defined(SCITER)
    : public tis::xview
#elif defined(SCITERJS)
    : public qjs::xview
#else
    : public html::view
#endif
#if defined(SYSTEM_DD_SUPPORT)
      ,
        public drop_target<window>
#endif
  {
  public:
#if defined(SCITER)
    typedef tis::xview view_type;
    typedef tis::xview super;
#elif defined(SCITERJS)
    typedef qjs::xview view_type;
    typedef qjs::xview super;
#else
    typedef html::view view_type;
    typedef html::view super;
#endif

    window(const window_params& params) : super(params),
          _is_painting(false), 
          _scrollbar_handling(false), _window_state(SW_HIDE),
          _animation_timer(0),
          _is_child(),
          _non_client_mouse(false) {}

    virtual ~window() {
      assert(get_hwnd() == 0);
      app = nullptr;
    }

    static bool init(bool start);

    // iwindow
    virtual graphics *surface() = 0;
    //virtual HWND      get_hwnd() const { return get_hwnd(); }
    virtual point     screen_pos();
    virtual point     client_screen_pos();
    virtual point     cursor_pos();
    virtual size      window_dim();
    virtual size      client_dim();
    virtual void      refresh();
    virtual void      refresh(const rect &area);
    virtual void      update();

    virtual bool is_at_position(point screen_pos) override;

    // virtual bool  set_frameless_ctl(window_controls* pctrls) override;
    // virtual window_controls* get_frameless_ctl() override;

    virtual void     attached(HWINDOW hw) override;
    virtual void     detached(HWINDOW hw) override;

    virtual bool       set_frame_type(FRAME_TYPE on) override;
    virtual FRAME_TYPE get_frame_type() const override;
    virtual bool       extend_window_frame(FRAME_TYPE ftype, FRAME_TYPE pftype);

    virtual bool        set_resizeable(bool on) override;
    virtual bool        get_resizeable() const override;
    virtual bool        set_minimizable(bool on) override;
    virtual bool        get_minimizable() override;
    virtual bool        set_maximizable(bool on) override;
    virtual bool        get_maximizable() override;
    //virtual bool        set_blurbehind(BLUR_BEHIND on) override;
    //virtual BLUR_BEHIND get_blurbehind() const override { return super::get_blurbehind(); }
    //virtual void set_enabled(bool on_off) override;
    //virtual bool is_enabled() const override;

    virtual bool         set_icon(gool::image *pimg) override;
    virtual gool::image *get_icon() const override;

    virtual bool         activate(bool and_bring_to_front) override
    {
      if (and_bring_to_front)
        ::SetForegroundWindow(get_hwnd());
      else
        ::SetActiveWindow(get_hwnd());
      return true;
    }

    void notify_win_event(UINT code, const element* pel) {
      NotifyWinEvent(code, get_hwnd(), OBJID_CLIENT, pel->uid);
    }
    

    // virtual void on_root_doc_parsed(document* d);

    // events

    // this object got HWND to it, get_hwnd() field is valid, ctor
    virtual void start(const window_params& params) override {
#if defined(SYSTEM_DD_SUPPORT)
      activate_drop_target(true);
#endif
#ifdef USE_TOUCH
      EnableTouchpadInput(get_hwnd());
#endif
      //EnableMouseInPointer(true); // does not help at all to handle touch pad :(
      super::start(params);
    } 
    
    virtual void stop() override {
#if defined(SYSTEM_DD_SUPPORT)
      activate_drop_target(false);
#endif
      super::stop();
      stop_request_idle();
      if (trayicon_is_set)
        trayicon_remove();
    } // this object is about to loose HWND, dtor

    OBSOLETE virtual size screen_dim();

    virtual void on_size(size sz) override;
    virtual bool on_size_request(int side_id, rect &rc) override {
      return super::on_size_request(side_id, rc);
    }
    virtual float_v aspect_ratio() const override { return dim_ratio; }
    virtual void    aspect_ratio(float_v v) override { dim_ratio = v; }
    virtual bool    get_min_size(gool::size &sz) override {
      if (dim_min.x.is_undefined()) return false;
      sz = dim_min;
      return true;
    }
    virtual bool get_max_size(gool::size &sz) override {
      if (dim_max.x.is_undefined()) return false;
      sz = dim_max;
      return true;
    }
    virtual bool set_min_size(gool::size sz = gool::size()) override {
      if (sz.x && sz.y)
        dim_min = sz;
      else
        dim_min.x.clear();
      return true;
    }
    virtual bool set_max_size(gool::size sz = gool::size()) override {
      if (sz.x && sz.y)
        dim_max = sz;
      else
        dim_max.x.clear();
      return true;
    }

    // virtual void on_paint( HDC hdc, rect paint_rc ) = 0;
    virtual bool render(void *hdc, rect client_rc) = 0;
    virtual bool print(void *hdc, rect paint_rc) {
      return render(hdc, paint_rc);
    }
    virtual bool render_on(graphics *gfx, rect paint_rc = rect()) = 0;
    virtual bool render_element(element *p, bool front_layer) { return false; }
    virtual bool render_element_on(element *p, graphics *gfx) { return false; }

    virtual void do_paint() {
      PAINTSTRUCT ps;
      HDC         hdc = BeginPaint(get_hwnd(), &ps);
      // FillRect(hdc,&ps.rcPaint,GetSysColorBrush(COLOR_WINDOW));
      if (!dismissing && !is_painting) {
        if (GetWindowLong(get_hwnd(), GWL_EXSTYLE) & WS_EX_LAYOUTRTL)
          SetLayout(hdc, 0);
        //dbg_printf("WM_PAINT %d %d %d %d\n", ps.rcPaint.left, ps.rcPaint.top, ps.rcPaint.right - ps.rcPaint.left, ps.rcPaint.bottom - ps.rcPaint.top);
        draw(hdc, ps.rcPaint);
      }
      EndPaint(get_hwnd(), &ps);
#ifdef _DEBUG
      // dbg_printf("paint:%d,%d,%d,%d\n", ps.rcPaint.left, ps.rcPaint.top,
      // ps.rcPaint.right, ps.rcPaint.bottom);
#endif
    }

    //virtual bool render_layered(void *dc, rect client_rc) override {
    //  bool r = super::render_layered(dc,client_rc);
    //  return r;
    //}

    virtual bool do_set_focus(
        helement b, FOCUS_CAUSE cause,
        bool postfactum = false /* true -shall not try to set focus on HWND*/) {
      if (is_enabled() && is_on_screen() && !postfactum && b && ::GetForegroundWindow() != get_hwnd()) {
        //::SetFocus(get_hwnd());
        ::SetForegroundWindow(get_hwnd());
      }
      return super::do_set_focus(b, cause, postfactum);
    }

    virtual bool is_active() const;

    virtual void on_dpi_changed(size dpi, rect proposed_window_rect) override;

    virtual size pixels_per_inch() override;

    static LRESULT CALLBACK proc(HWND hWnd, UINT message, WPARAM wParam,
                                 LPARAM lParam,
                                 BOOL & handled); // no DefWindowProc call

    static BOOL CALLBACK proc_x(HWND          hWnd,
                                SCITER_X_MSG *pMsg); // no DefWindowProc call

    static LRESULT CALLBACK window_proc(HWND hWnd, UINT message, WPARAM wParam,
                                        LPARAM lParam);

    static VOID CALLBACK timer_proc(HWND     hwnd,    // handle to window
                                    UINT     uMsg,    // WM_TIMER message
                                    UINT_PTR idEvent, // timer identifier
                                    DWORD    dwTime);    // current system time

    // static void CALLBACK animator_timer_proc(
    //    UINT uID,
    //    UINT uMsg,
    //    DWORD_PTR dwUser,
    //    DWORD_PTR dw1,
    //    DWORD_PTR dw2);

    //static VOID CALLBACK animator_timer_proc(PVOID pvwind, BOOLEAN d);

    bool mouse_move(WPARAM wParam, LPARAM lParam);
    bool mouse_down(uint btn, WPARAM wParam, LPARAM lParam);
    bool mouse_up(uint btn, WPARAM wParam, LPARAM lParam);
    bool mouse_dblclick(uint btn, WPARAM wParam, LPARAM lParam);
    bool mouse_wheel(WPARAM wParam, LPARAM lParam, bool vertical);
    //struct touch_point { uint  id; point pos; };
    //bool mouse_touch(slice<touch_point> touch_points);

    bool handle_scroll(bool vertical, WPARAM wParam, LPARAM lParam);

    bool timer_tick(WPARAM wParam, LPARAM lParam);

    virtual element *
    element_under_cursor(/* out, view related */ gool::point &cursor_pos);

    element *window_element(HWND other_hwnd);

    // virtual void  update(element *b);
    UINT_PTR idle_timer_id = 0;
    virtual void do_request_idle();
            void stop_request_idle();
    virtual void set_timer(uint_ptr id, uint ms, uint_ptr &sys_id);

    virtual void    set_cursor(cursor *pcur) override;
    virtual cursor *get_cursor() override;
    // virtual void    cursor_data_arrived(handle<pump::request> rq);

    virtual bool  set_h_scrollbar(range content_h, bool noremove, size &sz);
    virtual bool  set_v_scrollbar(range content_v, bool noremove, size &sz);
    virtual void  set_scroll_pos(point pos);
    virtual point get_scroll_pos();
    virtual bool  has_h_scrollbar(bool &yes);
    virtual bool  has_v_scrollbar(bool &yes);

    virtual bool           ask_close_window(bool by_chrome = false);
    virtual bool           close_window();
    virtual bool           show_modal();
    virtual array<ustring> ask_file_name(AFN_MODE mode, const ustring &caption,
                                         const ustring &filename,
                                         const wchar *  def_ext,
                                         const wchar *  filter) override;
    virtual bool ask_folder_name(const ustring &caption, ustring &foldername);

    virtual void         replace_windowed() override;
    virtual rect         window_decoration() const override;
    virtual void         move_window(const rect &spos, bool client_rc = false) override;
    virtual WINDOW_STATE get_window_state() const;
    virtual bool         set_window_state(WINDOW_STATE ws);
    virtual ustring      get_window_title() const;
    virtual bool         set_window_title(const wchar *title);
    virtual bool         show();

    //virtual handle<gool::bitmap> get_backbuffer();

    virtual bool do_event(DO_EVENT_MANNER m, bool &result);

    virtual bool add_animation(element *b, animation *pba,
                               const style *new_style, const style *old_style);

    virtual void set_capture(element *b);

    bool is_on_screen() {
      auto ws = get_window_state();
      switch (ws) {
        case WINDOW_HIDDEN:
        case WINDOW_MINIMIZED: return false;
        default: return true;
      }
    }

    virtual bool set_focus(helement b, FOCUS_CAUSE cause, bool postfactum) override {
#ifdef _DEBUG
      if (get_window_state() == WINDOW_HIDDEN)
        cause = cause;
#endif 

      if (b && (::GetFocus() != get_hwnd()) && is_on_screen())
        ::SetFocus(get_hwnd());
      return super::set_focus(b, cause, postfactum);
    }

    static LRESULT CALLBACK hook_proc(int code, WPARAM wParam, LPARAM lParam);
    static void             setup_hook();
    static void             release_hook();

    virtual iwindow *
    create_window(element *forel, element *anchor, WINDOW_TYPE wt,
                  function<rect(view &, element *, element *)> place,
                  ELEMENT_WINDOW_MODE mode = ELEMENT_WINDOW_AUTO) override;
    // virtual  bool     show_popup( element* el, element* anchor, WINDOW_TYPE
    // wt, uint placement, point vp_at = point() );
    virtual bool close_popup(element *b, bool set_auto_focus);

    virtual void init_media_vars();

    virtual void enable_ime(bool on) override;

    virtual bool activate_keyboard_for(element *b, uint type) override;

    virtual void handle_got_focus(HWND hwnd_from);
    virtual void handle_lost_focus(HWND hwnd_to);

#ifdef ACCESSIBLE
    virtual LRESULT handle_get_object(WPARAM wParam, LPARAM lParam, BOOL& handled);
#endif

    //virtual bool on_element_event(element *b, event_behavior &evt);

    virtual bool send_behavior_event(event_behavior &evt) override;
    virtual void on_focus_changed(element *b, bool got) override;
    virtual void on_current_changed(element *b) override;

    virtual bool request_animation_frame(uint delay = 0) override;
    virtual void stop_animation_frames();

    virtual popup *create_popup() = 0;
    void           handle_state_changed();
    virtual void   handle_position_change() {}
    
    virtual bool do_drag(clipboard::data *pd,
                         uint &ddm /*in out, DD_MODE flags*/, element *src,
                         gool::bitmap *drag_image, point offset) {

      auto_state<bool> _(is_dragging, true);

#if defined(SYSTEM_DD_SUPPORT)
      return perform_drag(pd, ddm, src, drag_image, offset);
#else
      return false;
#endif
    }
    virtual void create_drag_cursors(gool::bitmap *drag_image, point &offset,
                                     handle<gool::bitmap> &move,
                                     handle<gool::bitmap> &copy,
                                     handle<gool::bitmap> &none) override;

    virtual int get_system_metrics(int m); // GetSysteMetrics but DPI aware
    
    virtual int get_window_metrics(tool::value::length_special_values what) override;


    tristate_v   trayicon_is_set;
    HICON        trayicon_icon = nullptr;
    virtual bool trayicon_setup(const tray_icon_params& params) override;
    virtual bool trayicon_remove() override;
         LRESULT trayicon_message(WPARAM wp, LPARAM lp, BOOL& handled);
    virtual bool trayicon_place(rect& rc) override;

    virtual bool request_attention(WRA_MODE wm) override;

  protected:
    static bool translate_message(MSG &msg);

    virtual LRESULT on_nchittest(WPARAM wParam, LPARAM lParam, BOOL &handled);
    virtual LRESULT on_nccalcsize(WPARAM wParam, LPARAM lParam, BOOL &handled) {
      if (!wParam)
        return 0;
      if (get_frame_type() == STANDARD_EXTENDED) 
        handled = TRUE;
      //RECT* prc = (RECT*)lParam;
      //on_size(((rect*)prc)->size());
      return 0;
    }

  protected:
    bool  _is_painting;
    point _last_known_point;
    bool  _scrollbar_handling; // true if inside scrollbar handling
    uint  _window_state;
    tristate_v
               _collapsing; // true if window is shown but is about to be minimized
    tristate_v _full_screen; // true if window is maximized to full screen
    bool       _is_child;    // true if the window is child window (WS_CHILD)
    handle<gool::bitmap> _background_bitmap; // used when _is_child is true,
                                             // contains image rendered by
                                             // parent window.

    handle<window_controls>
         _window_controls;  // window controls, for WM_NCHITTEST handling.
    bool _non_client_mouse; // true is mouse is on NC area

    handle<cursor> _cursor; // current cursor

    dim_v_t dim_min;
    dim_v_t dim_max;
    float_v dim_ratio;

    ImeInput ime_ctx;
    bool     ime_notification;
public:
    UINT_PTR        _animation_timer;
    // bool              _pending_animation_request;
    // tristate_v        _pending_animation_frame_request;
    tristate_v _need_OleUninitialize;
    tristate_v _is_iaccessible_active;
#ifdef USE_UIAUTOMATION
    tristate_v _is_uiautomation_active;
    static bool use_uiautomation;
#endif
  };


  // extern window* create_window_instance(window* parent, bool is_rtl);

  class popup : public html::popup {
    typedef html::popup super;
    friend class window;

  protected:
    popup() {}
    virtual ~popup();

  public:
    // iwindow stuff:
    virtual graphics *surface() = 0;

    virtual void refresh() { refresh(rect(client_dim())); }
    virtual void refresh(const rect &area);
    virtual void update();
    virtual void dismiss();

    static bool translate_event(window *pw, MSG &msg);

    static void    init(bool start);
    static LRESULT CALLBACK proc(HWND hWnd, UINT message, WPARAM wParam,
                                 LPARAM lParam);
    static popup *          ptr(HWND hwnd);
    virtual void            destroy();

    virtual void do_paint() {
      PAINTSTRUCT ps;
      HDC         hdc = BeginPaint(get_hwnd(), &ps);
      if (GetWindowLong(get_hwnd(), GWL_EXSTYLE) & WS_EX_LAYOUTRTL)
        SetLayout(hdc, 0);
      draw(hdc, fromRECT(ps.rcPaint));
      EndPaint(get_hwnd(), &ps);
    } // WM_PAINT handler

    virtual bool print(void *hdc, rect rc) { return render(hdc, rc); }

    // virtual void paint(HDC hdc, rect rc) = 0;
    // virtual bool render() = 0;
    // virtual void render_layered() = 0;
    // virtual void render(HDC hdc, rect rc ) = 0; // WM_PRINTCLIENT handler
  };

} // namespace mswin

#endif