//|
//|
//| Copyright (c) 2001-2010
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//| UXTHEME support
//|

#include "win.h"

#ifdef THEMES_SUPPORT

#include <uxtheme.h>
#include "win-ux-themes.h"

#include "win-theme-XP.h"
#include "win-theme-95.h"

#include "gool/gool-part-names-ph.h"

namespace gool {

  handle<theme_image_95> images[TOTAL_KEYWORDS];

  bool is_transparent(const theme_image_95 *pimg) {
    const part_def &pd = theme_part_defs[pimg->image_id - 1];
    if (pd.nClass == THEME_GROUP_EDIT) return false;
    if (pd.nClass == THEME_GROUP_SCROLLBAR) return false;
    if (pd.nClass == THEME_GROUP_TABS && pd.nPart == TABP_PANE) return false;
    if (pd.nClass == THEME_GROUP_BUTTON && pd.nPart == BP_PUSHBUTTON)
      return false;
    return true;
  }

  void draw_rect(graphics *pg, rect rc, gool::color_v tl, gool::color_v br,
                 color_v back = color_v()) {
    //--rc.e;
    rect l     = rc;
    l.e.x = l.s.x;
    rect r     = rc;
    r.s.x = r.e.x;
    rect t     = rc;
    t.e.y = t.s.y;
    rect b     = rc;
    b.s.y = b.e.y;
    argb c1    = tl.to_argb();
    pg->fill(c1, l);
    pg->fill(c1, t);
    argb c2 = br.to_argb();
    pg->fill(c2, r);
    pg->fill(c2, b);
    if (back.is_defined()) {
      rc <<= 1;
      argb c3 = back.to_argb();
      pg->fill(c3, rc);
    }
  }

  void draw_rect_tb(graphics *pg, rect rc, gool::color_v tl, gool::color_v br,
                    color_v back = color_v()) {
    // size sz = rc.size();
    rect l     = rc;
    l.e.x = l.s.x;
    rect r     = rc;
    r.s.x = r.e.x;
    rect t     = rc;
    t.e.y = t.s.y;
    rect b     = rc;
    b.s.y = b.e.y;
    argb c1    = tl.to_argb();
    pg->fill(c1, l);
    pg->fill(c1, t);
    argb c2 = br.to_argb();
    pg->fill(c2, r);
    pg->fill(c2, b);
    if (back.is_defined()) {
      rc <<= 1;
      argb c3 = back.to_argb();
      c3.alfa = 128;
      pg->fill(c3, rc);
    }
  }

  void fill_rect(graphics *pg, rect rc, color_v back) {
    //--rc.e;
    argb c3 = back.to_argb();
    pg->fill(c3, rc);
  }

  void draw_sunken_frame(graphics *pg, rect rc, gool::color_v back) {
    draw_rect(pg, rc, SC_DIALOG_SHADOW, SC_DIALOG_BRIGHT, NO_COLOR);
    rc <<= 1;
    draw_rect(pg, rc, SC_DIALOG_DKSHADOW, SC_DIALOG_LIGHT, back);
  }
  void draw_raised_frame(graphics *pg, rect rc, gool::color_v back) {
    draw_rect(pg, rc, SC_DIALOG_BRIGHT, SC_DIALOG_DKSHADOW, NO_COLOR);
    rc <<= 1;
    draw_rect(pg, rc, SC_DIALOG_LIGHT, SC_DIALOG_SHADOW, back);
  }

  void draw_sunken_tb_frame(graphics *pg, rect rc, gool::color_v back) {
    draw_rect_tb(pg, rc, SC_DIALOG_LIGHT, SC_DIALOG_BRIGHT, back);
  }
  void draw_raised_tb_frame(graphics *pg, rect rc, gool::color_v back) {
    draw_rect_tb(pg, rc, SC_DIALOG_LIGHT, SC_DIALOG_SHADOW, back);
  }

  void draw_flat_frame(graphics *pg, rect rc, gool::color_v back) {
    draw_rect(pg, rc, SC_DIALOG_SHADOW, SC_DIALOG_SHADOW, back);
  }

  void draw_sunken_round_frame(graphics *pg, rect rc, gool::color_v back,
                               gool::color_v dot = gool::color_v()) {
    point center = rc.pointOf(5);
    sizef r      = rc.size() / 2;

    const float PI    = 3.14159265359f;
    float       angle = PI * 3 / 4;
    pg->push_state();
    pg->cap_style(CAP_SQUARE);
    pg->set_stroke_width(1.1f);
    pg->set_stroke(argb(get_current_system_color(SC_DIALOG_SHADOW)));
    pg->draw_arc(center, r, angle, PI);
    pg->set_stroke(argb(get_current_system_color(SC_DIALOG_BRIGHT)));
    pg->draw_arc(center, r, angle, -PI);
    r -= 1.0f;
    pg->set_stroke(argb(get_current_system_color(SC_DIALOG_DKSHADOW)));
    pg->draw_arc(center, r, angle, PI);
    pg->set_stroke(argb(get_current_system_color(SC_DIALOG_LIGHT)));
    pg->draw_arc(center, r, angle, -PI);
    r -= 1.0f;
    pg->set_stroke();
    pg->set_fill(back.to_argb());
    pg->draw_ellipse(center, r);
    if (dot.is_defined()) {
      r -= r.x / 2;
      pg->set_fill(dot.to_argb());
      pg->draw_ellipse(center, r);
    }
    pg->pop_state();
  }

  void draw_sunken_check_frame(graphics *pg, rect rc, gool::color_v back,
                               gool::color_v check = gool::color_v()) {
    draw_rect(pg, rc, SC_DIALOG_SHADOW, SC_DIALOG_BRIGHT, NO_COLOR);
    rc <<= 1;
    draw_rect(pg, rc, SC_DIALOG_DKSHADOW, SC_DIALOG_LIGHT, back);
    if (check.is_defined()) {
      rc <<= 3;
      float    r   = max(1.0f, float(rc.width()) / 3);
      pointf   org = pointf(rc.s) + pointf(0, -1);
      polygonf poly;
      poly.add(org + pointf(0 * r, 1 * r));
      poly.add(org + pointf(0 * r, 2 * r));
      poly.add(org + pointf(1 * r, 3 * r));
      poly.add(org + pointf(3 * r, 1 * r));
      poly.add(org + pointf(3 * r, 0 * r));
      poly.add(org + pointf(1 * r, 2 * r));
      poly.add(org + pointf(0 * r, 1 * r));
      pg->push_state();
      pg->set_stroke();
      pg->set_fill(check.to_argb());
      // pg->fill(argb(get_current_system_color(check)),poly);
      pg->draw_path(poly);
      pg->pop_state();
    }
  }
  void draw_sunken_square_frame(graphics *pg, rect rc, gool::color_v back,
                                gool::color_v check = gool::color_v()) {
    draw_rect(pg, rc, SC_DIALOG_SHADOW, SC_DIALOG_BRIGHT, NO_COLOR);
    rc <<= 1;
    draw_rect(pg, rc, SC_DIALOG_DKSHADOW, SC_DIALOG_LIGHT, back);
    if (check.is_defined()) {
      rc <<= 3;
      //--rc.e;
      // draw_rect(pg,rc,SC_DIALOG_DKSHADOW,SC_DIALOG_LIGHT, get_current_system_color(back));
      argb c1 = check.to_argb();
      pg->fill(c1, rc);
    }
  }

  void draw_push_button(graphics *sf, rect dst, uint buttonst) {
    switch (buttonst) {
    default:
    case 1: draw_raised_frame(sf, dst, SC_DIALOG_SURFACE); return;
    case 2: draw_raised_frame(sf, dst, SC_DIALOG_LIGHT); return;
    case 3: draw_flat_frame(sf, dst, SC_DIALOG_SURFACE); return;
    case 4: draw_flat_frame(sf, dst, SC_DIALOG_SURFACE); return;
    case 5: draw_raised_frame(sf, dst, SC_DIALOG_LIGHT); return;
    }
  }

  void draw_arrow_box(graphics *gfx, rect rc, int arrow,
                      gool::color_v back = gool::color_v()) {
    if (back.is_defined()) {
      rect trc = rc << 2;
      gfx->fill(back.to_argb(), trc);
    }

    argb     c = get_current_system_color(SC_WINDOW_TEXT);
    polygonf vertices;

    int d = max(5, min(rc.width(), rc.height()) / 3);

    rect ri(0, 0, d - 1, d - 1);
    ri.pointOf(5, rc.pointOf(5));

    rectf r = ri;

    ++r.e;
    float dx = floorf((r.width() - 1) / 4);
    float dy = floorf((r.height() - 1) / 4);

    // float dx1 = (r.width()-1) / 4 - 0.5f;
    // float dy1 = (r.height()-1) / 4 - 0.5f;

    const float m = 0.70710678f;

    switch (arrow) {
    case 4: // arrow-left
      r <<= sizef(dx, 0);
      vertices.add(r.pointOf(4));
      vertices.add(r.pointOf(9));
      vertices.add(r.pointOf(3));
      break;
    case 6: // arrow-right
      r <<= sizef(dx, 0);
      vertices.add(r.pointOf(7));
      vertices.add(r.pointOf(6));
      vertices.add(r.pointOf(1));
      break;
    case 8: // arrow-up
      r <<= sizef(0, dy);
      vertices.add(r.pointOf(8));
      vertices.add(r.pointOf(3));
      vertices.add(r.pointOf(1));
      break;
    case 2: // arrow-down
      r <<= sizef(0, dy);
      vertices.add(r.pointOf(7));
      vertices.add(r.pointOf(9));
      vertices.add(r.pointOf(2));
      break;
    case 9: // arrow-ne
      r.s.x = r.e.x - (m * r.width());
      r.e.y = r.s.y + (m * r.height());
      vertices.add(r.pointOf(7));
      vertices.add(r.pointOf(9));
      vertices.add(r.pointOf(3));
      break;
    case 3: // arrow-se
      r.s.x = r.e.x - (m * r.width());
      r.s.y = r.e.y - (m * r.height());
      vertices.add(r.pointOf(9));
      vertices.add(r.pointOf(3));
      vertices.add(r.pointOf(1));
      break;
    case 1: // arrow-sw
      r.e.x = r.s.x + (m * r.width());
      r.s.y = r.e.y - (m * r.height());
      vertices.add(r.pointOf(7));
      vertices.add(r.pointOf(3));
      vertices.add(r.pointOf(1));
      break;
    case 7: // arrow-nw
      r.e.x = r.s.x + (m * r.width());
      r.e.y = r.s.y - (m * r.height());
      vertices.add(r.pointOf(7));
      vertices.add(r.pointOf(9));
      vertices.add(r.pointOf(1));
      break;
    default: assert(false); break;
    }
    handle<gool::path> path = app()->create_path();
    path->set(vertices);
    gfx->fill(c, path);
  }

  void draw_sb_button(graphics *sf, rect dst, uint buttonst, uint arrow = 0) {
    switch (buttonst) {
    default:
    case 1: draw_raised_frame(sf, dst, SC_DIALOG_SURFACE); break;
    case 2: draw_raised_frame(sf, dst, SC_DIALOG_LIGHT); break;
    case 3: draw_flat_frame(sf, dst, SC_DIALOG_SURFACE); break;
    case 4: draw_flat_frame(sf, dst, SC_DIALOG_SURFACE); break;
    case 5: draw_raised_frame(sf, dst, SC_DIALOG_LIGHT); break;
    }
    if (arrow) draw_arrow_box(sf, dst, arrow);
  }

  bool render_edit(const part_def &pd, graphics *sf, rect dst) {
    if (pd.nState == 4 || pd.nState == 6)
      draw_sunken_frame(sf, dst, SC_DIALOG_LIGHT);
    else
      draw_sunken_frame(sf, dst, SC_WINDOW);
    return true;
  }

  bool render_progress(const part_def &pd, graphics *sf, rect dst) {
#if NOT_YET
    if (pd.nPart == PP_BAR || pd.nPart == PP_BARVERT) {
      DrawEdge(sf,          // handle to device context
               PRECT(dst),  // rectangle coordinates
               EDGE_SUNKEN, // type of edge
               BF_ADJUST | /*BF_MONO | BF_FLAT |*/ BF_RECT // type of border
      );
      int sys_color = COLOR_WINDOW;
      if (pd.nState == 4 || pd.nState == 6) sys_color = COLOR_3DLIGHT;
      HBRUSH hb = GetSysColorBrush(sys_color);
      FillRect(sf, PRECT(dst), hb);
    } else {
      HBRUSH hb = GetSysColorBrush(COLOR_HIGHLIGHT);
      FillRect(sf, PRECT(dst), hb);
    }
#endif
    return false;
  }

  bool render_trackbar(const part_def &pd, graphics *sf, rect dst) {
#if NOT_YET
    if (pd.nPart == TKP_TRACK) {
      size sz = dimension(pd);
      --sz;
      dst.s.y += (dst.height() - sz.y) / 2;
      dst.e.y = dst.s.y + sz.y - 1;

      part_def tpd;
      tpd.nClass = THEME_GROUP_TRACKBAR;
      tpd.nPart  = TKP_THUMB;
      tpd.nState = 0;
      size tsz   = dimension(tpd);

      dst.s.x += tsz.x / 2;
      dst.e.x -= tsz.x / 2;

      ++dst.e;
      DrawEdge(sf,                             // handle to device context
               PRECT(dst),                     // rectangle coordinates
               EDGE_SUNKEN,                    // type of edge
               /*BF_MONO | BF_FLAT |*/ BF_RECT // type of border
      );
    } else if (pd.nPart == TKP_TRACKVERT) {
      size sz = dimension(pd);
      --sz;
      dst.s.x += (dst.width() - sz.x) / 2;
      dst.e.x = dst.s.x + sz.x - 1;

      part_def tpd;
      tpd.nClass = THEME_GROUP_TRACKBAR;
      tpd.nPart  = TKP_THUMBVERT;
      tpd.nState = 0;
      size tsz   = dimension(tpd);

      dst.s.y += tsz.y / 2;
      dst.e.y -= tsz.y / 2;
      ++dst.e;

      DrawEdge(sf,                             // handle to device context
               PRECT(dst),                     // rectangle coordinates
               EDGE_SUNKEN,                    // type of edge
               /*BF_MONO | BF_FLAT |*/ BF_RECT // type of border
      );

    } else if (pd.nPart == TKP_THUMB || pd.nPart == TKP_THUMBBOTTOM ||
               pd.nPart == TKP_THUMBTOP || pd.nPart == TKP_THUMBVERT ||
               pd.nPart == TKP_THUMBRIGHT || pd.nPart == TKP_THUMBLEFT) {

      int         uistate   = 0;
      static uint states[6] = {
          DFCS_BUTTONPUSH,
          DFCS_BUTTONPUSH,
          DFCS_BUTTONPUSH | DFCS_HOT,
          DFCS_BUTTONPUSH | DFCS_HOT,
          DFCS_BUTTONPUSH | DFCS_HOT,
          DFCS_BUTTONPUSH | DFCS_INACTIVE,
      };
      int n   = pd.nState < items_in(states) ? pd.nState : 0;
      uistate = states[n];

      if (uistate & DFCS_HOT) {
        HBRUSH hb = GetSysColorBrush(COLOR_BTNHIGHLIGHT);
        DrawFrameControl(sf, PRECT(dst), DFC_BUTTON, BF_ADJUST | uistate);
        FillRect(sf, PRECT(dst), hb);
      } else
        DrawFrameControl(sf, PRECT(dst), DFC_BUTTON, uistate);
    }
#endif
    return false;
  }

  bool render_combobox(const part_def &pd, graphics *sf, rect dst) {
    // combobox-normal, 4, CP_BACKGROUND, 1,2,SHAPE_EXPAND
    // combobox-disabled, 4, CP_BACKGROUND, 4,2,SHAPE_EXPAND
    // combobox-button-normal, 4, CP_DROPDOWNBUTTON, 1,0,SHAPE_NOT_EXPANDABLE
    // combobox-button-hover, 4, CP_DROPDOWNBUTTON, 2,0,SHAPE_NOT_EXPANDABLE
    // combobox-button-pressed, 4, CP_DROPDOWNBUTTON, 3,0,SHAPE_NOT_EXPANDABLE
    // combobox-button-disabled, 4, CP_DROPDOWNBUTTON, 4,0,SHAPE_NOT_EXPANDABLE
    // combobox-button-right-normal, 4, CP_DROPDOWNBUTTONRIGHT,
    // 1,0,SHAPE_NOT_EXPANDABLE  combobox-button-right-hover, 4,
    // CP_DROPDOWNBUTTONRIGHT, 2,0,SHAPE_NOT_EXPANDABLE
    // combobox-button-right-pressed, 4, CP_DROPDOWNBUTTONRIGHT,
    // 3,0,SHAPE_NOT_EXPANDABLE  combobox-button-right-disabled, 4,
    // CP_DROPDOWNBUTTONRIGHT, 4,0,SHAPE_NOT_EXPANDABLE
    // combobox-button-left-normal, 4, CP_DROPDOWNBUTTONLEFT,
    // 1,0,SHAPE_NOT_EXPANDABLE  combobox-button-left-hover, 4,
    // CP_DROPDOWNBUTTONLEFT, 2,0,SHAPE_NOT_EXPANDABLE
    // combobox-button-left-pressed, 4, CP_DROPDOWNBUTTONLEFT,
    // 3,0,SHAPE_NOT_EXPANDABLE  combobox-button-left-disabled, 4,
    // CP_DROPDOWNBUTTONLEFT, 4,0,SHAPE_NOT_EXPANDABLE

    switch (pd.nPart) {
    case CP_BACKGROUND:
      switch (pd.nState) {
      default: draw_sunken_frame(sf, dst, SC_WINDOW); return true;
      case 4: draw_sunken_frame(sf, dst, SC_DIALOG_LIGHT); return true;
      }
      break;
    case CP_DROPDOWNBUTTON:
    case CP_DROPDOWNBUTTONRIGHT:
    case CP_DROPDOWNBUTTONLEFT:
      switch (pd.nState) {
      default:
      case 1:
      case 2: draw_arrow_box(sf, dst, 2); return true;
      case 3: draw_arrow_box(sf, dst, 2, SC_DIALOG_SURFACE); return true;
      case 4: draw_arrow_box(sf, dst, 2); return true;
      }
      break;
    }

    // int uistate = DFCS_SCROLLDOWN/* | DFCS_FLAT*/;
    ////dst <<= rect(0,2,2,2);
    // switch( pd.nState )
    //{
    //  case 1: break;
    //  case 2: uistate |= DFCS_HOT; break;
    //  case 3: uistate |= DFCS_HOT | DFCS_PUSHED | DFCS_FLAT; break;
    //  case 4: uistate |= DFCS_INACTIVE; break;
    //}
    // UINT ta = ::GetTextAlign(sf);
    //::SetTextAlign(sf,TA_TOP);
    // DrawFrameControl(sf,PRECT(dst),DFC_SCROLL,uistate);
    //::SetTextAlign(sf,ta);
    // return ;
    return false;
  }

  bool render_spin(const part_def &pd, graphics *sf, rect dst) {
    uint arrow = 0;
    switch (pd.nPart) {
    case SPNP_UPHORZ: arrow = 6; break;
    case SPNP_DOWNHORZ: arrow = 4; break;
    case SPNP_UP:
      arrow = 8;
      dst.s.y += 2;
      dst.e.x -= 2;
      break;
    case SPNP_DOWN:
      arrow = 2;
      dst.e.y -= 2;
      dst.e.x -= 2;
      break;
    default: assert(0); return false;
    }
    draw_sb_button(sf, dst, pd.nState, arrow);
    return true;

    // int uistate = 0;
    // switch( pd.nPart )
    //{
    // case SPNP_UPHORZ: uistate = DFCS_SCROLLLEFT; break;
    // case SPNP_DOWNHORZ: uistate = DFCS_SCROLLRIGHT; break;
    // case SPNP_UP: uistate = DFCS_SCROLLUP; break;
    // case SPNP_DOWN: uistate = DFCS_SCROLLDOWN; break;
    // default: assert(0); break;
    //}
    ////dst <<= 1;
    // switch( pd.nState )
    //{
    //  case 1: break;
    //  case 2: uistate |= DFCS_HOT; break;
    //  case 3: uistate |= DFCS_HOT | DFCS_PUSHED | DFCS_FLAT; break;
    //  case 4: uistate |= DFCS_INACTIVE; break;
    //}
    // UINT ta = ::GetTextAlign(sf);
    //::SetTextAlign(sf,TA_TOP);
    // DrawFrameControl(sf,PRECT(dst),DFC_SCROLL,uistate);
    //::SetTextAlign(sf,ta);
    // return false;
  }

  bool render_plus_minus(const part_def &pd, graphics *sf, rect dst) {
#if NOT_YET
    --dst.e;
    // sf.set_brush();
    // sf.set_pen(SC_DIALOG_SHADOW,1);
    sf.draw3d(dst, SC_DIALOG_SHADOW, SC_DIALOG_SHADOW);

    rect rm(dst.pointOf(5), size(1, 1));
    rm.s.x -= 2;
    rm.e.x += 2;
    sf.fill(rm, SC_WINDOW_TEXT);

    if (pd.nState == 1) {
      rect rm(dst.pointOf(5), size(1, 1));
      rm.s.y -= 2;
      rm.e.y += 2;
      sf.fill(rm, SC_WINDOW_TEXT);
    }
#endif
    return false;
  }

  bool render_button(const part_def &pd, graphics *sf, rect dst) {
    switch (pd.nPart) {
    case BP_PUSHBUTTON:
      // button-normal,    0, BP_PUSHBUTTON, 1,3,SHAPE_HORIZONTAL
      // button-hover,     0, BP_PUSHBUTTON, 2,3,SHAPE_HORIZONTAL
      // button-pressed,   0, BP_PUSHBUTTON, 3,3,SHAPE_HORIZONTAL
      // button-disabled,  0, BP_PUSHBUTTON, 4,3,SHAPE_HORIZONTAL
      // button-defaulted, 0, BP_PUSHBUTTON, 5,3,SHAPE_HORIZONTAL
      { draw_push_button(sf, dst, pd.nState); }
      return true;
      /*
        static uint states[5] = { DFCS_BUTTONPUSH,
          DFCS_BUTTONPUSH  ,
          DFCS_BUTTONPUSH  | DFCS_HOT,
          DFCS_BUTTONPUSH  | DFCS_PUSHED,
          DFCS_BUTTONPUSH  | DFCS_INACTIVE,
        };
        int n = pd.nState < items_in(states)? pd.nState: 0;
        uistate = states[n];
      }*/
      break;
    case BP_RADIOBUTTON:
      // radio-normal,    0, BP_RADIOBUTTON, 1,0,SHAPE_NOT_EXPANDABLE
      // radio-hover,     0, BP_RADIOBUTTON, 2,0,SHAPE_NOT_EXPANDABLE
      // radio-pressed,   0, BP_RADIOBUTTON, 3,0,SHAPE_NOT_EXPANDABLE
      // radio-disabled,  0, BP_RADIOBUTTON, 4,0,SHAPE_NOT_EXPANDABLE
      // radio-checked-normal,    0, BP_RADIOBUTTON, 5,0,SHAPE_NOT_EXPANDABLE
      // radio-checked-hover,     0, BP_RADIOBUTTON, 6,0,SHAPE_NOT_EXPANDABLE
      // radio-checked-pressed,   0, BP_RADIOBUTTON, 7,0,SHAPE_NOT_EXPANDABLE
      // radio-checked-disabled,  0, BP_RADIOBUTTON, 8,0,SHAPE_NOT_EXPANDABLE
      switch (pd.nState) {
      default:
      case 1: draw_sunken_round_frame(sf, dst, SC_WINDOW); return true;
      case 2: draw_sunken_round_frame(sf, dst, SC_INFO); return true;
      case 3: draw_sunken_round_frame(sf, dst, SC_DIALOG_SURFACE); return true;
      case 4: draw_sunken_round_frame(sf, dst, SC_DIALOG_SURFACE); return true;
      case 5:
        draw_sunken_round_frame(sf, dst, SC_WINDOW, SC_WINDOW_TEXT);
        return true;
      case 6:
        draw_sunken_round_frame(sf, dst, SC_INFO, SC_WINDOW_TEXT);
        return true;
      case 7:
        draw_sunken_round_frame(sf, dst, SC_DIALOG_SURFACE, SC_WINDOW_TEXT);
        return true;
      case 8:
        draw_sunken_round_frame(sf, dst, SC_DIALOG_SURFACE, SC_WINDOW_TEXT);
        return true;
      }
      // static uint states[9] = { DFCS_BUTTONRADIO  | DFCS_TRANSPARENT,
      //  DFCS_BUTTONRADIO | /*DFCS_FLAT |*/ DFCS_TRANSPARENT,
      //  DFCS_BUTTONRADIO | /*DFCS_FLAT |*/ DFCS_TRANSPARENT | DFCS_HOT,
      //  DFCS_BUTTONRADIO | /*DFCS_FLAT |*/ DFCS_TRANSPARENT | DFCS_PUSHED,
      //  DFCS_BUTTONRADIO | /*DFCS_FLAT |*/ DFCS_TRANSPARENT | DFCS_INACTIVE,
      //  DFCS_BUTTONRADIO | /*DFCS_FLAT |*/ DFCS_TRANSPARENT | DFCS_CHECKED,
      //  DFCS_BUTTONRADIO | /*DFCS_FLAT |*/ DFCS_TRANSPARENT | DFCS_CHECKED |
      //  DFCS_HOT, DFCS_BUTTONRADIO | /*DFCS_FLAT |*/ DFCS_TRANSPARENT |
      //  DFCS_CHECKED | DFCS_PUSHED, DFCS_BUTTONRADIO | /*DFCS_FLAT |*/
      //  DFCS_TRANSPARENT | DFCS_CHECKED | DFCS_INACTIVE,
      //};
      // int n = pd.nState < items_in(states)? pd.nState: 0;
      // uistate = states[n];
      // UINT ta = ::GetTextAlign(sf);
      //::SetTextAlign(sf,TA_TOP);
      //::DrawFrameControl(sf,PRECT(dst),DFC_BUTTON,uistate);
      //::SetTextAlign(sf,ta);
      // return ;
      break;

    case BP_CHECKBOX:

      // check-normal,    0, BP_CHECKBOX, 1,0,SHAPE_NOT_EXPANDABLE
      // check-hover,     0, BP_CHECKBOX, 2,0,SHAPE_NOT_EXPANDABLE
      // check-pressed,   0, BP_CHECKBOX, 3,0,SHAPE_NOT_EXPANDABLE
      // check-disabled,  0, BP_CHECKBOX, 4,0,SHAPE_NOT_EXPANDABLE
      // check-checked-normal,    0, BP_CHECKBOX, 5,0,SHAPE_NOT_EXPANDABLE
      // check-checked-hover,     0, BP_CHECKBOX, 6,0,SHAPE_NOT_EXPANDABLE
      // check-checked-pressed,   0, BP_CHECKBOX, 7,0,SHAPE_NOT_EXPANDABLE
      // check-checked-disabled,  0, BP_CHECKBOX, 8,0,SHAPE_NOT_EXPANDABLE
      // check-mixed-normal,    0, BP_CHECKBOX, 9,0,SHAPE_NOT_EXPANDABLE
      // check-mixed-hover,     0, BP_CHECKBOX, 10,0,SHAPE_NOT_EXPANDABLE
      // check-mixed-pressed,   0, BP_CHECKBOX, 11,0,SHAPE_NOT_EXPANDABLE
      // check-mixed-disabled,  0, BP_CHECKBOX, 12,0,SHAPE_NOT_EXPANDABLE

      switch (pd.nState) {
      default:
      case 1: draw_sunken_check_frame(sf, dst, SC_WINDOW); return true;
      case 2: draw_sunken_check_frame(sf, dst, SC_INFO); return true;
      case 3: draw_sunken_check_frame(sf, dst, SC_DIALOG_SURFACE); return true;
      case 4: draw_sunken_check_frame(sf, dst, SC_DIALOG_SURFACE); return true;
      case 5:
        draw_sunken_check_frame(sf, dst, SC_WINDOW, SC_WINDOW_TEXT);
        return true;
      case 6:
        draw_sunken_check_frame(sf, dst, SC_INFO, SC_WINDOW_TEXT);
        return true;
      case 7:
        draw_sunken_check_frame(sf, dst, SC_DIALOG_SURFACE, SC_WINDOW_TEXT);
        return true;
      case 8:
        draw_sunken_check_frame(sf, dst, SC_DIALOG_SURFACE, SC_WINDOW_TEXT);
        return true;
      case 9:
        draw_sunken_square_frame(sf, dst, SC_WINDOW, SC_WINDOW_TEXT);
        return true;
      case 10:
        draw_sunken_square_frame(sf, dst, SC_INFO, SC_WINDOW_TEXT);
        return true;
      case 11:
        draw_sunken_square_frame(sf, dst, SC_DIALOG_SURFACE, SC_WINDOW_TEXT);
        return true;
      case 12:
        draw_sunken_square_frame(sf, dst, SC_DIALOG_SURFACE, SC_WINDOW_TEXT);
        return true;
      }

      //{
      //  static uint states[13] = { DFCS_BUTTONCHECK  | DFCS_TRANSPARENT,
      //    DFCS_BUTTONCHECK | /*DFCS_FLAT |*/ DFCS_TRANSPARENT,
      //    DFCS_BUTTONCHECK | /*DFCS_FLAT |*/ DFCS_TRANSPARENT | DFCS_HOT,
      //    DFCS_BUTTONCHECK | /*DFCS_FLAT |*/ DFCS_TRANSPARENT | DFCS_PUSHED,
      //    DFCS_BUTTONCHECK | /*DFCS_FLAT |*/ DFCS_TRANSPARENT | DFCS_INACTIVE,
      //    DFCS_BUTTONCHECK | /*DFCS_FLAT |*/ DFCS_TRANSPARENT | DFCS_CHECKED,
      //    DFCS_BUTTONCHECK | /*DFCS_FLAT |*/ DFCS_TRANSPARENT | DFCS_CHECKED |
      //    DFCS_HOT, DFCS_BUTTONCHECK | /*DFCS_FLAT |*/ DFCS_TRANSPARENT |
      //    DFCS_CHECKED | DFCS_PUSHED, DFCS_BUTTONCHECK | /*DFCS_FLAT |*/
      //    DFCS_TRANSPARENT | DFCS_CHECKED | DFCS_INACTIVE,

      //    DFCS_BUTTONCHECK | /*DFCS_FLAT |*/ DFCS_TRANSPARENT | DFCS_INACTIVE,
      //    DFCS_BUTTONCHECK | /*DFCS_FLAT |*/ DFCS_TRANSPARENT | DFCS_INACTIVE
      //    | DFCS_HOT, DFCS_BUTTONCHECK | /*DFCS_FLAT |*/ DFCS_TRANSPARENT |
      //    DFCS_INACTIVE | DFCS_PUSHED, DFCS_BUTTONCHECK | /*DFCS_FLAT |*/
      //    DFCS_TRANSPARENT | DFCS_INACTIVE | DFCS_INACTIVE,
      //  };
      //  int n = pd.nState < items_in(states)? pd.nState: 0;
      //  uistate = states[n];
      //  UINT ta = ::GetTextAlign(sf);
      //  ::SetTextAlign(sf,TA_TOP);
      //  DrawFrameControl(sf,PRECT(dst),DFC_BUTTON,uistate);
      //  ::SetTextAlign(sf,ta);
      //  return;
      //}
      break;
    case BP_GROUPBOX:
      //--dst.e;
      // sf.draw3d(dst,SC_DIALOG_SHADOW,SC_DIALOG_SHADOW);
      // return;
    default: break;
    }
    // DrawFrameControl(sf,PRECT(dst),DFC_BUTTON,uistate);
    return false;
  }

  bool render_tab(const part_def &pd, graphics *sf, rect dst) {
#if NOT_YET
    int uistate = 0;

    switch (pd.nPart) {
    case TABP_PANE:
      // sf.set_pen(SC_DIALOG_SHADOW,1);
      // sf.set_brush(SC_WINDOW);
      sf.draw3d(dst, SC_DIALOG_SHADOW, SC_DIALOG_SHADOW, SC_WINDOW);
      return;
    case TABP_TABITEM: break;
    case TABP_TABITEMLEFTEDGE: break;
    case TABP_TABITEMRIGHTEDGE: break;
    default: assert(0); return;
    }

    switch (pd.nState) {
    case 1:
      // sf.set_brush(SC_DIALOG_SURFACE);
      // sf.set_pen();
      dst <<= size(1, 0);
      sf.fill(dst, SC_DIALOG_SURFACE);
      break;
    case 2:
      // sf.set_brush(mcolor(SC_DIALOG_SURFACE,SC_WINDOW));
      // sf.set_pen();
      dst <<= size(1, 0);
      sf.fill(dst, mcolor(SC_DIALOG_SURFACE, SC_WINDOW));
      break;
    case 3:
    case 5: {
      rect r = dst;
      r.e.y -= 2;
      if (sf.push_clip(r)) {
        // sf.set_pen(SC_DIALOG_SHADOW,1);
        // sf.set_brush(SC_WINDOW);
        sf.draw3d(dst, SC_DIALOG_SHADOW, SC_DIALOG_SHADOW, SC_WINDOW);
        sf.pop_clip();
      }
      return;
    }
    case 4:
      dst <<= size(1, 0);
      // sf.set_brush(SC_WINDOW);
      // sf.set_pen();
      sf.fill(dst, SC_WINDOW);
      break;
    }

#endif
    return false;
  }
  bool render_header(const part_def &pd, graphics *sf, rect dst) {
#if NOT_YET
    UINT uistate = 0;
    switch (pd.nPart) {
    case HP_HEADERITEM: {
      static uint states[] = {
          DFCS_BUTTONPUSH,
          DFCS_BUTTONPUSH,
          DFCS_BUTTONPUSH | DFCS_HOT,
          DFCS_BUTTONPUSH | DFCS_PUSHED,
      };
      int n   = pd.nState < items_in(states) ? pd.nState : 0;
      uistate = states[n];
    } break;
    default: return;
    }
    DrawFrameControl(sf, PRECT(dst), DFC_BUTTON, uistate);
#endif
    return false;
  }

  bool render_toolbar(const part_def &pd, graphics *sf, rect dst) {
    // if( pd.nState == 1 ) return false;

    switch (pd.nPart) {
    case TP_BUTTON:
      switch (pd.nState) {
      default:
      case 1: // TS_NORMAL = 1,
        return true;
      case 2: // TS_HOT = 2,
        draw_raised_tb_frame(sf, dst, SC_DIALOG_BRIGHT);
        return true;
      case 3: // TS_PRESSED = 3,
        draw_sunken_tb_frame(sf, dst, SC_DIALOG_BRIGHT);
        return true;
      case 4: // TS_DISABLED = 4,
        return true;
      case 5: // TS_CHECKED = 5,
        draw_sunken_tb_frame(sf, dst, SC_DIALOG_SURFACE);
        return true;
      case 6: // TS_HOTCHECKED = 6
        draw_sunken_tb_frame(sf, dst, SC_DIALOG_BRIGHT);
        return true;
      }
    default: return false;
    }

    //      if( pd.nState == 1 ) return;
    //
    //      UINT uistate = 0;
    ///*  TP_BUTTON = 1,
    //  TP_DROPDOWNBUTTON = 2,
    //  TP_SPLITBUTTON = 3,
    //  TP_SPLITBUTTONDROPDOWN = 4,
    //  TP_SEPARATOR = 5,
    //  TP_SEPARATORVERT = 6
    //  */
    //      switch(pd.nPart)
    //      {
    //        case TP_BUTTON:
    //          {
    //            static uint states[7] = {
    //              DFCS_BUTTONPUSH  | DFCS_FLAT,     // 0
    //              DFCS_BUTTONPUSH  | DFCS_FLAT,     // 1           TS_NORMAL =
    //              1, DFCS_BUTTONPUSH  | DFCS_HOT,      // 2           TS_HOT =
    //              2, DFCS_BUTTONPUSH  | DFCS_PUSHED,   // 3
    //              TS_PRESSED = 3, DFCS_BUTTONPUSH  | DFCS_FLAT |
    //              DFCS_INACTIVE, // TS_DISABLED = 4, DFCS_BUTTONPUSH  |
    //              DFCS_CHECKED,   // 5           TS_CHECKED = 5,
    //              DFCS_BUTTONPUSH  | DFCS_CHECKED | DFCS_HOT, // 6
    //              TS_HOTCHECKED = 6
    //            };
    //            int n = pd.nState < items_in(states)? pd.nState: 0;
    //            uistate = states[n];
    //          }
    //          break;
    //        default:
    //          return;
    //      }
    //      if( (uistate & DFCS_HOT) == DFCS_HOT )
    //      {
    //        DrawEdge(sf.hdc, PRECT(dst), BDR_RAISEDINNER, BF_RECT);
    //        return;
    //      }
    //      if( (uistate & DFCS_PUSHED) == DFCS_PUSHED )
    //        DrawEdge(sf.hdc, PRECT(dst), BDR_SUNKENINNER, BF_RECT);
    //
    //      return false;
  }

  size dimension(const part_def &pd) {
    // part_def& pd = theme_part_defs[img_id - 1];
    // HDC dc = ::GetDC(0);
    size sz;
    switch (pd.nClass) {
    case THEME_GROUP_BUTTON:
      sz.x = GetSystemMetrics(SM_CXMENUCHECK);
      sz.y = GetSystemMetrics(SM_CYMENUCHECK);
      break;
    case THEME_GROUP_TREEVIEW:
      sz.x = 9;
      sz.y = 9;
      break;
    case THEME_GROUP_COMBOBOX:
      sz.x = GetSystemMetrics(SM_CXVSCROLL);
      sz.y = GetSystemMetrics(SM_CYHSCROLL);
      break;
    case THEME_GROUP_SPIN:
      sz.x = 13;
      sz.y = 13;
      break;
    case THEME_GROUP_TRACKBAR:
      if (pd.nPart == TKP_TRACK || pd.nPart == TKP_TRACKVERT)
        sz.x = sz.y = 4;
      else if (pd.nPart == TKP_THUMB || pd.nPart == TKP_THUMBBOTTOM ||
               pd.nPart == TKP_THUMBTOP) {
        sz.x = 12;
        sz.y = 22;
      } else if (pd.nPart == TKP_THUMBVERT || pd.nPart == TKP_THUMBRIGHT ||
                 pd.nPart == TKP_THUMBLEFT) {
        sz.x = 22;
        sz.y = 12;
      }
      break;
    case THEME_GROUP_TOOLBAR:
      sz.x = 7;
      sz.y = 13;
      break;
    }
    // zGetThemePartSize(hThemes[pd.nClass], dc, pd.nPart, pd.nState, 0,
    // TS_TRUE, &sz);  ReleaseDC(0,dc);
    return sz;
  }

  size dimension(const theme_image_95 *pimg) {
    const part_def &pd = theme_part_defs[pimg->image_id - 1];
    return dimension(pd);
  }

  bool render_scrollbar(const part_def &pd, graphics *sf, rect dst) {
#if NOT_YET
    static uint states[4] = {
        0,
        DFCS_HOT,
        DFCS_HOT | DFCS_PUSHED | DFCS_FLAT,
        DFCS_INACTIVE,
    };
    uint uistate = states[(pd.nState - 1) % 4];

    RECT r = toRECT(dst);

    UINT ta = ::GetTextAlign(sf);
    ::SetTextAlign(sf, TA_TOP);

    switch (pd.nPart) {
    case SBP_ARROWBTN:
      if (pd.nState >= 13)
        DrawFrameControl(sf, &r, DFC_SCROLL, DFCS_SCROLLRIGHT | uistate);
      else if (pd.nState >= 9)
        DrawFrameControl(sf, &r, DFC_SCROLL, DFCS_SCROLLLEFT | uistate);
      else if (pd.nState >= 5)
        DrawFrameControl(sf, &r, DFC_SCROLL, DFCS_SCROLLDOWN | uistate);
      else
        DrawFrameControl(sf, &r, DFC_SCROLL, DFCS_SCROLLUP | uistate);
      break;
    case SBP_LOWERTRACKVERT:
    case SBP_UPPERTRACKVERT:
    case SBP_LOWERTRACKHORZ:
    case SBP_UPPERTRACKHORZ: {
      color  c1 = SC_SCROLLBAR;
      color  c2 = SC_WINDOW;
      color  c3 = mcolor(get_current_system_color(c1), get_current_system_color(c2));
      HBRUSH hb = CreateSolidBrush(c3);
      FillRect(sf, &r, hb);
      DeleteObject(hb);
    } break;
    }
    ::SetTextAlign(sf, ta);
#endif

    uint state = ((pd.nState - 1) % 4) + 1;

    switch (pd.nPart) {
    case SBP_ARROWBTN:
      if (pd.nState >= 13) draw_sb_button(sf, dst, state, 6);
      // DrawFrameControl(sf,&r,DFC_SCROLL, DFCS_SCROLLRIGHT | uistate);
      else if (pd.nState >= 9)
        draw_sb_button(sf, dst, state, 4);
      // DrawFrameControl(sf,&r,DFC_SCROLL, DFCS_SCROLLLEFT | uistate);
      else if (pd.nState >= 5)
        draw_sb_button(sf, dst, state, 2);
      // DrawFrameControl(sf,&r,DFC_SCROLL, DFCS_SCROLLDOWN | uistate);
      else
        draw_sb_button(sf, dst, state, 8);
      // DrawFrameControl(sf,&r,DFC_SCROLL, DFCS_SCROLLUP | uistate);
      return true;

    case SBP_LOWERTRACKVERT:
    case SBP_UPPERTRACKVERT:
    case SBP_LOWERTRACKHORZ:
    case SBP_UPPERTRACKHORZ: {
      fill_rect(sf, dst, mcolor(get_current_system_color(SC_SCROLLBAR), get_current_system_color(SC_WINDOW)));
    }
      return true;
    }

    return false;
  }

  void render(theme_image_95 *pimg, graphics *sf, rect dst, rect src,
              byte opacity) {
    const part_def &pd = theme_part_defs[pimg->image_id - 1];
    //++dst.e;

    switch (pd.nClass) {
    case THEME_GROUP_BUTTON:
      if (render_button(pd, sf, dst)) return;
      break;
    case THEME_GROUP_EDIT:
      if (render_edit(pd, sf, dst)) return;
      break;
    case THEME_GROUP_SCROLLBAR:
      if (render_scrollbar(pd, sf, dst)) return;
      break;
    case THEME_GROUP_TREEVIEW:
      if (render_plus_minus(pd, sf, dst)) return;
      break;
    case THEME_GROUP_COMBOBOX:
      if (render_combobox(pd, sf, dst)) return;
      break;
    case THEME_GROUP_SPIN:
      if (render_spin(pd, sf, dst)) return;
      break;
    case THEME_GROUP_TABS:
      if (render_tab(pd, sf, dst)) return;
      break;
    case THEME_GROUP_PROGRESS:
      if (render_progress(pd, sf, dst)) return;
      break;
    case THEME_GROUP_TRACKBAR:
      if (render_trackbar(pd, sf, dst)) return;
      break;
    case THEME_GROUP_HEADER:
      if (render_header(pd, sf, dst)) return;
      break;
    case THEME_GROUP_TOOLBAR:
      if (render_toolbar(pd, sf, dst)) return;
      break;
    case THEME_GROUP_TOOLTIP:
      draw_rect(sf, dst, SC_WINDOW_BORDER, SC_WINDOW_BORDER, SC_INFO);
      return;
    }
    sf->fill(argb(244, 0, 255), dst);
  }

  void theme_95::draw_h_scrollbar(gool::graphics *sf, uint pt, uint st,
                                  rect rc) {
    switch (pt) {
    case SCROLLBAR_PAGE_MINUS:
    case SCROLLBAR_PAGE_PLUS:
    case SCROLLBAR_BASE: {
      color   c3 = mcolor(get_current_system_color(SC_SCROLLBAR), get_current_system_color(SC_WINDOW));
      fill_rect(sf, rc, c3);
    } break;
    case SCROLLBAR_SLIDER: draw_sb_button(sf, rc, st); break;
    case SCROLLBAR_PLUS: draw_sb_button(sf, rc, st, 6); break;
    case SCROLLBAR_MINUS: draw_sb_button(sf, rc, st, 4); break;
    }
  }

  void theme_95::draw_v_scrollbar(gool::graphics *sf, uint pt, uint st,
                                  rect rc) {

    switch (pt) {
    case SCROLLBAR_PAGE_MINUS:
    case SCROLLBAR_PAGE_PLUS:
    case SCROLLBAR_BASE: {
      color c3 = mcolor(get_current_system_color(SC_SCROLLBAR), get_current_system_color(SC_WINDOW));
      fill_rect(sf, rc, c3);
    } break;
    case SCROLLBAR_SLIDER: draw_sb_button(sf, rc, st); break;
    case SCROLLBAR_PLUS: draw_sb_button(sf, rc, st, 2); break;
    case SCROLLBAR_MINUS: draw_sb_button(sf, rc, st, 8); break;
    }

    /*      uint part = 0;
          static uint states[5] = { 0,
              0,
              DFCS_HOT,
              DFCS_HOT | DFCS_PUSHED | DFCS_FLAT,
              DFCS_INACTIVE,
          };
          uint uistate = states[st];

          RECT r = toRECT(rc);

          UINT ta = ::GetTextAlign(sf);
          ::SetTextAlign(sf,TA_TOP);

          switch(pt)
          {
            case SCROLLBAR_PAGE_MINUS:
            case SCROLLBAR_PAGE_PLUS:
            case SCROLLBAR_BASE:
              {
                color c1 = SC_SCROLLBAR;
                color c2 = SC_WINDOW;
                color c3 = mcolor(get_current_system_color(c1),get_current_system_color(c2));
                HBRUSH hb = CreateSolidBrush( c3 );
                FillRect(sf,&r,hb);
                DeleteObject(hb);
              }
              break;
            case SCROLLBAR_SLIDER:
              DrawFrameControl(sf,&r,DFC_BUTTON, DFCS_BUTTONPUSH | uistate);
              break;
            case SCROLLBAR_PLUS:
              DrawFrameControl(sf,&r,DFC_SCROLL, DFCS_SCROLLDOWN | uistate);
              break;
            case SCROLLBAR_MINUS:
              DrawFrameControl(sf,&r,DFC_SCROLL, DFCS_SCROLLUP | uistate);
              break;
          }
          ::SetTextAlign(sf,ta); */
  }

  image *theme_95::get_image_impl(uint id) {
    if (!id || id > TOTAL_KEYWORDS) return 0;
    --id;
    if (images[id].is_null()) 
      images[id] = new theme_image_95(id + 1);
    return images[id];
  }

  void theme_image_95::draw(graphics *gfx, rect dst, rect src, byte opacity) {
    render(this, gfx, dst, src, opacity);
  }

  void theme_image_95::draw(graphics *gfx, rectf dst, rect src, byte opacity) {
    render(this, gfx, rect(dst), src, opacity);
  }

  size theme_image_95::dim() const { return gool::dimension(this); }

  bool theme_image_95::is_transparent() const {
    return gool::is_transparent(this);
  }

} // namespace gool

#endif