#ifndef __win_layered_h__
#define __win_layered_h__

#include "tool/tool.h"
#include "gool/gool.h"
#ifdef USE_D2D
#include "d2d/d2d-objects.h"
#include "d2d/d2d-primitives.h"
#include "d2d/d2d-graphics.h"
#endif

namespace mswin {
  using namespace tool;
  using namespace gool;
  class layered_window_ctx {
    const POINT             _source_pos;
    POINT                   _window_pos;
    SIZE                    _size;
    RECT                    _dirty;
    BLENDFUNCTION           _blend;
    UPDATELAYEREDWINDOWINFO _info;

  public:
    layered_window_ctx(size dim)
        : _source_pos(), _window_pos(), _blend(), _info() {
      _size.cx      = dim.x;
      _size.cy      = dim.y;
      _info.cbSize  = sizeof(_info);
      _info.pptSrc  = &_source_pos;
      _info.pptDst  = &_window_pos;
      _info.psize   = &_size;
      _info.pblend  = &_blend;
      _info.dwFlags = ULW_ALPHA;

      _blend.SourceConstantAlpha = 255;
      _blend.AlphaFormat         = AC_SRC_ALPHA;
    }

    void update(HWND window, HDC source /*, rect* pr*/) {

      if (_size.cx <= 0 || _size.cy <= 0) return;

      _info.hdcSrc = source;
#pragma TODO("partial update of layered?")
      //_info.prcDirty =
      RECT rect;
      GetWindowRect(window, &rect);
      _window_pos.x = rect.left;
      _window_pos.y = rect.top;
      // BOOL r = UpdateLayeredWindowIndirect(window, &_info);
      BOOL r = UpdateLayeredWindow(
          window, _info.hdcDst, const_cast<POINT *>(_info.pptDst),
          const_cast<SIZE *>(_info.psize), _info.hdcSrc,
          const_cast<POINT *>(_info.pptSrc), _info.crKey,
          const_cast<BLENDFUNCTION *>(_info.pblend), _info.dwFlags);
      assert(r);
      r = r;
    }
    size dim() const { return size(_size.cx, _size.cy); }

    NONCOPYABLE(layered_window_ctx)
  };
} // namespace mswin

#endif