#ifndef __win_frame_h__
#define __win_frame_h__

#include "win-view.h"
#include "win-callback.h"
#include "win-delayload.h"
#include "api/ext-ctl-api.h"
#include <dwmapi.h>
#include <strsafe.h>
//#ifdef USE_D2D
//#include "d2d/d2d-window.h"
//#endif

EXTERN_DLOADV(_DwmExtendFrameIntoClientArea, DwmExtendFrameIntoClientArea, dwmapi.dll,
  HRESULT(WINAPI *)(HWND hWnd, const MARGINS *pMarInset));

EXTERN_DLOADV(_DwmSetWindowAttribute, DwmSetWindowAttribute, dwmapi.dll,
  HRESULT(WINAPI *)(HWND hwnd, DWORD dwAttribute, _In_ LPCVOID pvAttribute, DWORD cbAttribute));

EXTERN_DLOADV(_DwmGetWindowAttribute, DwmGetWindowAttribute, dwmapi.dll,
  HRESULT(WINAPI *)(HWND hwnd, DWORD dwAttribute, _Out_ LPVOID pvAttribute,  DWORD cbAttribute));

EXTERN_DLOADV(_DwmEnableBlurBehindWindow, DwmEnableBlurBehindWindow, dwmapi.dll,
  HRESULT(WINAPI *)(HWND hWnd, const DWM_BLURBEHIND *pBlurBehind));

EXTERN_DLOADV(_DwmGetColorizationColor, DwmGetColorizationColor, dwmapi.dll,
  HRESULT(WINAPI *)(DWORD *pcrColorization,BOOL *pfOpaqueBlend));

/*struct DWMCOLORIZATIONPARAMS
{
  DWORD clrColor;
  DWORD clrAfterGlow;
  DWORD nIntensity;
  DWORD clrAfterGlowBalance;
  DWORD clrBlurBalance;
  DWORD clrGlassReflectionIntensity;
  BOOL  fOpaque;
};

EXTERN_DLOADV(_DwmGetColorizationParameters, DwmGetColorizationParameters, dwmapi.dll,
  VOID(WINAPI *)(DWMCOLORIZATIONPARAMS* pp)); */

// Windows 10 stuff
enum WINDOWCOMPOSITIONATTRIB {
  WCA_UNDEFINED = 0,
  WCA_NCRENDERING_ENABLED = 1,
  WCA_NCRENDERING_POLICY = 2,
  WCA_TRANSITIONS_FORCEDISABLED = 3,
  WCA_ALLOW_NCPAINT = 4,
  WCA_CAPTION_BUTTON_BOUNDS = 5,
  WCA_NONCLIENT_RTL_LAYOUT = 6,
  WCA_FORCE_ICONIC_REPRESENTATION = 7,
  WCA_EXTENDED_FRAME_BOUNDS = 8,
  WCA_HAS_ICONIC_BITMAP = 9,
  WCA_THEME_ATTRIBUTES = 10,
  WCA_NCRENDERING_EXILED = 11,
  WCA_NCADORNMENTINFO = 12,
  WCA_EXCLUDED_FROM_LIVEPREVIEW = 13,
  WCA_VIDEO_OVERLAY_ACTIVE = 14,
  WCA_FORCE_ACTIVEWINDOW_APPEARANCE = 15,
  WCA_DISALLOW_PEEK = 16,
  WCA_CLOAK = 17,
  WCA_CLOAKED = 18,
  WCA_ACCENT_POLICY = 19,
  WCA_FREEZE_REPRESENTATION = 20,
  WCA_EVER_UNCLOAKED = 21,
  WCA_VISUAL_OWNER = 22,
  WCA_LAST = 23
};

struct WINDOWCOMPOSITIONATTRIBDATA {
  WINDOWCOMPOSITIONATTRIB dwAttrib;
  PVOID                   pvData;
  SIZE_T                  cbData;
};

enum ACCENT_STATE {
  ACCENT_DISABLED = 0,
  ACCENT_ENABLE_GRADIENT = 1,
  ACCENT_ENABLE_TRANSPARENTGRADIENT = 2,
  ACCENT_ENABLE_BLURBEHIND = 3,
  ACCENT_ENABLE_ACRYLIC_BLURBEHIND = 4,
  ACCENT_ENABLE_HOSTBACKDROP = 5,
  ACCENT_INVALID_STATE = 5
};

struct ACCENT_POLICY {
  ACCENT_STATE AccentState;
  DWORD        AccentFlags;
  DWORD        GradientColor;
  DWORD        AnimationId;
};

EXTERN_DLOADV(_SetWindowCompositionAttribute, SetWindowCompositionAttribute,
  user32.dll,
  BOOL(WINAPI *)(HWND hWnd, WINDOWCOMPOSITIONATTRIBDATA *compositionData));

EXTERN_DLOADV(_GetWindowCompositionAttribute, SetWindowCompositionAttribute,
  user32.dll,
  BOOL(WINAPI *)(HWND hWnd, WINDOWCOMPOSITIONATTRIBDATA *compositionData));

namespace mswin 
{

  template <class WP> class frame : public WP {
    typedef WP super;

  protected:
    bool construction;          // true if in construction phase
    bool construction_rejected; // true if WM_CLOSE was seen while construction
  public:
    static handle<frame> construct(const window_params &params) {
      handle<frame> frm = new frame(params);
      if (frm) frm->init_instance(params);
      return frm;
    }

    virtual html::VIEW_TYPE view_type() const override {
      return html::VIEW_WINDOW;
    }

    virtual void init_instance(const window_params &params);
    virtual bool show();

    // void check_glass(bool force);
    void set_caption(wchars text);

    static LRESULT CALLBACK frame_proc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
    static bool             init();

    static frame* instance(HWND hwnd) { return html::view::ptr<frame>(hwnd); }

    static LPCWSTR window_class_name() { 
      static ustring _window_class_name = ustring::format(W("%s%s"), FRAME_CLASS_NAME, WP::class_name_suffix());
      return _window_class_name.c_str();
    }

    virtual ~frame() {
    }

  protected:
    frame(const window_params& params);
    SciterWindowDelegate *_delegate;
    LPVOID                _delegate_param;
  };

  template <class WP> class dialog : public frame<WP> {
  public:
    typedef frame super;

    static handle<dialog> construct(const window_params &params) {
      handle<dialog> frm = new dialog(params);
      if (frm) frm->init_instance(params);
      return frm;
    }

    virtual html::VIEW_TYPE view_type() const override {
      return html::VIEW_DIALOG;
    }

    virtual void init_instance(const window_params &params) override;
    virtual bool show_modal() override;
    virtual bool close_window() override;

    static LPCWSTR window_class_name() { 
      static ustring _window_class_name = ustring::format(W("%s%s"), DIALOG_CLASS_NAME, WP::class_name_suffix());
      return _window_class_name.c_str();
    }

  protected:
    dialog(const window_params& params);
  };

  
  template <class WP>
  inline LRESULT CALLBACK frame<WP>::frame_proc(HWND hwnd, UINT message,
                                                WPARAM wParam, LPARAM lParam) {
    BOOL handled = 0;

    if (message == WM_CREATE) {
      CREATESTRUCT *pcs = (CREATESTRUCT *)lParam;
      frame* pf  = static_cast<frame *>(pcs->lpCreateParams);
      pf->set_hwnd(hwnd);
      //attach(pf, hwnd);
      return 0;
    }
    else if (message == WM_DESTROY) {
      handle<frame> self = instance(hwnd);
      if (self) {
        if (self->is_main()) 
          ::PostQuitMessage(0);
        self->_delegate = 0;
        self->_delegate_param = 0;
      }
    }


    handle<frame> self = instance(hwnd);

    LRESULT lr = proc(hwnd, message, wParam, lParam, handled);

    if (self && self->_delegate && self->get_hwnd()) {
      BOOL    phandled = FALSE;
      LRESULT dlr      = self->_delegate(hwnd, message, wParam, lParam, self->_delegate_param, &phandled);
      if (phandled) {
        handled = TRUE;
        lr      = dlr;
      }
    }

    if (message == WM_CLOSE) {
      self = instance(hwnd);
      if (self) {
        // DONE in WM_CLOSE handler: if( !self->ask_unload( self->doc(), wParam
        // == WPARAM(hwnd) ? view::UNLOAD_BY_CODE : view::UNLOAD_BY_CHROME ))
        //  return 0;
        if (self->construction) // if it is in constructing phase
        {
          self->construction_rejected = true;
          return 0;
        }
        if (!handled) 
          self->close_window();
        return 0;
      }
    } 

    if (handled) return lr;

    return DefWindowProc(hwnd, message, wParam, lParam);
  }

  template <class WP> inline bool frame<WP>::init() {
    static ATOM atom = 0;
    if (atom) return true;

    WNDCLASSEX wcex = {0};

    HINSTANCE hexe = GetModuleHandle(NULL);

    // Register window class.
    wcex.cbSize         = sizeof(WNDCLASSEX);
    wcex.style = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc    = frame::frame_proc;
    wcex.cbClsExtra     = 0;
    wcex.cbWndExtra     = sizeof(LONG_PTR);
    wcex.hInstance      = THIS_HINSTANCE;
    wcex.hbrBackground  = //(HBRUSH)GetStockObject(NULL_BRUSH);
                          CreateSolidBrush(0xFFFFFF);
    wcex.lpszMenuName   = NULL;
    wcex.hIcon          = LoadIcon(hexe, W("SCITER-FRAME-ICON")); if(!wcex.hIcon) wcex.hIcon = LoadIcon(hexe, MAKEINTRESOURCEW(107));
    auto err = GetLastError();
    wcex.hCursor        = LoadCursor(NULL, IDC_ARROW);
    wcex.lpszClassName  = window_class_name();
    wcex.hIconSm        = LoadIcon(hexe, W("SCITER-FRAME-ICON-SMALL")); if (!wcex.hIconSm) wcex.hIcon = LoadIcon(hexe, MAKEINTRESOURCEW(107));

    atom = RegisterClassEx(&wcex);

    if (!atom) return false;
    return true;
  }

  template <class WP>
  inline frame<WP>::frame(const window_params& params) : super(params),construction(false), construction_rejected(false) {
  }

  template <class WP>
  inline void frame<WP>::init_instance(const window_params &params) {
        
    init();

    _delegate = (SciterWindowDelegate*)params.delegate;
    _delegate_param = params.delegateParam;

    construction          = true;
    construction_rejected = false;

    HWND owner = 0;
    if (params.parent && !params.is_detached)
      owner = params.parent->get_hwnd();
    else if (params.owner)
      owner = params.owner;

    bool is_blank = false;

    int x = CW_USEDEFAULT;
    int y = CW_USEDEFAULT;
    int w = CW_USEDEFAULT;
    int h = CW_USEDEFAULT;
    if (!params.dim.empty()) {
      x = params.pos.x;
      y = params.pos.y;
      w = params.dim.x; // static_cast<int>(640.0f / dpiScaleX),
      h = params.dim.y; // static_cast<int>(480.0f / dpiScaleY),
      if (params.client_coordinates) {
        RECT rc = {x, y, x + w, y + h};
        AdjustWindowRectEx(&rc, params.window_style, false,
                           params.window_style_ex);
        x = rc.left;
        y = rc.top;
        w = rc.right - rc.left;
        h = rc.bottom - rc.top;
      }
    }

    UINT ex_styles = params.window_style_ex;
    UINT styles = params.window_style;// | WS_CLIPCHILDREN; - WRONG on extended! 
        

    // Create window.
    HWND hwnd =
        CreateWindowEx(ex_styles, window_class_name(), params.caption, styles, x, y,
                       w, // static_cast<int>(640.0f / dpiScaleX),
                       h, // static_cast<int>(480.0f / dpiScaleY),
                       owner, NULL, HINST_THISCOMPONENT, this);

    if (!hwnd) {

      LPVOID lpMsgBuf;
      LPVOID lpDisplayBuf;
      DWORD  dw = GetLastError();

      LPTSTR lpszFunction = L"CreateWindowEx";

      FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |
                        FORMAT_MESSAGE_FROM_SYSTEM |
                        FORMAT_MESSAGE_IGNORE_INSERTS,
                    NULL, dw, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
                    (LPTSTR)&lpMsgBuf, 0, NULL);

      // Display the error message and exit the process

      lpDisplayBuf = (LPVOID)LocalAlloc(
          LMEM_ZEROINIT,
          (lstrlen((LPCTSTR)lpMsgBuf) + lstrlen((LPCTSTR)lpszFunction) + 40) *
              sizeof(TCHAR));
      StringCchPrintf(
          (LPTSTR)lpDisplayBuf, LocalSize(lpDisplayBuf) / sizeof(TCHAR),
          TEXT("%s failed with error %d: %s"), lpszFunction, dw, lpMsgBuf);
      MessageBox(NULL, (LPCTSTR)lpDisplayBuf, TEXT("Error"), MB_OK);

      LocalFree(lpMsgBuf);
      LocalFree(lpDisplayBuf);

      assert(false);

      return;
    }
    if (construction_rejected) return;

    construction = false;

    this->set_hwnd(hwnd);
    this->start(params);

    html::document *pd = doc();

    gool::rect wrc;
    {
      RECT rc;
      ::GetWindowRect(hwnd, &rc);
      wrc = gool::rect(rc);
    }

    if (window_was_moved) // it was set by window itself
      return;

    gool::rect displayrc;
    if (params.screen_no.is_defined()) {
      html::screen_info si;
      if (!html::get_screen_info(params.screen_no, si))
        html::get_screen_info(0, si);
      displayrc = si.workarea;
    } else if(params.parent )
      displayrc = params.parent->screen_workarea();
    else
      displayrc = screen_workarea();

    if (pd && params.dim.empty() && !is_blank) {

      size ssz = displayrc.size();
      size msz = wrc.size();
      msz.x = max(msz.x,pd->min_width(*this, ssz.x));
      if (pd->dim().x != msz.x) pd->set_width(*this, msz.x);
      msz.y = max(msz.y,pd->min_height(*this, ssz.y));
      if (msz.x == 0) msz.x = 300;
      if (msz.y == 0) msz.y = 150;

      gool::point pt = params.pos;

      wrc = gool::rect(pt, msz);

      if( get_frame_type() == STANDARD)
        AdjustWindowRectEx(PRECT(wrc), GetWindowLong(get_hwnd(), GWL_STYLE), FALSE,
                           GetWindowLong(get_hwnd(), GWL_EXSTYLE));
      //::GetClientRect(get_hwnd(), PRECT(wrc));
    }

    if (params.dim.x.is_undefined() && params.pos.x.is_defined()) {
      wrc.pointOf(params.alignment, params.pos);
      wrc.inscribe(displayrc);
    } else if (params.dim.x.is_defined() && params.pos.x.is_defined()) {
      // wrc = rect(params.pos,params.dim);
      // wrc.pointOf(params.alignment,params.pos);
    }

    if (params.pos.x.is_defined()) {
      ;
    } else if (params.alignment < 0 && params.alignment >= -9) {
      HWND hwndParent = 0;
      if (params.parent)
        hwndParent = params.parent->get_hwnd();
      else
        hwndParent = ::GetParent(get_hwnd());

      gool::rect drc;
      ::GetWindowRect(hwndParent, PRECT(drc));
      wrc.pointOf(abs(params.alignment), drc.pointOf(abs(params.alignment)));
      inscribe_to_screen(this, wrc, rect());
    } else if (params.alignment > 0 && params.alignment <= 9) {
      wrc.pointOf(params.alignment, displayrc.pointOf(params.alignment));
      wrc.inscribe(displayrc);
    }
    // else
    //  return;

    ::SetWindowPos(get_hwnd(), NULL, wrc.left(), wrc.top(), wrc.width(),
                   wrc.height(), SWP_NOZORDER | SWP_NOACTIVATE);

    }

  template <class WP> inline void frame<WP>::set_caption(wchars text) {
    if (get_hwnd()) {
      ustring us = text;
      ::SetWindowText(get_hwnd(), us);
    }
  }

  template <class WP> inline bool frame<WP>::show() {
    if (::IsWindow(get_hwnd())) {
      ShowWindow(get_hwnd(), SW_SHOWNORMAL);
      UpdateWindow(get_hwnd());
      return true;
    }
    return false;
  }

  template <class WP>
  inline dialog<WP>::dialog(const window_params& params): super(params) {}

  template <class WP>
  inline void dialog<WP>::init_instance(const window_params &params) {
    super::init_instance(params);
    if (!::IsWindow(get_hwnd()) || construction_rejected) {
      if (::IsWindow(get_hwnd())) ::DestroyWindow(get_hwnd());
      return;
    }

    html::document *pd = doc();
    if (!pd) {
      construction_rejected = true;
      return;
    }

    construction = false;
  }

  template <class WP> inline bool dialog<WP>::show_modal() {
    if (super::show_modal()) 
      return dialog_retval != NOTHING_VALUE;
    return false;
  }

  template <class WP> inline bool dialog<WP>::close_window() {
    if (!get_hwnd()) return false;
    HWND frm = ::GetWindow(get_hwnd(), GW_OWNER);
    if (::IsWindow(frm)) {
      ::EnableWindow(frm, TRUE);
      ::DestroyWindow(get_hwnd());
      ::SetActiveWindow(frm);
    } else
      ::DestroyWindow(get_hwnd());
    return true;
  }

} // namespace mswin

#endif