#ifndef __win_delayload_h__
#define __win_delayload_h__

#include "tool/tl_config.h"
#include "tool/tl_sync.h"
#include "tool/tl_ustring.h"
#include "tool/tl_hash_table.h"

#include <shlobj.h>


namespace mswin {

  inline tool::hash_table<tool::ustring, HINSTANCE> &libs_cache() {
    tool::critical_section _(tool::lock); // because of /Zc:threadSafeInit- WindowsXP abd below support
    static tool::hash_table<tool::ustring, HINSTANCE> libs;
    return libs;
  }

  template <class T> class func_proxy {
  protected:
    LPCWSTR lname;
    LPCSTR  fname;

    mutable T         pfunc;
    mutable HINSTANCE hlib;
    mutable bool      loaded;

    func_proxy() : pfunc(0), hlib(0), libname(nullptr), funcname(nullptr) {}

  public:
    func_proxy(LPCWSTR pszLib, LPCSTR pszName)
        : pfunc(0), hlib(0), lname(pszLib), fname(pszName) {
      // load( pszLib, pszName );
    }

    virtual ~func_proxy() { unload(true); }

    operator bool() const {
      if (!loaded) load();
      return pfunc != 0;
    }

    bool load() const {
      if (loaded) return pfunc != 0;

      loaded = true;

      // assert( !hlib );

      tool::ustring libname(lname);

      if (!libs_cache().find(libname, hlib)) {

        // NOTE: this mechanism is used to load only system libraries

        WCHAR path[MAX_PATH];
        path[0] = 0;

        BOOL r = SHGetSpecialFolderPath(NULL, path, CSIDL_SYSTEM, FALSE);
        if (!r) return false;

        wcscat_s(path, W("\\"));
        wcscat_s(path, lname);

        hlib = ::LoadLibraryEx(path, NULL, LOAD_WITH_ALTERED_SEARCH_PATH);
        libs_cache()[libname] = hlib;
      }

      if (hlib) {
#ifdef PLATFORM_WINCE
        pfunc = (T)::GetProcAddressA(hlib, fname);
#else
        pfunc = (T)::GetProcAddress(hlib, fname);
#endif
        if (!pfunc) unload();
      }
      return pfunc != 0;
    }

    bool unload(bool from_dtor = false) const {
      //  if( hlib && !from_dtor)
      //  {
      ///* we should not call FreeLibrary from DllMain routine during process
      ///termination,
      //   because this can result in a DLL being used after the system has
      //   executed its termination code
      //*/
      //      BOOL res = ::FreeLibrary( hlib );
      //      assert( res );
      //      return res != 0;
      //  }
      pfunc = 0;
      hlib  = 0;

      return false;
    }

    HINSTANCE instance() { return hlib; }

    T operator()() {
      if (!loaded) load();
      assert(pfunc);
      return pfunc;
    }
  };

} // namespace mswin

#ifndef stringizer
#define stringizer(x) (#x)
#endif

#define DLOAD(funcname, libname, type)                                         \
  mswin::func_proxy<type> funcname(TEXT(#libname), stringizer(funcname))

#define DLOADV(varname, funcname, libname, type)                               \
  mswin::func_proxy<type> varname(TEXT(#libname), stringizer(funcname))

#define EXTERN_DLOADV(varname, funcname, libname, type)                        \
  extern mswin::func_proxy<type> varname;

#endif // __win_delayload_h__
