#ifndef __win_application_h__
#define __win_application_h__

#include "tool/tool.h"
#include "gool/gool.h"
#include "html/html.h"

/*namespace html {
  class  view;
  struct element;
  struct node;
  namespace tflow {
    struct text_flow;
  }
}*/

#ifndef HINST_THISCOMPONENT
EXTERN_C IMAGE_DOS_HEADER __ImageBase;
#define HINST_THISCOMPONENT ((HINSTANCE)&__ImageBase)
#endif

#ifndef WINDOWLESS

namespace mswin {
  using namespace tool;
  using namespace gool;

  class window;
  // class  frame;
  // class  dialog;
  // struct window_params;

  class application : public html::application {
    friend application *app();

  public:

    DEFINE_TYPE_ID_DERIVED(application, html::application)

    virtual void final_release() override;

    virtual ~application();

    virtual bool is_valid() { return false; }

    virtual bool is_gdi() { return false; }
    virtual bool is_d2d() { return false; }

    virtual void get_system_font(/*inout*/ ustring &name, /*out*/ int &size,
                                 /*out*/ uint &weight,
                                 /*out*/ bool &italic) override;

    void post_quit() { PostQuitMessage(0); }

    virtual window* create_window_processor(const window_params &params) = 0;
    virtual window* create_dx_window_processor(const window_params &params, IDXGISwapChain * pSwapChain) { return nullptr; }

    virtual handle<html::view> create_frame(const window_params &params)  = 0;
    virtual handle<html::view> create_dialog(const window_params &params) = 0;

    HINSTANCE h_instance() { return HINST_THISCOMPONENT; }

#ifdef WIC_SUPPORT
    virtual IWICImagingFactory *wic_factory() const;
#endif

    virtual handle<print_target> select_printer(html::view *ui_parent,
                                                ustring printer_id) override;
    virtual handle<print_target> create_print_target();
    virtual array<printer_info>  get_printer_list() override;

    static void init();
    static void shutdown();

    virtual bool font_families_for_char_code(tool::wchars lang_id, WRITING_SCRIPT script, uint char_code, array<ustring>& out) override;

  protected:
    friend class app_shutdown_watcher;

    application();

    com::asset<IWICImagingFactory> p_WIC_factory;

    static application *instance;
  };

  struct hdc_print_target : public print_target {
    virtual bool
    print(const ustring &                                 doc_name,
          function<bool(graphics *page_gfx, int page_no)> renderer) override;
  };

  application *app();

  // extern tool::mutex guard;

} // namespace mswin

#endif
#endif