//|
//|
//| Copyright (c) 2001-2005
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//| URL class implementation
//|
//|

#ifndef ____tool__h____
#define ____tool__h____

#pragma warning(disable : 4786) // identifier was truncated...
#pragma warning(disable : 4345) // behavior change: an object of POD type
                                // constructed with an initializer of the form
                                // () will be default-initialized

//#define _CRT_SECURE_NO_WARNINGS

//#include <new.h>

#include "config.h"

#include "assert.h"

#include <ctype.h>
#include <wchar.h>

#include "tl_array.h"
#include "tl_base64.h"
#include "tl_basic.h"    // OS dependent
#include "tl_config.h"   // OS dependent
#include "tl_datetime.h" // OS dependent
#include "tl_dictionary.h"
#include "tl_handle.h"
#include "tl_handle_pool.h"
#include "tl_hash.h"
#include "tl_hash_table.h"
#include "tl_markup.h"
#include "tl_mm_file.h"
#include "tl_pool.h"
#include "tl_scope.h"
#include "tl_slice.h"
#include "tl_str_s.h"  // OS dependent
#include "tl_string.h" // OS dependent
#include "tl_sync.h"   // OS dependent
#include "tl_ternary_tree.h"
#include "tl_tokenizer.h"
#include "tl_url.h"
#include "tl_ustring.h" // OS dependent
#include "tl_value.h"
#include "tl_value_t.h"
#include "tl_wregexp.h"
#include "eval/tl_eval.h"
#include "tl_async_io.h"
#include "tl_delegate.h"
#include "tl_filesystem.h" // OS dependent
#include "tl_generator.h"
#include "tl_sar.h"
#include "tl_slice.h"
#include "tl_spell_checker.h"
#include "tl_streams.h"
#include "tl_timer.h"
#include "tl_zip.h"

#include "snprintf.h"
#include "snscanf.h"

//#include "sdk-headers.h"

// using namespace tool;

namespace tool {

#if defined(UNICODE)
typedef ustring tstring;
typedef wchar   tchar;
#else
typedef string tstring;
typedef char   tchar;
#endif

class error {
  string _msg;
public:
  error(const char* m) : _msg(m) {}

  virtual char const* what() const
  {
    return _msg.c_str();
  }

};


void split_path(const char *path, string &drive, string &dir, string &name,
                string &ext);
void split_path(const wchar *path, ustring &drive, ustring &dir, ustring &name,
                ustring &ext);

ustring real_path(ustring maybe_local);

template<typename C> 
  inline array<C> normalize_path(slice<C> path)
  {
    array<slice<C>> normalized;
    while (path) {
      wchars part = path.chop('/');
      if (part == CHARS("."))
        continue;
      else if (part == CHARS("..") && normalized.length()) {
        normalized.pop();
        continue;
      }
      else
        normalized.push(part);
    }
    array<C> rp;
    for (int i = 0; i < normalized.size(); ++i) {
      if (i) rp.push('/');
      rp.push(normalized[i]);
    }
    return rp;
  }




bool launch(ustring path);

// gets home dir of current module
/*tstring  get_home_dir(void* hinst = 0);*/
ustring get_home_dir(const wchar *relpath = W(""), void *hinst = 0);
ustring get_self_path();

enum STANDARD_DIR {
  UNKNOWN_DIR,
  APPLICATIONS_DIR,
  USER_APPDATA_DIR,
  USER_HOME_DIR,
  USER_DESKTOP_DIR,
  USER_DOWNLOADS_DIR,
  USER_DOCUMENTS_DIR,
  USER_MUSIC_DIR,
  USER_VIDEO_DIR,
  USER_PICTURES_DIR,
  USER_ROOT_DIR,
};

STANDARD_DIR parse_standard_dir(chars s);

ustring get_standard_dir(STANDARD_DIR sd);

extern unsigned int get_ticks();

#if defined(WINDOWS)
inline void alert(const char *msg) { ::MessageBoxA(NULL, msg, "alert", MB_OK); }
inline void alert(const wchar *msg) {
  ::MessageBoxW(NULL, msg, L"alert", MB_OK);
}
#elif defined(LINUX)
inline void    alert(const char *msg) {
  //GtkWidget *dialog =
  //    gtk_message_dialog_new(NULL, GTK_DIALOG_DESTROY_WITH_PARENT,
  //                           GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, msg);
  //gtk_dialog_run(GTK_DIALOG(dialog));
  //gtk_widget_destroy(dialog);
  printf("ALERT:%s\n",msg);
}

#endif

enum USER_PREFERENCES {
  UP_MENU_SHOW_DELAY,    // ms     , SPI_GETMENUSHOWDELAY
  UP_MENU_ANIMATION,     // 0/1/2  , no/fade/slide, SPI_GETMENUFADE
  UP_TOOLTIP_ANIMATION,  // 0/1/2  , no/fade/slide, SPI_GETTOOLTIPFADE & Co.
  UP_COMBOBOX_ANIMATION, // 0/1/2  , no/fade/slide, SPI_SETCOMBOBOXANIMATION
};
uint get_user_preference(USER_PREFERENCES up);

template <typename TC>
void expand_tabs(array<TC> &dst, slice<TC> text, int spaces_per_tab = 4,
                 int offset = 0) {
  TC splitter[2] = {0};
  splitter[0]    = '\n';
  tokens<TC> tz(text, splitter);
  while (tz.next(text)) {
    array<TC> buf;
    for (int n = 0; n < int(text.length); ++n) {
      wchar c = text[n];
      if (c == '\t') {
        int r = (offset + buf.size()) % spaces_per_tab;
        buf.push(' ', r ? r : spaces_per_tab);
      } else
        buf.push(c);
    }
    if (dst.is_empty())
      dst.swap(buf);
    else
      dst.push(buf());
  }
}

void play_sound(bytes sound_data);

array<chars> get_ext_for_mime(chars mimetype);
string       guess_mime_type(string filename, bytes data);
chars        mime_for_ext(chars ext);

int get_lang_id(const string &name);
// returns false if encoding is not recognized
bool decode_bytes(bytes bs, ustring &str, const string &encoding);
bool encode_bytes(wchars str, array<byte> &data, const string &encoding);

struct number_format_def {
  uint_v     num_digits;     // number of decimal digits
  tristate_v leading_zero;   // if leading zero in decimal fields
  uint_v     grouping;       // group size left of decimal
  ustring    decimal_sep;    // ptr to decimal separator string
  ustring    group_sep;      // ptr to group separator string
  uint_v     negative_order; // negative number ordering
  uint_v     positive_order; // positive number ordering
  ustring    currency_symbol;
};

ustring format_number_str(const ustring &locale, const ustring &str,
                          const number_format_def *pf = 0);
ustring format_currency_str(const ustring &locale, const ustring &str,
                            const number_format_def *pf = 0);
ustring format_date(const ustring &locale, date_time dt, const ustring &fmt);
ustring format_time(const ustring &locale, date_time dt, const ustring &fmt);
bool    parse_number_format_def(wchars format, number_format_def &f);

#if defined(WINDOWS)
DWORD locale_name_2_LCID(const ustring &name);
#endif

namespace environment 
{
  ustring user_name();
  ustring machine_name(bool full);

  bool used_lang_country(ustring &lang, ustring &country, bool for_user);
  bool set_used_lang_country(const ustring &lang, const ustring &country);
  
  // provided by backend 
  bool    get_lang_country(ustring &lang, ustring &country, bool for_user);

  enum os_versions {
    SOME_LINUX = 0, // :-p

    /*WIN_32S       = 0x100,
    WIN_95        = 0x101,
    WIN_95_OSR2   = 0x102,
    WIN_98        = 0x103,
    WIN_98_SE     = 0x104,
    WIN_ME        = 0x105,

    WIN_CE        = 0x110,
    WIN_NT4       = 0x111, */
    WIN_2000 = 0x112,
    WIN_XP   = 0x113,
    WIN_2003 = 0x114,

    WIN_VISTA = 0x120,
    WIN_7     = 0x130,
    WIN_7_1   = 0x131,
    WIN_8     = 0x140,
    WIN_8_1   = 0x141,
    WIN_10    = 0x150,
    WIN_10_1  = 0x151,
    WIN_10_2  = 0x152,

    SOME_OSX     = 0x200, // :-p
    SOME_IOS     = 0x300,
    SOME_ANDROID = 0x400,
  };

  int         get_os_version();
  const char *get_os_version_name();

  inline const string get_os_lang() {
    ustring lang; ustring country;
    used_lang_country(lang, country, false);
    return lang;
  }

  const char *platform_name();

  struct info 
  {
    char  lang[2];
    char  country[2];
    short orientation;      // 0-undefined, 1 - vertical (portrait), 2 -
                            // horizontal(landscape)
    short touchscreen;      // 0-undefined, 1 - no-touch, 2 - stylus, 3 - finger
    short navigation;       // N/A
    short navigationStatus; // N/A
    short keyboard;         // KEYBOARD_TYPE
    short keyboardStatus;   // KEYBOARD_STATUS
    short deviceType;       // DEVICE_TYPE
    short uiTheme;          // UI_THEME
    short osVersion;
  };


} // namespace environment

uint32 crc32(bytes data);

struct md5checksum {
  byte   data[16];
  string to_string();
};
md5checksum md5(bytes data);

class MD5 {
  void *ctx;

public:
  MD5();
  ~MD5();
  MD5 &       operator+=(bytes data);
  md5checksum close();
  NONCOPYABLE(MD5);
};
}

void debug_printf(uint subsystem, uint severity, const char *fmt, ...);
void debug_print(uint subsystem, uint severity, tool::wchars text);

#define debug_assert(b, exp)                                                   \
  if (!(b))                                                                    \
  debug_printf((exp))

#if defined(WINDOWS)
typedef void CALLBACK debug_output_func(void *p, uint subsystem, uint severity,
                                        const wchar *text, uint text_length);
#else
typedef void debug_output_func(void *p, uint subsystem, uint severity,
                               const wchar *text, uint text_length);
#endif

void setup_debug_output(void *p, debug_output_func *pf);


#if defined(WINDOWS)
  #include "ports/windows_specifics.h"
#elif defined(OSX)
  #include "ports/macosx_specifics.h"
#elif defined(LINUX)
  #include "ports/linux_specifics.h"
#endif

#ifndef TRUE 
  #define TRUE 1
  #define FALSE 0
#endif

FILE *wfopen(LPCWSTR filename, LPCWSTR mode);
int   wopen(LPCWSTR filename, int flags, int mode);

#endif
