#ifndef _TL_WREGEXP_H_
#define _TL_WREGEXP_H_

#include "tl_array.h"
#include "tl_config.h"
#include "tl_slice.h"
#include "tl_ustring.h"

#include <stddef.h>
#include <wchar.h>

#include "re/re.h"

namespace tool {
class wregexp {
public:
  struct regmatch {
    uint begin;
    uint end;
    regmatch() : begin(0), end(0) {}
  };

protected:
  void reset_matches();

  struct rex_prog *m_compiled;
  array<regmatch>  m_matches;

public:
  ustring m_pattern;
  ustring m_test;
  // ustring       m_test_input; // if 'i' (m_ignorecase) then this is lowercase
  // version of the m_test
  //                            // otherwise m_test itself
  uint    m_next_index;
  uint    m_index;
  ustring m_error;
  bool    m_ignorecase;
  bool    m_global;
  bool    m_multiline;
  bool    m_has_only_group = false; // true if it contains only one group, e.g.: /(abc)/ig;

  wregexp()
      : m_compiled(nullptr), m_ignorecase(false), m_global(false),
        m_multiline(false), m_next_index(0), m_index(0) {}
  wregexp(const ustring &pattern, bool ignorecase = true, bool global = true,
          bool multiline = false)
      : m_ignorecase(ignorecase), m_global(global), m_multiline(multiline),
        m_next_index(0), m_index(0) {
    compile(pattern, ignorecase, global, multiline);
  }
  ~wregexp();

  bool compile(const ustring &pattern, bool ignorecase, bool global,
               bool multiline);
  bool exec(wchars text);
  bool exec_all(wchars text);

  static wchars NEXT_CHUNK() {
    static wchar z = 0;
    return wchars(&z, 1);
  }

  bool     is_matched(int n_sub_exp = 0) const;
  int      get_match_start(int n_sub_exp = 0) const;
  int      get_match_end(int n_sub_exp = 0) const;
  wchars   get_match(int n_sub_exp = 0) const;
  regmatch get_match_position(int n = 0) const { return m_matches[n]; }

  wchars text() { return m_test; }

  // substitute string using the matches from the last exec()
  ustring substitute(wchars text);

  int get_number_of_matches() const;

  ustring get_error_string() const;

private:
  // disable copying
  wregexp(const wregexp &);
  wregexp &operator=(const wregexp &);
};

} // namespace tool

#endif /* TL_WREGEXP_H_ */
