//|
//|
//| Copyright (c) 2001-2005
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//| COW ASCII string_t<CT,ACT> class
//|
//|

#ifndef __tl_string_h__
#define __tl_string_h__

#include "tl_string_t.h"

namespace tool {

  typedef string_t<char, wchar> string;
  typedef string_chars_t<char, wchar> string_chars;


  inline bool streq(const char *s, const char *s1) {
    if (s && s1)
      return strcmp(s, s1) == 0;
    return false;
  }

  inline bool streqi(const char *s, const char *s1) {
    if (s && s1)
      return lexical::ci::cmp(s, s1) == 0;
    return false;
  }

  template<> inline string_t<char, wchar>&  string_t<char, wchar>::operator=(slice<byte> s) { 
    set(slice<char>((const char*)s.start, s.length)); return *this; 
  }

  extern string unique_id();
  
  template<>
    void string_t<char, wchar>::set(wchars s);
    
  template<>
    string_t<char,wchar> string_t<char, wchar>::format_args(const char *fmt, va_list args);

}; // namespace tool

#endif /* string_defined */
