//|
//|
//| Copyright (c) 2015
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//| System's spell checker interface
//|
//|

#ifndef __tl_spell_checker_h
#define __tl_spell_checker_h

#include "tl_basic.h"
#include "tl_handle.h"
#include "tl_hash_table.h"
#include "tl_ustring.h"

namespace tool {

enum SPELL_CORRECTIVE_ACTION {
  SPELL_CORRECTIVE_ACTION_NONE            = 0,
  SPELL_CORRECTIVE_ACTION_DELETE          = 1,
  SPELL_CORRECTIVE_ACTION_REPLACE         = 2,
  SPELL_CORRECTIVE_ACTION_GET_SUGGESTIONS = 3,
};

typedef function<void(SPELL_CORRECTIVE_ACTION action, uint start, uint length,
                      tool::ustring replacement)>
    spell_check_callback_t;

struct spell_checker : public resource {
  virtual bool check_spelling(const tool::ustring &  txt,
                              spell_check_callback_t callback) = 0;

  virtual array<ustring> get_suggestions_for(const ustring &text) = 0;
};

struct spell_checker_factory : public resource {
  hash_table<ustring, handle<spell_checker>> checkers;

  spell_checker *get(const ustring &lang) {
    handle<spell_checker> t;
    if (!checkers.find(lang, t)) {
      t = create(lang);
      checkers[lang] = t;
    }
    return t;
  }

  virtual spell_checker *create(const ustring &lang) = 0;

  static spell_checker_factory *create_factory()
#if defined(WINDOWS) || defined(OSX) || defined(LINUX)
      ;
#else
  {
    return nullptr;
  }
#endif
};

} // namespace tool

#endif
