//|
//|
//| Copyright (c) 2001-2005
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//| memory mapped file and flat table class
//|
//|

#ifndef __tl_mm_file_h
#define __tl_mm_file_h

#include "tl_config.h"

#include <assert.h>

namespace tool {

class mm_file {

#ifdef WINDOWS
  HANDLE hfile;
  HANDLE hmap;
#else
  int   hfile;
#endif

protected:
  void *  ptr;
  size_t  length;
  bool    read_only;
  ustring real_file_name;

public:
  mm_file() : hfile(0), ptr(0), length(0), read_only(true) {
#ifdef WINDOWS
    hmap = 0;
#endif
  }
  virtual ~mm_file() { close(); }

#ifdef WINDOWS
  void *open(const wchar *path, bool to_write = false);
#else
  void *open(const wchar *path, bool to_write = false);
#endif
  void close();

  void * data() { return ptr; }
  size_t size() { return length; }
  void   size(size_t sz) {
    assert(!read_only);
    length = sz;
  }
  ustring file_name() const { return real_file_name; }

  operator slice<byte>() { return slice<byte>((byte *)data(), (uint)size()); }
  slice<byte> bytes() { return slice<byte>((byte *)data(), (uint)size()); }
};


} // namespace tool

#endif
