#ifndef __tl_mem_pool_h__
#define __tl_mem_pool_h__

#include "tl_config.h"
#include <stdlib.h>

namespace tool {
template <typename T> class mem_pool {
  struct item {
    item *prev;
    item *next;
    byte  data[sizeof(T)];
    item() : prev(0), next(0) { memzero(data); }
  };

  item *active;  // list of active items in use
  item *passive; // list of passive, freed items
public:
  mem_pool() : active(0), passive(0) {}

  T *allocate() // returns non-initialized data
  {
    item *p = 0;
    if (passive) {
      p       = passive;
      passive = p->next;
      p->next = 0;
      p->prev = 0;
    } else {
      p = new item();
    }
    p->next      = active;
    active->prev = p;
    active       = p;
    return //(T*)p->data;
        new (p->data) T();
  }
  void release(T *t) {
    item *p = (item *)(((byte *)(t)) - offsetof(item, data));
    if (p == active) {
      active       = active->next;
      active->prev = 0;
    } else {
      if (p->next)
        p->next->prev = p->prev;
      if (p->prev)
        p->prev->next = p->next;
    }
    ((T *)p->data)->~T();
    p->prev       = 0;
    p->next       = passive;
    passive->prev = p;
    passive       = p;
  }
};

/*
    class mem_pool
    {
    public:
       mem_pool(size_t max_block_size = 512);
       ~mem_pool() { destroy(); }
       void* alloc(size_t sz);
       void  destroy();
    private:
      struct chunk
       {
         chunk* next;
         byte data[1];
         static chunk* alloc(size_t chunk_size)
         {
           chunk* n = (chunk*)malloc(sizeof(chunk) + chunk_size);
           n->next = 0;
           memset(n->data,0,chunk_size);
           return n;
         }
       };
       chunk* root_chunk;
       size_t charged;
       size_t chunk_size;
    };

    inline mem_pool::mem_pool(size_t max_block_size)
       :chunk_size(max_block_size),root_chunk(0)
    {
    }

    inline void* mem_pool::alloc(size_t sz)
    {
      assert( sz < chunk_size );

      if( !root_chunk )
      {
        root_chunk = chunk::alloc( max(sz,chunk_size) );
        charged = 0;
      }
      if( (charged + sz) > chunk_size )
      {
        chunk* n = chunk::alloc( max(sz,chunk_size) );
        n->next = root_chunk;
        root_chunk = n;
        charged = 0;
      }
      void* t = &root_chunk->data[ charged ];
      charged += sz;
      return t;
    }

    inline void mem_pool::destroy()
    {
      while(root_chunk)
      {
        chunk* t = root_chunk;
        root_chunk = root_chunk->next;
        free(t);
      }
    }
*/

} // namespace tool

#endif
