#ifndef __tl_config_h__
#define __tl_config_h__

#include "config.h"

#pragma warning(disable : 4481) // warning C4481: nonstandard extension used:
                                // override specifier 'override'
#pragma warning(                                                               \
    disable : 4127) // warning C4127: conditional expression is constant
#pragma warning(disable : 4100) // warning C4100: 'defsize' : unreferenced
                                // formal parameter
#pragma warning(disable : 4505) // warning C4505: '...' : unreferenced local
                                // function has been removed
#pragma warning(disable : 4702) // warning C4702: unreachable code
#pragma warning(disable : 4458) // warning C4458 : declaration of 'name' hides
                                // class member
#pragma warning(disable : 4456) // warning C4456 : declaration of 'r' hides
                                // previous local declaration
#pragma warning(disable : 4459) // warning C4459 : declaration of 'pi' hides
                                // global declaration
#pragma warning(disable : 4250) // inherits 'tool::async::entity::tool::async::entity::final_release' via dominance


/*#if __cplusplus >= 201402L
        #define CPP_11
        #define CPP_14
#elif __cplusplus >= 201103L
   #define CPP_11
#elif _MSC_VER >= 1900
        #define CPP_11
        #define CPP_14
#elif _MSC_VER >= 1600
        #define CPP_11
#endif

#ifndef CPP_14
        #define constexpr
#endif*/

#if defined(USE_THREAD_LOCAL)
#define THREAD_LOCAL thread_local
#else
#define THREAD_LOCAL
#endif

#if defined(WIN64) || defined(_WIN64) || defined(_M_X64)
  #define WINDOWS
  #define X64BITS
#elif defined(WIN32) || defined(_WIN32)
  #define WINDOWS
  #if defined(__GNUC__)
  #define PLATFORM_WIN32_GNU 1
  #define COMPILER_GCC
  #elif defined(_MSC_VER)
  #define COMPILER_MSC
  #elif defined(__INTEL_COMPILER)
  #define COMPILER_INTEL
  #endif
#elif defined(__APPLE__)
  #define OSX
  #define UTF8_CHARS // const char* is UTF8 sequence
  #ifdef __x86_64__
  #define X64BITS
  #endif
  #define POSIX
  #define CALLBACK
  #define IN
  #define OUT
  #if defined(__clang__)
  #define COMPILER_CLANG
  #elif defined(__GNUC__)
  #define COMPILER_GCC
  #endif
#elif defined(__ANDROID__) || defined(ANDROID)
  #ifndef ANDROID
    #define ANDROID
  #endif
  //#ifndef LINUX
  //  #define LINUX
  //#endif
  #define UTF8_CHARS // const char* is UTF8 sequence
  #if defined(ARM64)
    #define X64BITS
  #endif
  #define POSIX
  #define CALLBACK
  #define IN
  #define OUT
#else
  #ifndef LINUX
  #define LINUX
  #endif
  #define UTF8_CHARS // const char* is UTF8 sequence
  #if defined(__x86_64__) || defined(_IA64) || defined(__IA64__)
  #define X64BITS
  #endif
  #define POSIX
  #define CALLBACK
  #define IN
  #define OUT
#endif

#if defined(WINDOWS)

#define HAS_STR_S

#if !defined(WINVER)
#define WINVER 0x0602
#define _WIN32_WINNT 0x0602
#endif

#define WIN32_LEAN_AND_MEAN
#pragma warning(push)
#pragma warning(disable : 4005)
#define _WINSOCKAPI_
#include <intsafe.h>
#include <stdint.h>
#pragma warning(pop)

#include <assert.h>
#include <float.h>
#include <intrin.h>
#include <math.h>
#include <memory.h>
#include <specstrings.h>
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

/*#if defined(DEBUG) || defined(_DEBUG)
  #define INLINE inline // let compiler decide
#else
  #define INLINE __forceinline
#endif
*/
#define INLINE inline

#define PLATFORM_EOL "\r\n"

#ifndef THIS_HINSTANCE
EXTERN_C IMAGE_DOS_HEADER __ImageBase;
#define THIS_HINSTANCE ((HINSTANCE)&__ImageBase)
#endif

#elif defined(OSX)
#include <chrono>
#include <thread>
#define INLINE inline
//#define HWINDOW void*

#define PLATFORM_EOL "\n"

#elif defined(POSIX)
#include <atomic>
#include <chrono>
#include <thread>
#define INLINE inline

#define PLATFORM_EOL "\n"

#endif

#include <cmath>
#include <limits>

#ifdef min
#undef min
#undef max
#endif

template <typename T1, typename T2> inline T1 min(const T1 a, const T2 b) {
  return a < T1(b) ? a : T1(b);
}
template <typename T1, typename T2, typename T3>
inline T1 min(const T1 a, const T2 b, const T3 c) {
  T1 t = min(b, c);
  return a < t ? a : t;
}
template <typename T1, typename T2, typename T3, typename T4>
inline T1 min(const T1 a, const T2 b, const T3 c, const T4 d) {
  T1 t = min(b, c, d);
  return a < t ? a : t;
}
template <typename T1, typename T2> inline T1 max(const T1 a, const T2 b) {
  return a > T1(b) ? a : T1(b);
}
template <typename T1, typename T2, typename T3>
inline T1 max(const T1 a, const T2 b, const T3 c) {
  T1 t = max(b, c);
  return a > t ? a : t;
}
template <typename T1, typename T2, typename T3, typename T4>
inline T1 max(const T1 a, const T2 b, const T3 c, const T4 d) {
  T1 t = max(b, c, d);
  return a > t ? a : t;
}

template <typename T> struct limits {
  static T min_value() { return std::numeric_limits<T>::min(); }
  static T max_value() { return std::numeric_limits<T>::max(); }
};

#define NONCOPYABLE(T)             \
                                   \
private:                           \
  T(const T &) = delete;           \
  T &operator=(const T &) = delete;

#if defined(WINDOWS)

#define muldiv MulDiv

//#define BREAK_INTO_DEBUGGER()  asm { int 3 }

#elif defined(WINDOWS) && defined(UNDER_CE)

#define stricmp _stricmp
#define strnicmp _strnicmp
#define strdup _strdup

inline int muldiv(IN int nNumber, IN int nNumerator, IN int nDenominator) {
  __int64 multiple = nNumber * nNumerator;
  return static_cast<int>(multiple / nDenominator);
}

#elif defined(POSIX) || defined(OSX)

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <wchar.h>
//#define stricmp strcasecmp

#define muldiv(i1, i2, i3)                                                     \
  ((int)(((long long)(i1) * (long long)(i2)) / (long long)(i3)))

#define MAX_PATH 2048

#endif

template <bool> struct COMPILE_TIME_ERROR;
template <> struct COMPILE_TIME_ERROR<true> {};

#define STATIC_ASSERT(expr) (COMPILE_TIME_ERROR<(expr) != 0>())


typedef uint16_t   word;
typedef uint32_t   dword;
typedef uint64_t   qword;
typedef int64_t    int64;
typedef uint64_t   uint64;

#ifdef WIN32
  typedef wchar_t    wchar;
#else
  typedef char16_t   wchar;
#endif

//#define LL(ln) (ln##LL)

typedef int32_t        int32;
typedef uint32_t       uint32;
typedef float          float32;
typedef int8_t         int8;
typedef uint8_t        uint8;
typedef int16_t        int16;
typedef uint16_t       uint16;
typedef double         float64;

typedef uint8_t        byte;
typedef unsigned int   uint;
typedef unsigned short ushort;

typedef uint32 ucode; // unicode code point

#if INTPTR_MAX >= INT64_MAX
  #ifndef X64BITS
    #define X64BITS
  #endif
  typedef uint64 uint_ptr;
  typedef int64  int_ptr;
#else
  typedef uint32 uint_ptr;
  typedef int32  int_ptr;
#endif

//typedef uintptr_t uint_ptr;
//typedef intptr_t  int_ptr;

typedef int index_t; // index of element in collections

typedef word wchar16; // utf16 code unit

#ifdef WINDOWS
#define __WTEXT(quote) L##quote
#define __WCHAR(c) L##c
#else
#define __WTEXT(quote) u##quote
#define __WCHAR(c) u##c
#endif
#define WTEXT(quote) __WTEXT(quote)
#define UCHAR(c) __WCHAR(c)

#define W(quote) ((const wchar *)WTEXT(quote))

template <typename V> struct unsigned_t { typedef unsigned int type; };
template <> struct unsigned_t<int> { typedef unsigned int type; };
template <> struct unsigned_t<int64> { typedef uint64 type; };
template <> struct unsigned_t<char> { typedef unsigned char type; };
template <> struct unsigned_t<short> { typedef unsigned short type; };

#if defined(UNDER_CE)
typedef float real;
#else
typedef double             real;
#endif

template <typename REAL> struct real_traits {
  static inline double pi() { return 3.14159265358979323846; }
  static inline double pi2() { return 2 * 3.14159265358979323846; }
  static inline double epsilon() { return 1e-14; }
  static inline double sincos45() { return 0.707106781; }
  static inline double sqrt(double v) { return std::sqrt(v); }
  static inline double sin(double v) { return std::sin(v); }
  static inline double cos(double v) { return std::cos(v); }
  static inline double tan(double v) { return std::tan(v); }
  static inline double atan2(double x, double y) { return std::atan2(x, y); }
};

template <> struct real_traits<float> {
  static inline float pi() { return 3.14159265359f; }
  static inline float pi2() { return 2 * 3.14159265359f; }
  static inline float epsilon() { return 1e-7f; }
  static inline float sincos45() { return 0.707107f; }
  static inline float sqrt(float v) { return std::sqrt(v); }
  static inline float sin(float v) { return std::sin(v); }
  static inline float cos(float v) { return std::cos(v); }
  static inline float tan(float v) { return std::tan(v); }
  static inline float atan2(float x, float y) { return std::atan2(x, y); }
};

#define assert_static(e) (1 / int(e))

/*inline checks()
{
  assert_static( sizeof(byte) == 1 );
  assert_static( sizeof(int32) == 4 );
  assert_static( sizeof(float32) == 4 );
  assert_static( sizeof(int16) == 2 );
}*/

#if !defined(OBSOLETE)
/* obsolete API marker*/
#if defined(__GNUC__)
#define OBSOLETE __attribute__((deprecated))
#elif defined(_MSC_VER) && MSC_VER > 1200
#define OBSOLETE __declspec(deprecated)
#else
#define OBSOLETE
#endif
#endif

// marker used in inplace CTORs
struct NO_INIT {};

namespace locked {

#if defined(PLATFORM_WIN32_GNU)

typedef long counter_t;
inline long  _inc(counter_t &v) { return InterlockedIncrement(&v); }
inline long  _dec(counter_t &v) { return InterlockedDecrement(&v); }
inline long  _set(counter_t &v, long nv) { return InterlockedExchange(&v, nv); }

#elif defined(WINDOWS) &&                                                      \
    !defined(_WIN32_WCE) // lets try to keep things for wince simple as much as
                         // we can

typedef volatile long counter_t;
inline long _inc(counter_t &v) { return InterlockedIncrement((LPLONG)&v); }
inline long _inc(counter_t &v, long by) {
  return InterlockedExchangeAdd((LPLONG)&v, by);
}
inline long _dec(counter_t &v) { return InterlockedDecrement((LPLONG)&v); }
inline long _set(counter_t &v, long nv) {
  return InterlockedExchange((LPLONG)&v, nv);
}
inline long _set_when_eq(counter_t &v, long to_set, long eq_to) {
  return InterlockedCompareExchange((LPLONG)&v, to_set, eq_to);
}

#elif (__GNUC__ < 4 || (__GNUC__ == 4 && __GNUC_MINOR__ <= 8))

typedef long counter_t;
inline long  _inc(counter_t &v) { return __sync_add_and_fetch(&v, 1); }
inline long _inc(counter_t &v, long by) { return __sync_add_and_fetch(&v, by); }
inline long _dec(counter_t &v) { return __sync_add_and_fetch(&v, -1); }
inline long _set(counter_t &v, long nv) {
  return __sync_lock_test_and_set(&v, nv);
}
inline long _set_when_eq(counter_t &v, long to_set, long eq_to) {
  return __sync_val_compare_and_swap(&v, eq_to, to_set);
                                                                   /*long t(v); if(t == eq_to) v = to_set; return t;*/ }

#else

typedef std::atomic<long> counter_t;
inline long               _inc(counter_t &v) { return ++v; }
inline long               _inc(counter_t &v, long by) { return v += by; }
inline long               _dec(counter_t &v) { return --v; }
inline long               _set(counter_t &v, long nv) { return v.exchange(nv); }
inline long               _set_when_eq(counter_t &v, long to_set, long eq_to) {
  long t(v);
  v.compare_exchange_strong(eq_to, to_set);
  return t;
}

#endif

struct counter {
  counter_t cv;
  counter() : cv(0) {}
  counter(NO_INIT) {}
  counter(long iv) : cv(iv) {}
  counter &operator=(long nv) {
    _set(cv, nv);
    return *this;
  }
       operator long() const { return cv; }
  long operator++() { return _inc(cv); }
  long operator+=(long v) { return _inc(cv, v); }
  long operator--() { return _dec(cv); }
  long set_if_equal(long when_eq, long to) {
    return _set_when_eq(cv, to, when_eq);
  }
};

inline long inc(counter &v) { return ++v; }
inline long dec(counter &v) { return --v; }
inline void set(counter &v, long nv) { v = nv; }

struct auto_lock {
  counter &cnt;
  auto_lock(counter &c) : cnt(c) { ++cnt; }
  ~auto_lock() { --cnt; }

private:
  auto_lock(const auto_lock &c);
  auto_lock &operator=(const auto_lock &);
};
}

struct perf_counter {
#if defined(WINDOWS)
  LARGE_INTEGER start;
  LARGE_INTEGER freq;

  perf_counter() {
    ::QueryPerformanceCounter(&start);
    ::QueryPerformanceFrequency(&freq);
  }
  double elapsed() {
    LARGE_INTEGER stop;
    ::QueryPerformanceCounter(&stop);
    return double(stop.QuadPart - start.QuadPart) * 1000.0 /
           double(freq.QuadPart);
  }
#else
  perf_counter() {}
  double elapsed() { return 0; }
#endif
};

#endif
