//|
//|
//| Copyright (c) 2001-2005
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//|
//|
//|

#ifndef __tl_basic_h_
#define __tl_basic_h_

#include "tl_config.h"

#include <assert.h>
#include <ctype.h>
#include <float.h>
#include <functional>
#include <limits.h>
#include <math.h>
#include <new>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <type_traits>
#include <utility>
#include <wctype.h>
//#include <xutility>
#include <limits>
#include <tuple>

#include "ucdata/ucdata_lt.h"

#if defined(WINDOWS)
#include <intrin.h>
#else
inline void __debugbreak() { ; }
#endif

#if defined(max)
#undef max
#endif

#if defined(min)
#undef min
#endif

/*#if defined(WINDOWS)
  #ifndef min       // Hopefully this isn't already defined
    #define min(a,b)        (((a) < (b)) ? (a) : (b))
    #define max(a,b)        (((a) > (b)) ? (a) : (b))
  #endif
#else
  #include <unistd.h>

  template <typename T1,typename T2>
    inline T1 min(const T1 a, const T2 b) { return a < T1(b) ? a : T1(b); }
  template <typename T1,typename T2>
    inline T1 max(const T1 a, const T2 b) { return a > T1(b) ? a : T1(b); }
#endif*/

#define MEMBER_OF(T, M) [](const T &t) { return t.M; }

/****************************************************************************/

#include "tl_type_traits.h"

#include "snprintf.h"

inline bool is_space(char c) { return isspace(c & 0xff) != 0; }
inline bool is_space(wchar c) { return iswspace(c) != 0; }
inline bool is_space(ucode c) { return iswspace(wint_t(c)) != 0; }
inline bool is_space(int c) { return is_space((ucode)c); }

inline bool is_space_nocrlf(wchar c) { return iswspace(c) != 0 && c != '\r' && c != '\n'; }

inline bool is_digit(char c) { return isdigit(c & 0xff) != 0; }
inline bool is_digit(wchar c) { return iswdigit(c) != 0; }
inline bool is_digit(ucode c) { return iswdigit(wint_t(c)) != 0; }
inline bool is_digit(int c) { return is_digit((ucode)c); }

inline bool is_xdigit(char c) { return isxdigit(c & 0xff) != 0; }
inline bool is_xdigit(wchar c) { return iswxdigit(c) != 0; }
inline bool is_xdigit(ucode c) { return iswxdigit(wint_t(c)) != 0; }
inline bool is_xdigit(int c) { return is_xdigit((ucode)c); }

inline bool is_alpha(char c) { return isalpha(c & 0xff) != 0; }
inline bool is_alpha(wchar c) { return iswalpha(c) != 0; }
inline bool is_alpha(ucode c) { return iswalpha(wint_t(c)) != 0; }
inline bool is_alpha(int c) { return is_alpha((ucode)c); }

inline bool is_alnum(char c) { return isalnum(c & 0xff) != 0; }
inline bool is_alnum(wchar c) { return iswalnum(c) != 0; }
inline bool is_alnum(ucode c) { return iswalnum(wint_t(c)) != 0; }
inline bool is_alnum(int c) { return is_alnum((ucode)c); }

inline size_t str_len(const char *s) { return strlen(s); }
inline size_t str_len(const wchar *s) {
  const wchar *p = s;
  while (*p)
    p++;
  return p - s;
}

inline int str_cmp(const char *s1, const char *s2) { return strcmp(s1, s2); }
inline int str_cmp(const wchar *s1, const wchar *s2) {
  for (; *s1 == *s2; ++s1, ++s2)
    if (*s1 == 0)
      return 0;
  return int(*s1) - int(*s2);
}

//#ifdef WINDOWS
// inline const char* str_dup(const char* str) { return _strdup(str); }
// inline const wchar* str_dup(const wchar* str) { return _wcsdup(str); }
//#else
// inline const char* str_dup(const char* str) { return strdup(str); }
// inline const wchar* str_dup(const wchar* str) { return wcsdup(str); }
//#endif

/*#ifdef WINDOWS
inline int str_icmp(const char* s1,const char* s2) { return _stricmp(s1,s2); }
inline int str_icmp(const wchar* s1,const wchar* s2) { return _wcsicmp(s1,s2); }
inline int str_nicmp(const char* s1,const char* s2, size_t n) { return
_strnicmp(s1,s2,n); } inline int str_nicmp(const wchar* s1,const wchar* s2,
size_t n) { return _wcsnicmp(s1,s2,n); } inline int str_ncmp(const wchar*
s1,const wchar* s2, size_t n) { return wcsncmp(s1,s2,n); } #else inline int
str_icmp(const char* s1,const char* s2) { return strcasecmp(s1,s2); } inline int
str_icmp(const wchar* s1,const wchar* s2)
{
    for (;uctolower(*s1) == uctolower(*s2); ++s1, ++s2 )
                if (*s1 == 0) return 0;
        return int(*s1) - int(*s2);
}

inline int str_nicmp(const char* s1,const char* s2, size_t n) { return
strncasecmp(s1,s2,n); } inline int str_nicmp(const wchar* s1,const wchar* s2,
size_t n)
{
    for (size_t c = 0; uctolower(*s1) == uctolower(*s2); ++s1, ++s2, ++c )
                if (*s1 == 0 || c == n) return 0;
        return int(*s1) - int(*s2);
}
inline int str_ncmp(const wchar* s1,const wchar* s2, size_t n)
{
    for (size_t c = 0; *s1 == *s2; ++s1, ++s2, ++c )
                if (*s1 == 0 || c == n) return 0;
        return int(*s1) - int(*s2);
}
#endif */

inline const wchar *str_str(const wchar *str, const wchar *substr) {
  const wchar *a, *b;

  b = substr;
  if (*b == 0) {
    return str;
  }
  for (; *str != 0; ++str) {
    if (*str != *b) {
      continue;
    }
    a = str;
    while (1) {
      if (*b == 0) {
        return str;
      }
      if (*a++ != *b++) {
        break;
      }
    }
    b = substr;
  }
  return nullptr;

  /*	wchar c, sc; size_t len;
          if ((c = *find++) != 0) {
                  len = str_len(find);
                  do {
                          do {
                                  if ((sc = *s++) == L'\0')
                                          return nullptr;
                          } while (sc != c);
                  } while (str_ncmp(s, find, len) != 0);
                  s--;
          }
          return (wchar *)s; */
}

#ifdef WINDOWS
#define IROTL _lrotl
#else
#define IROTL(x, n) (((x) << (n)) | ((x) >> (32 - (n))))
#endif

namespace tool {
//#ifndef NULL
//#define NULL 0
//#endif

inline char  to_upper(char c) { return (char)toupper(c); }
inline wchar to_upper(wchar c) { return (wchar)uctoupper(c); }
inline char  to_lower(char c) { return (char)tolower(c); }
inline wchar to_lower(wchar c) { return (wchar)uctolower(c); }

using std::function;
using std::swap;
using std::tuple;

template <class T> inline T limit(T v, T minv, T maxv) {
  if (minv >= maxv)
    return minv;
  if (v > maxv)
    return maxv;
  if (v < minv)
    return minv;
  return v;
}

template <class T> inline bool is_between(T v, T minv, T maxv) {
  if (minv >= maxv)
    return false;
  if (v > maxv)
    return false;
  if (v < minv)
    return false;
  return true;
}

template <class T> inline bool is_one_of(const T &v, const T &v1, const T &v2) {
  return v == v1 || v == v2;
}

template <class T>
inline bool is_one_of(const T &v, const T &v1, const T &v2, const T &v3) {
  return v == v1 || v == v2 || v == v3;
}

template <class T>
inline bool is_one_of(const T &v, const T &v1, const T &v2, const T &v3,
                      const T &v4) {
  return v == v1 || v == v2 || v == v3 || v == v4;
}

template <class T1, class T2> inline bool set_if_less(T1 &i, T2 v) {
  if (i < v) {
    i = v;
    return true;
  }
  return false;
}

template <typename T>
struct inc_max // incremental max
{
  T acc;
  inc_max(T iv = 0) : acc(iv) {}
  inc_max &operator<<=(T v) {
    if (v > acc)
      acc = v;
    return *this;
  }
       operator const T &() const { return acc; }
  void reset() { acc = 0; }
};
template <typename T>
struct inc_min // incremental max
{
  T acc;
  inc_min(T iv = limits<T>::max_value()) : acc(iv) {}
  inc_min &operator<<=(T v) {
    if (v < acc)
      acc = v;
    return *this;
  }
       operator const T &() const { return acc; }
  void reset() { acc = limits<T>::max_value(); }
};

template <typename T, size_t size1, size_t size2> inline bool equal(const T(&arr1)[size1], const T(&arr2)[size2]) {
  if (size1 != size2) return false;
  for (size_t n = 0; n < size1; ++n)
    if (arr1[n] != arr2[n]) return false;
  return true;
}

/****************************************************************************/

/*#ifndef max       // Hopefully this isn't already defined

  #define max(a,b)        (((a) > (b)) ? (a) : (b))

#endif*/

/****************************************************************************/

/*template <typename T>
  inline void
    swap ( T &arg1, T &arg2 )
  {
    T tmp = arg1;
    arg1 = arg2;
    arg2 = tmp;
  }*/

template <typename T>
inline void swop(T &arg1, T &arg2) // the same as above but with different name
{
  T tmp = arg1;
  arg1  = arg2;
  arg2  = tmp;
}

  /****************************************************************************/

#ifdef _DEBUG
#define _TODO_STR(x) #x
#define TODO_STR(x) _TODO_STR(x)
#define TODO(desc)                                                             \
  message(__FILE__ "(" TODO_STR(__LINE__) ") : warning TODO: " desc)
#else
#define TODO(desc)
#endif

//
// following is a correct implementation of the auto_ptr function
// described in the 3rd edition of Stroustrup's "The C++ Programming
// Language".
//

template <class X> class auto_ptr {
public:
  typedef X element_type;

  // constructor.
  explicit auto_ptr(X *_ptr = nullptr) : ptr(_ptr), owner(true) {}

  // a copy constructor from another instance of auto_ptr.
  template <class Y> auto_ptr(auto_ptr<Y> &r) : ptr(r.get()), owner(true) {
    r.release();
  }

  // the destructor deletes ptr only if we are the owner.
  ~auto_ptr() {
    if (owner && ptr)
      delete ptr;
  }

  // the copy assignment operator.
  auto_ptr<X> &operator=(const auto_ptr<X> &r) {
    if (static_cast<const void *>(this) != static_cast<const void *>(&r)) {
      if (owner && ptr)
        delete ptr;
      owner = r.owner;
      ptr   = r.release();
    }
    return *this;
  }

  // dereferencing returns the target of ptr.
  X &operator*() const { return *ptr; }
  X *operator->() const { return ptr; }
  X *get() const { return ptr; }

  operator bool() const { return ptr != nullptr; }

  // release returns the ptr value and releases ownership
  // if we were previously the owner.
  X *release() const {
    owner = false;
    return get();
  }

private:
  X *          ptr;
  mutable bool owner;
};

template <class c_key> unsigned int hash(const c_key &the_key);

template <typename T>
inline size_t copy(T *dst, size_t dst_elements, const T *src, size_t elements, __true_type) {
  assert(max(dst, src) >= min(dst + dst_elements, src + elements));

  size_t n = dst ? min(dst_elements, elements) : 0;
#ifdef WINDOWS
  memcpy_s(dst, dst_elements * sizeof(T), src,
           elements * sizeof(T)); // note memcpy_s is quite useless here as all
                                  // arguments are passed all checks already
#else
  assert(n == elements);
  memcpy(dst, src, n * sizeof(T));
#endif
  return n;
}

template <typename T>
inline size_t copy(T *dst, size_t dst_elements, const T *src, size_t elements, __false_type) {
  assert(max(dst, src) >= min(dst + dst_elements, src + elements));

  size_t n = min(dst_elements, elements);
  for (T *dst_end = dst + n; dst < dst_end; ++dst, ++src)
    *dst = *src;
  return n;
}

template <typename T>
inline void move(T *dst, const T *src, size_t elements, __true_type) {
#ifdef WINDOWS
  // solely to make Chris happy
  const size_t n = elements * sizeof(T);
  memmove_s(dst, n, src, n); // note memmove_s is useless here as all arguments
                             // are passed all checks already
#else
  memmove(dst, src, elements * sizeof(T));
#endif
}

template <typename T>
inline void move(T *dst, const T *src, size_t elements, __false_type ft) {

  T *      dst_end = dst + elements;
  const T *src_end = src + elements;

  if (max(src, dst) >= min(dst_end, src_end)) // ranges do not overlap
    copy(dst, dst_end - dst, src, elements, ft);
  else if (dst < src)
    for (; dst < dst_end; ++dst, ++src)
      *dst = *src;
  else if (dst > src) {
    T *dst_start = dst;
    dst          = dst_end - 1;
    src          = src_end - 1;
    for (; dst >= dst_start; --dst, --src)
      *dst = *src;
  }
}

template <typename T>
size_t move(T *dst, size_t dst_elements, size_t from, size_t to,  size_t elements) {
  
  if(!elements) return 0;
  
  assert(dst);
  if (!dst) return 0;

  size_t toe   = min(to + elements, dst_elements);
  size_t frome = min(from + elements, dst_elements);

  size_t n = (size_t)max(0, min(int_ptr(toe) - int_ptr(to), int_ptr(frome) - int_ptr(from)));
  assert(n == elements);

  typedef typename __type_traits<T>::has_trivial_copy_constructor Tr;
  move(dst + from, dst + to, n, Tr());
  return n;
}

template <typename T>
size_t copy(T *dst, size_t dst_elements, const T *src, size_t elements) {
  typedef typename __type_traits<T>::has_trivial_copy_constructor Tr;
  return copy(dst, dst_elements, src, elements, Tr());
}

template <typename T>
size_t transfer(T *dst, size_t dst_elements, T *src, size_t elements) {
  return copy(dst, dst_elements, src, elements);
}

template <typename T> void move(T *dst, const T *src, size_t elements) {
  typedef typename __type_traits<T>::has_trivial_copy_constructor Tr;
  move(dst, src, elements, Tr());
}

template <typename T> void init(T *dst, size_t elements, __true_type) {
  T t = T();
  for (T *dst_end = dst + elements; dst < dst_end; ++dst)
    *dst = t;
}
template <typename T> void init(T *dst, size_t elements, __false_type) {
  for (T *dst_end = dst + elements; dst < dst_end; ++dst)
    new ((void *)dst) T();
}

template <typename T> void init(T *dst, size_t elements) {
  typedef typename __type_traits<T>::has_trivial_default_constructor Tr;
  init(dst, elements, Tr());
}

template <typename T>
void erase(T * /*dst*/, size_t /*elements*/, __true_type) {
  // do nothing
}
template <typename T> void erase(T *dst, size_t elements, __false_type) {
  for (T *dst_end = dst + elements; dst < dst_end; ++dst)
    dst->~T();
}

template <typename T> void erase(T *dst, size_t elements) {
  typedef typename __type_traits<T>::has_trivial_destructor Tr;
  erase(dst, elements, Tr());
}

template <typename T1, typename T2> struct pair {
  T1 first;
  T2 second;

  pair() {}
  pair(const T1 &f, const T2 &s) : first(f), second(s) {}

  bool operator==(const pair &rs) const {
    return first == rs.first && second == rs.second;
  }
  bool operator!=(const pair &rs) const {
    return first != rs.first || second != rs.second;
  }

  void unpack(T1 &f, T2 &s) {
    f = first;
    s = second;
  }
};

#define items_in(a) (sizeof(a) / sizeof(a[0]))
// chars in sting literal
#define chars_in(s) (sizeof(s) / sizeof(s[0]) - 1)

inline dword make_dword(word h, word l) { return dword(h) << 16 | dword(l); }
inline dword make_dword(short h, short l) {
  return dword(word(h)) << 16 | dword(word(l));
}

inline word hiword(dword dw) { return static_cast<word>((dw >> 16) & 0xffff); }
inline word loword(dword dw) { return static_cast<word>(dw & 0xffff); }

inline short hishort(dword dw) {
  return static_cast<short>((dw >> 16) & 0xffff);
}
inline short loshort(dword dw) { return static_cast<short>(dw & 0xffff); }

inline dword hidword(uint64 dw) {
  return static_cast<dword>((dw >> 32) & 0xffffffff);
}
inline dword lodword(uint64 dw) { return static_cast<dword>(dw & 0xffffffff); }

inline uint64 make_qword(dword h, dword l) {
  return (uint64(h) << 32) | uint64(l);
}

inline bool get_bit(uint32 mask, uint32 v) { return (v & mask) != 0; }
inline void set_bit(uint32 mask, uint32 &v, bool on) {
  if (on)
    v |= mask;
  else
    v &= ~mask;
}

inline bool get_bit(uint64 mask, uint64 v) { return (v & mask) != 0; }
inline void set_bit(uint64 mask, uint64 &v, bool on) {
  if (on)
    v |= mask;
  else
    v &= ~mask;
}

inline bool get_nth_bit(uint32 v, int n) { return get_bit(1u << n, v); }
inline void set_nth_bit(uint32 &v, int n, bool on) { set_bit(1u << n, v, on); }

// remove element[s] from the SLL
template <typename N, typename F>
inline N l1_delete(N el, F filter, bool all = true) {
  // see if we are at end of list.
  if (el == nullptr)
    return nullptr;

  // Check to see if current node is one to be deleted.
  if (filter(el)) {
    // return the new pointer to where we were called from. I.e. the pointer the
    // previous call will use to "skip over" the removed node.
    return el->next;
  }
  // check the rest of the list, fixing the next pointer in case the next node
  // is the one removed.
  if (all)
    el->next = l1_delete(el->next, filter);
  return el;
}

template <typename T, class CMP>
inline void sort(T *arr, size_t arr_size, CMP cmp) {
  enum { quick_sort_threshold = 9 };

  if (arr_size < 2)
    return;

  T *e1;
  T *e2;

  int  stack[80];
  int *top   = stack;
  int  limit = int(arr_size);
  int  base  = 0;

  for (;;) {
    int len = limit - base;

    int i;
    int j;
    int pivot;

    if (len > quick_sort_threshold) {
      // we use base + len/2 as the pivot
      pivot = base + len / 2;
      swap(arr[base], arr[pivot]);

      i = base + 1;
      j = limit - 1;

      // now ensure that *i <= *base <= *j
      e1 = &(arr[j]);
      e2 = &(arr[i]);
      if (cmp(*e1, *e2))
        swap(*e1, *e2);

      e1 = &(arr[base]);
      e2 = &(arr[i]);
      if (cmp(*e1, *e2))
        swap(*e1, *e2);

      e1 = &(arr[j]);
      e2 = &(arr[base]);
      if (cmp(*e1, *e2))
        swap(*e1, *e2);

      for (;;) {
        do
          i++;
        while (i < int(arr_size) && cmp(arr[i], arr[base]));
        do
          j--;
        while (j >= 0 && cmp(arr[base], arr[j]));
        if (i > j) {
          j = max(0, j);
          break;
        }
        // do i++; while( cmp(arr[i],arr[base]) );
        // do j--; while( cmp(arr[base],arr[j]) );
        // if( i > j )
        //{
        //    break;
        //}
        swap(arr[i], arr[j]);
      }

      swap(arr[base], arr[j]);

      // now, push the largest sub-array
      if (j - base > limit - i) {
        top[0] = base;
        top[1] = j;
        base   = i;
      } else {
        top[0] = i;
        top[1] = limit;
        limit  = j;
      }
      top += 2;
    } else {
      // the sub-array is small, perform insertion sort
      j = base;
      i = j + 1;

      for (; i < limit; j = i, i++) {
        for (; cmp(*(e1 = &(arr[j + 1])), *(e2 = &(arr[j]))); j--) {
          swap(*e1, *e2);
          if (j == base) {
            break;
          }
        }
      }
      if (top > stack) {
        top -= 2;
        base  = top[0];
        limit = top[1];
      } else {
        break;
      }
    }
  }
}

template <typename T> struct comparator {
  comparator() {}
  bool operator()(const T &v1, const T &v2) { return v1 < v2; }
};

template <typename T> void sort(T *arr, size_t arr_size) {
  sort<T, comparator<T>>(arr, arr_size, comparator<T>());
}

// double linked list , use CRTP
template <typename T> struct l2elem {
  l2elem() { prune(); }

  l2elem<T> *_next;
  l2elem<T> *_prev;
  void       link_after(l2elem *after) {
    assert(is_empty());
    if (!is_empty())
      unlink();
    (_next = after->_next)->_prev = this;
    (_prev = after)->_next        = this;
  }
  void link_before(l2elem *before) {
    assert(is_empty());
    if (!is_empty())
      unlink();
    (_prev = before->_prev)->_next = this;
    (_next = before)->_prev        = this;
  }
  void unlink() {
    if (is_empty()) 
      return;
    _prev->_next = _next;
    _next->_prev = _prev;
    prune();
  }
  void prune() { _next = _prev = this; }
  bool is_empty() const { return _next == this && _prev == this; };

  inline T *next() const { return static_cast<T *>(_next); }
  inline T *prev() const { return static_cast<T *>(_prev); }
};

#if defined(WINDOWS)
inline void beep() { 
  MessageBeep(MB_ICONEXCLAMATION); 
}
inline void sleep(uint ms) { Sleep(ms); }
#else
inline void beep() { putchar(7); }
inline void sleep(uint ms) {
  std::this_thread::sleep_for(std::chrono::milliseconds(ms));
}
#endif

inline uint rotl(uint n) {
  return (n << 1) | (n >> (sizeof(n) * CHAR_BIT - 1));
}

template <class T> struct vector_allocator {
  static T *  allocate(uint num) { return new T[num]; }
  static void deallocate(T *ptr, uint) { delete[] ptr; }
};

template <int N> struct power10 {
  static const int value = 10 * power10<N - 1>::value;
};
template <> struct power10<0> { static const int value = 1; };

#pragma pack(push, 4) // IT MUST BE 4 bytes aligned!!!!
template <typename BASE, int D = 3> struct fixed {
  typedef typename std::conditional<sizeof(BASE) < sizeof(double), int,
                                    long long>::type data_t;

  data_t data;

  fixed() : data(0) {}
  fixed(const fixed &t) : data(t.data) {}
  fixed(BASE b) { data = data_t((b * power10<D>::value)); }
  fixed(data_t d) { data = d * power10<D>::value; }
  operator BASE() const { return BASE(data) / power10<D>::value; }

  fixed &operator=(fixed b) {
    data = b.data;
    return *this;
  }
  fixed operator+(fixed b) const { return raw(data + b.data); }
  fixed operator-(fixed b) const { return raw(data - b.data); }
  fixed operator*(fixed b) const { return BASE(*this) * BASE(b); }
  fixed operator/(fixed b) const { return BASE(*this) / BASE(b); }

  fixed &operator+=(fixed b) {
    data += b.data;
    return *this;
  }
  fixed &operator-=(fixed b) {
    data -= b.data;
    return *this;
  }
  fixed &operator*=(fixed b) {
    data = fixed(BASE(*this) * BASE(b)).data;
    return *this;
  }
  fixed &operator/=(fixed b) {
    data = fixed(BASE(*this) / BASE(b)).data;
    return *this;
  }

  bool operator==(fixed b) const { return data == b.data; }
  bool operator!=(fixed b) const { return data != b.data; }
  bool operator<(fixed b) const { return data < b.data; }
  bool operator>(fixed b) const { return data > b.data; }
  bool operator<=(fixed b) const { return data <= b.data; }
  bool operator>=(fixed b) const { return data >= b.data; }

  unsigned int hash() const { return tool::hash(data); }

protected:
  static fixed raw(data_t t) {
    fixed d;
    d.data = t;
    return d;
  }
};
#pragma pack(pop)

struct exception {
  char message[256];
  exception(const char *msg) throw() {
    if (msg)
#ifdef WINDOWS
      strncpy_s(message, msg, 256);
#else
      strncpy(message, msg, 256);
#endif
    else
      message[0] = 0;
  }
  const char *what() const throw() { return message; }
};

} // namespace tool

//|
//| Search binary data using HORSPOOL algorithm (modified Boyer-Moore)
//| see http://www-igm.univ-mlv.fr/~lecroq/string/node18.html
//| SYNOPSIS:
//|   where - source data, src_length - source data byte length (bytes)
//|   what - data to be sought, what_length - sought data length (bytes)
//| RETURNS:
//|   0 if not found or address of 'what' data if found.
//|

const void *mem_lookup(const void *where, size_t where_length, const void *what,
                       size_t what_length);

inline const char *strnstr(const char *src, size_t src_length,
                           const char *search) {
  return (const char *)mem_lookup(src, src_length, search, strlen(search));
}

inline void memzero(void *p, size_t sz) { memset(p, 0, sz); }

template <typename T> inline void memzero(T &t) { memzero(&t, sizeof(T)); }

template <typename T> inline void struct_zero(T &t) {
  memzero(&t, sizeof(T));
  t.cbSize = sizeof(T);
}

// strtod, modified version of http://www.jbox.dk/sanos/source/lib/strtod.c.html
// reason: strtod is locale dependent.
template <typename TC> inline double str_to_d(const TC *str, TC **endptr) {
  double number;
  int    exponent;
  int    negative;
  TC *   p = (TC *)str;
  double p10;
  int    n;
  int    num_digits;
  int    num_decimals;

  // Skip leading whitespace
  while (is_space(*p))
    p++;

  // Handle optional sign
  negative = 0;
  switch (*p) {
  case '-':
    negative = 1; // Fall through to increment position
  case '+':
    p++;
  }

  number       = 0.;
  exponent     = 0;
  num_digits   = 0;
  num_decimals = 0;

  // Process string of digits
  while (is_digit(*p)) {
    number = number * 10. + (*p - '0');
    p++;
    num_digits++;
  }

  // Process decimal part
  if (*p == '.') {
    p++;

    while (is_digit(*p)) {
      number = number * 10. + (*p - '0');
      p++;
      num_digits++;
      num_decimals++;
    }

    exponent -= num_decimals;
  }

  if (num_digits == 0) {
    if (endptr)
      *endptr = p;
    return 0.0;
  }

  // Correct for sign
  if (negative)
    number = -number;

  // Process an exponent string
  if (*p == 'e' || *p == 'E') {
    // Handle optional sign
    negative = 0;
    switch (*++p) {
    case '-':
      negative = 1; // Fall through to increment pos
    case '+':
      p++;
    default:
      if (!is_digit(*p)) {
        --p;
        goto NO_EXPONENT;
      }
    }

    // Process string of digits
    n = 0;
    while (is_digit(*p)) {
      n = n * 10 + (*p - '0');
      p++;
    }

    if (negative)
      exponent -= n;
    else
      exponent += n;
  }

  if (exponent < DBL_MIN_EXP || exponent > DBL_MAX_EXP) {
    if (endptr)
      *endptr = p;
    return HUGE_VAL;
  }
NO_EXPONENT:
  // Scale the result
  p10 = 10.;
  n   = exponent;
  if (n < 0)
    n = -n;
  while (n) {
    if (n & 1) {
      if (exponent < 0)
        number /= p10;
      else
        number *= p10;
    }
    n >>= 1;
    p10 *= p10;
  }
  if (endptr)
    *endptr = p;
  return number;
}

unsigned int crc32(const unsigned char *buffer, unsigned int count);

#define REVERSE_BYTE_BITS(a)                                                   \
  ((a << 7) & (1 << 7)) | ((a << 5) & (1 << 6)) | ((a << 3) & (1 << 5)) |      \
      ((a << 1) & (1 << 4)) | ((a >> 7) & (1 << 0)) | ((a >> 5) & (1 << 1)) |  \
      ((a >> 3) & (1 << 2)) | ((a >> 1) & (1 << 3))

/* Integer square root by Halleck's method, with Legalize's speedup */
inline long isqrt(long x) {
  long squaredbit, remainder, root;
  if (x < 1)
    return 0;

  /* Load the binary constant 01 00 00 ... 00, where the number
   * of zero bits to the right of the single one bit
   * is even, and the one bit is as far left as is consistant
   * with that condition.)
   */
  squaredbit =
      (long)((((unsigned long)~0L) >> 1) & ~(((unsigned long)~0L) >> 2));
  /* This portable load replaces the loop that used to be
   * here, and was donated by  legalize@xmission.com
   */

  /* Form bits of the answer. */
  remainder = x;
  root      = 0;
  while (squaredbit > 0) {
    if (remainder >= (squaredbit | root)) {
      remainder -= (squaredbit | root);
      root >>= 1;
      root |= squaredbit;
    } else {
      root >>= 1;
    }
    squaredbit >>= 2;
  }
  return root;
}

inline uint rand(uint &rseed, uint maxn = 0) {
  if (rseed == 0)
    rseed = (uint)time(0);

  // make sure we don't get stuck at zero
  if (rseed == 0)
    rseed = 1;

  // algorithm taken from Dr. Dobbs Journal, November 1985, page 91
  uint k1 = rseed / 127773L;
  rseed   = 16807L * (rseed - k1 * 127773L) - k1 * 2836L;

  // return a random number between 0 and maxn-1
  return maxn ? (rseed % maxn) : rseed;
}

// "mangle" memory block
inline void mangle(uint pwd, byte *data, uint data_length) {
  uint rseed = pwd;
  for (uint n = 0; n < data_length; ++n)
    data[n] ^= rand(rseed, 256);
}

extern "C" void _dprintf(const char *fmt, ...);

#if defined(DEBUG)
#define dbg_printf _dprintf
#else
// inline void _dprintf(const char*, ...) {}
#define dbg_printf 1 ? (void)0 : _dprintf
#endif

#ifdef DEBUG
#define ASSERT(cond)                                                           \
  do {                                                                         \
    if (!(cond)) {                                                             \
      dbg_printf("ASSERTION: %s at %s(%d)\n", #cond, __FILE__, __LINE__, 0);   \
      __debugbreak();                                                          \
      throw tool::exception(#cond);                                            \
    }                                                                          \
  } while (0)
#else
#define ASSERT(cond)                                                           \
  do {                                                                         \
    if (!(cond)) {                                                             \
      throw tool::exception(#cond);                                            \
    }                                                                          \
  } while (0)
#endif

#ifdef DEBUG_RELEASE
class log4 {
protected:
  FILE *file;
  log4() : file(0) {
    char executableFilePath[MAX_PATH];
    ::GetModuleFileName(NULL, executableFilePath, MAX_PATH);
    char *executableFileName = ::strrchr(executableFilePath, '\\');
    char *lastDot            = ::strrchr(executableFileName, '.');
    strcpy(lastDot, ".log");
    file = fopen(executableFilePath, "wt");
  }
  static log4 &inst() {
    static log4 _inst;
    return _inst;
  }

public:
  ~log4() { fclose(file); }
  static void printf(const char *fmt, ...) {
    va_list args;
    va_start(args, fmt);
    vfprintf(inst().file, fmt, args);
    va_end(args);
  }
};
#endif

#define ENABLE_BIT_ENUM_OPERATORS(ET, IT)                                      \
  inline ET  operator~(ET v) { return ET(~IT(v)); }                            \
  inline ET  operator|(ET v1, ET v2) { return ET(IT(v1) | IT(v2)); }           \
  inline ET &operator|=(ET &v1, ET v2) {                                       \
    v1 = v1 | v2;                                                              \
    return v1;                                                                 \
  }                                                                            \
  inline ET  operator&(ET v1, ET v2) { return ET(IT(v1) & IT(v2)); }           \
  inline ET &operator&=(ET &v1, ET v2) {                                       \
    v1 = v1 & v2;                                                              \
    return v1;                                                                 \
  }                                                                            \
  inline ET  operator^(ET v1, ET v2) { return ET(IT(v1) ^ IT(v2)); }           \
  inline ET &operator^=(ET &v1, ET v2) {                                       \
    v1 = v1 ^ v2;                                                              \
    return v1;                                                                 \
  }

#define ENABLE_INC_ENUM_OPERATORS(ET, IT)                                      \
  inline ET &operator++(ET &v) {                                               \
    v = ET(IT(v) + 1);                                                         \
    return v;                                                                  \
  }                                                                            \
  inline ET &operator--(ET &v) {                                               \
    v = ET(IT(v) - 1);                                                         \
    return v;                                                                  \
  }                                                                            \
  inline ET operator++(ET &v, int) {                                           \
    ET tmp = v;                                                                \
    v      = ET(IT(v) + 1);                                                    \
    return tmp;                                                                \
  }                                                                            \
  inline ET operator--(ET &v, int) {                                           \
    ET tmp = v;                                                                \
    v      = ET(IT(v) - 1);                                                    \
    return tmp;                                                                \
  }

//
// enum TTT { a = 0x1, b = 0x2, c = 0x4 };
// ENABLE_BIT_ENUM_OPERATORS(TTT, uint)
// TTT t = a | b;
//

#endif
