#ifndef __REX_H__
#define __REX_H__

#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <wchar.h>

/* Regex flags */
#define REX_FLAG_G 1 /* Global - match in the whole string */
#define REX_FLAG_I 2 /* Ignore case */
#define REX_FLAG_M 4 /* Multiline */

typedef unsigned int ucodepoint;
#if defined(WIN32) || defined(WIN64)
typedef wchar_t wchar;
#else
typedef char16_t wchar;
#endif

/* Describes single capture */
struct rex_cap {
  const wchar *start; /* points to the beginning of the capture group */
  const wchar *end;   /* points to the end of the capture group */
};

/* Describes all captures */
#define REX_MAX_CAPS 64
struct rex_loot {
  int            num_captures;
  struct rex_cap caps[REX_MAX_CAPS];
};

/* Opaque structure that holds compiled regular expression */
struct rex_prog;

/* Return codes for rex_compile() */
enum rex_error {
  REX_OK,
  REX_INVALID_DEC_DIGIT,
  REX_INVALID_HEX_DIGIT,
  REX_INVALID_ESC_CHAR,
  REX_UNTERM_ESC_SEQ,
  REX_SYNTAX_ERROR,
  REX_UNMATCH_LBR,
  REX_UNMATCH_RBR,
  REX_NUM_OVERFLOW,
  REX_INF_LOOP_M_EMP_STR,
  REX_INV_CHARSET_RANGE,
  REX_MALFORMED_CHARSET,
  REX_INVALID_BACK_REFERENCE,
  REX_TOO_MANY_CAPTURES,
  REX_INVALID_QUANTIFIER,
  REX_BAD_CHAR_AFTER_USD
};

const char *rex_errmsg(int r);

int rex_compile(const wchar *pat, size_t pat_len, int flags, rex_prog **pr, bool is_regex);
int rex_exec(rex_prog *prog, int flag_g, const wchar *start, const wchar *end, rex_loot *loot);

void rex_free(struct rex_prog *prog);

int rex_match(const wchar *re, size_t re_len, int flags, const wchar *str,
              size_t str_len, struct rex_loot *loot);
int rex_replace(struct rex_loot *loot, const wchar *src, size_t src_len,
                const wchar *replace, size_t rep_len, struct rex_loot *dst);
int rex_get_flags(struct rex_prog *);
int rex_get_captures(struct rex_prog *);

#endif //__REX_H__