#include "config.h"

#include "targetver.h"

/*#if !defined(WINVER) || (WINVER < 0x0602)
#undef WINVER
#undef _WIN32_WINNT

#define WINVER 0x0602
#define _WIN32_WINNT 0x0602
#endif*/

#include "tool.h"

#include "tl_com.h"
#include "tl_spell_checker.h"

#ifdef SPELL_CHECK_SUPPORT
#include <spellcheck.h>
#endif

namespace tool {

#ifdef SPELL_CHECK_SUPPORT

struct spell_checker_impl : public spell_checker {
  com::asset<ISpellChecker> checker;

  virtual bool check_spelling(const ustring &        text,
                              spell_check_callback_t cb) override {

    com::asset<IEnumSpellingError> errors;

    bool spell_ok = true;

    if (SUCCEEDED(checker->Check(text, errors.target())))
    // use if(SUCCEEDED(checker->ComprehensiveCheck(text,errors.target()))) for
    // AUTO_REPLACEMENTs
    {
      for (;;) {
        com::asset<ISpellingError> error;
        if (errors->Next(error.target()) != S_OK)
          break;

        CORRECTIVE_ACTION action = CORRECTIVE_ACTION_REPLACE;
        ULONG             start  = 0;
        ULONG             length = 0;
        ustring           replacement;

        error->get_StartIndex(&start);
        error->get_Length(&length);
        error->get_CorrectiveAction(&action);

        if (action == CORRECTIVE_ACTION_REPLACE) {
          wchar_t *repl = nullptr;
          if (SUCCEEDED(error->get_Replacement(&repl))) {
            replacement = repl;
            CoTaskMemFree(repl);
          }
        }

        cb((SPELL_CORRECTIVE_ACTION)action, start, length, replacement);
        spell_ok = false;
      }
    }
    return spell_ok;
  }

  virtual array<ustring> get_suggestions_for(const ustring &text) {
    array<ustring>          list;
    com::asset<IEnumString> suggestions;

    if (SUCCEEDED(checker->Suggest(text.c_str(), suggestions.target()))) {
      for (;;) {
        wchar_t *suggestion = nullptr;
        if (S_OK != suggestions->Next(1, &suggestion, nullptr))
          break;
        list.push(ustring(suggestion));
        CoTaskMemFree(suggestion);
      }
    }
    return list;
  }
};

struct spell_checker_factory_impl : public spell_checker_factory {
  com::asset<ISpellCheckerFactory> factory;

  virtual spell_checker *
  spell_checker_factory::create(const ustring &lang) override {
    com::asset<ISpellChecker> checker;

    if (FAILED(factory->CreateSpellChecker(lang.c_str(), checker.target())))
      return nullptr;

    spell_checker_impl *pimp = new spell_checker_impl();
    pimp->checker            = checker;

    return pimp;
  }
};

spell_checker_factory *spell_checker_factory::create_factory() {

  com::asset<ISpellCheckerFactory> factory;

  CoCreateInstance(__uuidof(SpellCheckerFactory), nullptr, CLSCTX_INPROC_SERVER,
                   __uuidof(factory),
                   reinterpret_cast<void **>(factory.target()));
  if (!factory)
    return nullptr;

  spell_checker_factory_impl *pimpl = new spell_checker_factory_impl;
  pimpl->factory                    = factory;

  return pimpl;
}
#else
spell_checker_factory *spell_checker_factory::create_factory() {
  return nullptr;
}

#endif
}