
#import <Cocoa/Cocoa.h>
#import <dispatch/dispatch.h>

#include "tool.h"
#include "tl_spell_checker.h"

extern tool::ustring cvt (NSString* s);
extern NSString* cvt (const tool::ustring& s);

namespace tool
{

#ifdef SPELL_CHECK_SUPPORT  
  
  struct spell_checker_impl : public spell_checker 
  {
    NSSpellChecker* checker;
      
    enum _ { MAX_SUGGESTIONS = 6 };
      
    spell_checker_impl() : checker(NULL) {}

    ~spell_checker_impl()
    {
      //if( checker )
      //  [checker release]; -- shared spell checker is used now
    }
    
    virtual bool check_spelling(const ustring& text, spell_check_callback_t cb) override
    {

       bool spell_ok = true;
        
       //@autoreleasepool {
       
          NSString* misspelling = cvt(text);
       
          for( uint pos = 0; pos < text.length(); )
          {
            NSRange range = [this->checker checkSpellingOfString:misspelling startingAt:pos language: [checker language] wrap:NO inSpellDocumentWithTag:0 wordCount: NULL];
              
            if( range.length == 0)
              break;
           
            cb(SPELL_CORRECTIVE_ACTION_GET_SUGGESTIONS, uint(range.location), uint(range.length), ustring());
              
            pos = uint(range.location + range.length);
              
            spell_ok = false;
          }
       //}
       return spell_ok;
    }

    virtual array<ustring> get_suggestions_for(const ustring& text) override
    {
      array<ustring> list;
      //@autoreleasepool {
         NSString* misspelling = cvt(text);
         NSString* language = [this->checker language];
         NSRange range;
            
         range.location = 0;
         range.length = [misspelling length];
            
         NSArray* guesses = [this->checker guessesForWordRange:range inString:misspelling language:language inSpellDocumentWithTag:0];

         int n = min( int(guesses.count), int(MAX_SUGGESTIONS) );
          
         list.size( n );
            
         for (int i = 0; i < n; ++i) {
             list[i] = cvt((NSString*)[guesses objectAtIndex:i]);
         }
        if(misspelling)
          [misspelling release];
      //}
      return list;
    }
  };

  struct spell_checker_factory_impl : public spell_checker_factory 
  {
    virtual spell_checker* create(const ustring& lang) override
    {
      spell_checker_impl* pimp = new spell_checker_impl();
       
      pimp->checker = //[[NSSpellChecker alloc] init];
                      [NSSpellChecker sharedSpellChecker];
      [pimp->checker setAutomaticallyIdentifiesLanguages: NO];
        
      //@autoreleasepool {
        NSString* language = cvt(lang);
        if([pimp->checker setLanguage: language] != YES)
        {
            delete pimp;
            return nullptr;
        }
      //}
      
      return pimp;
    }

  };
  
  spell_checker_factory* spell_checker_factory::create_factory() 
  {
    spell_checker_factory_impl* pimpl = new spell_checker_factory_impl;
    return pimpl;
  }
#else
  spell_checker_factory* spell_checker_factory::create_factory() 
  {
    return nullptr;
  }
#endif

}
