//
//  osx-tool-bridge.mm
//  sciter
//
//  Created by andrew on 2014-03-18.
//  Copyright (c) 2014 andrew. All rights reserved.
//

#include "tool/tool.h"
//#if defined(SCITER)
//#include "osx-sciter.h"
//#endif
//#include "osx-mm.h"
//#include "osx-cvt.h"

tool::ustring osx_user_name()
{
    return cvt(NSUserName());
}

CFStringRef cfstr(tool::wchars text) {
    
    return CFStringCreateWithBytes (
                                    NULL,
                                    (const UInt8 *) text.start,
                                    text.length * sizeof(wchar),
#if __LITTLE_ENDIAN__
                                    kCFStringEncodingUTF16LE,
#else
                                    kCFStringEncodingUTF16BE,
#endif
                                    false);
}

CFStringRef cfstr(tool::chars text) {
    
    return CFStringCreateWithBytes (
                                    NULL,
                                    (const UInt8 *) text.start,
                                    text.length,
                                    kCFStringEncodingUTF8,
                                    false);
}


static tool::ustring get_locale_value (CFStringRef key)
{
    CFLocaleRef cfLocale = CFLocaleCopyCurrent();
    const tool::ustring result (cvt ((CFStringRef) CFLocaleGetValue (cfLocale, key)));
    CFRelease (cfLocale);
    return result;
}

tool::ustring osx_user_language()   { return get_locale_value (kCFLocaleLanguageCode); }
tool::ustring osx_user_region()     { return get_locale_value (kCFLocaleCountryCode); }

tool::ustring osx_display_language()
{
    CFArrayRef cfPrefLangs = CFLocaleCopyPreferredLanguages();
    const tool::ustring result = cvt((CFStringRef) CFArrayGetValueAtIndex (cfPrefLangs, 0));
    CFRelease (cfPrefLangs);
    return result;
}

tool::ustring osx_os_name() {
    
   @autoreleasepool {
     NSProcessInfo *pinfo = [NSProcessInfo processInfo];
     if([pinfo respondsToSelector : @selector(operatingSystemVersion)])
     {
       NSOperatingSystemVersion pver = [pinfo operatingSystemVersion];
       return tool::ustring::format(W("MacOS %d.%d.%d"),pver.majorVersion,pver.minorVersion,pver.patchVersion);
     }
     else {
     //NSArray *myarr = [[pinfo operatingSystemVersionString] componentsSeparatedByString:@" "];
     //NSString *version = [@"MacOSX " stringByAppendingString:[myarr objectAtIndex:1]];
       return cvt([pinfo operatingSystemVersionString]);
     }
   }
    
  /*@autoreleasepool
  {
    NSDictionary* dict = [NSDictionary dictionaryWithContentsOfFile:
                         @"/System/Library/CoreServices/SystemVersion.plist"];
    return cvt ([dict objectForKey: @"ProductVersion"]);
  }*/
   
}

tool::ustring cvt (NSString* s)
{
  if(!s) return tool::ustring();
  long length = [s length];
  tool::ustring us(' ',int(length));
  NSRange nr; nr.length = length; nr.location = 0;
  [s getCharacters: (unichar *)us.buffer() range:nr];
  return us;
  //return tool::ustring([s cStringUsingEncoding: NSUnicodeStringEncoding]);
}

NSString* cvt (const tool::ustring& s)
{
  //return [NSString stringWithCString: (const char*)s.c_str() encoding:NSUTF16LittleEndianStringEncoding];
  return [NSString stringWithCharacters:(const unichar *)s.c_str() length: s.size()];
}

NSString* cvt (tool::wchars s)
{
    //return [NSString stringWithCString: (const char*)s.c_str() encoding:NSUTF16LittleEndianStringEncoding];
    return [NSString stringWithCharacters:(const unichar *)s.start length: s.size()];
}

/*tool::string to_osx_file_name(tool::wchars s) {
    NSString* fn = cvt(s);
    char buffer[2048] = {0};
    [fn getFileSystemRepresentation:buffer maxLength:items_in(buffer)];
    return buffer;
}

#ifdef OSX
  string  path = to_osx_file_name(upath);
#else
  string  path  = u8::cvt(upath);
#endif*/

FILE *wfopen(LPCWSTR filename, LPCWSTR mode) {
  CFStringRef fn = cfstr(tool::chars_of(filename));
  char buffer[2048] = {0};
  CFStringGetFileSystemRepresentation(fn, buffer, items_in(buffer));
  CFRelease(fn);
  return fopen(buffer, tool::u8::cvt(tool::chars_of(mode)));
}
int   wopen(LPCWSTR filename, int flags, int mode) {
  CFStringRef fn = cfstr(tool::chars_of(filename));
  char buffer[2048] = {0};
  CFStringGetFileSystemRepresentation(fn, buffer, items_in(buffer));
  CFRelease(fn);
  return open(buffer, flags, mode);
}

NSString* ns_string_literal (const char* const s)
{
    return [NSString stringWithUTF8String: s];
}

//inline NSString* nsEmptyString() noexcept
//{
//    return [NSString string];
//}

tool::ustring cvt(CFStringRef theString)
{
    if(!theString) return tool::ustring();
    CFIndex utf16len = CFStringGetLength (theString);
    tool::ustring us( ' ', int(utf16len));
    CFRange range;
    range.location = 0;
    range.length = utf16len;
    CFStringGetCharacters(theString,range, (UniChar *) us.buffer() );
    return us;
    
//    return (const wchar*)CFStringGetCStringPtr(theString,NSUnicodeStringEncoding);
}

tool::ustring osx_get_exe_path() {
    return cvt([[NSBundle mainBundle] executablePath]);
}

tool::ustring osx_date_format(tool::ustring locale, double seconds1970, const wchar* utfmt)
{
    //return tool::ustring();
   
    @autoreleasepool {
        
        NSLocale *nslocale = [NSLocale localeWithLocaleIdentifier: cvt(locale)];
        if(!nslocale) return tool::ustring();

        NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
        dateFormatter.locale = nslocale;
       
        NSString* format = cvt( tool::ustring(utfmt) );
        [dateFormatter setDateFormat: format];
        [dateFormatter setTimeZone: [NSTimeZone timeZoneForSecondsFromGMT: 0 ]];
        
        NSDate *date = [NSDate dateWithTimeIntervalSince1970: seconds1970 ];

        NSString *formattedDateString = [dateFormatter stringFromDate:date];
        //NSLog(@"formattedDateString: %@", formattedDateString);
        return cvt(formattedDateString);
    }
 
}

tool::ustring osx_date_tostring(tool::ustring locale,double seconds1970, bool full, tool::date_time::PARTS parts)
{
    //return tool::ustring();
    
    @autoreleasepool {
        
        NSDateFormatterStyle dateStyle = NSDateFormatterNoStyle;
        NSDateFormatterStyle timeStyle = NSDateFormatterNoStyle;
        
        if( parts & tool::date_time::DATE )
            dateStyle = full? NSDateFormatterLongStyle : NSDateFormatterShortStyle;
        if( parts & tool::date_time::TIME )
            timeStyle = full? NSDateFormatterLongStyle : NSDateFormatterShortStyle;

        NSLocale *nslocale = [NSLocale localeWithLocaleIdentifier: cvt(locale)];
        if(!nslocale) return tool::ustring();

        NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
        dateFormatter.locale = nslocale;
        
        [dateFormatter setDateStyle: dateStyle ];
        [dateFormatter setTimeStyle: timeStyle ];
        [dateFormatter setTimeZone: [NSTimeZone timeZoneForSecondsFromGMT: 0 ]];
        
        NSDate *date = [NSDate dateWithTimeIntervalSince1970: seconds1970 ];
        
        NSString *formattedDateString = [dateFormatter stringFromDate:date];
        //NSLog(@"formattedDateString: %@", formattedDateString);
        return cvt(formattedDateString);
    }
    
}

tool::ustring osx_week_day_name(tool::ustring locale, int n, int maxlength) {
    @autoreleasepool {
        NSLocale *nslocale = [NSLocale localeWithLocaleIdentifier: cvt(locale)];
        if(!nslocale) return tool::ustring();

        NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
        dateFormatter.locale = nslocale;

        NSArray* names;
        
        if( maxlength <= 2 )
            names = [dateFormatter veryShortWeekdaySymbols];
        else if( maxlength <= 4 )
            names = [dateFormatter shortWeekdaySymbols];
        else
            names = [dateFormatter weekdaySymbols];

        //NSLog(@"formattedDateString: %@", formattedDateString);
        n = (n + 1) % 7;
        
        return cvt( (NSString*) [names objectAtIndex: n ]);
    }
    
}

int osx_first_day_of_week(tool::ustring locale) {
    
  @autoreleasepool {
      
    NSCalendar* nscalendar = [NSCalendar calendarWithIdentifier:NSCalendarIdentifierGregorian];
    
    NSLocale *nslocale = [NSLocale localeWithLocaleIdentifier: cvt(locale)];
    if(!nslocale) return 1;

    nscalendar.locale = nslocale;
    
    int n = (int) nscalendar.firstWeekday;
    return (n + 5) % 7 ;
  }
}

void osx_locale_date_format(tool::ustring locale,tool::date_time::date_format_order &order, wchar& separator)
{
    order = tool::date_time::date_format_order::MDY;
    separator = '/';

    @autoreleasepool {

        NSLocale *nslocale = [NSLocale localeWithLocaleIdentifier: cvt(locale)];
        if(!nslocale) return;

        NSString *dateFormat = [NSDateFormatter dateFormatFromTemplate:@"ddMMy" options:0 locale:nslocale];

        NSRange d_idx = [dateFormat rangeOfString:@"d"];
        NSRange m_idx = [dateFormat rangeOfString:@"M"];
        NSRange y_idx = [dateFormat rangeOfString:@"y"];

        if (d_idx.location == NSNotFound || m_idx.location == NSNotFound || y_idx.location == NSNotFound) {
            return;
        }

        if (d_idx.location < m_idx.location && m_idx.location < y_idx.location) {
            order = tool::date_time::date_format_order::DMY;
            separator = [dateFormat characterAtIndex: d_idx.location + 2];
        }
        else if (y_idx.location < m_idx.location && m_idx.location < d_idx.location) {
            order = tool::date_time::date_format_order::YMD;
            separator = [dateFormat characterAtIndex: m_idx.location - 1];
        }
        else {
            separator = [dateFormat characterAtIndex: d_idx.location + 2];
        }

        if (!CHARS("/.- ").contains(separator))
          separator = '/';
    }
}

void osx_locale_time_format(tool::ustring locale,tool::date_time::time_format_hours &hours,
                            tool::date_time::time_format_marker_pos &marker_pos,
                            tool::ustring &am, tool::ustring &pm)
{
    hours = tool::date_time::time_format_hours::H_12;
    marker_pos = tool::date_time::time_format_marker_pos::MP_AFTER;
    
    @autoreleasepool {

        NSLocale *nslocale = [NSLocale localeWithLocaleIdentifier: cvt(locale)];
        if(!nslocale) return;

        NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
        dateFormatter.locale = nslocale;
        am = cvt(dateFormatter.AMSymbol);
        pm = cvt(dateFormatter.PMSymbol);

        NSString *timeFormat = [NSDateFormatter dateFormatFromTemplate:@"jjmm" options:0 locale:nslocale];
        NSRange h_idx = [timeFormat rangeOfString:@"h"];
        if (h_idx.location != NSNotFound) {
            NSRange m_idx = [timeFormat rangeOfString:@"a"];
            if (m_idx.location != NSNotFound && m_idx.location < h_idx.location) {
                marker_pos = tool::date_time::time_format_marker_pos::MP_BEFORE;
            }
        }
        else {
            hours = tool::date_time::time_format_hours::H_24;
        }
    }
}

tool::ustring osx_month_name(tool::ustring locale, int monthNumber0) {
  @autoreleasepool {
    NSLocale *nslocale = [NSLocale localeWithLocaleIdentifier: cvt(locale)];
    if(!nslocale) return tool::ustring();

    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    dateFormatter.locale = nslocale;
      
    NSString *monthName = [[dateFormatter monthSymbols] objectAtIndex:monthNumber0];
    return cvt(monthName);
  }
}
namespace tool
{
  ustring  get_standard_dir(STANDARD_DIR sd)
  {
      NSSearchPathDirectory   type;
      NSSearchPathDomainMask  forwhom = NSUserDomainMask;

/*
 APPLICATIONS_DIR,
 USER_APPDATA_DIR,
 USER_HOME_DIR,
 USER_DESKTOP_DIR,
 USER_DOWNLOADS_DIR,
 USER_DOCUMENTS_DIR,
 USER_MUSIC_DIR,
 USER_VIDEO_DIR,
 USER_PICTURES_DIR,
 USER_ROOT_DIR,*/
      
      switch(sd) {
          default:
          case APPLICATIONS_DIR: type = NSApplicationDirectory; forwhom = NSLocalDomainMask; break;
          case USER_APPDATA_DIR: type = NSLibraryDirectory; break;
          case USER_DOCUMENTS_DIR: type = NSDocumentDirectory; break;
          case USER_HOME_DIR: return cvt(NSHomeDirectory());
          case USER_DOWNLOADS_DIR: type = NSDownloadsDirectory; break;
          case USER_DESKTOP_DIR: type = NSDesktopDirectory; break;
          case USER_MUSIC_DIR: type = NSMusicDirectory; break;
          case USER_VIDEO_DIR: type = NSMoviesDirectory; break;
          case USER_PICTURES_DIR: type = NSPicturesDirectory; break;
          case USER_ROOT_DIR: return WCHARS("/");
      }
      
      NSArray* res = NSSearchPathForDirectoriesInDomains ( type, forwhom, YES );
      NSString* first = [res firstObject];
      if( first )
          return cvt(first);
      assert(false);
      return ustring();
  }
    
  


}


