
#include "tool/tool.h"

#if !defined(WINDOWS) && !defined(OSX)

#include <unistd.h>
#include <locale.h>
#include <sys/utsname.h>

namespace tool {

  namespace environment {

    ustring user_name() { return ustring(); }

    ustring machine_name(bool full) { return ustring(); }

    bool get_lang_country(ustring &lang, ustring &country, bool for_user) 
    {
      const char *langstr = getenv("LANG");
      if (!langstr) return false;

      chars clang = chars_of(langstr);
      if (clang.length < 5) return false;

      lang    = ustring(clang(0, 2));
      country = ustring(clang(3, 5));

      return true;
    }

    int get_os_version() {
#ifdef ANDROID
      return SOME_ANDROID;
#else
      return SOME_LINUX;
#endif
    }

    const char *get_os_version_name() {
      static string os_name;

      if (os_name.length()) return os_name;

      utsname buf = {0};
      if (0 == uname(&buf)) {
        os_name = string::format("%s-%s", buf.sysname, buf.release);
      } else
        os_name = "Linux-Unknown";
      return os_name;
    }

  } // namespace environment

  ustring get_standard_dir(STANDARD_DIR sd) {
#ifndef WINDOWLESS
    switch (sd) {
      default:
      case SYSTEM_DIR:
      case SYSTEM_BIN_DIR:
        return g_get_home_dir(); // TODO ?????????????????????????
      case PROGRAM_FILES_DIR:
        return g_get_home_dir(); // TODO  ?????????????????????????
      case USER_APPDATA_DIR:
      case COMMON_APPDATA_DIR: return g_get_user_config_dir();
      case USER_DOCUMENTS_DIR:
      case COMMON_DOCUMENTS_DIR:
        return g_get_user_special_dir(G_USER_DIRECTORY_DOCUMENTS);
      case DOWNLOADS_DIR:
        return g_get_user_special_dir(G_USER_DIRECTORY_DOWNLOAD);
    }
#endif
    return ustring();
  }

} // namespace tool
#endif

/*
spell_checker_factory *spell_checker_factory::create_factory() {
  return nullptr;
}
*/
