#include <gtk/gtk.h>

#include <unistd.h>
#include <locale.h>
#include <sys/utsname.h>

#include "tool/tool.h"

namespace tool {


#if 0
  dispatch_queue_t get_current_dispatch_queue() {
    //return g_main_context_default();
    return std::this_thread::get_id();
  }

  struct async_thing: public resource
  {
    function<bool(void)> func;
    async_thing(function<bool(void)>&& f): func(std::move(f)) { add_ref(); }
    static gboolean callback (gpointer user_data)
    {
      async_thing* self = reinterpret_cast<async_thing*>(user_data);
      if( self->func() ) {
        self->release();
        return G_SOURCE_REMOVE;
      }
      return G_SOURCE_CONTINUE;
    }
  };


  bool exec_async(dispatch_queue_t queue, function<bool(void)>&& f, bool wait /* true - will block the thread until it will not execute it*/)
  {
     g_idle_add (async_thing::callback, new async_thing(std::move(f)));
// TODO: add wait handling!
     return true;
  }

 #endif

  namespace environment {

    ustring user_name() {
      char buf[L_cuserid] = {0};
      //getlogin_r(buf, items_in(buf));
      //const char* lc = getlogin();
      //return ustring::utf8(buf, strlen(buf));
      return cuserid(buf);
    }

    ustring machine_name(bool full)
    {
       char hostname[1024] = {0};
       gethostname(hostname, 1024);

       return u8::cvt( chars_of(hostname));
    }

    bool get_lang_country(ustring& lang,ustring& country, bool for_user)
    {
        const char* langstr = getenv ("LANG");
        if (!langstr)
           return false;

        chars clang = chars_of(langstr);
        if( clang.length < 5 )
          return false;

        lang = ustring(clang(0,2));
        country = ustring(clang(3,5));

        return true;
    }

    int get_os_version() {
      return SOME_LINUX;
    }

    const char* get_os_version_name()
    {
        static string os_name;

        if( os_name.length() )
          return os_name;

        FILE *fp = fopen("/etc/os-release", "rt");
        if(fp)
        {
          string pname, name;
          while(!feof(fp))
          {
            char buffer[1024];
            chars str = chars_of(fgets( buffer, 1024, fp));
            chars nam,val;
            if(str.split('=',nam,val)) {
              if(nam == CHARS("NAME")) name = val;
              if(nam == CHARS("PRETTY_NAME")) pname = val;
            }
          }
          fclose(fp);
          if( pname.length() )
            return (os_name = pname);
          if( name.length() )
            return (os_name = name);
        }

        utsname buf = {0};
        if( 0 == uname(&buf) ) {
          os_name = string::format("%s-%s", buf.sysname, buf.release);
        }
        else
          os_name = "Linux-Unknown";
        return os_name;
    }

  }

  ustring  get_standard_dir(STANDARD_DIR sd)
  {
      switch(sd) {
          default:
          case APPLICATIONS_DIR: return g_get_user_runtime_dir(); // TODO ?????????????????????????
          case USER_APPDATA_DIR: return g_get_user_config_dir ();
          case USER_DOCUMENTS_DIR: return g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
          case USER_DOWNLOADS_DIR: return g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
          case USER_MUSIC_DIR: return g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
          case USER_VIDEO_DIR: return g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
          case USER_PICTURES_DIR: return g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
      }
      return ustring();
  }

}
