#ifndef __tl_eval_bc_h__
#define __tl_eval_bc_h__

namespace tool {
namespace eval {
enum bytecode_t {
  BC_LINENO = 0, // 0, line_no <- bc[1..4]
  BC_PUSH,       // 1, 1, val -> stack.top
  BC_POP,        // 2, 1, val <- stack.top
  BC_ADD,        // 3, 1, val <- val + stack.pop();
  BC_SUB,        // 4, 1, val <- val - stack.pop();
  BC_MUL,        // 5, 1, val <- val * stack.pop();
  BC_DIV,        // 6, 1, val <- val / stack.pop();
  BC_MOD,        // 7, 1, val <- toint(val) % toint(stack.pop());
  BC_POWER,      // 8, 1, val <- val ^ stack.pop();
  BC_NEG,        // 9, 1, val <- -val;
  BC_NOT,        // 10, 1, val <- !val;
  BC_LITERAL,    // 11, 2, val <- literal(bc[1..4]);
  BC_TRUE,       // 12, 1, val <- true
  BC_FALSE,      // 13, 1, val <- false
  BC_NULL,       // 14, 1, val <- null
  BC_CANCEL,     // 15, 1, val <- null
  BC_GLOBAL,     // 16, 1, val <- global
  BC_SELF,       // 17, 1, val <- self
  BC_CONST_GET,  // 18, 5, val <- obj, idx <- bc[1..4]
  BC_ATTR_GET,   // 19, 5, val <- obj, idx <- bc[1..4]
  BC_ATTR_SET,   // 20, 5, val -> obj, idx <- bc[1..4]
  BC_STATE_GET,  // 21, 5, val <- obj, idx <- bc[1..4]
  BC_STATE_SET,  // 22, 5, val -> obj, idx <- bc[1..4]
  BC_VAR_GET,    // 23, 5, val <- var, idx <- bc[1..4]
  BC_VAR_SET,    // 24, 5, val -> var, idx <- bc[1..4]
  BC_CALL, // 25, 8, val <- function, symbol@bc[1..4], argn@bc[5..8], argv@stack
  BC_RETURN, // 26, return
  BC_INVOKE, // 27, invoke idx <- bc[1..4] on val(object)
  BC_BRF,    // 28, 5, branch if val==false, pc <- bc[1..4]
  BC_BRT,    // 29, 5, branch if val==true, pc <- bc[1..4]
  BC_BR,     // 30, 5, branch unconditionally, pc <- bc[1..4]
  BC_LT,     // 31, 1, val <- stack.pop() < val;
  BC_LE,     // 32, 1, val <- stack.pop() <= val;
  BC_GT,     // 33, 1, val <- stack.pop() > val;
  BC_GE,     // 34, 1, val <- stack.pop() >= val;
  BC_EQ,     // 35, 1, val <- stack.pop() == val;
  BC_NE,     // 36, 1, val <- stack.pop() != val;
  BC_OR,     // 37, 1, val <- toint(stack.pop()) | toint(val);
  BC_AND,    // 38, 1, val <- toint(stack.pop()) & toint(val);
  BC_FRAME,  // 39, 5,        bc[1..4]
  BC_CLOSE,  // 40, 5, val <- (this conduint, bc_offset( bc[1..4] )) - make
            // function reference
  BC_SATTR_GET, // 41, 5, val <- obj, idx <- bc[1..4]
  BC_SATTR_SET, // 42, 5, val -> obj, idx <- bc[1..4]
  BC_RANGE,     // 43, 1, val <- range(stack.pop(),val);
  BC_EXT_CONST, // 44, 5, val <- const defined elsewhere, sym <- bc[1..4]
  BC_LIKE       // 45, val <- stack.pop() like val;      
};
}
} // namespace tool

#endif