
var ItemsDB = { st:null, root:null }; // our DB class

// Opens Storage and returns it, static method
function ItemsDB.open( pathname = "items.db" ) 
{
  var idb = new ItemsDB();
  idb.st = Storage.open(pathname);
  idb.root = idb._init_root();
  return idb;
}

function ItemsDB.close()
{
  this.st.close();
  this.st = null;
  this.root = null;
}

function ItemsDB._init_root() 
{
  if(!this.st.root)
    this.st.root = 
      {
        ids:      this.st.createIndex(#string), // main index: item.id -> item
        keywords: this.st.createIndex(#string)  // keywords index: keyword -> array of items
      };
  return this.st.root;
}

function ItemsDB.addItem(item) 
{
  item.id = String.UID(); // each item has an id - global unique identifier
  
  stdout.printf("\noriginal item:%V\n",item);
  
  this.root.ids[item.id] = item;  
  if(item.keywords)
  {
    var keywords_idx = this.root.keywords;
    for( var kw in item.keywords )
    {
      var kwdef = keywords_idx[kw];
      if( kwdef )
          kwdef.items[ item ] = item;
      else
      {
          kwdef = { name:kw, items:{} };
          kwdef.items[ item ] = item;
          keywords_idx[kw] = kwdef;
      }
    }
  }
  item.store();
}


function itemsdb_unit_test()
{
  function dump( obj ) { stdout.printf("\ndumping object:%V\n",obj); }

  var db = ItemsDB.open("unit_test_items.db");
  
  if( db.root.ids.length == 0 )
  {
  
    // FOLLOWING WILL FAIL in GC! 
    // for(var i = 0; i < 100000; ++i)
    //   db.addItem({  desc:"My bug!", priority:1, severity:1 });
  
    db.addItem({  desc:"My 1st bug!", priority:1, severity:1, keywords:["sciter", "tiscript"] });
    db.addItem({  desc:"My 2nd bug!", priority:2, severity:1 });
    db.addItem({  desc:"My 3rd bug!", priority:3, severity:1, keywords:["sciter"] });
    db.addItem({  desc:"My 4th bug!", priority:4, severity:1, keywords:["sciter", "tiscript"] });
     
    stdout << "\ndb created\n";
  }

  var cnt = 0;
  for(var i in db.root.ids)
    {
      dump(i);
      ++cnt;
    }
  //if( cnt != 4 || db.root.ids.length != 4 ) throw "Failed to add or enumerate"; 
    
  stdout << "\nkeyword stats:\n";
  
  for(var kwdef in db.root.keywords)
  {
    stdout.printf( "%s(%d)\n", kwdef.name, kwdef.items.length );
  }
  
  //var stats = db.keywordStats();
  //for( var kw in stats) 
  //{
  //  stdout.printf( "%s(%d)\n", kw, stats[kw] );
  //}
  
  db.close();
  db = null;
  
}

itemsdb_unit_test();

