function DumpObj( obj )
{
  stdout << "dumping object: \n" ;

  for(var n in obj )
  {
    stdout << "Property: '" << n << "'\tValue: typeof '" << typeof(obj[n]) << "' value '" << obj[n] << "'\n";
    if(typeof(obj[n]) == "object")
    {
      stdout << "\t\tsub-object: \t" ;
      DumpObj( obj[n] );
      stdout << "\t\tEND of sub-object...\n" ;
    }
  }
}


function lastBugId(idx)
{
  var last = 0;
  try
  {
//    var r = idx.search(0, 10000, false);
    for( var bug in idx )
    { 
      last = bug.id;
    }
  }
  catch( ex )  
  {
    stdout << "Can't enumerate bugs\n";
    return 0;
  }
  
  stdout << "Last bug id = " << last << "\n";
  return last;
}


function insertNew(idx, desc, priority, severity)
{
  var nextId = lastBugId(idx) + 1;
  var bug = {id: nextId, desc: desc, priority: priority, severity: severity};
  DumpObj( bug )
  idx[nextId] = bug;
  stdout <<   "idx[" << nextId << "] = bug(" << desc << ", " << priority << ", " << severity << ")\n";
}

var s = Storage.openStorage("bugs.db");
var root = s.root;
if(root == null)
{
  var idx = s.createIndex(#integer);
  root = {};
  root.idx = idx;
  s.root = root;
}

var lastId = 0;
try 
{
  lastId = lastBugId(root.idxId);
}
catch( ex )
{
  stdout << "exception: " << ex.toString();
}

//stdout << "Last bug id: " << lastId << "\n";

insertNew(root.idx, "My 1st bug!", 1, 1);
insertNew(root.idx, "My next2 bug!", 2, 1);
insertNew(root.idx, "My next3 bug!", 3, 1);
insertNew(root.idx, "My next4 bug!", 2, 2);
insertNew(root.idx, "My next5 bug!", 2, 3);
insertNew(root.idx, "My next6 bug!", 2, 4);
stdout << "\nFinished\n";

s.close();

