
var ItemsDB = { st:null; root:null; }; // our DB class

// Opens Storage and returns it, static method
function ItemsDB.open( pathname = "items.db" ) 
{
  var idb = new ItemsDB();
  idb.st = Storage.openStorage(pathname);
  idb.root = idb._init_root();
}

function ItemsDB._init_root() 
{
  if(!this.st.root)
    this.st.root = 
      {
        ids:      this.st.createIndex(#string),       // main index: item.id -> item
        keywords: this.st.createIndex(#string, false) // keywords non-unique index: keyword -> item
      };
  return this.st.root;
}

function ItemsDB.addItem(item) 
{
  item.id = String.UID(); // each item has an id - global unique identifier
  this.root.ids[item.id] = item;  
  if(item.keywords)
  {
    var keywords_idx = this.root.keywords;
    for( var kw in item.keywords )
      keywords_idx.add(kw,item); // we cannot use [] here as index is not unique
  }
}

function DumpObj( obj )
{
  stdout.printf("dumping object:%V\n",obj);
}


function showBugsByKeyword(kwds)
{
    for(var o in kwds)
    {
      //stdout << k;
      DumpBug(o);
    }
}


var db = ItemsDB.open();

db.addItem( {    } );



insertNew(root.idx, root.keywords, "My 1st bug!", 1, 1, ["sciter", "tiscript"]);
insertNew(root.idx, root.keywords, "My next2 bug!", 2, 1);
insertNew(root.idx, root.keywords, "My next3 bug!", 3, 1, ["sciter"]);
insertNew(root.idx, root.keywords, "My next4 bug!", 2, 2);
insertNew(root.idx, root.keywords, "My next5 bug!", 2, 3);
insertNew(root.idx, root.keywords, "My next6 bug!", 2, 4);

stdout << "\nBy keywords\n";
showBugsByKeyword(root.keywords);

stdout << "\nFinished\n";

s.close();

