/* hash.c - string hashing routine */
/*
        Copyright (c) 2001-2004 Terra Informatica Software, Inc.
        and Andrew Fedoniouk andrew@terrainformatica.com
        All rights reserved
*/

#include "cs.h"

namespace tis {

  long FixedVectorSize(value obj);
  void FixedVectorScan(VM *c, value obj);

  /* HashTable pdispatch */
  dispatch CsHashTableDispatch = {
      "HashTable",          &CsHashTableDispatch, CsDefaultGetProperty,
      CsDefaultSetProperty, CsDefaultNewInstance, CsDefaultPrint,
      FixedVectorSize,      CsDefaultCopy,        FixedVectorScan,
      CsDefaultHash,        CsDefaultGetItem,     CsDefaultSetItem};

  /* CsMakeHashTable - make a new hash table */
  value CsMakeHashTable(VM *c, long size) {
    return CsMakeFixedVectorValue(c, &CsHashTableDispatch, size);
  }

  /* CsHashBytes - compute the hash value for a byte vector */
  int_t CsHashBytes(bytes bs) { return tool::hash(bs); }

  /* CsHashString - compute the hash value for a string */
  int_t CsHashString(wchars str) { return tool::hash(str); }

} // namespace tis
