#include "cs.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "cs.h"
#include "cs_com.h"
#include "cs_int.h"
#include "cs_pval.h"

namespace tis {
  typedef tool::wchars wchars;

  static int  codeaddr(CsCompiler *c);
  static void putcbytes(CsCompiler *c, bytes data);
  static void discard_codes(CsCompiler *c, int codeaddr);
  static int  fixup(CsCompiler *c, int chn, int val);

  // return last char read, level - level of '(',')' brackets. Has to be eq 1
  // initially.
  int scan_stringizer_string(CsCompiler *c, int &level);

// local constants
#define NIL 0 /* fixup list terminator */

  typedef void pval_ctl_t(CsCompiler *, int, PVAL *);
  typedef function<void(PVAL& node)> expr_transformer;

  static void code_literal(CsCompiler *c, int fcn, PVAL& pv);

  /* forward declarations */
  static void SetupCompiler(CsCompiler *c);
  static void do_statement(CsCompiler *c);
  static void do_define(CsCompiler *c);
  static void do_class_decl(CsCompiler *c, int tkn, bool store = true);
  // static void define_function(CsCompiler *c,char *name);

  static int  compile_code(CsCompiler *c, const char *name, FUNCTION_TYPE dct, PVAL& pv, bool is_static = false, expr_transformer tran = nullptr);
  static void do_stream(CsCompiler *c);
  enum DECORATOR_OF {
    GOT_NOTHING  = 0,
    GOT_FUNCTION = 1,
    GOT_CLASS    = 2,
  };
  static DECORATOR_OF do_decorator(CsCompiler *c, string& name);
  static DECORATOR_OF do_decorator(CsCompiler *c);
  static void         do_assert(CsCompiler *c);
  static void         do_debug(CsCompiler *c);
  static bool         do_log(CsCompiler *c, int tkn);
  static void         do_if(CsCompiler *c);
  static void         do_while(CsCompiler *c);
  static void         do_dowhile(CsCompiler *c);
  static void         do_for(CsCompiler *c);
  static void         do_with(CsCompiler *c);
  static void do_for_initialization(CsCompiler *c, PVAL& pv, ATABLE **patable,
                                    int *pptr);
  static SENTRY * addbreak(CsCompiler *c, int lbl,
                           const tool::string &name = tool::string());
  static int      rembreak(CsCompiler *c, SENTRY *old, int lbl);
  static void     do_break(CsCompiler *c);
  static SENTRY * addcontinue(CsCompiler *c, int lbl);
  static void     remcontinue(CsCompiler *c, SENTRY *old);
  static void     do_continue(CsCompiler *c);
  static SWENTRY *addswitch(CsCompiler *c);
  static void     remswitch(CsCompiler *c, SWENTRY *old);
  static void     do_switch(CsCompiler *c);
  static void     do_case(CsCompiler *c);
  static void     do_default(CsCompiler *c);
  static void     UnwindStack(CsCompiler *c, int levels);
  static void     UnwindTryStack(CsCompiler *c, int &endaddr);
  static void     do_block(CsCompiler *c, char *parameter);
  static void     do_property_block(CsCompiler *c, const char *valName);

  static void do_get_set(CsCompiler *c, bool get, const char *valName);
  static void do_return(CsCompiler *c);
  static void do_delete(CsCompiler *c);
  // static void do_yield(CsCompiler *c);
  static void do_typeof(CsCompiler *c);
  static void do_try(CsCompiler *c);
  static void do_throw(CsCompiler *c);
  static void do_test(CsCompiler *c, ATABLE **patable = 0, int *pptr = 0,
                      int *next = 0);
  static void do_expr(CsCompiler *c);

  static void do_var_local(CsCompiler *c, ATABLE **patable, int *pptr, PVAL& pv, int *next = 0);
  static void do_const_local(CsCompiler *c, ATABLE **patable, int *pptr);
  static void do_function_local(CsCompiler *c, FUNCTION_TYPE ft, ATABLE **patable, int *pptr);

  static void do_include(CsCompiler *c);
  static void do_import(CsCompiler *c);

  static void do_var_global(CsCompiler *c);
  static void do_const_global(CsCompiler *c);
  static void do_init_expr(CsCompiler *c);
  static void do_class_ref_expr(CsCompiler *c);
  static void do_right_side_expr(CsCompiler *c, PVAL& pv);
  static bool do_call_param_expr(CsCompiler *c, PVAL& pv, bool allow_dot_dot = false);
  static void rvalue(CsCompiler *c, PVAL& pv);
  static void chklvalue(CsCompiler *c, PVAL& pv);
  static void do_expr1(CsCompiler *c, PVAL& pv, bool handle_in = true);
  static void do_right_side_expr_list(CsCompiler *c, PVAL& pv, bool handle_in = true); // <right_side_expr> [, <right_side_expr>]*
  static void do_expr_list(CsCompiler *c, PVAL& pv, bool handle_in = true); // <expr2> [, <expr2>]*

  static int  do_expr2(CsCompiler *c, PVAL& pv, bool handle_in);
  static void do_assignment(CsCompiler *c, PVAL& pv, int op);
  static void do_expr3(CsCompiler *c, PVAL& pv, bool handle_in);
  static void do_expr4(CsCompiler *c, PVAL& pv, bool handle_in);
  static void do_expr5(CsCompiler *c, PVAL& pv, bool handle_in);
  static void do_expr6(CsCompiler *c, PVAL& pv, bool handle_in);
  static void do_expr7(CsCompiler *c, PVAL& pv, bool handle_in);
  static void do_expr8(CsCompiler *c, PVAL& pv, bool handle_in);
  static void do_expr9(CsCompiler *c, PVAL& pv, bool handle_in);
  static void do_expr10(CsCompiler *c, PVAL& pv, bool handle_in);
  static void do_expr11(CsCompiler *c, PVAL& pv);
  static void do_expr12(CsCompiler *c, PVAL& pv);
  static void do_expr13(CsCompiler *c, PVAL& pv);
  static void do_expr14(CsCompiler *c, PVAL& pv);
  static void do_preincrement(CsCompiler *c, PVAL& pv, int op);
  static void do_postincrement(CsCompiler *c, PVAL& pv, int op);
  static void do_expr15(CsCompiler *c, PVAL& pv,
                        bool allow_call_objects = true);
  static void do_primary(CsCompiler *c, PVAL& pv);
  static void do_primary_json(CsCompiler *c, PVAL& pv);

  static void do_ssx(CsCompiler *c, PVAL& pv, bool root = false);
  static void do_variable(CsCompiler *c, PVAL& pv);
  static void do_selector(CsCompiler *c, PVAL& pv);
  static void do_prop_reference(CsCompiler *c, PVAL& pv);
  static void do_prop_optional_reference(CsCompiler *c, PVAL& pv);
  static void do_function(CsCompiler *c, FUNCTION_TYPE fct, bool store = true, bool is_static = false );
  static string do_lambda(CsCompiler *c, PVAL& pv, FUNCTION_TYPE fct);
  static void do_fat_arrow(CsCompiler *c, PVAL& pv, expr_transformer tran = nullptr);
  static void do_event(CsCompiler *c, PVAL& pv);
  static void do_literal(CsCompiler *c, PVAL& pv);
  static void do_literal_symbol(CsCompiler *c, PVAL& pv);
  static void do_literal_vector(CsCompiler *c, PVAL& pv);
  // static void do_literal_tuple(CsCompiler *c,PVAL& pv, const char* name);
  static void do_literal_regexp(CsCompiler *c, PVAL& pv, int tkn);
  static void do_literal_obj(CsCompiler *c, PVAL& pv);
  // static void do_output_string(CsCompiler *c, const wchar* str);
  static void do_new_obj(CsCompiler *c, PVAL& pv);
  static void do_call(CsCompiler *c, PVAL& pv);        // name( param list )
  static void do_$_call(CsCompiler *c, PVAL& pv);      // name( param list )
  static void do_call_object(CsCompiler *c, PVAL& pv); // name object literal.
                                                       // name { field1: value,
                                                       // field2: value, ... }
  static void do_super(CsCompiler *c, PVAL& pv);
  static handle<expr::call_method> do_method_call(CsCompiler *c, PVAL& pv, PVAL pp, bool optional = false);
  static void do_$_method_call(CsCompiler *c, PVAL& pv, PVAL pp, bool optional = false);
  static handle<expr::call_method> do_method_call_object(CsCompiler *c, PVAL& pv, PVAL pp, bool optional = false);
  // static void do_yield(CsCompiler *c);
  // static void do_await(CsCompiler *c);
  static void    do_index(CsCompiler *c, PVAL& pv);
  static void    do_symbol_index(CsCompiler *c, PVAL& pv);
  static void    do_var_local_list(CsCompiler *c, ATABLE **patable, PVAL& pv, int acnt, bool is_var /*false - const*/, int tok_eol);

  static PVAL    do_var_local_list(CsCompiler *c, bool is_var /*false - const*/, int tok_eol);
  static PVAL    do_var_global_list(CsCompiler *c, bool is_var /* false - const */, int tok_eol);

  static void    InjectArgFrame(CsCompiler *c, ATABLE **patable, int *pptr);
  static void    AddArgument(CsCompiler *c, ATABLE *atable, const char *name,
                             bool immutable);
  static bool    ArgumentExists(CsCompiler *c, ATABLE *table, const char *name);
  static int     ArgumentsCount(CsCompiler *c, ATABLE *table);
  static value   AllocateArgNames(CsCompiler *c, ATABLE *atable, int n);
  static ATABLE *MakeArgFrame(CsCompiler *c, bool funcArgs = false);
  static void    PushArgFrame(CsCompiler *c, ATABLE *atable);
  static void    PushNewArgFrame(CsCompiler *c, bool funcArgs = false);
  static void    PopArgFrame(CsCompiler *c);
  static void    FreeArguments(CsCompiler *c);
  static bool FindArgument(CsCompiler *c, const char *name, int &lev, int &off,bool &pimmutable);
  static bool FindThis(CsCompiler *c, int &lev, int &off, int level = 0);
  static void CloseArgFrame(CsCompiler *c, ATABLE *atable, int ptr /* BC_FRAME arg offset */);

  static PVAL declare_local_name(CsCompiler *c, const string& name, bool is_const);
  static PVAL declare_global_name(CsCompiler *c, const string& name, bool is_const);

  static int   addliteral(CsCompiler *c, value lit, bool unique);
  static value getliteral(CsCompiler *c, int idx);
  static void  setliteral(CsCompiler *c, int idx, value val);

  static void foptional(CsCompiler *c, int rtkn);

  static void frequire(CsCompiler *c, int rtkn);
  static int  frequire_or(CsCompiler *c, int rtkn1, int rtkn2);
  static int  frequire_or(CsCompiler *c, int rtkn1, int rtkn2, int rtkn3);
  static int  frequire_or(CsCompiler *c, int rtkn1, int rtkn2, int rtkn3, int rtkn4);
  static void require(CsCompiler *c, int tkn, int rtkn);
  static void require_or(CsCompiler *c, int tkn, int rtkn1, int rtkn2);
  static void require_or(CsCompiler *c, int tkn, int rtkn1, int rtkn2, int rtkn3);
  static void require_or(CsCompiler *c, int tkn, int rtkn1, int rtkn2, int rtkn3, int rtkn4 );
  static void do_lit_integer(CsCompiler *c, int_t n);
  static void do_lit_float(CsCompiler *c, float_t n);
  // static void do_lit_string(CsCompiler *c,const wchar *str);
  static void do_lit_string(CsCompiler *c, tool::wchars str);
  static void do_lit_symbol(CsCompiler *c, const char *pname);
  static int  make_lit_string(CsCompiler *c, const wchar *str);
  static int  make_lit_string(CsCompiler *c, const wchar *str, int sz);
  static int  make_lit_string(CsCompiler *c, wchars str) {
    return make_lit_string(c, str.start, (int_t)str.length);
  }
  static int  make_lit_symbol(CsCompiler *c, const char *pname);
  static void variable_ref(CsCompiler *c, const char *name);
  static void findvariable(CsCompiler *c, const char *id, PVAL& pv);
  static void code_constant(CsCompiler *c, int fcn, PVAL *);
  static bool load_argument(CsCompiler *c, const char *name, PVAL& pv);
  static void code_argument(CsCompiler *c, int fcn, PVAL *);
  static void code_immutable_argument(CsCompiler *c, int fcn,
                                      PVAL *); // that was declared as const ...
  static void code_property(CsCompiler *c, int fcn, PVAL *);
  static void code_variable(CsCompiler *c, int fcn, PVAL *);
  //static void code_new_namespace_variable(CsCompiler *c, int fcn, PVAL *);
  static void code_namespace_variable(CsCompiler *c, int fcn, PVAL *);
  static void code_member_template_variable(CsCompiler *c, int fcn, PVAL& pv);
  // static void code_global_const(CsCompiler *c,int fcn,PVAL *);

  static void code_index(CsCompiler *c, int fcn, PVAL *);
  static void code_literal(CsCompiler *c, int fcn, PVAL& pv);
  static void emit_literal(CsCompiler *c, int n);
  static bool is_literal(PVAL& pv);

  static void do_store_if_defined(CsCompiler *c, PVAL target);

  static bool is_as_token(CsCompiler *c, int current_tkn) { return current_tkn == T_IDENTIFIER && chars_of(c->t_token) == CHARS("as"); }
  static bool is_from_token(CsCompiler *c, int current_tkn) { return current_tkn == T_IDENTIFIER && chars_of(c->t_token) == CHARS("from"); }
  static bool is_of_token(CsCompiler *c, int current_tkn) { return current_tkn == T_IDENTIFIER && chars_of(c->t_token) == CHARS("of"); }
  static bool is_extends_token(CsCompiler *c, int current_tkn) { return current_tkn == T_IDENTIFIER && chars_of(c->t_token) == CHARS("extends"); }
  static bool is_get_token(CsCompiler *c, int tkn) { return tkn == T_IDENTIFIER && chars_of(c->t_token) == CHARS("get"); }
  static bool is_set_token(CsCompiler *c, int tkn) { return tkn == T_IDENTIFIER && chars_of(c->t_token) == CHARS("set"); }

  static int fold_const(CsCompiler *c, int op, PVAL *left, PVAL *right);

  static void             AddLineNumber(CsCompiler *c, int line, int pc);
  static LineNumberBlock *AddLineNumberBlock(CsCompiler *c);
  static void             FreeLineNumbers(CsCompiler *c);
  static void             DumpLineNumbers(CsCompiler *c);
  static value            AllocateLineNumbers(CsCompiler *c);

  static char *copystring(CsCompiler *c, const char *str);

  extern int getoutputstring(CsCompiler *c);

  static void Optimize(CsCompiler *c, value bytecodes);

  // fully qualified name
  struct qualified_name {
    CsCompiler *c;
    char        name[TKNSIZE * 2 + 1];
    char        local_name[TKNSIZE + 1];
    const char *prev_name;

    qualified_name(CsCompiler *comp) : c(comp) {
      name[0]             = 0;
      name[TKNSIZE * 2]   = 0;
      prev_name           = c->qualifiedName;
      c->qualifiedName    = name;
      local_name[0]       = 0;
      local_name[TKNSIZE] = 0;
    }
    ~qualified_name() { c->qualifiedName = prev_name; }
    void append(const char *localName) {
      strncpy(local_name, localName, TKNSIZE);
      if (prev_name)
        do_snprintf(name, TKNSIZE * 2, "%s.%s", prev_name, localName);
      else
        strncpy(name, localName, TKNSIZE * 2);
    }
    bool is_root() { return prev_name == 0; }
  };

  static CsCompilerCallback dummy_cDOMcb;

  /* CsMakeCompiler - initialize the compiler */
  CsCompiler *CsMakeCompiler(VM *ic, long csize, long lsize) {
    CsCompiler *c;

    /* allocate the compiler context structure */
    if ((c = (CsCompiler *)CsAlloc(ic, sizeof(CsCompiler))) == nullptr)
      return nullptr;

    /* allocate and initialize the code buffer */
    if ((c->codebuf = (byte *)CsAlloc(ic, (size_t)csize)) == nullptr) {
      CsFree(ic, c);
      return nullptr;
    }
    c->cptr = c->codebuf;
    c->ctop = c->codebuf + csize;

    /* initialize the line number table */
    c->lineNumbers = c->currentBlock = nullptr;

    /* allocate and initialize the literal buffer */
    // CsProtectPointer(ic,&c->literalbuf);

    c->literalbuf.pin(ic);
    c->literalbuf = CsMakeVector(ic, lsize);

    c->lptr = 0; // c->ltop = lsize;

    /* link the compiler and interpreter contexts to each other */
    c->ic = ic;

    /* emit line number opcodes */
    c->emitLineNumbersP = ic->enableDebug;

    c->JSONonly    = false;
    c->atRightSide = false;

    c->cDOMcb = &dummy_cDOMcb;

    /* return the new compiler context */
    return c;
  }

  /* CsFreeCompiler - free the compiler structure */
  void CsFreeCompiler(CsCompiler *c) {
    c->literalbuf.unpin();
    if (c->codebuf) CsFree(c->ic, c->codebuf);
    c->t_wtoken.destroy();
    c->line.destroy();
    CsFree(c->ic, c);
  }

  /* SetupCompiler - setup the compiler context */
  static void SetupCompiler(CsCompiler *c, bool enableDebug) {
    c->cbase = c->cptr = c->codebuf;
    c->lbase = c->lptr = 0;
    c->bsbase = c->bsp = c->bstack - 1;
    c->csbase = c->csp = c->cstack - 1;
    c->ssbase = c->ssp  = c->sstack - 1;
    c->arguments        = nullptr;
    c->blockLevel       = 0;
    c->emitLineNumbersP = enableDebug;
    c->JSONonly         = false;
    c->tcStack          = 0;
    c->functionLevel    = 0;
    c->optionalPropSequenceEnd.clear();
  }

  /* CsCompileExpr - compile a single expression */
  value CsCompileExpr(CsScope *scope, bool add_this,
                      tool::slice<tool::ustring> argnames) {
    VM *        ic = scope->c;
    CsCompiler *c  = ic->compiler;
    value *     src, *dst;
    pvalue      code(ic);
    int         tkn;
    long        size;

    /* initialize the compiler */
    SetupCompiler(c, ic->enableDebug);

    value nameSymbol = CsSymbolOf(c->input->stream_name());

    auto_state<value> currentFileNameHolder(c->fileNameSymbol, nameSymbol);

    PushNewArgFrame(c, add_this);

    TRY {

      /* check for end of file */
      if ((tkn = CsToken(c)) == T_EOF) return value();

      CsSaveToken(c, tkn);

      if (add_this) /* the first arguments are always 'this' and '!next' */
      {
        AddArgument(c, c->arguments, "this", true);
        AddArgument(c, c->arguments, "!next", true);
      }

      for (uint an = 0; an < argnames.length; ++an)
        AddArgument(c, c->arguments, tool::string(argnames[an]), true);

      /* generate the argument frame */
      c->lineNumberChangedP = false;
      putcbyte(c, BC_AFRAME);
      putcbyte(c, 2);
      putcbyte(c, int(argnames.length));
      c->lineNumberChangedP = true;

      /* compile the code */
      // do_statement(c);
      do_stream(c);
      putcbyte(c, BC_RETURN);

      /* make the bytecode array */
      code = CsMakeByteVector(ic, c->cbase, int_t(c->cptr - c->cbase));

      value lineNums = AllocateLineNumbers(c);
      /* make the compiled code obj */
      size = c->lptr - c->lbase;
      code = CsMakeCompiledCode(ic, CsFirstLiteral + size, code, lineNums,
                                UNDEFINED_VALUE, c->fileNameSymbol);
      /* make dummy function name */
      CsSetCompiledCodeName(code, nameSymbol);
      src = CsVectorAddress(c->ic, c->literalbuf) + c->lbase;
      dst = CsCompiledCodeLiterals(code) + CsFirstLiteral;
      while (--size >= 0)
        *dst++ = *src++;

      /* make a closure */
      code = CsMakeMethod(ic, code, UNDEFINED_VALUE, ic->getCurrentNS());

      /* return the function */
      // CsDecodeProcedure(ic,code,ic->standardOutput);
      FreeLineNumbers(c);
      FreeArguments(c);
      return code;
    }
    CATCH_ERROR(e) {
      FreeArguments(c);
      RETHROW(e);
    }
    // return ic->val[0];
  }

  /* CsCompileExpr - compile a single expression */
  value CsCompileModule(CsScope *scope, bool add_this) {
    VM *        ic = scope->c;
    CsCompiler *c = ic->compiler;
    value *     src, *dst;
    pvalue      code(ic);
    int         tkn;
    long        size;

    /* initialize the compiler */
    SetupCompiler(c, ic->enableDebug);

    auto_state<value> currentFileNameHolder(c->fileNameSymbol, CsSymbolOf(c->input->stream_name()));

    PushNewArgFrame(c, add_this);

    TRY{

      /* check for end of file */
      if ((tkn = CsToken(c)) == T_EOF) return value();

    CsSaveToken(c, tkn);

    if (add_this) /* the first arguments are always 'this' and '!next' */
    {
      AddArgument(c, c->arguments, "this", true);
      AddArgument(c, c->arguments, "!next", true);
    }

    //for (uint an = 0; an < argnames.length; ++an)
    //  AddArgument(c, c->arguments, tool::string(argnames[an]), true);

    /* generate the argument frame */
    c->lineNumberChangedP = false;
    putcbyte(c, BC_AFRAME);
    putcbyte(c, 2);
    putcbyte(c, 0);
    c->lineNumberChangedP = true;

    /* compile the code */
    // do_statement(c);
    do_stream(c);
    putcbyte(c, BC_RETURN);

    /* make the bytecode array */
    code = CsMakeByteVector(ic, c->cbase, int_t(c->cptr - c->cbase));

    value lineNums = AllocateLineNumbers(c);
    /* make the compiled code obj */
    size = c->lptr - c->lbase;
    code = CsMakeCompiledCode(ic, CsFirstLiteral + size, code, lineNums,
      UNDEFINED_VALUE, c->fileNameSymbol);
    /* make dummy function name */
    CsSetCompiledCodeName(code, UNDEFINED_VALUE);
    src = CsVectorAddress(c->ic, c->literalbuf) + c->lbase;
    dst = CsCompiledCodeLiterals(code) + CsFirstLiteral;
    while (--size >= 0)
      *dst++ = *src++;

    /* make a closure */
    code = CsMakeMethod(ic, code, UNDEFINED_VALUE, ic->getCurrentNS());

    /* return the function */
    // CsDecodeProcedure(ic,code,ic->standardOutput);
    FreeLineNumbers(c);
    FreeArguments(c);
    return code;
    }
      CATCH_ERROR(e) {
      FreeArguments(c);
      RETHROW(e);
    }
    // return ic->val[0];
  }

  /* CsCompileExpressions - compile a expressions until eof */
  value CsCompileExpressions(CsScope *scope, bool serverScript, int line_no) {
    VM *        ic = scope->c;
    CsCompiler *c  = ic->compiler;
    value *     src, *dst;
    pvalue      code(ic);
    int         tkn;
    long        size;
    /* initialize the compiler */
    SetupCompiler(c, ic->enableDebug);

    auto_state<value> currentFileNameHolder(
        c->fileNameSymbol, CsSymbolOf(c->input->stream_name()));

    if (line_no)
      c->lineNumber = line_no - (c->savedChar != '\n' ? 1 : 0); /* line buffer reader will increment it */

    if (serverScript && (getoutputstring(c) == T_OUTPUT_STRING)) {
      tool::wchars s = c->get_wtoken_string();
      if (s.length) CsSaveToken(c, T_OUTPUT_STRING);
    }

    TRY {

      /* check for end of file */
      if ((tkn = CsToken(c)) == T_EOF) return value();

      CsSaveToken(c, tkn);

      /* make dummy function name */

      // const wchar* name = c->input->stream_name();

      /*if( name && name[0] )
      {
        //tool::ustring us(name);
        //make_lit_string(c,us);
        addliteral(c, CsMakeSymbol(ic,name));
      }
      else
        addliteral(c,UNDEFINED_VALUE);*/

      /* generate the argument frame */
      c->lineNumberChangedP = true;
      putcbyte(c, BC_AFRAME);
      putcbyte(c, 2);
      putcbyte(c, 0);
      c->lineNumberChangedP = true;

      /* compile the code */
      do_stream(c);

      putcbyte(c, BC_NS); // import/export requirement
      putcbyte(c, BC_RETURN);

      /* make the bytecode array */
      code = CsMakeByteVector(ic, c->cbase, int_t(c->cptr - c->cbase));

      value lineNums = AllocateLineNumbers(c);

      /* make the compiled code obj */
      size = c->lptr - c->lbase;
      code = CsMakeCompiledCode(ic, CsFirstLiteral + size, code, lineNums,
                                UNDEFINED_VALUE, c->fileNameSymbol);
      //      CsSetCompiledCodeName(code,name && name[0]?
      //      CsMakeSymbol(ic,name): UNDEFINED_VALUE);
      src = CsVectorAddress(c->ic, c->literalbuf) + c->lbase;
      dst = CsCompiledCodeLiterals(code) + CsFirstLiteral;
      while (--size >= 0)
        *dst++ = *src++;

      /* make a closure */
      code = CsMakeMethod(ic, code, UNDEFINED_VALUE, scope->globals);

      /* return the function */
      // CsDecodeProcedure(ic,code,ic->standardOutput);
      FreeLineNumbers(c);

#if defined(TISCRIPT_DEBUGGER)
      if (ic->pdebug) ic->pdebug->register_source_file(ic, c->fileNameSymbol);
#endif
      return code;
    }
    CATCH_ERROR(e) {
      FreeArguments(c);
      RETHROW(e);
    }
    // return ic->val[0];
  }

  /* CsCompileJSON - compile a JSON literal until eof */
  value CsCompileDataExpr(CsScope *scope) {
    VM *        ic = scope->c;
    CsCompiler *c  = ic->compiler;
    value *     src, *dst;
    pvalue      code(ic);
    int         tkn;
    long        size;

    /* initialize the compiler */
    SetupCompiler(c,false);
    auto_state<value> currentFileNameHolder(
        c->fileNameSymbol, CsSymbolOf(c->input->stream_name()));

    c->JSONonly = true;

    TRY {

      /* check for end of file */
      if ((tkn = CsToken(c)) == T_EOF) return value(0);

      CsSaveToken(c, tkn);

      /* make dummy function name */

      const wchar *name = c->input->stream_name();

      if (name && name[0]) {
        // tool::ustring us(name);
        // make_lit_string(c,us);
        addliteral(c, CsMakeSymbol(ic, name) /*UNDEFINED_VALUE*/);
      } else
        addliteral(c, UNDEFINED_VALUE);

      /* generate the argument frame */
      c->lineNumberChangedP = false;
      putcbyte(c, BC_AFRAME);
      putcbyte(c, 2);
      putcbyte(c, 0);
      c->lineNumberChangedP = true;

      /* compile the code */
      //do_init_expr(c);
      PVAL pv;
      do_primary_json(c, pv);
      rvalue(c, pv);

      putcbyte(c, BC_RETURN); // return it

      /* make the bytecode array */
      code = CsMakeByteVector(ic, c->cbase, int_t(c->cptr - c->cbase));

      value lineNums = AllocateLineNumbers(c);

      /* make the compiled code obj */
      size = c->lptr - c->lbase;
      code = CsMakeCompiledCode(ic, CsFirstLiteral + size, code, lineNums,
                                UNDEFINED_VALUE, c->fileNameSymbol);
      /* make dummy function name */
      CsSetCompiledCodeName(code, UNDEFINED_VALUE);
      src = CsVectorAddress(c->ic, c->literalbuf) + c->lbase;
      dst = CsCompiledCodeLiterals(code) + CsFirstLiteral;
      while (--size >= 0)
        *dst++ = *src++;

      /* make a closure */
      code = CsMakeMethod(ic, code, UNDEFINED_VALUE, ic->getCurrentNS());

      FreeLineNumbers(c);
      /* return the function */

      return code;
    }
    CATCH_ERROR(e) {
      FreeArguments(c);
      RETHROW(e);
    }
    // return ic->val[0];
  }

  /* do_statement - compile a single statement */
  static void do_statement(CsCompiler *c) {

    /*if (!c->ic->enableDebug)
    {
      for (;;) {
        int tkn = CsToken(c);
        if (!tkn)
          break;
        else if (tkn == ';')
          break;
      }
      putcbyte(c, BC_NOP);
      return;
    }*/

    int tkn;
    switch (tkn = CsToken(c)) {
    // case T_DEFINE:      do_define(c);   break;
    case T_DEBUG: do_debug(c); break;
    case T_ASSERT: do_assert(c); break;
    case T_IF: do_if(c); break;
    case T_WHILE: do_while(c); break;
    case T_WITH: do_with(c); break;
    case T_DO: do_dowhile(c); break;
    case T_FOR: do_for(c); break;
    case T_BREAK:
      do_break(c);
      CsSaveToken(c, CsToken(c));
      break;
    case T_CONTINUE:
      do_continue(c);
      CsSaveToken(c, CsToken(c));
      break;
    case T_SWITCH: do_switch(c); break;
    case T_CASE: /*do_case(c);*/
      CsParseError(c, "'case' outside of switch");
      break;
    case T_DEFAULT: /*do_default(c);*/
      CsParseError(c, "'default' outside of switch");
      break;
    case T_RETURN: do_return(c); break;
    case T_DELETE: do_delete(c); break;
    case T_TRY: do_try(c); break;
    case T_THROW: do_throw(c); break;
    case '{': do_block(c, 0); break;
    case ';':; break;
    case '=': {
      PVAL pv2;
      do_right_side_expr(c, pv2);
      rvalue(c, pv2);
      putcbyte(c, BC_OUTPUT);
    } break;

    case T_OUTPUT_STRING: {
      do_lit_string(c, c->get_wtoken_string());
      putcbyte(c, BC_OUTPUT);
    } break;

    //case T_IDENTIFIER:
    //  if (streq(c->t_token, "log"))
    //    do_log(c);
    //  else
    //; // fall trough

    default: {
      tool::auto_state<bool> _(c->atRightSide, false);
      CsSaveToken(c, tkn);
      do_expr(c);
      // frequire(c,';');
      break;
    }
    }
  }

  static int do_arg_list(CsCompiler *c, ATABLE **patable, PVAL& pv, int type) {
    int acnt = ArgumentsCount(c, *patable);
    //do_var_local_list(c, atable, pv, acnt, true, ')');

    int tok_eol;
    int tok_eol_alt = 0;

    // '(', ':', '{', '|'

    switch (type) {
      default: assert(false);
      case '(': tok_eol = ')'; break;
      case ':': tok_eol = ':'; tok_eol_alt = '{'; break;
      case '|': tok_eol = '|'; tok_eol_alt = '{'; break;
    }

    handle<expr::list> ls = new expr::list(c, expr::list::VARS, true);
    pv = ls;

    int  tkn;
    bool rest = false;
    do {
      PVAL pv2;
      tkn = CsToken(c);//frequire_or(c, T_IDENTIFIER, T_EVENT,',',tok_eol);
      if (tkn == ',')
      {
        pv2 = new expr::novalue(c);
        ls->elements.push(pv2);
        continue;
      }
      else if (tkn == tok_eol || tkn == tok_eol_alt)
      {
        return tkn;
      }
      else if (tkn == T_DOTDOTDOT) // new "rest" case : ...a
      {
        rest = true;
        tkn = frequire_or(c, T_IDENTIFIER, T_EVENT);
      }

      if (tkn != T_IDENTIFIER && tkn != T_EVENT)
        CsParseError(c, "invalid destructuring assignment sequence");

      string name = c->t_token;

      AddArgument(c, *patable, name, false);
      ++acnt;

      // handling of old "rest" case: a...
      if (!rest) {
        tkn = CsToken(c);
        if (tkn == T_DOTDOT || tkn == T_DOTDOTDOT)
          rest = true;
        else
          CsSaveToken(c, tkn);
      }

      pv2 = new expr::evar(c, name, 0, acnt);

      if (rest) {
        pv2 = new expr::rest(c, pv2);
        ls->elements.push(pv2);
        frequire(c, tok_eol);
        break;
      }
      else {
        tkn = CsToken(c);
      }

      if (tkn == '=') {
        PVAL rv;
        do_call_param_expr(c, rv, false);
        pv2 = new expr::assignment(c, pv2, rv);
        tkn = CsToken(c);
      }

      ls->elements.push(pv2);

      if (tkn == ',') {
        continue;
      }
      CsSaveToken(c, tkn);
    } while (true);
    return tkn;
  }

  // compile_code - compile a function or method
  // returns lindex of compiled literal containing code
  static int compile_code(CsCompiler *c, 
                          const char *name, 
                          FUNCTION_TYPE fct, PVAL& pv /*may contain expr::list for fat arrow*/, 
                          bool is_static, 
                          expr_transformer transformer )
  {
    tool::nesting_counter           _1(c->functionLevel);
    tool::auto_state<bool>          _2(c->yieldSeen, false);
    tool::auto_state<bool>          _3(c->awaitSeen, false);
    tool::auto_state<FUNCTION_TYPE> _4(c->functionType, fct);

    VM *             ic = c->ic;
    int              type;
    int              oldLevel, argc, rcnt, ocnt, vcnt = 0, nxt, tkn;
    value            code, *src, *dst;
    SENTRY *         oldbsbase, *oldcsbase;
    SWENTRY *        oldssbase;
    LineNumberBlock *oldlines, *oldcblock;
    byte *           oldcbase, *cptr;
    long             oldlbase, size;

    if (fct == FAT_ARROW) {
      //caller has consumed '=>' at this point
      tkn = type = '|'; // 'that' lambda
    }
    else
      tkn = type = frequire_or(c, '(', ':', '{', '|');

    /* initialize */
    argc = 2;
    rcnt = argc;
    ocnt = 0;

    /* save the previous compiler state */
    oldLevel  = c->blockLevel;
    oldcbase  = c->cbase;
    oldlbase  = c->lbase;
    oldbsbase = c->bsbase;
    oldcsbase = c->csbase;
    oldssbase = c->ssbase;
    oldlines  = c->lineNumbers;
    oldcblock = c->currentBlock;

    int literal_buf_size = CsVectorSize(c->ic, c->literalbuf);

    // tool::array<CsCompiler::TryCatchDef> saveTryCatchStack;   /*
    // try/catch/finally stack */  tool::swop(c->tryCatchStack,saveTryCatchStack);
    CsCompiler::TryCatchDef *save_tcStack = c->tcStack;
    c->tcStack                            = 0;

    /* initialize new compiler state */
    PushNewArgFrame(c,true);
    c->blockLevel  = 0;
    c->cbase       = c->cptr;
    c->lbase       = c->lptr;
    c->bsbase      = c->bsp;
    c->csbase      = c->csp;
    c->ssbase      = c->ssp;
    c->lineNumbers = c->currentBlock = nullptr;

    // form argument list

    // the first arguments are always 'this' and '!next'
    if ((type == '|') || is_static)
      AddArgument(c, c->arguments, "----", true); // "that" lambdas do not have 'this'
    else
      AddArgument(c, c->arguments, "this", true);

    AddArgument(c, c->arguments, "!next", true);


    /* generate the argument frame */
    cptr                  = c->cptr;
    c->lineNumberChangedP = false;
    putcbyte(c, BC_AFRAME);
    putcbyte(c, 0);
    putcbyte(c, 0);
    c->lineNumberChangedP = true;

    //char firstParam[TKNSIZE + 1];
    //firstParam[0] = 0;

    if (type == '{') {
      CsSaveToken(c, type);
      pv = new expr::list(c, expr::list::VARS, true);
      //  function/event without parameters:
      //    function name {}
    }
    else if (fct == FAT_ARROW) {
      assert(pv->is_of_type<expr::list>());
      expr::list* list = pv.ptr_of<expr::list>();
      for (PVAL& arg : list->elements) {
        ++argc;
        tool::string vname;
        if (arg->is_var_ref(&vname)) {
          AddArgument(c, c->arguments, vname, false);
          arg = new expr::evar(c, vname, 0, argc);
        }
        else if (arg->is_assignment() && arg.ptr_of<expr::assignment>()->target->is_var_ref(&vname)) {
          AddArgument(c, c->arguments, vname, false);
          arg.ptr_of<expr::assignment>()->target = new expr::evar(c, vname, 0, argc);
        }
        else if (arg->is_rest() && arg.ptr_of<expr::rest>()->principal->is_var_ref(&vname)) {
          AddArgument(c, c->arguments, vname, false);
          arg.ptr_of<expr::rest>()->principal = new expr::evar(c, vname, 0, argc);
        }
        else
          CsParseError(c, arg, "invalid argument of arrow function");
      }
    }
    else {
      tkn = do_arg_list(c, &c->arguments, pv, type);
    }

    assert(pv->is_of_type<expr::list>());
    expr::list* list = pv.ptr_of<expr::list>();
    for (int n = 0; n < list->elements.size(); ++n)
    {
      PVAL arg = list->elements[n];
      if (arg->is_rest()) {
        if (n != list->elements.last_index())
          CsParseError(c, arg, "must be last argument");
        cptr[0] = BC_AFRAMER;
        vcnt = 1;
        break;
      }
      if(arg->is_assignment())
      {
        int cnt = ++ocnt + rcnt;
        putcbyte(c, BC_ARGSGE);
        putcbyte(c, cnt);
        putcbyte(c, BC_BRT);
        nxt = putcword(c, 0);
        arg->do_fetch(c);
        fixup(c, nxt, codeaddr(c));
      }
      else {
        if (ocnt > 0)
          ++ocnt;
        else
          ++rcnt;
      }
    }


    switch (fct) {
    case FUNCTION: break;
    case FAT_ARROW: break;
    case UNDEFINED_PROPERTY:
    case PROPERTY:
      if (rcnt < 3 || ocnt != 0)
        CsParseError(c, "property requires at least one not optional argument");
      break;
    }

    /* fixup the function header */
    cptr[1] = byte(rcnt);
    assert(rcnt < 256);
    cptr[2] = byte(ocnt);
    assert(ocnt < 256);

    if (type == ':') /* lambda parsing */
    {
      require_or(c, tkn, '{', ':');
      if (tkn == ':') /* this is lambda declaration */
      {
        do_init_expr(c);
        // cannot use do_statement(c); here due to ',' parsing
        // return value of the lambda is a value of last expression seen so no
        // putcbyte(c,BC_NOTHING); here
        c->lineNumberChangedP = true;
        putcbyte(c, BC_RETURN);
        UnwindStack(c, c->blockLevel); // ???
      } else                           // if(tkn == '{')
      {
        /* compile the function body */
        do_block(c, 0);
        c->lineNumberChangedP = true;
        putcbyte(c, BC_NOTHING);
        putcbyte(c, BC_RETURN);
        UnwindStack(c, c->blockLevel); // ???
      }
    } else if (type == '|') /* '| |' lambda parsing */
    {
      if (fct == FAT_ARROW) {

        tkn = CsToken(c);
        if (tkn != '{') {
          CsSaveToken(c, tkn);
          goto PARSE_STATEMENT;
        }
        else
          goto PARSE_BLOCK;
  
      }
      else
        require_or(c, tkn, '{', '|');
      if (tkn == '|') /* this is lambda declaration */
      {
PARSE_STATEMENT:
        {
          PVAL pe;
          do_expr2(c, pe, true);
          if (transformer) {
            int tkn;
            while ((tkn = CsToken(c)) == ',') {
              transformer(pe);
              rvalue(c, pe);
              do_expr2(c, pe, true);
            }
            CsSaveToken(c, tkn);
            transformer(pe);
          }
          rvalue(c, pe);
        }
        // cannot use do_statement(c); here due to ',' parsing
        // return value of the lambda is a value of last expression seen so no
        // putcbyte(c,BC_NOTHING); here
        c->lineNumberChangedP = true;
        putcbyte(c, BC_RETURN);
        UnwindStack(c, c->blockLevel); // ???
      }
      else                           // if(tkn == '{')
      {
PARSE_BLOCK:
        /* compile the function body */
        do_block(c, 0);
        c->lineNumberChangedP = true;
        putcbyte(c, BC_NOTHING);
        putcbyte(c, BC_RETURN);
        UnwindStack(c, c->blockLevel); // ???
      }
    }
    else /* standard function parsing */
    {
      /* compile the function body */
      frequire(c, '{');
      if (fct == PROPERTY || fct == UNDEFINED_PROPERTY) {
        tool::string vname;
        if (list->elements.size() == 0 || !list->elements.last()->is_var_ref(&vname))
          CsParseError(c, list, "property declaration, parameter expected");
        do_property_block(c, vname);
      }
      else
        do_block(c, 0);
      /* add the return nothing, just in case */
      putcbyte(c, BC_NOTHING);
      // int end = NIL;
      // UnwindTryStack(c,end);
      // fixup(c,end,codeaddr(c));
      putcbyte(c, BC_RETURN);
      UnwindStack(c, c->blockLevel); // ???
    }

#ifdef TISCRIPT_DEBUGGER
    AddLineNumber(c, c->lineNumber, codeaddr(c));
#endif

    pvalue bytecodes(ic);
    pvalue lineNums(ic);
    pvalue argNames(ic);

    /* make the bytecode array */
    bytecodes = CsMakeByteVector(ic, c->cbase, int_t(c->cptr - c->cbase));
    lineNums  = AllocateLineNumbers(c);
    argNames  = AllocateArgNames(c, c->arguments, rcnt + ocnt + vcnt);

    /* make the literal vector */
    size = c->lptr - c->lbase;
    code = CsMakeCompiledCode(ic, CsFirstLiteral + size, bytecodes, lineNums, argNames, c->fileNameSymbol);
    CsSetCompiledCodeName(code, CsSymbolOf(name));
    src = CsVectorAddress(c->ic, c->literalbuf) + c->lbase;
    dst = CsCompiledCodeLiterals(code) + CsFirstLiteral;
    while (--size >= 0) {
      *dst++ = *src++;
    }

    uint flags = 0;
    if (c->yieldSeen)
      flags |= CODE_TYPE_GENERATOR;
    else if (c->functionType == GENERATOR)
      CsParseWarning(c, "'generator' does not contain any 'yield'");

    if (c->awaitSeen)
      flags |= CODE_TYPE_TASK;
    else if (c->functionType == ASYNC)
      CsParseWarning(c, "'async' does not contain any 'await'");

    CsSetCompiledCodeTypeFlags(code, flags);

    /* free the line number table */

    // if (name && c->emitLineNumbersP) {
    //    printf("%s:\n",name);
    //    DumpLineNumbers(c);
    //    printf("\n");
    //}

    FreeLineNumbers(c);

    /* pop the current argument frame and buffer pointers */
    PopArgFrame(c);
    c->cptr         = c->cbase;
    c->cbase        = oldcbase;
    c->lptr         = c->lbase;
    c->lbase        = oldlbase;
    c->bsp          = c->bsbase;
    c->bsbase       = oldbsbase;
    c->csp          = c->csbase;
    c->csbase       = oldcsbase;
    c->ssp          = c->ssbase;
    c->ssbase       = oldssbase;
    c->blockLevel   = oldLevel;
    c->lineNumbers  = oldlines;
    c->currentBlock = oldcblock;

    c->tcStack = save_tcStack;

    Optimize(c, bytecodes);

    /* make a closure */
    int lindex = addliteral(c, code);
    emit_literal(c, lindex);
    putcbyte(c, BC_CLOSE);
    putcbyte(c, fct);

    c->literalbuf = CsResizeVector(c->ic, c->literalbuf, literal_buf_size);
    return lindex;
  }

  static void do_store_if_defined(CsCompiler *c, expr::node* target) {
    int nxt = 0;
    putcbyte(c, BC_BR_UNDEFINED);
    nxt = putcword(c, NIL);
    target->do_store_only(c);
    fixup(c, nxt, codeaddr(c));
  }

  /* do_if - compile the 'if/else' expression */
  static void do_if(CsCompiler *c) {
    int tkn, nxt = 0, end;

    int     ptr    = 0; /* BC_FRAME arg offset */
    ATABLE *atable = nullptr;

    /* compile the test expression */
    do_test(c, &atable, &ptr);

    /* skip around the 'then' clause if the expression is false */
    putcbyte(c, BC_BRF);
    nxt = putcword(c, NIL);

    /* compile the 'then' clause */
    do_statement(c);

    // if((tkn != CsToken(c)) == ';')

    if (c->savedToken == ';') CsToken(c);

    /* compile the 'else' clause */
    if ((tkn = CsToken(c)) == T_ELSE) {
      putcbyte(c, BC_BR);
      end = putcword(c, NIL);
      fixup(c, nxt, codeaddr(c));
      do_statement(c);
      if (c->savedToken == ';') CsToken(c);

      nxt = end;
    } else
      CsSaveToken(c, tkn);

    /* handle the end of the statement */
    fixup(c, nxt, codeaddr(c));

    /* pop the local frame */
    if (atable) {
      CloseArgFrame(c, atable, ptr);
      --c->blockLevel;
    }
  }

  static void do_get_set(CsCompiler *c, bool get, const char *valName) {
    int nxt;

    PVAL pval;

    load_argument(c, valName,pval);
    pval->do_fetch(c);

    /* skip around the 'then' clause if the expression is false */
    if (get)
      putcbyte(c, BC_BRDEF);
    else
      putcbyte(c, BC_BRUNDEF);

    nxt = putcword(c, NIL);

    /* compile the 'then' clause */
    do_statement(c);
    if (c->savedToken == ';') CsToken(c);

    /* handle the end of the statement */
    fixup(c, nxt, codeaddr(c));
  }

  bool optToken(CsCompiler *c, int opttok) {
    int tok = CsToken(c);
    if (tok == opttok) return true;
    CsSaveToken(c, tok);
    return false;
  }

  bool optName(CsCompiler *c) {
    int tok = CsToken(c);
    if (tok != ':') {
      CsSaveToken(c, tok);
      return false;
    }
    tok = CsToken(c);
    if (tok != T_IDENTIFIER) {
      CsParseError(c, "Expecting name of the loop");
      return false;
    }
    return true;
  }

  /* do_with - compile the 'with' expression */
  static void do_with(CsCompiler *c) {
    /* compile the with expression */
    frequire(c, '(');
    do_expr(c);
    frequire(c, ')');
    putcbyte(c, BC_PUSH_NS);
    do_statement(c);
    putcbyte(c, BC_POP_NS);
  }

  /* do_while - compile the 'while' expression */
  static void do_while(CsCompiler *c) {
    SENTRY *ob, *oc;
    int     nxt = 0, end;

    int     ptr    = 0; /* BC_FRAME arg offset */
    ATABLE *atable = nullptr;

    tool::string name;
    if (optName(c)) name = c->t_token;

    /* compile the test expression */
    do_test(c, &atable, &ptr, &nxt);

    /* skip around the loop body if the expression is false */
    putcbyte(c, BC_BRF);
    end = putcword(c, NIL);

    /* compile the loop body */
    ob = addbreak(c, end, name);
    oc = addcontinue(c, nxt);
    do_statement(c);
    end = rembreak(c, ob, end);
    remcontinue(c, oc);

    /* branch back to the start of the loop */
    putcbyte(c, BC_BR);
    putcword(c, nxt);

    /* handle the end of the statement */
    fixup(c, end, codeaddr(c));

    /* pop the local frame */
    if (atable) {
      CloseArgFrame(c, atable, ptr);
      --c->blockLevel;
    }
  }

  /* do_dowhile - compile the do/while' expression */
  static void do_dowhile(CsCompiler *c) {
    SENTRY *ob, *oc;
    int     nxt, end = 0, body, tst = 0;

    tool::string name;
    if (optName(c)) name = c->t_token;

    putcbyte(c, BC_BR); // jump straight to the body of the loop
    body = putcword(c, NIL);

    /* remember the start of the loop */
    nxt = codeaddr(c);
    putcbyte(c, BC_BR);
    tst = putcword(c, NIL);

    body = fixup(c, body, codeaddr(c));

    /* compile the loop body */
    ob = addbreak(c, 0, name);
    oc = addcontinue(c, nxt);
    do_statement(c);
    end = rembreak(c, ob, end);
    remcontinue(c, oc);

    fixup(c, tst, codeaddr(c));
    /* compile the test expression */
    frequire(c, T_WHILE);
    do_test(c);

    frequire(c, ';');

    /* branch to the top if the expression is true */
    putcbyte(c, BC_BRT);
    putcword(c, body);

    /* handle the end of the statement */
    fixup(c, end, codeaddr(c));
  }

  static void do_for_in(CsCompiler *c, PVAL& pv, const tool::string &name);

  static void CloseArgFrame(CsCompiler *c, ATABLE *atable,
                            int ptr /* BC_FRAME arg offset */) {
    int arg_cnt   = ArgumentsCount(c, atable); // tcnt;
    c->cbase[ptr] = byte(arg_cnt);
#ifdef TISCRIPT_DEBUGGER
    {
      int off = c->cbase[ptr + 1];
      off |= c->cbase[ptr + 2] << 8;
      value name_vector = CsMakeTuple(c->ic, arg_cnt);

      ARGUMENT *arg = atable->at_arguments;
      for (int n = 0; n < arg_cnt && arg != nullptr; ++n, arg = arg->arg_next)
        CsSetTupleElement(name_vector, n, CsSymbolOf(arg->arg_name));

      setliteral(c, off, name_vector);
    }
#endif
    putcbyte(c, BC_UNFRAME);
    PopArgFrame(c);
  }

  /* do_for - compile the 'for' statement */
  static void do_for(CsCompiler *c) {
    int     tkn, nxt, end, body, update;
    SENTRY *ob, *oc;

    int ptr = 0; /* BC_FRAME arg offset */
    // int tcnt = 0; /* num locals */
    ATABLE *atable = nullptr;
    //++c->blockLevel;

    tool::string name;
    if (optName(c)) name = c->t_token;

    /* compile the initialization expression */

    frequire(c, '(');

    PVAL pv;
    do_for_initialization(c, pv, &atable, &ptr);

    tkn = CsToken(c);
    if (tkn == T_IN || is_of_token(c,tkn)) {
      do_for_in(c, pv, name);
      goto END;
    }

    rvalue(c, pv);
    require(c, tkn, ';');

    /* compile the test expression */
    nxt = codeaddr(c);
    if ((tkn = CsToken(c)) == ';')
      putcbyte(c, BC_T);
    else {
      CsSaveToken(c, tkn);
      do_expr(c);
      frequire(c, ';');
    }

    /* branch to the loop body if the expression is true */
    putcbyte(c, BC_BRT);
    body = putcword(c, NIL);

    /* branch to the end if the expression is false */
    putcbyte(c, BC_BR);
    end = putcword(c, NIL);

    /* compile the update expression */
    update = codeaddr(c);
    if ((tkn = CsToken(c)) != ')') {
      CsSaveToken(c, tkn);
      do_expr(c);
      frequire(c, ')');
    }

    /* branch back to the test code */
    putcbyte(c, BC_BR);
    putcword(c, nxt);

    /* compile the loop body */
    fixup(c, body, codeaddr(c));
    ob = addbreak(c, end, name);
    oc = addcontinue(c, update);
    do_statement(c);
    end = rembreak(c, ob, end);
    remcontinue(c, oc);

    /* branch back to the update code */
    putcbyte(c, BC_BR);
    putcword(c, update);

    /* handle the end of the statement */
    fixup(c, end, codeaddr(c));

    /* pop the local frame */
  END:
    if (atable) {
      CloseArgFrame(c, atable, ptr);
      --c->blockLevel;
    }
    //
  }

    /* do_for_in - compile the 'for' .. 'in' statement */

#if 0
// old variant, no 'otherwise' support
static void do_for_in(CsCompiler *c, PVAL* pv, const tool::string& name)
{
    int end,body;
    int nxt;
    SENTRY *ob,*oc;

    chklvalue(c,pv);

    PVAL pv2;
    do_right_side_expr(c,&pv2);
    rvalue(c,&pv2);

    putcbyte(c,BC_PUSH);         // sp-1  - our collection object

    frequire(c,')');

    putcbyte(c,BC_NOTHING);
    //(*pv->fcn)(c,STORE,pv);
    pv->store_l_value(c);

    putcbyte(c,BC_PUSH);         // sp-0  - index variable

    nxt = codeaddr(c);

    putcbyte(c,BC_NEXT);         // val  <- nextelement( index, collection, num_of_returns )
    putcword(c,pv->count());     // num_of_returns
    //(*pv->fcn)(c,STORE,pv);
    pv->store_l_value(c);

    // branch to the loop body if the expression != nothingValue
    putcbyte(c,BC_BRDEF);
    body = putcword(c,NIL);

    /* branch to the end */
    putcbyte(c,BC_BR);
    end = putcword(c,NIL);

    /* compile the loop body */
    fixup(c,body,codeaddr(c));
    ob = addbreak(c,end,name);
    oc = addcontinue(c,nxt);
    do_statement(c);
    end = rembreak(c,ob,end);
    remcontinue(c,oc);

    /* branch back to the nxt code */
    putcbyte(c,BC_BR);
    putcword(c,nxt);

    /* handle the end of the statement */
    fixup(c,end,codeaddr(c));

    putcbyte(c,BC_DROP);       // index variable
    putcbyte(c,BC_DROP);       // sp-1  - our collection object

}

#else

  // new variant, with 'otherwise' support

  /* do_for_in - compile the 'for' .. 'in' statement */
  static void do_for_in(CsCompiler *c, PVAL& pv, const tool::string &name) {
    int     end, body;
    int     nxt;
    SENTRY *ob, *oc;

    chklvalue(c, pv);

    if (pv->is_list() && pv->length() == 1) {
      // code below is critical to length of the lis, it shall be either list(2) or not list at all.
      handle<expr::list> list = pv.ptr_of<expr::list>();
      pv = list->elements[0];
    }

    PVAL pv2;
    do_right_side_expr(c, pv2);
    rvalue(c, pv2);

    putcbyte(c, BC_PUSH_VALUE); // sp-1  - our collection object

    frequire(c, ')');

    putcbyte(c, BC_NOTHING);

    putcbyte(c, BC_PUSH_VALUE); // sp-0  - index variable

    // intial next
    putcbyte(c, BC_NEXT); // val  <- nextelement( index, collection, num_of_returns )
    putcword(c, (int)pv->length()); // num_of_returns
    pv->do_store(c);
    // branch to the loop body if the expression != nothingValue
    putcbyte(c, BC_BRDEF);
    body = putcword(c, NIL);
    /* branch to the else */
    putcbyte(c, BC_BR);
    int else_body = putcword(c, NIL);

    //  next iteration
    nxt = codeaddr(c);

    putcbyte(c, BC_NEXT); // val  <- nextelement( index, collection, num_of_returns )
    putcword(c, (int) pv->length()); // num_of_returns

    pv->do_store(c);

    // branch to the loop body if the expression != nothingValue
    putcbyte(c, BC_BRDEF);
    body = putcword(c, body);

    /* branch to the end */
    putcbyte(c, BC_BR);
    end = putcword(c, NIL);

    /* compile the loop body */
    fixup(c, body, codeaddr(c));
    ob = addbreak(c, end, name);
    oc = addcontinue(c, nxt);

    do_statement(c);

    if (c->savedToken == ';') CsToken(c);

    end = rembreak(c, ob, end);
    remcontinue(c, oc);

    /* branch back to the nxt code */
    putcbyte(c, BC_BR);
    putcword(c, nxt);

    int tkn = CsToken(c);
    if (tkn == T_OTHERWISE) {
      fixup(c, else_body, codeaddr(c));
      do_statement(c);
      if (c->savedToken == ';') CsToken(c);
    } else {
      CsSaveToken(c, tkn);
      fixup(c, else_body, codeaddr(c));
    }

    /* handle the end of the statement */
    fixup(c, end, codeaddr(c));

    putcbyte(c, BC_DROP); // index variable
    putcbyte(c, BC_DROP); // sp-1  - our collection object
    //putcbyte(c, BC_RESET_RVAL);
  }

#endif

  /* addbreak - add a break level to the stack */
  static SENTRY *addbreak(CsCompiler *c, int lbl, const tool::string &name) {
    SENTRY *old = c->bsp;
    if (++c->bsp < &c->bstack[SSIZE]) {
      c->bsp->level = c->blockLevel;
      c->bsp->label = lbl;
      c->bsp->name  = name;
    } else
      CsParseError(c, "Too many nested loops");
    return old;
  }

  /* rembreak - remove a break level from the stack */
  static int rembreak(CsCompiler *c, SENTRY *old, int lbl) {
    return c->bsp > old ? (c->bsp--)->label : lbl;
  }

  /* do_break - compile the 'break' statement */
  static void do_break(CsCompiler *c) {
    if (c->bsp > c->bsbase) {
      tool::string name;
      if (optToken(c, T_IDENTIFIER)) {
        name = c->t_token;
        CsSaveToken(c, CsToken(c));

        SENTRY *pent = c->bsp;
        while (pent >= c->bsbase) {
          if (pent->name == name) {
            UnwindStack(c, c->blockLevel - pent->level);
            putcbyte(c, BC_BR);
            pent->label = putcword(c, pent->label);
            return;
          }
          --pent;
        }
        CsParseError(c, "Loop with such name is not found");
      } else {
        if (c->tcStack && c->bsp->level <= c->tcStack->blockLevel) {
          int end = NIL;
          UnwindTryStack(c, end);
          fixup(c, end, codeaddr(c));
          putcbyte(c, BC_BR);
          c->bsp->label = putcword(c, c->bsp->label);
        } else {
          UnwindStack(c, c->blockLevel - c->bsp->level);
          putcbyte(c, BC_BR);
          c->bsp->label = putcword(c, c->bsp->label);
        }
      }
    } else
      CsParseError(c, "Break outside of loop or switch");
  }

  /* addcontinue - add a continue level to the stack */
  static SENTRY *addcontinue(CsCompiler *c, int lbl) {
    SENTRY *old = c->csp;
    if (++c->csp < &c->cstack[SSIZE]) {
      c->csp->level = c->blockLevel;
      c->csp->label = lbl;
    } else
      CsParseError(c, "Too many nested loops");
    return old;
  }

  /* remcontinue - remove a continue level from the stack */
  static void remcontinue(CsCompiler *c, SENTRY *old) { c->csp = old; }

  /* do_continue - compile the 'continue' statement */
  static void do_continue(CsCompiler *c) {
    if (c->csp > c->csbase) {
      tool::string name;
      if (optToken(c, T_IDENTIFIER)) {
        name = c->t_token;
        CsSaveToken(c, CsToken(c));
        SENTRY *pent  = c->bsp;
        SENTRY *pcent = c->csp;
        while (pent >= c->bsbase) {
          if (pent->name == name) {
            UnwindStack(c, c->blockLevel - pent->level);
            putcbyte(c, BC_BR);
            putcword(c, pcent->label);
            return;
          }
          --pent;
          --pcent;
        }
        CsParseError(c, "Loop with such name is not found");
      } else {
        if (c->tcStack && c->bsp->level <= c->tcStack->blockLevel) {
          CsParseError(c, "continue exit from try block is not supported");
          /*int end = NIL;
          UnwindTryStack(c,end);
          fixup(c,end,codeaddr(c));
          putcbyte(c,BC_BR);
          putcword(c,c->csp->label);*/
        } else {
          UnwindStack(c, c->blockLevel - c->csp->level);
          putcbyte(c, BC_BR);
          putcword(c, c->csp->label);
        }
      }
    } else
      CsParseError(c, "Continue outside of loop");
  }

  /* UnwindStack - pop frames off the stack to get back to a previous nesting
   * level */
  static void UnwindStack(CsCompiler *c, int levels) {
    while (--levels >= 0)
      putcbyte(c, BC_UNFRAME);
  }

  static void UnwindTryStack(CsCompiler *c, int &retaddr) {
    int levels = c->blockLevel;

    if (!c->tcStack) {
      for (; levels > 0; --levels)
        putcbyte(c, BC_UNFRAME);
      return;
    }

    CsCompiler::TryCatchDef *ptcsi = c->tcStack;
    // order: innermost finally first
    while (ptcsi) {
      if (ptcsi->inTry) putcbyte(c, BC_EH_POP);

      for (; ptcsi->blockLevel < levels; --levels)
        putcbyte(c, BC_UNFRAME);

      putcbyte(c, BC_S_CALL);
      ptcsi->finallyAddr = putcword(c, ptcsi->finallyAddr);
      ptcsi              = ptcsi->prev;
    }
    for (; levels > 0; --levels)
      putcbyte(c, BC_UNFRAME);
    putcbyte(c, BC_BR);
    retaddr = putcword(c, retaddr);
  }

  /* addswitch - add a switch level to the stack */
  static SWENTRY *addswitch(CsCompiler *c) {
    SWENTRY *old = c->ssp;
    if (++c->ssp < &c->sstack[SSIZE]) {
      c->ssp->nCases       = 0;
      c->ssp->cases        = nullptr;
      c->ssp->defaultLabel = NIL;
    } else
      CsParseError(c, "Too many nested switch statements");
    return old;
  }

  /* remswitch - remove a switch level from the stack */
  static void remswitch(CsCompiler *c, SWENTRY *old) {
    CENTRY *entry, *next;
    for (entry = c->ssp->cases; entry != nullptr; entry = next) {
      next = entry->next;
      CsFree(c->ic, entry);
    }
    c->ssp = old;
  }

    /* do_switch - compile the 'switch' statement */

#if 0
static void do_switch(CsCompiler *c)
{
    int pdispatch,end,cnt;
    SENTRY *ob;
    SWENTRY *os;
    CENTRY *e;

    /* compile the test expression */
    do_test(c);

    /* branch to the pdispatch code */
    putcbyte(c,BC_BR);
    pdispatch = putcword(c,NIL);

    /* compile the body of the switch statement */
    os = addswitch(c);
    ob = addbreak(c,0);
    do_statement(c);
    end = rembreak(c,ob,0);

    /* branch to the end of the statement */
    putcbyte(c,BC_BR);
    end = putcword(c,end);

    /* compile the pdispatch code */
    fixup(c,pdispatch,codeaddr(c));
    putcbyte(c,BC_SWITCH);
    putcword(c,c->ssp->nCases);

    /* output the case table */
    cnt = c->ssp->nCases;
    e = c->ssp->cases;
    while (--cnt >= 0) {
        putcword(c,e->value);
        putcword(c,e->label);
        e = e->next;
    }
    if (c->ssp->defaultLabel)
        putcword(c,c->ssp->defaultLabel);
    else
        end = putcword(c,end);

    /* resolve break targets */
    fixup(c,end,codeaddr(c));

    /* remove the switch context */
    remswitch(c,os);
}
#endif

  static void do_switch(CsCompiler *c) {
    PVAL pv;
    int  nxt = 0, nxtbody = 0, end = 0, dflt = 0;

    ATABLE *atable = nullptr;
    int     ptr    = 0; /* BC_FRAME arg offset */

    SENTRY *old_break;

    frequire(c, '(');
    do_expr1(c, pv);
    rvalue(c, pv);
    frequire(c, ')');

    {
      InjectArgFrame(c, &atable, &ptr);
      AddArgument(c, atable, ".", true);
      putcbyte(c, BC_ESET);
      putcbyte(c, 0);
      putcbyte(c, 1);
    }

    frequire(c, '{');

    old_break = addbreak(c, 0);

    // putcbyte (c, BC_PUSH );

    int tkn;
    while ((tkn = CsToken(c)) != T_EOF) {
      if (tkn == '}') break;

      int  cmpop = 0;
      bool negation = false;

      switch (tkn) {
        case T_CASE: cmpop = BC_EQ; break;
        case T_LIKE: cmpop = BC_MATCH; break;
        case T_INSTANCEOF: cmpop = BC_INSTANCEOF; break;
        case T_IN: cmpop = BC_IN; break;
        case '!': {
          int tkn2 = CsToken(c);
          switch (tkn2) {
            case T_LIKE: cmpop = BC_MATCH; break;
            case T_INSTANCEOF: cmpop = BC_INSTANCEOF; break;
            case T_IN: cmpop = BC_IN; break;
            default: CsParseError(c, "Unexpecteted token in switch"); break;
          }
          negation = true;
          break;
        }
      }

      if (cmpop) {
        if (nxt) {
          putcbyte(c, BC_BR);
          nxtbody = putcword(c, 0);
          fixup(c, nxt, codeaddr(c));
        } else
          nxtbody = 0;

        // putcbyte   (c, BC_DUP );
        putcbyte(c, BC_EREF);
        putcbyte(c, 0);
        putcbyte(c, 1);
        putcbyte(c, BC_PUSH_VALUE);

        do_call_param_expr(c, pv);
        rvalue(c, pv);
        frequire(c, ':');
        //putcbyte(c, tkn == T_LIKE ? BC_MATCH : BC_EQ);
        putcbyte(c, cmpop);
        putcbyte(c, negation ? BC_BRT : BC_BRF);
        nxt = putcword(c, 0);
        if (nxtbody) {
          fixup(c, nxtbody, codeaddr(c));
          nxtbody = 0;
        }
      } else if (tkn == T_DEFAULT) {
        frequire(c, ':');
        if (nxt == 0) {
          putcbyte(c, BC_BR);
          nxt = putcword(c, 0);
        }
        dflt = codeaddr(c);
      } else {
        if (nxt == 0) CsParseError(c, "Unexpecteted token in switch");
        CsSaveToken(c, tkn);
        do_statement(c);
      }
    }

    end = rembreak(c, old_break, end);

    if (nxt) {
      if (dflt)
        fixup(c, nxt, dflt);
      else
        fixup(c, nxt, codeaddr(c));
    }

    // handle the end of the statement
    fixup(c, end, codeaddr(c));
    // putcbyte (c, BC_DROP );

    // if (atable)
    //{
    CloseArgFrame(c, atable, ptr);
    --c->blockLevel;
    //}
  }

#if 0

/* do_case - compile the 'case' statement */
static void do_case(CsCompiler *c)
{
    if (c->ssp > c->ssbase) {
        CENTRY **pNext,*entry;
        int val;
        int tok;
        /* get the case value */
        switch (tok = CsToken(c)) {

        case '-':
            tok = CsToken(c);
            if(tok == T_INTEGER)
              val = addliteral(c,CsMakeInteger(c->ic,-c->t_value));
            else if(tok == T_FLOAT)
              val = addliteral(c,CsMakeFloat(c->ic,-c->t_value));
            else
              goto BAD;
            break;
        case '+':
            tok = CsToken(c);
            if(tok == T_INTEGER)
              val = addliteral(c,CsMakeInteger(c->ic,c->t_value));
            else if(tok == T_FLOAT)
              val = addliteral(c,CsMakeFloat(c->ic,c->t_value));
            else
              goto BAD;
            break;
        case T_INTEGER:
            val = addliteral(c,CsMakeInteger(c->ic,c->t_value));
            break;
        case T_FLOAT:
            val = addliteral(c,CsMakeFloat(c->ic,c->t_fvalue));
            break;
        case T_STRING:
            val = addliteral(c,CsMakeCString(c->ic,c->get_wtoken_string()));
            break;
        case T_NULL:
            val = addliteral(c,c->ic->nullValue);
            break;
        case T_SYMBOL:
            val = addliteral(c,CsSymbolOf(c->t_token));
            break;
       case T_IDENTIFIER:
          {
            char tname[256];
            strncpy(tname,c->t_token, 255);
            if ( CsToken(c) == '.' && CsToken(c) == T_IDENTIFIER )
            {
                value cv;
                if( CsGetConstantValue(c->ic,tname,c->t_token,&cv ))
                {
                  val = addliteral(c,cv);
                  break;
                }
            }
          }
          // fall through.
        default:
          {
BAD:
            const char* n = CsTokenName(tok);
            CsParseError(c,"Expecting a literal value as <case> expression");
            val = 0; /* never reached */
          }
        }
        frequire(c,':');

        /* find the place to add the new case */
        for (pNext = &c->ssp->cases; (entry = *pNext) != nullptr; pNext = &entry->next) {
            if (val < entry->value)
                break;
            else if (val == entry->value)
                CsParseError(c,"Duplicate case");
        }

        /* add the case to the list of cases */
        if ((entry = (CENTRY *)CsAlloc(c->ic,sizeof(CENTRY))) == nullptr)
            CsInsufficientMemory(c->ic);
        entry->value = val;
        entry->label = codeaddr(c);
        entry->next = *pNext;
        *pNext = entry;

        /* increment the number of cases */
        ++c->ssp->nCases;
    }
    else
        CsParseError(c,"Case outside of switch");
}

/* do_default - compile the 'default' statement */
static void do_default(CsCompiler *c)
{
    if (c->ssp > c->ssbase) {
        frequire(c,':');
        c->ssp->defaultLabel = codeaddr(c);
    }
    else
        CsParseError(c,"Default outside of switch");
}

#endif

  /* do_try - compile the 'try' statement */

  static void do_try(CsCompiler *c) {

    int tkn;
    int catchaddr, end;

    /* compile the protected block */
    frequire(c, '{');

    CsCompiler::TryCatchDef tcdef;
    tcdef.blockLevel = c->blockLevel;
    tcdef.prev       = c->tcStack;
    c->tcStack       = &tcdef;

    putcbyte(c, BC_EH_PUSH);
    catchaddr = putcword(c, NIL);

    do_block(c, "-"); // "-" is a fake var to force frame to be created, needed
                      // to generate

    /* pop error handler */

    putcbyte(c, BC_EH_POP);
    tcdef.inTry = false;

    /* branch to the 'finally' code */
    putcbyte(c, BC_S_CALL);
    tcdef.finallyAddr = putcword(c, tcdef.finallyAddr);

    putcbyte(c, BC_BR);
    end = putcword(c, NIL);

    fixup(c, catchaddr, codeaddr(c));

    /* handle a 'catch' clause */
    if ((tkn = CsToken(c)) == T_CATCH) {
      char name[TKNSIZE + 1];
      /* get the formal parameter */

      frequire(c, '(');
      frequire(c, T_IDENTIFIER);
      strcpy_s(name, c->t_token);
      frequire(c, ')');

      /* compile the catch block */

      /* thrown var (error) is in intepreter->val,
         load it into T_IDENTIFIER (name) (first var in the CFRAME) */

      frequire(c, '{');
      do_block(c, name);
      tkn = CsToken(c);

      putcbyte(c, BC_S_CALL);
      tcdef.finallyAddr = putcword(c, tcdef.finallyAddr);

      putcbyte(c, BC_BR);
      end = putcword(c, end);

    } else // try {} [finally {}] case (no catch at all)
    {
      require_or(c, tkn, T_TRY, T_FINALLY);
      // execute finally
      putcbyte(c, BC_S_CALL);
      tcdef.finallyAddr = putcword(c, tcdef.finallyAddr);
      // we can get here if only if error was thrown
      // so just rethrow the error:
      putcbyte(c, BC_THROW);
      // putcbyte ( c, BC_BR);
      // end = putcword(c,end);
    }

    /* start of the 'finally' code or the end of the statement */
    fixup(c, tcdef.finallyAddr, codeaddr(c));
    c->tcStack = tcdef.prev;

    /* handle a 'finally' clause */
    if (tkn == T_FINALLY) {
      frequire(c, '{');
      putcbyte(c, BC_PUSH);
      do_block(c, 0);
      putcbyte(c, BC_DROP);
    } else {
      CsSaveToken(c, tkn);
    }
    putcbyte(c, BC_S_RETURN);

    /* handle the end of the statement */
    fixup(c, end, codeaddr(c));
  }

  /* do_throw - compile the 'throw' statement */
  static void do_throw(CsCompiler *c) {
    do_expr(c);
    putcbyte(c, BC_THROW);
    //frequire(c, ';'); - optional
  }

  /* handle local declarations */

  static PVAL do_var_local_list(CsCompiler *c, bool is_var /*false - const*/, int tok_eol) {
    PVAL pv;
    do_var_local_list(c, &c->arguments, pv, ArgumentsCount(c, c->arguments), is_var, tok_eol);
    return pv;
  }

  static void do_var_local_list(CsCompiler *c, ATABLE **patable, PVAL& pv, int acnt, bool is_var /*false - const*/, int tok_eol) {

    expr::list::LIST_TYPE list_type;

    switch (tok_eol) {
      default: assert(false);
      case ')': list_type = expr::list::VARS; break;
      case ']': list_type = expr::list::VECTOR; break;
      case '}': list_type = expr::list::MAP; break;
    }

    handle<expr::list> ls = new expr::list(c,list_type, is_var);
    pv = ls;

    int  tkn;
    bool rest = false;
    do {
      PVAL pv2;
      tkn = CsToken(c);//frequire_or(c, T_IDENTIFIER, T_EVENT,',',tok_eol);
      if (tkn == ',')
      {
        pv2 = new expr::noop(c);
        ls->elements.push(pv2);
        continue;
      }
      else if (tkn == tok_eol)
        break;
      else if (tkn == T_DOTDOTDOT) // new "rest" case : ...a
      {
        rest = true;
        tkn = frequire_or(c, T_IDENTIFIER, T_EVENT);
      }

      if (tkn != T_IDENTIFIER && tkn != T_EVENT)
        CsParseError(c, "invalid destructuring assignment sequence");

      string this_name = c->t_token;
      string that_name = this_name;

      if (list_type == expr::list::MAP) {
        tkn = CsToken(c);
        if ((tkn == ':') || is_as_token(c, tkn)) {
          frequire(c, T_IDENTIFIER);
          this_name = c->t_token;
          //tkn = CsToken(c);
        }
        else
          CsSaveToken(c,tkn);
      }

      AddArgument(c, *patable, this_name, !is_var);
      acnt += 1;

      // handling of old "rest" case: a...
      if (!rest) {
        tkn = CsToken(c);
        if (tkn == T_DOTDOT || tkn == T_DOTDOTDOT)
          rest = true;
        else
          CsSaveToken(c, tkn);
      }

      pv2 = new expr::evar(c, this_name, 0, acnt);

      if (rest) {
        pv2 = new expr::rest(c, pv2);
        ls->elements.push(pv2);
        frequire(c, tok_eol);
        break;
      }
      else {
        tkn = CsToken(c);
      }

      if ((list_type == expr::list::MAP) && (this_name != that_name))
        pv2 = new expr::pair(c, new expr::literal(c, tool::value(that_name)), pv2);

      if (tkn == '=') {
        PVAL rv;
        do_call_param_expr(c, rv, false);
        pv2 = new expr::assignment(c, pv2, rv);
        // rvalue(c, rv);
        // (*pv->fcn)(c, STORE, pv);
        tkn = CsToken(c);
      }

      ls->elements.push(pv2);

      if (tkn == ',') {
        //pv->push(c);
        continue;
      }
      CsSaveToken(c, tkn);
    } while (true);
  }


  static void do_var_local(CsCompiler *c, ATABLE **patable, int *pptr, PVAL& pvout, int *next) {
    int tkn;

    InjectArgFrame(c, patable, pptr);

    int acnt = ArgumentsCount(c, *patable);

    expr::list* out_list = nullptr;

    // parse each variable and initializer
    do {
      PVAL pv;
      string name;
      switch (tkn = CsToken(c)) {
        case T_EVENT: /*it is valid variable name*/
        case T_IDENTIFIER:
          name = c->t_token;
          AddArgument(c, *patable, name, false);
          acnt += 1;
          pv = new expr::evar(c, name,0, acnt);
          break;
        case '(': do_var_local_list(c, patable, pv, acnt, true, ')'); break;
        case '[': do_var_local_list(c, patable, pv, acnt, true, ']'); break;
        case '{': do_var_local_list(c, patable, pv, acnt, true, '}'); break;

        default: require_or(c, tkn, T_IDENTIFIER, '('); break;
      }

      if ((tkn = CsToken(c)) == '=') {
        if (next && *next == 0) *next = codeaddr(c);
        PVAL pv2;
        do_right_side_expr(c, pv2);
        //pv2->do_fetch(c); pv->do_store(c);
        pv = new expr::assignment(c, pv, pv2);
      }
      else {
        //pv = new expr::assignment(pv, new expr::literal_code(BC_UNDEFINED));
        CsSaveToken(c, tkn);
      }

      if ((tkn = CsToken(c)) == ',') {
        if (!out_list) {
          out_list = new expr::list(c, expr::list::EXPRESSIONS, true);
          pvout = out_list;
        }
        out_list->elements.push(pv);
      }
      else {
        if (out_list)
          out_list->elements.push(pv);
        else
          pvout = pv;
        break;
      }

    } while (tkn);

    // if( tkn != ';' ) //must always do:
    CsSaveToken(c, tkn);
    // 'cause: for(var i=0 ; ...)
  }

  PVAL declare_local_name(CsCompiler *c,const string& name, bool is_var) {
    int off = ArgumentsCount(c, c->arguments) + 1;
    AddArgument(c, c->arguments, name, !is_var);
    return is_var
      ? new expr::evar(c, name, 0, off)
      : new expr::evar_immutable(c, name, 0, off);
  }

  PVAL declare_global_name(CsCompiler *c, const string& name, bool is_var) {
    return
      new expr::gvar(c, name, is_var ? expr::gvar::NEW_NAMESPACE_VAR : expr::gvar::NEW_NAMESPACE_CONST);
  }


  static void do_var_local(CsCompiler *c, ATABLE **patable, int *pptr) {
    PVAL pv;
    do_var_local(c, patable, pptr, pv);
    rvalue(c, pv);
  }

  static void do_const_local(CsCompiler *c, ATABLE **patable, int *pptr) {
    int tkn;

    InjectArgFrame(c, patable, pptr);

    int acnt = ArgumentsCount(c, *patable);

    // parse each variable and initializer
    do {
      PVAL pv;
      string name;
      switch (tkn = CsToken(c)) {
      case T_EVENT: /*it is valid variable name*/
      case T_IDENTIFIER:
        name = c->t_token;
        AddArgument(c, *patable, name, true);
        acnt += 1;
        pv = new expr::evar(c, name, 0, acnt);
        break;
      case '(': do_var_local_list(c, patable, pv, acnt, false, ')'); break;
      case '[': do_var_local_list(c, patable, pv, acnt, false, ']'); break;
      case '{': do_var_local_list(c, patable, pv, acnt, false, '}'); break;
      default: require_or(c, tkn, T_IDENTIFIER, '('); break;
      }

      if ((tkn = CsToken(c)) == '=') {
        PVAL pv2;
        do_right_side_expr(c, pv2);
        pv2->do_fetch(c);
        pv->do_store(c);
      } else
        // CsSaveToken(c,tkn);
        CsParseError(c, "Expecting '=' and constant intialization");
    } while ((tkn = CsToken(c)) == ',');

    // if( tkn != ';' ) //must always do:
    CsSaveToken(c, tkn);
    // 'cause: for(var i=0 ; ...)
  }

  // static void do_const_local(CsCompiler *c, ATABLE **patable, int *pptr)
  //{
  //    int tkn;
  //
  //    InjectArgFrame(c, patable, pptr);
  //
  //    int acnt = ArgumentsCount(c,*patable);
  //
  //    /* parse each variable and initializer */
  //    do {
  //        char name[TKNSIZE+1];
  //        frequire(c,T_IDENTIFIER);
  //        strcpy_s(name,c->t_token);
  //
  //        if ((tkn = CsToken(c)) == '=') {
  //            do_init_expr(c);
  //            putcbyte(c,BC_ESET);
  //            putcbyte(c,0);
  //            putcbyte(c,1 + acnt);
  //        }
  //        else
  //          CsParseError(c,"Expecting '=' and constant intialization");
  //        AddArgument(c,*patable,name, true);
  //        acnt += 1;
  //    } while ((tkn = CsToken(c)) == ',');
  //
  //    //if( tkn != ';' )
  //    CsSaveToken(c,tkn);
  //    //require(c,tkn,';');
  //}

  static void do_include(CsCompiler *c) {
    int  tkn    = CsToken(c);
    bool native = false;
    if (tkn == T_IDENTIFIER && strcmp(c->t_token, "library") == 0)
      native = true;
    else
      CsSaveToken(c, tkn);

#if 1
    PVAL pv;
    do_right_side_expr(c, pv);
    rvalue(c, pv);
#else
    frequire(c, T_STRING);
    tool::ustring path = c->get_wtoken_string();
    do_lit_string(c, path);
#endif
    putcbyte(c, native ? BC_INCLUDE_LIBRARY : BC_INCLUDE);
  }

  // caller consumed T_IMPORT
  static void do_import(CsCompiler *c) {

    //bool local = c->arguments != nullptr;

    int  tkn = CsToken(c);

    PVAL pvnames, pvall, pvdefault;

    if (tkn == '{') {
      pvnames = do_var_global_list(c, false, '}');
    }
    else if(tkn == T_IDENTIFIER) { // default importing
      pvdefault = declare_global_name(c, c->t_token, false);
    }
    else if (tkn == '*') {
      tkn = CsToken(c);
      if (!is_as_token(c, tkn))
        CsParseError(c, "expecting 'as'");
      frequire(c, T_IDENTIFIER);
      pvall = declare_global_name(c, c->t_token, false);
    }
    else
      CsSaveToken(c, tkn);

    tkn = CsToken(c);

    if( !is_from_token(c,tkn) )
      CsParseError(c, "expecting 'from'");

    frequire(c, T_STRING);

    PVAL pvurl = new expr::literal(c, tool::value(c->t_wtoken()));

    pvurl->do_fetch(c);
    putcbyte(c, BC_IMPORT);

    if (pvdefault) {

      putcbyte(c, BC_GETP_NTH);
      putcword(c, 0);
      pvdefault->do_store(c);
    }

    if (pvall) {
      pvall->do_store(c);
    }
    if (pvnames) {
      if (!pvnames->is_list()) {
        expr::list* pl = new expr::list(c, expr::list::MAP, false);
        pl->elements.push(pvnames);
        pvnames = pl;
      }
      pvnames->do_store(c);
    }

  }

  static DECORATOR_OF do_decorator_parameter(CsCompiler *c, PVAL& pv,
                                             tool::string &name);

  /* compile decorator:
     @something p1 p2 @something p3 p4
  */

  static DECORATOR_OF do_decorator(CsCompiler *c, string& name) {
    int          tkn, n = 2;
    DECORATOR_OF got_something = GOT_NOTHING;

    PVAL pv;

    frequire(c, T_IDENTIFIER);
    findvariable(c, c->t_token, pv);

    while ((tkn = CsToken(c)) == '.')
      do_prop_reference(c, pv);
    CsSaveToken(c, tkn);

    /* get the value of the function */
    rvalue(c, pv);
    putcbyte(c, BC_PUSH);
    putcbyte(c, BC_PUSHSCOPE);

    /* compile each argument expression */
    for (tkn = CsToken(c); tkn; tkn = CsToken(c)) {
      if (tkn == ';') // empty decorator (without function)
      {
        putcbyte(c, BC_NULL);
        putcbyte(c, BC_PUSH);
        ++n;
        break;
      } else if (tkn == ',')
        continue;
      CsSaveToken(c, tkn);
      PVAL tpv;
      got_something = do_decorator_parameter(c, tpv, name);
      rvalue(c, tpv);
      putcbyte(c, BC_PUSH);
      ++n;
      if (got_something) break;
    }
    if (!tkn) CsParseError(c, "Expecting function or lambda declaration");

    /* call the function */

    putcbyte(c, BC_ROTATE);
    putcbyte(c, n - 2);

    putcbyte(c, BC_CALL);
    putcbyte(c, n);

    return got_something;
  }

  static DECORATOR_OF do_decorator(CsCompiler *c) {
    tool::string name;
    DECORATOR_OF dr = do_decorator(c, name);
    if (dr && name.length()) {
      putcbyte(c, BC_GSETNS_NEW_CONST);
      putcword(c, make_lit_symbol(c, name.c_str()));
    }
    return dr;
  }

  static void do_expr16(CsCompiler *c, PVAL& pv, bool allow_call_objects);

  /* do_decorator_parameter - parse decorator parameter */
  static DECORATOR_OF do_decorator_parameter(CsCompiler *c, PVAL& pv,
                                             tool::string &name) {
    int tkn;
    bool is_async = false;

    tkn = CsToken(c);
    if (tkn == T_ASYNC) {
      is_async = true;
      tkn = CsToken(c);
    }

    switch (tkn) {
    case T_FUNCTION: {
      // frequire(c,T_IDENTIFIER);
      // name = c->t_token;
      tkn = CsToken(c);
      CsSaveToken(c, tkn);
      if (tkn == T_IDENTIFIER) {
        name = c->t_token;
        do_function(c, is_async ? ASYNC : FUNCTION, false);
        //pv->fcn = nullptr;
      } else
        do_lambda(c, pv, is_async ? ASYNC : FUNCTION);
      return GOT_FUNCTION;
    }

    case T_NAMESPACE:
    case T_CLASS: {
      int decoratible = tkn;
      tkn = CsToken(c);
      CsSaveToken(c, tkn);
      if (tkn == T_IDENTIFIER) {
        name = c->t_token;
        do_class_decl(c, decoratible, false);
        //pv->fcn = nullptr;
        return GOT_CLASS;
      }
      CsParseError(c, "Expecting a class name");
      break;
    }
    case ':':
      CsSaveToken(c, tkn);
      do_lambda(c, pv, is_async ? ASYNC : FUNCTION);
      return GOT_FUNCTION;
    case '|':
      CsSaveToken(c, tkn);
      do_lambda(c, pv, is_async ? ASYNC : FUNCTION);
      return GOT_FUNCTION;

    case '(':
      do_expr1(c, pv, true);
      frequire(c, ')');
      break;

    case T_FLOAT:
    case T_INTEGER:
    case T_LENGTH:
    case T_ANGLE:
    case T_DURATION:
      pv = new expr::literal(c, c->t_value);
      break;

    case T_SYMBOL:
      pv = new expr::literal(c, tool::value(c->t_token));
      break;
    case T_STRING:
      {
        tool::array<wchar> buf;
        do {
          wchars str = c->get_wtoken_string();
          buf.push(str);
          if ((tkn = CsToken(c)) == T_STRING) continue;
          CsSaveToken(c, tkn);
          break;
        } while (tkn != T_EOF);

        pv = new expr::literal(c, tool::value(buf()));
      }
      break;
    case T_NULL:
      pv = new expr::literal_code(c, BC_NULL);
      break;
    case T_IDENTIFIER:
      if (c->t_token[0] == '@' && c->t_token[1] != 0) {
        CsSaveToken(c, tkn);
        return do_decorator(c,name);
      }
      findvariable(c, c->t_token, pv);
      while ((tkn = CsToken(c)) == '.')
        do_prop_reference(c, pv);

      if (tkn == '(') { // function calls in decorators
        string fname;
        bool is_$_name = c->disallowStringiziers ? false : (pv->is_var_ref(&fname) && fname[0] == '$');
        if (is_$_name)
          do_$_call(c, pv);
        else
          do_call(c, pv);
      } else
        CsSaveToken(c, tkn);
      break;

    case '[': /* vector */ do_literal_vector(c, pv); break;
    case '{': /* obj */ do_literal_obj(c, pv); break;
    case '/':
    case T_DIVEQ: do_literal_regexp(c, pv, tkn); break;
    default: CsParseError(c, "Expecting a primary expression"); break;

    }
    return GOT_NOTHING;
  }

  static void do_var_global_list(CsCompiler *c, PVAL &pv, bool is_var /* false - const */, int tok_eol) {

    expr::list::LIST_TYPE list_type;

    switch (tok_eol) {
      default: assert(false);
      case ')': list_type = expr::list::VARS; break;
      case ']': list_type = expr::list::VECTOR; break;
      case '}': list_type = expr::list::MAP; break;
    }

    handle<expr::list> ls = new expr::list(c, list_type, is_var);
    pv = ls;

    int  tkn;
    bool rest = false;
    do {
      PVAL pv2;
      tkn = CsToken(c);//frequire_or(c, T_IDENTIFIER, T_EVENT,',',tok_eol);
      if (tkn == ',')
      {
        pv2 = new expr::novalue(c);
        ls->elements.push(pv2);
        continue;
      }
      else if (tkn == tok_eol)
        break;
      else if (tkn == T_DOTDOTDOT)
      {
        rest = true;
        tkn = frequire_or(c, T_IDENTIFIER, T_EVENT);
      }

      if (tkn != T_IDENTIFIER && tkn != T_EVENT)
        CsParseError(c, "invalid destructuring assignment sequence");

      string this_name = c->t_token;
      string that_name = this_name;

      if (list_type == expr::list::MAP) {
        tkn = CsToken(c);
        if ((tkn == ':') || is_as_token(c, tkn)) {
          frequire(c, T_IDENTIFIER);
          this_name = c->t_token;
          //tkn = CsToken(c);
        }
        else
          CsSaveToken(c, tkn);
      }

      pv2 = new expr::gvar(c, this_name, is_var ? expr::gvar::NEW_NAMESPACE_VAR : expr::gvar::NEW_NAMESPACE_CONST);

      if (rest) {
        pv2 = new expr::rest(c, pv2);
        ls->elements.push(pv2);
        frequire(c, tok_eol);
        break;
      }
      else {
        tkn = CsToken(c);
      }

      if ((list_type == expr::list::MAP) && (this_name != that_name))
        pv2 = new expr::pair(c, new expr::literal(c, tool::value(that_name)), pv2);

      if (tkn == '=') {
        PVAL rv;
        do_call_param_expr(c, rv, false);
        pv2 = new expr::assignment(c, pv2, rv);
        // rvalue(c, rv);
        // (*pv->fcn)(c, STORE, pv);
        tkn = CsToken(c);
      }

      ls->elements.push(pv2);
      if (c->exportSeen && c->exports) {
        if (c->defaultSeen)
          c->exports->elements.insert(0,pv2);
        else
          c->exports->elements.push(pv2);
      }

      if (tkn == ',') {
        //pv->push(c);
        continue;
      }
      CsSaveToken(c, tkn);
    } while (true);
  }

  static PVAL do_var_global_list(CsCompiler *c, bool is_var /* false - const */, int tok_eol) {
    PVAL pv;
    do_var_global_list(c, pv, is_var, tok_eol);
    return pv;
  }


  static void do_member_var(CsCompiler *c) {

    int  tkn;
    PVAL pv;
    //pv.type = PVAL::VAR_PVAL;

    /* parse each variable and initializer */
    do {
      PVAL pv2;
      string name;
      switch (tkn = CsToken(c)) {
        case T_EVENT: /*it is valid variable name*/
        case T_IDENTIFIER:
          name = c->t_token;
          pv = new expr::gvar(c, name, expr::gvar::NEW_MEMBER_VAR);
          break;
        default: require(c, tkn, T_IDENTIFIER); break;
      }
      if ((tkn = CsToken(c)) == '=') {
        do_right_side_expr(c, pv2);
        pv = new expr::assignment(c, pv, pv2);
      }
      else {
        pv = new expr::assignment(c, pv, new expr::literal_code(c, BC_NOTHING));
        CsSaveToken(c, tkn);
      }
      pv->do_store(c);

    } while ((tkn = CsToken(c)) == ',');

    if (tkn != ';') CsSaveToken(c, tkn);

  }

  static void do_var_global(CsCompiler *c) {
    int  tkn;
    PVAL pv;
    /* parse each variable and initializer */
    do {
      PVAL pv2,pvar;
      string name;
      switch (tkn = CsToken(c)) {
        case T_EVENT: /*it is valid variable name*/
        case T_IDENTIFIER:
          // frequire(c,T_IDENTIFIER);
          name = c->t_token;
          pv = new expr::gvar(c, name, expr::gvar::NEW_NAMESPACE_VAR);
          if (c->exportSeen && c->exports) {
            if (c->defaultSeen)
              //c->exports[0] = pv;
              c->exports->elements.insert(0, pv);
            else
              c->exports->elements.push(pv);
          }
          break;
        case '(': do_var_global_list(c, pv, true,')'); break;
        case '[': do_var_global_list(c, pv, true,']'); break;
        case '{': do_var_global_list(c, pv, true,'}'); break;
        default: require_or(c, tkn, T_IDENTIFIER, '('); break;
      }
      //pv.push_l_value(c);
      if ((tkn = CsToken(c)) == '=') {
        do_right_side_expr(c, pv2);
        pv = new expr::assignment(c, pv, pv2);
      } else {
        pv = new expr::assignment(c, pv, new expr::literal_code(c, BC_UNDEFINED));
        CsSaveToken(c, tkn);
      }
      pv->do_store(c);
    } while ((tkn = CsToken(c)) == ',');

    if (tkn != ';') CsSaveToken(c, tkn);
  }

  static void do_const_global(CsCompiler *c) {
    int  tkn;
    PVAL pv;
    //pv.type = PVAL::VAR_PVAL;

    /* parse each variable and initializer */
    do {
      PVAL pv2;
      string name;
      switch (tkn = CsToken(c)) {
      case T_EVENT: /*it is valid variable name*/
      case T_IDENTIFIER:
        // frequire(c,T_IDENTIFIER);
        name = c->t_token;
        pv = new expr::gvar(c, name, expr::gvar::NEW_NAMESPACE_CONST);
        if (c->exportSeen && c->exports) {
          if (c->defaultSeen)
            c->exports->elements.insert(0, pv);
          else
            c->exports->elements.push(pv);
        }
        break;
      case '(': do_var_global_list(c, pv, false, ')'); break;
      case '[': do_var_global_list(c, pv, false, ']'); break;
      case '{': do_var_global_list(c, pv, false, '}'); break;
      default: require_or(c, tkn, T_IDENTIFIER, '('); break;
      }

      if ((tkn = CsToken(c)) == '=') {
        do_right_side_expr(c, pv2);
        pv = new expr::assignment(c, pv, pv2);
      }
      else {
        pv = new expr::assignment(c, pv, new expr::literal_code(c, BC_UNDEFINED));
        CsSaveToken(c, tkn);
      }
      pv->do_store(c);
    } while ((tkn = CsToken(c)) == ',');

    if (tkn != ';') CsSaveToken(c, tkn);
  }

  // static void do_const_global(CsCompiler *c)
  //{
  //    int   tkn;
  //    //PVAL  pv;
  //
  //    /* parse each variable and initializer */
  //    do {
  //        PVAL pv2;
  //        char name[TKNSIZE+1];
  //        frequire(c,T_IDENTIFIER);
  //        strcpy_s(name,c->t_token);
  //
  //        if ((tkn = CsToken(c)) == '=')
  //        {
  //          do_right_side_expr(c,&pv2);
  //          rvalue(c,&pv2);
  //        }
  //        else
  //        {
  //          CsParseError(c,"Expecting '=' and constant initialization ");
  //        }
  //        putcbyte(c,BC_GSETC);
  //        putcword(c,make_lit_symbol(c,name));
  //
  //    } while ((tkn = CsToken(c)) == ',');
  //
  //    if( tkn != ';' )
  //      CsSaveToken(c,tkn);
  //    //require(c,tkn,';');
  //}

  static void do_class_decl(CsCompiler *c, int decl_type, bool store,
                            qualified_name &qn);

  static void do_class_decl(CsCompiler *c, int decl_type, bool store) {
    int  tkn;
    PVAL pv;
    // int   decl_line_no = c->lineNumber;

    frequire(c, T_IDENTIFIER);

    qualified_name qn(c);
    qn.append(c->t_token);

    if ((tkn = CsToken(c)) == '.') {
      findvariable(c, qn.local_name, pv);
      rvalue(c, pv);
      putcbyte(c, BC_PUSH_NS);
      do_class_decl(c, decl_type, store);
      putcbyte(c, BC_POP_NS);
    } else {
      CsSaveToken(c, tkn);
      do_class_decl(c, decl_type, store, qn);
    }
  }

  static void do_member_var(CsCompiler *c);

  static void do_class_decl(CsCompiler *c, int decl_type, bool store,
                            qualified_name &qn) {
    int  tkn;
    PVAL pv;
    int  decl_line_no = c->lineNumber;

    // putcbyte(c,BC_DEBUG);

    tkn = CsToken(c);

    if (tkn == ':' || is_extends_token(c,tkn)) {
      /* was
      if(decl_type == T_NAMESPACE)
        CsParseError(c, " ':' is not expecting in namespace declaration");


      The limitation above is removed now - something like:


      namesapce A : B { ... }

      makes sense - allows to inherit namespaces.
        */
      do_class_ref_expr(c);
    } else {
      switch (decl_type) {
        case T_CLASS: variable_ref(c, "Object"); break;
        case T_NAMESPACE: putcbyte(c, BC_NS); break;
      }
      CsSaveToken(c, tkn);
    }

    putcbyte(c, BC_PUSH);
    do_lit_symbol(c, qn.local_name); // qn.name - WRONG, as it prevents local
                                     // namespace merging ...
    putcbyte(c, BC_NEWCLASS);
    putcbyte(c, decl_type == T_CLASS);
    putcbyte(c, BC_PUSH);

    frequire(c, '{');

    putcbyte(c, BC_PUSH_NS);

    int prev_functionLevel = c->functionLevel;
    c->functionLevel       = 0;

    c->cDOMcb->on_class(true, qn.local_name, decl_type, decl_line_no);

    // set strong name

    bool is_static = false;

    while (decl_line_no = c->lineNumber, (tkn = CsToken(c)) != '}')
      switch (tkn) {
      case ';': continue;
      case T_THIS:
        if (CsToken(c) != T_VAR)
          CsParseError(c, " Expecting 'var' - declaration of member variables");
        do_member_var(c);
        break;
      case T_LET:
      case T_VAR: do_var_global(c); break;
      case T_CONST: do_const_global(c); break;
      case T_FUNCTION: {
        int t = CsToken(c);
        if (t == '*')
          do_function(c, GENERATOR,true,is_static);
        else {
          CsSaveToken(c, t);
          do_function(c, FUNCTION, true, is_static);
        }
        is_static = false;
      } break;

      case T_STATIC: {
        tkn = CsToken(c);
        require_or(c, tkn, T_FUNCTION, T_IDENTIFIER);
        is_static = true;
        CsSaveToken(c, tkn);
        continue;
      }
      case T_ASYNC:
        if (CsToken(c) != T_FUNCTION)
          CsParseError(c, "Expecting 'function' - declaration of async function");
        do_function(c, ASYNC);
        break;
      case T_EVENT: do_function(c, EVENT); break;
      case T_PROPERTY: do_function(c, PROPERTY); break;
      //case T_TYPE:
      case T_CLASS:
      case T_NAMESPACE:
        do_class_decl(c, tkn); break;
      case T_INCLUDE: do_include(c); break;
      case T_IMPORT: do_import(c); break;
      case T_IDENTIFIER:
        if (c->t_token[0] == '@' && c->t_token[1] != 0) {
          CsSaveToken(c, tkn);
          do_decorator(c);
          break;
        }
        else if (is_get_token(c, tkn)) {
          PVAL pv;
          string name = do_lambda(c, pv, FUNCTION);
          pv->do_fetch(c);
          putcbyte(c, BC_GSETNS_GETTER);
          putcword(c, make_lit_symbol(c,name));
          break;
        }
        else if (is_set_token(c, tkn)) {
          PVAL pv;
          string name = do_lambda(c, pv, FUNCTION);
          pv->do_fetch(c);
          putcbyte(c, BC_GSETNS_SETTER);
          putcword(c, make_lit_symbol(c, name));
          break;
        }
        else { // js compatibility
          if (chars_of(c->t_token) == CHARS("constructor"))
            strcpy(c->t_token, "this"); // hackish, can it be better?
          CsSaveToken(c, tkn);
          do_function(c, FUNCTION, true, is_static);
          is_static = false;
          break;
        }

      default:
        CsParseError(c, " Expecting 'const', 'var', 'function' or 'property'");
      }

    putcbyte(c, BC_POP_NS);

    putcbyte(c, BC_DROP);

    if (store) {
      /*
      putcbyte(c, BC_GSETNS_NEW_CONST);
      putcword(c, make_lit_symbol(c, qn.local_name));*/
      PVAL pv2 = new expr::gvar(c, qn.local_name, expr::gvar::NEW_NAMESPACE_CONST );
      pv2->do_store(c);
      if (c->exportSeen && c->exports) {
        if (c->defaultSeen)
          c->exports->elements.insert(0,pv2);
        else
          c->exports->elements.push(pv2);
      }
    }
    c->functionLevel = prev_functionLevel;

    c->cDOMcb->on_class(false, qn.local_name, decl_type, decl_line_no);
  }

  /* do_block - compile the {} expression */
  static void do_block(CsCompiler *c, char *parameter) {
    ATABLE *atable = nullptr;
    int     ptr    = 0; /* BC_FRAME arg offset */
    // int tcnt = 0; /* num locals */
    int tkn;
    int n = 0;

    if (parameter) {
      InjectArgFrame(c, &atable, &ptr);
      AddArgument(c, atable, parameter, true);
      putcbyte(c, BC_ESET);
      putcbyte(c, 0);
      putcbyte(c, 1);
    }

    /* compile the statements in the block */

    while ((tkn = CsToken(c)) != '}') {
      switch (tkn) {
      case T_LET:
      case T_VAR: do_var_local(c, &atable, &ptr /*,&tcnt*/); break;
      case T_CONST: do_const_local(c, &atable, &ptr /*,&tcnt*/); break;

      case T_FUNCTION: {
        int t = CsToken(c);
        if (t == '*')
          do_function_local(c, GENERATOR, &atable, &ptr);
        else {
          CsSaveToken(c, t);
          do_function_local(c, FUNCTION, &atable, &ptr);
        }
      } break;
      case T_ASYNC:
        if (CsToken(c) != T_FUNCTION)
          CsParseError(c,"Expecting 'function' - declaration of async function");
        do_function_local(c, ASYNC, &atable, &ptr);
        break;
      case T_EVENT:
        //do_function_local(c, EVENT, &atable, &ptr);
        CsParseError(c, "misplaced 'event' declaration, no principal");
        break;

      case T_PROPERTY:
        //  do_property_local(c,&atable,&ptr/*,&tcnt*/);
        CsParseError(c, "misplaced 'property' declaration, no principal");
        break;

      default:
        CsSaveToken(c, tkn);
        do_statement(c);
        ++n;
        break;
      }
    }

    if (n == 0) putcbyte(c, BC_UNDEFINED);

    /* pop the local frame */
    if (atable) {
      CloseArgFrame(c, atable, ptr);
      --c->blockLevel;
    }
  }

  /* do_block - compile the {} expression */
  static void do_property_block(CsCompiler *c, const char *valName) {
    ATABLE *atable = nullptr;
    int     ptr    = 0; /* BC_FRAME arg offset */
    // int tcnt = 0; /* num locals */
    int tkn;
    int n = 0;

    /* compile the statements in the block */

    while ((tkn = CsToken(c)) != '}') {
      if (tkn == T_VAR || tkn == T_LET)
        do_var_local(c, &atable, &ptr);
      else if (tkn == T_CONST)
        do_const_local(c, &atable, &ptr);
      else if (tkn == T_FUNCTION) {
        int t = CsToken(c);
        if (t == '*')
          do_function_local(c, GENERATOR, &atable, &ptr);
        else {
          CsSaveToken(c, t);
          do_function_local(c, FUNCTION, &atable, &ptr);
        }
      } else if (tkn == T_ASYNC) {
        if (CsToken(c) != T_FUNCTION)
          CsParseError(c,
                       " Expecting 'function' - declaration of async function");
        do_function_local(c, ASYNC, &atable, &ptr);
      } else if(is_get_token(c,tkn)) //if (tkn == T_GET)
        do_get_set(c, true, valName);
      else if(is_set_token(c, tkn)) //if (tkn == T_SET)
        do_get_set(c, false, valName);
      else {
        CsSaveToken(c, tkn);
        do_statement(c);
        ++n;
      }
    }

    if (n == 0) putcbyte(c, BC_UNDEFINED);

    /* pop the local frame */
    if (atable) {
      CloseArgFrame(c, atable, ptr);
      --c->blockLevel;
    }
  }

  static void do_export(CsCompiler* c) {

    c->defaultSeen = false;
    c->exportSeen = true;

    int tkn = CsToken(c);
    if (tkn == T_DEFAULT) {
      c->defaultSeen = true;
      tkn = CsToken(c);
    }

    if (tkn == '{') {
      PVAL list = do_var_global_list(c, true, '}');
      if (list)
        c->exports->elements.push(list.ptr_of<expr::list>()->elements());
      c->defaultSeen = false;
      c->exportSeen = false;
    }
    else
      CsSaveToken(c, tkn);

  }

  /* do_stream - compile the stream until eof */
  static void do_stream(CsCompiler *c) {
    c->exports = new expr::list(c,expr::list::MAP,false);
    /* compile the statements in the block */
    int tkn = 0;

    auto_state<bool> _disallowStringiziers(c->disallowStringiziers, false);

    for (tkn = CsToken(c); tkn; tkn = CsToken(c))
    {
      if (tkn != T_STRING) {
        CsSaveToken(c, tkn);
        break;
      }
      if (c->t_wtoken() == WCHARS("disable $tringizers"))
        c->disallowStringiziers = true;
      else {
        CsSaveToken(c, tkn);
        break;
      }
    }

    for (tkn = CsToken(c); tkn; tkn = CsToken(c))
    {
      switch (tkn) {
      case T_EXPORT: do_export(c); continue;
      case T_LET:
      case T_VAR: do_var_global(c); break;
      case T_CONST: do_const_global(c); break;
      case T_CLASS:
      case T_NAMESPACE: do_class_decl(c, tkn); break;
      case T_FUNCTION: {
        int t = CsToken(c);
        if (t == '*')
          do_function(c, GENERATOR);
        else {
          CsSaveToken(c, t);
          do_function(c, FUNCTION);
        }
      } break;
      case T_ASYNC:
        if (CsToken(c) != T_FUNCTION)
          CsParseError(c," Expecting 'function' - declaration of async function");
        do_function(c, ASYNC);
        break;
      case T_EVENT: do_function(c, EVENT); break;
      case T_PROPERTY: do_function(c, PROPERTY); break;
      case T_INCLUDE: do_include(c); break;
      case T_IMPORT: do_import(c); break;
      case ';': continue;
      case T_IDENTIFIER:
        if (c->t_token[0] == '@' && c->t_token[1] != 0) {
          CsSaveToken(c, tkn);
          do_decorator(c);
          break;
        }
        // else fall through
      default:
        c->exportSeen = false;
        CsSaveToken(c, tkn);
        do_statement(c);
        break;
      }
      c->exportSeen = false;
    }
    if (c->exports && c->exports->elements.size())
    {
      c->exports->do_fetch(c);
      putcbyte(c,BC_RETURN);
    }
  }

  /* do_return - handle the 'return' statement */
  static void do_return(CsCompiler *c) {
    int tkn, end = NIL;
    if ((tkn = CsToken(c)) == ';')
      putcbyte(c, BC_NOTHING);
    else {
      CsSaveToken(c, tkn);
      PVAL pv;
      do_right_side_expr(c, pv);
      rvalue(c, pv);
      if ((tkn = CsToken(c)) != ';') CsSaveToken(c, tkn);
    }
    // UnwindStack(c,c->blockLevel); - functionality moved to UnwindTryStack
    UnwindTryStack(c, end);

    fixup(c, end, codeaddr(c));
    putcbyte(c, BC_RETURN);
  }

  /* do_return - handle the 'delete' */
  static void do_delete(CsCompiler *c) {
    PVAL pv;
    do_right_side_expr(c, pv);
    pv->do_delete(c);
  }

  static void do_debug(CsCompiler *c) {

    if (!c->ic->enableDebug)
    {
      for (;;) { // optional values to show
        int tkn = CsToken(c);
        if (!tkn)
          break;
        else if (tkn == ';')
          break;
      }
      putcbyte(c, BC_NOP);
      return;
    }

    int tkn = CsToken(c);
    if (tkn == T_BREAK) {
      putcbyte(c, BC_DEBUG);
      putcbyte(c, 2);
      putcword(c, c->lineNumber);
      frequire(c, ';');
    }
    //if (tkn != T_IDENTIFIER && tkn != T_NAMESPACE) {
    //}
    else if (streq(c->t_token, "namespace")) {
      putcbyte(c, BC_DEBUG);
      putcbyte(c, 0);
      frequire(c, ';');
    }
    else if (streq(c->t_token, "stacktrace")) {
      putcbyte(c, BC_DEBUG);
      putcbyte(c, 1);
      frequire(c, ';');
    }
    else {
      if (!do_log(c, tkn))
        CsParseError(c, "expecting 'namespace' or 'stacktrace' or ':' after the 'debug'");
    }
  }

  static void do_assert(CsCompiler *c) {

    if (!c->ic->enableDebug)
    {
      for (;;) { // optional values to show
        int tkn = CsToken(c);
        if (!tkn)
          break;
        else if (tkn == ';')
          break;
      }
      putcbyte(c, BC_NOP);
      return;
    }

    PVAL         pv;
    const wchar *expr_start = c->linePtr;
    do_right_side_expr(c, pv);
    rvalue(c, pv);
    putcbyte(c, BC_PUSH);
    const wchar *expr_end = c->linePtr - 1;
    int          tkn      = CsToken(c);
    wchars       str(expr_start, max(0, expr_end - expr_start));
    do_lit_string(c, str);
    putcbyte(c, BC_PUSH);
    int n = 2; // condition var + literal string
    if (tkn == ':') {
      for (;;) { // optional values to show
        tkn = CsToken(c);
        if (!tkn)
          break;
        else if (tkn == ';')
          break;
        else if (tkn == ',')
          continue;
        CsSaveToken(c, tkn);
        PVAL pv2;
        do_right_side_expr(c, pv2);
        rvalue(c, pv2);
        putcbyte(c, BC_PUSH);
        ++n;
      }
    }
    else if (tkn == ';')
      ;//putcbyte(c, BC_NOTHING);
    else
      CsSaveToken(c, tkn);

    require(c, tkn, ';');

    putcbyte(c, BC_ASSERT);
    putcbyte(c, n);
  }

  static bool do_log(CsCompiler *c, int tkn) {

    const int HAS_MODE = 0x01;
    const int STRINGIZER = 0x02;

    int flags = 0;
    int n = 0;

    if (tkn == T_IDENTIFIER || tkn == T_SYMBOL || tkn == T_STRING)
    {
      PVAL pv;
      do_literal_symbol(c, pv);
      rvalue(c, pv);
      putcbyte(c, BC_PUSH);
      tkn = CsToken(c);
      flags |= HAS_MODE;
      n = 1;
    }

    if (tkn == ':') {
      for (;;) {
        const wchar *expr_start = c->linePtr;
        /*tkn = CsToken(c);
        if (!tkn)
          break;
        else if (tkn == ';')
          break;
        else if (tkn == ',')
          continue;
          CsSaveToken(c, tkn);
          */

        flags |= STRINGIZER; // this is now a stringizer alike thing too.

        PVAL pv;
        do_right_side_expr(c, pv);
        const wchar *expr_end = c->linePtr - 1;

        wchars       str(expr_start, max(0, expr_end - expr_start));
        ustring fmt; if(n > 1) fmt += WCHARS(" ");
        fmt += trim(str); fmt += WCHARS(":");

        rvalue(c, pv);
        putcbyte(c, BC_PUSH);
        ++n;

        do_lit_string(c, fmt);
        putcbyte(c, BC_PUSH);
        ++n;

        // swap two topmost stack elements
        putcbyte(c, BC_ROTATE);
        putcbyte(c, 2);

        if (frequire_or(c, ',', ';') == ';')
          break;
      }
    }
    else if (tkn == '(')
    {
      int bracket_level = 1;

      flags |= STRINGIZER;

      PVAL pv;

      int lastc = scan_stringizer_string(c, bracket_level);
      do_lit_string(c, c->t_wtoken());
      putcbyte(c, BC_PUSH);
      ++n;

      while (lastc == '{') {
        do_call_param_expr(c, pv);
        frequire(c, '}');
        rvalue(c, pv);
        putcbyte(c, BC_PUSH_VALUE);
        ++n;
        lastc = scan_stringizer_string(c, bracket_level);
        do_lit_string(c, c->t_wtoken());
        putcbyte(c, BC_PUSH_VALUE);
        ++n;
      }
      if (lastc != ')') CsParseError(c, "expecting ')'");
    }
    else
      return false;

    putcbyte(c, BC_LOG);
    putcbyte(c, flags);
    putcbyte(c, n);
    return true;
  }


  /* do_typeof - handle the 'typeof' statement */
  static void do_typeof(CsCompiler *c) {
    do_expr(c);
    putcbyte(c, BC_TYPEOF);
  }

  /* do_test - compile a test expression with optional var declaration */
  static void do_test(CsCompiler *c, ATABLE **patable, int *pptr, int *next) {
    frequire(c, '(');
    int  tkn = CsToken(c);
    PVAL pv;
    if ((tkn == T_VAR || tkn == T_LET) && patable)
      do_var_local(c, patable, pptr, pv, next);
    else {
      CsSaveToken(c, tkn);
      if (next) *next = codeaddr(c);
      do_expr2(c, pv, true);
    }
    frequire(c, ')');
    rvalue(c, pv);
  }

  /*{
      frequire(c,'(');
      do_expr(c);
      frequire(c,')');
  }*/

  /* do_expr - parse an expression */
  static void do_expr(CsCompiler *c) {
    PVAL pv;
    do_expr1(c, pv);
    rvalue(c, pv);
  }

  /* do_init_expr - parse an initialization expression */
  static void do_init_expr(CsCompiler *c) {
    PVAL pv;
    do_expr2(c, pv, true);
    rvalue(c, pv);
  }

  /* do_right_side_expr - parse an initialization expression */
  static void do_right_side_expr(CsCompiler *c, PVAL& pv) {
    int tkn;
    tkn = CsToken(c);

    tool::auto_state<bool> _(c->atRightSide, true);

    CsSaveToken(c, tkn);
    // if(tkn == '[' || tkn == '{')
    //  do_literal(c,pv);
    // else if(tkn == '/' || tkn == T_DIVEQ)
    //  do_literal(c,pv);
    // else
    if (c->JSONonly)
      do_primary_json(c, pv);
    else
      // do_right_side_expr_list(c,pv);
      do_expr2(c, pv, true);
  }

  static bool do_call_param_expr(CsCompiler *c, PVAL& pv, bool allow_dot_dot) {
    tool::auto_state<bool> _(c->atRightSide, true);
    int dot_dots = 0;
    int tkn;
    tkn = CsToken(c);
    switch (tkn) {
    case '[': case '{':
      CsSaveToken(c, tkn);
      do_literal(c, pv);
      break;
    case '/': case T_DIVEQ:
      CsSaveToken(c, tkn);
      do_literal(c, pv); // re expr
      break;
    case T_DOTDOT:
    case T_DOTDOTDOT:
      if (allow_dot_dot) {
        do_expr2(c, pv, true);
        ++dot_dots;
        break;
      }
    default:
      CsSaveToken(c, tkn);
      if (c->JSONonly)
        do_primary_json(c, pv);
      else
        do_expr2(c, pv, true);
      break;
    }
    return dot_dots > 0;
  }


  static void do_class_ref_expr(CsCompiler *c) {
    PVAL pv;

    int tkn = CsToken(c);
    if (tkn == '.') {
      pv = new expr::literal_code(c, BC_ROOT_NS);
      CsSaveToken(c, tkn);
    } else if (tkn == T_IDENTIFIER)
      findvariable(c, c->t_token, pv);
    else
      require_or(c, tkn, T_IDENTIFIER, '.');

    for (tkn = CsToken(c); tkn; tkn = CsToken(c)) {
      //rvalue(c, pv);
      if (tkn != '.') {
        CsSaveToken(c, tkn);
        break;
      }
      //putcbyte(c, BC_PUSH);
      PVAL pv2;
      do_selector(c,pv2);
      pv = new expr::property(c, pv, pv2);
      //pv.fcn = code_property;
    }
    pv->do_fetch(c);
  }

  /* rvalue - get the rvalue of a partial expression */
  static void rvalue(CsCompiler *c, PVAL& pv) {
    //pv->do_fetch(c);
    if (pv) {
      // ;a++; is equivalent of ;++a;
      pv->do_fetch_root(c);
      pv = nullptr;
    }
  }

  /* chklvalue - make sure we've got an lvalue */
  static void chklvalue(CsCompiler *c, PVAL& pv) {
    if (!pv->is_lvalue()) CsParseError(c, pv, "Expecting an lvalue");
  }

  /* do_expr1 - handle the ',' operator */
  static void do_expr1(CsCompiler *c, PVAL& pv, bool handle_in) {
    int tkn;
    do_expr2(c, pv, handle_in);
    while ((tkn = CsToken(c)) == ',') {
      rvalue(c, pv);
      do_expr1(c, pv, handle_in);
    }
    rvalue(c, pv);
    CsSaveToken(c, tkn);
  }

  /* do_right_side_expr_list - handle the ',' operator in right side expressions
   * like return <rs-list>; */

  static void do_right_side_expr_list(CsCompiler *c, PVAL& pv, bool handle_in) {
    int tkn;
    handle<expr::list> ls;
    do_expr2(c, pv, handle_in);
    while ((tkn = CsToken(c)) == ',') {
      if (!ls) {
        ls = new expr::list(c, expr::list::EXPRESSIONS, true);
        ls->elements.push(pv);
        pv = ls;
      }
      PVAL pv2;
      do_expr2(c, pv2, handle_in);
      ls->elements.push(pv2);
    }
    CsSaveToken(c, tkn);
  }

  static void do_list_item(CsCompiler *c, PVAL& pv, bool handle_in) {
    int tkn = CsToken(c);
    bool rest = false;
    if (tkn == T_DOTDOT || tkn == T_DOTDOTDOT)
      rest = true;
    else
      CsSaveToken(c,tkn);
    do_expr2(c, pv, handle_in);
    if (rest)
      pv = new expr::rest(c, pv);
  }

  // (a,b,c)
  // caller has consumed '('
  static void do_expr_list(CsCompiler *c, PVAL& pv, bool handle_in) {

    handle<expr::list> ls = new expr::list(c, expr::list::VARS, true);
    pv = ls;

    int tkn = CsToken(c);
    CsSaveToken(c, tkn);

    if (tkn == ')')
      return;

    while (tkn) {
      PVAL pv2;
      do_list_item(c, pv2, handle_in);
      ls->elements.push(pv2);
      tkn = CsToken(c);
      if (tkn == ')') {
        CsSaveToken(c, tkn);
        break;
      }
      require(c, tkn, ',');
    }

    if (ls->elements.size() == 1)
      pv = ls->elements[0];

/*    int tkn;
    handle<expr::list> ls;
    do_list_item(c, pv, handle_in);
    while ((tkn = CsToken(c)) == ',') {
      if (!ls) {
        ls = new expr::list(c,expr::list::VARS, true);
        ls->elements.push(pv);
        pv = ls;
      }
      PVAL pv2;
      do_list_item(c, pv2, handle_in);
      ls->elements.push(pv2);
    }
    CsSaveToken(c, tkn); */
  }

  static void do_expr_white_space_list(CsCompiler *c, PVAL& pv) {

    do_expr2(c, pv, false);

    int tkn;

    expr::list* list = nullptr;

    do {
      tkn = CsToken(c);
      CsSaveToken(c, tkn);
      if (tkn == ',' || tkn == ';' || tkn == '}') break;
      if (!list) {
        list = new expr::list(c, expr::list::VECTOR, false);
        list->elements.push(pv);
        pv = list;
      }
      PVAL pv2;
      do_expr2(c, pv2, false);
      list->elements.push(pv2);
    } while (tkn);

    CsSaveToken(c, tkn);
  }

  /* do_for_initialization - handle the initialization of for statement */
  static void do_for_initialization(CsCompiler *c, PVAL& pv, ATABLE **patable,
                                    int *pptr) {
    int tkn = CsToken(c);

    if (tkn == T_VAR || tkn == T_LET)
      do_var_local(c, patable, pptr, pv);
    else if (tkn == ';')
      CsSaveToken(c, tkn);
    else {
      CsSaveToken(c, tkn);
      do_right_side_expr_list(c, pv,false);
    }
  }

  /* do_expr2 - handle the assignment operators
     returns addr of the 'next' statement if handle_in==true and was 'in'
  */

  static int do_expr2(CsCompiler *c, PVAL& pv, bool handle_in) {
    int nxt = 0;
    int tkn;

    do_expr3(c, pv, handle_in);

    while ((tkn = CsToken(c)) == '=' || tkn == T_ADDEQ || tkn == T_SUBEQ ||
           tkn == T_MULEQ || tkn == T_DIVEQ || tkn == T_REMEQ ||
           tkn == T_ANDEQ || tkn == T_OREQ || tkn == T_XOREQ ||
           tkn == T_SHLEQ || tkn == T_SHREQ || tkn == T_USHLEQ ||
           tkn == T_USHREQ
           //||     (handle_in && (tkn == T_IN))
    ) {
      chklvalue(c, pv);
      switch (tkn) {
      case '=': {
        //PVAL pv2;
        //pv->push_l_value(c);
        //do_right_side_expr(c, &pv2);
        //pv2.r_valuate(c);
        //pv->store_l_value(c);

        PVAL pv2;
        do_right_side_expr(c, pv2);
        pv = new expr::assignment(c, pv, pv2);
      } break;
      /*
      case T_IN: // for(... in ....)
          {
              putcbyte(c,BC_NOTHING);
              (*pv->fcn)(c,STORE,pv);
              nxt = codeaddr(c);
              PVAL pv2;
              (*pv->fcn)(c,LOAD,pv);
              putcbyte(c,BC_PUSH);
              do_right_side_expr(c,&pv2);
              rvalue(c,&pv2);
              putcbyte(c,BC_NEXT);
              (*pv->fcn)(c,STORE,pv);
          }
          break; */
      case T_ADDEQ: do_assignment(c, pv, BC_ADD_EQ); break;
      case T_SUBEQ: do_assignment(c, pv, BC_SUB); break;
      case T_MULEQ: do_assignment(c, pv, BC_MUL); break;
      case T_DIVEQ: do_assignment(c, pv, BC_DIV); break;
      case T_REMEQ: do_assignment(c, pv, BC_REM); break;
      case T_ANDEQ: do_assignment(c, pv, BC_BAND); break;
      case T_OREQ: do_assignment(c, pv, BC_BOR); break;
      case T_XOREQ: do_assignment(c, pv, BC_XOR); break;
      case T_SHLEQ: do_assignment(c, pv, BC_SHL); break;
      case T_SHREQ: do_assignment(c, pv, BC_SHR); break;
      case T_USHLEQ: do_assignment(c, pv, BC_USHL); break;
      case T_USHREQ: do_assignment(c, pv, BC_USHR); break;
      }
      //pv->fcn = nullptr;
    }
    CsSaveToken(c, tkn);
    return nxt;
  }

  /* do_assignment - handle assignment operations */
  static void do_assignment(CsCompiler *c, PVAL& pv, int op) {
    tool::auto_state<bool> _(c->atRightSide, true);
    /*PVAL                   pv2;
    (*pv->fcn)(c, DUP, 0);
    (*pv->fcn)(c, LOAD, pv);
    putcbyte(c, BC_PUSH);
    do_expr2(c, &pv2, false);
    rvalue(c, &pv2);
    putcbyte(c, op);
    (*pv->fcn)(c, STORE, pv);*/

    PVAL pv2;
    do_expr2(c, pv2, false);
    pv = new expr::mutating_assignment(c, byte(op), pv, pv2);
    //pv->do_store(c);
  }

  /* do_expr3 - handle the '?:' operator */
  static void do_expr3(CsCompiler *c, PVAL& pv, bool handle_in) {
    int tkn;
    do_expr4(c, pv, handle_in);
    while ((tkn = CsToken(c)) == '?') {
      PVAL ptrue, pfalse;
      do_expr2(c, ptrue, handle_in);
      frequire(c, ':');
      do_expr2(c, pfalse, handle_in);
      pv = new expr::ternary(c, pv, ptrue, pfalse);
    }
    CsSaveToken(c, tkn);
  }


  /* do_expr4 - handle the '||' operator */
  static void do_expr4(CsCompiler *c, PVAL& pv, bool handle_in) {
    int tkn;
    do_expr5(c, pv, handle_in);
    while ((tkn = CsToken(c)) == T_OR) {
      PVAL pvr;
      do_expr5(c, pvr, true);
      pv = new expr::logical_or(c, pv, pvr);
    }
    CsSaveToken(c, tkn);
  }

  /* do_expr5 - handle the '&&' operator */
  static void do_expr5(CsCompiler *c, PVAL& pv, bool handle_in) {
    int tkn;
    do_expr6(c, pv, handle_in);
    while ((tkn = CsToken(c)) == T_AND) {
      PVAL pvr;
      do_expr6(c, pvr, true);
      pv = new expr::logical_and(c, pv,pvr);
    }
    CsSaveToken(c, tkn);
  }

  /* do_expr6 - handle the '|' operator */
  static void do_expr6(CsCompiler *c, PVAL& pv, bool handle_in) {
    int tkn;
    do_expr7(c, pv, handle_in);
    while ((tkn = CsToken(c)) == '|') {
      PVAL vr;
      do_expr7(c, vr, true);
      pv = new expr::binary(c, BC_BOR, pv, vr);
#if 0
      PVAL vl, vr; pv->copy_if_literal(vl);
      int  save_addr = codeaddr(c);

      rvalue(c, pv);
      putcbyte(c, BC_PUSH_VALUE);

      do_expr7(c, &vr, true);

      if (is_literal(&vr) && is_literal(pv)) {
        discard_codes(c, save_addr);
        pv->val = fold_const(c, BC_BOR, &vl, &vr);
        pv->fcn = code_literal;
      } else {
        rvalue(c, &vr);
        putcbyte(c, BC_BOR);
      }
#endif
    }
    CsSaveToken(c, tkn);
  }

  /* do_expr7 - handle the '^' operator */
  static void do_expr7(CsCompiler *c, PVAL& pv, bool handle_in) {
    int tkn;
    do_expr8(c, pv, handle_in);
    while ((tkn = CsToken(c)) == '^') {
      PVAL vr;
      do_expr8(c, vr, true);
      pv = new expr::binary(c, BC_XOR, pv, vr);

#if 0
      PVAL vl, vr; pv->copy_if_literal(vl);
      int  save_addr = codeaddr(c);

      rvalue(c, pv);
      putcbyte(c, BC_PUSH_VALUE);

      do_expr8(c, &vr, true);
      if (is_literal(&vr) && is_literal(pv)) {
        discard_codes(c, save_addr);
        pv->val = fold_const(c, BC_XOR, &vl, &vr);
        pv->fcn = code_literal;
      } else {
        rvalue(c, &vr);
        putcbyte(c, BC_XOR);
      }
#endif
    }
    CsSaveToken(c, tkn);
  }

  /* do_expr8 - handle the '&' operator */
  static void do_expr8(CsCompiler *c, PVAL& pv, bool handle_in) {
    int tkn;
    do_expr9(c, pv, handle_in);
    while ((tkn = CsToken(c)) == '&') {
      PVAL vr;
      do_expr9(c, vr, true);
      pv = new expr::binary(c, BC_BAND, pv, vr);
    }
    CsSaveToken(c, tkn);
  }

  /* do_expr9 - handle the '==' and '!=' operators */
  static void do_expr9(CsCompiler *c, PVAL& pv, bool handle_in) {
    int tkn, op = 0/*, opm = 0*/;
    do_expr10(c, pv, handle_in);
    while ((tkn = CsToken(c)) == T_EQ || tkn == T_NE || tkn == T_NE_STRONG ||
           tkn == T_EQ_STRONG) {
      switch (tkn) {
      case T_EQ:
        op  = BC_EQ;
        break;
      case T_NE:
        op  = BC_NE;
        break;
      case T_EQ_STRONG:
        op  = BC_EQ_STRONG;
        break;
      case T_NE_STRONG:
        op  = BC_NE_STRONG;
        break;
      }
      PVAL vr;
      do_expr10(c, vr, true);
      pv = new expr::binary(c, byte(op), pv, vr);
    }
    CsSaveToken(c, tkn);
  }

  /* do_expr10 - handle the '<', '<=', '>=' and '>' operators */
  static void do_expr10(CsCompiler *c, PVAL& pv, bool handle_in) {
    int tkn, op = 0;
    do_expr11(c, pv);
    while ((tkn = CsToken(c)) == '<' || tkn == T_LE || tkn == T_GE ||
           tkn == '>' || tkn == T_IN) {
      switch (tkn) {
      case '<': op = BC_LT; break;
      case T_LE: op = BC_LE; break;
      case T_GE: op = BC_GE; break;
      case '>': op = BC_GT; break;
      case T_IN:
        if (handle_in) {
          op = BC_IN;
          break;
        }
        CsSaveToken(c, tkn);
        return;
      }
      PVAL vr;
      do_expr11(c, vr);
      pv = new expr::binary(c, byte(op), pv, vr);
    }
    CsSaveToken(c, tkn);
  }

  /* do_expr11 - handle the '<<' and '>>' operators */
  static void do_expr11(CsCompiler *c, PVAL& pv) {
    int tkn, op = 0;
    do_expr12(c, pv);
    while ((tkn = CsToken(c)) == T_SHL || tkn == T_SHR || tkn == T_USHL ||
           tkn == T_USHR) {
      switch (tkn) {
      case T_SHL: op = BC_SHL; break;
      case T_SHR: op = BC_SHR; break;
      case T_USHL: op = BC_USHL; break;
      case T_USHR: op = BC_USHR; break;
      }
      PVAL vr;
      do_expr12(c, vr);
      pv = new expr::binary(c, byte(op), pv, vr);
    }
    CsSaveToken(c, tkn);
  }

  /* do_expr12 - handle the '+' and '-' operators */
  static void do_expr12(CsCompiler *c, PVAL& pv) {
    int tkn, op = 0;
    do_expr13(c, pv);
    while ((tkn = CsToken(c)) == '+' || tkn == '-') {
      switch (tkn) {
      case '+': op = BC_ADD; break;
      case '-': op = BC_SUB; break;
      }

      PVAL vr;
      do_expr13(c, vr);
      pv = new expr::binary(c, byte(op), pv, vr);

    }
    CsSaveToken(c, tkn);
  }

  /* do_expr13 - handle the '*' and '/' operators */
  static void do_expr13a(CsCompiler *c, PVAL& pv);

  static void do_expr13(CsCompiler *c, PVAL& pv) {
    int tkn, op;
    do_expr13a(c, pv);

    for (tkn = CsToken(c); tkn; tkn = CsToken(c)) {
      // bool neg = false;
      switch (tkn) {
      case '*': op = BC_MUL; break;
      case '/': op = BC_DIV; break;
      case '%': op = BC_REM; break;
      default: goto NA;
      }

      PVAL vr;
      do_expr13a(c, vr);
      pv = new expr::binary(c, byte(op), pv, vr);

    }
  NA:
    CsSaveToken(c, tkn);
  }

  static void do_expr13a(CsCompiler *c, PVAL& pv) {
    int tkn, op;
    do_expr14(c, pv);
    for (tkn = CsToken(c); tkn; tkn = CsToken(c)) {
      bool neg = false;
      switch (tkn) {

      case T_FARROW:
        do_fat_arrow(c, pv);
        return;

      case T_CAR: op = BC_CAR; break;
      case T_CDR: op = BC_CDR; break;
      case T_RCAR: op = BC_RCAR; break;
      case T_RCDR: op = BC_RCDR; break;

      case T_INSTANCEOF: op = BC_INSTANCEOF; break;
      case T_LIKE: op = BC_LIKE; break;
      case '!': // smth !instanceof class
        tkn = CsToken(c);
        if (tkn == T_INSTANCEOF) {
          op  = BC_INSTANCEOF;
          neg = true;
          break;
        } else if (tkn == T_LIKE) {
          op  = BC_LIKE;
          neg = true;
          break;
        } else if (tkn == T_IN) {
          op  = BC_IN;
          neg = true;
          break;
        } else
          CsParseError(c, "'!' is invalid here");
      default: goto NA;
      }
      //rvalue(c, pv);
      //putcbyte(c, BC_PUSH_VALUE);
      //do_expr14(c, pv);
      //rvalue(c, pv);
      //putcbyte(c, op);
      //if (neg) putcbyte(c, BC_NOT);

      PVAL vr;
      do_expr14(c, vr);
      pv = new expr::binary(c, byte(op), pv, vr);
      if (neg)
        pv = new expr::unary(c, BC_NOT, pv);
    }
  NA:
    CsSaveToken(c, tkn);
  }

  /* do_expr14 - handle unary operators */
  static void do_expr14(CsCompiler *c, PVAL& pv) {
    int tkn;
    switch (tkn = CsToken(c)) {
    case '-':
      do_expr15(c, pv);
      pv = new expr::unary(c, BC_NEG, pv);
      break;
    case '+':
      do_expr15(c, pv);
      break;
    case '!':
      do_expr14(c, pv);
      pv = new expr::unary(c, BC_NOT, pv);
      break;
    case '~':
      do_expr15(c, pv);
      pv = new expr::unary(c, BC_BNOT,pv);
      break;
    case T_INC: do_preincrement(c, pv, BC_INC); break;
    case T_DEC: do_preincrement(c, pv, BC_DEC); break;
    case T_TYPEOF:
      do_expr15(c, pv);
      pv = new expr::unary(c, BC_TYPEOF, pv);
      break;
    case T_VOID:
      do_expr15(c, pv);
      pv = new expr::unary(c, BC_NOTHING, pv);
      break;
    case T_AWAIT:
      if (c->functionLevel == 0)
        CsParseError(c, "'await' can be used only inside function");
      if (c->functionType != ASYNC && c->functionType != EVENT)
        CsParseWarning(c, "'await' should be used only inside 'async' or 'event'");
      if (c->yieldSeen)
        CsParseError(c, "'yield' and 'await' cannot be used in the same function");
      c->awaitSeen = true;

      do_right_side_expr(c, pv);
      pv = new expr::unary(c, BC_AWAIT, pv);

      break;
    case T_YIELD:
      if (c->functionLevel == 0)
        CsParseError(c, "'yield' can be used only inside function");
      if (c->functionType != GENERATOR)
        CsParseWarning(c, "'yield' should be used only inside 'generator'");
      if (c->awaitSeen)
        CsParseError(c, "'yield' and 'await' cannot be used in the same function");
      c->yieldSeen = true;

      do_right_side_expr(c, pv);
      pv = new expr::unary(c, BC_YIELD, pv);

      break;
    default:
      CsSaveToken(c, tkn);
      do_expr15(c, pv);
      return;
    }
  }

  /* do_preincrement - handle prefix '++' and '--' */
  static void do_preincrement(CsCompiler *c, PVAL& pv, int op) {
    do_expr15(c, pv);
    chklvalue(c, pv);
    pv = new expr::preop(c, byte(op), pv);
  }

  /* do_postincrement - handle postfix '++' and '--' */
  static void do_postincrement(CsCompiler *c, PVAL& pv, int op) {
    chklvalue(c, pv);
    pv = new expr::postop(c, byte(op), pv);
  }


  /* do_expr15 - handle the '??' operator */
  static void do_expr15(CsCompiler *c, PVAL& pv, bool handle_in) {
    int tkn;
    do_expr16(c, pv, handle_in);
    while ((tkn = CsToken(c)) == T_QUESTION_QUESTION) {
      PVAL pvr;
      do_expr16(c, pvr, true);
      pv = new expr::optional_fallback(c, pv, pvr);
    }
    CsSaveToken(c, tkn);
  }


  /* do_expr16 - handle function calls */
  static void do_expr16(CsCompiler *c, PVAL& pv, bool allow_call_objects) {
    int tkn;
    do_primary(c, pv);

    if (!pv)
    {
      CsParseError(c, "internal error");
      return;
    }

    string name;
    bool is_$_name = c->disallowStringiziers
                      ? false
                      : (pv->is_var_ref(&name) && name[0] == '$');

    while ((tkn = CsToken(c)) == '(' || tkn == '[' ||
           (allow_call_objects && (tkn == '{')) || tkn == '.' || tkn == T_SYMBOL || tkn == T_INC || tkn == T_DEC || tkn == T_QUESTION_DOT)
      switch (tkn) {
      case '(':
        // if
        if (is_$_name)
          do_$_call(c, pv);
        else
          do_call(c, pv);
        break;
      case '{': do_call_object(c, pv); break;
      case '[': do_index(c, pv); break;
      case '.': do_prop_reference(c, pv); break;
      case T_QUESTION_DOT:
        do_prop_optional_reference(c, pv);
        break;
      case T_SYMBOL:
        CsSaveToken(c, tkn);
        do_symbol_index(c, pv);
        break;
      case T_INC: do_postincrement(c, pv, BC_INC); break;
      case T_DEC: do_postincrement(c, pv, BC_DEC); break;
      }
    CsSaveToken(c, tkn);
  }

  /* do_prop_reference - parse a property reference */
  static void do_prop_reference(CsCompiler *c, PVAL& pv) {
    int tkn;

    // get the selector
    PVAL pvsel;
    do_selector(c,pvsel);

    bool is$ = c->disallowStringiziers ? false : c->t_token[0] == '$';

    // check for a method call
    if ((tkn = CsToken(c)) == '(') {
      if (is$)
        do_$_method_call(c, pv,pvsel);
      else
        do_method_call(c, pv,pvsel);
    } else if (tkn == '{') {
      do_method_call_object(c, pv,pvsel);
    }
    // handle a property reference
    else {
      pv = new expr::property(c, pv, pvsel);
      CsSaveToken(c, tkn);
    }
  }

  /* do_prop_reference - parse a property reference
     obj?.selector
  */
  static void do_prop_optional_reference(CsCompiler *c, PVAL& pv) {
    int tkn;

    // get the selector
    PVAL pvsel;
    do_selector(c, pvsel);

    bool is$ = c->disallowStringiziers ? false : c->t_token[0] == '$';

    // check for a method call
    if ((tkn = CsToken(c)) == '(') {
      if (is$)
        do_$_method_call(c, pv, pvsel,true);
      else
        do_method_call(c, pv, pvsel, true);
    }
    else if (tkn == '{') {
      do_method_call_object(c, pv, pvsel, true);
    }
    // handle a property reference
    else {
      pv = new expr::optional_property(c, pv, pvsel);
      CsSaveToken(c, tkn);
    }
  }

  /* do_selector - parse a property selector */
  static void do_selector(CsCompiler *c,PVAL& pv) {
    int tkn;
    switch (tkn = CsToken(c)) {
    // these are allowed as selector names:
    case T_FUNCTION:
    case T_VAR:
    case T_LET:
    case T_IF:
    case T_ELSE:
    case T_WHILE:
    case T_RETURN:
    case T_FOR:
    case T_BREAK:
    case T_CONTINUE:
    case T_DO:
    case T_SWITCH:
    case T_CASE:
    case T_DEFAULT:
    case T_NULL:
    //case T_TYPE:
    case T_SUPER:
    case T_NEW:
    case T_TRY:
    case T_CATCH:
    case T_FINALLY:
    case T_THROW:
    case T_TYPEOF:
    case T_INSTANCEOF:
    case T_IN:
    case T_PROPERTY:
    case T_CONST:
    //case T_GET:
    //case T_SET:
    case T_INCLUDE:
    case T_LIKE:
    case T_NAMESPACE:
    case T_ASSERT:
    case T_THIS:
    case T_DELETE:
    case T_OTHERWISE:
    case T_WITH:
    case T_CLASS:
    case T_IDENTIFIER:
    case T_EVENT:
    case T_ASYNC:
      pv = new expr::literal(c, tool::value(c->t_token)); break;
    case '(':
      do_expr2(c,pv, false);
      frequire(c, ')');
      break;
    default: CsParseError(c, "Expecting a property selector"); break;
    }
  }

  /* do_primary - parse a primary expression and unary operators */
  static void do_primary(CsCompiler *c, PVAL& pv) {
    int tkn;
    switch (tkn = CsToken(c)) {
    case T_ASYNC:
      if (CsToken(c) != T_FUNCTION)
        CsParseError(c," Expecting 'function' - declaration of async function");
      do_lambda(c, pv, ASYNC);
      break;
    case T_FUNCTION: do_lambda(c, pv, FUNCTION); break;
    case T_EVENT: do_event(c, pv); break;
    case T_PROPERTY: do_lambda(c, pv, PROPERTY); break;
    case '\\': //?????
      do_literal(c, pv);
      break;
    case '(':
      do_expr_list(c, pv);
      frequire(c, ')');
      break;
    case T_INTEGER:
    case T_FLOAT:
    case T_LENGTH:
    case T_ANGLE:
    case T_DURATION:
      pv = new expr::literal(c, c->t_value);
      break;
    case T_SYMBOL:
      pv = new expr::literal(c, tool::value(c->t_token));
      break;
    case T_STRING: {
        tool::array<wchar> buf;
        do {
          wchars str = c->get_wtoken_string();
          buf.push(str);
          if ((tkn = CsToken(c)) == T_STRING) continue;
          CsSaveToken(c, tkn);
          break;
        } while (tkn != T_EOF);

        pv = new expr::literal(c, tool::value(buf()));
      }
      break;
    case T_NULL:
      pv = new expr::literal_code(c, BC_NULL);
      break;
    case T_IDENTIFIER:
      if (c->t_token[0] == '@' && c->t_token[1] != 0) {
        CsSaveToken(c, tkn);
        do_decorator(c);
        pv = new expr::noop(c);
        break;
      }
      findvariable(c, c->t_token, pv);
      break;

    case T_THIS:
      tkn = CsToken(c);
      if (tkn == T_FUNCTION) {
        pv = new expr::literal_code(c, BC_THIS_FUNCTION);
      } else if (tkn == T_SUPER) {
        int level = 1;
        while ((tkn = CsToken(c)) == T_SUPER)
          ++level;
        CsSaveToken(c, tkn);
        int lev, off;
        if (!FindThis(c, lev, off, level))
          CsParseError(c, "no 'this' at this level");

        pv = new expr::evar_immutable(c, "this", lev, off);

      } else {
        CsSaveToken(c, tkn);
        int lev, off;
        if (FindThis(c, lev, off)) {
          pv = new expr::evar_immutable(c, "this",lev, off);
        } else
          CsParseError(c, " 'this' cannot be used in this function");
      }
      break;
    case T_SUPER: do_super(c, pv); break;
    case T_NEW:
      do_new_obj(c, pv);
      break;

    case ':':
      CsSaveToken(c, tkn);
      do_lambda(c, pv, FUNCTION);
      break;

    case '|':  // |a,b| statement;  | a,b { statements; } - outer 'this'
      CsSaveToken(c, tkn);
      do_lambda(c, pv, FUNCTION);
      break;
    case T_OR: // || statement; - outer 'this'
      CsSaveToken(c, '|'); // treat `||` as two `|`, `|` here
      c->savedChar = '|';
      do_lambda(c, pv, FUNCTION);
      break;

    case '[': /* vector */ do_literal_vector(c, pv); break;
    case '{': /* obj */ do_literal_obj(c, pv); break;
    case '/':
    case T_DIVEQ: do_literal_regexp(c, pv, tkn); break;
    case T___FILE__:
      //do_lit_string(c, tool::chars_of(c->input->stream_name()));
      pv = new expr::literal(c, tool::value(c->input->stream_name()));
      break;
    case T___FOLDER__: {
      tool::wchars path = tool::chars_of(c->input->stream_name());
      path              = path.r_head('/');
      if (path.length) path.length += 1; // to include trailing '/'
      //do_lit_string(c, path);
      pv = new expr::literal(c, tool::value(path));
    } break;
    case T___LINE__:
      //do_lit_integer(c, c->lineNumber);
      pv = new expr::literal(c, tool::value(c->lineNumber));
      break;
    case T___TRACE__:
      pv = new expr::literal_code(c, BC_TRACE);
      break;
    case T_INCLUDE:
      do_include(c);
      pv = new expr::noop(c);
      break;
    case T_IMPORT:
      do_import(c);
      pv = new expr::noop(c);
      break;
    case '<':
      do_ssx(c, pv, true);
      break;

    default: CsParseError(c, "Expecting a primary expression"); break;
    }
  }

  static void do_primary_json(CsCompiler *c, PVAL& pv) {
    int tkn;
    switch (tkn = CsToken(c)) {
    case '\\': //?????
      do_literal(c, pv);
      break;
    case '(':
      do_expr1(c, pv, true);
      frequire(c, ')');
      break;
    case '-':
      do_primary_json(c, pv);
      pv = new expr::unary(c, BC_NEG, pv);
      break;
    case '+':
      do_primary_json(c, pv);
      break;
    case T_INTEGER:
    case T_FLOAT:
    case T_LENGTH:
    case T_ANGLE:
    case T_DURATION:
      pv = new expr::literal(c, c->t_value);
      break;

    case T_IDENTIFIER:
    case T_SYMBOL:
      pv = new expr::literal(c, tool::value(c->t_token));
      break;
    case T_STRING: {
        tool::array<wchar> buf;
        do {
          wchars str = c->get_wtoken_string();
          buf.push(str);
          if ((tkn = CsToken(c)) == T_STRING) continue;
          CsSaveToken(c, tkn);
          break;
        } while (tkn != T_EOF);
        pv = new expr::literal(c, tool::value(buf()));
      }
      break;
    case T_NULL:
      pv = new expr::literal_code(c, BC_NULL);
      break;

    case '[': /* vector */ do_literal_vector(c, pv); break;
    case '{': /* obj */ do_literal_obj(c, pv); break;
    case '/':
    case T_DIVEQ: do_literal_regexp(c, pv, tkn); break;

      // else fall through
    default: CsParseError(c, "Expecting a primary expression"); break;
    }
  }

  /* do_variable - parse a variable name only */
  static void do_variable(CsCompiler *c, PVAL& pv) {
    if (CsToken(c) == T_IDENTIFIER)
      findvariable(c, c->t_token, pv);
    else
      CsParseError(c, "Expecting a variable name");
  }

  static void do_method(CsCompiler *c, char *name, FUNCTION_TYPE fct);

  static void do_function_local(CsCompiler *c, FUNCTION_TYPE ft,
                                ATABLE **patable, int *pptr) {
    // char name[TKNSIZE+1]; name[0] = 0;
    int decl_line_no = c->lineNumber;

    qualified_name qn(c);

    /* check for a function name */
    frequire(c, T_IDENTIFIER);

    qn.append(c->t_token);

    InjectArgFrame(c, patable, pptr);

    if (ArgumentExists(c, *patable, qn.local_name))
      CsParseError(c, "Name already defined");
    AddArgument(c, *patable, qn.local_name, true);

    c->cDOMcb->on_method(true, qn.local_name, FUNCTION, decl_line_no);

    PVAL pv;

    /* compile function body */
    compile_code(c, qn.name, ft, pv);

    c->cDOMcb->on_method(false, qn.local_name, FUNCTION, c->lineNumber);

    /* store the function as the value of the local variable */

    int  lev, off;
    bool dummy;
    dummy = FindArgument(c, qn.local_name, lev, off, dummy);
    assert(dummy);

    putcbyte(c, BC_ESET);
    putcbyte(c, lev);
    putcbyte(c, off);

  }

  bool scan_stringizer_literal(CsCompiler *c);

  static void do_event_def(CsCompiler *c, string &name, string &ns,
                           ustring &selector) {
    // T_EVENT just parsed

    int tkn = CsToken(c, true);

    require_or(c, tkn, T_SYMBOL, T_STRING, '~');

    bool sinkingMofifier = false;
    if (tkn == '~') {
      tkn = CsToken(c, true);
      require(c, tkn, T_SYMBOL);
      tkn             = T_SYMBOL;
      sinkingMofifier = true;
    }
    if (tkn == T_SYMBOL) {
      name = c->t_token;
      if (sinkingMofifier) name.insert(CHARS("~"), 0);
    } else { // if( tkn == T_STRING)
      wchars spec = c->get_wtoken_string();
      wchars nns  = spec.chop('|');
      if (spec.length) selector = spec;
      name = string(nns.chop('.'));
      ns   = string(nns);
      goto CHECK_SELECTOR;
    }
    tkn = CsToken(c);
    while (tkn == ':') {
      tkn = CsToken(c, true);
      require(c, tkn, T_SYMBOL);
      name += ":";
      name += c->t_token;
      tkn = CsToken(c);
    }
    if (tkn == '.') {
      tkn = CsToken(c, true);
      require(c, tkn, T_SYMBOL);
      ns  = c->t_token;
      tkn = CsToken(c);
    }
  CHECK_SELECTOR:
    if (tkn == T_IDENTIFIER && c->t_token[0] == '$' && c->t_token[1] == 0) {
      if (!scan_stringizer_literal(c)) CsParseError(c, "expecting selector");
      selector = c->get_wtoken_string();
    } else
      CsSaveToken(c, tkn);

    name.to_lower();
  }

  /* do_function - parse function or property in global space */
  static void do_function(CsCompiler *c, FUNCTION_TYPE fct, bool store, bool is_static) {
    // char name[TKNSIZE+1]; name[0] = 0;
    int tkn, decl_line_no = c->lineNumber;

    qualified_name qn(c);

    /* check for a function name */
    // frequire(c,T_IDENTIFIER);
    if (fct == EVENT) {
      string  name, ns;
      ustring selector;
      do_event_def(c, name, ns, selector);
      qn.append(tool::string::format("%s.%s|%S", name.c_str(), ns.c_str(),
                                     selector.c_str()));
      emit_literal(c, addliteral(c, CsSymbolOf("event")));
      putcbyte(c, BC_PUSH_VALUE);
      emit_literal(c, make_lit_symbol(c, name));
      putcbyte(c, BC_PUSH_VALUE);
      if (ns.is_defined())
        emit_literal(c, make_lit_symbol(c, ns));
      else
        putcbyte(c, BC_UNDEFINED);
      putcbyte(c, BC_PUSH_VALUE);
      if (selector.is_defined())
        emit_literal(c, make_lit_string(c, selector()));
      else
        putcbyte(c, BC_UNDEFINED);
      putcbyte(c, BC_PUSH_VALUE);
      putcbyte(c, BC_NEWTUPLE_STACK);
      putcword(c, 3);
      putcbyte(c, BC_PUSH_VALUE);
    } else {
      frequire_or(c, T_IDENTIFIER, T_THIS);
      if (strcmp(c->t_token, "undefined") == 0) fct = UNDEFINED_PROPERTY;
      qn.append(c->t_token);
    }

    // if(qn.is_root()) // functions inside namespace can have dot names.
    {
      tkn = CsToken(c);
      if (tkn == '.') {
        do_method(c, qn.local_name, fct);
        return;
      } else if (tkn == T_SYMBOL) {
        CsSaveToken(c, tkn);
        do_method(c, qn.local_name, fct);
        return;
      } else
        CsSaveToken(c, tkn);
    }

    c->cDOMcb->on_method(true, qn.local_name, fct, decl_line_no);

    /* compile function body */
    PVAL pv;
    compile_code(c, qn.name, fct, pv, is_static);

    if (store) {
      if (fct == EVENT) {
        putcbyte(c, BC_PUSH_VALUE);
        putcbyte(c, BC_NS);
        putcbyte(c, BC_ADD_EVENT);
      } else {
        //putcbyte(c, BC_GSETNS_NEW);
        //putcword(c, make_lit_symbol(c, qn.local_name));
        pv = new expr::gvar(c, qn.local_name, expr::gvar::NEW_NAMESPACE_CONST);
        pv->do_store(c);
        if (c->exportSeen && c->exports) {
          if (c->defaultSeen)
            c->exports->elements.insert(0,pv);
          else
            c->exports->elements.push(pv);
        }
      }
    }
    c->cDOMcb->on_method(false, qn.local_name, fct, c->lineNumber);
  }

  static string do_lambda(CsCompiler *c, PVAL& pv, FUNCTION_TYPE fct) {
    char           name[256];
    int            tkn = CsToken(c);
    string         loclal_name;
    qualified_name qn(c);
    if (tkn == T_IDENTIFIER) {
      qn.append(c->t_token);
    } else if (tkn == '(' || tkn == ':' || tkn == '|' || tkn == T_OR) {
      CsSaveToken(c, tkn);
      sprintf(name, "@%d@%d", c->lineNumber, int(c->linePtr - c->line.head()));
      qn.append(name);
    } else
      CsParseError(c, "expecting name or parameter list");
    /* compile function body */
    int start = codeaddr(c);
    compile_code(c, qn.name, fct, pv);
    int end = codeaddr(c);
    pv = new expr::bytecodes(c, bytes(c->cbase + start, size_t(end - start)) );
    discard_codes(c, start);
    return qn.local_name;
  }

  static void do_fat_arrow(CsCompiler *c, PVAL& pv, expr_transformer tran) {
    char           name[256];
    qualified_name qn(c);
    sprintf(name, "@%d@%d", c->lineNumber, int(c->linePtr - c->line.head()));
    qn.append(name);

    if (!pv->is_list()) {
      expr::list* pl = new expr::list(c,expr::list::VARS, true);
      pl->elements.push(pv);
      pv = pl;
    }

    /* compile function body */
    int start = codeaddr(c);
    compile_code(c, qn.name, FAT_ARROW, pv, false, tran);
    int end = codeaddr(c);
    pv = new expr::bytecodes(c, bytes(c->cbase + start, size_t(end - start)));
    discard_codes(c, start);
  }


  static void do_event(CsCompiler *c, PVAL& pv) {

    int start = codeaddr(c);

    qualified_name qn(c);

    string  name, ns;
    ustring selector;
    do_event_def(c, name, ns, selector);
    qn.append(tool::string::format("%s.%s|%S", name.c_str(), ns.c_str(),
                                   selector.c_str()));
    emit_literal(c, addliteral(c, CsSymbolOf("event")));
    putcbyte(c, BC_PUSH);
    emit_literal(c, make_lit_symbol(c, name));
    putcbyte(c, BC_PUSH);
    if (ns.is_defined())
      emit_literal(c, make_lit_symbol(c, ns));
    else
      putcbyte(c, BC_UNDEFINED);
    putcbyte(c, BC_PUSH);
    if (selector.is_defined())
      emit_literal(c, make_lit_string(c, selector()));
    else
      putcbyte(c, BC_UNDEFINED);
    putcbyte(c, BC_PUSH);
    putcbyte(c, BC_NEWTUPLE_STACK);
    putcword(c, 3);
    putcbyte(c, BC_PUSH);

    /* compile function body */
    compile_code(c, qn.name, EVENT, pv);
    int end = codeaddr(c);
    pv = new expr::bytecodes(c, bytes(c->cbase + start, size_t(end - start)));
    discard_codes(c, start);

  }

  struct method_qualified_name {
    CsCompiler *c;
    char        name[TKNSIZE * 2];
    char *      end;
    char *      tail;
    char *      selector;
    char *      function_name;
    const char *prev_name;

    method_qualified_name(CsCompiler *comp) : c(comp) {
      end         = &name[TKNSIZE * 2 - 1];
      int base_sz = (int)strlen(c->qualifiedName);
      strcpy_s(name, c->qualifiedName);
      tail             = name + base_sz;
      function_name    = name;
      selector         = 0;
      prev_name        = c->qualifiedName;
      c->qualifiedName = name;

      /*name[0] = 0;
      name[TKNSIZE*2] = 0;
      prev_name = c->qualifiedName;
      c->qualifiedName = name;
      local_name[0] = 0;
      local_name[TKNSIZE] = 0;*/
    }
    ~method_qualified_name() { c->qualifiedName = prev_name; }

    /*method_qualified_name(const char* base)
    {
      end = &name[TKNSIZE*2 - 1];
      int base_sz = strlen(base);
      strcpy_s( name, base );
      tail = name + base_sz;
      selector = 0;
    }*/

    void _append(const char *str) {
      while ((tail < end) && *str)
        *tail++ = *str++;
      *tail = 0;
    }
    void append_name(const char *name) {
      _append(".");
      selector = tail;
      _append(name);
    }
    void append_sym(const char *name) {
      _append("#");
      _append(name);
      selector = 0;
    }
  };

  static void do_method(CsCompiler *c, char *name, FUNCTION_TYPE fct) {
    int tkn, decl_line_no = c->lineNumber;

    // c->lineNumberChangedP = true;

    method_qualified_name mqn(c);

    /* push the class */
    variable_ref(c, name);
    putcbyte(c, BC_PUSH);

    /* get the selector */
    for (;;) {
      decl_line_no = c->lineNumber;
      tkn          = CsToken(c);
      if (tkn == T_IDENTIFIER) {
        mqn.append_name(c->t_token);
        tkn = CsToken(c);
        if (tkn == '(') break;
        do_lit_symbol(c, mqn.selector);
        putcbyte(c, BC_GETP);
        putcbyte(c, BC_PUSH_VALUE);
        if (tkn != '.') CsSaveToken(c, tkn);
        continue;
      } else if (tkn == T_SYMBOL) {
        mqn.append_sym(c->t_token);
        do_lit_symbol(c, c->t_token);
        putcbyte(c, BC_VREF);
        putcbyte(c, BC_PUSH_VALUE);
        tkn = CsToken(c);
        if (tkn != '.') CsSaveToken(c, tkn);
        continue;
      }
      CsParseError(c, "Expecting symbol or property name");
    }

    /* push the selector symbol */
    CsSaveToken(c, tkn);
    if (!mqn.selector) CsParseError(c, "Expecting property name");
    do_lit_symbol(c, mqn.selector);

    putcbyte(c, BC_PUSH);

    int savedLineNumber = c->lineNumber;

    c->cDOMcb->on_method(true, mqn.function_name, fct, decl_line_no);

    /* compile the code */
    PVAL pv;
    compile_code(c, mqn.name, fct, pv);

    int newLineNumber = c->lineNumber;
    c->cDOMcb->on_method(false, mqn.function_name, fct, newLineNumber);

    c->lineNumber         = savedLineNumber;
    c->lineNumberChangedP = true;
    /* store the method as the value of the property */
    putcbyte(c, BC_SETPM);

    c->lineNumberChangedP = true;
    c->lineNumber         = newLineNumber;
  }

  /* do_literal - parse a literal expression */
  static void do_literal(CsCompiler *c, PVAL& pv) {
    int tkn;
    switch (tkn = CsToken(c)) {
    case T_IDENTIFIER: /* symbol */ do_literal_symbol(c, pv); break;
    case '[': /* vector */ do_literal_vector(c, pv); break;
    case '{': /* obj */ do_literal_obj(c, pv); break;
    case '/':
    case T_DIVEQ: do_literal_regexp(c, pv, tkn); break;

    default:
      CsParseError(c, "Expecting literal symbol, array, object or regexp");
      break;
    }
  }

  /* do_literal_symbol - parse a literal symbol */
  static void do_literal_symbol(CsCompiler *c, PVAL& pv) {
    pv = new expr::literal(c, tool::value(c->t_token));
  }

  /* do_literal_vector - parse a literal vector or destructuring assignment */
  /*static void do_literal_vector_or_da(CsCompiler *c, PVAL& pv, int tkn) {
    int cnt = 0;

    int dot_dots = 0;

    if (tkn != ']') {
      CsSaveToken(c, tkn);
    PARSE_ELEMENTS:
      do {
        ++cnt;
        {
          PVAL v;
          if (do_call_param_expr(c, &v, true))
            ++dot_dots;
          //pv->is_nmtoken_list
          //rvalue(c, &v);
          putcbyte(c, BC_PUSH_VALUE);
        }
        tkn = CsToken(c);
        if (tkn == ',') {
          if ((tkn = CsToken(c)) == ']') break;
          CsSaveToken(c, tkn);
        }
        else
          break;
      } while (true);
      require(c, tkn, ']');
    }
    // do_lit_integer(c,has_tag?-cnt:cnt);
    if (dot_dots)
      putcbyte(c, BC_NEWVECTOR_WITH_SPREADS);
    else
      putcbyte(c, BC_NEWVECTOR);

    assert(cnt < 0xFFFF);
    putcword(c, cnt);

   pv = new expr::noop();
  }*/

  bool isidchar(int ch);

  static bool looksLikeSymbolColon(CsCompiler *c) {
    for (const wchar* p = c->linePtr; p < c->line.end(); ++p) {
      if (*p == '-') continue;
      if (*p == ' ') continue;
      if (*p == ':') return true;
      if (isidchar(*p)) continue;
      break;
    }
    return false;
  }

  /* do_literal_vector - parse a literal vector */
  static void do_literal_vector(CsCompiler *c, PVAL& pv) {

    int cnt = 0;

    int tkn = CsToken(c, looksLikeSymbolColon(c));

    expr::list* list = new expr::list(c, expr::list::VECTOR, true);
    pv = list;

    // check [tagname: e1,e2,e3, ...] case - tuple literal
    if ((tkn == T_IDENTIFIER || tkn == T_SYMBOL) && c->savedChar == ':' /*sorry, one additional lookahead */) {
      list->tag = new expr::literal(c, tool::value(c->t_token));
      tkn = CsToken(c);
      assert(tkn == ':');
      goto PARSE_ELEMENTS;
    }

    if (tkn != ']') {
      CsSaveToken(c, tkn);

    PARSE_ELEMENTS:
      do {
        ++cnt;
        {
          PVAL iv;
          if (do_call_param_expr(c, iv, true))
            iv = new expr::rest(c, iv);
          list->elements.push(iv);
        }
        tkn = CsToken(c);
        if (tkn == ',') {
          if ((tkn = CsToken(c)) == ']') break;
          CsSaveToken(c, tkn);
        } else
          break;
      } while (true);
      require(c, tkn, ']');
    }
  }

  void getregexp(CsCompiler *c);

  static void do_literal_regexp(CsCompiler *c, PVAL& pv, int tkn) {

    expr::literal_regexp* re = new expr::literal_regexp(c);
    pv = re;

    if (tkn == T_DIVEQ) re->re = WCHARS("=");

    getregexp(c);

    re->re += c->get_wtoken_string();
    re->flags = ustring(c->t_token);

  }

  static void do_expr_white_space_list(CsCompiler *c, PVAL& pv);

  static void do_pair(CsCompiler *c, PVAL& pv) {

    PVAL pname, pval;

    int tkn = CsToken(c, true);
    switch (tkn) {
    case T_IDENTIFIER:
    case T_SYMBOL:
      pname = new expr::literal(c, tool::value(c->t_token));
      break;
    case T_STRING:
      pname = new expr::literal(c, tool::value(c->get_wtoken_string()));
      break;
    case T_LENGTH:
    case T_DURATION:
    case T_ANGLE:
    case T_INTEGER:
    case T_FLOAT:
      pname = new expr::literal(c, c->t_value);
      break;

    case T_FUNCTION:
    case T_VAR:
    case T_LET:
    case T_IF:
    case T_ELSE:
    case T_WHILE:
    case T_RETURN:
    case T_FOR:
    case T_BREAK:
    case T_CONTINUE:
    case T_DO:
    case T_SWITCH:
    case T_CASE:
    case T_DEFAULT:
    case T_NULL:
      //case T_TYPE:
    case T_SUPER:
    case T_NEW:
    case T_TRY:
    case T_CATCH:
    case T_FINALLY:
    case T_THROW:
    case T_TYPEOF:
    case T_INSTANCEOF:
    case T_IN:
    case T_PROPERTY:
    case T_CONST:
      //case T_GET:
      //case T_SET:
    case T_INCLUDE:
    case T_LIKE:
    case T_NAMESPACE:
    case T_ASSERT:
    case T_THIS:
    case T_DELETE:
    case T_OTHERWISE:
    case T_WITH:
    case T_CLASS:
      pname = new expr::literal(c, tool::value(c->t_token));
      break;

    case '[':
      do_right_side_expr(c, pname);
      frequire(c, ']');
      break;
    case '(':
      do_right_side_expr(c, pname);
      frequire(c, ')');
      break;

    default:
      CsParseError(c, "expecting property key");
      //CsSaveToken(c, tkn);
      //do_primary(c, pname);
    }

    tkn = CsToken(c);
    if (tkn == ':')
      do_expr_white_space_list(c, pval);
    else if (is_as_token(c, tkn)) {
      frequire(c, T_IDENTIFIER);
      pval = new expr::literal(c,tool::value(c->t_token));
      //do_expr_white_space_list(c, pval);
    }
    else {
      CsSaveToken(c, tkn);
      pval = new expr::literal_code(c, BC_NOTHING);
    }
    pv = new expr::pair(c, pname, pval);
  }


  /* do_literal_obj - parse a literal obj */
  static void do_literal_obj(CsCompiler *c, PVAL& pv) {

    expr::list* list = new expr::list(c, expr::list::MAP, true);
    pv = list;

    int tkn;

    while((tkn = CsToken(c,true)) != '}')
    {
      if (tkn == ',' || tkn == ';')
        continue;

      PVAL item;

      if (tkn == T_DOTDOT || tkn == T_DOTDOTDOT) {
        frequire(c, T_IDENTIFIER);
        findvariable(c, c->t_token, item);
        item = new expr::rest(c, item);
      }
      else {
        CsSaveToken(c, tkn);
        do_pair(c, item);
        tkn = CsToken(c);
        if (tkn == '=') {
          PVAL pvr;
          do_right_side_expr(c, pvr);
          item = new expr::assignment(c, item, pvr);
        }
        else
          CsSaveToken(c, tkn);
      }

      list->elements.push(item);
    }
    require(c, tkn, '}');
  }


  /* do_call - compile a function call */
  static void do_call(CsCompiler *c, PVAL& pv) {

    expr::call* pcall = new expr::call(c, pv);
    pv = pcall;

    int tkn = CsToken(c);
    if (tkn != ')') {
      CsSaveToken(c, tkn);
      do {
        PVAL param;
        bool rest = do_call_param_expr(c, param, true);
        if( rest )
          pcall->parameters.push(new expr::rest(c, param));
        else
          pcall->parameters.push(param);
      } while ((tkn = CsToken(c)) == ',');
    }
    require(c, tkn, ')');
  }

  /* do_call - compile "stringizer" function call */
  static void do_$_call(CsCompiler *c, PVAL& pv) {

    expr::call* pcall = new expr::call(c, pv);
    pv = pcall;

    int bracket_level = 1;

    PVAL param;

    int lastc = scan_stringizer_string(c, bracket_level);

    param = new expr::literal(c, tool::value(c->t_wtoken()));
    pcall->parameters.push(param);

    while (lastc == '{') {
      do_call_param_expr(c, param);
      frequire(c, '}');
      pcall->parameters.push(param);
      lastc = scan_stringizer_string(c, bracket_level);
      param = new expr::literal(c, tool::value(c->t_wtoken()));
      pcall->parameters.push(param);
    }

    if (lastc != ')') CsParseError(c, "expecting ')'");

  }

  /* do_call_object - compile a function call with single parameter - object
   * literal */
  static void do_call_object(CsCompiler *c, PVAL& pv) {

    expr::call* pcall = new expr::call(c, pv);
    pv = pcall;

    PVAL param;
    do_literal_obj(c, param);

    pcall->parameters.push(param);
  }

  /* do_super - compile a super.selector() expression */
  static void do_super(CsCompiler *c, PVAL& pv) {

    PVAL _this, _next;
    if (!load_argument(c, "this",_this))
      CsParseError(c, "Use of super outside of a method");
    load_argument(c, "!next",_next);

    int tkn = CsToken(c);

    bool is_method = false;

    if (tkn == '.') {
      is_method = true;
      do_selector(c, pv);
    }
    else {
      pv = new expr::literal(c, tool::value("this"));
      CsSaveToken(c, tkn);
    }

    frequire(c, '(');

    expr::call_method_super* pcall = new expr::call_method_super(c, _this, _next, _next, pv);
    pv = pcall;

    tkn = CsToken(c);
    if (tkn != ')') {
      CsSaveToken(c, tkn);
      do {
        PVAL param;
        bool rest = do_call_param_expr(c, param, true);
        if (rest)
          pcall->parameters.push(new expr::rest(c, param));
        else
          pcall->parameters.push(param);
      } while ((tkn = CsToken(c)) == ',');
    }
    require(c, tkn, ')');
  }

  /* do_new_obj - compile a new obj expression */
  static void do_new_obj(CsCompiler *c, PVAL& pv) {

    int tkn = CsToken(c);
    if (tkn == T_IDENTIFIER)
      findvariable(c, c->t_token, pv);
    else {
    UNEXPECTED:
      CsParseError(c, "Expecting name, '(' or '{'");
    }

    for (tkn = CsToken(c); tkn; tkn = CsToken(c)) {
      if (tkn == '(')
        break;
      else if (tkn == '{')
        break;
      else if (tkn == '.')
      {
        tkn = CsToken(c);
        if (tkn == T_IDENTIFIER) {
          PVAL psel = new expr::literal(c, tool::value(c->t_token));
          pv = new expr::property(c, pv,psel);
        } else
          goto UNEXPECTED;
      }
      else if (tkn == '[') {
        do_index(c, pv);
      }
      else
        goto UNEXPECTED;
    }

    PVAL sele = new expr::literal(c, tool::value("this"));
    PVAL coll = pv;

    handle<expr::call_method> call;

                    // sp[3] - obj
                    // sp[2] - obj
                    // sp[1] - #this
                    // sp[0] - class
    if (tkn == '{')
      call = do_method_call_object(c, pv, sele);
    else
      call = do_method_call(c, pv, sele);

    pv = new expr::new_object(c, coll, call);
  }

  /* do_method_call - compile a method call expression */
  static handle<expr::call_method> do_method_call(CsCompiler *c, PVAL& pv, PVAL pp, bool optional)
  {
    expr::call_method* pcall = optional
      ? new expr::optional_call_method(c, pv, pp)
      : new expr::call_method(c, pv, pp);
    pv = pcall;

    int tkn = CsToken(c);
    if (tkn != ')') {
      CsSaveToken(c, tkn);
      do {
        PVAL param;
        bool rest = do_call_param_expr(c, param, true);
        if(rest)
          pcall->parameters.push(new expr::rest(c, param));
        else
          pcall->parameters.push(param);
      } while ((tkn = CsToken(c)) == ',');
    }
    require(c, tkn, ')');
    return pcall;
  }

  static void do_$_method_call(CsCompiler *c, PVAL& pv, PVAL pp, bool optional) {
    expr::call_method* pcall = optional
      ? new expr::optional_call_method(c, pv, pp)
      : new expr::call_method(c, pv,pp);
    pv = pcall;

    int bracket_level = 1;

    PVAL param;

    int lastc = scan_stringizer_string(c, bracket_level);

    param = new expr::literal(c, tool::value(c->t_wtoken()));
    pcall->parameters.push(param);

    while (lastc == '{') {
      do_call_param_expr(c, param);
      pcall->parameters.push(param);
      frequire(c, '}');
      lastc = scan_stringizer_string(c, bracket_level);
      param = new expr::literal(c, tool::value(c->t_wtoken()));
      pcall->parameters.push(param);
    }

    if (lastc != ')') CsParseError(c, "expecting ')'");
  }

  /* do_method_call_object - compile a method call expression
     obj.method { prm1: val,prm2: val }
   */
  static handle<expr::call_method> do_method_call_object(CsCompiler *c, PVAL& pv, PVAL psel, bool optional) {

    expr::call_method* pcall = optional
      ? new expr::optional_call_method(c, pv, psel)
      : new expr::call_method(c, pv, psel);

    pv = pcall;

    PVAL param;
    do_literal_obj(c, param);

    pcall->parameters.push(param);
    return pcall;
  }

  /* do_index - compile an indexing operation */
  static void do_index(CsCompiler *c, PVAL& pv) {

    int tkn = CsToken(c);

    PVAL pvi;
    PVAL pvi_end;
    bool range = false;

    if (tkn == T_DOTDOT || tkn == T_DOTDOTDOT) { // [...n] case
      pvi = new expr::literal_code(c, BC_NOTHING);
      range = true;
      do_expr2(c, pvi_end, true);
    }
    else {
      CsSaveToken(c, tkn);
      do_expr2(c, pvi, true);
    }

    tkn = CsToken(c);

    if (tkn == T_DOTDOT || tkn == T_DOTDOTDOT)
    {
      range = true;
      tkn = CsToken(c); CsSaveToken(c, tkn);
      if (tkn == ']')
        pvi_end = new expr::literal_code(c, BC_NOTHING);
      else
        do_expr2(c, pvi_end, true);
    } else
      CsSaveToken(c, tkn);

    if( range )
      pv = new expr::index_range(c, pv,pvi, pvi_end);
    else
      pv = new expr::index(c, pv, pvi);

    frequire(c, ']');

  }

  /* do_symbol_index - compile an indexing by symbol operation:
     foo#bar
   */
  static void do_symbol_index(CsCompiler *c, PVAL& pv) {

    int tkn = CsToken(c);

    if (tkn == T_SYMBOL)
      pv = new expr::index(c, pv, new expr::literal(c, tool::value(c->t_token)));
    else
      // impossible but...
      require(c, tkn, T_SYMBOL);
  }

  static void InjectArgFrame(CsCompiler *c, ATABLE **patable, int *pptr) {
    if (!*patable) {
      /* make a new argument frame */
      *patable = MakeArgFrame(c);

      /* establish the new frame */
      PushArgFrame(c, *patable);

      /* create a new argument frame */
      putcbyte(c, BC_FRAME);
      *pptr = putcbyte(c, 0); // local vars in this frame
      putcword(c, addliteral(c, NOTHING_VALUE,true)); // local vars names, literal no of FixedVector of names

      ++c->blockLevel;
    }
  }

  static bool ArgumentExists(CsCompiler *c, ATABLE *table, const char *name) {
    if (!table) return false;
    ARGUMENT *arg;
    for (arg = table->at_arguments; arg != nullptr; arg = arg->arg_next) {
      if (strcmp(name, arg->arg_name) == 0) { return true; }
    }
    return false;
  }

  static int ArgumentsCount(CsCompiler *c, ATABLE *table) {
    if (!table) return 0;
    ARGUMENT *arg;
    int       cnt = 0;
    for (arg = table->at_arguments; arg != nullptr; arg = arg->arg_next) {
      ++cnt;
    }
    return cnt;
  }

  static bool FindArgument(CsCompiler *c, const char *name, int &plev,
                           int &poff, bool &pimmutable);

  /* AddArgument - add a formal argument */
  static void AddArgument(CsCompiler *c, ATABLE *atable, const char *name,
                          bool immutable) {
    ARGUMENT *arg;
    for (arg = atable->at_arguments; arg != nullptr; arg = arg->arg_next)
      if (strcmp(name, arg->arg_name) == 0)
        CsParseError(c, "Name already defined");
    /*WTF?: if (!atable->at_isFunctionArgs && atable->at_next && atable->at_next->at_isFunctionArgs) { - wrong it is block inside function
      // this is initial arg frame of a function, names here should not shadow function arguments:
      for (arg = atable->at_next->at_arguments; arg != nullptr; arg = arg->arg_next)
        if (strcmp(name, arg->arg_name) == 0)
          CsParseError(c, "Name already defined as function argument");
    }*/

    if ((arg = (ARGUMENT *)CsAlloc(c->ic, sizeof(ARGUMENT))) == nullptr)
      CsInsufficientMemory(c->ic);
    arg->arg_name             = copystring(c, name);
    arg->arg_next             = nullptr;
    arg->immutable            = immutable;
    *atable->at_pNextArgument = arg;
    atable->at_pNextArgument  = &arg->arg_next;
  }

  static value AllocateArgNames(CsCompiler *c, ATABLE *atable, int n) {
    if (n <= 2) return UNDEFINED_VALUE;
    value     argnv = CsMakeTuple(c->ic, n - 2);
    ARGUMENT *arg   = atable->at_arguments;
    for (int cnt = 0; cnt < n; ++cnt, arg = arg->arg_next) {
      if (cnt < 2) continue;
      CsSetTupleElement(argnv, cnt - 2, CsSymbolOf(arg->arg_name));
    }
#ifdef TISCRIPT_DEBUGGER
    CsSetTupleName(argnv, CsSymbolOf(WCHARS("args")));
#endif
    return argnv;
  }

  /* MakeArgFrame - make a new argument frame */
  static ATABLE *MakeArgFrame(CsCompiler *c, bool funcArgs) {
    ATABLE *atable;
    if ((atable = (ATABLE *)CsAlloc(c->ic, sizeof(ATABLE))) == nullptr)
      CsInsufficientMemory(c->ic);
    atable->at_arguments     = nullptr;
    atable->at_pNextArgument = &atable->at_arguments;
    atable->at_next          = nullptr;
    atable->at_isFunctionArgs = funcArgs;
    return atable;
  }

  /* PushArgFrame - push an argument frame onto the stack */
  static void PushArgFrame(CsCompiler *c, ATABLE *atable) {
    atable->at_next = c->arguments;
    c->arguments    = atable;
  }

  /* PushNewArgFrame - push a new argument frame onto the stack */
  static void PushNewArgFrame(CsCompiler *c, bool funcArgs) {
    PushArgFrame(c, MakeArgFrame(c,funcArgs));
  }

  /* PopArgFrame - push an argument frame off the stack */
  static void PopArgFrame(CsCompiler *c) {
    ARGUMENT *arg, *nxt;
    ATABLE *  atable;
    for (arg = c->arguments->at_arguments; arg != nullptr; arg = nxt) {
      nxt = arg->arg_next;
      CsFree(c->ic, arg->arg_name);
      CsFree(c->ic, (char *)arg);
      arg = nxt;
    }
    atable = c->arguments->at_next;
    CsFree(c->ic, (char *)c->arguments);
    c->arguments = atable;
  }

  /* FreeArguments - free all argument frames */
  static void FreeArguments(CsCompiler *c) {
    while (c->arguments)
      PopArgFrame(c);
  }

  /* FindArgument - find an argument offset */
  static bool FindArgument(CsCompiler *c, const char *name, int &plev,
                           int &poff, bool &pimmutable) {
    ATABLE *  table;
    ARGUMENT *arg;
    int       lev, off;
    lev = 0;
    for (table = c->arguments; table != nullptr; table = table->at_next) {
      off = 1;
      for (arg = table->at_arguments; arg != nullptr; arg = arg->arg_next) {
        if (strcmp(name, arg->arg_name) == 0) {
          plev       = lev;
          poff       = off;
          pimmutable = arg->immutable;
          return true;
        }
        ++off;
      }
      ++lev;
    }
    return false;
  }

  static bool FindThis(CsCompiler *c, int &plev, int &poff, int level) {
    ATABLE *  table;
    ARGUMENT *arg;
    int       lev, off;
    lev = 0;
    for (table = c->arguments; table != nullptr; table = table->at_next) {
      off = 1;
      for (arg = table->at_arguments; arg != nullptr; arg = arg->arg_next) {
        if (strcmp("this", arg->arg_name) == 0) {
          if (level-- == 0) {
            plev = lev;
            poff = off;
            return true;
          }
          break; // not at this level, got to the next level
        }
        ++off;
      }
      ++lev;
    }
    return false;
  }

  /* addliteral - add a literal to the literal vector */
  static int addliteral(CsCompiler *c, value lit, bool unique) {
    long p;
#ifdef _DEBUG
    if (lit == NOTHING_VALUE)
      lit = lit;
#endif

    if (!unique)
      for (p = c->lbase + 1; p < c->lptr; ++p) // first literal is a name
                                               // vector, skip it. Note this
                                               // also fixes the case when
                                               // #undefined is used.
        if (CsVectorElement(c->ic, c->literalbuf, p) == lit)
          return (int)(CsFirstLiteral + (p - c->lbase));
    long sz = CsVectorSize(c->ic, c->literalbuf);
    if (c->lptr >= sz) {
      // CsParseError(c,"too many literals");
      CsPush(c->ic, lit);
      c->literalbuf = CsResizeVector(c->ic, c->literalbuf, c->lptr + 1);
      lit           = CsPop(c->ic);
    }
    // if (c->lptr >= c->ltop)
    //    CsParseError(c,"too many literals");
    p = c->lptr++;
    // WRONG will eliminate #nothing : CsSetVectorElement(c->ic, c->literalbuf, p, lit);
    CsVectorAddress(c->ic, c->literalbuf)[p] = lit;
    return (int)(CsFirstLiteral + (p - c->lbase));
  }

  static value getliteral(CsCompiler *c, int idx) {
    return CsVectorElement(c->ic, c->literalbuf,
                           idx - CsFirstLiteral + c->lbase);
  }
  static void setliteral(CsCompiler *c, int idx, value val) {
    CsSetVectorElement(c->ic, c->literalbuf, idx - CsFirstLiteral + c->lbase,
                       val);
  }

  /* frequire - fetch a CsToken and check it */
  static void frequire(CsCompiler *c, int rtkn) {
    require(c, CsToken(c), rtkn);
  }

  /* frequire_or - fetch a CsToken and check it */
  static int frequire_or(CsCompiler *c, int rtkn1, int rtkn2) {
    int tkn = CsToken(c);
    require_or(c, tkn, rtkn1, rtkn2);
    return tkn;
  }
  /* frequire_or - fetch a CsToken and check it */
  static int frequire_or(CsCompiler *c, int rtkn1, int rtkn2, int rtkn3) {
    int tkn = CsToken(c);
    require_or(c, tkn, rtkn1, rtkn2, rtkn3);
    return tkn;
  }

  /* frequire_or - fetch a CsToken and check it */
  static int frequire_or(CsCompiler *c, int rtkn1, int rtkn2, int rtkn3, int rtkn4) {
    int tkn = CsToken(c);
    require_or(c, tkn, rtkn1, rtkn2, rtkn3, rtkn4);
    return tkn;
  }


  /* require - check for a required CsToken */
  static void require(CsCompiler *c, int tkn, int rtkn) {
    char msg[100], tknbuf[100];
    if (tkn != rtkn) {
      strcpy_s(tknbuf, CsTokenName(rtkn));
      sprintf(msg, "Expecting '%s', found '%s'", tknbuf, CsTokenName(tkn));
      CsParseError(c, msg);
    }
  }

  /* require - check for a required CsToken */
  static void require_or(CsCompiler *c, int tkn, int rtkn1, int rtkn2) {
    if (tkn == rtkn1 || tkn == rtkn2) return;

    char msg[100];
    char t1[100];
    char t2[100];
    strncpy(t1, CsTokenName(rtkn1), 100);
    t1[99] = 0;
    strncpy(t2, CsTokenName(rtkn2), 100);
    t2[99] = 0;
    sprintf(msg, "Expecting '%s' or '%s', found '%s'", t1, t2, CsTokenName(tkn));
    CsParseError(c, msg);
  }

  static void require_or(CsCompiler *c, int tkn, int rtkn1, int rtkn2, int rtkn3) {
    if (tkn == rtkn1 || tkn == rtkn2 || tkn == rtkn3) return;

    char msg[100];
    char t1[100];
    char t2[100];
    char t3[100];
    strncpy(t1, CsTokenName(rtkn1), 100);
    t1[99] = 0;
    strncpy(t2, CsTokenName(rtkn2), 100);
    t2[99] = 0;
    strncpy(t3, CsTokenName(rtkn3), 100);
    t3[99] = 0;
    sprintf(msg, "Expecting '%s', '%s' or '%s', found '%s'", t1, t2, t3, CsTokenName(tkn));
    CsParseError(c, msg);
  }

  static void require_or(CsCompiler *c, int tkn, int rtkn1, int rtkn2, int rtkn3,int rtkn4) {
    if (tkn == rtkn1 || tkn == rtkn2 || tkn == rtkn3 || tkn == rtkn4) return;

    char msg[100];
    char t1[101] = {0};
    char t2[101] = { 0 };
    char t3[101] = { 0 };
    char t4[101] = { 0 };
    strncpy(t1, CsTokenName(rtkn1), 100);
    strncpy(t2, CsTokenName(rtkn2), 100);
    strncpy(t3, CsTokenName(rtkn3), 100);
    strncpy(t4, CsTokenName(rtkn3), 100);
    sprintf(msg, "Expecting '%s', '%s', '%s' or '%s', found '%s'", t1, t2, t3, t4, CsTokenName(tkn));
    CsParseError(c, msg);
  }


  /* do_lit_integer - compile a literal integer */
  static void do_lit_integer(CsCompiler *c, int_t n) {
    emit_literal(c, addliteral(c, CsMakeInteger(n)));
  }

  /* do_lit_float - compile a literal float */
  static void do_lit_float(CsCompiler *c, float_t n) {
    emit_literal(c, addliteral(c, CsMakeFloat(n)));
  }

  /* do_lit_string - compile a literal string */
  /*static void do_lit_string(CsCompiler *c,const wchar *str)
  {
      emit_literal(c,make_lit_string(c,str));
  }*/

  /* do_lit_string - compile a literal string */
  static void do_lit_string(CsCompiler *c, tool::wchars str) {
    emit_literal(c, make_lit_string(c, str.start, int(str.length)));
  }

  /* do_lit_symbol - compile a literal symbol */
  static void do_lit_symbol(CsCompiler *c, const char *pname) {
    emit_literal(c, make_lit_symbol(c, pname));
  }

  /* make_lit_string - make a literal string */
  static int make_lit_string(CsCompiler *c, const wchar *str) {
    return addliteral(c, CsMakeCString(c->ic, str));
  }
  static int make_lit_string(CsCompiler *c, const wchar *str, int sz) {
    return addliteral(c, CsMakeCharString(c->ic, str, sz));
  }

  /* make_lit_symbol - make a literal reference to a symbol */
  static int make_lit_symbol(CsCompiler *c, const char *pname) {
    return addliteral(c, CsSymbolOf(pname));
  }

  /* variable_ref - compile a variable reference */
  static void variable_ref(CsCompiler *c, const char *name) {
    PVAL pv;
    findvariable(c, name, pv);
    rvalue(c, pv);
  }

  /* findvariable - find a variable */
  static void findvariable(CsCompiler *c, const char *id, PVAL& pv) {
    int  lev, off;
    bool immutable;
    if (strcmp(id, "true") == 0) {
      pv = new expr::literal_code(c, BC_T);
    } else if (strcmp(id, "false") == 0) {
      pv = new expr::literal_code(c, BC_F);
    } else if (strcmp(id, "null") == 0) {
      pv = new expr::literal_code(c, BC_NULL);
    } else if (strcmp(id, "undefined") == 0) {
      pv = new expr::literal_code(c, BC_UNDEFINED);
    } else if (FindArgument(c, id, lev, off, immutable)) {
      if (immutable)
        pv = new expr::evar_immutable(c, id,lev, off);
      else
        pv = new expr::evar(c, id,lev, off);
    } else {
      assert(strcmp(id, "this") != 0);
      pv = new expr::gvar(c, id, expr::gvar::GLOBAL);
    }
  }


  /* load_argument - compile code to load an argument */
  static bool load_argument(CsCompiler *c, const char *name, PVAL& pv) {
    int  lev, off;
    bool dummy;
    if (!FindArgument(c, name, lev, off, dummy)) return false;
    pv = new expr::evar(c, name, lev, off);
    return true;
  }



  /* code_literal - compile a literal reference */
  static void emit_literal(CsCompiler *c, int n) {
    putcbyte(c, BC_LIT);
    putcword(c, n);
  }

  /* codeaddr - get the current code address (actually, offset) */
  static int codeaddr(CsCompiler *c) { return int(c->cptr - c->cbase); }

  /* putcbyte - put a code byte into the code buffer */
  int putcbyte(CsCompiler *c, int b) {

    int addr = codeaddr(c);
    if (c->cptr >= c->ctop) CsThrowKnownError(c->ic, CsErrTooMuchCode, c);
    if (c->emitLineNumbersP && c->lineNumberChangedP && !c->JSONonly /*do not need line numbers in JSON literals */) {
      c->lineNumberChangedP = false;
      AddLineNumber(c, c->lineNumber, addr);
#ifdef TISCRIPT_DEBUGGER
      *c->cptr++ = BC_LINENO;
      putcword(c, c->lineNumber);
#endif
    }
    *c->cptr++ = byte(b);
    return addr;
  }

  static void putcbytes(CsCompiler *c, bytes data) {
    if (c->cptr + data.length >= c->ctop) CsThrowKnownError(c->ic, CsErrTooMuchCode, c);
    target(c->cptr, data.length).copy(data);
    c->cptr += data.length;
  }

  static void discard_codes(CsCompiler *c, int codeaddr) {
    c->cptr = c->cbase + codeaddr;
  }

  /* putcword - put a code word into the code buffer */
  int putcword(CsCompiler *c, int w) {
    int addr = codeaddr(c);
    if (c->cptr >= c->ctop) CsThrowKnownError(c->ic, CsErrTooMuchCode, c);
    *c->cptr++ = byte(w & 0xFF);
    if (c->cptr >= c->ctop) CsThrowKnownError(c->ic, CsErrTooMuchCode, c);
    *c->cptr++ = byte((w >> 8) & 0xFF);
    return addr;
  }

  /* fixup - fixup a reference chain */
  static int fixup(CsCompiler *c, int chn, int val) {
    int hval, nxt;
    for (hval = val >> 8; chn != NIL; chn = nxt) {
      nxt               = (c->cbase[chn] & 0xFF) | (c->cbase[chn + 1] << 8);
      c->cbase[chn]     = byte(val);
      c->cbase[chn + 1] = byte(hval);
    }
    return val;
  }

  /* AddLineNumber - add a line number entry */
  static void AddLineNumber(CsCompiler *c, int line, int pc) {
    LineNumberBlock *current;
    LineNumberEntry *entry;
    current = c->currentBlock;
    if (!current || current->count >= kLineNumberBlockSize)
      current = AddLineNumberBlock(c);
    entry       = &current->entries[current->count++];
    entry->line = line;
    entry->pc   = pc;
  }

  /* AddLineNumberBlock - add a new block of line numbers */
  static LineNumberBlock *AddLineNumberBlock(CsCompiler *c) {
    LineNumberBlock *current, *block;
    block = (LineNumberBlock *)CsAlloc(c->ic, sizeof(LineNumberBlock));
    if (!block) CsInsufficientMemory(c->ic);
    block->count = 0;
    block->next  = nullptr;
    current      = c->currentBlock;
    if (!current)
      c->lineNumbers = block;
    else
      current->next = block;
    c->currentBlock = block;
    return block;
  }

  /* FreeLineNumbers - free the line number table */
  static void FreeLineNumbers(CsCompiler *c) {
    LineNumberBlock *block, *next;
    for (block = c->lineNumbers; block != nullptr; block = next) {
      next = block->next;
      CsFree(c->ic, block);
    }
    c->lineNumbers = c->currentBlock = nullptr;
  }

  /* DumpLineNumbers - dump the line number table */
  static void DumpLineNumbers(CsCompiler *c) {
    LineNumberBlock *block;
    for (block = c->lineNumbers; block != nullptr; block = block->next) {
      int i;
      for (i = 0; i < block->count; ++i) {
        LineNumberEntry *entry = &block->entries[i];
        printf("  %d %04x\n", entry->line, entry->pc);
      }
    }
  }

  /* CountLineNumberEntries - return number of entries in line number table */
  static value AllocateLineNumbers(CsCompiler *c) {
    int              cnt = 0;
    LineNumberBlock *block;
    for (block = c->lineNumbers; block != nullptr; block = block->next)
      cnt += block->count;
    if (cnt == 0) return UNDEFINED_VALUE;

    value buf = CsMakeByteVector(c->ic, 0, cnt * sizeof(LineNumberEntry));

    LineNumberEntry *dst = (LineNumberEntry *)CsByteVectorAddress(buf);

    for (block = c->lineNumbers; block != nullptr; block = block->next) {
      for (int i = 0; i < block->count; ++i, ++dst) {
        *dst = block->entries[i];
      }
    }
    return buf;
  }

  extern void BinaryOp(VM *c, int op);

  /*static int fold_const(CsCompiler *c, int op, PVAL *left, PVAL *right) {
    value lv = getliteral(c, left->val);
    value rv = getliteral(c, right->val);
    return addliteral(c, CsBinaryOp(c->ic, op, lv, rv));
  }*/

  /* copystring - make a copy of a string */
  static char *copystring(CsCompiler *c, const char *str) {
    size_t len = strlen(str);
    char * ns  = (char *)CsAlloc(c->ic, (unsigned long)len + 1);
    if (ns == nullptr) CsInsufficientMemory(c->ic);
#ifdef WINDOWS
    strcpy_s(ns, len + 1, str);
#else
    strcpy(ns, str);
#endif
    return ns;
  }



  static void Optimize(CsCompiler *c, value bytecodes) {
    // JumpToJumpOpt(c, bytecodes);
    // PeepholeOpt(c, bytecodes);
  }

  namespace expr {

    void binary::do_fetch(CsCompiler *c) {
      if (folded.is_undefined()) {
        tool::value r;
        if (folded = fold(r))
          left = new literal(c, r);
      }
      left->do_fetch(c);
      if (!folded) {
        putcbyte(c, BC_PUSH_VALUE);
        right->do_fetch(c);
        putcbyte(c, code);
      }
    }

    bool binary::fold(tool::value& res) const {
      tool::value l, r;
      if (!left->fold(l)) return false;
      if (!right->fold(r)) return false;

      switch (code) {
      case BC_ADD: return tool::arithm::try_add(l, r, res);
      case BC_SUB: return tool::arithm::try_sub(l, r, res);
      case BC_MUL: return tool::arithm::try_mul(l, r, res);
      case BC_DIV: return tool::arithm::try_div(l, r, res);
      case BC_REM: return tool::arithm::try_mod(l, r, res);
      case BC_BAND: return tool::arithm::try_band(l, r, res);
      case BC_BOR: return tool::arithm::try_bor(l, r, res);
      case BC_XOR: return tool::arithm::try_bxor(l, r, res);
      case BC_USHL: return tool::arithm::try_lshift(l, r, res);
      case BC_USHR: return tool::arithm::try_rshift(l, r, res);

      case BC_EQ: return tool::arithm::try_eq(l, r, res);
      case BC_NE: return tool::arithm::try_ne(l, r, res);
      case BC_GT: return tool::arithm::try_gt(l, r, res);
      case BC_GE: return tool::arithm::try_ge(l, r, res);
      case BC_LT: return tool::arithm::try_lt(l, r, res);
      case BC_LE: return tool::arithm::try_le(l, r, res);
      default: return false;
      }
    }

    void unary::do_fetch(CsCompiler *c) {
      if (folded.is_undefined()) {
        tool::value r;
        if (folded = fold(r)) {
          right = new expr::literal(right, r);
        }
      }
      if (code == BC_NOTHING) {
        if (!folded)
          right->do_fetch(c);
        putcbyte(c, code);
      }
      else {
        right->do_fetch(c);
        if (!folded)
          putcbyte(c, code);
      }
    }

    bool unary::fold(tool::value& res) const {
      tool::value r;
      if (!right->fold(r)) return false;
      switch (code) {
      case BC_NEG: return tool::arithm::try_neg(r, res);
      case BC_BNOT: return tool::arithm::try_bnot(r, res);
      case BC_NOT: return tool::arithm::try_not(r, res);
        //case BC_NOTHING: return true;
      default: return false;
      }
    }

    bool logical_or::fold(tool::value& res) const {
      tool::value l, r;
      if (!left->fold(l)) return false;
      if (!right->fold(r)) return false;
      return tool::arithm::try_or(l, r, res);
    }

    bool logical_and::fold(tool::value& res) const {
      tool::value l, r;
      if (!left->fold(l)) return false;
      if (!right->fold(r)) return false;
      return tool::arithm::try_and(l, r, res);
    }

    void index::do_fetch(CsCompiler *c) {
      coll->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);
      idx->do_fetch(c);
      putcbyte(c, BC_VREF);
    }

    void index::do_store(CsCompiler *c) {
      CsParseError(c, "incompatible yet");
    }

    void index::do_assign(CsCompiler *c, node* r) {
      coll->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);
      idx->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);
      r->do_fetch(c);
      putcbyte(c, BC_VSET);
    }

    void index::do_increment(CsCompiler *c, byte code, node* r) {
      coll->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);
      idx->do_fetch(c);
      putcbyte(c, BC_DUP2);
      putcbyte(c, BC_VREF);
      if (r) {
        putcbyte(c, BC_PUSH_VALUE);
        r->do_fetch(c);
      }
      putcbyte(c, code);
      putcbyte(c, BC_VSET);
    }

    void index::do_delete(CsCompiler *c) {
      coll->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);
      idx->do_fetch(c);
      putcbyte(c, BC_VDEL);
    }

    void property::do_fetch(CsCompiler *c) {
      coll->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);
      prop->do_fetch(c);
      putcbyte(c, BC_GETP);
    }

    void property::do_store(CsCompiler *c) {
      CsParseError(c, this, "incompatible yet");
    }

    void property::do_assign(CsCompiler *c, node* r) {
      coll->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);
      prop->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);
      r->do_fetch(c);
      putcbyte(c, BC_SETP);
    }

    void property::do_increment(CsCompiler *c, byte code, node* r) {
      coll->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);
      prop->do_fetch(c);
      putcbyte(c, BC_DUP2);
      putcbyte(c, BC_GETP);
      if (r) {
        putcbyte(c, BC_PUSH_VALUE);
        r->do_fetch(c);
      }
      putcbyte(c, code);
      putcbyte(c, BC_SETP);
    }

    void property::do_delete(CsCompiler *c) {
      coll->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);
      prop->do_fetch(c);
      putcbyte(c, BC_DELP);
    }

    void optional_property::do_fetch(CsCompiler *c) {

      bool optional_root = false;

      //auto_state<int_v> _(c->optionalPropSequenceEnd, int_v());

      if (c->optionalPropSequenceEnd.is_undefined()) {
        c->optionalPropSequenceEnd = 0;
        optional_root = true;
      }

      coll->do_fetch(c);

      putcbyte(c, BC_BR_UNDEFINED);
      c->optionalPropSequenceEnd = putcword(c, c->optionalPropSequenceEnd);

      putcbyte(c, BC_PUSH_VALUE);
      prop->do_fetch(c);
      putcbyte(c, BC_GETP);

      putcbyte(c, BC_BR_UNDEFINED);
      c->optionalPropSequenceEnd = putcword(c, c->optionalPropSequenceEnd);

      if (optional_root) {
        fixup(c, c->optionalPropSequenceEnd, codeaddr(c));
        c->optionalPropSequenceEnd.clear();
      }
    }

    void optional_call_method::do_fetch(CsCompiler *c) {

      bool optional_root = false;

      if (c->optionalPropSequenceEnd.is_undefined()) {
        c->optionalPropSequenceEnd = 0;
        optional_root = true;
      }

      coll->do_fetch(c);

      putcbyte(c, BC_BR_UNDEFINED);
      c->optionalPropSequenceEnd = putcword(c, c->optionalPropSequenceEnd);

      putcbyte(c, BC_PUSH_VALUE); putcbyte(c, BC_PUSH_VALUE);
      prop->do_fetch(c);
      putcbyte(c, BC_GETP);

      putcbyte(c, BC_BR_UNDEFINED);
      c->optionalPropSequenceEnd = putcword(c, c->optionalPropSequenceEnd);

      putcbyte(c, BC_PUSH_VALUE);
      putcbyte(c, BC_OVER);

      do_fetch_nopreambula(c);

      if (optional_root) {
        fixup(c, c->optionalPropSequenceEnd, codeaddr(c));
        c->optionalPropSequenceEnd.clear();
      }

    }


    void optional_fallback::do_fetch(CsCompiler *c) {

      bool optional_root = false;

      assert(c->optionalPropSequenceEnd.is_undefined());

      if (c->optionalPropSequenceEnd.is_undefined()) {
        c->optionalPropSequenceEnd = 0;
        optional_root = true;
      }

      optional->do_fetch(c);

      if (c->optionalPropSequenceEnd == 0) { // case foo ?? 42; - fallback to undefined
        putcbyte(c, BC_BR_UNDEFINED);
        c->optionalPropSequenceEnd = putcword(c, c->optionalPropSequenceEnd);
      }

      if (optional_root) {
        putcbyte(c, BC_BR); // jump straight over the fallback retreival code
        int end = putcword(c, NIL);
        fixup(c, c->optionalPropSequenceEnd, codeaddr(c));
        fallback->do_fetch(c); // putcbyte(c, BC_UNDEFINED);
        fixup(c, end, codeaddr(c));
        c->optionalPropSequenceEnd.clear();
      }
    }


    void list::do_fetch(CsCompiler *c) {
      switch (type) {
      case VARS: return do_fetch_vars(c);
      case VECTOR: return do_fetch_vector(c);
      case MAP: return do_fetch_map(c);
      case EXPRESSIONS: return do_fetch_expressions(c);
      }
    }
    void list::do_fetch_vars(CsCompiler *c) {
      for (auto node : elements) {
        node->do_fetch(c);
        putcbyte(c, BC_PUSH_VALUE);
      }
      putcbyte(c, BC_LIST_RVALS);
      putcword(c, elements.size());
    }
    void list::do_fetch_map(CsCompiler *c) {
      variable_ref(c, "Object");
      putcbyte(c, BC_NEWOBJECT);
      putcbyte(c, 0); // new object without ctor
      if (elements.size() == 0) return;
      putcbyte(c, BC_PUSH_VALUE);
      for (auto item : elements) {
        if (item->is_of_type<expr::pair>()) {
          putcbyte(c, BC_DUP);
          item.ptr_of<expr::pair>()->name->do_fetch(c);
          putcbyte(c, BC_PUSH_VALUE);
          item.ptr_of<expr::pair>()->val->do_fetch(c);
        }
        else if (item->is_rest()) {
          item.ptr_of<expr::rest>()->principal->do_fetch_root(c);
          putcbyte(c, BC_EXTEND_TOP_MAP);
          continue;
        }
        else {
          putcbyte(c, BC_DUP);
          string name = item->source_name(c);
          do_lit_symbol(c, name);
          putcbyte(c, BC_PUSH_VALUE);
          item->do_fetch(c);
          //putcbyte(c, BC_UNDEFINED);
        }
        putcbyte(c, BC_SETPM); // set this member ignoring virtual properties.
      }
      putcbyte(c, BC_DROP);

    }
    void list::do_fetch_vector(CsCompiler *c) {

      if (tag) {
        tag->do_fetch(c);
        putcbyte(c, BC_PUSH_VALUE);
      }
      if (tag)
        putcbyte(c, BC_NEWTUPLE);
      else
        putcbyte(c, BC_NEWVECTOR);
      putcword(c, elements.size());

      putcbyte(c, BC_PUSH_VALUE);
      for (int n = elements.last_index(); n >= 0; --n) {
        node* pn = elements[n];
        pn->do_fetch_root(c);
        if (tag) {
          if (pn->is_rest())
            putcbyte(c, BC_TSET_TOP_NTH_ELEMENT_SPREAD);
          else
            putcbyte(c, BC_TSET_TOP_NTH_ELEMENT);
        }
        else {
          if (pn->is_rest())
            putcbyte(c, BC_VSET_TOP_NTH_ELEMENT_SPREAD);
          else
            putcbyte(c, BC_VSET_TOP_NTH_ELEMENT);
        }
        putcword(c, n);
      }
      putcbyte(c, BC_DROP);
    }

    void list::do_fetch_expressions(CsCompiler *c) {
      for (auto node : elements)
        node->do_fetch(c);
    }

    void list::do_assign(CsCompiler *c, node* r)
    {
      r->do_fetch(c);
      do_store(c);
    }

    void list::do_store(CsCompiler *c)
    {
      switch (type) {
      case VARS: return do_store_vars(c);
      case VECTOR: return do_store_vector(c);
      case MAP: return do_store_map(c);
      }
    }

    void list::do_store_vars(CsCompiler *c) {
      putcbyte(c, BC_PUSH); // must be BC_PUSH but not BC_PUSH_VALUE
      for (int n = 0; n < elements.size(); ++n) {
        expr::node* pn = elements[n];
        pn->do_fetch_initial(c);
        putcbyte(c, BC_GET_RVAL);
        putcbyte(c, n);
        pn->do_store(c);
      }
      putcbyte(c, BC_DROP);
    }
    void list::do_store_vector(CsCompiler *c) {
      putcbyte(c, BC_PUSH_VALUE);
      for (int n = 0; n < elements.size(); ++n) {
        expr::node* pn = elements[n];
        pn->do_fetch_initial(c);
        if (pn->is_rest())
          putcbyte(c, BC_GET_TOP_VECTOR_REST_ELEMENTS);
        else
          putcbyte(c, BC_GET_TOP_VECTOR_ELEMENT);
        putcbyte(c, n);
        do_store_if_defined(c, pn);
        //pn->do_store_only(c);
      }
      putcbyte(c, BC_DROP);
    }
    void list::do_store_map(CsCompiler *c) {
      putcbyte(c, BC_PUSH_VALUE);
      for (int n = 0; n < elements.size(); ++n) {
        expr::node* pn = elements[n];
        if (pn->is_rest()) {
          putcbyte(c, BC_CLONE_TOP_MAP_EXCEPT);
          putcbyte(c, elements.size() - 1);
          for (int i = 0; i < elements.size(); ++i)
            if (elements[i] != pn) {
              string sname = elements[i]->source_name(c);
              putcword(c, addliteral(c, CsSymbolOf(sname())));
            }
        }
        else {
          pn->do_fetch_initial(c);
          putcbyte(c, BC_GET_TOP_MAP_ELEMENT);
          string sname = pn->source_name(c);
          putcword(c, addliteral(c, CsSymbolOf(sname())));
        }
        do_store_if_defined(c, pn);
        //pn->do_store_only(c);

      }
      putcbyte(c, BC_DROP);
    }

    handle<node> node::stringify(CsCompiler *c)
    {
      return new expr::unary(c, BC_STRINGIFY, this);
    }

    void list::stringify_vector(CsCompiler *c) {
      if (tag) { // tuple (vdom)
        for (int n = min(1, elements.last_index()); n >= 0; --n) // don't stringify states
          elements[n]->stringify(c);
      }
      else
        for (int n = elements.last_index(); n >= 0; --n) {
          handle<node> pn = elements[n];
          elements[n] = pn->stringify(c);
        }
    }

    void list::stringify_map(CsCompiler *c) {
      for (int n = elements.last_index(); n >= 0; --n) {
        elements[n]->stringify(c);
      }
    }


    void pair::do_fetch_initial(CsCompiler *c) {
      if (val->is_var_ref())
      {
        val->do_fetch_initial(c);
      }
      else {
        string tname = target_name(c);
        PVAL pvn;
        findvariable(c, tname, pvn);
        pvn->do_fetch_initial(c);
      }
    }

    void pair::do_fetch(CsCompiler *c) {
      if (val->is_var_ref())
      {
        val->do_fetch(c);
      }
      else {
        string tname = target_name(c);
        PVAL pvn;
        findvariable(c, tname, pvn);
        pvn->do_fetch(c);
      }
    }
    void pair::do_store(CsCompiler *c) {
      if (val->is_var_ref())
      {
        val->do_store(c);
      }
      else {
        string tname = target_name(c);
        PVAL pvn;
        findvariable(c, tname, pvn);
        pvn->do_store(c);
      }
    }

    string pair::source_name(CsCompiler *c) const {
      if (name->is_of_type<literal>()) {
        //value vname = getliteral(c, name.ptr_of<literal>()->lindex);
        //return value_to_string(vname);
        return name->source_name(c);
      }
      else {
        CsParseError(c, this, "Expecting name");
        return string();
      }
    }
    string pair::target_name(CsCompiler *c) const {
      if (val->is_of_type<literal>()) {
        //value vname = getliteral(c, val.ptr_of<literal>()->lindex);
        //return value_to_string(vname);
        return val->source_name(c);
      }
      else if (name->is_of_type<literal>()) {
        //value vname = getliteral(c, name.ptr_of<literal>()->lindex);
        //return value_to_string(vname);
        return name->source_name(c);
      }
      else {
        CsParseError(c, "Expecting name of variable");
        return string();
      }
    }

    void ternary::do_fetch(CsCompiler *c) {
      cond->do_fetch(c);
      putcbyte(c, BC_BRF);
      int nxt = putcword(c, NIL);
      truthy->do_fetch(c);
      putcbyte(c, BC_BR);
      int end = putcword(c, NIL);
      fixup(c, nxt, codeaddr(c));
      falsy->do_fetch(c);
      fixup(c, end, codeaddr(c));
    }

    void logical_or::do_fetch(CsCompiler *c) {
      int end = 0;
      left->do_fetch(c);
      putcbyte(c, BC_BRT);
      int nxt = putcword(c, end);
      right->do_fetch(c);
      end = nxt;
      fixup(c, end, codeaddr(c));
    }

    void logical_and::do_fetch(CsCompiler *c) {
      int end = 0;
      left->do_fetch(c);
      putcbyte(c, BC_BRF);
      int nxt = putcword(c, end);
      right->do_fetch(c);
      end = nxt;
      fixup(c, end, codeaddr(c));
    }

    void bytecodes::do_fetch(CsCompiler *c) {
      putcbytes(c, data());
    }

    int literal::literal_index(CsCompiler *c) {
      if (lindex.is_undefined()) {
        value val = value_to_value(c->ic, lval);
        lindex = addliteral(c, val);
      }
      return lindex;
    }


    void literal_regexp::do_fetch(CsCompiler *c) {
      variable_ref(c, "RegExp");
      putcbyte(c, BC_NEWOBJECT);
      putcbyte(c, 1); // newobject with ctor call preparation

      emit_literal(c, addliteral(c, CsSymbolOf(re)));
      putcbyte(c, BC_PUSH_VALUE);
      emit_literal(c, addliteral(c, CsSymbolOf(flags)));
      putcbyte(c, BC_PUSH_VALUE);

      putcbyte(c, BC_SEND);
      putcbyte(c, 4);

      putcbyte(c, BC_DROP);
    }

    void index_range::do_fetch(CsCompiler *c) {
      coll->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);
      start->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);
      end->do_fetch(c);
      putcbyte(c, BC_GETRANGE);
    }

    void call::do_fetch(CsCompiler *c) {

      // get the value of the function
      funcref->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);
      putcbyte(c, BC_PUSHSCOPE);

      bool spreads = false;

      for (auto param : parameters) {
        param->do_fetch(c);
        if (param->is_rest()) {
          putcbyte(c, BC_SPREAD);
          spreads = true;
        }
        putcbyte(c, BC_PUSH_VALUE);
      }
      if (spreads)
        putcbyte(c, BC_CALL_WITH_SPREADS);
      else
        putcbyte(c, BC_CALL);
      putcbyte(c, parameters.size() + 2);
    }


    void call_method::do_fetch(CsCompiler *c) {

      coll->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);
      prop->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);
      putcbyte(c, BC_OVER);

      do_fetch_nopreambula(c);
    }


    void call_method::do_fetch_nopreambula(CsCompiler *c) {
      bool spreads = false;
      for (auto param : parameters) {
        param->do_fetch(c);
        if (param->is_rest()) {
          putcbyte(c, BC_SPREAD);
          spreads = true;
        }
        putcbyte(c, BC_PUSH_VALUE);
      }
      if (spreads)
        putcbyte(c, BC_SEND_WITH_SPREADS);
      else
        putcbyte(c, BC_SEND);
      putcbyte(c, parameters.size() + 2);
    }

    void call_method_super::do_fetch(CsCompiler *c) {

      _this->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);

      prop->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);

      _next->do_fetch(c);
      putcbyte(c, BC_PUSH_VALUE);

      do_fetch_nopreambula(c);
    }


    void new_object::do_fetch(CsCompiler *c)
    {
      clas->do_fetch(c);
      /* create the new obj */
      putcbyte(c, BC_NEWOBJECT);
      putcbyte(c, 1); // newobject with ctor call preparation:

                      // sp[3] - obj
                      // sp[2] - obj
                      // sp[1] - #this
                      // sp[0] - class

      call->do_fetch_nopreambula(c);

      // ignore ret value from ctor
      putcbyte(c, BC_DROP);

    }

    int gvar::symbol_index(CsCompiler *c) {
      if (s_index.is_undefined())
        s_index = make_lit_symbol(c, name);
      return s_index;
    }

    /*void ssx_vnode_factory::do_fetch(CsCompiler *c)
    {
      states->do_fetch(c); putcbyte(c, BC_PUSH);
      kids->do_fetch(c); putcbyte(c, BC_PUSH);
      atts->do_fetch(c); putcbyte(c, BC_PUSH);
      fact->do_fetch(c);
      putcbyte(c, BC_VNODE_FACTORY);
    }*/

  } // namespace expr

  extern char scan_ssx_text(CsCompiler *c);

  // TSX stuff - JSX alike thing
  void do_ssx(CsCompiler *c, PVAL& pv, bool root) {
    // caller consumed `<`

    auto gather_tag_name = [=]() -> string {
      int tkn = CsToken(c, true);
      require(c, tkn, T_SYMBOL);

      string tagname = c->t_token;

      if (to_lower(c->t_token[0]) == c->t_token[0])
        return tagname; // lovercase tagname - standard tag name

      while (tkn) {
        tkn = CsToken(c, true);
        if (tkn != '.') {
          CsSaveToken(c, tkn);
          break;
        }
        tkn = CsToken(c, true);
        require(c, T_SYMBOL, tkn);

        tagname += CHARS(".");
        tagname += c->t_token;
      }
      return tagname;
    };

    /*auto check_element_ref_nodes = [c](expr::node* vn) {
      if (vn->is_of_type<expr::evar_immutable>())
        static_cast<expr::evar*>(vn)->level += 1;
      else if (vn->is_of_type<expr::gvar>())
        static_cast<expr::gvar*>(vn)->s_index.clear();
    };*/

    string tagname = gather_tag_name();

    handle<expr::list> atts;
    handle<expr::list> children;
    handle<expr::list> states;

    auto add_child = [&](expr::node* pn) {
      if (!children)
        children = new expr::list(c, expr::list::VECTOR, false);
      children->elements.push(pn);
    };

    // tag head:
    //   <div attr1="val" attr1={expr} > or
    //   <div attr1="val" attr1={expr} /> or
    //   <div attr1="val" {expr} /> or
    // extra sciter specific rules:
    //   <div(attr1) /> - div name="attr1"
    //   <div|attr1 /> - div type="attr1"
    //   <div.n1.n2 /> - div class="n1 n2"
    int tkn;

    ustring class_attr;

    for (;;) {
      tkn = CsToken(c, true);
      if (tkn == '/') {
        frequire(c, '>');
        goto DONE; // done, empty tag
      }
      else if (tkn == '>')
        break;

      if (!atts)
        atts = new expr::list(c, expr::list::MAP, false);

      if (c->firstTokenChar == '#') {
        handle<expr::pair> nv = new expr::pair(c,
          new expr::literal(c, tool::value(CHARS("id"))),
          new expr::literal(c, tool::value(ustring(c->t_token))));
        atts->elements.push(nv);
        continue;
      }

      if (tkn == '{') { // case <div attr1="val" {expr} /> - expression instead of attr=val pair
        PVAL ae;
        do_expr2(c, ae, false);
        frequire(c, '}');
        atts->elements.push(new expr::rest(c,ae));
        continue;
      }

      if (tkn == '(') {
        tkn = CsToken(c, true);
        require(c, tkn, T_SYMBOL);
        handle<expr::pair> nv = new expr::pair(c,
          new expr::literal(c, tool::value(CHARS("name"))),
          new expr::literal(c, tool::value(ustring(c->t_token))));
        atts->elements.push(nv);
        frequire(c, ')');
        continue;
      }
      if (tkn == '|') {
        tkn = CsToken(c, true);
        require(c, tkn, T_SYMBOL);
        handle<expr::pair> nv = new expr::pair(c,
          new expr::literal(c, tool::value(CHARS("type"))),
          new expr::literal(c, tool::value(ustring(c->t_token))));
        atts->elements.push(nv);
        continue;
      }
      if (tkn == '.') {
        tkn = CsToken(c, true);
        require(c, tkn, T_SYMBOL);
        if (class_attr.length()) class_attr += WCHARS(" ");
        class_attr += ustring(c->t_token);
        continue;
      }

      bool is_state = false;

      if (tkn == ':') {
        tkn = CsToken(c, true);
        is_state = true;
        if (!states)
          states = new expr::list(c, expr::list::MAP, false);
      }
      else if (tkn == T_SYMBOL && chars_of(c->t_token) == CHARS("@")) {
        // compile
        is_state = true;
        frequire(c, '{');
        handle<expr::evar> src = new expr::evar(c,CHARS("@"),0,3);
        PVAL fcn = src;

        auto tranformer = [c](PVAL& expr) {
          if (expr->is_lvalue() && !expr->is_assignment()) { 
            // to handle @{this.span} case
            PVAL at;
            findvariable(c, "@", at);
            expr = new expr::assignment(c, expr, at);
          }
          // else (something that is not strictly lvalue) like @{ @.data = [1,2,3] }
          // - do not need any transformations
        };
        do_fat_arrow(c, fcn, tranformer);
        if (!states)
          states = new expr::list(c, expr::list::MAP, false);
        states->elements.push(new expr::pair(c, new expr::literal(c, tool::value(CHARS("@"))), fcn));

        frequire(c, '}');
        continue;
      }

      require(c, tkn, T_SYMBOL);
      string attrname = c->t_token;

      //bool is_event_name = attrname().starts_with(CHARS("on-"));

      handle<expr::pair> nv = new expr::pair(c,
        new expr::literal(c, tool::value(attrname)),
        new expr::literal(c, tool::value(wchars())));

      tkn = CsToken(c, true);
      if (tkn == '=') {
        tkn = CsToken(c, true);
        if (is_state)
          switch (tkn) {
            case T_STRING:
            case '{':
            case T_INTEGER:
            case T_FLOAT:
            case T_LENGTH:
            case T_ANGLE:
            case T_DURATION:
            case T_SYMBOL:
              break;
            default:
              CsParseError(c, "bad state value");
          }
        else
          require_or(c, tkn, T_STRING, '{');
        if (tkn == T_STRING) {
          nv->val = new expr::literal(c, tool::value(c->t_wtoken()));
          if (is_state)
            states->elements.push(nv);
          else
            atts->elements.push(nv);
        }
        /*else if (is_event_name) {
          // event handler
          PVAL ee;
          do_expr2(c, ee, false);
          nv->val = ee;
          atts->elements.push(nv);
          frequire(c, '}');
        }*/
        else if (tkn == '{') {
          PVAL ae;
          do_expr2(c, ae, false);
          if (!is_state && (attrname == CHARS("src") || attrname == CHARS("href")))
            nv->val = new expr::call_method(c, ae, new expr::literal(c, tool::value(CHARS("toUrlString"))));
          else
            nv->val = ae;
          if (is_state)
            states->elements.push(nv);
          else
            atts->elements.push(nv);
          frequire(c, '}');
        }
        else if (is_state) {
          CsSaveToken(c, tkn);
          PVAL se;
          do_primary(c, se);
          nv->val = se;
          states->elements.push(nv);
        }
      }
      else {
        if (is_state)
          states->elements.push(nv);
        else
          atts->elements.push(nv);
        CsSaveToken(c, tkn);
      }
    }

    for (;;) {
      scan_ssx_text(c);
      wchars text = c->t_wtoken();
      if (trim(text).length)
        add_child(new expr::literal(c, tool::value(text)));
      int tok = CsToken(c, true);
      if (tok == T_TAIL_TAG_START) {
        string tail_tagname = gather_tag_name();
        //frequire(c, T_IDENTIFIER);
        if (tagname != tail_tagname)
          CsParseError(c, string::format("tag <%s> is not closed, </%s> was seen instead", tagname.c_str(), tail_tagname.c_str()));
        frequire(c, '>');
        break;
      }
      else if (tok == '{') {
        PVAL child;
        do_expr2(c, child, false);
        child = new expr::rest(c, child);
        add_child(child);
        frequire(c, '}');
      }
      else if (tok == '<')
      {
        PVAL child;
        do_ssx(c, child);
        add_child(child);
      }
    }
  DONE:

    if (class_attr.length()) {
      handle<expr::pair> nv = new expr::pair(c,
        new expr::literal(c, tool::value(CHARS("class"))),
        new expr::literal(c, tool::value(class_attr)));
      atts->elements.push(nv);
    }

#if 0
    // JSX calling convention
    if (tagname().contains('.') ||        //<Namespace.Function title = "..." / >
      to_upper(tagname[0]) == tagname[0]) // or <Dialog title="..." />
    {
      chars tn = tagname();
      string nm = tn.chop('.');
      findvariable(c, nm, pv);
      while (tn) {
        nm = tn.chop('.');
        pv = new expr::property(c, pv, new expr::literal(c, tool::value(nm)));
      }

      handle<expr::node> used_atts;
      if(atts)
        used_atts = atts;
      else
        used_atts = new expr::literal_code(c, BC_NULL);

      handle<expr::node> used_children;
      if(children)
        used_children = children;
      else
        used_children = new expr::literal_code(c, BC_NULL);

      handle<expr::node> used_states;
      if(states)
        used_states = states;
      else
        used_states = new expr::literal_code(c, BC_NULL);

      handle<expr::ssx_vnode_factory> factory = new expr::ssx_vnode_factory(c, pv,
        used_atts,
        used_children,
        used_states );

      pv = factory;
    }
    else 
#endif
    { // <dialog title="..." />
      handle<expr::list> eltuple = new expr::list(c, expr::list::VECTOR, false);

      bool needs_stringify = false;

      if (tagname().contains('.') ||        //<Namespace.Function title = "..." / >
        to_upper(tagname[0]) == tagname[0]) // or <Dialog title="..." />
      {
        chars tn = tagname();
        string nm = tn.chop('.');
        findvariable(c, nm, pv);
        while (tn) {
          nm = tn.chop('.');
          pv = new expr::property(c, pv, new expr::literal(c, tool::value(nm)));
        }
        eltuple->tag = pv;
      }
      else {
        eltuple->tag = new expr::literal(c, tool::value(tagname));
        needs_stringify = true;
      }
      
      if (atts) {
        //if(needs_stringify)
        //  atts->stringify(c);
        eltuple->elements.push(atts);
      }
      else
        eltuple->elements.push(new expr::literal_code(c, BC_NULL));
      if (children) {
        //if (needs_stringify)
        //  children->stringify(c);
        eltuple->elements.push(children);
      }
      else
        eltuple->elements.push(new expr::literal_code(c, BC_NULL));
      if (states)
        eltuple->elements.push(states);
      //else
      //  eltuple->elements.push(new expr::literal_code(c, BC_NULL));
      pv = eltuple;
    }
  }

} // namespace tis
