// maindlg.h : interface of the CMainDlg class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINDLG_H__BC18EE0D_3E2E_45A7_B8A3_B594A4D2A545__INCLUDED_)
#define AFX_MAINDLG_H__BC18EE0D_3E2E_45A7_B8A3_B594A4D2A545__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CMainDlg;

extern void InitDialogClass(tiscript::env &x, CMainDlg *pinst);
extern void LoadScript(tiscript::env &x);
extern void NotifyMove(CMainDlg *pinst, int l, int t, int w, int h);

class CMainDlg : public CDialogImpl<CMainDlg>,
                 public CUpdateUI<CMainDlg>,
                 public CMessageFilter,
                 public CIdleHandler {
public:
  tiscript::pinned expando;

  CMainDlg() : expando(script_engine) {}

  enum { IDD = IDD_MAINDLG };

  virtual BOOL PreTranslateMessage(MSG *pMsg) {
    return CWindow::IsDialogMessage(pMsg);
  }

  virtual BOOL OnIdle() { return FALSE; }

  std::wstring GetCaption() {
    WCHAR buf[512];
    GetWindowText(buf, 512);
    return buf;
  }
  void SetCaption(const std::wstring &text) { SetWindowText(text.c_str()); }

  std::wstring GetText() {
    WCHAR buf[512];
    GetDlgItemText(IDC_TEXT, buf, 512);
    return buf;
  }
  void SetText(const std::wstring &text) {
    SetDlgItemText(IDC_TEXT, text.c_str());
  }

  BEGIN_UPDATE_UI_MAP(CMainDlg)
  END_UPDATE_UI_MAP()

  BEGIN_MSG_MAP(CMainDlg)
  MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
  MESSAGE_HANDLER(WM_SIZE, OnMove)
  MESSAGE_HANDLER(WM_MOVE, OnMove)
  COMMAND_ID_HANDLER(ID_APP_ABOUT, OnAppAbout)
  COMMAND_ID_HANDLER(IDOK, OnOK)
  COMMAND_ID_HANDLER(IDCANCEL, OnCancel)
  END_MSG_MAP()

  // Handler prototypes (uncomment arguments if needed):
  //  LRESULT MessageHandler(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM
  //  /*lParam*/, BOOL& /*bHandled*/) LRESULT CommandHandler(WORD
  //  /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
  //  LRESULT NotifyHandler(int /*idCtrl*/, LPNMHDR /*pnmh*/, BOOL&
  //  /*bHandled*/)

  LRESULT OnInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/,
                       BOOL & /*bHandled*/) {
    // center the dialog on the screen
    CenterWindow();

    // set icons
    HICON hIcon = (HICON)::LoadImage(
        _Module.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME),
        IMAGE_ICON, ::GetSystemMetrics(SM_CXICON),
        ::GetSystemMetrics(SM_CYICON), LR_DEFAULTCOLOR);
    SetIcon(hIcon, TRUE);
    HICON hIconSmall = (HICON)::LoadImage(
        _Module.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME),
        IMAGE_ICON, ::GetSystemMetrics(SM_CXSMICON),
        ::GetSystemMetrics(SM_CYSMICON), LR_DEFAULTCOLOR);
    SetIcon(hIconSmall, FALSE);

    // register object for message filtering and idle updates
    CMessageLoop *pLoop = _Module.GetMessageLoop();
    ATLASSERT(pLoop != NULL);
    pLoop->AddMessageFilter(this);
    pLoop->AddIdleHandler(this);

    UIAddChildWindowContainer(m_hWnd);

    InitDialogClass(script_engine, this);
    LoadScript(script_engine);

    return TRUE;
  }

  LRESULT OnMove(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/,
                 BOOL & /*bHandled*/) {
    RECT r;
    GetWindowRect(&r);
    NotifyMove(this, r.left, r.top, r.right - r.left, r.bottom - r.top);
    return 0;
  }

  LRESULT OnAppAbout(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/,
                     BOOL & /*bHandled*/) {
    CAboutDlg dlg;
    dlg.DoModal();
    return 0;
  }

  LRESULT OnOK(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/,
               BOOL & /*bHandled*/) {
    CloseDialog(wID);
    return 0;
  }

  LRESULT OnCancel(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/,
                   BOOL & /*bHandled*/) {
    CloseDialog(wID);
    return 0;
  }

  void CloseDialog(int nVal) {
    DestroyWindow();
    ::PostQuitMessage(nVal);
  }
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before
// the previous line.

#endif // !defined(AFX_MAINDLG_H__BC18EE0D_3E2E_45A7_B8A3_B594A4D2A545__INCLUDED_)
