#ifndef __lite_virtual_keys_h__
#define __lite_virtual_keys_h__

#if !defined(ANDROID)
  #if defined(SCITERJS)
    #include "sdk.js/include/sciter-x-lite-keycodes.h"
  #else
    #include "sdk/include/sciter-x-lite-keycodes.h"
  #endif
#else  // ANDROID

  #include <android/keycodes.h>

enum KEYBOARD_CODES {

  KB_SPACE                = AKEYCODE_SPACE,
  KB_APOSTROPHE           = AKEYCODE_APOSTROPHE, /* ' */
  KB_COMMA                = AKEYCODE_COMMA,
  /* , */ KB_QUOTE        = KB_APOSTROPHE,
  KB_MINUS                = AKEYCODE_MINUS,  /* - */
  KB_PERIOD               = AKEYCODE_PERIOD, /* . */
  KB_SLASH                = AKEYCODE_SLASH,  /* / */
  KB_0                    = AKEYCODE_0,
  KB_1                    = AKEYCODE_1,
  KB_2                    = AKEYCODE_2,
  KB_3                    = AKEYCODE_3,
  KB_4                    = AKEYCODE_4,
  KB_5                    = AKEYCODE_5,
  KB_6                    = AKEYCODE_6,
  KB_7                    = AKEYCODE_7,
  KB_8                    = AKEYCODE_8,
  KB_9                    = AKEYCODE_9,
  KB_SEMICOLON            = AKEYCODE_SEMICOLON, /* ; */
  KB_EQUAL                = AKEYCODE_EQUALS,    /* = */
  KB_A                    = AKEYCODE_A,
  KB_B                    = AKEYCODE_B,
  KB_C                    = AKEYCODE_C,
  KB_D                    = AKEYCODE_D,
  KB_E                    = AKEYCODE_E,
  KB_F                    = AKEYCODE_F,
  KB_G                    = AKEYCODE_G,
  KB_H                    = AKEYCODE_H,
  KB_I                    = AKEYCODE_I,
  KB_J                    = AKEYCODE_J,
  KB_K                    = AKEYCODE_K,
  KB_L                    = AKEYCODE_L,
  KB_M                    = AKEYCODE_M,
  KB_N                    = AKEYCODE_N,
  KB_O                    = AKEYCODE_O,
  KB_P                    = AKEYCODE_P,
  KB_Q                    = AKEYCODE_Q,
  KB_R                    = AKEYCODE_R,
  KB_S                    = AKEYCODE_S,
  KB_T                    = AKEYCODE_T,
  KB_U                    = AKEYCODE_U,
  KB_V                    = AKEYCODE_V,
  KB_W                    = AKEYCODE_W,
  KB_X                    = AKEYCODE_X,
  KB_Y                    = AKEYCODE_Y,
  KB_Z                    = AKEYCODE_Z,
  KB_LEFT_BRACKET         = AKEYCODE_LEFT_BRACKET,
  /* [ */ KB_LEFTBRACKET  = KB_LEFT_BRACKET,
  KB_BACKSLASH            = AKEYCODE_BACKSLASH, /* \ */
  KB_RIGHT_BRACKET        = AKEYCODE_RIGHT_BRACKET,
  /* ] */ KB_RIGHTBRACKET = KB_RIGHT_BRACKET,
  KB_GRAVE_ACCENT         = AKEYCODE_GRAVE, /* ` */
  //KB_WORLD_1              = 161,
  ///* non-US #1 */ KB_DOT  = KB_WORLD_1,
  //KB_WORLD_2              = 162, /* non-US #2 */

  /* Function keys */
  KB_ESCAPE       = AKEYCODE_ESCAPE,
  KB_ENTER        = AKEYCODE_ENTER,
  KB_RETURN       = KB_ENTER,
  KB_TAB          = AKEYCODE_TAB,
  KB_BACKSPACE    = AKEYCODE_DEL,
  KB_BACK         = KB_BACKSPACE,
  KB_INSERT       = AKEYCODE_INSERT,
  KB_DELETE       = AKEYCODE_FORWARD_DEL,
  KB_RIGHT        = AKEYCODE_DPAD_RIGHT,
  KB_LEFT         = AKEYCODE_DPAD_LEFT,
  KB_DOWN         = AKEYCODE_DPAD_DOWN,
  KB_UP           = AKEYCODE_DPAD_UP,
  KB_PAGE_UP      = AKEYCODE_PAGE_UP,
  KB_PRIOR        = KB_PAGE_UP,
  KB_PAGE_DOWN    = AKEYCODE_PAGE_DOWN,
  KB_NEXT         = KB_PAGE_DOWN,
  KB_HOME         = AKEYCODE_MOVE_HOME,
  KB_END          = AKEYCODE_MOVE_END,
  KB_CAPS_LOCK    = AKEYCODE_CAPS_LOCK,
  KB_CAPITAL      = KB_CAPS_LOCK,
  KB_SCROLL_LOCK  = AKEYCODE_SCROLL_LOCK,
  KB_SCROLL       = KB_SCROLL_LOCK,
  KB_NUM_LOCK     = AKEYCODE_NUM_LOCK,
  KB_NUMLOCK      = KB_NUM_LOCK,
  KB_PRINT_SCREEN = AKEYCODE_SYSRQ,
  KB_PAUSE        = AKEYCODE_MEDIA_PLAY_PAUSE,
  KB_F1           = AKEYCODE_F1,
  KB_F2           = AKEYCODE_F2,
  KB_F3           = AKEYCODE_F3,
  KB_F4           = AKEYCODE_F4,
  KB_F5           = AKEYCODE_F5,
  KB_F6           = AKEYCODE_F6,
  KB_F7           = AKEYCODE_F7,
  KB_F8           = AKEYCODE_F8,
  KB_F9           = AKEYCODE_F9,
  KB_F10          = AKEYCODE_F10,
  KB_F11          = AKEYCODE_F11,
  KB_F12          = AKEYCODE_F12,
  /*KB_F13             = 302,
  KB_F14             = 303,
  KB_F15             = 304,
  KB_F16             = 305,
  KB_F17             = 306,
  KB_F18             = 307,
  KB_F19             = 308,
  KB_F20             = 309,
  KB_F21             = 310,
  KB_F22             = 311,
  KB_F23             = 312,
  KB_F24             = 313,
  KB_F25             = 314,*/
  KB_NUMPAD0         = AKEYCODE_NUMPAD_0,
  KB_NUMPAD1         = AKEYCODE_NUMPAD_1,
  KB_NUMPAD2         = AKEYCODE_NUMPAD_2,
  KB_NUMPAD3         = AKEYCODE_NUMPAD_3,
  KB_NUMPAD4         = AKEYCODE_NUMPAD_4,
  KB_NUMPAD5         = AKEYCODE_NUMPAD_5,
  KB_NUMPAD6         = AKEYCODE_NUMPAD_6,
  KB_NUMPAD7         = AKEYCODE_NUMPAD_7,
  KB_NUMPAD8         = AKEYCODE_NUMPAD_8,
  KB_NUMPAD9         = AKEYCODE_NUMPAD_9,
  KB_NUMPAD_DECIMAL  = AKEYCODE_NUMPAD_DOT,
  KB_DECIMAL         = KB_NUMPAD_DECIMAL,
  KB_SEPARATOR       = KB_DECIMAL,
  KB_NUMPAD_DIVIDE   = AKEYCODE_NUMPAD_DIVIDE,
  KB_DIVIDE          = KB_NUMPAD_DIVIDE,
  KB_NUMPAD_MULTIPLY = AKEYCODE_NUMPAD_MULTIPLY,
  KB_MULTIPLY        = KB_NUMPAD_MULTIPLY,
  KB_NUMPAD_SUBTRACT = AKEYCODE_NUMPAD_SUBTRACT,
  KB_SUBTRACT        = KB_NUMPAD_SUBTRACT,
  KB_NUMPAD_ADD      = AKEYCODE_NUMPAD_ADD,
  KB_ADD             = KB_NUMPAD_ADD,
  KB_PLUS            = KB_ADD,
  KB_NUMPAD_ENTER    = AKEYCODE_NUMPAD_ENTER,
  KB_NUMPAD_EQUAL    = AKEYCODE_NUMPAD_EQUALS,
  KB_LEFT_SHIFT      = AKEYCODE_SHIFT_LEFT,
  KB_SHIFT           = KB_LEFT_SHIFT,
  KB_LEFT_CONTROL    = AKEYCODE_CTRL_LEFT,
  KB_CONTROL         = KB_LEFT_CONTROL,
  KB_SHORTCUT        = KB_CONTROL,
  KB_LEFT_ALT        = AKEYCODE_ALT_LEFT,
  KB_LEFT_SUPER      = AKEYCODE_META_LEFT,
  KB_RIGHT_SHIFT     = AKEYCODE_SHIFT_RIGHT,
  KB_RIGHT_CONTROL   = AKEYCODE_CTRL_RIGHT,
  KB_RIGHT_ALT       = AKEYCODE_ALT_RIGHT,
  KB_RIGHT_SUPER     = AKEYCODE_META_RIGHT,
  KB_MENU            = AKEYCODE_MENU,
};



#endif

#endif
