#ifndef __LITE_VIEW_H__
#define __LITE_VIEW_H__

#if defined(SCITER)
  #include "xdom/xview.h"
#elif defined(SCITERJS)
  #include "xdomjs/xview.h"
#endif

#include "sdk-headers.h"

namespace lite {
  using namespace tool;
  using namespace gool;
  using namespace html;

  class view;

  class popup : public html::popup {
    typedef html::popup super;
    friend class window;

    view* pview = nullptr;
    
  protected:
    popup() {}
    virtual ~popup();

  public:

    popup(view* pv): pview(pv) {}

    // iwindow stuff:
    virtual graphics *surface() override;

    virtual void refresh() override { refresh(rect(client_dim())); }
    virtual void refresh(const rect &area) override;
    virtual void update() override;
    virtual void dismiss() override;

    static void   init(bool start);
    static popup *ptr(HWINDOW hwnd);
    virtual void  destroy();

    virtual void do_paint();

    virtual bool print(void *hdc, rect rc) { return false; }
  };

  class view 
#if defined(SCITERJS)
    : public qjs::xview 
#else
    : public tis::xview 
#endif
  {
  public:
#if defined(SCITERJS)
    typedef qjs::xview view_type_t;
    typedef qjs::xview super;
#else 
    typedef tis::xview view_type_t;
    typedef tis::xview super;
#endif

    enum { MOUSE_IDLE_TIMER_ID = 1 };

    view(const window_params& params)
      : super(params),
      /*_idle_id(0), _delegate(0), _delegate_param(0),*/ _gfx(0),
      _is_closing(false), _mouse_idle_timer_id(0),
      _window_state(WINDOW_SHOWN)
      //, _is_glassy(false)
      ,
      _is_transparent(false) {

      init_media_vars();
    }
    virtual ~view() {
      // setup_mouse_idle(false);
      // if (_idle_id) {
      //  g_source_remove(_idle_id);
      //  _idle_id = 0;
      //}
    }

    virtual bool needs_opengl() { return true; }
    virtual bool must_use_raster() const { return false; }

    void attach(HWINDOW gview) {
      set_hwnd(gview);
      _window_state = WINDOW_HIDDEN;
    } // this object got HWND to it, _hwnd field is valid, ctor
    void detach() {
      stop();
      set_hwnd(nullptr);
    } // detaching the instance from NSView

      // virtual HWINDOW get_hwnd() const override { return _widget; }
    virtual html::VIEW_TYPE view_type() const override {
      return type == html::DIALOG_WINDOW ? html::VIEW_DIALOG :
        html::VIEW_WINDOW;
    }

    bool is_transparent() const { return !!_is_transparent; }
    // virtual void set_transparency( bool on_off ) { _is_transparent = on_off;
    // } virtual bool get_transparency() const { return _is_transparent; }

    // virtual void set_glassy( bool on_off ) { _is_glassy = on_off; }
    // virtual bool get_glassy() const { return _is_glassy; }

    virtual gool::graphics *surface() override;

    virtual bool set_target_surface(void* pSurface) { return false; }

    virtual bool add_animation(element *b, animation *pba,
      const style *new_style,
      const style *old_style) override;

    virtual bool request_animation_frame(uint delay = 0) override;
    virtual void stop_animation_frames() override;
    virtual uint get_animation_ticks() override;

    virtual bool is_active() const override;
    virtual bool set_focus(helement b, FOCUS_CAUSE cause, bool postfactum) override;

    virtual size pixels_per_inch() override;
    // virtual element* element_under_cursor(/* out, view related */
    // gool::point& cursor_pos ) override;
    virtual void          set_cursor(gool::cursor *pcur) override;
    virtual gool::cursor *get_cursor() override;

    virtual void stop() override;

    virtual void do_request_idle() override;
    virtual void set_timer(uint_ptr id, uint ms, uint_ptr &sys_id) override;
    virtual bool on_timer(uint_ptr uid) override;

    virtual bool ask_close_window(bool by_chrome = false) override;
    virtual bool close_window() override;

    bool rq_close_window();

    virtual array<ustring> ask_file_name(AFN_MODE mode, const ustring &caption,
      const ustring &filename,
      const wchar *  def_ext,
      const wchar *  filter) override;
    virtual bool           ask_folder_name(const ustring &caption,
      ustring &      foldername) override;

    virtual void replace_windowed() override;
    virtual rect window_decoration() const override;
    // void                 update_window_decoration();
    virtual void         move_window(const rect &spos, bool client_rc = false) override;
    virtual WINDOW_STATE get_window_state() const override;
    virtual bool         set_window_state(WINDOW_STATE ws) override;
    virtual ustring      get_window_title() const override;
    virtual bool         set_window_title(const wchar *title) override;

    // virtual bool         show() override;
    virtual bool show_modal() override;

    virtual bool do_event(DO_EVENT_MANNER m, bool &result) override;

    virtual void
      setup_text_flow(html::element *elem, html::tflow::text_flow &tf,
        tool::slice<tool::handle<html::node>> nodes) override {
      assert(false);
    }
    virtual void draw_glyph_run(gool::graphics *              gfx,
      const html::tflow::text_flow &tf,
      const html::tflow::glyph_run &gr,
      gool::pointf at, argb color,
      const style *run_style) override {
      assert(false);
    }

    virtual iwindow *create_window(html::element *forel, html::element *anchor,
        html::WINDOW_TYPE wt,
        function<rect(html::view &, html::element *, html::element *)>
        setup_and_calc_place,
        ELEMENT_WINDOW_MODE mode = ELEMENT_WINDOW_AUTO) override;
    virtual bool   close_popup(element *b, bool set_auto_focus) override;
    virtual popup *create_popup();

    virtual GRAPHICS_CAPS graphics_caps() const override {
      return SOFTWARE_GRAPHICS;
    }
    ustring graphics_backend() const override { return ustring(W("cairo")); }

    virtual void init_media_vars() override;
    //virtual bool set_environment(const tool::environment::info &penv) override;
    
    virtual int get_window_metrics(tool::value::length_special_values what) override;

    /*void do_paint() {
      if (!invalid.empty())
        render(nullptr, invalid);
    }*/

    virtual bool render_element(element *p, bool front_layer) { return false; }
    virtual void paint(element *to_draw = nullptr, bool front_layer = true) override;
    void paint(function<void(gool::bitmap *dst, point view_pos)> cb, element *to_draw = nullptr, bool front_layer = true);

    virtual bool disable_element_draw(graphics *pg, element *el)  override {
      //NOTE: in Lite case all elements are drawn on the same surface (window) so we are not disabling any drawing here
      //if (el->state.popup() && pg->get_drawing_root() == doc()) return true;
      return false;
    }

    virtual void invalidate(const rect &area) override {
      super::invalidate(area);
      if (callback)
        callback->invalidate_rect(this, area);
    }


    // virtual void render(graphics * pg, gool::rect dirty_rc) ; // removed from
    // html::iwindow

    void post_posted_callback(uint_ptr wp, uint_ptr lp);

    // static gboolean idle_callback(gpointer user_data);
    // static gboolean mouse_idle_timer_callback(gpointer user_data);

    void update_window_state(WINDOW_STATE st) {
      if (_window_state != st) {
        _window_state = st;
        on_state_changed();
      }
    }

    // virtual float_v aspect_ratio() const override { return
    // super::aspect_ratio(); } virtual void    aspect_ratio(float_v r) override
    // { super::aspect_ratio(r); }

    // virtual bool get_min_size(gool::size &sz) override;
    // virtual bool get_max_size(gool::size &sz) override;
    // virtual bool set_min_size(gool::size sz = gool::size()) override;
    // virtual bool set_max_size(gool::size sz = gool::size()) override;

    virtual bool set_resizeable(bool on) override { return false; }
    virtual bool get_resizeable() const override { return false; }
    virtual bool set_topmost(bool on) override { return false; }
    virtual bool get_topmost() override { return false; }
    virtual bool set_minimizable(bool on) override { return false; }
    virtual bool get_minimizable() override { return false; }
    virtual bool set_maximizable(bool on) override { return false; }
    virtual bool get_maximizable() override { return false; }

    virtual void on_size(size sz) override {
      dim = sz;
      super::on_size(sz);
    }

    static SBOOL CALLBACK proc_x(HWINDOW hWnd, SCITER_X_MSG *pMsg); 

  protected:

    html::WINDOW_STATE _window_state;

    handle<cursor> _cursor;

    // bool                  _is_glassy;
    bool _is_transparent;
    bool _is_closing;

    float_v    _aspect_ratio;
    dim_v_t    _min_size;
    dim_v_t    _max_size;
    tristate_v _is_topmost;
    tristate_v _is_resizeable;

    // uint                      _idle_id;
    uint_v   _animation_ticker;
    uint_ptr _mouse_idle_timer_id;
    point    _mouse_idle_pos;
    // static gboolean           gv_on_animation_tick(GtkWidget *    widget,
    //                                               GdkFrameClock *frame_clock,
    //                                               gpointer       user_data);
  public:
    mutable dim_v_t _decorations_origin;
    mutable dim_v_t _decorations_corner;

    // tool::event            posted_callback_complete;
    handle<graphics> _gfx;
    tristate_v       _got_mouse_up;
    tristate_v       _closerq_by_code;
    
  };

} // namespace android

#endif
