#include "lite.h"

namespace gool {

#if !defined(WINDOWS)
  cursor *cursor::system(uint id) {
    // no cursors on mobile so far
    return nullptr;
  };

  cursor *cursor::from_data(bytes data, string url) { 
    return nullptr;
  }

  cursor *cursor::from_bitmap(bitmap *bmp, string url, size offset) {
    return nullptr;
  }
#endif

  struct _resolution_provider : public resolution_provider 
  {
    size _pixels_per_inch;

    _resolution_provider() : _pixels_per_inch(96,96) {}

    size pixels_per_inch() override {
      return _pixels_per_inch;
    }

    void reset_resolution() override {}

    void pixels_per_inch(size sz) override {
      //assert(false); // not used in default provider
      _pixels_per_inch = sz;
    }
  };


  resolution_provider &resolution_provider::desktop() {
    static _resolution_provider provider;
    return provider;
  }

  bool set_gpu_black_list(const char *bl_json) { return false; }

  gool::application* app() { return lite::app(); }

  color xcolor(SYSTEM_COLORS cs) {
    switch (cs) {
    case SC_WINDOW: return 0xFFFFFF;
    case SC_WINDOW_TEXT: return 0x000000;
    case SC_DIALOG_BRIGHT: return 0xFFFFFF;
    case SC_DIALOG_LIGHT: return 0xE3E3E3;
    case SC_DIALOG_SURFACE: return 0xF0F0F0;
    case SC_DIALOG_SHADOW: return 0xA0A0A0;
    case SC_DIALOG_DKSHADOW:
      return 0x696969;
      //      case SC_SELECTION         : return sys_color_table_initialized ?
      //      sc_selection_back : 0xFF9933; case SC_SELECTION_TEXT    : return
      //      sys_color_table_initialized ? sc_selection_text : 0xFFFFFF; case
      //      SC_MENU_SELECTION      : return sys_color_table_initialized ?
      //      sc_selection_back : 0xFF9933; case SC_MENU_SELECTION_TEXT :
      //      return sys_color_table_initialized ? sc_selection_text :
      //      0xFFFFFF;
    case SC_ACCENT:
    case SC_SELECTION: return 0xFF9933;
    case SC_ACCENT_TEXT:
    case SC_SELECTION_TEXT: return 0xFFFFFF;
    case SC_MENU_SELECTION: return 0xFF9933;
    case SC_MENU_SELECTION_TEXT: return 0xFFFFFF;
    case SC_WORKSPACE: return 0xABABAB;
    case SC_CAPTION: return 0xF2E4D7;
    case SC_CAPTION_TEXT: return 0x544E43;
    case SC_ACTIVE_CAPTION: return 0xD1B499;
    case SC_ACTIVE_CAPTION_TEXT: return 0x000000;
    case SC_INFO: return 0xE1FFFF;
    case SC_INFO_TEXT: return 0x000000;
    case SC_DIALOG_TEXT: return 0x000000;
    case SC_SCROLLBAR: return 0xF7F7F7;
    case SC_DESKTOP: return 0x464646;
    case SC_GRAY_TEXT: return 0x6D6D6D;
    case SC_WINDOW_BORDER: return 0xA0A0A0;
    case SC_BORDER: return 0xA0A0A0;
    case SC_DIALOG_LIGHTSHADOW:
      return 0xE9E9E9;
      // case INVERSE_COLOR          : return INVERSE_COLOR;
    }
    return cs;
  }


}
