#ifndef __lite_application_h__
#define __lite_application_h__

#include "tool/tool.h"
#include "gool/gool.h"
#include "html/html.h"

namespace lite {
  using namespace tool;
  using namespace gool;
  using namespace html;

  class view;
  class popup;

  class application : public gool::application {
    static application* instance;
  public:

    static application *factory();

    //handle<view> window; // the only window ?

    application();
    virtual ~application();

    virtual bool is_valid() { return true; }

    virtual gool::font *
      create_font(const ustring &name, float size, uint weight = 400,
        bool                 italic = false,
        gool::FONT_RENDERING mode = gool::FR_VECTOR) override;

    virtual void clear_font_cache() override;

    virtual tool::ustring get_supported_font_family(const tool::ustring &family_name_list) override;

    static wchars fallback_list(wchars lang_id, WRITING_SCRIPT script, bool serif);

    virtual bool is_d2d() { return false; }

    virtual void get_system_font(/*inout*/ ustring &name, /*out*/ int &size,
      /*out*/ uint &weight,
      /*out*/ bool &italic) override;

    // bool get_supported_font_family(wchars family_name_list,
    //                               const function<bool(wchars)> &cb,
    //                               tool::wchars lang_id, WRITING_SCRIPT
    //                               script);

    virtual bool install_font(const tool::ustring &name, int weight,
      bool italic, tool::bytes data) override {
      return false;
    }

    virtual bool get_used_font(tool::handle<gool::font> &pf,
      tool::wchars              family_name_list,
      const gool::font *proto, tool::wchars lang_id,
      WRITING_SCRIPT script,
      uint           char_code = 0) override {
      assert(false);
      return false;
    }

    virtual gool::path *create_path() override
    {
      assert(false);
      return nullptr;
    }

    virtual gool::graphics *create_bitmap_graphics(gool::graphics *proto,
      gool::bitmap *  bmp,
      gool::argb initc) override
    {
      assert(false);
      return nullptr;
    }

    virtual gool::graphics * create_bitmap_bits_graphics(gool::bitmap *bmp, gool::argb initc,
      bool high_quality = false) override
    {
      assert(false);
      return nullptr;
    }
        
    virtual gool::GRAPHICS_CAPS graphics_caps() const override {
      return gool::SOFTWARE_GRAPHICS;
    }

    virtual lite::view* create_window_processor(const window_params &params);
    
    virtual handle<html::view> create_frame(const window_params &params) override { return nullptr; }
    virtual handle<html::view> create_dialog(const window_params &params) override { return nullptr; }

  protected:
    virtual bool init_font(gool::font *pfont) override {
      assert(false);
      return false;
    }
  };

  inline application* app() {
    return application::factory();
  }


} // namespace lite

#endif
