#include "html.h"

namespace html {

  point element::positioned_pos(view &v, element *positioned) {
    assert(!ldata->zctx.is_empty());
    return ldata->zctx.get_position(positioned);
  }

  void z_ctx::request_replace() {
    if (!_data) return;
    _data->layout_valid = false;
  }

  void z_ctx::replace(view &v, element *container) {
    if (!_data) return;

    for (index_t i = _data->arr.last_index(); i >= 0; --i) {
      i = limit(i, 0, _data->arr.last_index());
      helement el = _data->arr[i].el;
      if (!el->belongs_to(container)) {
        remove(el, container);
        continue;
      }
      helement pa = el->abs_pos_parent(v);
      if (pa != container) {
        remove(el, container);
        if (pa && pa->ldata) pa->ldata->zctx.push(v, pa, el);
        continue;
      }
      if (!el->takes_space(v)) continue;
      if (_data->arr.is_valid_index(i)) {
        el->get_style(v);
        el->check_layout(v);
        _data->arr[i].pos = reposition(v, container, el);
      }
    }

    //sort(_data->arr.begin(), _data->arr.length()); -- sort is not stable :( TODO

    _data->layout_valid = true;
  }

  void z_ctx::draw(view &v, graphics *sf, point p, element *container,
                   bool above) {

    if (!_data) return;

    if (!_data->layout_valid) 
      replace(v, container);

    point cvp = container->view_pos(v);

    for (int i = 0; i < _data->arr.size(); ++i) {
      element_pos t = _data->arr[i];

      if (t.el->airborn) continue;

      const style *tcs = t.el->get_style(v);

      if (!t.el->belongs_to(container)) {
        remove(t.el, container);
        --i;
        continue;
      }
      element *pa = t.el->abs_pos_parent(v);
      if (pa != container) {
        remove(t.el, container);
        --i;
        pa->ldata->zctx.push(v, pa, t.el);
        continue;
      }

      // if( t->popup_positioned(v) && !t->state.popup() )
      //{
      //  t->draw(v, sf, vp);
      //  continue;
      //}

      if (!t.el->is_drawable(v)) continue;

      int z_index = tcs->z_index.val(0);

      if (above && (z_index < 0)) continue;
      if (!above && (z_index >= 0)) continue;

      if (t.el->state.popup() /*&& !sf.is_buffer()*/)
        continue; // they are drawn by popup windows

      point vp = cvp + t.pos;

      // rect brc = t.el->rendering_box(v) + vp;
      /*if(!(brc && dirty))
      {
        if( !tcs->clip_overflow() && !t.el->ldata->zctx.is_empty())
          t.el->ldata->zctx.draw(v, sf, vp, t.el, above );
        continue;
      }*/
      if (t.el->fix_positioned(v) || t.el->popup_positioned(v)) {
        point vp = p + t.pos;
        t.el->draw(v, sf, vp);
        if(!t.el->c_style->clip_overflow())
          t.el->draw_outlines(v, sf, vp, true, true, true);
        else
          t.el->draw_outline(v, sf, vp);

      } else if (t.el->abs_positioned(v)) {
        point dp = p + t.pos;
        t.el->draw(v, sf, dp);
        if (!t.el->c_style->clip_overflow())
          t.el->draw_outlines(v, sf, dp, true, true, true);
        else 
          t.el->draw_outline(v, sf, dp);
      } else if (t.el->rel_positioned(v)) {
        point dp = p + t.pos; // p + t->rel_pos(v,container);
        t.el->draw(v, sf, dp);
        if(!t.el->c_style->clip_overflow())
          t.el->draw_outlines(v, sf, dp, true, true, true);
        else
          t.el->draw_outline(v, sf, dp);
      } else {
        remove(t.el, container);
        --i;
      }
    }
  }

  void z_ctx::draw_owned_popups(view &v, graphics *sf, element *container) {
    if (!_data) return;
    int i;
    for (i = 0; i < _data->arr.size(); ++i) {
      element_pos t = _data->arr[i];
      t.el->get_style(v);
      if (t.el->popup_positioned(v) && !t.el->state.popup() &&
          t.el->belongs_to(container, false))
        t.el->draw(v, sf, t.el->view_pos(v));
    }
  }

  element *z_ctx::find_element(view &v, point zpos, point nt_zpos,
                               element *container, bool above)
  //                                     tanslated   not translated
  {
    if (!_data) return 0;

    if ((container->get_style(v)->overflow() > overflow_visible) &&
        !container->client_box(v).contains(nt_zpos))
      return 0;

    for (index_t i = _data->arr.last_index(); i >= 0; --i) {
      element_pos  t   = _data->arr[i];
      const style *tcs = t.el->get_style(v);

      if (!t.el->belongs_to(container)) {
        remove(t.el, container);
        continue;
      }

      if (above && tcs->z_index < 0) continue;   // break;
      if (!above && tcs->z_index >= 0) continue; // break;

      if (!t.el->is_visible(v)) continue;

      if (t.el->state.moving() || t.el->state.copying()) continue;

      if (t.el->airborn) continue;

      element *bf = 0;

#ifdef _DEBUG
      if (t.el->is_id_test()) t.el = t.el;
#endif

      if (t.el->popup_positioned(v) && container == v.doc())
        bf = t.el->find_element(v, nt_zpos - t.pos);
      else if (t.el->fix_positioned(v) && container == t.el->doc())
        bf = t.el->find_element(v, nt_zpos - t.pos);
      else if (t.el->abs_positioned(v))
        bf = t.el->find_element(v, zpos - t.pos);
      else if (t.el->rel_positioned(v))
        // bf = t->find_element(v, docp - t->rel_pos(v,container) + t->pos +
        // t->rel_shift());
        bf = t.el->find_element(v, zpos - t.pos);
      else
        remove(t.el, container);
      if (bf) return bf;
    }
    return 0;
  }

  void z_ctx::remove(element *b, element *container) {
#ifdef _DEBUG
    if (b->is_id_test()) b = b;
    assert(!b->positioned_parent || b->positioned_parent == container);
#endif
    b->positioned_parent = 0;
    if (!_data) return;
    _data->layout_valid = false;

    index_t tt = _data->arr.get_index(b);
    if (tt >= 0) { _data->arr.remove(tt); }
    // else
    //  assert(false);
  }

  void z_ctx::push(view &v, element *container, element *b) {
#ifdef _DEBUG
    if (b->is_id_test()) 
      b = b;
#endif

    if (b->positioned_parent) remove(b, b->positioned_parent);
    int zi = b->get_style(v)->z_index;
    if (!_data) _data = new data(container);

    _data->layout_valid = false;
    b->drop_minmax_dim(); //b->drop_content_layout(); ??? used to be b->drop_layout_tree(); and that breaks
                          //basic rendering. 
    
    b->positioned_parent = container;

    index_t last = _data->arr.last_index();
    for (index_t i = last; i >= 0; --i) {
      element_pos t = _data->arr[i];
      if (!t.el->doc()) {
        assert(!t.el->positioned_parent ||
               t.el->positioned_parent == container);
        t.el->positioned_parent = 0;
        _data->arr.remove(i);
        continue;
      }
      int tzi = t.el->get_style(v)->z_index;
      if (tzi < zi) {
        element_pos nt;
        nt.el = b;
        _data->arr.insert(i + 1, nt);
        return;
      }
#pragma TODO("Do I need this at all?")
      if (tzi == zi) {
        // bookmark bmt = t->this_bookmark();
        // if(bmt < bmi)
        //{
        element_pos nt;
        nt.el = b;
        _data->arr.insert(i + 1, nt);
        return;
        //}
      }
    }
    element_pos nt;
    nt.el = b;
    _data->arr.insert(0, nt);
  }

  void z_ctx::clear() {
    if (_data) {
      FOREACH(i, _data->arr)
      _data->arr[i].el->positioned_parent = 0;
      _data->arr.clear();
    }
  }

  rect z_ctx::content_outline(view &v, element *b) {
    rect rc(size(b->ldata->dim_min.x, b->ldata->dim_min.y));
    if (_data)
      for (index_t i = _data->arr.last_index(); i >= 0; --i) {
        element_pos t = _data->arr[i];
        if (!t.el->doc()) {
          t.el->positioned_parent = 0;
          _data->arr.remove(i);
          continue;
        }
        if (!t.el->is_visible(v)) continue;
        if (t.el->popup_positioned(v)) continue;
        if (t.el->fix_positioned(v)) continue;

        rect trc = t.el->border_box(v, element::TO_LAYOUT_PARENT);
        // trc += t->rel_pos(b);
        rc |= trc;
      }
    return rc;
  }

  bool z_ctx::has_fixed(view &v) const {
    if (_data)
      for (index_t i = _data->arr.last_index(); i >= 0; --i) {
        element_pos t = _data->arr[i];
        if (!t.el->doc()) {
          t.el->positioned_parent = 0;
          _data->arr.remove(i);
          continue;
        }
        if (t.el->fix_positioned(v) || t.el->popup_positioned(v)) return true;
      }
    return false;
  }

} // namespace html