#ifndef __html_view_print_h__
#define __html_view_print_h__

#include "tool/tool.h"
#include "gool/gool.h"

#include "html-view.h"
#if defined(SCITER)
  #include "xdom/xview.h"
#elif defined(SCITERJS)
  #include "xdomjs/xview.h"
#endif

namespace html {
  using namespace tool;
  using namespace gool;

  template <class TV> struct print_view_t : public TV {

    virtual bool is_printing() const { return true; }

    virtual iwindow *create_window(
        element *forel, element *anchor, WINDOW_TYPE wt,
        function<rect(view &, element *, element *)> setup_and_calc_place,
        ELEMENT_WINDOW_MODE mode = ELEMENT_WINDOW_AUTO) {
      assert(false);
      return nullptr;
    }
    virtual void set_cursor(cursor *pcur) { /*assert(false);*/
    }
    virtual cursor *get_cursor() {
      assert(false);
      return nullptr;
    }
    virtual void set_timer(uint_ptr id, uint ms, uint_ptr &sys_id) override {
      assert(false);
    }
    virtual void on_animation_tick() override { /*assert(false);*/
    }
    virtual bool request_animation_frame(uint delay = 0) override { /*assert(false);*/
      return false;
    }
    virtual void stop_animation_frames() { /*assert(false);*/
    }
    virtual bool is_active() const {
      assert(false);
      return false;
    }
    virtual void do_request_idle() {
      handle<TV> self = this;
      if (auto ppv = self->parent()) {
        ppv->async([self]() -> bool {
          self->on_idle();
          return true;
        });
      }
    }

    virtual bool post(functor *pf, bool only_once = false) override {
      return parent()->post(pf, only_once);
    }

    virtual bool show_modal() {
      assert(false);
      return false;
    }
    virtual void replace_windowed() { /*assert(false);*/
    }

    virtual void update() override {}
    virtual void refresh(const rect &area) override {}
    virtual void refresh(element *b, rect rc_to_refresh) override {}

  protected:
    print_view_t(const window_params& params): TV(params) {}
  };

#if defined(WINDOWS)
  #if defined(SCITER)
    typedef html::print_view_t<tis::xview> print_view_base;
  #elif defined(SCITERJS)
    //typedef html::print_view_t<qjs::xview> print_view_base;
    typedef html::print_view_t<html::view> print_view_base;
  #endif
#else
  typedef html::print_view_t<html::view> print_view_base;
#endif

  class print_view : public print_view_base {
  protected:
    typedef print_view_base super;
    print_view(const window_params& params) : super(params), page_no(0), _host(nullptr), drawing_content(false) {}

    handle<graphics> _gfx;
    html::element *  _host;

  public:
    bool  drawing_content;
    uint  page_no; // current page_no
    range page_y;  // drawing page y

    // function<void(print_view*)> update_cb;
    // tristate_v                  update_request;

    // static  print_view* create(view* p);
    virtual graphics *surface() override;

    void           host(html::element *t) { _host = t; }
    html::element *host() const { return _host; }

    void set_graphics(graphics *gfx) { _gfx = gfx; }

    virtual HWINDOW         get_hwnd() const override;
    virtual html::VIEW_TYPE view_type() const override {
      return html::VIEW_PAGES;
    }

    //#if defined(WINDOWS)
    virtual void
                         setup_text_flow(html::element *elem, html::tflow::text_flow &tf,
                                         tool::slice<tool::handle<html::node>> nodes) = 0;
    virtual void         draw_glyph_run(gool::graphics *              gfx,
                                        const html::tflow::text_flow &tf,
                                        const html::tflow::glyph_run &gr,
                                        gool::pointf at, argb color,
                                        const html::style *run_style) = 0;
    virtual void         draw_glyph_run_back(gool::graphics *              gfx,
                                             const html::tflow::text_flow &tf,
                                             const html::tflow::glyph_run &gr,
                                             gool::rectf rc, argb back_color) = 0;
    virtual handle<gool::text_layout> create_text_layout(wchars text) override {  return parent()->create_text_layout(text); }
    /*
        virtual void setup_text_flow( html::element* elem,
       html::tflow::text_flow& tf, tool::slice< tool::handle<html::node> > nodes
       ) override { return parent()->setup_text_flow(elem,tf, nodes); } virtual
       void draw_glyph_run( gool::graphics* gfx, const html::tflow::text_flow&
       tf, const html::tflow::glyph_run& gr, gool::pointf at, argb color, const
       html::style* run_style) override { parent()->draw_glyph_run(gfx, tf, gr,
       at, color, run_style); } virtual void draw_glyph_run_back(
       gool::graphics* gfx, const html::tflow::text_flow& tf, const
       html::tflow::glyph_run& gr, gool::rectf rc, argb back_color) override {
       parent()->draw_glyph_run_back(gfx, tf, gr, rc, back_color); } virtual
       text_layout* create_text_layout(wchars text, const text_format& tf)
       override
           

           */

    //#endif

    virtual bool disable_element_draw(graphics *pg, element *el) override {
      //#ifdef _DEBUG
      //    if(el->is_id_test())
      //      el = el;
      //#endif
      if (super::disable_element_draw(pg, el)) return true;
      if (el->ldata->page_no_start == 0) return false;
      if (el->ldata->page_no_end == 0) return false;
      bool inside = this->page_no >= el->ldata->page_no_start &&
                    this->page_no <= el->ldata->page_no_end;
      return !inside;
    }

    virtual void refresh(const rect &area) override { 
      if (auto pp = parent()) pp->refresh();
    }
    virtual void refresh(element *b, rect rc_to_refresh) override { 
      if (auto pp = parent()) pp->refresh();
    }

    virtual void on_root_doc_parsed(document *d) override { }
    virtual void on_root_doc_loaded(document *d) override { }

    virtual void measure_document() {
      if (doc())
        doc()->commit_measure(*this);
    }

    virtual size client_dim() override {
      if (_host)
        return _host->dim();
      return size();
    }


  };


  /*
    inline print_view* print_view::create(view* parent)
    {
       gool::application* app = parent->app->printing_app();

       window_params params;
       params.parent = parent;
       params.window_type = gool::PRINT_VIEW;

       print_view* ppv = new print_view(params);
       ppv->app = app;
       return ppv;
     } */

  inline graphics *print_view::surface() { return _gfx; }

  inline HWINDOW print_view::get_hwnd() const { return parent()->get_hwnd(); }

} // namespace html

#endif