#include "html.h"

namespace html {

  struct tabstop {
    element *b;
    int      tab_index;
    int      index;

    tabstop() : b(0), tab_index(0), index(0) {}

    bool operator<(const tabstop &rs) const {
      if (tab_index == rs.tab_index) return index < rs.index;
      return tab_index < rs.tab_index;
    }
  };

  static bool only_visible(view &v, element *b) {
    return b->is_it_visible(v) /*|| b->state.focus_element()*/ ||
           b->state.popup();
  }

  static bool only_focusable(view &v, element *b) {
    return (b->is_it_visible(v) || b->state.popup()) && !b->is_disabled();
  }

  element *view::get_next_focus_element(FOCUS_CMD_TYPE cmd,
                                        element *      current_element,
                                        bool &         end_reached) {
    if (!current_element) {
      if (focus_element && focus_element->pview() == this)
        current_element = focus_element;
      else
        current_element = old_focus_element;
    }

    helement root = event_capture_element ? event_capture_element : doc();
    end_reached   = false;

    array<tabstop> tabstops;

    int              counter = 0;
    element_iterator it(*this, root, only_focusable);
    for (element *b; it(b);) {
      // b->get_style(*this);
      int_v tabindex = b->tab_index();

      // if(tabindex.defined())
      //  tabindex = tabindex;

      if (tabindex.is_defined() && b->is_focusable(*this) && b != root &&
          tabindex >= 0 && b->is_visible(*this)) {
        tabstop ts;
        ts.b = b;
        ts.tab_index =
            tabindex == 0 ? limits<int>::max_value() : tabindex.val(0);
        ts.index = ++counter;
        tabstops.push(ts);
      }
      // else if(b == current_element)
      //{
      //  assert(false); // current element have to be in the list.
      //}
    }

    if (tabstops.size() == 0) {
      if (root) {
        tabstop ts;
        ts.b         = root;
        ts.tab_index = 0;
        ts.index     = ++counter;
        tabstops.push(ts);
      } else
        return 0;
    }

    sort<tabstop>(tabstops.head(), tabstops.size());

    int current_idx = -1;

    if (current_element) {
      for (int i = tabstops.last_index(); i >= 0; --i)
        if (tabstops[i].b == current_element) {
          current_idx = i;
          break;
        }
    }

    switch (cmd) {
    case FOCUS_FIRST:
    case FOCUS_HOME:
      current_idx = 0;
      if (current_idx >= tabstops.size()) return 0;
      break;
    case FOCUS_LAST:
    case FOCUS_END:
      current_idx = tabstops.last_index();
      if (current_idx < 0) return 0;
      break;

    case FOCUS_NEXT:
      if (current_idx < 0)
        current_idx = 0;
      else if (++current_idx >= tabstops.size()) {
        end_reached = true;
        // if(request_parent_to_advance_focus( true ))
        //  return true;
        if (!is_closed_tab_cycle()) return 0;
        current_idx = 0;
      }
      break;
    case FOCUS_PREV:
      if (current_idx < 0) {
        current_idx = tabstops.last_index();
      } else if (--current_idx < 0) {
        end_reached = true;
        if (!is_closed_tab_cycle()) return 0;
        current_idx = tabstops.last_index();
      }
      break;
    }

    return tabstops[current_idx].b;
  }

  bool view::set_focus_on(FOCUS_CMD_TYPE cmd) {
    bool     end_reached = false;
    helement next_focus  = get_next_focus_element(cmd, 0, end_reached);

    //ADVANCE_FOCUS
    
    FOCUS_CMD_TYPE cmd_advance = cmd;

    if (end_reached)
      cmd_advance = (FOCUS_CMD_TYPE) (cmd | FOCUS_END_REACHED);
    event_focus fe(next_focus.ptr(), ADVANCE_FOCUS , (FOCUS_CAUSE)cmd_advance , false);
    traverser<event_focus> trv(*this);
    if (trv.traverse(next_focus, fe))
      return false;

    FOCUS_CAUSE cause;

    switch (cmd) {
    case FOCUS_FIRST:
    case FOCUS_LAST: cause = BY_CODE; break;
    case FOCUS_HOME: cause = BY_KEY_NEXT; break;
    case FOCUS_END: cause = BY_KEY_PREV; break;
    case FOCUS_NEXT:
      cause = BY_KEY_NEXT;
      if (end_reached && request_parent_to_advance_focus(true)) return true;
      break;
    case FOCUS_PREV:
      cause = BY_KEY_PREV;
      if (end_reached && request_parent_to_advance_focus(false)) return true;
      break;
    default: cause = BY_CODE;
    }

    if (next_focus == focus_element) return false;

    return set_focus(next_focus, cause);
  }

  element *get_focus_target(view &v, element *b, bool only_visible) {
    ustring for_selector;
    if (b->atts.get(attr::a_for, for_selector)) {
      ustring at_selector;
      b->atts.get(attr::a_at, at_selector);
      element *t = find_first_ex(v, at_selector.length() ? b : b->doc(),
                                 for_selector, at_selector, only_visible);
      if (t) return t;
    }
    return b;
  }

  bool view::set_focus(helement b, FOCUS_CAUSE cause, bool postfactum) {
    auto_state<tristate_v> _1(is_setting_focus, TRUE);

    if (is_changing_focus) {
      this->post(delegate(this, &view::do_set_focus, b, cause, postfactum),true);
      return true;
    }
#pragma TODO("investigate, is_changing_focus needed at all")
    auto_state<tristate_v> _2(is_changing_focus, true);
    return do_set_focus(b, cause, postfactum);
  }

  bool view::post_set_focus(helement b, FOCUS_CAUSE cause, bool postfactum) {
#ifdef DEBUG
    if (this->focus_element && this->focus_element->tag == tag::T_INPUT)
      b = b;
#endif

    this->post(delegate(this, &view::do_set_focus, b, cause, postfactum),true);
    return true;
  }

  bool view::do_set_focus(helement b, FOCUS_CAUSE cause, bool postfactum) {

    if (b && b->state.focus()) {
      if (b == focus_element) return true;
    }

    auto is_in_dom = [this](element* el) -> bool {  
      if (!el->is_connected()) return false;
      if (el->pview() != this) return false;
      return true;
    };

    helement requested = b;

    if (requested && !is_in_dom(requested))
      return true; // attempt to set focus on removed element.

    if (!is_enabled()) {
      old_focus_element = requested;
      return false;
    }

    helement pfocus = focus_element;
    if (pfocus && !is_in_dom(pfocus)) // it was removed from the dom
      focus_element = pfocus = 0;

    updater of(this, 0, false, false);

    if (b) {
      event_focus            evt(b, REQUEST_FOCUS, cause, postfactum);
      traverser<event_focus> trv(*this);
      if (trv.traverse(b, evt)) {
        if (evt.is_canceled()) return true;
        b = evt.target;
        dont_change_focus = true;
      }
      element *nf = get_focus_target(*this, b, true);
      if (nf != b) dont_change_focus = true;
      b = nf;
    }

    if (b == doc())
      ; // request to set focus_element on html node.
    else
      for (; b;) {
        if (b->is_focusable(*this)) break;

        if (is_anchored_popup(b))
          b = popup_anchor(b);
        else
          b = b->parent;
      }

    if ((b == pfocus) && !postfactum) {
      // assert(!b || b->state.focus());
      if (b && !b->state.focus()) b->state_focus_on(*this, false);
      // it is already has focus_element
      return true;
    }

    if (requested && b == 0 && pfocus != 0) {
      // it is already has focus_element
      return true;
    }

    if (requested && !b && !pfocus) b = doc();

    handle<element> common_p = element::find_common_ui_parent(*this, b, pfocus);
    if (pfocus && pfocus->pview()) {
      event_focus evt(b, FOCUS_OUT, cause, postfactum);

      traverser<event_focus> trv(*this);

      evt.cmd = FOCUS_OUT | EVENT_SINKING;
      trv.traverse_parent_child(pfocus, common_p, evt);
      evt.cmd = FOCUS_OUT;
      trv.traverse_child_parent(pfocus, common_p, evt);

      // trv.traverse(pfocus,evt,false);

      if (evt.is_canceled()) return true;

      if (pfocus != focus_element) {
        // What? Someone too smart decided to change focus_element in LOST_FOCUS
        // handlers ...
        return true; // don't know what they wanted so get out of here.
      }
      // pfocus->dbg_report("lost focus ");
    }

    focus_element = b;

#if defined(CAN_WORK_AS_TABLET)
    bool nwk = focus_element && focus_element->wants_keyboard(*this);
    bool pwk = pfocus && pfocus->wants_keyboard(*this);
    if (nwk != pwk) {
      activate_keyboard_for(focus_element, nwk);
/*      if (nwk)
        virtual_keyboard::show_if_needed();
      else if (pwk)
        virtual_keyboard::dismiss_if_shown();
        */
    }
#endif

    on_focus_changed(pfocus, false);

    bool needs_ime = false;

    if (b) {
      event_focus            evt(pfocus, FOCUS_IN, cause, postfactum);
      traverser<event_focus> trv(*this);

      evt.cmd = FOCUS_IN | EVENT_SINKING;
      trv.traverse_parent_child(focus_element, common_p, evt);
      evt.cmd = FOCUS_IN;
      trv.traverse_child_parent(focus_element, common_p, evt);

      // trv.traverse(b,evt);

      if ((old_focus_element != focus_element) && !b->state.popup()) {
        ensure_visible(b, false);
      }
      old_focus_element = focus_element;

      needs_ime = !evt.is_canceled() && evt.need_ime;
      on_focus_changed(b, true);
      // focus_element->dbg_report("got focus ");
    }

    if (pfocus) {
      traverser<event_focus> trv(*this);
      event_focus            evt(pfocus, LOST_FOCUS, cause, postfactum);
      trv.traverse(pfocus, evt);
      pfocus->state_focus_off(*this);
    }

    if (focus_element) {
      traverser<event_focus> trv(*this);
      event_focus evt(focus_element, GOT_FOCUS, cause, postfactum);
      trv.traverse(focus_element, evt);
      needs_ime = !evt.is_canceled() && evt.need_ime;
#ifdef _DEBUG
//      focus_element->dbg_report("do_set_focus\n");
#endif
    }

    enable_ime(needs_ime);

    return true;
  }

  void view::on_focus_changed(element *pfocus, bool got) {

#if defined(OSX)
    if (!focus_element && pfocus && windows.size()) close_popup_tree(doc());
#else
    if (pfocus && !got) {
      if (!focus_element)
        close_popup_tree(pfocus);
      else if (!focus_element->belongs_to(*this, pfocus, true))
        close_popup_tree(pfocus);
    }
#endif
  }

  bool view::on_focus(bool got) {
    if (!doc()) return false;

    auto notify = [this](event_focus &evt) {
      behavior_h pc = this->ground_behavior;
      while (pc.is_defined()) {
        if (pc->will_handle(HANDLE_FOCUS) && pc->on(*this, doc(), evt))
          evt.cmd |= EVENT_HANDLED;
        behavior_h next = pc->next;
        pc              = next;
      }
    };

    if (got) {
      if (is_setting_focus) // that on_focus call is originated from set_focus()
        return true;

      helement pfocus = old_focus_element;
      if (!pfocus || !pfocus->doc()) {
        if (view_type() == VIEW_DIALOG)
          pfocus = find_first(*this, doc(), WCHARS("[role='default-button']"), true);
        if (!pfocus) {
          set_focus_on(FOCUS_FIRST);
          event_focus evt(focus_element, FOCUS_IN, BY_CODE, true);
          notify(evt);
          return true;
        }
      }
      if (pfocus) {
        set_focus(pfocus, BY_CODE);
        event_focus evt(focus_element, FOCUS_IN, BY_CODE, true);
        notify(evt);
      }
    } else {
#ifdef _DEBUG
      //if (focus_element) focus_element->dbg_report("window lost focus");
#endif
      set_focus(0, BY_CODE, true);
      event_focus evt(focus_element, FOCUS_OUT, BY_CODE, true);
      notify(evt);
    }
    return true;
  }

  selection_ctx *view::get_selection_ctx() {
    if (!focus_element) return nullptr;
    return get_selection_ctx();
  }

} // namespace html
