#pragma once

#include "html.h"

namespace html {

#ifdef USE_TOUCH
    bool view::handle_touch(array<touch_point> touch_points, uint alts)
    {
      if (touch_points.length() == 0) {
        if (is_touched) {
          is_touched = false;
          bool r = handle_touch_end(alts);
          //touch_points.clear(); // cause double tap
          return r;
        }
      }
      touch_move tm = { get_ticks(), std::move(touch_points) };
      touch_history.push_front(tm);
      if (!is_touched) {
        is_touched = true;
        return handle_touch_start(alts);
      }
      else
        return handle_touch_move(alts);
    }

    bool view::handle_touch_end(uint alts) {
      alts |= html::ALT_TOUCH;
      is_touched = false;
      //point pt = touch_history[0].points[0].pos;
      on_mouse(MOUSE_TOUCH_END, 0, alts, mouse_pos);
      return true;
    }

    bool view::handle_touch_start(uint alts) {
      alts |= html::ALT_TOUCH;
      is_touched = true;
      //point pt = touch_history[0].points[0].pos;
      on_mouse(MOUSE_TOUCH_START, 0, alts, mouse_pos);
#if 0
      //point pt = touch_history[0].points[0].pos;

      event_touch evt(get_target_touch_element(mouse_pos, doc()), TOUCH_START, mouse_pos);
      traverse_mouse(evt.target, evt);

      touch_was_double_tap = false;

      if (touch_last_start_time.is_defined()) {
        uint delta_time = touch_history[0].ticks - touch_last_start_time;
        bool is_double_tap =
               delta_time > 0 
            && delta_time < 250
            && distance(touch_last_start_pos, touch_history[0].points[0].pos) < 30;
        //if (this.isDoubleTap) clearTimeout(this.singleTapTimeout);
        
        if (is_double_tap) {
          touch_was_double_tap = true;
          event_touch evt(get_target_touch_element(mouse_pos, doc()), TOUCH_DOUBLE_TAP, mouse_pos);
          traverse_mouse(evt.target, evt);
        }
      }
      touch_last_start_time = touch_history[0].ticks;
      touch_last_start_pos = touch_history[0].points[0].pos;
#endif
      return true;
    }

    bool view::handle_touch_move(uint alts) {
      alts |= html::ALT_TOUCH;
      return true;
    }

    element*  view::get_target_touch_element(point pt, element* fallback)
    {
      helement over_element = mouse_over_element;
      helement capture_element = mouse_capture_element;
      if (!capture_element) capture_element = event_capture_element;

      element *b = nullptr;

      if (capture_element)
      {
        if (mouse_capture_strict ||
          capture_element->get_style(*this)->display == display_inline)
          b = over_element = capture_element;
        else {
          b = find_element(pt);
          if (b && !b->belongs_to(*this, capture_element, true)) b = nullptr;
        }
        if (!b) b = capture_element;
      }
      else
      {
        b = find_element(pt);
      }
      return b ? b : fallback;
    }

#endif

}

