#ifndef __html_symbols_h__
#define __html_symbols_h__

#include "tool/tool.h"
#include "gool/gool.h"

namespace html {
  // TAG NAMES only symbol table!
  struct style;
  struct style_prop_list;

  namespace tag {
    using namespace tool;

    typedef uint_v symbol_t;

    symbol_t symbol(const string &str, bool create = true); // intern it and
                                                            // return id. if not
                                                            // found returns
                                                            // undefined;
    symbol_t symbol(chars str, bool create = true); // intern it and return id.
                                                    // if not found returns
                                                    // undefined;
    string symbol_name(symbol_t id);
    void   clear_all();

    // default value of display:
    enum TAG_TYPE {
      UNKNOWN_TAG,
      INLINE_BLOCK_TAG,
      BLOCK_TAG,
      INLINE_TAG,
      TABLE_TAG,
      TABLE_BODY_TAG,
      TABLE_ROW_TAG,
      TABLE_CELL_TAG,
      INFO_TAG
    };
    // parsing model:
    enum PMODEL_TYPE {
      PMODEL_NORMAL,  // normal head/tail: <div></div>
      PMODEL_NO_TAIL, // no tail: <img>, <br>, <hr>
      PMODEL_CDATA,   // cdata inside
    };
    // see http://dev.w3.org/html5/markup/common-models.html
    enum CMODEL_TYPE {
      CMODEL_BLOCKS,      // 7.1. Flow elements
      CMODEL_INLINES,     // 7.3. Phrasing elements
      CMODEL_TRANSPARENT, // like <del>, <a>, etc.
      CMODEL_TEXT,        // only plain text
      CMODEL_TABLE,       // table components inside
      CMODEL_EMPTY,       // img, br, hr
    };

    struct tag_def {
      string   name;
      TAG_TYPE tag_type;
      // bool     can_be_open; // IMG, INPUT, HR, BR are true
      PMODEL_TYPE      pmodel;
      CMODEL_TYPE      cmodel;
      handle<style_prop_list> plist;
      tag_def() : tag_type(UNKNOWN_TAG), pmodel(PMODEL_NORMAL), cmodel(CMODEL_BLOCKS) {}
    };

    bool add_definition(const char *name, TAG_TYPE type, PMODEL_TYPE pmodel,CMODEL_TYPE  cmodel,html::style_prop_list *ps = 0); // add new type of elements

    TAG_TYPE type(symbol_t t);
    void     all_formatting_spans(
            array<tag::symbol_t> &tlist); // all spans except of <a>
    // bool can_be_open(symbol_t idx);
    PMODEL_TYPE parsing_model(symbol_t t);
    CMODEL_TYPE content_model(symbol_t t);
    inline bool require_block_container(symbol_t t) {
      TAG_TYPE tt = type(t);
      return tt == BLOCK_TAG || tt == TABLE_TAG || tt == TABLE_BODY_TAG ||
             tt == TABLE_ROW_TAG || tt == TABLE_CELL_TAG;
    }

    style_prop_list *intrinsic_style(symbol_t sym, bool for_svg);

#define TAGDEF(p1, p2, p3, p4) T_##p1,
    enum symbols {
#include "html-tag-defs.inl"
    };
#undef TAGDEF

    void init();
    void init_styles(hash_table<string, tag_def> &tbl);
  } // namespace tag

  namespace attr {

    using gool::name::symbol_t;
    using gool::name::symbol;
    using gool::name::symbol_name;

/*    typedef uint_v symbol_t;

    symbol_t symbol(
        chars str); // intern it and return id. if not found returns undefined;
    symbol_t symbol(const string &str); // intern it and return id. if not found
                                        // returns undefined;
    string symbol_name(symbol_t sym);
    */

#define ATTDEF(p1) a_##p1,
#define ATTDEF2(p1, p2) a_##p1,
    enum att_symbols {
#include "html-attr-defs.inl"
    };
#undef ATTDEF
#undef ATTDEF2

  } // namespace attr

  void init_symbols(bool on);

} // namespace html

#endif
