#include "html.h"

namespace html {
  namespace tag {
    using namespace tool;

    static hash_table<string, tag_def> table(128);

    symbol_t symbol(const string &str, bool create) {
      critical_section cs(html::lock);
      string           ucs(str);
      ucs.to_lower();

      int max_idx = table.size();
      int idx = table.get_index(ucs, create);

      if (!create)
        return idx < 0 ? symbol_t(0) : symbol_t(idx);

      if (idx == max_idx) { // new definition was created
        table(max_idx).name = ucs;
        //BAD (SVG needs it undefined): table(max_idx).istyle = table(0).istyle; // initialize it by _UNKNOWN style
      }
      return symbol_t(idx);
    }
    symbol_t symbol(chars str, bool create) {
      string           s(str);
      return symbol(s,create);
    }

    string symbol_name(symbol_t idx) {
      critical_section cs(html::lock);
      if (idx >= uint(table.size())) idx = 0;
      return table.elements()[idx].name;
    }

    void clear_styles() {
      for (int n = 0; n < table.size(); ++n)
        table.elements()[n].plist = nullptr;
    }

    bool add_definition(const char *name, TAG_TYPE type, PMODEL_TYPE pmodel,CMODEL_TYPE cmodel, style_prop_list *ps) {
      critical_section cs(html::lock);
      string           ucs(name);
      ucs.to_lower();
      int idx = table.get_index(ucs, false);
      if (idx >= 0) {
        table.elements()[idx].plist = ps;
        return false;
      }
      tag_def td;
      td.tag_type = type;
      td.pmodel   = pmodel;
      td.cmodel   = cmodel;
      td.name     = ucs;
      td.plist    = ps;
      table[ucs]  = td;
      return true;
    }

    TAG_TYPE type(symbol_t idx) {
      // critical_section cs(html::lock);
      if (idx >= uint(table.size())) return INLINE_TAG;
      return table.elements()[idx].tag_type;
    }

    void all_formatting_spans(array<tag::symbol_t> &tlist) {
      for (uint idx = 0; idx < table.length(); ++idx) {
        if ((type(idx) == INLINE_TAG) && (idx != T_A)) tlist.push(idx);
      }
    }

    PMODEL_TYPE parsing_model(symbol_t idx) {
      // critical_section cs(html::lock);
      if (idx >= uint(table.size())) return PMODEL_NORMAL;
      return table.elements()[idx].pmodel;
    }
    CMODEL_TYPE content_model(symbol_t idx) {
      // critical_section cs(html::lock);
      if (idx >= uint(table.size())) return CMODEL_BLOCKS;
      return table.elements()[idx].cmodel;
    }

    /*bool  can_be_open(symbol_t idx)
    {
      critical_section cs(html::lock);
      if(idx >= uint(table.size()) ) return false;
      return table.elements()[idx].can_be_open;
    }*/

    void init() {
#define TAGDEF(p1, p2, p3, p4) add_definition(#p1, p2, p3, p4, 0);
#include "html-tag-defs.inl"
#undef TAGDEF
      init_styles(table);
      //assert(table(T_HTML).istyle->display == display_block);
    }

    style_prop_list *intrinsic_style(symbol_t sym, bool for_svg) {
      int i = tool::limit((int)sym, (int)0, (int)table.size() - 1);
      style_prop_list * ps = table(i).plist;
      if( !ps && !for_svg)
        return table(T__UNKNOWN).plist;
      return ps;
    }
  } // namespace tag

  namespace attr {
/*
    static tool::lookup_tbl<string, true> symtab;

    symbol_t symbol(const char *name) {
      critical_section cs(html::lock);
      return symtab[name] - 1;
    }

    symbol_t symbol(chars name) {
      critical_section cs(html::lock);
      assert(name.start[name.length] == 0); // it has to be zstring
      return symtab[name.start] - 1;
    }

    symbol_t symbol(const tool::string &name) {
      critical_section cs(html::lock);
      return symtab[name] - 1;
    }
    string symbol_name(symbol_t sym) {
      critical_section cs(html::lock);
      uint             n = sym + 1;
      if (n > symtab.size()) n = 1;
      return symtab(n);
    }
*/

    void init() {
#define ATTDEF(p1) symbol(#p1);
#define ATTDEF2(p1, p2) symbol(p2);
#include "html-attr-defs.inl"
#undef ATTDEF
#undef ATTDEF2
    }

  } // namespace attr

  namespace cssa {
    static tool::lookup_tbl<string, false, STYLE_CHANGE_TYPE> symtab;

    symbol_t symbol(const char *name) {
      critical_section cs(html::lock);
      auto sym = symtab[name];
      return sym - 1;
    }

    symbol_t symbol(const char *name, STYLE_CHANGE_TYPE ct) {
      critical_section cs(html::lock);
      auto sym = symtab[name];
      symtab.data(sym) = ct;
      return sym - 1;
    }
    string symbol_name(symbol_t sym) {
      //critical_section cs(html::lock);
      uint n = sym + 1;
      if (n > symtab.size()) n = 1;
      return symtab(n);
    }

    STYLE_CHANGE_TYPE symbol_change_type(symbol_t sym)
    {
      uint n = sym + 1;
      if (n > symtab.size()) return STYLE_CHANGE_TYPE();
      return symtab.data(n);
    }

    uint_v lookup(const char *str) {
      return symtab(str);
    }

    void init() {
#define CSSA(n, c, cm) symbol(c,cm);
#include "html-style-atts.inl"
#undef CSSA
    }
  }; // namespace cssa

  void init_symbols(bool on) {
    static bool inited = false;
    if (on) {
      if (inited) return;
      inited = true;
      tag::init();
      attr::init();
      cssa::init();
    } else if (inited) {
      inited = false;
      tag::clear_styles();
    }
  }

} // namespace html
