#if !defined(__html_svg_h__) && defined(SVG_SUPPORT)
#define __html_svg_h__

#include "html-document.h"
#include "html-layout.h"

namespace html {

  struct block_svg;
  struct svg_document;

  extern element *find_svg_element(view &v, element *self, gool::point zpos,
                                   bool exact);
  extern element *find_svg_child_element(view &v, element *cont,
                                         point at /*at is this relative*/,
                                         bool  exact);

  bool parse_d_path(gool::path* path, wchars d);
  bool parse_d_path(gool::path* path, value v);

  struct svg_root_data;

  struct block_svg_element : public block {
    DEFINE_TYPE_ID_DERIVED(block_svg_element,block);

    enum { LAYOUT_TYPE = flow_svg_element };

    struct layout_data : public block::layout_data {
      typedef block::layout_data super;
      virtual flow_e          type() const { return flow_svg_element; }
      layout_data(block_svg_element *b)
          : super(b), require_init(true), stroke_join(), stroke_cap(),
            stroke_width(1), stroke_dashoffset(0) {}
      virtual ~layout_data() {}

      virtual void drop() {
        super::drop();
        path.clear();
        fill.clear();
        stroke.clear();
        require_init = true;
      }

      bool require_init;

      gool::rectf bounds;

      handle<gool::path>  path;
      gool::affine_mtx_f  xform;
      handle<gool::brush> fill;
      handle<gool::brush> stroke;
      float               stroke_width;
      gool::LINE_JOIN     stroke_join;
      float               stroke_miterlimit;
      gool::CAP_STYLE     stroke_cap;
      array<float>        stroke_dasharray;
      float               stroke_dashoffset;

      virtual bool is_valid() { return true; }
    };

    block_svg_element(tag::symbol_t st) : super(st) {}
    block_svg_element(NO_INIT ni) : super(ni) {}

    static block_svg_element *setup_on(view &v, element *el);

    virtual bool is_svg_element() const { return true; }

    virtual flow_e layout_type() const override {
      return flow_e(LAYOUT_TYPE);
    }
    virtual element *nearest_known_box();

    virtual bool is_sensitive_attr(const name_or_symbol &ns, bool &rem) {
      return true;
    }

    virtual void init(view &v);

    void init_g(view &v, element *that, const attribute_bag &atts,
                svg_root_data *prd, element *root, handle<layout_data> ld);
    void init_path(view &v, element *that, const attribute_bag &atts,
                   svg_root_data *prd, element *root, handle<layout_data> ld);
    void init_rect(view &v, element *that, const attribute_bag &atts,
                   svg_root_data *prd, element *root, handle<layout_data> ld);
    void init_circle(view &v, element *that, const attribute_bag &atts,
                     svg_root_data *prd, element *root, handle<layout_data> ld);
    void init_ellipse(view &v, element *that, const attribute_bag &atts,
                      svg_root_data *prd, element *root,
                      handle<layout_data> ld);
    void init_line(view &v, element *that, const attribute_bag &atts,
                   svg_root_data *prd, element *root, handle<layout_data> ld);
    void init_polyline(view &v, bool closed, element *that,
                       const attribute_bag &atts, svg_root_data *prd,
                       element *root, handle<layout_data> ld);
    void init_switch(view &v, element *that, const attribute_bag &atts,
                     svg_root_data *prd, element *root, handle<layout_data> ld);
    void init_use(view &v, svg_document *pd, element *that,
                  const attribute_bag &atts, svg_root_data *prd, element *root,
                  handle<layout_data> ld);

    // block_svg* svg_root() const;
    virtual rectf get_bounds(view &v);

    // void draw_element( view& v );
    virtual void render(view &v, graphics *pg, bool check_animator = true);
    gool::brush *get_brush(view &v, const ustring &id, opacity_v opacity);

    virtual point translate(view &v, point pos)
        override; // translate - from "dom pixels" to "screen pixels"
    virtual point inverse_translate(view &v,
                                    point pos) override; // inverse translate -
                                                         // to flat, non
                                                         // transformed position
                                                         // : "screen pixels" to
                                                         // "DOM pixels"

    virtual element *find_element(view &v, point zpos /*at is this relative*/,
                                  bool exact = true) override;
    virtual element *
    find_child_element(view &v, point at /*at is this relative*/, bool exact) {
      return find_svg_child_element(v, this, at, exact);
    }

    virtual bool on_set_attr(uint att_sym, const ustring &val)
        override; // return true if it is known attr and some action was made
    virtual bool on_remove_attr(uint att_sym, const ustring &val)
        override; // return true if it is known attr and some action was made

    void         on_style_changed(view &    v,
                                  document *pd) override; // style changed "event"
    virtual void stray(view &v) override {
      layout_data *ld = ldata.ptr_of<layout_data>();
      ld->path        = nullptr;
      ld->fill        = nullptr;
      ld->stroke      = nullptr;
      super::stray(v);
    }

    //virtual void fixup_style(view &v, document *pd, style &s) override;
  };

  struct svg_root_data {
    bool           require_init;
    pointf         origin;
    sizef          dimension;
    pointf         vbmin;
    sizef          vbdim; // in dips!
    rect_placement drawing_placement;

    svg_root_data() : require_init(true) {}

    void init(view &v, element *self);
    void init_fragment(view &v, svg_document *self, const string &fragment);

    rectf viewbox() const { return rectf(vbmin, vbdim); }
    rectf get_bounds(view &v, element *self) { return rectf(viewbox().size()); }
    void  draw_content(view &v, element *self, graphics *pg, point pos,
                       bool clip = true);

    // virtual bool is_fore_image_provider(view& v) const { return true; }

    void calc_intrinsic_widths(view &v, element *self);

    int_v auto_width(view &v, element *self);
    int_v auto_height(view &v, element *self);

    bool on_set_attr(element *self, uint att_sym,
                     const ustring &val); // return true if it is known attr and
                                          // some action was made
    bool on_remove_attr(element *self, uint att_sym); // return true if it is
                                                      // known attr and some
                                                      // action was made

    point
          translate(view &v, element *self,
                    point pos); // translate - from "dom pixels" to "screen pixels"
    point inverse_translate(view &v, element *self,
                            point pos); // inverse translate - to flat, non
                                        // transformed position : "screen
                                        // pixels" to "DOM pixels"
  };

  struct svg_document : public document {
    DEFINE_TYPE_ID_DERIVED(svg_document,document);

    hstyle default_style;

    enum { LAYOUT_TYPE = flow_svg };

    struct layout_data : public document::layout_data, public svg_root_data {
      typedef block::layout_data super;
      virtual flow_e          type() const { return flow_svg; }
      layout_data(svg_document *b) : document::layout_data(b) {}
      ~layout_data() {}

      virtual bool is_valid() { return true; }
    };

    svg_document(const string &url, tag::symbol_t st = tag::T_SVG)
        : super(url, st) {
      ldata = new layout_data(this);
    }
    svg_document(NO_INIT ni) : super(ni) {}

    virtual bool is_svg_document() const { return true; }

    virtual void setup_layout(view &v) { ldata->is_initialized = true; }

    virtual flow_e layout_type() const override {
      return flow_e(LAYOUT_TYPE);
    }

    virtual element *nearest_known_box() { return this; }

    virtual void init(view &v) { ldata.ptr_of<layout_data>()->init(v, this); }

    virtual style *get_base_style(view &v) override {
      if (default_style) return default_style;
      if (parent) return parent->get_style(v);
      return v.get_default_style();
    }

    void set_default_colors(view &v, color_v fill_color, color_v stroke_color) {
      if (default_style && default_style->fill_color == fill_color &&
          default_style->stroke_color == stroke_color)
        return;

      if (!default_style) default_style = new style(*v.get_default_style());
      default_style->fill_color   = fill_color;
      default_style->stroke_color = stroke_color;

      drop_styles(v);
    }

    virtual void draw_content(view &v, graphics *pg, point pos,
                              bool clip = true) override {
      ldata.ptr_of<layout_data>()->init(v, this);
      ldata.ptr_of<layout_data>()->draw_content(v, this, pg, pos, clip);
    }

    virtual void calc_intrinsic_widths(view &v) override {
      ldata.ptr_of<layout_data>()->calc_intrinsic_widths(v, this);
      size sz        = ldata.ptr_of<layout_data>()->dimension;
      ldata->dim_min = ldata->dim_max = sz;
      // super::calc_intrinsic_widths(v);
    }

    virtual int layout_width(view &v, int width) override {
      calc_intrinsic_widths(v);
      if (ldata->dim.x != width) {
        // ldata.ptr_of<layout_data>()->require_init = true;
        ldata->dim.x                                = width;
        rect crect                                  = client_rect(v);
        size inner                                  = crect.size();
        /*ldata->client_dim.x =*/ldata->inner_dim.x = inner.x;
        /*ldata->client_dim.y =*/ldata->inner_dim.y = 0;
      }
      return int(ldata.ptr_of<layout_data>()->dimension.y);
    }
    virtual int layout_height(view &v, int height) override {
      if (ldata->dim.y != height) {
        // ldata.ptr_of<layout_data>()->require_init = true;
        ldata->dim.y                                = height;
        size inner_dim                              = client_rect(v).size();
        /*ldata->client_dim.y =*/ldata->inner_dim.y = inner_dim.y;
      }
      return ldata->dim.x;
    }

    virtual point translate(view &v, point pos) {
      return ldata.ptr_of<layout_data>()->translate(v, this, pos);
    }
    virtual point inverse_translate(view &v, point pos) {
      return ldata.ptr_of<layout_data>()->inverse_translate(v, this, pos);
    }

    virtual element *find_element(view &v, point zpos /*at is this relative*/,
                                  bool exact = true) {
      return find_svg_element(v, this, zpos, exact);
    }
    virtual element *
    find_child_element(view &v, point at /*at is this relative*/, bool exact) {
      return find_svg_child_element(v, this, at, exact);
    }

    virtual int_v auto_width(view &v) override {
      return ldata.ptr_of<layout_data>()->auto_width(v, this);
    }
    virtual int_v auto_height(view &v) override {
      return ldata.ptr_of<layout_data>()->auto_height(v, this);
    }

    virtual bool on_set_attr(uint att_sym, const ustring &val)
        override; // return true if it is known attr and some action was made
    virtual bool on_remove_attr(uint att_sym, const ustring &val)
        override; // return true if it is known attr and some action was made
  };

  // embedded SVG element
  struct block_svg : public block {
    DEFINE_TYPE_ID_DERIVED(block_svg,block);

    enum { LAYOUT_TYPE = flow_svg };

    struct layout_data : public block::layout_data, public svg_root_data {
      typedef block::layout_data super;
      virtual flow_e          type() const { return flow_svg; }
      layout_data(block_svg *b) : block::layout_data(b) {}
      ~layout_data() {}
      virtual bool is_valid() { return true; }
    };

    block_svg(tag::symbol_t st) : super(st) {}
    block_svg(NO_INIT ni) : super(ni) {}

    virtual bool is_svg_document() const { return true; }

    static block_svg *setup_on(view &v, element *el);

    virtual flow_e layout_type() const override {
      return flow_e(LAYOUT_TYPE);
    }
    virtual element *nearest_known_box() { return this; }

    virtual void init(view &v) { ldata.ptr_of<layout_data>()->init(v, this); }

    virtual void draw_content(view &v, graphics *pg, point pos,
                              bool clip) override {
      ldata.ptr_of<layout_data>()->init(v, this);
      ldata.ptr_of<layout_data>()->draw_content(v, this, pg, pos, clip);
    }

    virtual void calc_intrinsic_widths(view &v) override {
      ldata.ptr_of<layout_data>()->calc_intrinsic_widths(v, this);
    }

    virtual int layout_width(view &v, int width) override {
      if (ldata->dim.x != width) {
        // ldata.ptr_of<layout_data>()->require_init = true;
        ldata->dim.x       = width;
        rect crect         = client_rect(v);
        size inner         = crect.size();
        ldata->inner_dim.x = inner.x;
        ldata->inner_dim.y = 0;
      }
      return int(ldata.ptr_of<layout_data>()->dimension.y);
    }
    virtual int layout_height(view &v, int height) override {
      if (ldata->dim.y != height) {
        // ldata.ptr_of<layout_data>()->require_init = true;
        ldata->dim.y       = height;
        size inner_dim     = client_rect(v).size();
        ldata->inner_dim.y = inner_dim.y;
        ldata->dim.y       = height;
      }
      return ldata->dim.x;
    }

    virtual point translate(view &v, point pos) override {
      return ldata.ptr_of<layout_data>()->translate(v, this, pos);
    }
    virtual point inverse_translate(view &v, point pos) override {
      return ldata.ptr_of<layout_data>()->inverse_translate(v, this, pos);
    }

    virtual element *find_element(view &v, point zpos /*at is this relative*/,
                                  bool exact = true) override {
      return find_svg_element(v, this, zpos, exact);
    }
    virtual element *find_child_element(view &v,
                                        point at /*at is this relative*/,
                                        bool  exact) override {
      return find_svg_child_element(v, this, at, exact);
    }

    virtual int_v auto_width(view &v) override {
      return ldata.ptr_of<layout_data>()->auto_width(v, this);
    }
    virtual int_v auto_height(view &v) override {
      return ldata.ptr_of<layout_data>()->auto_height(v, this);
    }

    virtual bool on_set_attr(uint att_sym, const ustring &val)
        override; // return true if it is known attr and some action was made
    virtual bool on_remove_attr(uint att_sym, const ustring &val)
        override; // return true if it is known attr and some action was made
  };

  class svg_image // svg image wrapper
      : public gool::image {
    friend class svg_image_fragment;
    // tool::string _name;
    handle<svg_document> doc;

    struct cache_item {
      handle<gool::bitmap> bitmap;
      //handle<style>        host_style; - WRONG will create cyclic reference to this image
      uint_ptr             host_style_id;
      
      ~cache_item() { bitmap.clear(); /* bug in GCC, bad code generation without this */ }
    };

    tool::circular_buffer<cache_item> cache;

    svg_image() : cache(8) {}
    svg_image(const svg_image &);

  public:
    svg_image(svg_document *pdoc) : cache(8), doc(pdoc) {}
    // static svg_image* load(view& v, bytes data, const string& url);

    virtual bool is_valid() const { return doc.ptr() != 0; }
    virtual bool is_transparent() const { return true; } // has alpha bits
    virtual bool is_animated(uint_ptr /*site_id*/) const { return false; }

    virtual image *get_fragment(const string &fragment_id);

    virtual handle<bitmap> get_bitmap(graphics *pg, size sz) override;

    virtual void draw(graphics *gfx, rect dst, rect src, byte opacity) {
      draw(gfx, rectf(dst), src, opacity);
    }
    virtual void draw(graphics *gfx, rectf dst, rect src, byte opacity);
    virtual void expand(graphics * /*gfx*/, const rect & /*dst*/,
                        const SECTION_DEFS & /*sds*/) {
      assert(false);
    }

    virtual size dimension() const;

    virtual size dim() const { return dimension(); }
    virtual size dim(const rect & /*for_dst*/) const { return dim(); }
    virtual void drop_cache();

    virtual image *mapped_left_to_right();
    virtual image *mapped_top_to_right();
  };

  class svg_image_fragment : svg_image {
    string        fragment;
    svg_root_data root_data;

  protected:
    friend class svg_image;
    svg_image_fragment(const svg_image *base, const string &fragment);

  public:
    virtual image * get_fragment(const string &fragment_id) override { return this; }
    virtual handle<bitmap> get_bitmap(graphics *pg, size sz) override;
    virtual size    dimension() const override;
  };

} // namespace html

#endif
