#include "html.h"

namespace html {

#ifdef SVG_SUPPORT

  // parse standalone SVG document
  bool parse_svg(html::document *pd, bytes data, const string &url,
                 handle<svg_document> &pdoc) {
    if (!pd) return false;
    istream inp(data, url, false);

    if (!is_svg_markup(inp)) return false;

    inp.set_utf8_encoding();

    handle<view> pv = pd->pview();
    if (!pv) return false;

    pdoc = new svg_document(url);
    // WRONG, svg images can be shared among multiple documents: pdoc->parent = pd;
    pdoc->pview(pv);

    //pdoc->flags.state_initialized;

    // SCRIPT IS NOT USED in SVG loaded in images! pv->on_load_start(pdoc);
    pdoc->allow_own_scripts = false;

    html::parse_html(*pv, inp, pdoc);
    pdoc->setup_layout(*pv);

    // SCRIPT IS NOT USED in SVG loaded in images! pv->on_load_end(pdoc,false);

    pdoc->check_layout(*pv);

    return true;
  }
    
  handle<bitmap> svg_image::get_bitmap(graphics *pg, size sz) {
    //argb fill_color;
    //argb stroke_color;

    if (sz.empty())
      return nullptr;

    view *pv = doc->pview();
    if (!pv) 
      return nullptr;

    sz *= pv->pixels_scaling();

    //ustring theme;

    element* pel = pg ? pg->current_element : element::drawing_element;
    handle<style> cs;

    uint_ptr hid = 0;

    if (pel) {
#ifdef DEBUG
      if (pel->is_id_test())
        pel = pel;
#endif // DEBUG
      cs = pel->get_style(*pv);
      hid = cs->hash();
      //hid = cs->is_unique() ? cs->hash() : uint_ptr(cs);
      //fill_color      = cs->fill_color.to_argb(pel);
      //stroke_color    = cs->stroke_color.to_argb(pel);
      //theme           = pel->get_theme();
    }
    else {
      //assert(false);
    }

    for (int n = cache.size() - 1; n >= 0; --n) {
      const cache_item &ci = cache[n];
      //if (ci.bitmap->dimension() == sz && cs && *ci.host_style == *cs )
      if (ci.bitmap->dimension() == sz && ci.host_style_id == hid)
        return ci.bitmap;
    }
        
    cache_item ci;
    ci.host_style_id = hid;
    
    if (pel) {
      doc->drop_styles(*pv);
      doc->parent = pel;
      if (cs->fill_color.is_defined() || cs->stroke_color.is_defined()) {
        argb fill_color = cs->fill_color.to_argb();
        argb stroke_color = cs->stroke_color.to_argb();
        doc->set_default_colors(*pv, fill_color, stroke_color);
      }
      doc->get_style(*pv);
    }
    
    ci.bitmap = new bitmap(sz, true, true);
    if (ci.bitmap)
    {
      {
        handle<graphics> gfx = pv->app->create_bitmap_bits_graphics(ci.bitmap, argb(0, 0, 0, 0));
        if (!gfx) return nullptr;
        doc->measure(*pv, sz);
        doc->draw_content(*pv, gfx, point(0, 0));
      }
      cache.push(ci);
#if 0 && defined(DEBUG_DRAW_PIPELINE)
      if (ci.bitmap->draws_nothing())
        view::debug_printf(html::OT_DOM, html::OS_ERROR,
          "SVG image draws nothing, bitmap %d %d for %d %d, "
          "pixmap size: %d, colors %x %x",
          ci.bitmap->dim().x, ci.bitmap->dim().y, sz.x, sz.y,
          ci.bitmap->get_bits().length, color(ci.fill_color),
          color(ci.stroke_color));
#endif
    }
    doc->parent = nullptr;
    return ci.bitmap;
  }

  void svg_image::draw(graphics *gfx, rectf dst, rect src, byte opacity) {
    // assert(0);
    handle<bitmap> pbmp = get_bitmap(gfx, dst.size());
    if (pbmp) pbmp->draw(gfx, dst, pbmp->dim(), opacity);
  }

  size svg_image::dimension() const {
    if (doc) {
      view *pv = doc->pview();
      size  sz;
      sz.x = doc->auto_width(*pv);
      sz.y = doc->auto_height(*pv);
      return sz;
    }
    return size(10);
  }

  void svg_image::drop_cache() {
    cache.clear();
  }

  image *svg_image::mapped_left_to_right() { return this; }
  image *svg_image::mapped_top_to_right() { return this; }

  image *svg_image::get_fragment(const string &fragment_id) {
    return new svg_image_fragment(this, fragment_id);
  }

  svg_image_fragment::svg_image_fragment(const svg_image *base,
                                         const string &   fragment) {
    doc      = base->doc;
    view *pv = doc->pview();
    if (pv) root_data.init_fragment(*pv, doc, fragment);
  }

  /*void svg_image_fragment::draw(graphics* gfx, rectf dst, rect src, byte
  opacity)
  {
    view* pv = doc->pview();
    if(pv)
      root_data.draw_content(*pv,doc,gfx,
  }
  */
  handle<bitmap> svg_image_fragment::get_bitmap(graphics *pg, size sz) {
    //argb fill_color;
    //argb stroke_color;

    view *pv = doc->pview();
    if (!pv) return nullptr;

    const style *cs = nullptr;
    uint_ptr hid = 0;

    element *pel = pg->current_element;

    if (pel = pg->current_element) {
      cs = pel->get_style(*pv);
      hid = cs->hash();
      //fill_color      = cs->fill_color.to_argb(pel);
      //stroke_color    = cs->stroke_color.to_argb(pel);
    }

    for (int n = cache.size() - 1; n >= 0; --n) {
      const cache_item &ci = cache[n];
      //if (ci.bitmap->dimension() == sz && cs && *ci.host_style == *cs)
      if (ci.bitmap->dimension() == sz && ci.host_style_id == hid)
        return ci.bitmap;
    }

    cache_item ci;
    ci.host_style_id = hid;

    //if (!fill_color.is_transparent() && !stroke_color.is_transparent())
    //  doc->set_default_colors(*pv, fill_color, stroke_color);

    if (pel) {
      doc->drop_styles(*pv);
      doc->parent = pel;
      doc->get_style(*pv);
    }

    ci.bitmap = new bitmap(sz, true, false);
    {
      handle<graphics> gfx =
          pv->app->create_bitmap_graphics(pg, ci.bitmap, argb(0, 0, 0, 0));
      if (gfx) {
        doc->measure(*pv, sz);
        root_data.draw_content(*pv, doc, gfx, point(0, 0));
        cache.push(ci);
      }
    }
    return ci.bitmap;
  }

  size svg_image_fragment::dimension() const { return root_data.dimension; }
#endif
}

namespace gool {

#ifdef SVG_SUPPORT
  handle<image> svg_reader::read(html::document *pd) {

    if (!pd) return nullptr;

    bytes svg_preambula((const byte *)"<svg", 4);

    if (!this->data(0, 256).contains(svg_preambula)) {
      if (tool::url(this->url).ext() == CHARS("svg")) {
        html::view::debug_printf(
            html::OT_DOM, html::OS_WARNING,
            "svg file <%s> does not contain '<svg ' in first 256 bytes\n"
            "file preambula(256):%s\n",
            this->url.c_str(), string(this->data(0, 256)).c_str());
        if (!this->data(0, 1024).contains(svg_preambula)) return nullptr;
      } else
        return nullptr;
    }

    handle<html::svg_document> doc;

    if (html::parse_svg(pd, this->data, this->url, doc))
      return new html::svg_image(doc);
    return nullptr;
  }
#endif
}
