#include "html.h"

#if defined(PLATFORM_WINCE) || defined(EMULATE_WINCE)
#define PLATFORM_MEDIA_TYPE "handheld"
#else
#define PLATFORM_MEDIA_TYPE "all"
#endif

// extern bool get_stock_style_resource(char* &pbstart, char* &pbend);

#define PI 3.14159265358979323846

namespace html {
  using namespace tool;
  using namespace gool;

  static ustring s_none     = WCHARS("none");
  static ustring s_inherit  = WCHARS("inherit");
  static string  as_none    = CHARS("none");
  static string  as_inherit = CHARS("inherit");
  value          parse_value(const ustring &token);

  bool is_none_value(const value &val) { return val.is_none(); }
  bool is_auto_value(const value &val) {
    return val.is_auto() || (val.units() == value::as && val.is_length() && 
                             val._int() == size_v::special_values::$auto);
  }
  bool is_inherit_value(const value &val) {
    return val.is_inherit() || (val.units() == value::as && val.is_length() &&
                                val._int() == size_v::special_values::$inherit);
  }

  bool crack_image_value(document *pd, image_ref &id, value val);

  bool border_radius_8(rect_style& prs, slice<value> a_values) {
    slice<value> xr = a_values, yr;
    for (int n = 0; n < a_values.size(); ++n) {
      if (a_values[n].is_string() && a_values[n].get(W("")) == WCHARS("/")) {
        yr        = xr;
        xr.length = n;
        yr.prune(n + 1);
        break;
      }
    }

    switch (xr.length) {
    case 0:
      return false; // too bad, no values
    case 1: {
      size_v sz;
      length_value(sz, xr[0]);
      prs.border_radius[0] = prs.border_radius[1] = sz;
      prs.border_radius[2] = prs.border_radius[3] = sz;
      prs.border_radius[4] = prs.border_radius[5] = sz;
      prs.border_radius[6] = prs.border_radius[7] = sz;
      break;
    }
    case 2: {
      size_v sz1, sz2;
      length_value(sz1, xr[0]);
      length_value(sz2, xr[1]);
      prs.border_radius[0] = sz1;
      prs.border_radius[1] = sz1;
      prs.border_radius[2] = sz2;
      prs.border_radius[3] = sz2;
      prs.border_radius[4] = sz1;
      prs.border_radius[5] = sz1;
      prs.border_radius[6] = sz2;
      prs.border_radius[7] = sz2;
      break;
    }
    case 3: {
      size_v sz1, sz2, sz3;
      length_value(sz1, xr[0]);
      length_value(sz2, xr[1]);
      length_value(sz3, xr[2]);
      prs.border_radius[0] = sz1;
      prs.border_radius[1] = sz1;
      prs.border_radius[2] = sz2;
      prs.border_radius[3] = sz2;
      prs.border_radius[4] = sz3;
      prs.border_radius[5] = sz3;
      prs.border_radius[6] = sz1;
      prs.border_radius[7] = sz1;
      break;
    }
    case 4: {
      size_v sz1, sz2, sz3, sz4;
      length_value(sz1, xr[0]);
      length_value(sz2, xr[1]);
      length_value(sz3, xr[2]);
      length_value(sz4, xr[3]);
      prs.border_radius[0] = sz1;
      prs.border_radius[1] = sz1;
      prs.border_radius[2] = sz2;
      prs.border_radius[3] = sz2;
      prs.border_radius[4] = sz3;
      prs.border_radius[5] = sz3;
      prs.border_radius[6] = sz4;
      prs.border_radius[7] = sz4;
      break;
    }
    default: return false;
    }

    switch (yr.length) {
    case 0:
      return true; // ok, no y'es
    case 1: {
      size_v sz;
      length_value(sz, yr[0]);
      prs.border_radius[1] = sz;
      prs.border_radius[3] = sz;
      prs.border_radius[5] = sz;
      prs.border_radius[7] = sz;
      return true;
    }
    case 2: {
      size_v sz1, sz2;
      length_value(sz1, yr[0]);
      length_value(sz2, yr[1]);
      prs.border_radius[1] = sz1;
      prs.border_radius[3] = sz2;
      prs.border_radius[5] = sz1;
      prs.border_radius[7] = sz2;
      return true;
    }
    case 3: {
      size_v sz1, sz2, sz3;
      length_value(sz1, yr[0]);
      length_value(sz2, yr[1]);
      length_value(sz3, yr[2]);
      prs.border_radius[1] = sz1;
      prs.border_radius[3] = sz2;
      prs.border_radius[5] = sz3;
      prs.border_radius[7] = sz1;
      return true;
    }
    case 4: {
      size_v sz1, sz2, sz3, sz4;
      length_value(sz1, yr[0]);
      length_value(sz2, yr[1]);
      length_value(sz3, yr[2]);
      length_value(sz4, yr[3]);
      prs.border_radius[1] = sz1;
      prs.border_radius[3] = sz2;
      prs.border_radius[5] = sz3;
      prs.border_radius[7] = sz4;
      return true;
    }
    default: return false;
    }
  }

  bool border_radius(rect_style& prs, int corner, slice<value> a_values) {
    int n = corner * 2;
    if (a_values.size() == 1) {
      size_v sz;
      length_value(sz, a_values[0]);
      prs.border_radius[n] = prs.border_radius[n + 1] = sz;
      return true;
    } else if (a_values.size() == 2) {
      size_v sz1, sz2;
      length_value(sz1, a_values[0]);
      length_value(sz2, a_values[1]);
      prs.border_radius[n]     = sz1;
      prs.border_radius[n + 1] = sz2;
      return true;
    }
    return false;
  }

  bool border_radius(rect_style& prs, int corner, slice<value> a_values, bool vertical) {
    int    n = corner * 2 + (vertical ? 1 : 0);
    size_v sz;
    length_value(sz, a_values[0]);
    prs.border_radius[n] = sz;
    return true;
  }

  bool scroll_manner_value(value &v, const value &val) {

    if (val.is_none() || val.is_inherit()) {
      v = val;
      return true;
    }
    if (!val.is_function(WCHARS("scroll-manner")))
      return false;

    v = val;
    return true;
  }

  bool overflow_value(overflow_ev &v, value &sm, slice<value> values) {
    if (!v.set(values[0]))
      return false;
    if (values.size() > 1) 
      return scroll_manner_value(sm, values[1]);
    return true;
  }

  bool draggable_value(enum_v &v, const value &val) {
    if (!val.is_string()) {
      if (is_none_value(val)) {
        v = draggable_none;
        return true;
      } else if (is_inherit_value(val)) {
        v = enum_v::inherit_val();
        return true;
      }
      return false;
    }
    string s = val.to_string();
    if (s.length() == 0) return false;

    if (s == CHARS("copy-move"))
      v = draggable_copy_move;
    else if (s == CHARS("only-copy"))
      v = draggable_only_copy;
    else if (s == CHARS("only-move"))
      v = draggable_only_move;
    else
      return false;
    return true;
  }

  ustring draggable_value_string(const enum_v &v) {
    if (v.is_defined()) switch (int(v)) {
      case draggable_copy_move: return WCHARS("move-copy");
      case draggable_only_move: return WCHARS("only-move");
      case draggable_only_copy: return WCHARS("only-copy");
      case draggable_none: return s_none;
      }
    return ustring();
  }

  bool drop_value(enum_v &v, const value &val) {
    if (!val.is_string()) {
      if (is_inherit_value(val)) {
        v = enum_v::inherit_val();
        return true;
      }
      return false;
    }
    string s = val.to_string();
    if (s.length() == 0) return false;

    if (s == CHARS("insert"))
      v = drop_insert;
    else if (s == CHARS("recycle"))
      v = drop_recycle;
    else if (s == CHARS("append"))
      v = drop_append;
    else if (s == CHARS("prepend"))
      v = drop_prepend;
    else if (s == CHARS("replace"))
      v = drop_replace;
    else
      return false;
    return true;
  }

  ustring drop_value_string(const enum_v &v) {
    if (v.is_defined()) switch (int(v)) {
      case drop_insert: return WCHARS("insert");
      case drop_recycle: return WCHARS("recycle");
      case drop_append: return WCHARS("append");
      case drop_prepend: return WCHARS("prepend");
      case drop_replace: return WCHARS("replace");
      }
    return ustring();
  }

  bool cursor_value(const element_context& ctx, handle<cursor> &v, slice<value> a_values) {
    if (a_values.length == 3) {
      if (a_values[0].is_url() && a_values[1].is_int() && a_values[2].is_int()) {
        string t = a_values[0].get_url();
        size   hotspot(a_values[1].to_int(), a_values[2].to_int());
        v = ctx.pdoc()->load_cursor(t, &hotspot);
        return true;
      }
      return false;
    }

    value val = a_values[0];

    if (val.is_inherit()) {
      v = cursor::inherit;
      return true;
    }
    else if (val.is_url()) {
      string t = val.get_url();
      v = ctx.pdoc()->load_cursor(t);
      return true;
    } else if (val.is_none()) {
      v = cursor::system(cursor_none);
      return true;
    }
    else if (val.is_resource<gool::cursor>()) {
      v = val.get_resource<gool::cursor>();
      return true;
    } else if (!val.is_string()) {
      return false;
    }
    string s = val.to_string();
    if (s.length() == 0) return false;

    if (s == CHARS("auto"))
      v = cursor::system(cursor_auto);
    else if (s == CHARS("pointer"))
      v = cursor::system(cursor_pointer);
    else if (s == CHARS("default"))
      v = cursor::system(cursor_default);
    else if (s == CHARS("crosshair"))
      v = cursor::system(cursor_crosshair);
    else if (s == CHARS("move"))
      v = cursor::system(cursor_move);
    else if (s == CHARS("wait"))
      v = cursor::system(cursor_wait);
    else if (s == CHARS("help"))
      v = cursor::system(cursor_help);
    else if (s == CHARS("e-resize"))
      v = cursor::system(cursor_e_resize);
    else if (s == CHARS("ne-resize"))
      v = cursor::system(cursor_ne_resize);
    else if (s == CHARS("nw-resize"))
      v = cursor::system(cursor_nw_resize);
    else if (s == CHARS("n-resize"))
      v = cursor::system(cursor_n_resize);
    else if (s == CHARS("se-resize"))
      v = cursor::system(cursor_se_resize);
    else if (s == CHARS("sw-resize"))
      v = cursor::system(cursor_sw_resize);
    else if (s == CHARS("s-resize") || s == CHARS("ns-resize"))
      v = cursor::system(cursor_ns_resize);
    else if (s == CHARS("w-resize") || s == CHARS("ew-resize"))
      v = cursor::system(cursor_ew_resize);
    else if (s == CHARS("text"))
      v = cursor::system(cursor_text);
    else if (s == CHARS("no") || s == CHARS("no-drop"))
      v = cursor::system(cursor_no);
    else if (s == CHARS("drag-copy") || s == CHARS("copy"))
      v = cursor::system(cursor_drag_copy);
    else if (s == CHARS("drag-move"))
      v = cursor::system(cursor_drag_move);
    else
      return false;
    return true;
  }

  bool length_value(size_v &sz, const value &v, size_v::NUMERIC_CONVERSION number_cvt) {
    return sz.set(v, number_cvt);
  }
  
  ustring length_value_string(const size_v &sz) { return to_string(sz); }

  value length_value(const size_v &sz) {
    if (sz.is_undefined()) return value();
    if (sz.is_none()) return value::null_val();
    if (sz.unit == size_v::unit_type::as) return value(to_string(sz));
    return sz;
  }

  bool font_variant_value(style& s, slice<value> values) {
    int n = 0;
    for (auto v : values) {
      font_variant_ligatures_ev lg;
      if (lg.set(v)) {
        s.font_variant_ligatures.inherit(lg);
        ++n;
        continue;
      }
      font_variant_caps_ev cp;
      if (cp.set(v)) {
        s.font_variant_caps = cp;
        ++n;
      }
    }
    return n > 0;
  }

  bool image_position(size_v &v, const value &val) {
    if (length_value(v, val)) return true;
    if (val.is_string()) {
      string s = val.to_string();
      if (s == CHARS("left") || s == CHARS("top"))
        v.set_percents(0);
      else if (s == CHARS("center"))
        v.set_percents(50);
      else if (s == CHARS("right") || s == CHARS("bottom"))
        v.set_percents(100);
      else
        return false;
      return true;
    }
    return false;
  }
  bool image_positions(size_v &x, size_v &y, const value &val1, const value &val2) {
    bool xfirst = true;
    if (val1.is_string()) {
      string s = val1.to_string();
      if (s == CHARS("top") || s == CHARS("bottom")) xfirst = false;
    }
    if (val2.is_string()) {
      string s = val2.to_string();
      if (s == CHARS("left") || s == CHARS("right")) xfirst = false;
    }
    if (xfirst) {
      if (!image_position(x, val1)) return false;
      if (!image_position(y, val2)) return false;
    } else {
      if (!image_position(y, val1)) return false;
      if (!image_position(x, val2)) return false;
    }
    return true;
  }

  bool crack_image_positions(rect_style::image_def& imd, slice<value>& a_values) 
  {
    size_v  margin[4];
    margin[0].set_auto();
    margin[1].set_auto();
    margin[2].set_auto();
    margin[3].set_auto();

    if (a_values.length >= 4) 
    {
      int kw1, kw2;
      if ((kw1 = a_values[0].is_string_of(CHARS("left"), CHARS("right"), CHARS("top"),CHARS("bottom")))
        && a_values[1].is_length_or_percent_or_zero()
        && (kw2 = a_values[2].is_string_of(CHARS("left"), CHARS("right"), CHARS("top"), CHARS("bottom")))
        && a_values[3].is_length_or_percent_or_zero())
      {
        switch (kw1) {
          case 1: /*left*/ margin[0] = a_values[1]; break;
          case 2: /*right*/ margin[2] = a_values[1]; break;
          case 3: /*top*/ margin[1] = a_values[1]; break;
          case 4: /*bottom*/ margin[3] = a_values[1]; break;
        }
        switch (kw2) {
          case 1: /*left*/ margin[0] = a_values[3]; break;
          case 2: /*right*/ margin[2] = a_values[3]; break;
          case 3: /*top*/ margin[1] = a_values[3]; break;
          case 4: /*bottom*/ margin[3] = a_values[3]; break;
        }
        a_values.prune(4);
        goto OK;
      }
      else 
      {
        if (!image_position(margin[1], a_values[0])) return false;
        if (!image_position(margin[2], a_values[1])) return false;
        if (!image_position(margin[3], a_values[2])) return false;
        if (!image_position(margin[0], a_values[3])) return false;
        a_values.prune(4);
        goto OK;
      }
    }
    if (a_values.length >= 3) {
      bool vert = false;
      if (a_values[1].is_length_or_percent_or_zero()) {
        int kw = kw = a_values[0].is_string_of(CHARS("left"), CHARS("right"), CHARS("top"), CHARS("bottom"));
        switch (kw) {
          case 1: /*left*/ margin[0] = a_values[1]; vert = false; break;
          case 2: /*right*/ margin[2] = a_values[1]; vert = false; break;
          case 3: /*top*/ margin[1] = a_values[1]; vert = true; break;
          case 4: /*bottom*/ margin[3] = a_values[1]; vert = true; break;
          default: goto CASE2;
        }
        if (vert) {
          if (!image_position(margin[0], a_values[2])) goto CASE2;
        }
        else {
          if (!image_position(margin[1], a_values[2])) goto CASE2;
        }
        a_values.prune(3);
        goto OK;
      } 
      else if (a_values[2].is_length_or_percent_or_zero())
      {
        int kw = a_values[1].is_string_of(CHARS("left"), CHARS("right"), CHARS("top"), CHARS("bottom"));
        switch (kw) {
          case 1: /*left*/ margin[0] = a_values[1]; vert = false; break;
          case 2: /*right*/ margin[2] = a_values[1]; vert = false; break;
          case 3: /*top*/ margin[1] = a_values[1]; vert = true; break;
          case 4: /*bottom*/ margin[3] = a_values[1]; vert = true; break;
          default: goto CASE2;
        }
        if (vert) {
          if (!image_position(margin[0], a_values[0])) goto CASE2;
        }
        else {
          if (!image_position(margin[1], a_values[0])) goto CASE2;
        }
        a_values.prune(3);
        goto OK;
      }
    }
  CASE2:
    if (a_values.size() >= 2 && image_positions(margin[0], margin[1], a_values[0], a_values[1])) {
      a_values.prune(2);
      goto OK;
    }
    if (a_values.size() >= 1 && image_position(margin[0], a_values[0])) {
      margin[1].set_percents(50);
      a_values.prune(1);
      goto OK;
    }
    return false;
  OK:
    imd.margin[0] = margin[0];
    imd.margin[1] = margin[1];
    imd.margin[2] = margin[2];
    imd.margin[3] = margin[3];
    return true;
  }
  
  bool image_frame_no_value(int_v &v, const value &val) {
    if (val.is_string()) {
      ustring s = val.to_string();
      if (s.length() == 0) return false;
      if (s == WCHARS("first"))
        v = FRAME_FIRST;
      else if (s == WCHARS("last"))
        v = FRAME_CURRENT;
      else if (s == WCHARS("current"))
        v = FRAME_CURRENT;
      else if (s == WCHARS("animate"))
        v = FRAME_ANIMATE;
      else
        return false;
    } else if (val.is_int())
      v = val.get_int();
    else
      return false;
    return true;
  }

  ustring image_frame_no_string(const int_v &v) {
    if (v.is_undefined()) return ustring();
    if (v.is_inherit()) return WCHARS("inherit");
    if (v == FRAME_FIRST)
      return WCHARS("first");
    else if (v == FRAME_LAST)
      return WCHARS("last");
    else if (v == FRAME_CURRENT)
      return WCHARS("current");
    else if (v == FRAME_ANIMATE)
      return WCHARS("animate");
    else
      return itow(v.val(0));
  }

  bool percent_or_number(const value &v) {
    return v.is_number() || v.is_percent();
  }
  bool only_angle(const value &v) { return v.is_angle(); }
  bool only_length(const value &v) { return v.is_length(); }

  bool filter_value(filter_v &v, slice<value> list) {
    for (int n = 0; n < list.size(); ++n) {
      const value &el = list[n];
      if (el.is_none()) {
        v.set_none();
        return true;
      }
      if (!el.is_function()) return false;
      if (el.is_function(WCHARS("blur"), only_length)) continue;
      if (el.is_function(WCHARS("brightness"), percent_or_number)) continue;
      if (el.is_function(WCHARS("contrast"), percent_or_number))
        continue; // note 200% is a length value
      if (el.is_function(WCHARS("grayscale"), percent_or_number)) continue;
      if (el.is_function(WCHARS("hue-rotate"), only_angle)) continue;
      if (el.is_function(WCHARS("invert"))) continue;
      if (el.is_function(WCHARS("opacity"), percent_or_number)) continue;
      if (el.is_function(WCHARS("saturate"), percent_or_number)) continue;
      if (el.is_function(WCHARS("sepia"), percent_or_number)) continue;
      if (el.is_function(WCHARS("drop-shadow"))) { // drop-shadow( <length>{2,4} <color>? )
        const function_value *pf = el.get_function();
        int                   l  = 0;
        int                   c  = 0;
        for (int n = 0; n < pf->params.size(); ++n) {
          if (pf->params.value(n).is_length() || pf->params.value(n).is_zero())
            ++l;
          else if (pf->params.value(n).is_color())
            ++c;
          else
            return false;
        }
        if (l < 2 || l > 4) return false;
        if (c > 1) return false;
        continue;
      }
      return false;
    }
    v = list;
    return true;
  }

  ustring filter_string(const filter_v &v) {
    if (v.is_undefined()) return ustring();
    /*    switch(v.val(0))
        {
          case image_rendering_default: return WCHARS("default");
          case image_rendering_speed:   return WCHARS("optimize-speed");
          case image_rendering_quality: return WCHARS("optimize-quality");
        } */
    return ustring();
  }

  bool area_size_value(size_v &x, size_v &y, slice<value> &v) {
    if (v->is_string()) {
      ustring sv = v->to_string();
      if (sv == WCHARS("cover")) {
        x = y = size_v::make_literal(size_v::special_values::$cover);
        ++v;
        return true;
      } else if (sv == WCHARS("contain")) {
        x = y = size_v::make_literal(size_v::special_values::$contain);
        ++v;
        return true;
      }
    }
    if (length_value(x, *v)) {
      ++v;
      if (v.length && length_value(y, *v)) {
        ++v;
        return true;
      }
      y = size_v::make_literal(size_v::special_values::$auto);
      return true;
    }
    return false;
  }

  ustring area_size_value_string(const size_v &x, const size_v &y) {
    if (x.is_undefined() && y.is_undefined()) return ustring();
    if (x == y && x == size_v::make_literal(size_v::special_values::$contain))
      return WCHARS("contain");
    if (x == y && x == size_v::make_literal(size_v::special_values::$cover))
      return WCHARS("cover");
    return length_value_string(x) + W(" ") + length_value_string(y);
  }

  bool float_value(value &v, const value &val) {
    if (val.is_none()) {
      v = float_ev(float_none).to_value();
      return true;
    }
    if (val.is_inherit()) {
      v = v.inherit_val();
      return true;
    }
    if (!val.is_string_symbol()) {
      v = val;
    } else {
      ustring s = val.to_string();
      if (s == WCHARS("left"))
        v = float_ev(float_left).to_value();
      else if (s == WCHARS("right"))
        v = float_ev(float_right).to_value();
      else
        return false;
    }
    return true;
  }


  bool font_variant(tristate_v &v, const value &val) {
    if (!val.is_string()) return false;
    string s = val.to_string();
    if (s.length() == 0) return false;
    s.to_lower();
    if (s == CHARS("normal"))
      v = 0;
    else if (s == CHARS("small-caps"))
      v = 1;
    else
      return false;
    return true;
  }
/*
  bool display_style(enum_v &v, const value &val) {
    if (!val.is_string()) {
      if (is_none_value(val)) {
        v = _display_none;
        return true;
      } else if (is_inherit_value(val)) {
        v = enum_v::inherit_val();
        return true;
      }
      if (val.is_int()) {
        v = val.get_int();
        return true;
      }
      return false;
    }
    ustring s = val.to_string();
    if (s.length() == 0) return false;
    if (s == s_none)
      v = _display_none;
    else if (s == WCHARS("block"))
      v = display_block;
    else if (s == WCHARS("inline"))
      v = display_inline;
    else if (s == WCHARS("inline-block"))
      v = display_inline_block;
    else if (s == WCHARS("list-item"))
      v = display_list_item;
    else if (s == WCHARS("contents"))
      v = display_contents;
    else if (s == WCHARS("table"))
      v = display_table;
    else if (s == WCHARS("inline-table"))
      v = display_inline_table;
    else if (s == WCHARS("table-row"))
      v = display_table_row;
    else if (s == WCHARS("table-cell"))
      v = display_table_cell; // !!!!!
    else if (s == WCHARS("table-body"))
      v = display_table_body;
    else
      return false;
    return true;
  }
  */

  /*ustring floats_string(const enum_str_v &floats) {
    if (floats.is_defined()) {
      if (floats.is_string()) return floats.sv;
      switch (int(floats)) {
      case floats_left: return WCHARS("left");
      case floats_right: return WCHARS("right");
      }
    }
    return ustring();
  }

  ustring floats_string(const enum_v &floats) {
    if (floats.is_defined()) {
      switch (int(floats)) {
      case floats_left: return WCHARS("left");
      case floats_right: return WCHARS("right");
      }
    }
    return ustring();
  }*/

  bool background_image_attachment(enum_v &v, const value &val) {
    if (!val.is_string()) return false;
    string s = val.to_string();
    if (s.length() == 0) return false;
    if (s == CHARS("scroll"))
      v = attachment_scroll;
    else if (s == CHARS("fixed"))
      v = attachment_fixed;
    else if (s == CHARS("local"))
      v = attachment_local;
    else
      return false;
    return true;
  }
  ustring background_image_attachment_string(const enum_v &v) {
    if (v.is_undefined()) return ustring();
    switch (v) {
    case attachment_scroll: return WCHARS("scroll");
    case attachment_local: return WCHARS("local");
    case attachment_fixed: return WCHARS("fixed");
    }
    return ustring();
  }

  /*bool text_decoration_line(enum_v &line, slice<value> vals) {
    for (int n = 0; n < vals.size(); ++n) {
      value val = vals[n];
      if (!val.is_string()) {
        if (is_none_value(val)) {
          line = text_decoration_none;
          return true;
        } else if (is_inherit_value(val)) {
          line = enum_v::inherit_val();
          return true;
        }
        return false;
      }
      ustring s = val.to_string();

      if (s == s_none)
        line = text_decoration_none;
      else if (s == WCHARS("underline"))
        line = line | text_decoration_underline;
      else if (s == WCHARS("overline"))
        line = line | text_decoration_overline;
      else if (s == WCHARS("line-through"))
        line = line | text_decoration_linethrough;
      else
        return false;
    }
    return true;
  }*/

  bool text_decoration_color(color_v &col, value val) {
    if (val.is_string()) {
      ustring s = val.to_string();
      if (s == WCHARS("currentcolor")) {
        col = color_v::current_val();
        return true;
      }
      return false;
    } else if (val.is_color()) {
      col = val;
      return true;
    }
    return false;
  }

  bool text_decoration(text_decoration_ev &line, text_decoration_style_ev &style, color_v &clr, size_v &thickness, slice<value> a_values) {
    line.clear();
    style.clear();
    clr.clear();
    thickness.clear();
    for (int i = 0; i < a_values.size(); ++i) {
      value val = a_values[i];
      if(line.set(val))
        continue;
      else if (style.set(val))
        continue;
      else if (text_decoration_color(clr, val))
        continue;
      else if (length_value(thickness, val))
        continue;
      else
        return false;
    }
    if (style.is_defined() && line.is_undefined())
      line = text_decoration_underline;
    return true;
  }


  bool font_weight(int_v &v, const value &val) {
    if (is_inherit_value(val)) {
      v = int_v::inherit_val();
      return true;
    }
    if (val.is_int() && val.units() == 0) {
      v = val.get_int();
      return true;
    }

    if (!val.is_string()) return false;
    string s = val.to_string();
    if (s.length() == 0) return false;

    if (s == CHARS("bold"))
      v = 700;
    else if (s == CHARS("normal"))
      v = 400;
    else if (s == CHARS("bolder"))
      v = 900;
    else if (s == CHARS("lighter"))
      v = 200;
    else {
      char *endptr;
      long  l = strtol(s, &endptr, 10);
      if (*endptr == '\0')
        v = int(l);
      else
        return false;
    }
    return true;
  }

  ustring font_weight_to_string(const int_v &v) {
    if (v.is_undefined()) return ustring();
    return ustring::format(W("%d"), (int)v);
  }

  bool mapping(mapping_v &val, slice<value> sa) {
    auto set_all_to = [&](MAPPING_TYPE mt) {
      val.u.parts.margin              = mt;
      val.u.parts.padding             = mt;
      val.u.parts.border              = mt;
      val.u.parts.background_position = mt;
      val.u.parts.background_image    = mt;
      val.u.parts.foreground_image    = mt;
      val.u.parts.foreground_position = mt;
      val.u.parts.layout              = mt;
      val.u.parts.list_image          = mt;
      val.u.parts.alignment           = mt;
    };

    for (int n = 0; n < sa.size(); ++n) {
      if (sa[n].is_none()) {
        set_all_to(mapping_none);
        continue;
      }
      if (sa[n].is_inherit()) {
        set_all_to(mapping_inherit);
        continue;
      }
      if (sa[n].is_string() && sa[n].get(W("")) == WCHARS("left-to-right")) {
        set_all_to(mapping_left_to_right);
        continue;
      }
      if (sa[n].is_string() && sa[n].get(W("")) == WCHARS("top-to-right")) {
        set_all_to(mapping_top_to_right);
        continue;
      }

      if (!sa[n].is_function()) return false;
      function_value *pf = sa[n].get_function();
      MAPPING_TYPE    mt = mapping_default;
      if (pf->name == WCHARS("none"))
        mt = mapping_none;
      else if (pf->name == WCHARS("inherit"))
        mt = mapping_inherit;
      else if (pf->name == WCHARS("left-to-right"))
        mt = mapping_left_to_right;
      else if (pf->name == WCHARS("top-to-right"))
        mt = mapping_top_to_right;
      else
        return false;

      mapping_v d;

      for (int i = 0; i < pf->params.size(); ++i) {
        ustring name = pf->params.value(i).to_string();
        if (name == WCHARS("margin"))
          d.u.parts.margin = mt;
        else if (name == WCHARS("padding"))
          d.u.parts.padding = mt;
        else if (name == WCHARS("border"))
          d.u.parts.border = mt;
        else if (name == WCHARS("background"))
          d.u.parts.background_position = d.u.parts.background_image = mt;
        else if (name == WCHARS("background-image"))
          d.u.parts.background_image = mt;
        else if (name == WCHARS("background-position"))
          d.u.parts.background_position = mt;
        else if (name == WCHARS("foreground"))
          d.u.parts.foreground_position = d.u.parts.foreground_image = mt;
        else if (name == WCHARS("foreground-image"))
          d.u.parts.foreground_image = mt;
        else if (name == WCHARS("foreground-position"))
          d.u.parts.foreground_position = mt;
        else if (name == WCHARS("list-style-image"))
          d.u.parts.list_image = mt;
        else if (name == WCHARS("layout"))
          d.u.parts.layout = mt;
        else if (name == WCHARS("alignment"))
          d.u.parts.alignment = mt;
        else
          return false;
      }
      val = d;
    }
    return true;
  }

  ustring mapping_string(const mapping_v &v) {
    if (v.is_undefined()) return ustring();

    array<wchar> out;

    auto fmt = [&](MAPPING_TYPE mt, wchars funcname) {
      if (v.u.parts.margin == mt || v.u.parts.padding == mt ||
          v.u.parts.border == mt || v.u.parts.background_position == mt ||
          v.u.parts.background_image == mt ||
          v.u.parts.foreground_position == mt ||
          v.u.parts.foreground_image == mt || v.u.parts.layout == mt) {
        if (out.size()) out += WCHARS(" ");
        out += funcname;
        out += WCHARS("(");
        int n = 0;
        if (v.u.parts.margin == mt) {
          out += WCHARS("margin");
          ++n;
        }
        if (v.u.parts.padding == mt) {
          if (n) out += ',';
          out += WCHARS("padding");
          ++n;
        }
        if (v.u.parts.border == mt) {
          if (n) out += ',';
          out += WCHARS("border");
          ++n;
        }
        if (v.u.parts.background_image == mt) {
          if (n) out += ',';
          out += WCHARS("background-image");
          ++n;
        }
        if (v.u.parts.background_position == mt) {
          if (n) out += ',';
          out += WCHARS("background-position");
          ++n;
        }
        if (v.u.parts.foreground_image == mt) {
          if (n) out += ',';
          out += WCHARS("foreground-image");
          ++n;
        }
        if (v.u.parts.foreground_position == mt) {
          if (n) out += ',';
          out += WCHARS("foreground-position");
          ++n;
        }
        if (v.u.parts.layout == mt) {
          if (n) out += ',';
          out += WCHARS("layout");
          ++n;
        }
        if (v.u.parts.list_image == mt) {
          if (n) out += ',';
          out += WCHARS("list-style-image");
          ++n;
        }
        if (v.u.parts.alignment == mt) {
          if (n) out += ',';
          out += WCHARS("alignment");
          ++n;
        }
        out += WCHARS(") ");
      }
    };

    fmt(mapping_inherit, WCHARS("inherit"));
    fmt(mapping_none, WCHARS("none"));
    fmt(mapping_left_to_right, WCHARS("left-to-right"));
    fmt(mapping_top_to_right, WCHARS("top-to-right"));
    return out();
  }

  enum_item_def popup_pos_edef[] = {
      {0, W("default")},

      {7, W("top-left")},    {8, W("top-center")},    {9, W("top-right")},

      {4, W("middle-left")}, {5, W("middle-center")}, {6, W("middle-right")},

      {1, W("bottom-left")}, {2, W("bottom-center")}, {3, W("bottom-right")},

      {0x14, W("at-start")}, {0x16, W("at-end")},     {0x18, W("at-head")},
      {0x12, W("at-tail")},

  };

  bool popup_position(enum_v &pref, enum_v &aref, slice<value> sa) {
    if (sa.size() == 1) {
      if (is_none_value(sa[0])) {
        aref = 0;
        pref = 0;
        return true;
      } else if (is_inherit_value(sa[0])) {
        aref = enum_v::inherit_val();
        pref = enum_v::inherit_val();
        return true;
      } else
        return parse_enum(aref, sa[0].to_string(), popup_pos_edef);
    }
    if (sa.size() != 2) return false;

    return parse_enum(pref, sa[0].to_string(), popup_pos_edef) &&
           parse_enum(aref, sa[1].to_string(), popup_pos_edef);
  }

  ustring popup_position_string(enum_v pref, enum_v aref) {

    if (aref.is_undefined() && pref.is_undefined()) return ustring();

    if (aref == enum_v::inherit_val() && pref == enum_v::inherit_val())
      return WCHARS("inherit");

    if (aref == 0 && pref == 0) return WCHARS("default");

    return ustring::format(W("%s %s"), enum_to_string(pref, popup_pos_edef),
                           enum_to_string(aref, popup_pos_edef));
  }

  static bool get_color(const value &v, color_v &c) {
    if (v.is_color()) {
      c = color_v(v.get_packed_color());
      return true;
    } else if (v.is_inherit()) {
      c = color_v::inherit_val();
      return true;
    } else if (v.is_none()) {
      c = color_v::transparent_val();
      return true;
    }
    return false;
  }

  static bool get_float(const value &v, float &d) {
    if (v.is_double()) {
      d = (float)v.get_double();
      return true;
    } else if (v.is_int()) {
      d = (float)v.get_int();
    }
    return false;
  }
  static bool get_float(const value &v, double &d) {
    if (v.is_double()) {
      d = v.get_double();
      return true;
    } else if (v.is_int()) {
      d = (real)v.get_int();
    }
    return false;
  }

/*
  bool interpret_color_function(const style *cs, function_value *vf, color_v &c) {
    if (vf->name == WCHARS("var")) {
      if (vf->params.size() != 2) return false;
      if (!vf->params.value(1).is_color()) return false;
      if (!vf->params.value(0).is_string()) return false;
      uint sym = attr::symbol(vf->params.value(0).get_string());
      c = color_v::named(sym, color_v(vf->params.value(1)));
      return true;
    }
    if (vf->name == WCHARS("color")) {
      if (vf->params.size() != 1) return false;
      if (!vf->params.value(0).is_string()) return false;
      uint sym = attr::symbol(vf->params.value(0).get_string());
      c = color_v::named(sym, color_v(argb(0, 0, 0, 0)));
      return true;
    }
    if (vf->name == WCHARS("hsl")) {
      if (vf->params.size() != 3) return false;
      gool::hsl z;
      z.h = (float)limit(vf->params.value(0).get(0), 0, 360);
      z.s = (float)(limit(vf->params.value(1).get(0), 0, 100)) / 100.0f;
      z.l = (float)(limit(vf->params.value(2).get(0), 0, 100)) / 100.0f;
      c   = rgb(z);
      return true;
    }
    if (vf->name == WCHARS("hsv")) {
      if (vf->params.size() != 3) return false;
      gool::hsv z;
      z.h = (float)limit(vf->params.value(0).get(0), 0, 360);
      z.s = (float)(limit(vf->params.value(1).get(0), 0, 100)) / 100.0f;
      z.v = (float)(limit(vf->params.value(2).get(0), 0, 100)) / 100.0f;
      c   = rgb(z);
      return true;
    }

    if (vf->name == WCHARS("tint")) {
      color_v base_color;
      float   saturation = 0, luminance = 1;
      if (vf->params.size() < 2) return false;

      if (!color_value(base_color, vf->params.value(0))) return false;
      if (!get_float(vf->params.value(1), luminance)) return false;
      if (vf->params.size() >= 3) {
        if (!get_float(vf->params.value(2), saturation)) return false;
      }

      gool::rgb i = base_color.to_rgb(cs);

      gool::hsl z = i;

      saturation = limit(saturation, -1.0f, 1.0f);
      luminance  = limit(luminance, -1.0f, 1.0f);

      if (saturation < 0.0f)
        z.s -= z.s * (-saturation);
      else if (saturation > 0.0)
        z.s += (1.0f - z.s) * (saturation);

      if (luminance < 0.0f)
        z.l -= z.l * (-luminance);
      else if (luminance > 0.0f)
        z.l += (1.0f - z.l) * (luminance);

      rgb r(z);
      c = r;
      return true;
    }

    return false;
  } */

  bool color_value(color_v &c, const value &v, const style *pcs) {
    //if (v.is_function()) return interpret_color_function(pcs, v.get_function(), c);
    //if (get_color(v, c)) return true;
    c = v;
    return c.is_defined();
  }

  value color_value(const color_v &c) {
    /*if (c.is_undefined()) return value();

    if (c.is_named()) {
      tool::handle<tool::function_value> pf = new tool::function_value();
      pf->name                              = WCHARS("var");
      pf->params.push(tool::value(attr::symbol_name(c.get_name())));
      color_v t = c.ac;
      pf->params.push(color_value(t));
      return value::make_function(pf);
    }
    return value::make_packed_color(c.sc, c.ac);*/
    return c.to_value();
  }

  void list_style(const element_context& ctx, style *pcs, slice<value> sa) {
    for (int n = 0; n < sa.size(); ++n) {
      const value &val = sa[n];
      int_v        v_type;
      if (is_none_value(val))
        pcs->list_style_type = list_style_none;
      else if (crack_image_value(ctx.pdoc(), pcs->list_style_image, val)) {
        ;
      }
      else if (pcs->list_style_position.set(val)) { ; }
      else if (pcs->list_style_type.set(val)) { ; }

    }
  }


  void border(style& pcs, int i, slice<value> sa) {
    if (sa.length == 1 && is_inherit_value(sa[0])) {
      pcs.border_style[i] = enum_v::inherit_val();
      pcs.border_width[i] = size_v::inherit_val();
      pcs.border_color[i] = color_v::inherit_val();
      return;
    }
    //else if (sa.length == 1)
    //  i = i;

    //<border-width> || <border-style> || <color>
    for (int n = 0; n < sa.size(); ++n) {
      const value &val = sa[n];

      if (pcs.border_style[i].set(val))
        ;
      else if (length_value(pcs.border_width[i], val))
        ;
      else
        color_value(pcs.border_color[i], val);
    }
  }

  void outline(style& pcs, slice<value> sa) {
    bool got_width = false;
    //<border-width> || <border-style> || <color> || <border-offset>
    for (int n = 0; n < sa.size(); ++n) {
      const value &val = sa[n];
      if (pcs.outline_style.set(val))
        continue;
      else if (!got_width && pcs.outline_width.set(val)) {
        got_width = true;
      } else if (got_width && pcs.outline_offset.set(val))
        continue;
      else
        color_value(pcs.outline_color, val);
    }
  }

  bool parse_gradient_position(const value &v, point_v& pos) {
    slice<value> p = v.is_array() ? v.get_array()->elements() : slice<value>(&v, 1);
    bool xfirst = true;
    if (p.length > 2) return false;

    uint n       = 0;
    uint nfirst  = 0;
    bool to_mode = false;
    for (; n < p.length; ++n) {
      value t = p[n];
      value d;
      /*if( t.is_array() )
      {
        if( !pdim ) return false; // dim is not acceptable here.
        d = t[1];
        if( !d.is_length() ) return false;
        t = t[0];
      }
      */
      if (t.is_string(WCHARS("to"))) {
        if (n != 0) return false;
        to_mode = true;
        nfirst  = 1;
      } else if (t.is_string(WCHARS("left"))) {
        to_mode ? pos.x.set_percents(100) : pos.x.set_percents(0);
      } else if (t.is_string(WCHARS("right"))) {
        to_mode ? pos.x.set_percents(0) : pos.x.set_percents(100);
      } else if (t.is_string(WCHARS("top"))) {
        to_mode ? pos.y.set_percents(100) : pos.y.set_percents(0);
        if (n == nfirst) xfirst = false;
      } else if (t.is_string(WCHARS("bottom"))) {
        to_mode ? pos.y.set_percents(0) : pos.y.set_percents(100);
        if (n == nfirst) xfirst = false;
      } else if (t.is_string(WCHARS("center"))) {
        ;
      } else if (t.is_length()) {
        if (n == nfirst) {
          pos.x = t; /*if(pdim) pdim->x = d;*/
        } else if (xfirst) {
          pos.y = t; /*if(pdim) pdim->y = d;*/
        } else {
          pos.x = t; /*if(pdim) pdim->x = d;*/
        }
      } else
        return false;
    }

    size_v p50;
    p50.set_percents(50);
    if (pos.x.is_undefined()) pos.x = p50;
    if (pos.y.is_undefined()) pos.y = p50;

    return n == p.length;
  }

  bool parse_radial_size(const value &v, radial_gradient::SHAPE &sh,
                         radial_gradient::SIZE &sz, point_v &rad) {
    slice<value> p =
        v.is_array() ? v.get_array()->elements() : slice<value>(&v, 1);
    if (p.length > 2) return false;

    if (p[0].is_string()) {
      ustring s1 = p[0].get_string();
      sz         = radial_gradient::FARTHEST_CORNER;
      if (s1 == WCHARS("circle"))
        sh = radial_gradient::CIRCLE;
      else if (s1 == WCHARS("ellipse"))
        sh = radial_gradient::ELLIPSE;

      if (!p[1].is_string()) return false;

      // closest-side | closest-corner | farthest-side | farthest-corner |
      // contain | cover
      ustring s2 = p[1].get_string();

      if (s2 == WCHARS("closest-side") || s2 == WCHARS("contain"))
        sz = radial_gradient::CLOSEST_SIDE;
      else if (s2 == WCHARS("closest-corner"))
        sz = radial_gradient::CLOSEST_CORNER;
      else if (s2 == WCHARS("farthest-side"))
        sz = radial_gradient::FARTHEST_SIDE;
      else if (s2 == WCHARS("farthest-corner") || s2 == WCHARS("cover"))
        sz = radial_gradient::FARTHEST_CORNER;
    } else if (p[0].is_length() && p.length == 1) {
      sh    = radial_gradient::EXPLICIT;
      rad.x = rad.y = p[0];
    } else if (p[0].is_length() && p[1].is_length()) {
      sh    = radial_gradient::EXPLICIT;
      rad.x = p[0];
      rad.y = p[1];
    } else
      return false;

    return true;
  }

  bool parse_radial(const value &v, radial_gradient::SHAPE &sh,
                    radial_gradient::SIZE &sz, point_v &pos, point_v &dim) {
    slice<value> p =
        v.is_array() ? v.get_array()->elements() : slice<value>(&v, 1);
    // if( p.length > 2 )
    //  return false;

    auto parse_distance = [](const value &          v,
                             radial_gradient::SIZE &sz) -> bool {
      ustring s2 = v.get_string();
      if (s2 == WCHARS("closest-side") || s2 == WCHARS("contain"))
        sz = radial_gradient::CLOSEST_SIDE;
      else if (s2 == WCHARS("closest-corner"))
        sz = radial_gradient::CLOSEST_CORNER;
      else if (s2 == WCHARS("farthest-side"))
        sz = radial_gradient::FARTHEST_SIDE;
      else if (s2 == WCHARS("farthest-corner") || s2 == WCHARS("cover"))
        sz = radial_gradient::FARTHEST_CORNER;
      else
        return false;
      return true;
    };

    uint n = 0; // n consumed

    if (p[0].to_string() == WCHARS("circle") && p[1].is_length()) {
      sh    = radial_gradient::EXPLICIT;
      dim.x = dim.y = p[1];
      n             = 2;
    } else if (p[0].to_string() == WCHARS("circle") && p[1].is_string()) {
      sh = radial_gradient::CIRCLE;
      if (!parse_distance(p[1], sz)) return false;
      n = 2;
    } else if (p[0].to_string() == WCHARS("ellipse") && p[1].is_length() &&
               p[2].is_length()) {
      sh    = radial_gradient::EXPLICIT;
      dim.x = p[1];
      dim.y = p[2];
      n     = 3;
    } else if (p[0].to_string() == WCHARS("ellipse") && p[1].is_string()) {
      sh = radial_gradient::ELLIPSE;
      if (!parse_distance(p[1], sz)) return false;
      n = 2;
    }
    if (n < p.length && p[n].to_string() == WCHARS("at") &&
        p[n + 1].is_length() && p[n + 2].is_length()) {
      pos.x = p[n + 1];
      pos.y = p[n + 2];
    }

    return n > 0;
  }

  bool parse_angled_gradient(const value &v, float_v &angle, size_v &length) {
    slice<value> p =
        v.is_array() ? v.get_array()->elements() : slice<value>(&v, 1);
    if (p.length == 0 || p.length > 2) return false;
    if (!p[0].is_angle()) return false;
    angle = p[0].get_angle();
    if (p.length == 2) {
      if (!p[1].is_length()) return false;
      length = p[1];
    }
    return true;
  }

  /* linear-gradient( [<start-pos>,] [<offset>,] [<angle>,] <color-stops> ) */

  bool background_gradient(value_handle<gradient> &grad, const value &val) {
    // static handle<gradient> pgb_none = new linear_gradient();

    if (val.is_none()) {
      grad = gradient::none_gradient();
      return true;
    } else if (!val.is_function())
      return false;

    function_value *pf = val.get_function();

    value   p1;
    point_v pos;
    // point_v end;
    float_v angle;
    point_v dim;
    size_v  length;
    int     n = 0;

    if (pf->params.size() < 3) return false;
    if (pf->name == WCHARS("linear-gradient"))
      goto LINEAR;
    else if (pf->name == WCHARS("radial-gradient"))
      goto RADIAL;
    return false;

  LINEAR : {
    if (parse_gradient_position(pf->params.value(n), pos)) ++n;
    if (parse_gradient_position(pf->params.value(n), dim)) ++n;
    if (pf->params.value(n).is_angle()) {
      angle = pf->params.value(n).get_angle();
      ++n;
    }
    value_handle<linear_gradient> pgb = new linear_gradient();
    pgb->pos                    = pos;
    pgb->angle                  = angle;
    pgb->dim                    = dim;
    grad                        = pgb;
  }
    goto PARSE_STOPS;
  RADIAL : {
    radial_gradient::SHAPE sh = radial_gradient::ELLIPSE;
    radial_gradient::SIZE  sz = radial_gradient::FARTHEST_CORNER;
    point_v                focus;

    if (parse_radial(pf->params.value(n), sh, sz, pos, dim))
      ++n;
    else {
      if (parse_gradient_position(pf->params.value(n), pos)) ++n;
      if (parse_radial_size(pf->params.value(n), sh, sz, dim)) ++n;
    }

    value_handle<radial_gradient> pgb = new radial_gradient();
    pgb->center                 = pos;
    pgb->radius                 = dim;
    pgb->size                   = sz;
    pgb->shape                  = sh;
    grad                        = pgb;
  }
    goto PARSE_STOPS;

  PARSE_STOPS:
    for (; n < pf->params.size(); ++n) {
      const value &cs = pf->params.value(n);
      color_v      c;
      float_v      p;
      if (cs.is_array() && cs.size() == 2) {
        if (cs.get_element(0).is_color())
          // c = cs.get_element(0);
          color_value(c, cs.get_element(0));
        else
          return false;
        if (cs.get_element(1).is_percent())
          p = (float)cs.get_element(1).get_double() / 100.0f;
        else
          return false;
      } else if (cs.is_color())
        color_value(c, cs);
      else
        return false;
      grad->add_stop(p, c);
    }
    grad->normalize_stops();
    return true;
  }

  bool crack_image_value(document *pd, image_ref &id, value val) {
    string s;
    ustring map_name;
    ustring part_name;
    if (is_none_value(val)) {
      id.set_none();         // = pd->register_image(t);
      return true;
    } else if (val.is_url()) {
      // val is already escaped ?
      string t = val.get_url(); //combine_url(url, );
      id       = pd->register_image(t);
      return true;
    }
    else if (val.crack_function(WCHARS("image-map"), map_name)) {
      id = pd->register_image_fragment(map_name, part_name);
      return true;
    }
    else if (val.crack_function(WCHARS("image-map"), map_name, part_name)) {
      id = pd->register_image_fragment(map_name, part_name);
      return true;
    }
    else if (val.crack_function(WCHARS("url"),s)) {
      id = pd->register_image(s);
      return true;
    } else if (val.is_string()) {
      s = val.to_string();
      if (s.like("url(*)")) {
        s = s(4, s.size() - 1);
        id = pd->register_image(s);
        return true;
      }
    }
    return false;
  }

  void background(const element_context& ctx, style& pcs, slice<value> sa) {
    //<background-color> || <background-image> || <background-repeat> ||
    //<background-attachment> || <background-position>
    int    margin_idx = 0;
    int    color_idx  = 0;
    size_v mar;

    color_v back_colors[4];
    size_v  back_positions[5];

    pcs.back_image.id.set_none();
    pcs.back_image.attachment = attachment_scroll;
    // pcs.back_color[0] =
    // pcs.back_color[1] =
    // pcs.back_color[2] =
    // pcs.back_color[3] = TRANSPARENT_COLOR;
    pcs.back_color = color_v::transparent_val();
    pcs.back_image.margin[0].set_literal(size_v::special_values::$auto);
    pcs.back_image.margin[1] = pcs.back_image.margin[0];
    pcs.back_image.margin[2] = pcs.back_image.margin[0];
    pcs.back_image.margin[3] = pcs.back_image.margin[0];
    pcs.back_image.repeat    = background_no_repeat;
    pcs.back_image.dim[0] = pcs.back_image.dim[1] = size_v::make_auto();

    pcs.back_gradient = gradient::none_gradient();
    //??? pcs.back_image.repeat.clear();

#if 0
    for (int i = 0; i < sa.size(); ++i) {
      value val = sa[i];
      //<background-image>
      if (crack_image_value(pd, pcs.back_image.id, val)) {
        ;
      }
      //<background-attachment>
      else if (background_image_attachment(pcs.back_image.attachment, val))
        continue;
      else if (background_gradient(pcs.back_gradient, val))
        continue;
      //<background-color>
      else if (color_idx < 4 && color_value(back_colors[color_idx], val)) {
        if (color_idx == 0) pcs.back_color = back_colors[0];
        ++color_idx;
      }
      //<background-position>
      else if (margin_idx < 5 && image_position(mar, val)) {
        back_positions[margin_idx++] = mar;
      }
      //if (crack_image_positions(pcs.back_image, sa)) {
      //  continue;
      //}

      //<background-repeat>
      else if (pcs.back_image.repeat.set(slice<value>(val)))
        continue;
    }
#else 
    while (sa) {
      //<background-image>
      if (crack_image_value(ctx.pdoc(), pcs.back_image.id, *sa))
        ++sa;
      //<background-attachment>
      else if (background_image_attachment(pcs.back_image.attachment, *sa))
        ++sa;
      else if (background_gradient(pcs.back_gradient, *sa))
        ++sa;
      //<background-color>
      else if (color_idx < 4 && color_value(back_colors[color_idx], *sa)) {
        if (color_idx == 0) pcs.back_color = back_colors[0];
        ++color_idx;
        ++sa;
      }
      //<background-position>
      else if (crack_image_positions(pcs.back_image, sa))
        continue;
      //<background-repeat>
      else if (pcs.back_image.repeat.set(sa))
        continue;
      else
        break;
    }

#endif

    if (color_idx == 4) {
      if ((back_colors[0] == back_colors[1]) &&
          (back_colors[2] == back_colors[3])) {
        value_handle<linear_gradient> lg = new linear_gradient();
        lg->pos.x.set_percents(0);
        lg->pos.y.set_percents(0);
        lg->dim.x.set_percents(0);
        lg->dim.y.set_percents(100);
        lg->add_stop(0.0, back_colors[0]);
        lg->add_stop(1.0, back_colors[2]);
        pcs.back_gradient = lg;
      } else if ((back_colors[0] == back_colors[3]) &&
                 (back_colors[1] == back_colors[2])) {
        value_handle<linear_gradient> lg = new linear_gradient();
        lg->pos.x.set_percents(0);
        lg->pos.y.set_percents(0);
        lg->dim.x.set_percents(100);
        lg->dim.y.set_percents(0);
        lg->add_stop(0.0, back_colors[0]);
        lg->add_stop(1.0, back_colors[2]);
        pcs.back_gradient = lg;
      }
    }
    /*switch (margin_idx) {
    case 1:
      image_position(pcs.back_image.margin[0], back_positions[0]);
      pcs.back_image.margin[1].set_percents(50);
      break;
    case 2:
      image_positions(pcs.back_image.margin[0], pcs.back_image.margin[1],
                      back_positions[0], back_positions[1]);
      break;
    case 3:
      image_position(pcs.back_image.margin[0], back_positions[0]);
      pcs.back_image.margin[2].set_auto();
      pcs.back_image.margin[3].set_auto();
      image_position(pcs.back_image.margin[1], back_positions[1]);
      image_position(pcs.back_image.margin[2], back_positions[2]);
      break;
    case 4:
      image_position(pcs.back_image.margin[0], back_positions[0]);
      pcs.back_image.margin[1] = pcs.back_image.margin[0];
      image_position(pcs.back_image.margin[2], back_positions[1]);
      image_position(pcs.back_image.margin[3], back_positions[2]);
      image_position(pcs.back_image.margin[0], back_positions[3]);
      break;
    case 5:
      image_position(pcs.back_image.margin[0], back_positions[0]);
      pcs.back_image.margin[1] = back_positions[0];
      image_position(pcs.back_image.margin[2], back_positions[1]);
      image_position(pcs.back_image.margin[3], back_positions[2]);
      image_position(pcs.back_image.margin[0], back_positions[3]);
      break;
    }*/

  }

  void foreground(const element_context& ctx, style& pcs, slice<value> sa) {
    //<background-color> || <background-image> || <background-repeat> ||
    //<background-attachment> || <background-position>
    int    margin_idx = 0;
    size_v mar;

    pcs.fore_image.id.set_none();
    pcs.fore_image.attachment = attachment_scroll;
    pcs.fore_color            = color_v::transparent_val();
    pcs.fore_image.margin[0].set_literal(size_v::special_values::$auto);
    pcs.fore_image.margin[1] = pcs.fore_image.margin[0];
    pcs.fore_image.margin[2] = pcs.fore_image.margin[0];
    pcs.fore_image.margin[3] = pcs.fore_image.margin[0];
    pcs.fore_image.repeat    = background_no_repeat;
    pcs.fore_image.dim[0] = pcs.fore_image.dim[1] = size_v::make_auto();

    pcs.fore_gradient = gradient::none_gradient();
    //??? pcs.fore_image.repeat.clear();

#if 0
    for (int i = 0; i < sa.size(); ++i) {
      value val = sa[i];
      //<background-image>
      if (crack_image_value(pd, pcs.fore_image.id, val)) {
        ;
      }
      //<background-attachment>
      else if (background_image_attachment(pcs.fore_image.attachment, val))
        continue;
      else if (background_gradient(pcs.fore_gradient, val))
        continue;
      //<background-color>
      else if (color_value(pcs.fore_color, val))
        continue;
      //<background-position>
      else if (margin_idx < 5 && image_position(mar, val)) {
        switch (margin_idx) {
        case 0:
          pcs.fore_image.margin[0] = mar;
          pcs.fore_image.margin[1].set_percents(50);
          break;
        case 1:
          image_positions(pcs.fore_image.margin[0], pcs.fore_image.margin[1],sa[i - 1], sa[i]);
          // pcs.fore_image.margin[1] = mar;
          break;
        }
        ++margin_idx;
      }
      //<background-repeat>
      else if (pcs.fore_image.repeat.set(slice<value>(val)))
        continue;
    }
#else
    while (sa) {
      //<background-image>
      if (crack_image_value(ctx.pdoc(), pcs.fore_image.id, *sa))
        ++sa;
      //<background-attachment>
      else if (background_image_attachment(pcs.fore_image.attachment, *sa))
        ++sa;
      else if (background_gradient(pcs.fore_gradient, *sa))
        ++sa;
      //<background-color>
      else if (color_value(pcs.fore_color, *sa))
        ++sa;
      //<background-position>
      else if (crack_image_positions(pcs.fore_image, sa))
        continue;
      //<background-repeat>
      else if (pcs.fore_image.repeat.set(sa))
        continue;
      else
        break;
    }
#endif

  }

  image_filter *image_transformation_1(const style* cs, rect_style::image_def &imd, const value & v);

  void image_transformation(const style* cs, rect_style::image_def &imd, slice<value> values) {
    if (values.length == 0) return;

    handle<image_filter> last;
    for (uint n = 0; n < values.length; ++n) {
      if (values[n].is_string() && values[n].get_string() == WCHARS("~")) {
        imd.filters.additive = true;
        continue;
      }
      if (last == 0) {
        imd.filters.first = last = image_transformation_1(cs, imd, values[n]);
        if (!last) {
          imd.filters.clear();
          return;
        }
      } else {
        last->next = image_transformation_1(cs, imd, values[n]);
        if (!last->next) {
          imd.filters.clear();
          return;
        }
        last = last->next;
      }
    }
  }

  image_filter *image_transformation_1(const style* cs,
                                       rect_style::image_def &imd,
                                       const value &v) {
    if (v.is_none()) { return new image_filter_none(); }
    if (!v.is_function()) return 0;

    handle<function_value> func = v.get_function();

    // int type

    if (func->name == WCHARS("color-schema")) {
      if (func->params.size() == 1) {
        if (func->params.value(0).is_string() &&
            func->params.value(0).to_string() == "system") {
          auto_ptr<image_filter_color_schema_5> tr(
              new image_filter_color_schema_5());
          tr->clr0 = argb(get_current_system_color(SC_DIALOG_DKSHADOW));
          tr->clr1 = argb(get_current_system_color(SC_DIALOG_SHADOW));
          tr->clr2 = argb(get_current_system_color(SC_DIALOG_SURFACE));
          tr->clr3 = argb(get_current_system_color(SC_DIALOG_LIGHT));
          tr->clr4 = argb(get_current_system_color(SC_DIALOG_BRIGHT));
          return tr.release();
        }
        value   cv = func->params.value(0);
        color_v c;
        if (cv.is_string()) cv = parse_value(cv.get_string());

        if (!color_value(c, cv)) {
          view::debug_printf(OT_CSS, OS_ERROR,
                             "image-transformation, color-schema() function: "
                             "bad color value\n");
          return 0;
        }

        auto_ptr<image_filter_color_schema_1> tr(new image_filter_color_schema_1());
        tr->src = c.to_argb();
        return tr.release();
      } else if (func->params.size() == 5) {
        color_v c[5];
        for (int i = 0; i < 5; ++i) {
          value cv = func->params.value(i);
          if (cv.is_string()) cv = parse_value(cv.get_string());

          if (!color_value(c[i], cv)) {
            view::debug_printf(OT_CSS, OS_ERROR,
                               "image-transformation, color-schema() function: "
                               "bad color value\n");
            return 0;
          }
        }
        auto_ptr<image_filter_color_schema_5> tr(
            new image_filter_color_schema_5());
        tr->clr0 = c[0].to_argb();
        tr->clr1 = c[1].to_argb();
        tr->clr2 = c[2].to_argb();
        tr->clr3 = c[3].to_argb();
        tr->clr4 = c[4].to_argb();
        return tr.release();
      } else
        view::debug_printf(OT_CSS, OS_ERROR,
                           "image-transformation, color-schema() function: "
                           "wrong number of arguments - either 1 or 5\n");
    } else if (func->name == WCHARS("contrast-brightness-gamma")) {
      if (func->params.size() == 3) {
        auto_ptr<image_filter_contrast_brightness_gamma> tr(
            new image_filter_contrast_brightness_gamma());
        tr->contrast =
            limit((float)func->params.value(0).to_float(), 0.0f, 1.0f);
        tr->brightness =
            limit((float)func->params.value(1).to_float(), 0.0f, 1.0f);
        tr->gamma_exponent =
            limit((float)func->params.value(2).to_float(), 0.0f, 4.0f);
        return tr.release();
      } else
        view::debug_printf(OT_CSS, OS_ERROR,
                           "image-transformation, contrast-brightness-gamma() "
                           "function: wrong number of arguments - 3\n");
    } else if (func->name == WCHARS("contrast")) {
      if (func->params.size() == 1) {
        auto_ptr<image_filter_contrast_brightness_gamma> tr(
            new image_filter_contrast_brightness_gamma());
        tr->contrast =
            limit((float)func->params.value(0).to_float(), 0.0f, 1.0f);
        // tr->brightness = limit(func->params.value(1).to_float(),0.0,1.0);
        // tr->gamma_exponent = limit(func->params.value(2).to_float(),0.0,4.0);
        return tr.release();
      } else
        view::debug_printf(OT_CSS, OS_ERROR,
                           "image-transformation, contrast() function: wrong "
                           "number of arguments - 1\n");
    } else if (func->name == WCHARS("brightness")) {
      if (func->params.size() == 1) {
        auto_ptr<image_filter_contrast_brightness_gamma> tr(
            new image_filter_contrast_brightness_gamma());
        tr->brightness =
            limit((float)func->params.value(0).to_float(), 0.0f, 1.0f);
        return tr.release();
      } else
        view::debug_printf(OT_CSS, OS_ERROR,
                           "image-transformation, brightness() function: wrong "
                           "number of arguments - 1\n");
    } else if (func->name == WCHARS("gamma")) {
      if (func->params.size() == 1) {
        image_filter_contrast_brightness_gamma* tr = 
            new image_filter_contrast_brightness_gamma();
        tr->gamma_exponent =
            limit((float)func->params.value(0).to_float(), 0.0f, 1.0f);
        return tr;
      } else
        view::debug_printf(OT_CSS, OS_ERROR,
                           "image-transformation, gamma() function: wrong "
                           "number of arguments - 1\n");
    } else if (func->name == WCHARS("colorize")) {
      if (func->params.size() == 1) {
        value   cv = func->params.value(0);
        color_v c;
        if (cv.is_string()) cv = parse_value(cv.get_string());

        if (!color_value(c, cv)) {
          view::debug_printf(OT_CSS, OS_ERROR,
                             "image-transformation, colorize() function: bad "
                             "color value: %S\n",
                             cv.to_string().c_str());
          return 0;
        }

        image_filter_colorize* tr = new image_filter_colorize();
        tr->src = c.to_argb();
        return tr;
      } else
        view::debug_printf(OT_CSS, OS_ERROR,
                           "image-transformation, colorize() function: wrong "
                           "number of arguments - 1\n");
    } else if (func->name == WCHARS("hue")) {
      if (func->params.size() == 1) {
        value   cv = func->params.value(0);
        color_v c;
        if (cv.is_string()) cv = parse_value(cv.get_string());

        float hue; // degrees 0..360

        if (color_value(c, cv))
          hue = hsv(c.to_argb()).h;
        else if (cv.is_number())
          hue = (float)cv.to_float();
        else if (cv.is_angle())
          hue = (float)(cv.to_float() * 180 / PI);
        else {
          view::debug_printf(
              OT_CSS, OS_ERROR,
              "image-transformation, hue() function: bad hue value: %S\n",
              cv.to_string().c_str());
          return 0;
        }
        image_filter_hue* tr = new image_filter_hue();
        tr->hue = hue;
        return tr;
      } else
        view::debug_printf(OT_CSS, OS_ERROR,
                           "image-transformation, hue() function: wrong number "
                           "of arguments - 1\n");
    } else if (func->name == WCHARS("saturation")) {
      if (func->params.size() == 1) {
        value   cv = func->params.value(0);
        color_v c;
        if (cv.is_string()) cv = parse_value(cv.get_string());

        float saturation;

        if (color_value(c, cv))
          saturation = hsv(c.to_argb()).s;
        else if (cv.is_number())
          saturation = (float)cv.to_float();
        else {
          view::debug_printf(OT_CSS, OS_ERROR,
                             "image-transformation, saturation() function: bad "
                             "color value: %S\n",
                             cv.to_string().c_str());
          return 0;
        }
        image_filter_saturation *tr = new image_filter_saturation();
        tr->saturation              = saturation;
        return tr;
      } else
        view::debug_printf(OT_CSS, OS_ERROR,
                           "image-transformation, saturation() function: wrong "
                           "number of arguments - 1\n");
    } else if (func->name == WCHARS("opacity")) {
      if (func->params.size() == 1) {
        float factor;
        if (func->params.value(0).is_double())
          factor = (float)func->params.value(0).get_double();
        else if (func->params.value(0).is_int())
          factor = (float)func->params.value(0).get_int() / 255.0f;
        else {
          view::debug_printf(
              OT_CSS, OS_ERROR,
              "image-transformation, opacity() function: bad opacity value\n");
          return 0;
        }

        image_filter_opacity* tr = new image_filter_opacity();
        tr->opacity = factor;
        return tr;
      } else
        view::debug_printf(OT_CSS, OS_ERROR,
                           "image-transformation, opacity() function: wrong "
                           "number of arguments - 1\n");
    } else if (func->name == WCHARS("flip-x")) {
      return new image_filter_flip_x();
    } else if (func->name == WCHARS("flip-y")) {
      return new image_filter_flip_y();
    }
    else
      view::debug_printf(
          OT_CSS, OS_ERROR,
          "image-transformation, function '%S' is not supported\n",
          func->name.c_str());

    return 0;
  }

#if 0
  void image_transformation(rect_style::image_def& imd, const value& v)
  {
    if( v.is_none() )
    {
      imd.transformation_id.clear();
      return;
    }
    if( !v.is_function()) return;

    handle<function_value> func = v.get_function();

    //int type 

    if( func->name == "color-schema")
    {
      if(func->params.size() == 1 )
      {
        if( func->params.value(0).is_string() && func->params.value(0).to_string() == "system" )
        {
              gool::image_transformation ict;
              ict.ict = ICT_COLOR_SCHEMA;
              ict.params.push( value((int)get_current_system_color(SC_DIALOG_DKSHADOW), value::clr) );
              ict.params.push( value((int)get_current_system_color(SC_DIALOG_SHADOW), value::clr) );
              ict.params.push( value((int)get_current_system_color(SC_DIALOG_SURFACE), value::clr) );
              ict.params.push( value((int)get_current_system_color(SC_DIALOG_LIGHT), value::clr) );
              ict.params.push( value((int)get_current_system_color(SC_DIALOG_BRIGHT), value::clr) );
              imd.set_transformation(ict);
          return;
        }
        color_v c;
        if(func->params.value(0).is_string())
          func->params.value(0) = parse_value(func->params.value(0).get_string());

        if(!color_value(c, func->params.value(0)))
        {
          view::debug_printf(OT_CSS, OS_ERROR, "in color-schema() function: bad color value\n");
          return;
        }
            gool::image_transformation ict;
            ict.ict = ICT_COLOR_SCHEMA;
            ict.params.push( value((int)get_current_system_color(c), value::clr) );
            imd.set_transformation(ict);
      }
      else if(func->params.size() == 5 )
      {
        color_v c[5];
        for( int i = 0; i < 5; ++i )
        {
          if(func->params.value(i).is_string())
            func->params.value(i) = parse_value(func->params.value(i).get_string());

          if(!color_value(c[i], func->params.value(i)))
          {
            view::debug_printf(OT_CSS, OS_ERROR, "in color-schema() function: bad color value\n");
            return;
          }
        }
            gool::image_transformation ict;
            ict.ict = ICT_COLOR_SCHEMA;
            ict.params.push( value((int)get_current_system_color(c[0]), value::clr) );
            ict.params.push( value((int)get_current_system_color(c[1]), value::clr) );
            ict.params.push( value((int)get_current_system_color(c[2]), value::clr) );
            ict.params.push( value((int)get_current_system_color(c[3]), value::clr) );
            ict.params.push( value((int)get_current_system_color(c[4]), value::clr) );
            imd.set_transformation(ict);
      }
      else
        view::debug_printf(OT_CSS, OS_ERROR,"in color-schema() function: wrong number of arguments - either 1 or 5\n");
    }
    else if( func->name == "contrast-brightness-gamma")
    {
        if(func->params.size() == 3 )
        {
          gool::image_transformation ict;
          ict.ict = ICT_CBG;
          ict.params.push( value(func->params.value(0).to_float()));
          ict.params.push( value(func->params.value(1).to_float()));
          ict.params.push( value(func->params.value(2).to_float()));
          imd.set_transformation(ict);
        }
        else
          view::debug_printf(OT_CSS, OS_ERROR,"in contrast-brightness-gamma() function: wrong number of arguments - 3\n");
    }
    else if( func->name == "colorize")
    {
        if(func->params.size() == 1 )
        {
          gool::image_transformation ict;
          ict.ict = ICT_COLORIZE;
          color_v c;
          if(func->params.value(0).is_string())
            func->params.value(0) = parse_value(func->params.value(0).get_string());

          if(!color_value(c, func->params.value(0)))
            {
               value tv = func->params.value(0);
               view::debug_printf(OT_CSS, OS_ERROR,"in colorize() function: bad color value: %S\n",tv.to_string().c_str());
               return;
            }

          ict.params.push( value((int)get_current_system_color(c), value::clr) );
              imd.set_transformation(ict);
        }
        else
          view::debug_printf(OT_CSS, OS_ERROR,"in colorize() function: wrong number of arguments - 1\n");
    }
    else if( func->name == "hue")
    {
        if(func->params.size() == 1 )
        {
          gool::image_transformation ict;
          ict.ict = ICT_HUE;
          color_v c;
          if(func->params.value(0).is_string())
            func->params.value(0) = parse_value(func->params.value(0).get_string());

          if(!color_value(c, func->params.value(0)))
            {
               value tv = func->params.value(0);
               view::debug_printf(OT_CSS, OS_ERROR,"in colorize() function: bad color value: %S\n",tv.to_string().c_str());
               return;
            }

          ict.params.push( value((int)get_current_system_color(c), value::clr) );
              imd.set_transformation(ict);
        }
        else
          view::debug_printf(OT_CSS, OS_ERROR,"in colorize() function: wrong number of arguments - 1\n");
    }
    else if( func->name == "opacity")
    {
        if(func->params.size() == 1 )
        {
          gool::image_transformation ict;
          ict.ict = ICT_OPACITY;
          double factor;
          if(func->params.value(0).is_double())
            factor = func->params.value(0).get_double();
          else if(func->params.value(0).is_int())
            factor = func->params.value(0).get_int() / 255.0;
          else
            view::debug_printf(OT_CSS, OS_ERROR,"in opacity() function: bad opacity value\n");

          ict.params.push( value( factor ) );
          imd.set_transformation(ict);
        }
        else
          view::debug_printf(OT_CSS, OS_ERROR,"in colorize() function: wrong number of arguments - 1\n");
    }
    else
      view::debug_printf(OT_CSS, OS_ERROR,"function '%s' is not supported\n",func->name.c_str());

  }

#endif

  bool parse_transition_item(string &name, transition_item &p, const value &val);

  bool shadow_style(value_handle<shadow_def> &val, slice<value> sa) {
    auto parse_item = [](slice<value> sa) -> shadow_def * {
      shadow_def it;

      int l = -1;
      int c = -1;
      int s = -1;
      for (uint n = 0; n < sa.length; ++n) {
        const value &v = sa[n];
        if( v.is_none() )
          return nullptr;
        if (v.is_string_symbol()) {
          if (++s == 0 && v.get_string() == WCHARS("inset"))
            it.inset = true;
          else
            return nullptr;
        } else if (v.is_color()) {
          if (++c != 0) return nullptr;
          color_value(it.color, v);
        } else if (v.is_length() || v.is_zero()) {
          switch (++l) {
          case 0: length_value(it.offset_x, v); break;
          case 1: length_value(it.offset_y, v); break;
          case 2: length_value(it.radius, v); break;
          case 3: length_value(it.spread, v); break;
          default: return nullptr;
          }
        }
      }
      return new shadow_def(it);
    };

    if (sa[0].is_array()) {
      for (int n = sa.size() - 1; n >= 0; --n) {
        if (!sa[n].is_array()) return false;
        value_handle<shadow_def> t = parse_item(sa[n].values());
        if (!t) {
          val = nullptr;
          return false;
        }
        t->next = val;
        val     = t;
      }
    } else {
      val = parse_item(sa);
    }
    return !!val;
  }

  bool parse_effect_type(const string& name, EFFECT_TYPE &et) {
    if (name == CHARS("blend"))
      et = transition_blend;
    else if (name == CHARS("blend-atop"))
      et = transition_blend_atop;
    else if (name == CHARS("slide-top"))
      et = transition_slide_top;
    else if (name == CHARS("slide-bottom"))
      et = transition_slide_bottom;
    else if (name == CHARS("slide-left"))
      et = transition_slide_left;
    else if (name == CHARS("slide-right"))
      et = transition_slide_right;

    else if (name == CHARS("slide-over-top"))
      et = transition_slide_over_top;
    else if (name == CHARS("slide-over-bottom"))
      et = transition_slide_over_bottom;
    else if (name == CHARS("slide-over-left"))
      et = transition_slide_over_left;
    else if (name == CHARS("slide-over-right"))
      et = transition_slide_over_right;

    else if (name == CHARS("remove-top"))
      et = transition_remove_top;
    else if (name == CHARS("remove-bottom"))
      et = transition_remove_bottom;
    else if (name == CHARS("remove-left"))
      et = transition_remove_left;
    else if (name == CHARS("remove-right"))
      et = transition_remove_right;

    else if (name == CHARS("scroll-top"))
      et = transition_scroll_top;
    else if (name == CHARS("scroll-bottom"))
      et = transition_scroll_bottom;
    else if (name == CHARS("scroll-left"))
      et = transition_scroll_left;
    else if (name == CHARS("scroll-right"))
      et = transition_scroll_right;
    else
      return false;
    return true;
  }

  bool effect_style(style& pcs, const value &val) {
    static tool::handle_pool<animated_effect> _dict;

    animated_effect ae;

    if (val.is_none()) {
      ae.etype = transition_none;
    } else if (val.is_string() && val.to_string() == WCHARS("blend")) {
      ae.etype    = transition_blend;
      ae.duration = 200;
      ae.easef = ae.reverse_easef = html::ease::linear;
    } else if (val.is_function()) {
      string name;
      if (!parse_transition_item(name, ae, val)) return false;
      if (!parse_effect_type(name, ae.etype)) return false;
    } else
      return false;

    critical_section _(html::lock);
    pcs.transition_effect = _dict.intern(ae);
    return true;
  }


  bool transition_style(enum_v &v, const value &val) {
    if (is_none_value(val)) {
      v = transition_none;
      return true;
    } else if (is_inherit_value(val)) {
      v = enum_v::inherit_val();
      return true;
    }

    if (!val.is_string()) return false;
    string s = val.to_string();
    if (s.length() == 0) return false;

    if (s == CHARS("blend")) v = transition_blend;
    // else if(s == CHARS("slide"))
    //  v = transition_slide;
    // else if(s == CHARS("image"))
    //  v = transition_image;
    else if (s == CHARS("window-blend"))
      v = transition_window_blend;
    else if (s == CHARS("window-slide-ltr"))
      v = transition_window_slide_ltr;
    else if (s == CHARS("window-slide-rtl"))
      v = transition_window_slide_rtl;
    else if (s == CHARS("window-slide-ttb"))
      v = transition_window_slide_ttb;
    else if (s == CHARS("window-slide-btt"))
      v = transition_window_slide_btt;
    else
      return false;
    return true;
  }

  ustring transition_style_string(const enum_v &v) {
    if (v.is_undefined()) return ustring();

    switch (v) {
    case transition_none: return WCHARS("none");
    case transition_blend:
      return WCHARS("blend");
    // case transition_slide: return L"slide";
    // case transition_image: return L"image";
    case transition_window_blend: return WCHARS("window-blend");
    case transition_window_slide_ltr: return WCHARS("window-slide-ltr");
    case transition_window_slide_rtl: return WCHARS("window-slide-rtl");
    case transition_window_slide_ttb: return WCHARS("window-slide-ttb");
    case transition_window_slide_btt: return WCHARS("window-slide-btt");
    }
    assert(false);
    return ustring();
  }

  // attr-sym(easefn,duration, delay, reverse-easefn)

  bool parse_transition_item(string &name, transition_item &p, const value &val) {
    if (!val.is_function()) return false;

    function_value *fv = val.get_function();

    if (fv->params.size() < 2) return false;

    name = fv->name;

    double duration = 0.0;
    double delay    = 0.0;

    float_v         reverse_duration;
    float_v         reverse_delay;
    ease::function  pf;
    ease::function  pfr;

    int rollback_idx = 1;

    if (fv->params.key(0).is_string()) goto NAMED_PARAMS;

    if (fv->params.value(0).is_none()) goto ROLLBACK;

    //if (!fv->params.value(0).is_string()) return false;

    pf = ease::get_ease_func(fv->params.value(0));
    if (!pf) return false; // unknown ease function.
    pfr = pf;

    if (!fv->params.value(1).is_duration()) return false; // bad duration
    duration = fv->params.value(1).get_duration(0);

    rollback_idx = 2;

    if (fv->params.size() >= 3) {
      if (fv->params.value(2).is_duration()) {
        delay        = fv->params.value(2).get_duration(0);
        rollback_idx = 3;
      }
    }

  ROLLBACK:

    if (rollback_idx < fv->params.size()) {
      if (fv->params.value(rollback_idx).is_none()) {
        pfr = 0;
      } else {
        pfr = ease::get_ease_func(fv->params.value(rollback_idx));
        if (!pfr) return false; // unknown ease function.
      }
      ++rollback_idx;
    }
    if (rollback_idx < fv->params.size()) {
      if (fv->params.value(rollback_idx).is_duration())
        reverse_duration = fv->params.value(rollback_idx).get_duration(0);
      else
        return false;
      ++rollback_idx;
    }
    if (rollback_idx < fv->params.size()) {
      if (fv->params.value(rollback_idx).is_duration())
        reverse_delay = fv->params.value(rollback_idx).get_duration(0);
      else
        return false;
      ++rollback_idx;
    }

    p.easef         = pf;
    p.reverse_easef = pfr;
    p.delay         = uint(delay * 1000);
    p.duration      = uint(duration * 1000);
    if (reverse_duration.is_defined()) {
      p.reverse_duration = uint(reverse_duration * 1000);
      p.reverse_delay    = uint(reverse_delay * 1000);
    }
    return true;

  NAMED_PARAMS:

    value v = fv->params(value(WCHARS("timing-function")));
    if (v.is_none())
      pfr = pf = 0;
    else
      pfr = pf = ease::get_ease_func(v);
    v = fv->params(value(WCHARS("timing-function-in")));
    pf = ease::get_ease_func(v);
    v = fv->params(value(WCHARS("timing-function-out")));
    pfr = ease::get_ease_func(v);

    v = fv->params(value(WCHARS("delay")));
    if (v.is_duration()) delay = v.get_duration(0);
    v = fv->params(value(WCHARS("delay-in")));
    if (v.is_duration()) delay = v.get_duration(0);
    v = fv->params(value(WCHARS("delay-out")));
    if (v.is_duration()) reverse_delay = v.get_duration(0);

    v = fv->params(value(WCHARS("duration")));
    if (v.is_duration()) duration = v.get_duration(0);
    v = fv->params(value(WCHARS("duration-in")));
    if (v.is_duration()) duration = v.get_duration(0);
    v = fv->params(value(WCHARS("duration-out")));
    if (v.is_duration()) reverse_duration = v.get_duration(0);

    if (!pf || !pfr) return false;
    p.easef         = pf;
    p.reverse_easef = pfr;
    p.delay         = uint(delay * 1000);
    p.duration      = uint(duration * 1000);
    if (reverse_duration.is_defined()) {
      p.reverse_duration = uint(reverse_duration * 1000);
      p.reverse_delay    = uint(reverse_delay * 1000);
    }
    return true;
  }


  /*bool parse_transition_1(transition_item &p,
                          const value &val) {
    string name;
    if (!parse_transition_item(name, p, val)) return false;

    cssa::symbol_t attr_sym = cssa::symbol(name);
    if (attr_sym == 0 || attr_sym == cssa_transition)
      return false; // not a valid CSS property name

    p.prop_sym = uint(attr_sym);
    return true;
  }*/

  bool parse_transition_item_std(string &name, transition_item &p, slice<value> vals) {

    if(!vals) return false;

    if (!vals->is_string()) return false;

    name = vals->to_string();

    float_v duration;
    float_v delay;

    ease::function pf;

    vals.prune(1);

    while (vals.length) {
      if (vals->is_duration()) {
        if(duration.is_undefined())
          duration = vals->get_duration(0);
        else
          delay = vals->get_duration(0);
        vals.prune(1);
      }
      else {
        pf = ease::get_ease_func(*vals);
        if (!pf) return false;
        vals.prune(1);
      }
    }

    p.easef = pf ? pf : pf = ease::get_default_ease_func();
    if (delay.is_defined()) p.delay = uint(delay * 1000);
    if (duration.is_defined()) p.duration = uint(duration * 1000);

    return true;
  }


  
  bool parse_transition_1_std(transition_item &p,
                              slice<value> vals, style* pcs = nullptr) {
    string name;
    if (!parse_transition_item_std(name, p, vals)) return false;

    EFFECT_TYPE et; 
    if (pcs && parse_effect_type(name, et)) { // this is not a CSS property but effect type
      animated_effect ae = p;
      ae.etype = et;
      ae.reverse_duration = ae.duration;
      ae.reverse_easef = ae.easef;
      static tool::handle_pool<animated_effect> _dict;
      critical_section _(html::lock);
      pcs->transition_effect = _dict.intern(ae);
      return false;
    }

    cssa::symbol_t attr_sym = cssa::symbol(name);
    if (attr_sym == 0 || attr_sym == cssa_transition)
      return false; // not a valid CSS property name

    p.prop_sym = uint(attr_sym);
    return true;
  }

  void parse_transition(style& pcs, slice<value> a_values) {
    pcs.transition_effect.clear();
    pcs.transitions = 0;

    if (a_values.size() == 1 && a_values[0].is_none()) {
      pcs.transitions = transition_def::null();
      return;
    }
    //if (a_values.size() == 1 && effect_style(pcs, a_values[0])) return;

    //if (!a_values[0].is_function()) // standard
    {
      if (!a_values[0].is_array()) {
        transition_item p;
        if (parse_transition_1_std(p, a_values, &pcs))
          pcs.add_transition(p);
      } else
        for (int n = 0; n < a_values.size(); ++n) {
          transition_item p;
          slice<value> item_values = a_values[n].get_array()->elements();
          if (parse_transition_1_std(p, item_values))
            pcs.add_transition(p);
        }
    }
    /*else 
    {
      // default, sciter specific
      for (int n = 0; n < a_values.size(); ++n) {
        transition_item p;
        if (parse_transition_1(p, a_values[n]))
          pcs.add_transition(p, false);
      }
    }
    */
  }

  bool number_value(float &v, const value &val) {
    if (!val.is_number()) return false;
    v = (float)val.to_float();
    return true;
  }
  bool angle_value(float &rad, const value &val) {
    rad = (float)val.get_angle();
    return true;
  }

  handle<transforms> parse_transform(slice<value> a_values) 
  {
    handle<html::transforms> transforms;

    if (a_values[0].is_none()) {
      transforms = new html::transforms();
      return transforms;
    }

    for (uint n = 0; n < a_values.length; ++n) {
      const value &val = a_values[n];
      if (!val.is_function()) goto FAILURE;
      if (!transforms) transforms = new html::transforms();
      function_value *fv = val.get_function();

      if (fv->params.size() == 1 &&
          fv->params.value(0).is_array()) // what a f...
      {
        // instead of matrix(5.5,0,0,5.54,13.62,13.8)
        // we've got matrix(5.5 0 0 5.54 13.62 13.8)
        handle<array_value> arr = fv->params.value(0).get_array();
        fv->params.clear();
        for (int n = 0; n < arr->elements.size(); ++n)
          fv->params.push(arr->elements[n]);
      }
      if (fv->name == WCHARS("translate") &&
          is_one_of(fv->params.size(), 1, 2)) {
        handle<x_translation> p = new x_translation();
        if (!length_value(p->x, fv->params.value(0), size_v::NUMERIC_TO_NUMERIC)) goto FAILURE;
        if (fv->params.size() == 2) {
          if (!length_value(p->y, fv->params.value(1), size_v::NUMERIC_TO_NUMERIC)) goto FAILURE;
        } else
          p->y = 0;
        transforms->items.push(p.ptr());
      }
      // if( fv->name == WCHARS("translateX") && fv->params.size() == 1)

      else if (fv->name == WCHARS("scale") &&
               is_one_of(fv->params.size(), 1, 2)) {
        handle<x_scaling> p = new x_scaling();
        if (!number_value(p->x, fv->params.value(0))) goto FAILURE;
        if (fv->params.size() == 2) {
          if (!number_value(p->y, fv->params.value(1))) goto FAILURE;
        } else
          p->y = p->x;
        transforms->items.push(p.ptr());
      } else if (fv->name == WCHARS("rotate") && fv->params.size() == 1) {
        handle<x_rotation> p = new x_rotation();
        if (!angle_value(p->radians, fv->params.value(0))) {
          if (!number_value(p->radians, fv->params.value(0))) goto FAILURE;
          p->radians = p->radians * real_traits<float>::pi2() / 360.f;
        }
        transforms->items.push(p.ptr());
      } else if (fv->name == WCHARS("rotate") && fv->params.size() == 3) // svg rotation style : rotate(angle x y)
      {
        handle<x_rotation> p = new x_rotation();
        if (!angle_value(p->radians, fv->params.value(0))) {
          if (!number_value(p->radians, fv->params.value(0))) goto FAILURE;
          p->radians = p->radians * real_traits<float>::pi2() / 360.f;
        }
        if (!length_value(p->x, fv->params.value(1), size_v::NUMERIC_TO_NUMERIC)) goto FAILURE;
        if (!length_value(p->y, fv->params.value(2), size_v::NUMERIC_TO_NUMERIC)) goto FAILURE;

        transforms->items.push(p.ptr());
      } else if (fv->name == WCHARS("skew") && is_one_of(fv->params.size(), 1, 2)) {
        handle<x_skew> p = new x_skew();
        if (!angle_value(p->x, fv->params.value(0))) goto FAILURE;
        if (fv->params.size() == 2) {
          if (!angle_value(p->y, fv->params.value(1))) goto FAILURE;
        } else
          p->y = p->x;
        transforms->items.push(p.ptr());
      } else if (fv->name == WCHARS("matrix") && fv->params.size() == 6) {
        handle<x_matrix> p = new x_matrix();
        p->mtx.sx          = (float)fv->params.value(0).get_double();
        p->mtx.shy         = (float)fv->params.value(1).get_double();
        p->mtx.shx         = (float)fv->params.value(2).get_double();
        p->mtx.sy          = (float)fv->params.value(3).get_double();
        p->mtx.tx          = (float)fv->params.value(4).get_double();
        p->mtx.ty          = (float)fv->params.value(5).get_double();
        transforms->items.push(p.ptr());
      }

      else
        goto FAILURE;
    }
    return transforms;
  FAILURE:
    transforms.clear();
    return transforms;
  }

  ustring transform_style_string(const transforms *pv) {
    if (pv) return pv->to_string();
    return ustring();
  }

  void parse_transform_origin(style& pcs, slice<value> a_values) {
    if (!is_one_of(a_values.size(), 1, 2)) return;
    if (!length_value(pcs.transform_origin_x, a_values[0])) return;
    if (a_values.size() == 2) {
      if (!length_value(pcs.transform_origin_y, a_values[1])) {
        pcs.transform_origin_x.clear();
        return;
      }
    } else
      pcs.transform_origin_y = pcs.transform_origin_x;
  }

  ustring transform_origin_style_string(const transforms *pv) {
    assert(false);
    return ustring();
  }

  bool page_break_style(int_v &v, const value &val) {
    /*if(is_none_value(val))
    {
      v = transition_none;
      return true;
    }*/
    size_v pr;
    if (length_value(pr, val) && pr.is_percent()) {
      v = limit(pr.percent(), 0, 100);
      return true;
    }
    if (!val.is_string()) return false;
    string s = val.to_string();
    if (s.length() == 0) return false;

    if (s == CHARS("auto"))
      v = page_break_auto;
    else if (s == CHARS("always"))
      v = page_break_always;
    else if (s == CHARS("avoid"))
      v = page_break_avoid;
    else
      return false;
    return true;
  }

  /*ustring page_break_style_string(const int_v& v)
  {
    if(v.is_undefined())
      return ustring();

    switch(v)
    {
      case transition_blend: return "blend";
      case transition_slide: return "slide";
      case transition_image: return "image";
    }
    assert(false);
    return ustring();
  }*/

  bool string_value(string &s, const value &v) {
    if (v.is_string()) {
      s = v.to_string();
      return true;
    }
    return false;
  }

  /*
  bool content_value(handle<value::function>& xcontent, const value& v)
  {
    if( v.type() != value::t_function )
      return false;

    value::function *pf = v.get_function();
    static array< handle<value::function> > transformers;

    for( int n = transformers.last_index(); n >= 0; --n )
    {
      if( *transformers[n] == *pf )
      {
        xcontent = transformers[n];
        return true;
      }
    }
    transformers.push( pf );
    xcontent.
  }*/

  value parse_value(const ustring &token) {
    // static ustring s_inherit = L"inherit";
    // static ustring s_none = L"none";
    size_v sz;
    if(token().starts_with(WCHARS("--")))
      return value(token, value::UT_SYMBOL);

    if (token == s_none) return value::none_value();
    // sz = sz;

    from_string(sz, token);
    if (sz.is_defined()) {
      if (sz.is_expr())
        return value((object *)sz.cexpr());
      else
        return value(sz.d.value, sz.unit);
    }

    color_v cv;
    from_string(cv, token);
    if (cv.is_defined()) return cv.to_value();

    return value(token,value::UT_SYMBOL);
  }

  bool parse_function_value(document *pd, const string &base_url,
                            css_istream &s, value &fv);

  bool parse_value(document *pd, const string &base_url, css_istream &s, value &v) {
    int t = s.a_token();

    switch (t) {
    case css_istream::T_URL: {
        ustring r = combine_url(base_url, s.token_value());
        //v         = value(r);
        //v.units(value::uri);
        v = value::make_url(r);
        return true;
      }

    case css_istream::T_NMTOKEN: {
      wchars tv = s.token_value();
      if (tv == WCHARS("true")) {
        v = value(true);
        return true;
      } else if (tv == WCHARS("false")) {
        v = value(false);
        return true;
      } else if (tv == WCHARS("null")) {
        v = value::null_val();
        return true;
      }

      color_v cv;
      from_string(cv, tv);
      if (cv.is_defined()) {
        v = cv.to_value();
        return true;
      }
      size_v sz;
      from_string(sz, tv);
      if (sz.is_defined()) {
        v = sz; // value::make_length(sz.d.value,sz.unit);
        return true;
      }
    } // else fall through
    case css_istream::T_STRING: {
      v = value(s.token_value());
      return true;
    }

    case css_istream::T_SELECTOR: {
      v = value(s.token_value());
      return true;
    }

    case css_istream::T_NUMBER_UNIT: {
      size_v sz;
      from_string(sz, s.token_value());
      if (sz.is_defined()) {
        v = sz; // value::make_length(sz.d.value,sz.unit);
        return true;
      }
    } break;
    case css_istream::T_DURATION: {
      wchars tok = s.token_value();
      double t   = str_to_f(tok, 0.0);
      if (!!tok && *tok == 'm') t /= 1000;
      v = value::make_duration(t);
    }
      return true;

    case css_istream::T_ANGLE: {
      wchars tok = s.token_value();
      double t   = str_to_f(tok, 0.0);
      if (tok == WCHARS("deg"))
        t = t * 2 * PI / 360;
      else if (tok == WCHARS("grad"))
        t = t * 2 * PI / 400;
      else if (tok == WCHARS("rad"))
        t = t;
      else if (tok == WCHARS("turn"))
        t = t * 2 * PI / 100;
      else {
        assert(false);
        return false;
      }
      v = value::make_angle(t);
    }
      return true;

    case css_istream::T_INTEGER: {
      wchars tok = s.token_value();
      int    t   = str_to_i(tok, 0);
      v          = value(t);
    }
      return true;

    case css_istream::T_DPI: 
      {
        wchars tok = s.token_value();
        int    t   = str_to_i(tok, 0);
        //v          = value(t, value::dpi);
        v = value::make_dpi(t);
      }
      return true;

    case css_istream::T_FLOAT: {
      wchars tok = s.token_value();
      double t   = str_to_f(tok, 0.0);
      v          = value(t);
    }
      return true;

    case css_istream::T_COLOR: {
      color_v cv;
      from_string(cv, s.token_value());
      if (cv.is_defined()) {
        v = cv.to_value();
        return true;
      }
    } break;

    case css_istream::T_FUNCTION: {
      if (parse_function_value(pd, base_url, s, v)) return true;
    } break;

    case css_istream::T_ATRULE: {
      value cv = pd->styles().get_const(string(s.token_value()));
      if (cv.is_defined()) {
        v = cv;
        return true;
      }
    } break;
    }
    return false;
  }

  bool parse_function_parameter_value(document *pd, const string &base_url,
                                      css_istream &s, ustring &name,
                                      value &val) {
    int t;
    // name.clear();
    // val.clear();
    array<value> vals;
    for (t = s.a_token(); t; t = s.a_token())
      switch (t) {
      case ')':
      case ',':
        s.push_back();
        if (vals.size() == 0)
          val = value();
        else if (vals.size() == 1)
          val = vals[0];
        else
          val = value::make_array(vals());
        return true;
      case css_istream::T_NMTOKEN: {
        ustring ts = s.token_value();
        if (s.b_token() != ':') {
          s.push_back();
          vals.push(parse_value(ts));
          continue;
        }
        name = ts;
        value v;
        if (!parse_value(pd, base_url, s, v)) return false;
        vals.push(v);
        continue;
      }

      case css_istream::T_ATRULE: {
        value cv = pd->styles().get_const(string(s.token_value()));
        if (cv.is_array()) {
          for (uint i = 0; i < cv.size(); ++i)
            vals.push(cv.get_element(i));
        } else if (cv.is_defined())
          vals.push(cv);
        continue;
      }

      case '/':
        if (vals.size() == 0)
          break;
        else {
          value pair[2];
          pair[0] = vals.pop();
          if (!parse_value(pd, base_url, s, pair[1])) return false;
          vals.push(value::make_array(slice<value>(pair, 2),value::UT_PAIR));
          continue;
        }

      default: {
        // PARSE_VALUE:
        value v;
        s.push_back();
        if (!parse_value(pd, base_url, s, v)) return false;
        vals.push(v);
        continue;
      }
      }
    return false;
  }

  bool parse_function_value(document *pd, const string &base_url, css_istream &s, value &fv) {
    handle<function_value> f = new function_value();
    f->name                  = s.token_value();

    /*auto get_color_component = [](const value &          v,
                                  gool::argb::channel_t &cc) -> bool {
      if (v.is_int()) {
        cc = gool::argb::channel_t(v.get(0));
        return true;
      }
      if (v.is_percent()) {
        cc = gool::argb::channel_t(255 * v.get_percent());
        return true;
      }
      if (v.is_double()) {
        cc = gool::argb::channel_t(255 * v.get(0.0));
        return true;
      }
      return false;
    };
    auto get_alpha_component = [](const value &          v,
                                  gool::argb::channel_t &cc) -> bool {
      if (v.is_int()) {
        cc = gool::argb::channel_t(255 * v.get(0));
        return true;
      }
      if (v.is_percent()) {
        cc = gool::argb::channel_t(255 * v.get_percent());
        return true;
      }
      if (v.is_double()) {
        cc = gool::argb::channel_t(255 * v.get(0.0));
        return true;
      }
      return false;
    };*/

    int t;
    for (t = s.a_token(); t; t = s.a_token())
      switch (t) {
      case ')':
        /*if (f->name() == WCHARS("rgb")) {
          gool::argb cv(0, 0, 0, 255);
          if (f->params.size() == 3 &&
              get_color_component(f->params.value(0), cv.red) &&
              get_color_component(f->params.value(1), cv.green) &&
              get_color_component(f->params.value(2), cv.blue)) {
            fv = color_v(cv).to_value();
            return true;
          }
        } else if (f->name() == WCHARS("rgba")) {
          gool::argb cv(0, 0, 0, 255);
          color_v    other;
          if (f->params.size() == 3 &&
              get_color_component(f->params.value(0), cv.red) &&
              get_color_component(f->params.value(1), cv.green) &&
              get_color_component(f->params.value(2), cv.blue)) {
            fv = color_v(cv).to_value();
            return true;
          } else if (f->params.size() == 4 &&
                     get_color_component(f->params.value(0), cv.red) &&
                     get_color_component(f->params.value(1), cv.green) &&
                     get_color_component(f->params.value(2), cv.blue) &&
                     get_alpha_component(f->params.value(3), cv.alfa)) {
            fv = color_v(cv).to_value();
            return true;
          } else if (f->params.size() == 2 &&
                     color_value(other, f->params.value(0)) &&
                     get_alpha_component(f->params.value(1), cv.alfa)) {
            gool::argb ov = other.to_argb();
            cv.red        = ov.red;
            cv.green      = ov.green;
            cv.blue       = ov.blue;
            fv            = color_v(cv).to_value();
            return true;
          }
        }*/

        fv = value::make_function(f);

        return true;
      case ',': continue;
      default: {
        s.push_back();
        ustring name;
        value   val;
        if (!parse_function_parameter_value(pd, base_url, s, name, val))
          return false;
        if (name.is_defined())
          f->params[value(name, 0xFFFF)] = val;
        else
          f->params.push(val);
        continue;
      }
      }
    return false;
  }

  /*  bool parse_function_value(document* pd, const string& base_url,
  css_istream& s, value& fv)
    {
        handle< function_value > f = new function_value();
        f->name = s.token_value();
        int t;
        while(t = s.a_token())
          switch( t )
          {
            case ')':
              fv = value::make_function(f);
              return true;

            case css_istream::T_NMTOKEN:
              {
                ustring ts = s.token_value();
                if(s.b_token() != ':')
                {
                  s.push_back();
                  f->params.push( parse_value(ts) );
                  //if(ts == L"none" )
                  //  f->params.push(value::none_value());
                  //else
                  //  f->params.push(value(ts));
                  continue;
                }
                ustring name = ts;
                value v;
                if(!parse_value(base_url, s, v ))
                  return false;
                f->params[value(name,0xFFFF)] = v;
              }
            

            case ',':
              continue;
            

            case css_istream::T_ATRULE:
              {
                if(f->params.size() >= 32) // recursive inclusion?
                {
                  assert(false);
                  break;
                }
                array<value>* pa =
  pd->styles().get_const(string(s.token_value())); if( pa )
                {
                  for(int i = 0; i < pa->size(); ++i)
                  {
                    value v = (*pa)[i];
                    f->params.push(v);
                  }
                }
                continue;
              }
            default:
              {
  //PARSE_VALUE:
                value v;
                s.push_back();
                if(!parse_value(base_url, s, v ))
                  return false;
                f->params.push(v);
                continue;
              }
          }
        return false;
    } */

  inline void set_val(value &to, const value &by) {
    if (to.is_array()) {
      to.push(by);
    } else if (to.is_defined()) {
      to = value::make_array(slice<value>(&to, 1));
      to.push(by);
    } else
      to = by;
  }

  bool parse_css_value(html::context& c, wchars text, value &v) {
    css_istream s(text, c.pdoc()->uri().src);
    return parse_value(c.pdoc(), s.url, s, v);
  }

  bool parse_css_value(html::context& c, chars text, value &v) {
    auto ws = u8::cvt(text);
    return parse_css_value(c, ws(), v);
  }
  
  bool parse_custom_attribute_value(document *pd, const string &url,
                                    css_istream &s, value &val, style_bag *sb) {
    int t;

    for (t = s.a_token(); t; t = s.a_token())
      switch (t) {
      case ';': return true;
      case ')':
      case '}': s.push_back(); return true;

      case css_istream::T_URL:
        set_val(val,value::make_url(combine_url(url, string(s.token_value()))));
        break;

      case css_istream::T_NMTOKEN: {
        if (s.token_value() == WCHARS("none"))
          set_val(val, value::none_value());
        else {
          color_v cv;
          from_string(cv, s.token_value());
          if (cv.is_defined())
            set_val(val, cv.to_value());
          else
            set_val(val, value(s.token_value(), tool::value::UT_SYMBOL));
        }
        break;
      }
      case css_istream::T_COLOR: {
        color_v cv;
        from_string(cv, s.token_value());
        if (cv.is_defined()) {
          set_val(val, cv.to_value());
          break;
        }
        // else fall through
      }
        // fall through
      case css_istream::T_SELECTOR:
      case css_istream::T_STRING:
        set_val(val, value(ustring(s.token_value())));
        break;
      case css_istream::T_INTEGER:
        set_val(val, value(str2i(s.token_value(), 0)));
        break;
      case css_istream::T_DPI:
        set_val(val, value::make_dpi(str2i(s.token_value(),0)));
          //value(str2i(s.token_value(), 0), value::dpi));
        break;
      case css_istream::T_FLOAT:
        set_val(val, value(str2f(s.token_value(), 0.0)));
        break;
      case css_istream::T_NUMBER_UNIT: {
        size_v sz;
        from_string(sz, s.token_value());
        if (sz.is_defined())
          set_val(val,
                  value(sz)); // tool::value::make_length(sz.d.value,sz.unit);
        else
          goto GOT_ERROR;
      } break;
      case css_istream::T_DURATION: {
        wchars tok = s.token_value();
        double t   = str_to_f(tok, 0.0);
        if (*tok == 'm') t /= 1000;
        set_val(val, value::make_duration(t));
        break;
      }
      case css_istream::T_ATRULE: {
        value cv = sb ? sb->get_const(s.token_value())
                      : pd->styles().get_const(s.token_value());
        val = cv;
        return true;
      }
      case css_istream::T_FUNCTION: {
        value v;
        if (parse_function_value(pd, url, s, v)) {
          val = v;
          return true;
        }
      }
      default: goto GOT_ERROR;
      }
    return false;
  GOT_ERROR:
    // assert(false);
    for (t = s.a_token(); t; t = s.a_token()) {
      if (t == ';') break;
      if (t == '}') {
        s.push_back();
        break;
      }
    }
    return false;
  }

  bool parse_variable_value(document *pd, const string &url, css_istream &s,
                            value &val, style_bag *sb) {
    int t;

    for (t = s.a_token();; t = s.a_token())
      switch (t) {
      case css_istream::T_EOF: return true;
      case ';': return true;
      case '}': s.push_back(); return true;
      case ')': s.push_back(); return true;

      case css_istream::T_URL:
        set_val(val,value::make_url(combine_url(url, string(s.token_value()))));
        break;

      case css_istream::T_NMTOKEN: {
        if (s.token_value() == WCHARS("none"))
          set_val(val, value::none_value());
        else {
          color_v cv;
          from_string(cv, s.token_value());
          if (cv.is_defined())
            set_val(val, cv.to_value());
          else
            set_val(val, value(s.token_value(), tool::value::UT_SYMBOL));
        }
        break;
      }
      case css_istream::T_COLOR: {
        color_v cv;
        from_string(cv, s.token_value());
        if (cv.is_defined()) {
          set_val(val, cv.to_value());
          break;
        }
        // else fall through
      }
        // fall through
      case css_istream::T_SELECTOR:
      case css_istream::T_STRING:
        set_val(val, value(ustring(s.token_value())));
        break;
      case css_istream::T_INTEGER:
        set_val(val, value(str2i(s.token_value(), 0)));
        break;
      case css_istream::T_DPI:
        //set_val(val, value(str2i(s.token_value(), 0), value::dpi));
        set_val(val, value::make_dpi(str2i(s.token_value(), 0)));
        break;
      case css_istream::T_FLOAT:
        set_val(val, value(str2f(s.token_value(), 0.0)));
        break;
      case css_istream::T_NUMBER_UNIT: {
        size_v sz;
        from_string(sz, s.token_value());
        if (sz.is_defined())
          set_val(val,
                  value(sz)); // tool::value::make_length(sz.d.value,sz.unit);
        else
          goto GOT_ERROR;
      } break;
      case css_istream::T_DURATION: {
        wchars tok = s.token_value();
        double t   = str_to_f(tok, 0.0);
        if (*tok == 'm') t /= 1000;
        set_val(val, value::make_duration(t));
        break;
      }
      case css_istream::T_ATRULE: {
        value cv = sb ? sb->get_const(s.token_value())
                      : pd->styles().get_const(s.token_value());
        val = cv;
        break;
      }
      case css_istream::T_FUNCTION: {
        value v;
        if (parse_function_value(pd, url, s, v)) {
          set_val(val, v);
          break;
        }
      }
      default: goto GOT_ERROR;
      }
    return false;
  GOT_ERROR:
    // assert(false);
    for (t = s.a_token(); t; t = s.a_token()) {
      if (t == ';') break;
      if (t == '}') {
        s.push_back();
        break;
      }
    }
    return false;
  }

#if 0
  bool parse_action_attribute_value(document *pd, const string &url,
                                    css_istream &s, array<value> &a_values,
                                    style_bag *sb) {
    a_values.clear();

    handle<eval::conduit> prg = new eval::conduit();
    eval::parser          parser(*prg, url, s.line_no, sb);
    wchars                expr(s.pos, s.end - s.pos);
    wchars                left = expr;
    try {
      left = parser.parse(expr);
    } catch (eval::parse_error &er) {
      view::debug_printf(OT_CSSS, OS_ERROR, "%s at (%s(%d))\n", er.msg.c_str(),
                         url.c_str(), s.line_no);
      // view::debug_println( start, s.pos );
      // printf("error:%s at line %d\n", er.msg.c_str(), er.line_no);
      prg = 0;
    }

    s.pos = left.start;

    if (!prg) return false;

    value v;
    v.set_object(
        /*pd->actions.intern(*/ prg /*)*/); // interning is removed 'cause in
                                            // on_style_changed() we have: if
                                            // ... (_style->act_assigned !=
                                            // prev_style->act_assigned)
    a_values.push(v);
    return true;
  }
#endif

  bool parse_calc_value(document *pd, style_bag *sb, const string &url,
                        css_istream &s, wchars expr, array<value> &a_values) {
    handle<eval::conduit> prg = new eval::conduit();
    eval::parser          parser(*prg, url, s.line_no, sb);
    try {
      parser.parse(expr);
    } catch (eval::parse_error &er) {
      view::debug_printf(OT_CSSS, OS_ERROR, "%s at (%s(%d)\n", er.msg.c_str(),
                         url.c_str(), s.line_no);
      return false;
    }

    value v;
    v.set_object(
        /*pd->actions.intern(*/ prg /*)*/); // interning is removed 'cause in
                                            // on_style_changed() we have: if
                                            // ... (_style->act_assigned !=
                                            // prev_style->act_assigned)
    a_values.push(v);
    return true;
  }

  bool crack_attribute_value_1(document *pd, const string &url, css_istream &s,
                               array<value> &a_values, bool &is_important,
                               style_bag *sb,
                               CAV_MODE parsing_mode);

  bool crack_attribute_value(document *pd, const string &url, css_istream &s,
                             array<value> &a_values, bool &is_important,
                             style_bag *sb, CAV_MODE parsing_mode) {
#ifdef _DEBUG
    //if (comma_separated_list)
    //  comma_separated_list = comma_separated_list;
#endif 

    int t;
    int ncommas = parsing_mode == CAV_FORCE_COMMA_LIST ? 1 : 0;
    a_values.clear();
    array<value> values;
    for (t = s.a_token(); t; t = s.a_token()) {
      switch (t) {
      case ';': s.push_back(); break;
      case '}': s.push_back(); break;
      case ',':
        a_values.push(value::make_array(values()));
        ++ncommas;
        values.clear();
        continue;
      case '/':
        if (!values.size())
          break;
        else {
          array<value> vals;
          vals.push(values.pop());
          // a_values.push(   value(ustring(L"/"));
          bool v_is_important = false;
          if (!crack_attribute_value_1(pd, url, s, vals, v_is_important, sb, parsing_mode) || v_is_important)
            return false;
          values.push(value::make_array(vals(), value::UT_PAIR));
        }
        continue;
      default:
        s.push_back();
        if (!crack_attribute_value_1(pd, url, s, values, is_important, sb, parsing_mode))
          return false;
        continue;
      }
      if (ncommas) {
        a_values.push(value::make_array(values(), value::UT_WS_LIST));
        values.clear();
      }
      break;
    }
    if (a_values.size() == 0) a_values.transfer_from(values);
    return true;
  }

  bool crack_attribute_value_1(document *pd, const string &url, css_istream &s,
                               array<value> &a_values, bool &is_important,
                               style_bag *sb, CAV_MODE parsing_mode) {
    int t = s.a_token();
    /*START:*/
    switch (t) {
    case 0:
    case ';': s.push_back(); break;
    case '}': s.push_back(); break;
    case ',': s.push_back(); break;

    case css_istream::T_ATRULE:
      if (a_values.size() >= 32) // recursive inclusion?
      {
        assert(false);
        break;
      }
      {
        value cv = sb ? sb->get_const(s.token_value())
                      : pd->styles().get_const(s.token_value());
        if (cv.is_array()) {
          for (uint i = 0; i < cv.size(); ++i)
            a_values.push(cv.get_element(i));
        } else if (cv.is_defined())
          a_values.push(cv);
      }
      return true;

    case css_istream::T_URL: 
      {
        ustring r = combine_url(url, s.token_value());
        // dprintf("url %s\n",(const char*)r);
        //value v = value(r);
        //v.units(value::uri);
        a_values.push(value::make_url(r));
        return true;
      }
    case css_istream::T_CALC:
      return parse_calc_value(pd, sb, url, s, s.token_value(), a_values);

    case css_istream::T_NMTOKEN: {
      if (s.token_value() == WCHARS("none")) {
        a_values.push(value::none_value());
        return true;
      }
      if (s.token_value() == WCHARS("inherit")) {
        a_values.push(value::inherit_val());
        return true;
      }
      if (s.token_value() == WCHARS("auto")) {
        a_values.push(value::auto_val());
        return true;
      }
      if (lexical::ci::eq( s.token_value(),WCHARS("currentcolor"))) {
        a_values.push(value::make_function(W("currentcolor")));
        return true;
      }
      color_v cv;
      from_string(cv, s.token_value());
      if (cv.is_defined()) {
        a_values.push(cv.to_value());
        return true;
      }
      size_v sz;
      from_string(sz, s.token_value());
      if (sz.is_defined()) {
        value tv = sz;
        a_values.push(tv);
        // a_values.push(value::make_length(sz.d.value, sz.unit));
        return true;
      }
      //if (parsing_mode != CAV_FONT_MODE) 
      {
        ustring us = s.token_value();
        value   val(us, value::UT_SYMBOL);
        a_values.push(val);
        return true;
      }

    } // else fall through
    case css_istream::T_STRING: 
      /*if (parsing_mode == CAV_FONT_MODE) {
        ustring us = s.token_value();
        int     tt = t;
        while (true) {
          t = s.a_token();
          if (t != ',') {
            value val(us, tt == css_istream::T_NMTOKEN ? value::UT_SYMBOL : 0);
            a_values.push(val);
            s.push_back();
            return true;
          }
          tt = s.a_token();
          if (tt != css_istream::T_NMTOKEN && tt != css_istream::T_STRING)
            goto GOT_ERROR;
          us += ',';
          us += s.token_value();
        }
      }
      else  */
      {
        ustring us = s.token_value();
        value   val(us, value::UT_STRING);
        a_values.push(val);
        return true;
      }
      break;


    case css_istream::T_SELECTOR: {
      ustring as = s.token_value();
      value   v  = value(as);
      a_values.push(v);
    }
      return true;

    case css_istream::T_NUMBER_UNIT: {
      size_v sz;
      from_string(sz, s.token_value());
      if (sz.is_defined())
        a_values.push(sz /*value::make_length(sz.d.value, sz.unit)*/);
      else
        goto GOT_ERROR;
    }
      return true;

    case css_istream::T_DURATION: {
      wchars tok = s.token_value();
      double t   = str_to_f(tok, 0.0);
      if (!!tok && *tok == 'm') t /= 1000;
      a_values.push(value::make_duration(t));
    }
      return true;

    case css_istream::T_DPI: {
      int d = parse_int(s.token_value(), 0);
      a_values.push(value::make_dpi(d));
    }
      return true;

    case css_istream::T_INTEGER: {
      int d = parse_int(s.token_value(), 0);
      a_values.push(value(d));
    }
      return true;

    case css_istream::T_FLOAT: {
      double d = str2f(s.token_value(), 0.0);
      a_values.push(value(d));
    }
      return true;

    case css_istream::T_COLOR: {
      color_v cv;
      from_string(cv, s.token_value());
      if (cv.is_defined()) {
        a_values.push(cv.to_value());
        return true;
      }
      goto GOT_ERROR;
    }

    case css_istream::T_FUNCTION: {
      value v;
      if (parse_function_value(pd, url, s, v)) {
        a_values.push(v);
        return true;
      }
    }
      goto GOT_ERROR;

    case css_istream::T_IMPORTANT: 
      is_important = true; 
      return true;

    default: goto GOT_ERROR;
    }
    return true;
  GOT_ERROR:
    // assert(false);
    for (t = s.a_token(); t; t = s.a_token()) {
      if (t == ';') break;
      if (t == '}') {
        s.push_back();
        break;
      }
    }
    return false;
  }

  PAV_RESULT parse_attribute_value(document *pd, style_prop_map& sm,
                                   css_istream &s, cssa::name_or_symbol a_name,
                                   style_bag *sb) {
    array<value> a_values;
    bool         is_important = false;

    if (crack_attribute_value(pd, pd->uri().src, s, a_values, is_important, sb , CAV_DEFAULT)) {
      if(a_values.length() > 1)
        sm.set(a_name, value::make_array(a_values()));
      else
        sm.set(a_name, a_values[0]);
      return PAV_OK;
    } else
      return PAV_BAD_VALUE;
  }

  bool css_istream::parse_value(value &val) {
    val.clear();
    int t = a_token();
    /*START:*/
    switch (t) {
    case 0:
    case ';': push_back(); break;
    case '}': push_back(); break;
    case ',': push_back(); break;

    case css_istream::T_URL: 
      {
        ustring r = combine_url(url, token_value());
        // dprintf("url %s\n",(const char*)r);
        //val = value(r);
        //val.units(value::uri);
        val = value::make_url(r);
        return true;
      }
      // case css_istream::T_CALC:
      //  return parse_calc_value(pd,url,s,token_value(),a_values);

    case css_istream::T_NMTOKEN: {
      if (token_value() == WCHARS("none")) {
        val = value::none_value();
        return true;
      }
      color_v cv;
      if (token_value() == WCHARS("inherit")) {
        size_v sz = size_v::inherit_val();
        val       = sz;
        return true;
      }
      from_string(cv, token_value());
      if (cv.is_defined()) {
        if (cv.is_current())
          val = value::make_function(W("currentcolor"));
        else 
          val = cv.to_value();
        return true;
      }
      size_v sz;
      from_string(sz, token_value());
      if (sz.is_defined()) {
        val = sz;
        return true;
      }
      /*if(comma_separated_list) {
        ustring us = token_value();
        value val(us, value::UT_SYMBOL);
        a_values.push( val );
        return true;
      }*/

    } // else fall through
    case css_istream::T_STRING: {
      ustring us = token_value();
      val        = us;
      return true;
      /*int     tt = t;
      while(true)
      {
        t = a_token();
        if( t != ',' || comma_separated_list)
        {
          value val(us, tt == css_istream::T_NMTOKEN? value::UT_SYMBOL:0 );
          a_values.push( val );
          push_back();
          return true;
        }
        tt = a_token();
        if( tt != css_istream::T_NMTOKEN && tt != css_istream::T_STRING )
          goto GOT_ERROR;
        us += ','; us += token_value();
      }
      break;*/
    }

    case css_istream::T_SELECTOR: {
      ustring as = token_value();
      val        = value(as);
    }
      return true;

    case css_istream::T_NUMBER_UNIT: {
      size_v sz;
      from_string(sz, token_value());
      if (sz.is_defined())
        val = sz;
      else
        goto GOT_ERROR;
    }
      return true;

    case css_istream::T_DURATION: {
      wchars tok = token_value();
      double t   = str_to_f(tok, 0.0);
      if (!!tok && *tok == 'm') t /= 1000;
      val = value::make_duration(t);
    }
      return true;

    case css_istream::T_DPI: {
      int d = parse_int(token_value(), 0);
      val = value::make_dpi(d);
    }
      return true;

    case css_istream::T_INTEGER: {
      int d = parse_int(token_value(), 0);
      val   = value(d);
    }
      return true;

    case css_istream::T_FLOAT: {
      double d = str2f(token_value(), 0.0);
      val      = value(d);
    }
      return true;

    case css_istream::T_COLOR: {
      color_v cv;
      from_string(cv, token_value());
      if (cv.is_defined()) {
        val = value::make_packed_color(cv.bits);
        return true;
      }
      goto GOT_ERROR;
    }

    case css_istream::T_FUNCTION: {
      /*value v;
      if(parse_function_value(pd,url, s, v))
      {
        a_values.push(v);
        return true;
      }*/
    }
      goto GOT_ERROR;

      /*case css_istream::T_IMPORTANT:
        is_important = true;
        return true; */

    default: goto GOT_ERROR;
    }
    return true;
  GOT_ERROR:
    // assert(false);
    for (t = a_token(); t; t = a_token()) {
      if (t == ';') break;
      if (t == '}') {
        push_back();
        break;
      }
    }
    return false;
  }

  string s_inherit_val() {
    static string s = CHARS("inherit");
    return s;
  }

  bool try_font_list(document *pd, style *pcs, const value &val,
                     bool only_font_name) {

    if (!val.is_string()) return false;

    wchars list = val.get_chars();

    array<wchar> font_family;

    while (list.length) {
      wchars name = list.chop(',');
      if (name.like(W("system*")) && font_family.size() == 0) {
        int     size;
        bool    italic;
        uint    weight;
        ustring sname;
        app()->get_system_font(sname, size, weight, italic);
        {
          // pcs->font_family = pd->font_name_pool.intern(name);
          font_family = sname();
          if (!only_font_name) {
            pcs->font_size.set(size, size_v::unit_type::dip);
            pcs->font_weight         = weight;
            pcs->font_style          = italic ? font_style_italic : font_style_normal;
            pcs->font_rendering_mode = 1; // snap pixel
          }
        }
      } else {
        if (font_family.length()) font_family.push(WCHARS(","));
        font_family.push(name);
      }
    }
    pcs->font_family = pd->font_name_pool.intern(font_family());
    return true;
  }

  static void to_font_list(slice<value> list, ustring& font_list) {
      for (uint n = 0; n < list.length; ++n) {
        if(font_list.length() && !font_list().ends_with(','))
          font_list += WCHARS(",");
        if (list[n].is_array())
          to_font_list(list[n].values(), font_list);
        else 
          font_list += list[n].to_string();
      }
  }


static void crack_font_values(slice<value> list, style& s, ustring& font_list)
{
  for (uint n = 0; n < list.length; ++n) {
    value v = list[n];

    if (is_inherit_value(v)) {
      s.font_family = s_inherit_val();
      s.font_size = size_v::inherit_val();
      s.font_weight = int_v::inherit_val();
      s.font_style = font_style_ev::inherit_val();
      s.line_height = size_v::inherit_val();
      break;
    }
    else if (v.is_array() && v.units() == value::UT_PAIR) {
      length_value(s.font_size, v.get_element(0));
      length_value(s.line_height, v.get_element(1), size_v::NUMERIC_TO_PERCENT);
    }
    else if (v.is_array())
      crack_font_values(v.values(), s, font_list);
    if (v.is_length() && s.font_size.is_undefined()) {
      length_value(s.font_size, v);
      continue;
    }
    else if (s.font_weight.is_undefined() && font_weight(s.font_weight, v))
      continue;
    else if (s.font_style.is_undefined() && s.font_style.set(v))
      continue;
    else if (v.is_string()) {
      ustring name = v.to_string();
      if (name.like(W("system*"))) {
        int     size;
        bool    italic;
        uint    weight;
        app()->get_system_font(name, size, weight, italic);
        {
          s.font_size.set(size, size_v::unit_type::dip);
          s.font_weight = weight;
          s.font_style = italic ? font_style_italic : font_style_normal;
          s.font_rendering_mode = 1; // snap pixel
        }
      }
      if (font_list.length() && !font_list().ends_with(','))
        font_list += WCHARS(",");
      font_list += name;
    }
  }
}

  value resolve_var(const element_context& ctx, value val) {
    string name; value dv;
    while (val.get_variable_name_and_value(name, dv)) {
      if (!ctx.pel()->get_var(ctx, name, val, ctx.pstyle())) {
        val = dv;
#ifdef DEBUG
        ctx.pel()->dbg_report(string::format("CSS, NOT FOUND: var(%s)?", name.c_str()));
#endif // DEBUG
        break;
      }
    }
    switch (val.type()) {
      case value::t_array: {
        slice<value> list = val.values();
//        for (auto& el : list) if (el.is_variable()) goto COPY_ARRAY; 
//        break;
//      COPY_ARRAY: 
        handle<array_value> parr = new array_value();
        parr->elements.length(list.length);
        for (uint n = 0; n < list.length; ++n)
          parr->elements[n] = resolve_var(ctx, list[n]);
        val = value::make_array(parr);
        break;
      }
      case value::t_function:
      case value::t_map: {
        slice<value::key_value> list = val.key_values();
//        for (auto& el : list) if (el.val.is_variable()) goto COPY_MAP; - need deeper check
//        break;
//      COPY_MAP:
        handle<function_value> parr = new function_value();
        parr->name = val.get_function()->name;
        for (auto kv : list)
          parr->push(kv.key,resolve_var(ctx, kv.val));
        val = val.type() == value::t_function ? value::make_function(parr) : value::make_map(parr);

        if (val.is_variable_color())
          return resolve_color_function(ctx, val);
        else if (val.is_variable_length())
          return resolve_length_function(ctx, val);

        break;
      }

    }
    return val;
  }

  bool set_attribute_value(const element_context& ctx, style& s,  cssa::name_or_symbol attr, slice<value> a_values_in, style_bag* pb) {
    if (a_values_in.size() == 0) return true;

#ifdef DEBUG
    if (pb)
      pb = pb;
    auto szs = sizeof(style);
#endif

    buffer<value, 16> _a_values(a_values_in.length);
    for (uint n = 0; n < a_values_in.length; ++n)
      _a_values[n] = resolve_var(ctx, a_values_in[n]);

    slice<value> a_values = _a_values();

    switch (attr.att_sym) 
    {

    default: return false;

    case cssa_direction: return s.direction.set(a_values[0]);
    case cssa_font:
      //[ <font-style> || <font-variant> || <font-weight> ]? <font-size> [ /
      //<line-height> ]? <font-family>
      {
        s.font_family.clear();
        s.font_size.clear();
        s.font_weight.clear();
        s.font_style.clear();

        ustring font_family;

        crack_font_values(a_values, s, font_family);
        if (font_family.is_defined())
          s.font_family = ctx.pdoc()->font_name_pool.intern(font_family());

        if (s.font_family.is_undefined() || s.font_size.is_undefined())
        {
          int     size;
          bool    italic;
          uint    weight;
          app()->get_system_font(font_family, size, weight, italic);
          if (s.font_family.is_undefined())
            s.font_family = ctx.pdoc()->font_name_pool.intern(font_family());
          if(s.font_size.is_undefined())
            s.font_size.set(size, size_v::unit_type::dip);
        }
      }
      break;
    case cssa_font_family:
      if (is_inherit_value(a_values[0]))
        s.font_family = s_inherit_val();
      else {
        ustring name;
        to_font_list(a_values,name);
        s.font_family = ctx.pdoc()->font_name_pool.intern(name);
      }
      break;
    case cssa_font_size: length_value(s.font_size, a_values[0]); break;
    case cssa_font_style: s.font_style = a_values[0]; break;
    case cssa_font_rendering_mode: s.font_rendering_mode = a_values[0]; break;
    case cssa_font_variant: font_variant_value(s, a_values);  break;
    case cssa_font_variant_ligatures: s.font_variant_ligatures.set(a_values);  break;
    case cssa_font_variant_caps: s.font_variant_caps.set(a_values[0]);  break;

    case cssa_letter_spacing:
      if (a_values[0].is_string_symbol(WCHARS("normal")))
        s.letter_spacing = size_v(0);
      else
        length_value(s.letter_spacing, a_values[0]);
      break;
    case cssa_font_weight: 
      font_weight(s.font_weight, a_values[0]); 
      break;
    case cssa_line_height: 
      length_value(s.line_height, a_values[0], size_v::NUMERIC_TO_PERCENT);
      break;
    case cssa_text_decoration: text_decoration(s.text_decoration_line, s.text_decoration_style, s.text_decoration_color, s.text_decoration_thickness, a_values); break;
    case cssa_text_decoration_line: 
      //text_decoration_line(s.text_decoration_line, a_values); 
      s.text_decoration_line.set(a_values);
      break;
    case cssa_text_decoration_style: 
      s.text_decoration_style = a_values[0]; 
      break;
    case cssa_text_decoration_color: color_value(s.text_decoration_color, a_values[0]); break;
    case cssa_text_decoration_thickness: length_value(s.text_decoration_thickness, a_values[0]); break;

    case cssa_color: 
      color_value(s.font_color, a_values[0]); 
      if (s.font_color.is_current()) s.font_color.clear();  break;
    case cssa_zoom:
      if (a_values[0].is_percent())
        s.zoom = a_values[0].get_percent();
      else if (a_values[0].is_int())
        s.zoom = float(a_values[0].get(1));
      else if (a_values[0].is_double())
        s.zoom = float(a_values[0].get(1.0));
      break;
    case cssa_text_selection_color:
      color_value(s.text_selection_color, a_values[0]);
      break;
    case cssa_text_selection_background_color:
      color_value(s.text_selection_background_color, a_values[0]);
      break;
    case cssa_text_selection_caret_color:
      color_value(s.text_selection_caret_color, a_values[0]);
      break;
    case cssa_text_selection:
      color_value(s.text_selection_color, a_values[0]);
      if (a_values.size() >= 2)
        color_value(s.text_selection_background_color, a_values[1]);
      break;
    case cssa_height: length_value(s.height, a_values[0]); break;
    case cssa_width: length_value(s.width, a_values[0]); break;
    case cssa_size:
      s.width.clear();
      s.height.clear();
      switch (a_values.size()) {
      case 1:
        length_value(s.width, a_values[0]);
        s.height = s.width;
        break;
      case 2:
        length_value(s.width, a_values[0]);
        length_value(s.height, a_values[1]);
        break;
      }
      break;
    case cssa_box_sizing: s.box_sizing = a_values[0]; break;
    case cssa_clip_box: s.clip_box = a_values[0]; break;
    case cssa_min_height: s.min_height = a_values[0]; break;
    case cssa_min_width: s.min_width = a_values[0]; break;
    case cssa_max_height: s.max_height = a_values[0]; break;
    case cssa_max_width: s.max_width = a_values[0]; break;
    case cssa_text_align: s.text_align = a_values[0]; break;
    case cssa_text_indent: s.text_indent = a_values[0]; break;
    case cssa_vertical_align: s.vertical_align = a_values[0]; break;
    case cssa_horizontal_align: s.horizontal_align = a_values[0]; break;
    case cssa_content_vertical_align: s.content_vertical_align = a_values[0]; break;
    case cssa_content_horizontal_align: s.horizontal_align = a_values[0]; break;


    case cssa_white_space: s.white_space = a_values[0]; break;
    case cssa_word_wrap: s.word_wrap = a_values[0]; break;
    case cssa_word_break: s.word_break = a_values[0]; break;
    case cssa_background_color: {
      color_value(s.back_color, a_values[0]);
      color_v back_colors[4];
      back_colors[0] = s.back_color;
      if (a_values.size() == 4) {
        color_value(back_colors[1], a_values[1]);
        color_value(back_colors[2], a_values[2]);
        color_value(back_colors[3], a_values[3]);

        if ((back_colors[0] == back_colors[1]) &&
            (back_colors[2] == back_colors[3])) {
          value_handle<linear_gradient> lg = new linear_gradient();
          lg->pos.x.set_percents(0);
          lg->pos.y.set_percents(0);
          lg->dim.x.set_percents(0);
          lg->dim.y.set_percents(100);
          lg->add_stop(0.0, back_colors[0]);
          lg->add_stop(1.0, back_colors[2]);
          s.back_gradient = lg;
        } else if ((back_colors[0] == back_colors[3]) &&
                   (back_colors[1] == back_colors[2])) {
          value_handle<linear_gradient> lg = new linear_gradient();
          lg->pos.x.set_percents(0);
          lg->pos.y.set_percents(0);
          lg->dim.x.set_percents(100);
          lg->dim.y.set_percents(0);
          lg->add_stop(0.0, back_colors[0]);
          lg->add_stop(1.0, back_colors[2]);
          s.back_gradient = lg;
        }
      }
    } break;
      /*case cssa_background_color_top_left:
              color_value(s.back_color[0], a_values[0]);
              break;
      case cssa_background_color_top_right:
              color_value(s.back_color[1], a_values[0]);
              break;
      case cssa_background_color_bottom_right:
              color_value(s.back_color[2], a_values[0]);
              break;
      case cssa_background_color_bottom_left:
              color_value(s.back_color[3], a_values[0]);
              break; */

    case cssa_background:
      s.back_image.margin[2].clear();
      s.back_image.margin[3].clear();
      background(ctx, s, a_values);
      break;

    case cssa_background_gradient:
      if (a_values[0].is_resource()) {
        if (a_values[0].get_resource()->is_of_type<linear_gradient>())
          s.back_gradient =
              static_cast<linear_gradient *>(a_values[0].get_resource());
        if (a_values[0].get_resource()->is_of_type<radial_gradient>())
          s.back_gradient =
              static_cast<radial_gradient *>(a_values[0].get_resource());
      } else
        background_gradient(s.back_gradient, a_values[0]);
      break;

    case cssa_background_attachment:
      background_image_attachment(s.back_image.attachment, a_values[0]);
      break;
    case cssa_background_image:
      crack_image_value(ctx.pdoc(), s.back_image.id, a_values[0]);
      break;
    case cssa_background_position:
      /*image_position(s.back_image.margin[0], a_values[0]);
      if (a_values.size() == 1) {
        s.back_image.margin[2].set_auto();
        s.back_image.margin[3].set_auto();
        s.back_image.margin[1].set_percents(50);
      } else if (a_values.size() == 2) {
        s.back_image.margin[2].set_auto();
        s.back_image.margin[3].set_auto();
        image_positions(s.back_image.margin[0], s.back_image.margin[1], a_values[0], a_values[1]);
      } else if (a_values.size() == 3) {
        s.back_image.margin[2].set_auto();
        s.back_image.margin[3].set_auto();
        image_position(s.back_image.margin[1], a_values[1]);
        image_position(s.back_image.margin[2], a_values[2]);
      } else if (a_values.size() == 4) {
        s.back_image.margin[1] = s.back_image.margin[0];
        image_position(s.back_image.margin[2], a_values[1]);
        image_position(s.back_image.margin[3], a_values[2]);
        image_position(s.back_image.margin[0], a_values[3]);
      } else if (a_values.size() == 5) {
        s.back_image.margin[1] = s.back_image.margin[0];
        image_position(s.back_image.margin[2], a_values[1]);
        image_position(s.back_image.margin[3], a_values[2]);
        image_position(s.back_image.margin[0], a_values[3]);
        image_position(s.back_image.margin[4], a_values[4]);
      }*/
      crack_image_positions(s.back_image, a_values);
      break;

    case cssa_background_position_top:
      image_position(s.back_image.margin[1], a_values[0]);
      break;
    case cssa_background_position_left:
      image_position(s.back_image.margin[0], a_values[0]);
      break;
    case cssa_background_position_right:
      image_position(s.back_image.margin[2], a_values[0]);
      break;
    case cssa_background_position_bottom:
      image_position(s.back_image.margin[3], a_values[0]);
      break;

    case cssa_background_repeat: 
      s.back_image.repeat.set(a_values);
      break;

    case cssa_background_image_transformation:
      image_transformation(&s,s.back_image, a_values);
      break;

    case cssa_background_size:
      area_size_value(s.back_image.dim[0], s.back_image.dim[1], a_values);
      break;
    case cssa_background_width: {
      size_v dummy;
      area_size_value(s.back_image.dim[0], dummy, a_values);
    } break;
    case cssa_background_height: {
      size_v dummy;
      area_size_value(s.back_image.dim[1], dummy, a_values);
    } break;
    case cssa_background_clip:
      s.back_image.clip = a_values[0];
      break;
    case cssa_background_frame_no:
      image_frame_no_value(s.back_image.frame_no, a_values[0]);
      break;
    //case cssa_background_blend_mode:
    //  s.back_image.blend_mode = a_values[0];
    //  break;
    case cssa_foreground_size:
      area_size_value(s.fore_image.dim[0], s.fore_image.dim[1], a_values);
      break;
    case cssa_foreground_width: {
      size_v dummy;
      area_size_value(s.fore_image.dim[0], dummy, a_values);
    } break;
    case cssa_foreground_height: {
      size_v dummy;
      area_size_value(s.fore_image.dim[1], dummy, a_values);
    } break;
    case cssa_foreground_clip:
      s.fore_image.clip = a_values[0];
      break;

    case cssa_foreground_frame_no:
      image_frame_no_value(s.fore_image.frame_no, a_values[0]);
      break;

    //case cssa_foreground_blend_mode:
    //  s.fore_image.blend_mode = a_values[0];
    //  break;

    case cssa_image_rendering: s.image_rendering = a_values[0];
      break;

    case cssa_filter: 
      filter_value(s.filter, a_values); 
      break;
    case cssa_backdrop_filter: 
      filter_value(s.backdrop_filter, a_values); 
      break;

    case cssa_foreground:
      s.fore_image.margin[2].clear();
      s.fore_image.margin[3].clear();
      foreground(ctx, s, a_values);
      break;

    case cssa_foreground_color:
      color_value(s.fore_color, a_values[0]);
      break;
    case cssa_foreground_attachment:
      background_image_attachment(s.fore_image.attachment, a_values[0]);
      break;
    case cssa_foreground_image:
      crack_image_value(ctx.pdoc(), s.fore_image.id, a_values[0]);
      break;
    case cssa_foreground_position:
      /*image_position(s.fore_image.margin[0], a_values[0]);
      if (a_values.size() == 1) {
        s.fore_image.margin[1].set_percents(50);
        s.fore_image.margin[2].set_auto();
        s.fore_image.margin[3].set_auto();
      } else if (a_values.size() == 2) {
        s.fore_image.margin[2].set_auto();
        s.fore_image.margin[3].set_auto();
        image_positions(s.fore_image.margin[0], s.fore_image.margin[1],
                        a_values[0], a_values[1]);
        // image_position(s.fore_image.margin[1],a_values[1]);
      } else if (a_values.size() == 3) {
        s.fore_image.margin[2].set_auto();
        s.fore_image.margin[3].set_auto();
        image_position(s.fore_image.margin[1], a_values[1]);
        image_position(s.fore_image.margin[2], a_values[2]);
      } else if (a_values.size() == 4) {
        s.fore_image.margin[1] = s.fore_image.margin[0];
        image_position(s.fore_image.margin[2], a_values[1]);
        image_position(s.fore_image.margin[3], a_values[2]);
        image_position(s.fore_image.margin[0], a_values[3]);
      } else if (a_values.size() == 5) {
        s.fore_image.margin[1] = s.fore_image.margin[0];
        image_position(s.fore_image.margin[2], a_values[1]);
        image_position(s.fore_image.margin[3], a_values[2]);
        image_position(s.fore_image.margin[0], a_values[3]);
        image_position(s.fore_image.margin[4], a_values[4]);
      }*/
      crack_image_positions(s.fore_image, a_values);
      break;
    case cssa_foreground_position_top:
      image_position(s.fore_image.margin[1], a_values[0]);
      break;
    case cssa_foreground_position_left:
      image_position(s.fore_image.margin[0], a_values[0]);
      break;
    case cssa_foreground_position_right:
      image_position(s.fore_image.margin[2], a_values[0]);
      break;
    case cssa_foreground_position_bottom:
      image_position(s.fore_image.margin[3], a_values[0]);
      break;

    case cssa_foreground_repeat:
      s.fore_image.repeat.set(a_values);
      break;
    case cssa_foreground_image_transformation:
      image_transformation(&s, s.fore_image, a_values);
      break;

    case cssa_foreground_gradient:
      if (a_values[0].is_resource()) {
        if (a_values[0].get_resource()->is_of_type<linear_gradient>())
          s.fore_gradient =
              static_cast<linear_gradient *>(a_values[0].get_resource());
        if (a_values[0].get_resource()->is_of_type<radial_gradient>())
          s.fore_gradient =
              static_cast<radial_gradient *>(a_values[0].get_resource());
      } else
        background_gradient(s.fore_gradient, a_values[0]);
      break;

    case cssa_border:
      border(s, 0, a_values);
      s.border_color[3] = s.border_color[2] = s.border_color[1] =
          s.border_color[0];
      s.border_width[3] = s.border_width[2] = s.border_width[1] =
          s.border_width[0];
      s.border_style[3] = s.border_style[2] = s.border_style[1] =
          s.border_style[0];
      break;

    case cssa_border_bottom: border(s, 3, a_values); break;
    case cssa_border_bottom_color:
      color_value(s.border_color[3], a_values[0]);
      break;
    case cssa_border_bottom_style:
      s.border_style[3] = a_values[0];
      break;
    case cssa_border_bottom_width:
      length_value(s.border_width[3], a_values[0]);
      break;

    case cssa_border_color:
      if (a_values.size() == 1 && color_value(s.border_color[0], a_values[0])) {
        s.border_color[3] = s.border_color[2] = s.border_color[1] = s.border_color[0];
      } else if (a_values.size() == 2 &&
                 color_value(s.border_color[1], a_values[0]) &&
                 color_value(s.border_color[0], a_values[1])) {
        s.border_color[3] = s.border_color[1];
        s.border_color[2] = s.border_color[0];
      } else if (a_values.size() == 3) {
        color_value(s.border_color[1], a_values[0]);
        color_value(s.border_color[2], a_values[1]);
        color_value(s.border_color[3], a_values[2]);
        s.border_color[0] = s.border_color[2];
      } else if (a_values.size() == 4) {
        color_value(s.border_color[1], a_values[0]);
        color_value(s.border_color[2], a_values[1]);
        color_value(s.border_color[3], a_values[2]);
        color_value(s.border_color[0], a_values[3]);
      }
      break;
    case cssa_border_left: border(s, 0, a_values); break;
    case cssa_border_left_color:
      color_value(s.border_color[0], a_values[0]);
      break;
    case cssa_border_left_style:
      s.border_style[0] = a_values[0];
      break;
    case cssa_border_left_width:
      length_value(s.border_width[0], a_values[0]);
      break;

    case cssa_border_right: border(s, 2, a_values); break;

    case cssa_border_right_color:
      color_value(s.border_color[2], a_values[0]);
      break;
    case cssa_border_right_style:
      s.border_style[2] = a_values[0];
      break;
    case cssa_border_right_width:
      length_value(s.border_width[2], a_values[0]);
      break;

    case cssa_border_style:
      if (s.border_style[0].set(a_values[0]))
          s.border_style[3] = s.border_style[2] = s.border_style[1] = s.border_style[0];
      break;

    case cssa_border_top: 
      border(s, 1, a_values); 
      break;
    case cssa_border_top_color:
      color_value(s.border_color[1], a_values[0]);
      break;
    case cssa_border_top_style:
      s.border_style[1] = a_values[0];
      break;
    case cssa_border_top_width:
      length_value(s.border_width[1], a_values[0]);
      break;
    case cssa_border_width:
      switch (a_values.size()) {
      case 1:
        if (length_value(s.border_width[0], a_values[0])) {
          s.border_width[3] = s.border_width[2] = s.border_width[1] =
              s.border_width[0];
        }
        break;
      case 2:
        length_value(s.border_width[1], a_values[0]);
        s.border_width[3] = s.border_width[1];
        length_value(s.border_width[0], a_values[1]);
        s.border_width[2] = s.border_width[0];
        break;
      case 3:
        // BODY { border_width: 1em 2em 3em } /* top=1em, right=2em, bottom=3em,
        // left=2em */
        length_value(s.border_width[1], a_values[0]);
        length_value(s.border_width[2], a_values[1]);
        length_value(s.border_width[3], a_values[2]);
        s.border_width[0] = s.border_width[2];
        break;
      case 4:
        length_value(s.border_width[1], a_values[0]);
        length_value(s.border_width[2], a_values[1]);
        length_value(s.border_width[3], a_values[2]);
        length_value(s.border_width[0], a_values[3]);
        break;
      }
      break;

    case cssa_border_radius: border_radius_8(s, a_values); break;

    case cssa_border_top_left_radius: border_radius(s, 0, a_values); break;
    case cssa_border_top_right_radius: border_radius(s, 1, a_values); break;
    case cssa_border_bottom_right_radius: border_radius(s, 2, a_values); break;
    case cssa_border_bottom_left_radius: border_radius(s, 3, a_values); break;

    case cssa_border_top_left_radius_x:
      border_radius(s, 0, a_values, false);
      break;
    case cssa_border_top_left_radius_y:
      border_radius(s, 0, a_values, true);
      break;
    case cssa_border_top_right_radius_x:
      border_radius(s, 1, a_values, false);
      break;
    case cssa_border_top_right_radius_y:
      border_radius(s, 1, a_values, true);
      break;
    case cssa_border_bottom_right_radius_x:
      border_radius(s, 2, a_values, false);
      break;
    case cssa_border_bottom_right_radius_y:
      border_radius(s, 2, a_values, true);
      break;
    case cssa_border_bottom_left_radius_x:
      border_radius(s, 3, a_values, false);
      break;
    case cssa_border_bottom_left_radius_y:
      border_radius(s, 3, a_values, true);
      break;

    case cssa_clear:
      s.clears = a_values[0];
      break;
    case cssa_float: 
      float_value(s.floats, a_values[0]); 
      /*if (a_values[0].is_string())
        s.floats = a_values[0].get<ustring>();
      else
        s.floats = a_values[0];*/
      break;

    case cssa_margin: {
      switch (a_values.length) {
      case 1:
        if (length_value(s.margin[0], a_values[0]))
          s.margin[3] = s.margin[2] = s.margin[1] = s.margin[0];
        break;
      case 2:
        length_value(s.margin[1], a_values[0]);
        s.margin[3] = s.margin[1];
        length_value(s.margin[0], a_values[1]);
        s.margin[2] = s.margin[0];
        break;
      case 3:
        // BODY { margin: 1em 2em 3em } /* top=1em, right=2em, bottom=3em,
        // left=2em */
        length_value(s.margin[1], a_values[0]);
        length_value(s.margin[2], a_values[1]);
        length_value(s.margin[3], a_values[2]);
        s.margin[0] = s.margin[2];
        break;
      case 4:
        length_value(s.margin[1], a_values[0]);
        length_value(s.margin[2], a_values[1]);
        length_value(s.margin[3], a_values[2]);
        length_value(s.margin[0], a_values[3]);
        break;
      }
    } break;
    case cssa_margin_bottom: length_value(s.margin[3], a_values[0]); break;
    case cssa_margin_left: length_value(s.margin[0], a_values[0]); break;
    case cssa_margin_right: length_value(s.margin[2], a_values[0]); break;
    case cssa_margin_top: length_value(s.margin[1], a_values[0]); break;
    case cssa_padding: {
      switch (a_values.size()) {
      case 1:
        length_value(s.padding_width[0], a_values[0]);
        s.padding_width[3] = s.padding_width[2] = s.padding_width[1] = s.padding_width[0];
        break;
      case 2:
        length_value(s.padding_width[1], a_values[0]);
        s.padding_width[3] = s.padding_width[1];
        length_value(s.padding_width[0], a_values[1]);
        s.padding_width[2] = s.padding_width[0];
        break;
      case 3:
        // BODY { padding: 1em 2em 3em } /* top=1em, right=2em, bottom=3em,
        // left=2em */
        length_value(s.padding_width[1], a_values[0]);
        length_value(s.padding_width[2], a_values[1]);
        length_value(s.padding_width[3], a_values[2]);
        s.padding_width[0] = s.padding_width[2];
        break;
      case 4:
        length_value(s.padding_width[1], a_values[0]);
        length_value(s.padding_width[2], a_values[1]);
        length_value(s.padding_width[3], a_values[2]);
        length_value(s.padding_width[0], a_values[3]);
        break;
      }
    } break;

    case cssa_padding_bottom: length_value(s.padding_width[3], a_values[0]); break;
    case cssa_padding_left: length_value(s.padding_width[0], a_values[0]); break;
    case cssa_padding_right: length_value(s.padding_width[2], a_values[0]); break;
    case cssa_padding_top: length_value(s.padding_width[1], a_values[0]); break;

    case cssa_list_style: list_style(ctx, &s, a_values); break;
    case cssa_list_style_image: crack_image_value(ctx.pdoc(), s.list_style_image, a_values[0]); break;
    case cssa_list_style_position: s.list_style_position = a_values[0]; break;
    case cssa_list_style_type: s.list_style_type = a_values[0]; break;
    case cssa_list_marker_color:
      s.list_marker_color = a_values[0];
      break;
    case cssa_list_marker_size:
      length_value(s.list_marker_size, a_values[0]);
      break;
    case cssa_list_marker_style: s.list_marker_style = a_values[0]; break;
    case cssa_overflow: {
      overflow_ev v;
      value  sm;
      overflow_value(v, sm, a_values);
      s.overflow_x      = v;
      s.overflow_y      = v;
      s.scroll_manner_x = sm;
      s.scroll_manner_y = sm;
    } break;
    case cssa_overflow_x:
      overflow_value(s.overflow_x, s.scroll_manner_x, a_values);
      break;
    case cssa_overflow_y:
      overflow_value(s.overflow_y, s.scroll_manner_y, a_values);
      break;

    case cssa_scroll_manner: {
      value v;
      scroll_manner_value(v, a_values[0]);
      s.scroll_manner_x = v;
      s.scroll_manner_y = v;
    } break;
    case cssa_scroll_manner_x:
      scroll_manner_value(s.scroll_manner_x, a_values[0]);
      break;
    case cssa_scroll_manner_y:
      scroll_manner_value(s.scroll_manner_y, a_values[0]);
      break;

    case cssa_cursor: cursor_value(ctx, s.cursor, a_values); break;
    case cssa_foreground_image_cursor:  cursor_value(ctx, s.foreground_image_cursor, a_values); break;

    case cssa_display: return s.display.set(a_values[0]); 
    case cssa_flow: return s.flow.set(a_values); 
    case cssa_visibility: return s.visibility.set(a_values[0]);
    case cssa_behavior: {
      if (a_values[0].is_string()) {
        string bn = a_values[0].to_string();
        for (uint n = 1; n < a_values.length; ++n) {
          bn += ' ';
          bn += a_values[n].to_string();
        }
        // s.behavior = combine_behavior(s.behavior, bn);
        s.behavior = ctx.pdoc()->string_pool.intern(bn);
      } else if (is_none_value(a_values[0])) {
        // s.behavior = combine_behavior(s.behavior, s_none);
        s.behavior = ctx.pdoc()->string_pool.intern("none");
      }
      break;
    }
    case cssa_context_menu: {
      if (is_none_value(a_values[0]))
        s.context_menu_url = s.context_menu_sel = string("none");
      else if (a_values[0].is_url()) {
        string bn = a_values[0].get_url();
        s.context_menu_url = ctx.pdoc()->string_pool.intern(bn);
      }
      else if (a_values[0].is_selector()) {
        string bn = a_values[0].get_selector();
        s.context_menu_sel = ctx.pdoc()->string_pool.intern(bn);
      }
      else if (a_values[0].is_string()) {
        string bn = a_values[0].to_string();
        // for( int n = 1; n < a_values.size(); ++n )
        //{
        //  bn += ' ';
        //  bn += a_values[n].to_string();
        //}
        if (a_values[0].is_url())
          s.context_menu_url = ctx.pdoc()->string_pool.intern(bn);
        else
          s.context_menu_sel = ctx.pdoc()->string_pool.intern(bn);
      }
      break;
    }

    case cssa_draggable: {
      draggable_value(s.draggable, a_values[0]);
      break;
    }

    case cssa_accept_drop: {
      if (is_none_value(a_values[0]))
        s.accept_drop = string("none");
      else if (a_values[0].is_string()) {
        string bn        = a_values[0].to_string();
        s.accept_drop = ctx.pdoc()->string_pool.intern(bn);
      }
      break;
    }
    case cssa_drop: drop_value(s.drop, a_values[0]); break;

#if defined(SCITER) || defined(SCITERJS)
    case cssa_prototype: {
      if (a_values[0].is_string()) {
        s.prototype_url.clear();
        s.prototype = ctx.pdoc()->string_pool.intern(a_values[0].to_string());
        if (a_values.length >= 2 && a_values[1].is_url())
          s.prototype_url = ctx.pdoc()->string_pool.intern( a_values[1].get_url());
      } else if (is_none_value(a_values[0])) {
        s.prototype_url.clear();
        s.prototype = ctx.pdoc()->string_pool.intern("none");
      }
      break;
    }
    case cssa_aspect: {
      for (int n = 0; n < a_values.size(); ++n) {
        //if (n == 0) s.handler_list.clear();

        string                   fn;
        dictionary<value, value> params;

        if (a_values[n].is_function()) {
          function_value *pf = a_values[n].get_function();
          fn                 = pf->name;
          params             = pf->params;
        } else if (!a_values[n].is_string())
          continue;
        else
          fn = a_values[n].to_string();
        string ur;
        if ((n + 1) < a_values.size() && a_values[n + 1].is_url())
          ur = a_values[++n].get_url();
        s.handler_list.append(fn, ur, params);
      }
      break;
    }

#endif
    case cssa_content: {
      static pool<value> t;
      s.content = t.intern(a_values[0]);
      /*if(a_values[0].is_string())
        s.content = ctx.pdoc()->ustring_pool.intern( a_values[0].to_string() );
      else if(is_none_value(a_values[0]))
        s.content.clear();*/
    } break;
    case cssa_z_index: {
      value v(a_values[0]);
      s.z_index = v.to_int();
      break;
    }
    case cssa_role: {
      static pool<ustring> t;
      if (a_values.size() == 1 && is_none_value(a_values[0]))
        s.role = ustring();
      else
        s.role = t.intern(a_values[0].to_string());
      break;
    }

    case cssa_outline_width:
      length_value(s.outline_width, a_values[0]);
      break;
    case cssa_outline_offset:
      length_value(s.outline_offset, a_values[0]);
      break;
    case cssa_outline_color:
      color_value(s.outline_color, a_values[0]);
      break;
    case cssa_outline_style:
      s.outline_style = a_values[0];
      break;
    case cssa_outline: outline(s, a_values); break;
    case cssa_outline_shift:
      if (a_values.size() == 1) {
        length_value(s.outline_shift_x, a_values[0]);
        s.outline_shift_y = s.outline_shift_x;
      } else if (a_values.size() == 2) {
        length_value(s.outline_shift_x, a_values[0]);
        length_value(s.outline_shift_y, a_values[1]);
      }
      break;
    case cssa_outline_shift_x:
      length_value(s.outline_shift_x, a_values[0]);
      break;
    case cssa_outline_shift_y:
      length_value(s.outline_shift_y, a_values[0]);
      break;

    case cssa_transition:
      parse_transition(s, a_values);
      break;

    case cssa_transition_delay:
      if (!s.transitions)
        s.transitions = new transition_def();
      if (a_values.length > 1)
        s.transitions->delay = value::make_array(a_values);
      else
        s.transitions->delay = a_values[0];
      break;
    case cssa_transition_duration:
      if (!s.transitions)
        s.transitions = new transition_def();
      if (a_values.length > 1)
        s.transitions->duration = value::make_array(a_values);
      else
        s.transitions->duration = a_values[0];
      break;
    case cssa_transition_property:
      if (!s.transitions)
        s.transitions = new transition_def();
      if (a_values.length > 1)
        s.transitions->prop_name = value::make_array(a_values);
      else
        s.transitions->prop_name = a_values[0];
      break;
    case cssa_transition_timing_function:
      if (!s.transitions)
        s.transitions = new transition_def();
      if (a_values.length > 1)
        s.transitions->timing_func = value::make_array(a_values);
      else
        s.transitions->timing_func = a_values[0];
      break;

    case cssa_animation:
    {
      //s.animation_name.clear(); ???
      s.animation_delay.clear();
      s.animation_duration.clear();
      s.animation_iteration_count.clear();
      s.animation_timing_function.clear();
      s.animation_fill_mode.clear();
      s.animation_direction.clear();
      int ndurations = 0;
      for (int n = 0; n < a_values.size(); ++n) {
        auto c = get_counter_v(a_values[n]);
        if (c.is_defined()) {
          s.animation_iteration_count = c;
          continue;
        }
        auto t = get_duration_v(a_values[n]);
        if (t.is_defined()) {
          switch (++ndurations) {
            case 1: s.animation_duration = t; break;
            case 2: s.animation_delay = t; break;
          }
          continue;
        }

        if (s.animation_fill_mode.set(a_values[n]))
          continue;
        if (s.animation_direction.set(a_values[n]))
          continue;
        {
          auto tf = ease::get_ease_func(a_values[n]);
          if (tf.is_defined()) {
            s.animation_timing_function = tf;
            continue;
          }
        }
        if (a_values[n].is_string()) {
          s.animation_name = ctx.pdoc()->string_pool.intern(a_values[n].to_string());
          s.animation_style_bag = pb;
        }
      }

    } break;

    case cssa_animation_name:
      s.animation_style_bag = pb;
      s.animation_name = ctx.pdoc()->string_pool.intern(a_values[0].get_string());
      break;

    case cssa_animation_delay:
      s.animation_delay = get_duration_v(a_values[0]);
      break;
    case cssa_animation_duration:
      s.animation_duration = get_duration_v(a_values[0]);
      break;
    case cssa_animation_iteration_count:
      s.animation_iteration_count = get_counter_v(a_values[0]);
      break;
    case cssa_animation_timing_function:
      //if (a_values[0].is_string())
      s.animation_timing_function = ease::get_ease_func(a_values[0]);
      break;
    case cssa_animation_fill_mode: s.animation_fill_mode = a_values[0]; break;
    case cssa_animation_direction: s.animation_direction = a_values[0]; break;
    case cssa_animation_play_state: s.animation_play_state = a_values[0];
      break;

    case cssa_transform: s.transforms = parse_transform(a_values); break;
    case cssa_transform_origin: parse_transform_origin(s, a_values); break;
    case cssa_transform_origin_x: s.transform_origin_x = a_values[0]; break;
    case cssa_transform_origin_y: s.transform_origin_y = a_values[0]; break;

    case cssa_text_overflow: s.text_overflow = a_values[0]; break;
    case cssa_position: s.position = a_values[0]; break;
    case cssa_left: length_value(s.left, a_values[0]); break;
    case cssa_right: length_value(s.right, a_values[0]); break;
    case cssa_top: length_value(s.top, a_values[0]); break;
    case cssa_bottom: length_value(s.bottom, a_values[0]); break;
    case cssa_vertical_scrollbar:
      if (a_values[0].is_string())
        s.vscrollbar = ctx.pdoc()->string_pool.intern(a_values[0].to_string());
      else if (is_none_value(a_values[0]))
        s.vscrollbar = as_none;
      // else if(a_values[0].is_color())
      //  s.vscrollbar = a_values[0];
      break;
    case cssa_horizontal_scrollbar:
      if (a_values[0].is_string())
        s.hscrollbar = ctx.pdoc()->string_pool.intern(a_values[0].to_string());
      else if (is_none_value(a_values[0]))
        s.hscrollbar = as_none;
      // else if(a_values[0].is_color())
      //  s.hscrollbar = a_values[0];
      break;
    case cssa_style_set:
      if (a_values[0].is_string())
        s.style_set = ctx.pdoc()->string_pool.intern(a_values[0].to_string());
      else if (is_none_value(a_values[0])) {
        s.style_set = ctx.pdoc()->string_pool.intern("none");
        // s.style_set.clear();
      }
      break;
    case cssa_style_set_base:
      if (a_values[0].is_string())
        s.style_set_base = ctx.pdoc()->string_pool.intern(a_values[0].to_string());
      else if (is_none_value(a_values[0])) {
        s.style_set_base = ctx.pdoc()->string_pool.intern("none");
      }
      break;

    case cssa_appearance: 
      s.appearance = a_values[0]; 
      break;
    
    case cssa_border_spacing:
      if (a_values.size() > 1) {
        length_value(s.border_spacing_x, a_values[0]);
        length_value(s.border_spacing_y, a_values[1]);
      } else {
        length_value(s.border_spacing_x, a_values[0]);
        s.border_spacing_y = s.border_spacing_x;
      }
      break;
    case cssa_border_spacing_x: s.border_spacing_x = a_values[0]; break;
    case cssa_border_spacing_y: s.border_spacing_y = a_values[0]; break;

    case cssa_border_collapse: s.border_collapse = a_values[0]; break;

    case cssa_opacity: s.opacity = a_values[0]; break;
    case cssa_page_break_before:
      page_break_style(s.page_break_before, a_values[0]);
      break;
    case cssa_page_break_after:
      page_break_style(s.page_break_after, a_values[0]);
      break;
    case cssa_page_break_inside:
      page_break_style(s.page_break_inside, a_values[0]);
      break;
    //case cssa_display_model:
    //  display_model(s.display_model, a_values[0]);
    //  break;

    case cssa_hit_margin:
      switch (a_values.size()) {
      case 1:
        length_value(s.hit_margin[0], a_values[0]);
        s.hit_margin[3] = s.hit_margin[2] = s.hit_margin[1] =
            s.hit_margin[0];
        break;
      case 2:
        length_value(s.hit_margin[1], a_values[0]);
        s.hit_margin[3] = s.hit_margin[1];
        length_value(s.hit_margin[0], a_values[1]);
        s.hit_margin[2] = s.hit_margin[0];
        break;
      case 3:
        // BODY { hit_margin: 1em 2em 3em } /* top=1em, right=2em, bottom=3em,
        // left=2em */
        length_value(s.hit_margin[1], a_values[0]);
        length_value(s.hit_margin[2], a_values[1]);
        length_value(s.hit_margin[3], a_values[2]);
        s.hit_margin[0] = s.hit_margin[2];
        break;
      case 4:
        length_value(s.hit_margin[1], a_values[0]);
        length_value(s.hit_margin[2], a_values[1]);
        length_value(s.hit_margin[3], a_values[2]);
        length_value(s.hit_margin[0], a_values[3]);
        break;
      }
      break;

    case cssa_text_transform: s.text_transform = a_values[0]; break;

    case cssa_text_shadow: 
      s.text_shadow = nullptr;
      if (a_values[0].is_resource() &&
        a_values[0].get_resource()->is_of_type<shadow_def>())
        s.text_shadow = static_cast<shadow_def *>(a_values[0].get_resource());
      else
        shadow_style(s.text_shadow, a_values); 
      break;
    case cssa_box_shadow:
      s.box_shadow = nullptr;
      if (a_values[0].is_resource() &&
          a_values[0].get_resource()->is_of_type<shadow_def>())
        s.box_shadow = static_cast<shadow_def *>(a_values[0].get_resource());
      else {
        shadow_style(s.box_shadow, a_values);
      }
      break;

    case cssa_tab_size: s.tab_size = a_values[0].get(0); break;

    case cssa_mapping: mapping(s.mapping, a_values); break;
    case cssa_popup_position:
      popup_position(s.popup_pref_point, s.popup_aref_point, a_values);
      break;
    case cssa_popup_attachment:
      s.popup_attachment = a_values[0]; break;
#if 0
    case cssa_act_hover_on:
      s.act_hover_on = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_hover_off:
      s.act_hover_off = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_active_on:
      s.act_active_on = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_active_off:
      s.act_active_off = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_focus_on:
      s.act_focus_on = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_focus_off:
      s.act_focus_off = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_click:
      s.act_click = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_double_click:
      s.act_double_click = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_value_changed:
      s.act_value_changed = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_size_changed:
      s.act_size_changed = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_assigned:
      s.act_assigned = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_validate:
      s.act_validate = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_key_on:
      s.act_key_on = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_key_off:
      s.act_key_off = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_timer:
      s.act_timer = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_animation_step:
      s.act_animation_step = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_animation_end:
      s.act_animation_end = (eval::conduit *)a_values[0].get_object();
      break;
    case cssa_act_animation_start:
      s.act_animation_start = (eval::conduit *)a_values[0].get_object();
      break;
#endif

    case cssa_fill:
      if (color_value(s.fill_color, a_values[0]))
        ;
      else if (a_values[0].is_url())
        s.fill_id =
            ctx.pdoc()->string_pool.intern(a_values[0].get_url()().r_tail('#'));
      break;

    case cssa_fill_opacity: 
      s.fill_opacity = a_values[0]; 
      break;

    case cssa_fill_rule: s.fill_rule = a_values[0]; break;

    case cssa_stroke:
      // if(a_values[0].is_color())
      //  s.stroke_color = a_values[0].get_color();
      if (color_value(s.stroke_color, a_values[0]))
        ;
      else if (a_values[0].is_url())
        s.stroke_id = ctx.pdoc()->string_pool.intern(a_values[0].get_url()().r_tail('#'));
      break;

    case cssa_stroke_width: s.stroke_width.set(a_values[0],size_v::NUMERIC_TO_NUMERIC); break;
    case cssa_stroke_linecap: s.stroke_linecap = a_values[0]; break;
    case cssa_stroke_linejoin: s.stroke_linejoin = a_values[0]; break;
    case cssa_stroke_miterlimit: s.stroke_miterlimit = a_values[0]; break;
    case cssa_stroke_dasharray: 
      if (a_values.length && a_values[0].is_number())
        s.stroke_dasharray = value::make_array(a_values);
      else s.stroke_dasharray.clear();
      break;
    case cssa_stroke_dashoffset:  s.stroke_dashoffset = a_values[0]; break;
    case cssa_stroke_opacity:  s.stroke_opacity = a_values[0]; break;
    // <stop> parts in gradients
    case cssa_stop_color: s.stroke_color = a_values[0]; break;
    case cssa_stop_opacity: s.stroke_opacity = a_values[0]; break;
    }

    return true;
  }

  value style::to_value(const string &name) const {
    if (name.length() == 0) return value();

    tool::value av;

    if (name[0] == '-') {
      if (!custom.get(name, av)) return value();
    } else
      av = to_value(cssa::symbol(name));

    /*if (av.is_variable_color()) {
      color_v cv;
      color_value(cv, av);
      return color_v(resolve_color(cv)).to_value();
    } else if (av.is_variable_length())
      return size_v(resolve_length(size_v(av)));*/
    return av;
  }

  static bool margins_are_equal(const style *ps) {
    return ps->margin[0] == ps->margin[1] && ps->margin[0] == ps->margin[2] &&
           ps->margin[0] == ps->margin[3];
  }

  /*static bool paddings_are_equal(const style *ps) {
    return ps->padding[0] == ps->padding[1] &&
           ps->padding[0] == ps->padding[2] && ps->padding[0] == ps->padding[3];
  }*/

  value style::to_value(cssa::symbol_t css_att_sym) const {

    switch(css_att_sym) 
    {

      default: return value();

      case cssa_direction: return direction.to_value();
      case cssa_font: break;
      case cssa_font_family: return value(font_family); break;
      case cssa_font_size: return font_size.to_value();
      case cssa_font_style: return font_style.to_value();
      case cssa_font_rendering_mode: return font_rendering_mode.to_value();
      case cssa_font_variant_ligatures: return font_variant_ligatures.to_value();
      case cssa_letter_spacing: return letter_spacing.to_value();
      case cssa_font_weight: return font_weight.to_value();
      case cssa_line_height: return line_height.to_value();
      case cssa_text_decoration: break;
      case cssa_text_decoration_line: return text_decoration_line.to_value();
      case cssa_text_decoration_style: return text_decoration_style.to_value();
      case cssa_text_decoration_color: return text_decoration_color.to_value();
      case cssa_text_decoration_thickness: return text_decoration_thickness.to_value();

      case cssa_color: return font_color.to_value();
      case cssa_zoom: return zoom.to_value();
      case cssa_text_selection_color: return text_selection_color.to_value();
      case cssa_text_selection_background_color: return text_selection_background_color.to_value();
      case cssa_text_selection_caret_color: return text_selection_caret_color.to_value();
      case cssa_text_selection: break;
      case cssa_height: return height.to_value();
      case cssa_width: return width.to_value();
      case cssa_size: break;
      case cssa_box_sizing: return box_sizing.to_value();
      case cssa_clip_box: return clip_box.to_value();
      case cssa_min_height: return min_height.to_value();
      case cssa_min_width: return min_width.to_value();
      case cssa_max_height: return max_height.to_value();
      case cssa_max_width: return max_width.to_value();
      case cssa_text_align: return text_align.to_value();
      case cssa_text_indent: return text_indent.to_value();
      case cssa_vertical_align: return vertical_align.to_value();
      case cssa_horizontal_align: return horizontal_align.to_value();

      case cssa_content_vertical_align: return content_vertical_align.to_value();
      case cssa_content_horizontal_align: return horizontal_align.to_value();

      case cssa_white_space: return white_space.to_value();
      case cssa_word_wrap: return word_wrap.to_value(); 
      case cssa_word_break: return word_break.to_value();
      case cssa_background_color: return back_color.to_value();

      case cssa_background: break;

      case cssa_background_gradient: return back_gradient.to_value();
      case cssa_background_attachment: return back_image.attachment.to_value();
      case cssa_background_image: return back_image.id.to_value();

      case cssa_background_position: break;
    
      case cssa_background_position_top: return back_image.margin[1].to_value();
      case cssa_background_position_left: return back_image.margin[0].to_value();
      case cssa_background_position_right: return back_image.margin[2].to_value();
      case cssa_background_position_bottom: return back_image.margin[3].to_value();
      case cssa_background_repeat: return back_image.repeat.to_value();
  #pragma TODO("cssa_background_image_transformation")    
      case cssa_background_image_transformation: break;

      case cssa_background_size: break;
      case cssa_background_width: return back_image.dim[0].to_value();
      case cssa_background_height: return back_image.dim[1].to_value();
      case cssa_background_clip: return back_image.clip.to_value();
      case cssa_background_frame_no: return back_image.frame_no.to_value();
      //case cssa_background_blend_mode: return back_image.blend_mode.to_value();

      case cssa_foreground_size: break;
      case cssa_foreground_width: return fore_image.dim[0].to_value();
      case cssa_foreground_height: return fore_image.dim[1].to_value();
      case cssa_foreground_clip: return fore_image.clip.to_value();
      case cssa_foreground_frame_no: return fore_image.frame_no.to_value();
      //case cssa_foreground_blend_mode: return fore_image.blend_mode.to_value();
      case cssa_image_rendering: return image_rendering.to_value();
  #pragma TODO("cssa_filter")
      case cssa_filter: /*filter_value(s.filters, a_values);*/ break; 
      case cssa_foreground: break;
      case cssa_foreground_color: return fore_color.to_value();
      case cssa_foreground_attachment: return fore_image.attachment.to_value();
      case cssa_foreground_image: return fore_image.id.to_value();
      case cssa_foreground_position: break;
      case cssa_foreground_position_top: return fore_image.margin[1].to_value();
      case cssa_foreground_position_left: return fore_image.margin[0].to_value();
      case cssa_foreground_position_right: return fore_image.margin[2].to_value();
      case cssa_foreground_position_bottom: return fore_image.margin[3].to_value();
      case cssa_foreground_repeat: return fore_image.repeat.to_value();
  #pragma TODO("cssa_foreground_image_transformation")    
      case cssa_foreground_image_transformation: break;
      case cssa_foreground_gradient: return fore_gradient.to_value();
      case cssa_border: break;

      case cssa_border_bottom: break;
      case cssa_border_bottom_color: return border_color[3].to_value();
      case cssa_border_bottom_style: return border_style[3].to_value();
      case cssa_border_bottom_width: return border_width[3].to_value();
      case cssa_border_color: break;

      case cssa_border_left: break;
      case cssa_border_left_color: return border_color[0].to_value();
      case cssa_border_left_style: return border_style[0].to_value();
      case cssa_border_left_width: return border_width[0].to_value();

      case cssa_border_right: break;
      case cssa_border_right_color: return border_color[2].to_value();
      case cssa_border_right_style: return border_style[2].to_value();
      case cssa_border_right_width: return border_width[2].to_value();

      case cssa_border_style: break;
      case cssa_border_top: break;

      case cssa_border_top_color: return border_color[1].to_value();
      case cssa_border_top_style: return border_style[1].to_value();
      case cssa_border_top_width: return border_width[1].to_value();

      case cssa_border_width: break;
      case cssa_border_radius: break;

      case cssa_border_top_left_radius: break;
      case cssa_border_top_right_radius: break;
      case cssa_border_bottom_right_radius: break;
      case cssa_border_bottom_left_radius: break;

      case cssa_border_top_left_radius_x: return border_radius[0].to_value();
      case cssa_border_top_left_radius_y: return border_radius[1].to_value();
      case cssa_border_top_right_radius_x: return border_radius[2].to_value();
      case cssa_border_top_right_radius_y: return border_radius[3].to_value();
      case cssa_border_bottom_right_radius_x: return border_radius[4].to_value();
      case cssa_border_bottom_right_radius_y: return border_radius[5].to_value();
      case cssa_border_bottom_left_radius_x: return border_radius[6].to_value();
      case cssa_border_bottom_left_radius_y: return border_radius[7].to_value();

      case cssa_clear: return clears.to_value();
      case cssa_float: return floats;

      case cssa_margin: break;
      case cssa_margin_bottom: return margin[3].to_value();
      case cssa_margin_left: return margin[0].to_value();
      case cssa_margin_right: return margin[2].to_value();
      case cssa_margin_top: return margin[1].to_value();

      case cssa_padding: break;
      case cssa_padding_bottom: return padding_width[3].to_value();
      case cssa_padding_left: return padding_width[0].to_value();
      case cssa_padding_right: return padding_width[2].to_value();
      case cssa_padding_top: return padding_width[1].to_value();

      case cssa_list_style: break;
      case cssa_list_style_image: return list_style_image.to_value();
      case cssa_list_style_position: return list_style_position.to_value();
      case cssa_list_style_type: return list_style_type.to_value();

      case cssa_list_marker_color: return list_marker_color.to_value();
      case cssa_list_marker_size: return list_marker_size.to_value();
      case cssa_list_marker_style: return list_marker_style.to_value();
    
      case cssa_overflow: break;
      case cssa_overflow_x: return overflow_x.to_value();
      case cssa_overflow_y: return overflow_y.to_value();
    
      case cssa_scroll_manner: break;
      case cssa_scroll_manner_x: return scroll_manner_x;
      case cssa_scroll_manner_y: return scroll_manner_y;
    
      case cssa_cursor: return cursor.to_value();
      case cssa_foreground_image_cursor:  return foreground_image_cursor.to_value();

      case cssa_display: return display.to_value();
      case cssa_flow: return flow.to_value();
      case cssa_visibility: return visibility.to_value();
      case cssa_behavior: return behavior.to_value();
      case cssa_context_menu: 
        if(context_menu_url.is_defined())
           return value(ustring(context_menu_url),value::UT_URL);
        else if (context_menu_sel.is_defined())
           return value(ustring(context_menu_sel),value::UT_SELECTOR);

      case cssa_draggable: 
        //draggable_value(s.draggable, a_values[0]);
        break;
      case cssa_accept_drop:
        if (accept_drop.is_defined())
          return value(ustring(accept_drop), value::UT_SELECTOR);
        break;
      case cssa_drop: 
        //drop_value(s.drop, a_values[0]); 
        break;

  #if defined(SCITER) || defined(SCITERJS)
      case cssa_prototype: {
        if(prototype.is_defined()) {
          value va[2] = {
            value(ustring(prototype)),
            value(ustring(prototype_url), value::UT_URL)
          };
          return value::make_array(items_of(va));
        } else
          break;
      }
      case cssa_aspect: return handler_list.to_value();
  #endif
      case cssa_content: return content;
      case cssa_z_index: return z_index.to_value();
      case cssa_role: return role.to_value();

      case cssa_outline_width: return outline_width.to_value();
      case cssa_outline_offset: return outline_offset.to_value();
      case cssa_outline_color: return outline_color.to_value();
      case cssa_outline_style: return outline_style.to_value();
      case cssa_outline: break;
      case cssa_outline_shift: break;
      case cssa_outline_shift_x: return outline_shift_x.to_value();
      case cssa_outline_shift_y: return outline_shift_y.to_value();
      case cssa_transition:
        //parse_transition(s, a_values);
  #pragma TODO("cssa_transition")    
        break;
      case cssa_transition_delay:
        if (transitions) return transitions->delay;
        break;
      case cssa_transition_duration:
        if (transitions) return transitions->duration;
        break;
      case cssa_transition_property:
        if (transitions) return transitions->prop_name;
        break;
      case cssa_transition_timing_function:
        if (transitions) return transitions->timing_func;
        break;

      case cssa_animation: break;
      case cssa_animation_name:
        if (animation_name.is_defined())
          return value(animation_name);
        break;
      case cssa_animation_delay: return animation_delay.to_value();
      case cssa_animation_duration: return animation_duration.to_value();
      case cssa_animation_iteration_count: return animation_iteration_count.to_value();
      case cssa_animation_timing_function:
        //s.animation_timing_function = ease::get_ease_func(a_values[0].get_string());
        break;
      case cssa_animation_fill_mode: return animation_fill_mode.to_value();
      case cssa_animation_direction: return animation_direction.to_value();
      case cssa_animation_play_state: return animation_play_state.to_value();

      case cssa_transform: return transforms.to_value();
      case cssa_transform_origin: break;
      case cssa_transform_origin_x: return transform_origin_x.to_value();
      case cssa_transform_origin_y: return transform_origin_y.to_value();

      case cssa_text_overflow: return text_overflow.to_value();
      case cssa_position: return position.to_value();
      case cssa_left: return left.to_value();
      case cssa_right: return right.to_value();
      case cssa_top: return top.to_value();
      case cssa_bottom: return bottom.to_value();

      case cssa_vertical_scrollbar: return vscrollbar.to_value();
      case cssa_horizontal_scrollbar: return hscrollbar.to_value();
    
      case cssa_style_set: return style_set.to_value();
      case cssa_appearance: return appearance.to_value();
    
      case cssa_border_spacing: break;
      case cssa_border_spacing_x: return border_spacing_x.to_value();
      case cssa_border_spacing_y: return border_spacing_y.to_value();
      case cssa_border_collapse: return border_collapse.to_value();
    
      case cssa_opacity: return opacity.to_value();
      case cssa_page_break_before: return page_break_before.to_value();
      case cssa_page_break_after: return page_break_after.to_value();
      case cssa_page_break_inside: return page_break_inside.to_value();
      case cssa_hit_margin: 
        if (hit_margin[0].is_defined()) {
          value ma[4] = { hit_margin[0] ,hit_margin[1],hit_margin[2],hit_margin[3] };
          return value::make_array(items_of(ma));
        }
        break;

      case cssa_text_transform: return text_transform.to_value();
      case cssa_text_shadow: return text_shadow.to_value();
      case cssa_box_shadow: return box_shadow.to_value();

      case cssa_tab_size: return tab_size.to_value();
      case cssa_mapping: return mapping.to_value();

      case cssa_popup_position:
        if (popup_pref_point.is_defined()) {
          value ma[2] = { popup_pref_point.to_value() ,popup_aref_point.to_value() };
          return value::make_array(items_of(ma));
        }
        break;
      case cssa_popup_attachment: return popup_attachment.to_value();

      /*case cssa_act_hover_on:
      case cssa_act_hover_off:
      case cssa_act_active_on:
      case cssa_act_focus_on:
      case cssa_act_focus_off:
      case cssa_act_click:
      case cssa_act_double_click:
      case cssa_act_value_changed:
      case cssa_act_size_changed:
      case cssa_act_assigned:
      case cssa_act_validate:
      case cssa_act_key_on:
      case cssa_act_key_off:
      case cssa_act_timer:
      case cssa_act_animation_step:
      case cssa_act_animation_end:
      case cssa_act_animation_start:
        break;*/

      case cssa_fill: return fill_color.to_value();
      case cssa_fill_opacity: return fill_opacity.to_value();
      case cssa_fill_rule: return fill_rule.to_value();
      case cssa_stroke: return stroke_color.to_value();
      case cssa_stroke_width: return stroke_width.to_value();
      case cssa_stroke_linecap: return stroke_linecap.to_value();
      case cssa_stroke_linejoin: return stroke_linejoin.to_value();
      case cssa_stroke_miterlimit: return stroke_miterlimit.to_value();
      case cssa_stroke_dasharray: return stroke_dasharray;
      case cssa_stroke_dashoffset:  return stroke_dashoffset.to_value();
      case cssa_stroke_opacity:  return stroke_opacity.to_value();
        // <stop> parts in gradients
      case cssa_stop_color: return stroke_color.to_value(); break;
      case cssa_stop_opacity: return stroke_opacity.to_value(); break;
    }

    return value();
  }

} // namespace html
