#include "html.h"

namespace html {
  using namespace tool;
  using namespace gool;

  bool style_prop_list::apply_to(const element_context& ctx, style &s, uint inherit_mode, bool apply_important) {
//#pragma TODO("CSS:actions,custom,vars")

    if (apply_important) {
      for (auto& pair : important_props) {
        if (pair.val.is_array())
          set_attribute_value(ctx, s, pair.sym, pair.val.values());
        else
          set_attribute_value(ctx, s, pair.sym, slice<value>(pair.val));
      }
      return important_props.size() > 0;
    }
    else {

      //for (auto& pair : vars.elements()) s.vars.set(pair.key, pair.val);
      for (auto& pair : custom.elements()) s.custom.set(pair.key, pair.val);

      for (auto& pair : props) {
        if(pair.val.is_array())
          set_attribute_value(ctx, s, pair.sym, pair.val.values(), pbag);
        else
          set_attribute_value(ctx, s, pair.sym, slice<value>(pair.val), pbag);
      }
      return false;
    }
  }

  void style_prop_list::apply_variables(const element_context& ctx, style &s) {
    for (auto& pair : vars.elements()) s.vars.set(pair.key, pair.val);
  }

  bool style_prop_list::set(cssa::name_or_symbol name, slice<value> vals, bool important) {
    array<prop_item>& list = important ? important_props : props;
    if (vals.length == 1)
      set(name, vals[0], important);
    else
      set(name,value::make_array(vals),important);
    return true;
  }

  bool style_prop_list::set(cssa::name_or_symbol name, value val, bool important) {
    array<prop_item>& list = important ? important_props : props;
    list.push({ name.att_sym, val });
    if (name.att_sym == cssa_style_set)
      style_set_name = val.to_string();
    else if (name.att_sym == cssa_style_set_base)
      style_set_name_base = val.to_string();
    else if (name.att_sym == cssa_appearance)
      appearance = val;
    return true;
  }

  void style_prop_list::set_action(const string& name, value val) { actions[name] = val; }
  void style_prop_list::set_custom(const string& name, value val) { custom[name] = val; }
  bool style_prop_list::set_var(const string& name, value val) {
    if (vars(name) != val) { vars[name] = val; return true; }
    return false;
  }




}
