#ifndef __html_style_parser_h
#define __html_style_parser_h

#include "tool/tool.h"
#include "tool/eval/tl_eval.h"
#include "gool/gool.h"
#include "html-style.h"
#include "html-style-atts.h"

namespace html {
  using namespace tool;
  using namespace gool;

  bool eval_media_query(view *pv /*or null*/, document *doc,
                        eval::conduit *code, bool &res);

  struct css_istream {
    string       url;
    int          line_no;
    const wchar *start;
    const wchar *end;
    const wchar *pos;
    const wchar *prev_pos;
    array<wchar> _token_value;

    enum _ {
      ESCAPE_CHAR = '\\',
    };

    enum TOKEN_TYPE {
      T_ERROR   = -1,
      T_EOF     = 0,
      T_NMTOKEN = 256,
      T_ID,        // #nmtoken
      T_PSEUDO,    // :nmtoken, state class
      T_PSEUDO_EL, // ::nmtoken, pseudo element
      T_CLASS,     // .nmtoken
      T_ATRULE,    // @nmtoken

      T_STRING,      // "abc" or 'abc'
      T_INTEGER,     // integer
      T_NUMBER_UNIT, // 1px
      T_FLOAT,       // 0.5
      T_DURATION,    // 0.5s
      T_ANGLE,       // 45deg, 1rad, etc.
      T_DPI,         // 200dpi, 100dpi, etc.

      T_MATCH_LIST,       // ~=
      T_MATCH_LIST_ICASE, // %= - case insensitive match
      T_MATCH_FIRST,      // |=
      T_MATCH_PREFIX,     // ^=
      T_MATCH_SUFFIX,     // $=
      T_MATCH_SUBSTR,     // *=
      T_MATCH_ICASE,      // #=

      T_URL,       // "url(abc)" , token_value == abc
      T_CALC,      // "calc(csss! expr)" , token_value == csss! expr
      T_FUNCTION,  // "nmtoken(" , token_value == nmtoken
      T_COLOR,     // token_value == #XXX ... #XXXXXXXX
      T_SELECTOR,  // "selector(...css selector...)"
      T_IMPORTANT, // !impportant
      T_VARIABLE_NAME,
      T_VARIABLE_VAL,

    };

    enum NMTOKEN_VARIATIONS {
      NMTOKEN_DEFAULT,
      NMTOKEN_PLUS_DOT,
      NMTOKEN_PLUS_AT,
    };

    css_istream(wchars text, const string &src_url, int initial_lineno = 1) {
      url      = src_url;
      prev_pos = pos = start = text.start;
      end                    = text.end();
      line_no                = initial_lineno;
    }

    wchars token_value() {
      _token_value.push(0);
      _token_value.pop();
      return _token_value();
    }

    auto& token_value_ref() {
      return _token_value;
    }

    int s_token(bool ws_ignore  = false,
                bool inside_nth = false); // selector token
    int b_token();                        // body token
    int a_token();                        // attribute value token

    wchars scan_until(const wchar *delimeters);

    wchar skip_spaces();

    inline void push_back() { 
      for (const wchar* pc = pos - 1; pc >= prev_pos; --pc)
        if (*pc == '\n') 
          --line_no;
      pos = prev_pos; 
    }

    // ATTN: this is not a full implementation of CSS escape.
    bool unescape(wchar &ch);
    /*{
      if( ch == ESCAPE_CHAR )
      {
        ++pos; if( pos >= end ) return false;
        ch = *pos;
        return true;
      }
      return false;
    }*/

    bool scan_number();
    int  scan_number_unit(); // scan number with units px,mm,ex,em,etc. returns
                             // T_NUMBER_UNIT / T_FLOAT
    bool scan_nmtoken(NMTOKEN_VARIATIONS ntv = NMTOKEN_DEFAULT);
    bool scan_attr_name();
    bool scan_name();
    bool scan_chars_only(); // scans only isalpha sequences.
    bool scan_string();
    bool scan_color();

    bool skip_comment();

    bool parse_value(value &val);
  };

  enum PAV_RESULT {
    PAV_OK               = 0,
    PAV_UNKNOWN_PROPERTY = 1,
    PAV_BAD_VALUE        = 2,
  };

  //PAV_RESULT parse_attribute_value(document *pd, const string &url, style *pcs,
  //                                 css_istream &s, const string &a_name,
  //                                 style_bag *sb = 0);
  //PAV_RESULT parse_attribute_value(document *pd, style *pcs,
  //                                 const string &a_name, const ustring &v);

  enum CAV_MODE {
    CAV_DEFAULT = 0,
    CAV_FONT_MODE = 1,
    CAV_FORCE_COMMA_LIST = 2
  };
  
  bool crack_attribute_value(document *pd, const string &url, css_istream &s,
                             array<value> &a_values, bool &is_important,
                             style_bag *sb  = 0,
                             CAV_MODE parsing_mode = CAV_DEFAULT);
  void clear_attribute_value(document *pd, style *pcs, const string &a_name);

  bool  parse_custom_attribute_value(document *pd, const string &url,css_istream &s, value &val, style_bag *sb = 0);
  bool  parse_variable_value(document *pd, const string &url, css_istream &s, value &val, style_bag *sb = 0);
  //bool  parse_action_attribute_value(document *pd, const string &url, css_istream &s, array<value> &a_values, style_bag *sb);
  value parse_function(tokenz &zz, const string &token, const string &url);
  value parse_value(const ustring &token);
  bool  parse_value(document *pd, const string &base_url, css_istream &s, value &v);
  bool  parse_css_value(html::context& c, wchars text, value &v);
  bool  parse_css_value(html::context& c, chars text, value &v);

  void parse_css_property_as(document *d, cssa::name_or_symbol attr_sym, wchars val, style_prop_list *s);
 
  extern string combine_behavior(document *pd, const string &v, const string &nv);

  class style_parser {
  protected:
    css_istream s;

    string       a_name;
    array<value> a_values;

    string    url;
    document *doc;

    style *pcs;

    string     seqid; // sequentional id is used for rules reordering.
    style_bag *top_sb;

  public:
    handle<eval::conduit> media_expr; // active @media expression

    //typedef tool::value::unit_type unit_type;

    style_parser(const string &seq_id, wchars text, document *pd);
    style_parser(const string &seq_id, wchars text, document *pd,
                 const string &src_url, int line_no = 1);

    bool parse(wchars mquery, bool section = false, style_bag *sb = 0);
    bool parse_rules(string initial_seqid, string seqid, uint& import_cnt, style_bag *sb = 0);

    bool parse_body(style_prop_list& spl);

    bool parse_supports_expr(bool& block_open);
    
  protected:
    void skip_statement();
    void skip_block(bool open = false);
    void parse_import_statement(const string &is_seqid);
    void parse_include_statement();
    void parse_font_face_statement();
    void parse_image_map_statement();
    void parse_set_block(style_bag *parent_sb);
#if defined(SCSS)
    void parse_nested_declaration(style_bag *              sb,
                                  slice<handle<style_def>> outer_defs);
#endif
    void parse_const_declaration(style_bag *sb);
    void parse_media_section(style_bag *sb);
    void parse_mixin_declaration(style_bag *sb);
    void parse_keyframes_declaration(style_bag *sb);
    void parse_supports_section(string initial_seqid, string seqid, uint& import_cnt, style_bag *sb);

    bool load_style_sheet(const string &ss_seqid, string href, wchars mquery);
    bool load_resource(string href, string mime_type);
  };

  void parse_inline_style(style &st, wchars text, document *pd);
  void parse_style_sheet(const string &seqid, wchars text, document *pd,
                         const string &url, wchars mediaq);

} // namespace html

#endif