#ifndef __html_style_enums_h__
#define __html_style_enums_h__

#include "tool/tool.h"
#include "tool/tl_value_t.h"

#include "html-style-types.h"

#define ENUMV(T) html::enumv<T>

namespace html {

    template<typename E>
      enum_def* enum_pdef();

    template<class E>
      inline bool parse_enumv(enum_v &v, wchars us)
      {
        if (icmp(us, WCHARS("inherit"))) { v._v = enum_v::inherit_val(); return true; }
        //else if (icmp(us(), WCHARS("unset"))) { return value::none_val(); }
        else {
          enum_def* pdef = enum_pdef<E>();
          for (auto& it : pdef->items)
            if (icmp(us, it.token)) {
              v._v = it.value;
              return true;
            }
        }
        return false;
      }


    template<typename E>
      struct enumv : public enum_v
    {
      using code = E;
      enumv() : enum_v() {}
      enumv(int v) : enum_v(v) {}
      enumv(const value& v) : enum_v() { set(v); }
      operator value() const { return to_value(); }
      E val() const { return (E)(enum_v::val(0)); }
      E val(E dv) const { return (E)(enum_v::val(dv)); }
      ustring to_string() const { return enum_to_string(*this, enum_pdef<E>()->items); }
      value to_value() const {
        if (is_undefined()) return tool::value();
        else if (is_inherit()) return value::inherit_val();
        return value::make_enum(val(), enum_pdef<E>());
      }
      bool set(const value& v) {
        if (v.is_undefined()) return false;
        else if (v.is_inherit()) { _v = enum_v::inherit_val(); return true; }
        else if (v.is_none() && parse_enumv<E>(*this, WCHARS("none"))) { return true; }
        else if (v.is_auto() && parse_enumv<E>(*this, WCHARS("auto"))) { return true; }
        else if (v.is_enum() && v.get_enum_def() == enum_pdef<E>()) { _v = v.get_enum_code(); return true; }
        else if (v.is_string() && parse_enumv<E>(*this, v.to_string())) { return true; }
        else if (v.is_int()) { 
        _v = v.get_int(); return true; 
       }
        return false;
      }
      bool set(const ustring& s) { return parse_enumv<E>(*this, s); }
    };

    template<typename E>
    struct flagsv : public enumv<E> {
      flagsv() : enumv<E>() {}
      flagsv(int v) : enumv<E>(v) {}
      flagsv(const value& v) : enumv<E>() { enumv<E>::set(v); }

      operator value() const { return enumv<E>::operator value(); }

      void inherit(const flagsv<E> &v) {
        if (v.is_defined()) 
        {
          if(enum_v::is_undefined())
            this->_v = 0;
          if (v._v == 0)
            this->_v = 0;
          else
            this->_v |= v._v;
        }
      }

      bool set(const value& val) { 
        flagsv t;
        if (t.enumv<E>::set(val)) {
          inherit(t);
          return true;
        }
        return false;

        //if (val.is_array())
        //  set(val.get_array<value>()());
        //else
        //  return enumv<E>::set(val); 
      }
      bool set(slice<value> vals) {
        flagsv t; 
        int n = 0;
        for (auto v : vals) {
          if (t.set(v)) {
            inherit(t);
            ++n;
          }
        }
        return n > 0;
      }

      ustring to_string() const {
        if (enumv<E>::is_undefined()) return ustring();
        if (enumv<E>::is_inherit()) return W("inherit");
        auto idefs = enum_pdef<E>()->items;
        if (this->_v == 0) return idefs[0].token;
        ustring r;
        for (uint i = 0; i < idefs.length; ++i) {
          if ((this->_v & idefs[i].value) != 0) {
            if(r.length()) r += WCHARS(" ");
            r += chars_of(idefs[i].token);
          }
        }
        return r;
      }
    };

    enum direction_e {
      direction_ltr,
      direction_rtl,
      direction_ttb,
    };

    typedef html::enumv<direction_e> direction_ev;

    template<> inline enum_def* enum_pdef<direction_e>() {
      static enum_item_def edef[] = {
        { direction_ltr, W("ltr") },
        { direction_rtl, W("rtl") },
        { direction_ttb, W("ttb") },
      };
      static enum_def t = { W("direction"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<direction_e> direction_ev;

    //enum display_e

    template<> inline enum_def* enum_pdef<display_e>() {
      static enum_item_def edef[] = {
        { display_none,         W("none") },
        { display_block,        W("block") },
        { display_inline,       W("inline") },
        { display_inline_block, W("inline-block") },
        { display_list_item,    W("list-item") },
        { display_contents,     W("contents") },
        { display_table,        W("table") },
        { display_inline_table, W("inline-table") },
        { display_table_row,    W("table-row") },
        { display_table_cell,   W("table-cell") },
        { display_table_body,   W("table-body") },
      };
      static enum_def t = { W("display"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<display_e> display_ev;

    enum font_style_e {
      font_style_normal,
      font_style_italic,
      font_style_oblique,
    };

    typedef html::enumv<font_style_e> font_style_ev;

    template<> inline enum_def* enum_pdef<font_style_e>() {
      static enum_item_def edef[] = {
        { font_style_normal,  W("normal") },
        { font_style_italic,  W("italic") },
        { font_style_oblique, W("oblique") },
      };
      static enum_def t = { W("font-style"), items_of(edef) };
      return &t;
    }

    enum font_rendering_mode_e {
      font_rendering_mode_sub_pixel,
      font_rendering_mode_snap_pixel,
      font_rendering_mode_sub_pixel_scaled, // SVG rendering mode - sub-pixel and font size is in dips 
    };

    typedef html::enumv<font_rendering_mode_e> font_rendering_mode_ev;

    template<> inline enum_def* enum_pdef<font_rendering_mode_e>() {
      static enum_item_def edef[] = {
        { font_rendering_mode_sub_pixel,      W("sub-pixel") },
        { font_rendering_mode_snap_pixel,     W("snap-pixel") },
        { font_rendering_mode_sub_pixel,      W("enhanced") },
        { font_rendering_mode_sub_pixel,      W("scaleable") },
        { font_rendering_mode_snap_pixel,     W("classic") },
        { font_rendering_mode_sub_pixel_scaled,  W("sub-pixel-scaled") },
      };
      static enum_def t = { W("font-rendering-mode"), items_of(edef) };
      return &t;
    }

    enum white_space_e {
      white_space_normal,
      white_space_nowrap,
      white_space_pre,
      white_space_prewrap,
    };

    typedef html::enumv<white_space_e> white_space_ev;

    template<> inline enum_def* enum_pdef<white_space_e>() {
      static enum_item_def edef[] = {
        { white_space_normal,  W("normal") },
        { white_space_nowrap,  W("nowrap") },
        { white_space_pre,  W("pre") },
        { white_space_prewrap,  W("prewrap") },
        { white_space_nowrap,  W("no-wrap") },
        { white_space_prewrap,  W("pre-wrap") },
      };
      static enum_def t = { W("white-space"), items_of(edef) };
      return &t;
    }

    enum overflow_wrap_e {
      overflow_wrap_normal,
      overflow_wrap_break_word,
      overflow_wrap_anywhere,
    };

    typedef html::enumv<overflow_wrap_e> overflow_wrap_ev;

    template<> inline enum_def* enum_pdef<overflow_wrap_e>() {
      static enum_item_def edef[] = {
        { overflow_wrap_normal,  W("normal") },
        { overflow_wrap_break_word,  W("break-word") },
        { overflow_wrap_anywhere,  W("anywhere") },
      };
      static enum_def t = { W("overflow-wrap"), items_of(edef) };
      return &t;
    }

    enum word_break_e {
      word_break_normal,
      word_break_keep_all,
      word_break_break_all,
    };

    typedef html::enumv<word_break_e> word_break_ev;

    template<> inline enum_def* enum_pdef<word_break_e>() {
      static enum_item_def edef[] = {
        { word_break_normal,  W("normal") },
        { word_break_keep_all,  W("keep-all") },
        { word_break_break_all,  W("break-all") },
      };
      static enum_def t = { W("word-break"), items_of(edef) };
      return &t;
    }

    enum float_e {
      float_none,
      float_left,
      float_right,
    };

    typedef html::enumv<float_e> float_ev;

    template<> inline enum_def* enum_pdef<float_e>() {
      static enum_item_def edef[] = {
        { float_none,  W("none") },
        { float_left,  W("left") },
        { float_right, W("right") },
      };
      static enum_def t = { W("float"), items_of(edef) };
      return &t;
    }

    enum valign_e {
      valign_auto,
      valign_top,
      valign_middle,
      valign_bottom,
      valign_sub,
      valign_super,
      valign_baseline,
      valign_text_top,
      valign_text_bottom,
      valign_text_middle,
    };

    typedef html::enumv<valign_e> valign_ev;

    template<> inline enum_def* enum_pdef<valign_e>() {
      static enum_item_def edef[] = {
        { valign_auto,   W("auto") },
        { valign_top,    W("top") },
        { valign_middle, W("middle") },
        { valign_bottom, W("bottom") },
        { valign_sub,    W("sub") },
        { valign_super,  W("super") },
        { valign_baseline,  W("baseline") },
        { valign_text_top,  W("text-top") },
        { valign_text_bottom,  W("text-bottom") },
        { valign_text_middle,  W("text-middle") },
      };
      static enum_def t = { W("vertical-align"), items_of(edef) };
      return &t;
    }

    enum list_style_type_e {
      list_style_none,
      list_style_disc,
      list_style_circle,
      list_style_square,
      list_style_decimal,
      list_style_lower_roman,
      list_style_upper_roman,
      list_style_lower_alpha,
      list_style_upper_alpha,
      list_style_index,
      list_non_numeric,
      list_style_tree_lines,
    };

    typedef html::enumv<list_style_type_e> list_style_type_ev;

    template<> inline enum_def* enum_pdef<list_style_type_e>() {
      static enum_item_def edef[] = {
        { list_style_none,    W("none") },
        { list_style_disc,    W("disc") },
        { list_style_circle,  W("circle") },
        { list_style_square,  W("square") },
        { list_style_decimal, W("decimal") },
        { list_style_lower_roman,  W("lower-roman") },
        { list_style_upper_roman,  W("upper-roman") },
        { list_style_lower_alpha,  W("lower-alpha") },
        { list_style_upper_alpha,  W("upper-alpha") },
        { list_style_index,   W("index") },
        { list_style_tree_lines,  W("tree-line") },
      };
      static enum_def t = { W("list-style-type"), items_of(edef) };
      return &t;
    }


    enum halign_e {
      align_auto,
      align_left,
      align_center,
      align_right,
      align_justify,
      align_start, // if(direction == ltr) align_left, if(direction == rtl)
                   // align_right
                   align_end,   // if(direction == ltr) align_right, if(direction == rtl)
                                // align_left
    };

    typedef html::enumv<halign_e> halign_ev;

    template<> inline enum_def* enum_pdef<halign_e>() {
      static enum_item_def edef[] = {
        { align_auto,     W("auto") },
        { align_left,     W("left") },
        { align_right,    W("right") },
        { align_center,   W("center") },
        { align_justify,  W("justify") },
        { align_start,    W("start") },
        { align_end,      W("end") },
      };
      static enum_def t = { W("text-align"), items_of(edef) };
      return &t;
    }

    enum text_anchor_e {
      text_anchor_start,  // if(direction == ltr) align_left, if(direction == rtl) align_right
      text_anchor_middle, // if(direction == ltr) align_left, if(direction == rtl) align_right
      text_anchor_end,    // if(direction == ltr) align_right, if(direction == rtl) align_left
    };

    typedef html::enumv<text_anchor_e> text_anchor_ev;

    template<> inline enum_def* enum_pdef<text_anchor_e>() {
      static enum_item_def edef[] = {
        { text_anchor_start,     W("start") },
        { text_anchor_middle,    W("middle") },
        { text_anchor_end,       W("end") },
      };
      static enum_def t = { W("text-anchor"), items_of(edef) };
      return &t;
    }

    typedef BLEND_MODE blend_mode_e;

    typedef html::enumv<blend_mode_e> blend_mode_ev;

    template<> inline enum_def* enum_pdef<blend_mode_e>() {
      static enum_item_def edef[] = {
        { BLEND_NORMAL,     W("normal") },
        { BLEND_MULTIPLY,   W("multiply") },
        { BLEND_SCREEN,     W("screen") },
        { BLEND_OVERLAY,    W("overlay") },
        { BLEND_DARKEN,     W("darken") },
        { BLEND_LIGHTEN,    W("lighten") },
        { BLEND_COLOR_DODGE,W("color-dodge") },
        { BLEND_COLOR_BURN, W("color-burn") },
        { BLEND_HARD_LIGHT, W("hard-light") },
        { BLEND_SOFT_LIGHT, W("soft-light") },
        { BLEND_DIFFERNCE,  W("differnce") },
        { BLEND_EXCLUSION,  W("exclusion") },
        { BLEND_HUE,        W("hue") },
        { BLEND_SATURATION, W("saturation") },
        { BLEND_COLOR,      W("color") },
        { BLEND_LUMINOSITY, W("luminosity") },
      };
      static enum_def t = { W("blend-mode"), items_of(edef) };
      return &t;
    }

    enum border_style_e {
      border_none,
      border_solid,
      border_dotted,
      border_dashed,
      border_double,
      border_groove,
      border_ridge,
      border_inset,
      border_outset,
      border_glow,
      border_nwse_hatch,
      border_nesw_hatch,
    };

    typedef html::enumv<border_style_e> border_style_ev;

    template<> inline enum_def* enum_pdef<border_style_e>() {
      static enum_item_def edef[] = {
        { border_none,    W("none") },
        { border_solid,   W("solid") },
        { border_double,  W("double") },
        { border_dotted,  W("dotted") },
        { border_dashed,  W("dashed") },
        { border_groove,  W("groove") },
        { border_ridge,   W("ridge") },
        { border_inset,   W("inset") },
        { border_outset,  W("outset") },
        { border_glow,    W("glow") },
        { border_nwse_hatch,    W("nwse-hatch") },
        { border_nesw_hatch,    W("nesw-hatch") },
      };
      static enum_def t = { W("border-style"), items_of(edef) };
      return &t;
    }

    //enum text_decoration_e;

    template<> inline enum_def* enum_pdef<text_decoration_e>() {
      static enum_item_def edef[] = {
        { text_decoration_none,         W("none") },
        { text_decoration_underline,    W("underline") },
        { text_decoration_overline,     W("overline") },
        { text_decoration_linethrough,  W("line-through") },
        //{ text_decoration_wavy,         W("wavy") },
      };
      static enum_def t = { W("text-decoration"), items_of(edef) };
      return &t;
    }

    typedef html::flagsv<text_decoration_e> text_decoration_ev;

    // enum clip_e

    template<> inline enum_def* enum_pdef<clip_e>() {
      static enum_item_def edef[] = {
        { clip_border_box,    W("border-box") },
        { clip_padding_box,   W("padding-box") },
        { clip_margin_box,    W("margin-box") },
        { clip_content_box,   W("content-box") },
        { clip_hit_margin_box,W("hit-margin-box") },
      };
      static enum_def t = { W("clip"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<clip_e> clip_ev;


    // enum overflow_e

    template<> inline enum_def* enum_pdef<overflow_e>() {
      static enum_item_def edef[] = {
        { overflow_visible,   W("visible") },
        { overflow_none,      W("none") },
        { overflow_hidden,    W("hidden") },
        { overflow_scroll,    W("scroll") },
        { overflow_auto,      W("auto") },
        { overflow_hidden_scroll, W("hidden-scroll") },
        { overflow_scroll_indicator, W("scroll-indicator") },
      };
      static enum_def t = { W("overflow"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<overflow_e> overflow_ev;

    enum appearance_e {
      appearance_auto,
      appearance_none,
      appearance_default,
    };

    template<> inline enum_def* enum_pdef<appearance_e>() {
      static enum_item_def edef[] = {
        { appearance_auto,      W("auto") },
        { appearance_none,      W("none") },
        { appearance_default,   W("default") },
      };
      static enum_def t = { W("appearance"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<appearance_e> appearance_ev;


    //enum clear_e

    template<> inline enum_def* enum_pdef<clear_e>() {
      static enum_item_def edef[] = {
        { clear_none,   W("none") },
        { clear_left,   W("left") },
        { clear_right,  W("right") },
        { clear_both,   W("both") },
        { clear_left,   W("before") },
        { clear_right,  W("after") },
      };
      static enum_def t = { W("clear"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<clear_e> clear_ev;

    enum text_transform_e {
      text_transform_none = 0,
      text_transform_capitalize = 1,
      text_transform_uppercase = 2,
      text_transform_lowercase = 3
    };

    template<> inline enum_def* enum_pdef<text_transform_e>() {
      static enum_item_def edef[] = {
        { text_transform_none,       W("none") },
        { text_transform_capitalize, W("capitalize") },
        { text_transform_uppercase,  W("uppercase") },
        { text_transform_lowercase,  W("lowercase") },
      };
      static enum_def t = { W("text-tranform"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<text_transform_e> text_transform_ev;

    enum list_style_position_e {
      list_style_position_outside,
      list_style_position_inside
    };

    template<> inline enum_def* enum_pdef<list_style_position_e>() {
      static enum_item_def edef[] = {
        { list_style_position_outside,  W("outside") },
        { list_style_position_inside,   W("inside") },
      };
      static enum_def t = { W("list-style-position"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<list_style_position_e> list_style_position_ev;

    enum text_decoration_style_e {
      text_decoration_style_solid,
      text_decoration_style_double,
      text_decoration_style_dotted,
      text_decoration_style_dashed,
      text_decoration_style_wavy,
    };

    typedef html::flagsv<text_decoration_style_e> text_decoration_style_ev;

    template<> inline enum_def* enum_pdef<text_decoration_style_e>() {
      static enum_item_def edef[] = {
        { text_decoration_style_solid,   W("solid") },
        { text_decoration_style_double,  W("double") },
        { text_decoration_style_dotted,  W("dotted") },
        { text_decoration_style_dashed,  W("dashed") },
        { text_decoration_style_wavy,    W("wavy") },

      };
      static enum_def t = { W("text-decoration-style"), items_of(edef) };
      return &t;
    }

    enum font_variant_ligatures_e {
      font_variant_ligatures_normal,
      font_variant_ligatures_none = 0xFF,
      font_variant_ligatures_common = 0,
      font_variant_ligatures_no_common = 0x01,
      font_variant_ligatures_discretionary = 0,
      font_variant_ligatures_no_discretionary = 0x02,
      font_variant_ligatures_historical = 0,
      font_variant_ligatures_no_historical = 0x04,
      font_variant_ligatures_contextual = 0,
      font_variant_ligatures_no_contextual = 0x08,
    };

    typedef html::flagsv<font_variant_ligatures_e> font_variant_ligatures_ev;

    template<> inline enum_def* enum_pdef<font_variant_ligatures_e>() {
      static enum_item_def edef[] = {
        { font_variant_ligatures_normal, W("normal") },
        { font_variant_ligatures_none,   W("none") },
        { font_variant_ligatures_common, W("common-ligatures") },
        { font_variant_ligatures_no_common, W("no-common-ligatures") },
        { font_variant_ligatures_discretionary, W("discretionary-ligatures") },
        { font_variant_ligatures_no_discretionary, W("no-discretionary-ligatures") },
        { font_variant_ligatures_historical, W("historical-ligatures") },
        { font_variant_ligatures_no_historical, W("no-historical-ligatures") },
        { font_variant_ligatures_contextual, W("contextual") },
        { font_variant_ligatures_no_contextual, W("no-contextual") },
      };
      static enum_def t = { W("font-variant-ligatures"), items_of(edef) };
      return &t;
    }

    enum font_variant_caps_e {
      font_variant_caps_normal,
      font_variant_caps_small,
      font_variant_caps_all_small,
      font_variant_caps_petite,
      font_variant_caps_all_petite,
      font_variant_caps_unicase,
      font_variant_caps_titling,
    };

    typedef html::enumv<font_variant_caps_e> font_variant_caps_ev;

    template<> inline enum_def* enum_pdef<font_variant_caps_e>() {
      static enum_item_def edef[] = {
        { font_variant_caps_normal, W("normal") },
        { font_variant_caps_small,  W("small-caps") },
        { font_variant_caps_all_small, W("all-small-caps") },
        { font_variant_caps_petite, W("petite-caps") },
        { font_variant_caps_all_petite, W("all-petite-caps") },
        { font_variant_caps_unicase, W("unicase") },
        { font_variant_caps_titling, W("titling-caps") },
      };
      static enum_def t = { W("font-variant-caps"), items_of(edef) };
      return &t;
    }

    enum fill_rule_e {
      fill_rule_nonzero = 0,
      fill_rule_evenodd = 1,
    };

    template<> inline enum_def* enum_pdef<fill_rule_e>() {
      static enum_item_def edef[] = {
        { fill_rule_nonzero, W("nonzero") },
        { fill_rule_evenodd, W("evenodd") },
      };
      static enum_def t = { W("fill-rule"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<fill_rule_e> fill_rule_ev;

    enum animation_fill_mode_e {
      animation_fill_mode_none = 0,
      animation_fill_mode_forwards = 1,
      animation_fill_mode_backwards = 2,
      animation_fill_mode_both = 3,
    };

    template<> inline enum_def* enum_pdef<animation_fill_mode_e>() {
      static enum_item_def edef[] = {
        { animation_fill_mode_none,       W("none") },
        { animation_fill_mode_forwards,   W("forwards") },
        { animation_fill_mode_backwards,  W("backwards") },
        { animation_fill_mode_both,       W("both") },
      };
      static enum_def t = { W("animation-fill-mode"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<animation_fill_mode_e> animation_fill_mode_ev;

    enum animation_direction_e {
      animation_direction_normal,
      animation_direction_reverse,
      animation_direction_alternate,
      animation_direction_alternate_reverse,
    };

    template<> inline enum_def* enum_pdef<animation_direction_e>() {
      static enum_item_def edef[] = {
        { animation_direction_normal, W("normal") },
        { animation_direction_reverse, W("reverse") },
        { animation_direction_alternate, W("alternate") },
        { animation_direction_alternate_reverse, W("alternate-reverse") },
      };
      static enum_def t = { W("animation-direction"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<animation_direction_e> animation_direction_ev;

    enum animation_play_state_e {
      animation_play_state_running,
      animation_play_state_paused,
    };

    template<> inline enum_def* enum_pdef<animation_play_state_e>() {
      static enum_item_def edef[] = {
        { animation_play_state_running, W("running") },
        { animation_play_state_paused, W("paused") },
      };
      static enum_def t = { W("animation-play-state"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<animation_play_state_e> animation_play_state_ev;

    enum stroke_linecap_e {
      stroke_linecap_butt = gool::CAP_BUTT,
      stroke_linecap_round = gool::CAP_ROUND,
      stroke_linecap_square = gool::CAP_SQUARE,
    };

    template<> inline enum_def* enum_pdef<stroke_linecap_e>() {
      static enum_item_def edef[] = {
        { stroke_linecap_butt, W("butt") },
        { stroke_linecap_round, W("round") },
        { stroke_linecap_square, W("square") },
      };
      static enum_def t = { W("stroke-linecap"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<stroke_linecap_e> stroke_linecap_ev;


    enum stroke_linejoin_e {
      stroke_linejoin_miter = gool::JOIN_MITER,
      stroke_linejoin_round = gool::JOIN_ROUND,
      stroke_linejoin_bevel = gool::JOIN_BEVEL,
    };

    template<> inline enum_def* enum_pdef<stroke_linejoin_e>() {
      static enum_item_def edef[] = {
        { stroke_linejoin_miter, W("miter") },
        { stroke_linejoin_round, W("round") },
        { stroke_linejoin_bevel, W("bevel") },
      };
      static enum_def t = { W("animation-direction"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<stroke_linejoin_e> stroke_linejoin_ev;


    using image_rendering_mode_e = gool::IMAGE_RENDERING;

    template<> inline enum_def* enum_pdef<image_rendering_mode_e>() {
      static enum_item_def edef[] = {
        { image_rendering_default, W("default") },
        { image_rendering_default, W("crisp-edges") },
        { image_rendering_speed,   W("optimize-speed") },
        { image_rendering_speed,   W("pixelated") },
        { image_rendering_quality, W("optimize-quality") },
        { image_rendering_quality, W("auto") },
      };
      static enum_def t = { W("image-rendering-mode"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<image_rendering_mode_e> image_rendering_mode_ev;

    enum image_attachment_e {
      attachment_scroll = 0,
      attachment_fixed = 1,
      attachment_local = 2,
    };

    template<> inline enum_def* enum_pdef<image_attachment_e>() {
      static enum_item_def edef[] = {
        { attachment_scroll, W("scroll") },
        { attachment_fixed,  W("fixed") },
        { attachment_local,  W("local") },
      };
      static enum_def t = { W("image-attachment"), items_of(edef) };
      return &t;
    }

    typedef html::enumv<image_attachment_e> image_attachment_ev;

    enum text_overflow_e {
      text_overflow_clip,
      text_overflow_ellipsis,
      text_overflow_path_ellipsis,
    };

    typedef html::enumv<text_overflow_e> text_overflow_ev;

    template<> inline enum_def* enum_pdef<text_overflow_e>() {
      static enum_item_def edef[] = {
        { text_overflow_clip,         W("clip") },
        { text_overflow_ellipsis,     W("ellipsis") },
        { text_overflow_path_ellipsis,W("path-ellipsis") },
      };
      static enum_def t = { W("text-overflow"), items_of(edef) };
      return &t;
    }

    enum position_e {
      position_static,   // normal flow
      position_relative, // normal flow, but offset by left and top
      position_absolute, //
      position_fixed,    //
      position_popup,    // h-smile specific - popup - out doc gool::surface - new
                         // window
    };
    typedef html::enumv<position_e> position_ev;

    template<> inline enum_def* enum_pdef<position_e>() {
      static enum_item_def edef[] = {
        { position_static,    W("static") },
        { position_relative,  W("relative") },
        { position_absolute,  W("absolute") },
        { position_fixed,     W("fixed") },
        { position_popup,     W("popup") },
      };
      static enum_def t = { W("position"), items_of(edef) };
      return &t;
    }

    enum border_collapse_e {
      border_separate,
      border_collapse,
    };
    typedef html::enumv<border_collapse_e> border_collapse_ev;

    template<> inline enum_def* enum_pdef<border_collapse_e>() {
      static enum_item_def edef[] = {
        { border_separate,    W("separate") },
        { border_collapse,    W("collapse") },
      };
      static enum_def t = { W("border-collapse"), items_of(edef) };
      return &t;
    }

    enum box_sizing_e {
      box_sizing_content = 0,
      box_sizing_padding = 1,
      box_sizing_border = 2
    };

    typedef html::enumv<box_sizing_e> box_sizing_ev;

    template<> inline enum_def* enum_pdef<box_sizing_e>() {
      static enum_item_def edef[] = {
        { box_sizing_content,    W("content-box") },
        { box_sizing_padding,    W("padding-box") },
        { box_sizing_border,     W("border-box") },
      };
      static enum_def t = { W("box-sizing"), items_of(edef) };
      return &t;
    }

    enum clip_box_e {
      clip_box_default = 0,
      clip_box_content = 1,
      clip_box_padding = 2,
      clip_box_border = 3,
      clip_box_margin = 4,
      clip_box_hit_margin = 5,
    };

    typedef html::enumv<clip_box_e> clip_box_ev;

    template<> inline enum_def* enum_pdef<clip_box_e>() {
      static enum_item_def edef[] = {
        { clip_box_default,    W("default") },
        { clip_box_content,    W("content-box") },
        { clip_box_padding,    W("padding-box") },
        { clip_box_border,     W("border-box") },
        { clip_box_margin,     W("margin-box") },
        { clip_box_hit_margin, W("hit-margin-box") },
      };
      static enum_def t = { W("clip-box"), items_of(edef) };
      return &t;
    }


    enum visibility_e {
      visibility_visible,
      //visibility_hidden_when_partial,
      visibility_hidden,
      visibility_collapse,
      visibility_none,
    };

    typedef html::enumv<visibility_e> visibility_ev;

    template<> inline enum_def* enum_pdef<visibility_e>() {
      static enum_item_def edef[] = {
        { visibility_visible,    W("visible") },
        { visibility_hidden,     W("hidden") },
        { visibility_collapse,   W("collapse") },
        { visibility_none,       W("none") },
      };
      static enum_def t = { W("visibility"), items_of(edef) };
      return &t;
    }

    enum flow_e {
      flow_default = 0,
      flow_vertical = 1,
      flow_horizontal = 2,
      flow_h_flow = 3,
      flow_v_flow = 4,
      flow_grid = 5,
      flow_table = 7,
      flow_table_fixed = 8,
      flow_stack = 9,
      flow_text = 10,
      flow_table_row = 11,
      flow_table_body = 12,
      flow_columns = 13,
      flow_null = 14,
      flow_image = 15,
      flow_svg = 16,
      flow_svg_element = 17,
    };

    typedef html::enumv<flow_e> flow_ev;

    template<> inline enum_def* enum_pdef<flow_e>() {
      static enum_item_def edef[] = {
        { flow_default,       W("default") },
        { flow_vertical,      W("vertical") },
        { flow_horizontal,    W("horizontal") },
        { flow_h_flow,        W("horizontal-wrap") },
        { flow_h_flow,        W("horizontal-flow") },
        { flow_h_flow,        W("h-flow") },
        { flow_v_flow,        W("vertical-wrap") },
        { flow_v_flow,        W("vertical-flow") },
        { flow_v_flow,        W("v-flow") },
        { flow_grid,          W("grid") }, // note, parsed separately
        { flow_columns,       W("columns") }, // note, parsed separately
        { flow_table,         W("table") },
        { flow_table_fixed,   W("table-fixed") },
        { flow_table_row,     W("table-row") },
        { flow_stack,         W("stack") },
        { flow_null,          W("null") },
        { flow_text,          W("text") },
        { flow_svg,           W("svg") },
        { flow_svg_element,   W("svg-element") },

      };
      static enum_def t = { W("flow"), items_of(edef) };
      return &t;
    }

//#pragma pack(push, 4) // IT MUST BE 4 bytes aligned!!!!
    struct flow_v {
      handle<function_value> func;
      flow_ev                ev;

      flow_v() {}
      // flow_v(const enum_str_v& iv): ev(iv.ev),sv(iv.sv)  {}
      flow_v(const flow_v &iv) : ev(iv.ev), func(iv.func) {}
      flow_v(const value &iv) { set(iv); }
      flow_v(const flow_ev& e) { ev = e; }

      operator int() const { return int(ev); }
      // flow_v& operator = (const string& vs) { sv = vs; ev.clear();
      // func.clear(); return *this; }
      flow_v &operator=(const int &vi) {
        ev = vi;
        func.clear();
        return *this;
      }

      static flow_v null_val() { return flow_v(); }
      static flow_v inherit_val() {
        flow_v n;
        n.ev = flow_ev::inherit_val();
        return n;
      }

      bool is_undefined() const { return ev.is_undefined(); }
      bool is_defined() const { return ev.is_defined(); }
      bool is_inherit() const { return ev == enum_v::inherit_val(); }
      bool is_default() const { return ev == flow_default; }

      // bool is_string() const { return sv.is_defined(); }

      void clear() {
        ev.clear();
        func = nullptr;
      }

      bool set(const value& v);
      bool set(slice<value> vs);

      void inherit(const flow_v &v) {
        if (v.is_defined()) {
          ev = v.ev;
          func = v.func;
        }
      }

      uint hash() const {
        return ev.hash() + func.hash();
      }

      bool operator==(const flow_v &r) const {
        return ev == r.ev && func.is_identical(r.func);
      }
      bool operator!=(const flow_v &r) const {
        return ev != r.ev || !func.is_identical(r.func);
      }

      value to_value() const {
        if (is_undefined()) return value();
        if (func)
          return value::make_function(func);
        else
          return ev.to_value();
      }

      ustring to_string() const {
        if ((ev.val() == flow_grid) && func)
          return func->to_string();
        return ev.to_string();
      }
    };
//#pragma pack(pop)

    enum image_repeat_e {
      background_no_repeat = 0, // in Sciter background-repeat is no-repeat by default
      background_repeat = 1,
      background_repeat_x = 2,
      background_repeat_y = 3,
      background_stretch = 4,
      background_expand = 5,
      background_stretch_top = 0x25,
      background_stretch_bottom = 0x85,
      background_stretch_left = 0x15,
      background_stretch_right = 0x45,
      background_stretch_center = 0x105,
      background_keep_ratio = 0x8000,
    };

    struct image_repeat_ev : public int_v {

      image_repeat_ev() : int_v() {}

      image_repeat_ev(value val) : int_v() { slice<value> t(val); set(t); }
      image_repeat_ev(image_repeat_e v) : int_v(v) { ; }

      bool set(slice<value>& val);

      operator value() const { return to_value(); }

      value to_value() const;
      ustring to_string() const;

    };

    enum popup_attachment_e {
      popup_attachment_top_left = 1,
      popup_attachment_top_center = 2,
      popup_attachment_top_right = 3,

      popup_attachment_right_top = 4,
      popup_attachment_right_middle = 5,
      popup_attachment_right_bottom = 6,

      popup_attachment_bottom_right = 7,
      popup_attachment_bottom_center = 8,
      popup_attachment_bottom_left = 9,

      popup_attachment_left_bottom = 10,
      popup_attachment_left_middle = 11,
      popup_attachment_left_top    = 12,

    };

    typedef html::enumv<popup_attachment_e> popup_attachment_ev;

    template<> inline enum_def* enum_pdef<popup_attachment_e>() {
      static enum_item_def edef[] = {
        { popup_attachment_top_left, W("top-left") },
        { popup_attachment_top_center, W("top-center") },
        { popup_attachment_top_right, W("top-right") },

        { popup_attachment_right_top, W("right-top") },
        { popup_attachment_right_middle, W("right-middle") },
        { popup_attachment_right_bottom, W("right-bottom") },

        { popup_attachment_bottom_left, W("bottom-left") },
        { popup_attachment_bottom_center, W("bottom-center") },
        { popup_attachment_bottom_right, W("bottom-right") },

        { popup_attachment_left_top, W("left-top") },
        { popup_attachment_left_middle, W("left-middle") },
        { popup_attachment_left_bottom, W("left-bottom") },

      };
      static enum_def t = { W("popup-attachment"), items_of(edef) };
      return &t;
    }


}

namespace tool {
    template<typename E>
      inline enum_def* enum_pdef() { return html::enum_pdef<E>(); }
}

#endif
