#ifndef __html_style_atts_h__
#define __html_style_atts_h__

namespace html {

  enum STYLE_CHANGE_TYPE {
    NO_CHANGES,
    CHANGES_VISUAL,
    CHANGES_POSITION,
    CHANGES_DIMENSION,
    CHANGES_MODEL,
    RESOLVE_STYLE,
  };

  enum STYLE_ATTS {
#define CSSA(n, c, cm) cssa_##n,
#include "html-style-atts.inl"
#undef CSSA
    CSSA_ATTR_MAX
  };

  namespace cssa {
    using namespace tool;

    typedef uint symbol_t;

    symbol_t symbol(const char *str); // intern it and return id. if not found
                                      // returns undefined;
    inline symbol_t symbol(const string &str) { return symbol(str.c_str()); }
    inline symbol_t symbol(const ustring &str) { return symbol(string(str).c_str()); }
    inline symbol_t symbol(const wchar *str) { return symbol(string(str).c_str()); }
    inline symbol_t symbol(chars str) { 
      if( str.start[str.length] )
        return symbol(string(str).c_str()); 
      else 
        return symbol(str.start);
    }

    symbol_t symbol(const char *str, STYLE_CHANGE_TYPE cm); // intern it and return id. if not found
                                                            // returns undefined;

    uint_v lookup(const char *str);

    string symbol_name(symbol_t id);

    STYLE_CHANGE_TYPE symbol_change_type(symbol_t id);

    void init();

    struct name_or_symbol {
      symbol_t att_sym;
      name_or_symbol(cssa::symbol_t sym) : att_sym(sym) {}
      //name_or_symbol(int sym) : att_sym(uint(sym)) {}
      name_or_symbol(const char *name) : att_sym(cssa::symbol(name)) {}
      name_or_symbol(chars name) : att_sym(cssa::symbol(name)) {}
      name_or_symbol(const tool::string &name) : att_sym(cssa::symbol(name)) {}

      bool operator==(const name_or_symbol &rs) const { return att_sym == rs.att_sym; }
      bool operator!=(const name_or_symbol &rs) const { return att_sym != rs.att_sym; }
    };


    template<typename F>
    bool each_terminal_prop_of(symbol_t sym, F f) 
    {
      switch (sym)
      {
      case cssa_font:
        f(cssa_font_size);
        f(cssa_line_height);
        f(cssa_color);
        break;
      case cssa_text_selection:
        f(cssa_text_selection_color);
        f(cssa_text_selection_background_color);
        break;
      case cssa_size:
        f(cssa_width);
        f(cssa_height);
        break;
      case cssa_background_size:
        f(cssa_background_width);
        f(cssa_background_height);
        break;
      case cssa_background:
        f(cssa_background_position_top);
        f(cssa_background_position_left);
        f(cssa_background_position_right);
        f(cssa_background_position_bottom);
        f(cssa_background_gradient);
        f(cssa_background_image);
        f(cssa_background_color);
        break;
      case cssa_background_position:
        f(cssa_background_position_top);
        f(cssa_background_position_left);
        f(cssa_background_position_right);
        f(cssa_background_position_bottom);
        break;
      case cssa_background_offset:
        f(cssa_background_offset_top);
        f(cssa_background_offset_left);
        f(cssa_background_offset_right);
        f(cssa_background_offset_bottom);
        break;
        // foreground
      case cssa_foreground:
        f(cssa_foreground_position_top);
        f(cssa_foreground_position_left);
        f(cssa_foreground_position_right);
        f(cssa_foreground_position_bottom);
        f(cssa_foreground_gradient);
        f(cssa_foreground_image);
        f(cssa_foreground_color);
        break;
      case cssa_foreground_position:
        f(cssa_foreground_position_top);
        f(cssa_foreground_position_left);
        f(cssa_foreground_position_right);
        f(cssa_foreground_position_bottom);
        break;
      case cssa_foreground_size:
        f(cssa_foreground_width);
        f(cssa_foreground_height);
        break;
      case cssa_border:
        f(cssa_border_bottom_color);
        f(cssa_border_bottom_width);
        f(cssa_border_left_color);
        f(cssa_border_left_width);
        f(cssa_border_right_color);
        f(cssa_border_right_width);
        f(cssa_border_top_color);
        f(cssa_border_top_width);
        break;
      case cssa_border_bottom:
        f(cssa_border_bottom_color);
        f(cssa_border_bottom_width);
        break;
      case cssa_border_color:
        f(cssa_border_bottom_color);
        f(cssa_border_left_color);
        f(cssa_border_right_color);
        f(cssa_border_top_color);
        break;
      case cssa_border_left:
        f(cssa_border_left_color);
        f(cssa_border_left_width);
        break;
      case cssa_border_right:
        f(cssa_border_right_color);
        f(cssa_border_right_width);
        break;
      case cssa_border_top:
        f(cssa_border_top_color);
        f(cssa_border_top_width);
        break;
      case cssa_border_width:
        f(cssa_border_bottom_width);
        f(cssa_border_left_width);
        f(cssa_border_right_width);
        f(cssa_border_top_width);
        break;
      case cssa_border_radius:
        f(cssa_border_top_left_radius_x);
        f(cssa_border_top_left_radius_y);
        f(cssa_border_top_right_radius_x);
        f(cssa_border_top_right_radius_y);
        f(cssa_border_bottom_right_radius_x);
        f(cssa_border_bottom_right_radius_y);
        f(cssa_border_bottom_left_radius_x);
        f(cssa_border_bottom_left_radius_y);
        break;
      case cssa_border_top_left_radius:
        f(cssa_border_top_left_radius_x);
        f(cssa_border_top_left_radius_y);
        break;
      case cssa_border_top_right_radius:
        f(cssa_border_top_right_radius_x);
        f(cssa_border_top_right_radius_y);
        break;
      case cssa_border_bottom_right_radius:
        f(cssa_border_bottom_right_radius_x);
        f(cssa_border_bottom_right_radius_y);
        break;
      case cssa_border_bottom_left_radius:
        f(cssa_border_bottom_left_radius_x);
        f(cssa_border_bottom_left_radius_y);
        break;

      case cssa_margin:
        f(cssa_margin_bottom);
        f(cssa_margin_left);
        f(cssa_margin_right);
        f(cssa_margin_top);
        break;
      case cssa_padding:
        f(cssa_padding_bottom);
        f(cssa_padding_left);
        f(cssa_padding_right);
        f(cssa_padding_top);
        break;
      case cssa_outline:
        f(cssa_outline_width);
        f(cssa_outline_offset);
        f(cssa_outline_color);
        f(cssa_outline_style);
        break;
      case cssa_outline_shift:
        f(cssa_outline_shift_x);
        f(cssa_outline_shift_y);
        break;
      case cssa_transform_origin:
        f(cssa_transform_origin_x);
        f(cssa_transform_origin_y);
        break;
      default:
        f(sym);
        return false;
      }
      return true;
    }



  } // namespace cssa

} // namespace html

#endif