#ifndef __html_layout_h__
#define __html_layout_h__

#include "tool/tool.h"
#include "html-dom.h"
#include "html-primitives.h"
#include "html-scrollbar.h"
#include "html-layout-types.h"
#include "html-layout-text-flow.h"
#include "html-spring.h"
//#if defined(USE_D2D)
//  #include "d2d/d2d-primitives.h"
//#endif

namespace html {


  inline element *element::nearest_known_box() {
    for (element *p = this; p; p = p->parent) {
      if ((p->is_box() && p->is_layout_valid() && !p->ldata->dim.empty())
          //|| p->flags.airborn
          || p->state.popup() || !p->parent)
        return p;
    }
    return 0;
  }

  inline element *element::nearest_table_cell() {
    for (element *p = this; p; p = p->parent) {
      if (p->is_table_cell()) return p;
    }
    return nullptr;
  }

  inline element *element::nearest_bfc(
      view &v) // closest block formatting context (<body>, <td> , float)
  {
    for (element *p = this; p; p = p->parent) {
      p->check_layout(v);
      if (p->is_atomic_box()) continue;
      if (p->is_table_cell()) return p;
      if (p->state.popup()) return p;
      if (p->floats(v)) return p;
      if (p->is_document()) return p;
      if (p->is_body()) return p;
      if (p->get_style(v)->overflow() > overflow_visible) return p;
    }
    return 0;
  }

  bool stops_layout_propagation(element *el);

  // typedef layout_data layout_data_t;
  typedef handle<layout_data> h_layout_data;

  int premeasure(view &v, helement b, hstyle cs, size container_dim);
  // void  measure_borders_x(view& v, element* b, style* cs, size container_dim
  // );  void  measure_borders_y(view& v, element* b, style* cs, size
  // container_dim );

  void replace_v(view &v, element *b, int cell_height,
                 bool include_margins = true, valign_ev align = valign_ev(),
                 int_v baseline = int_v());
  void replace_h(view &v, element *b, int cell_width,
                 bool include_margins = true, halign_ev align = halign_ev());

  void calc_margin_top(view &v, helement b, int parent_height, int &pix,
                       int &spr, int &pref, bool for_self = true);
  void calc_margin_bottom(view &v, helement b, int parent_height, int &pix,
                          int &spr, int &pref, bool for_self = true);
  void calc_margin_left(view &v, helement b, int parent_width, int &pix,
                        int &spr, int &pref);
  void calc_margin_right(view &v, helement b, int parent_width, int &pix,
                         int &spr, int &pref);

  // int  premeasure(view& v, element* b) { return
  // premeasure(v,b,b->get_style(v),b->ldata }
  void  overlapping_y(view &v, helement self, element *prev_blk, element *blk, int &pix, int &spr);
  void  overlapping_x(view &v, helement self, element *prev_blk, element *blk, int &pix, int &spr);
  point reposition(view &v, element *container, element *self); // calculates oof position

  // default block layout [controller]
  struct block : public element {
    DEFINE_TYPE_ID_DERIVED(block,element);

    enum { LAYOUT_TYPE = flow_default };

    struct layout_data : public html::layout_data {
      typedef html::layout_data super;
      layout_data(block *) : can_v_flex(false) {}

      DEFINE_TYPE_ID(layout_data);

      // virtual flow_e type() const { return flow_default; }
      ~layout_data() { /*FOREACH(n,blocks) blocks[n]->owner = 0; - wrong,
                          addrefed links! */
      }
      virtual void drop() {
        FOREACH(n, blocks) { blocks[n]->detach_owner(); }
        blocks.clear();
        super::drop();
      }
      virtual void push(view &v, element *self, element *el) override {
        blocks.push(el);
        if (!el->parent) {
          el->parent = self; //???
        }
        //else if (el->flags.is_synthetic)
        //  ++n_synthetics;
        assert(el->parent);
        el->owner = self;
        el->flags.ui_index = (int)blocks.last_index();
        el->get_style(v);
        el->check_layout(v);
        drop_minmax_dim();
      }

      virtual element *next_ui_element(element *el) override {
        int n = el->flags.ui_index + 1;
        if (n >= 0 && n < blocks.size()) return blocks[n];
        return 0;
      }
      virtual element *prev_ui_element(element *el) override {
        int n = el->flags.ui_index - 1;
        if (n >= 0 && n < blocks.size()) return blocks[n];
        return 0;
      }

      array<helement> blocks;
      int_v           baseline;
      bool            can_v_flex;
    };

    block(tag::symbol_t st) : super(st) {}
    block(NO_INIT ni) : super(ni) {}
    /*virtual void transformed() {
      if(!ldata || ldata->type() != flow_default)
        ldata = new layout_data;
      else
        ldata->drop();
    }*/

    virtual bool is_box() const { return true; }

    virtual bool is_vertical_layout() const { return true; }

    virtual bool each_ui_child(function<bool(element *)> f) override;
    virtual bool each_ui_child(function<bool(element *)> f, BACKWARD_E) override;

    //virtual bool each_any_child(const function<bool(element *)> &f) override;
    virtual bool each_any_child_node(const function<bool(node *)> &f) override;

    virtual int      n_ui_children() const override;
    virtual element *ui_child(int n) const override;

    /*virtual element* first_ui_element() const ; // ui child
    virtual element* last_ui_element() const ;  // ui child
    virtual element* next_ui_child( const element* el) const;
    virtual element* prev_ui_child( const element* el) const;*/

    static block *setup_on(view &v, element *el);

    //virtual element *find_element(view &v, point zpos /*at is this relative*/,
    //                              bool exact = true);
    virtual bookmark find_text_pos(view &v, point zpos);

    virtual element *find_child_element(view &v,
                                        point at /*at is this relative*/,
                                        bool  exact = true) {
      return find_child_element_vertical(v, at, exact);
    }
    virtual element *
                     find_child_element_generic(view &v, point at,
                                                bool exact = true); // generic find
    virtual element *find_child_element_vertical(
        view &v, point at,
        bool exact = true); // optimized find for vertical layouts

    virtual flow_e layout_type() const { return flow_default; }

    virtual int layout_width(view &v, int width);
    virtual int layout_height(view &v, int height) {
      return ldata.ptr_of<layout_data>()->can_v_flex
                 ? layout_height_flex(v, height)
                 : layout_height_std(v, height);
    }
    int          layout_height_std(view &v, int height);
    int          layout_height_flex(view &v, int height);
    virtual void layout_width_start(view &v, int width) {}
    virtual void calc_intrinsic_widths(view &v);
    virtual void content_x_range_at(view &v, range y, element *of,
                                    range &in_out_xx);

    virtual void get_inline_block_metrics(view &v, int &ascent, int &descent,
                                          int &height);

    // virtual point static_pos(view& v, element* child);

    virtual void draw_content(view &v, graphics *pg, point pos, bool clip);
    virtual void draw_content_generic(view &v, graphics *pg, point pos,
                                      bool clip);
    virtual void draw_content_vertical(view &v, graphics *pg, point pos,
                                       bool clip);

    virtual float inline_baseline(view &v) override;

    // virtual bool  advance(view& v, bookmark& bm, ADVANCE_DIR cmd, point vpt =
    // point());

    virtual int      n_rows() override;
    virtual int      n_cols() override;
    virtual void     get_row(int row, array<handle<element>> &els) override;
    virtual void     get_col(int col, array<handle<element>> &els) override;
    virtual bool     get_col_x(int col, gool::range &x) override;
    virtual bool     get_row_y(int row, gool::range &y) override;
    virtual bool     get_row_at(view &v, int y, int &row) override;
    virtual bool     get_col_at(view &v, int x, int &col) override;
    virtual element *at(int row, int col) override;
  };

  struct null_layout : public block {
    DEFINE_TYPE_ID_DERIVED(null_layout,block);

    typedef block::layout_data layout_data;

    enum { LAYOUT_TYPE = flow_null };

    null_layout(tag::symbol_t st) : super(st) {}
    null_layout(NO_INIT ni) : super(ni) {}

    static null_layout *setup_on(view &v, element *el) {
      null_layout *tb = turn_element_to<null_layout>(el);
      return tb;
    }

    virtual flow_e layout_type() const { return flow_null; }

    virtual element *find_child_element(view &v,
                                        point at /*at is this relative*/,
                                        bool  exact = true) {
      return find_child_element_generic(v, at, exact);
    }

    virtual int layout_width(view &v, int width) {

      hstyle              cs = get_style(v);
      handle<layout_data> ld = ldata.ptr_of<layout_data>();

      ld->dim.x = width;

      rect crect = client_rect(v);
      size inner = crect.size();

      ld->dim_min.x = 0;
      ld->dim_max.y = 0;

      ld->inner_dim.x = inner.x;
      ld->inner_dim.y = 0;
      ld->dim_min.y.clear();
      ld->dim_max.y.clear();
      return 0;
    }

    virtual int layout_height(view &v, int height) {
      hstyle       cs  = get_style(v);
      layout_data *pld = ldata.ptr_of<layout_data>();
      pld->dim.y       = height;
      size inner_dim   = client_rect(v).size();
      if (pld->inner_dim.y == inner_dim.y) return pld->dim.x;
      pld->inner_dim.y = inner_dim.y;
      return pld->dim.x;
    }
  };

  struct block_vertical : public block {
    DEFINE_TYPE_ID_DERIVED(block_vertical, block);

    typedef block::layout_data layout_data;

    enum { LAYOUT_TYPE = flow_vertical };

    /*struct layout_data: public block::layout_data
    {
      layout_data( block_vertical* b):block::layout_data(b) {}
      virtual flow_e type() const { return flow_vertical; }
    };*/

    block_vertical(tag::symbol_t st) : super(st) {}
    block_vertical(NO_INIT ni) : super(ni) {}
    // virtual void transformed() { ldata = new layout_data; }

    static block_vertical *setup_on(view &v, element *el);

    virtual flow_e layout_type() const { return flow_vertical; }

    virtual int layout_height(view &v, int height) {
      return layout_height_flex(v, height);
    }
  };

  struct block_vertical_wrap : public block_vertical {
    DEFINE_TYPE_ID_DERIVED(block_vertical_wrap,block_vertical);

    // typedef block_vertical::layout_data layout_data;

    enum { LAYOUT_TYPE = flow_v_flow };

    struct layout_data : public block_vertical::layout_data {
      //int_v        total_height;
      array<irange> cols;
      layout_data(block_vertical_wrap *b) : block_vertical::layout_data(b) {}
      virtual flow_e type() const { return flow_v_flow; }
    };

    block_vertical_wrap(tag::symbol_t st) : super(st) {}
    block_vertical_wrap(NO_INIT ni) : super(ni) {}
    // virtual void transformed() { ldata = new layout_data; }

    static block_vertical_wrap *setup_on(view &v, element *el);

    virtual flow_e layout_type() const { return flow_v_flow; }

    void             layout_column(view &v, int colstart, int colend, point pos, int colwidth);
    virtual element *find_child_element(view &v,
                                        point at /*at is this relative*/,
                                        bool  exact = true) override {
      return find_child_element_generic(v, at, exact);
    } 
    virtual void draw_content(view &v, graphics *pg, point pos, bool clip) override {
      draw_content_generic(v, pg, pos, clip);
    }
        

    void do_layout(view &v);

    virtual void calc_intrinsic_widths(view &v) {
      handle<layout_data> ld = ldata.ptr_of<layout_data>();
      super::calc_intrinsic_widths(v);
      //ld->total_height       = super::layout_width(v, 10);
      do_layout(v);
    }

    int declared_height(view &v, int container_height) override {
      hstyle cs = get_style(v);
      if (airborn && airborn->dim.y.is_defined())
        return airborn->dim.y;
      else if (cs->height.is_defined()) {
        check_layout(v);
        int t = 0;
        if (cs->height.is_min_intrinsic())
          t = min_content_height(v);
        else if (cs->height.is_max_intrinsic())
          t = max_content_height(v);
        else
          t = pixels(v, this, cs->height).height();
        return t;
      }
      return container_height ? container_height : 150;
    }

    int layout_width(view &v, int width) {
      hstyle              cs = get_style(v);
      handle<layout_data> ld = ldata.ptr_of<layout_data>();
      ld->dim.x              = width;
      do_layout(v);
      ld->offset.x = 0;
      return ld->dim_min.y;
    }
    virtual int layout_height(view &v, int height) {
      hstyle              cs = get_style(v);
      handle<layout_data> ld = ldata.ptr_of<layout_data>();
      ld->dim.y              = height;
      do_layout(v);
      return ld->dim_min.x;
    }

    //virtual int min_content_height(view &v) override;
    //virtual int max_content_height(view &v) override;

    virtual int      n_rows() override;
    virtual int      n_cols() override;
    virtual void     get_row(int row, array<handle<element>> &els) override;
    virtual void     get_col(int col, array<handle<element>> &els) override;
    virtual bool     get_col_x(int col, gool::range &x) override;
    virtual bool     get_row_y(int row, gool::range &y) override;
    virtual bool     get_row_at(view &v, int y, int &row) override;
    virtual bool     get_col_at(view &v, int x, int &col) override;
    virtual element *at(int row, int col) override;
  };

  struct block_columns : public block_vertical {
    DEFINE_TYPE_ID_DERIVED(block_columns,block_vertical);

    typedef block_vertical::layout_data layout_data;

    enum { LAYOUT_TYPE = flow_columns };

    /*struct layout_data: public block::layout_data
    {
      array<range> cols;
      layout_data( block_vertical* b):block::layout_data(b) {}
      virtual flow_e type() const { return flow_v_flow; }
    };*/

    block_columns(tag::symbol_t st) : super(st) {}
    block_columns(NO_INIT ni) : super(ni) {}
    // virtual void transformed() { ldata = new layout_data; }

    static block_columns *setup_on(view &v, element *el);

    virtual flow_e layout_type() const { return flow_v_flow; }

    void layout_column(view &v, int colstart, int colend, int xpos,
                       int colwidth);

    void do_layout(view &v);

    void calc_intrinsic_widths(view &v) { super::calc_intrinsic_widths(v); }

    int layout_width(view &v, int width) {
      hstyle              cs = get_style(v);
      handle<layout_data> ld = ldata.ptr_of<layout_data>();
      ld->dim.x              = width;
      do_layout(v);
      return ld->dim_min.y;
    }
    virtual int layout_height(view &v, int height) {
      hstyle              cs = get_style(v);
      handle<layout_data> ld = ldata.ptr_of<layout_data>();
      ld->dim.y              = height;
      do_layout(v);
      return ld->dim_min.x;
    }
  };

  struct block_horizontal : public block {
    DEFINE_TYPE_ID_DERIVED(block_horizontal,block);

    typedef block::layout_data layout_data;

    enum { LAYOUT_TYPE = flow_horizontal };

    /*struct layout_data: public block::layout_data
    {
      layout_data( block_horizontal* b):block::layout_data(b) {}
      virtual flow_e type() const { return flow_horizontal; }
      //virtual flow_e type() const { return flow_horizontal; }
    };*/

    // block_horizontal(tag::symbol_t st): super(st) {}
    block_horizontal(NO_INIT ni) : super(ni) {}
    // virtual void transformed() { ldata = new layout_data; }

    virtual bool is_horizontal_layout() const override { return true; }

    static block_horizontal *setup_on(view &v, element *el);

    virtual flow_e layout_type() const { return flow_horizontal; }

    virtual void calc_intrinsic_widths(view &v);
    virtual int  layout_width(view &v, int width);
    virtual int  layout_height(view &v, int height);

    virtual element *find_child_element(view &v,
                                        point at /*at is this relative*/,
                                        bool  exact = true) {
      return find_child_element_generic(v, at, exact);
    }
    virtual void draw_content(view &v, graphics *pg, point pos, bool clip) {
      draw_content_generic(v, pg, pos, clip);
    }

    virtual float inline_baseline(view &v) override;

    virtual int      n_rows() override;
    virtual int      n_cols() override;
    virtual void     get_row(int row, array<handle<element>> &els) override;
    virtual void     get_col(int col, array<handle<element>> &els) override;
    virtual bool     get_col_x(int col, gool::range &x) override;
    virtual bool     get_row_y(int row, gool::range &y) override;
    virtual bool     get_row_at(view &v, int y, int &row) override;
    virtual bool     get_col_at(view &v, int x, int &col) override;
    virtual element *at(int row, int col) override;
  };

  struct block_horizontal_wrap : public block {
    DEFINE_TYPE_ID_DERIVED(block_horizontal_wrap,block);

    enum { LAYOUT_TYPE = flow_h_flow };

    struct row_def {
      uint  first, last; // indexes of first and last element
      int   y;
      int   height;
      int   min_h;
      int_v max_h;
      int_v baseline;
      int_v max_hflex1000;
      row_def() : y(0), height(0), first(0u), last(~0u), min_h(0) {}
    };
    struct layout_data : public block::layout_data {
      DEFINE_TYPE_ID(layout_data);
      layout_data(block_horizontal_wrap *b) : block::layout_data(b) {}
      // virtual flow_e type() const { return flow_h_flow; }

      array<row_def> rows;
      int_v          min_child_border_width;
      int_v          max_child_border_width;
      inline int     child_max_auto(view &v, element *b) {
        return max_child_border_width - b->ldata->borpad_left() - b->ldata->borpad_right();
      }
      inline int child_min_auto(view &v, element *b) {
        return min_child_border_width - b->ldata->borpad_left() - b->ldata->borpad_right();
      }
    };
    // block_horizontal(tag::symbol_t st): super(st) {}
    block_horizontal_wrap(NO_INIT ni) : super(ni) {}
    // virtual void transformed() { ldata = new layout_data; }
    virtual bool is_horizontal_layout() const override { return true; }

    static block_horizontal_wrap *setup_on(view &v, element *el);

    virtual flow_e layout_type() const { return flow_h_flow; }

    virtual void calc_intrinsic_widths(view &v);
    virtual int  layout_width(view &v, int width);
    virtual int  layout_height(view &v, int height);

    virtual element *find_child_element(view &v,
                                        point at /*at is this relative*/,
                                        bool  exact = true) {
      return find_child_element_generic(v, at, exact);
    }
    virtual void draw_content(view &v, graphics *pg, point pos, bool clip) {
      draw_content_generic(v, pg, pos, clip);
    }

    // virtual int    n_rows() override;
    // virtual void   get_row( int row, array< handle<element> >& els) override;
    // virtual bool   get_row_y(int row, irange& y)  override;

    virtual int      n_rows() override;
    virtual int      n_cols() override;
    virtual void     get_row(int row, array<handle<element>> &els) override;
    virtual void     get_col(int col, array<handle<element>> &els) override;
    virtual bool     get_col_x(int col, gool::range &x) override;
    virtual bool     get_row_y(int row, gool::range &y) override;
    virtual bool     get_row_at(view &v, int y, int &row) override;
    virtual bool     get_col_at(view &v, int x, int &col) override;
    virtual element *at(int row, int col) override;
  };

  struct block_grid : public block {
    DEFINE_TYPE_ID_DERIVED(block_grid,block);

    enum { LAYOUT_TYPE = flow_grid };

    struct cr_def // column/row
    {
      flex_value body;
      flex_value b_margin; // before
      flex_value a_margin; // after
      int_v      ascent;   // row ascent.
      int_v      descent;  // row descent.

      int  value;          // computed shape width or height;
      int  b_margin_value; // computed margins, before margin
      int  a_margin_value; // after margin
      int  pos;            // position
      bool is_defined;     // width/height is defined

      cr_def()
          : value(0), b_margin_value(0), a_margin_value(0), pos(0),
            is_defined(false) {}
    };

    struct cell_def {
      element *b;
      irange   cols;
      irange   rows;
      value    id;
      point    shift; // computed shift of the b inside the cell
      cell_def() : b(0) {}
    };

    struct row_align {
      int ascent;
      int descent;
      row_align() : ascent(0), descent(0) {}
    };

    struct layout_data : public block::layout_data {
      DEFINE_TYPE_ID(layout_data);
      // virtual flow_e type() const { return flow_grid; }

      typedef block::layout_data super;
      spring_board               cols;
      spring_board               rows;
      array<row_align>           rows_aligns;
      array<cell_def>            cells;

      layout_data(block_grid *b) : block::layout_data(b) {}

      virtual void drop() {
        FOREACH(n, cells) {
          element *pb = cells[n].b;
          if (pb) pb->owner = nullptr;
        }
        cells.clear();
        cols.clear();
        rows.clear();
        super::drop();
      }
    };

    block_grid(NO_INIT ni) : super(ni) {}
    // virtual void transformed() { ldata = new layout_data; }

    static block_grid *setup_on(view &v, element *el);

    virtual flow_e layout_type() const { return flow_grid; }

    virtual void init(view &v);
    void         init_rows(view &v);
    void         init_grid(view &v);

    virtual void calc_intrinsic_widths(view &v);
    virtual int  layout_width(view &v, int width);
    virtual int  layout_height(view &v, int height);

    virtual element *find_child_element(view &v,
                                        point at /*at is this relative*/,
                                        bool  exact = true) override {
      return find_child_element_generic(v, at, exact);
    }
    //virtual void draw_content(view &v, graphics *pg, point pos, bool clip) {
    //  draw_content_generic(v, pg, pos, clip);
    //}
    virtual void draw_content(view &v, graphics *pg, point pos, bool clip) override;

    virtual float inline_baseline(view &v) override;

    void check_ranges(view &v, element *b, irange &rows, irange &cols);

    virtual int      n_rows() override;
    virtual int      n_cols() override;
    virtual void     get_row(int row, array<handle<element>> &els) override;
    virtual void     get_col(int col, array<handle<element>> &els) override;
    virtual bool     get_col_x(int col, gool::range &x) override;
    virtual bool     get_row_y(int row, gool::range &y) override;
    virtual bool     get_row_at(view &v, int y, int &row) override;
    virtual bool     get_col_at(view &v, int x, int &col) override;
    virtual element *at(int row, int col) override;
  };

#if 0
  struct block_template: public block_grid
  {
    DEFINE_TYPE_ID(block_template);

    typedef block_grid super;
    enum { LAYOUT_TYPE = flow_template };

    /*struct layout_data: public block_grid::layout_data
    {
      virtual flow_e type() const { return flow_template; }
      typedef block_grid::layout_data super;

      layout_data(block_template* b): block_grid::layout_data(b) {}

    };*/

    block_template(NO_INIT ni): super(ni) {}
    //virtual void transformed() { ldata = new layout_data; }
    
    static block_template* setup_on( view& v, element* el );
    
    virtual flow_e layout_type() const { return flow_template; }

    virtual void init(view& v) override;
            void check_ranges(view& v, element* b, range& rows, range& cols);
  };
#endif

#pragma pack(push, 2)
  struct cell_def {
    helement b;
    irange    cols;
    irange    rows;
    cell_def() {}
  };
#pragma pack(pop)

  struct col_def // column/row
  {
    flex_value minmax;
    size_v     declared;
    int        value;  // computed shape width or height;
    int        pos;    // position
    helement   column; // column element, if any

    col_def() : value(0), pos(0) {}
    void clear() {
      minmax.clear();
      declared.clear();
    }
  };
  struct row_def // column/row
  {
    flex_value minmax;
    size_v     declared;
    int        value;  // computed shape width or height;
    int        pos;    // position
    helement   row;    // row element, if any
    int spanned_value; // computed shape width or height including spanned
                       // elements.
    bool layout_valid;
    // bool            is_defined;
    array<cell_def> cells;
    row_def() : value(0), pos(0), spanned_value(0), layout_valid(false) {}
    void transfer_from(row_def &rd) {
      minmax        = rd.minmax;
      declared      = rd.declared;
      value         = rd.value;
      pos           = rd.pos;
      row           = rd.row;
      spanned_value = rd.spanned_value;
      cells.transfer_from(rd.cells);
    }
  };

  struct block_table_body;

  struct block_table : public block_vertical {
    DEFINE_TYPE_ID_DERIVED(block_table,block_vertical);

    enum { LAYOUT_TYPE = flow_table };

    struct layout_data : public super::layout_data {
      DEFINE_TYPE_ID(layout_data);

      // virtual flow_e type() const { return flow_table; }

      typedef block_vertical::layout_data super;
      array<col_def>                      cols;
      range                               hoffsets;
      // handle<block_table_body> body; // synthetic body element, if any
      layout_data(block_table *b) : block_vertical::layout_data(b) {}

      virtual void drop();
      virtual void push(view &v, element *self, element *el);
      int          get_tbody_index_for_insertion();
      void insert_element(view &v, element *self, element *el, int index);
      virtual void drop_minmax_dim();
    };

    block_table(NO_INIT ni) : super(ni) {}
    // virtual void transformed() { ldata = new layout_data; }

    virtual bool is_table() const { return true; }
    virtual bool is_fixed() const { return false; }
    virtual bool is_table_body() const { return false; }

    virtual void fixup_layout(view &v);

    static block_table *setup_on(view &v, element *el);
    virtual flow_e   layout_type() const { return flow_table; }
    virtual void        calc_intrinsic_widths(view &v);
    virtual int         layout_width(view &v, int width);
    virtual int         layout_height(view &v, int height);
    virtual void        layout_width_start(view &v, int width);

    virtual element *drop_layout(view *pv = 0) override;

    virtual max_values measure_borders_x(view &v, size container_dim) override;
    virtual max_values measure_borders_y(view &v, size container_dim) override;

    virtual void drop_content_layout(view* pv = 0) override;
    // virtual element* find_child_element(view& v, point at );
    // virtual void draw_content(view& v, graphics* pg, point pos);

    virtual element *find_child_element(view &v, point at /*at is this relative*/, bool  exact) override {
      return find_child_element_vertical(v, at, true);
    }

    virtual bookmark find_text_pos(view &v, point zpos) override {
      rect zrc = this->content_box(v);
      if (zpos.x < zrc.left() || zpos.y < zrc.top())
        return this->start_pos();
      if (zpos.x > zrc.right() || zpos.y > zrc.bottom())
        return this->end_pos();
      return super::find_text_pos(v, zpos);
    }

  };

  struct block_table_fixed : public block_table {
    DEFINE_TYPE_ID_DERIVED(block_table_fixed,block_table);

    enum { LAYOUT_TYPE = flow_table_fixed };

    block_table_fixed(NO_INIT ni) : super(ni) {}

    static block_table_fixed *setup_on(view &v, element *el);
    virtual flow_e         layout_type() const { return flow_table_fixed; }

    virtual bool is_table() const { return true; }
    virtual bool is_fixed() const { return true; }

    // virtual void calc_intrinsic_widths(view& v);
    // virtual int  layout_width(view& v, int width);
    // virtual int  layout_height(view& v, int height);
    // virtual void layout_width_start(view& v, int width);
  };

  struct block_table_row : public element {
    DEFINE_TYPE_ID_DERIVED(block_table_row,element);

    enum { LAYOUT_TYPE = flow_table_row };

    struct layout_data : public html::layout_data {
      virtual flow_e          type() const { return flow_table_row; }
      typedef block::layout_data super;
      layout_data(block_table_row *b) : html::layout_data(b) {}
    };

    block_table_row(NO_INIT ni) : super(ni) {}
    // virtual void transformed() { ldata = new layout_data; }

    virtual bool is_table_row() const { return true; }

    static block_table_row *setup_on(view &v, element *el);
    virtual flow_e          layout_type() const { return flow_table_row; }
    virtual void            calc_intrinsic_widths(view &v);

    virtual element *similar_neighbour(element *child) const override;

    virtual void commit_measure(view &v) override;

    virtual element *drop_layout(view *pv = 0) override;

    virtual bool is_caret_pos(view& v, const bookmark &bm) const override;

    virtual block_table_body *parent_table_body() const override;

    // virtual void  draw(view& v, graphics* pg, point pos, bool check_animator
    // = true);
    virtual void draw_content(view &v, graphics *pg, point pos, bool clip);

    // virtual bool each_ui_child( const function<bool(element*)>& f ) { return
    // each_child(f); }  virtual bool each_ui_child( const
    // function<bool(element*)>& f, BACKWARD_E back) { return each_child(f,back);
    // }
  };

  struct block_table_body : public block {
    DEFINE_TYPE_ID_DERIVED(block_table_body, block);

    enum { LAYOUT_TYPE = flow_table_body };

    struct layout_data : public html::layout_data {
      DEFINE_TYPE_ID(layout_data);

      typedef html::layout_data super;
            
      layout_data(block_table_body *el);
      ~layout_data() { drop(); }
      array<col_def>  &cols;
      array<row_def>  rows;

      // array<cell_def> cells;
      virtual void drop() {
        FOREACH(n, rows) rows[n].row->detach_owner();
        rows.clear();
        super::drop();
      }
      virtual void push(view &v, element *self, element *el);

      // layout_data(block_table_body* b): super::layout_data(b) {}

      void append_cell(int row_n, element *el);
      void set_cell_at(int row_n, int col_n, element *el, int rs, int cs);
    };

    block_table_body(tag::symbol_t st) : super(st) {}
    block_table_body(NO_INIT ni) : super(ni) {}
    // virtual void transformed() { ldata = new layout_data(this); }

    virtual void fixup_layout(view &v);

    block_table *parent_table() const {
      return (parent && parent->is_table()) ? parent.ptr_of<block_table>() : 0;
    }
    virtual bool is_table() const { return false; }
    virtual bool is_table_body() const { return true; }
    virtual bool is_fixed() const {
      block_table *pt = parent_table();
      return pt && pt->is_fixed();
    }

    virtual bool measure_inplace(view &v) {
      if (block_table *pt = parent_table())
        return pt->measure_inplace(v);
      return false;
    }

    virtual element *drop_layout(view *pv = 0) override;

    static block_table_body *setup_on(view &v, element *el);

    virtual flow_e layout_type() const { return flow_table_body; }

    virtual bool each_ui_child(function<bool(element *)> f) override;
    virtual bool each_ui_child(function<bool(element *)> f, BACKWARD_E) override;

    //virtual bool each_any_child(const function<bool(element *)> &f) override;
    virtual bool each_any_child_node(const function<bool(node *)> &f) override;

    virtual int
    n_ui_children() const; // number of ui children (rendering tree children)
    virtual element *
    ui_child(int idx) const; // n-th ui child (rendering tree child)

    /*virtual element* first_ui_element() const ; // ui child
    virtual element* last_ui_element() const ;  // ui child
    virtual element* next_ui_child( const element* el) const;
    virtual element* prev_ui_child( const element* el) const;*/

    // virtual void init(view& v);
    virtual void calc_intrinsic_widths(view &v);
    virtual int  layout_width(view &v, int width);
    virtual int  layout_width_fixed(view &v, int width);
    virtual int  layout_height(view &v, int height);
    virtual int  layout_height_fixed(view &v, int height);
    virtual void drop_content_layout(view *pv = 0) override;

    virtual void _commit_measure(view &v);

    virtual bookmark
                     find_text_pos(view &v, point zpos /*at is owner relative*/) override;
    virtual element *find_child_element(view &v,
                                        point at /*at is this relative*/,
                                        bool  exact = true);
    virtual void     draw_content(view &v, graphics *pg, point pos,
                                  bool clip) override;
    virtual void     draw_outlines(view &v, graphics *pg, point pos, bool self,
                                   bool children,
                                   bool apply_transforms = false) override;

    element *get_cell_at(uint r, uint c) const;
    element *get_actual_cell_at(uint r, uint c, irange &ar, irange &ac) const;
    bool     get_cell_row_col(const node *incell, uint &r, uint &c) const;
    bool get_cell_rows_cols(const node *incell, uint &r1, uint &r2, uint &c1,
                            uint &c2) const;
    bool get_rows_cols(uint &rows, uint &cols) const;
    static block_table_body *of(const element *cell);

    virtual void on_vscrollbar_show(view &v);  // after scrollbar shown/hidden
    bool         _on_vscrollbar_show(view *v); // after scrollbar shown/hidden

    virtual int      n_rows() override;
    virtual int      n_cols() override;
    virtual void     get_row(int row, array<handle<element>> &els) override;
    virtual void     get_col(int col, array<handle<element>> &els) override;
    virtual bool     get_col_x(int col, gool::range &x) override;
    virtual bool     get_row_y(int row, gool::range &y) override;
    virtual bool     get_row_at(view &v, int y, int &row) override;
    virtual bool     get_col_at(view &v, int x, int &col) override;
    virtual element *at(int row, int col) override;

    void set_cell_at(int row_n, int col_n, element *cell);
  };

  inline block_table_body *block_table_row::parent_table_body() const {
    element *owner = get_owner();
    return (owner && owner->is_of_type<block_table_body>())
               ? owner->cast<block_table_body>()
               : 0;
  }

  inline element *block_table_row::drop_layout(view *pv) {
    return super::drop_layout(pv);
  }

  struct block_stack : public block {
    DEFINE_TYPE_ID_DERIVED(block_stack,block);

    enum { LAYOUT_TYPE = flow_stack };

    /*struct layout_data: public block::layout_data
    {
      typedef block::layout_data super;
      virtual flow_e type() const { return flow_stack; }
      layout_data(block_stack* b): block::layout_data(b) {}
    };*/

    block_stack(tag::symbol_t st) : super(st) {}
    block_stack(NO_INIT ni) : super(ni) {}
    // virtual void transformed() { ldata = new layout_data; }

    static block_stack *setup_on(view &v, element *el);

    virtual flow_e layout_type() const { return flow_stack; }

    virtual void calc_intrinsic_widths(view &v);
    virtual int  layout_width(view &v, int width);
    virtual int  layout_height(view &v, int height);
    void         reorder(view &v); // according to css::z_stack

    virtual element *find_child_element(view &v, point at /*at is this relative*/,  bool  exact = true) override;

    virtual void draw_content(view &v, graphics *pg, point pos,
                              bool clip) override {
      reorder(v);
      draw_content_generic(v, pg, pos, clip);
    }
  };

  struct block_image : public block {
    DEFINE_TYPE_ID_DERIVED(block_image,block);

    enum { LAYOUT_TYPE = flow_image };

    struct layout_data : public block::layout_data {
      typedef block::layout_data super;
      virtual flow_e          type() const { return flow_image; }
      layout_data(block_image *b) : block::layout_data(b) {}
      ~layout_data() {
      }
      handle<image> pimg;
      image_ref     ir;
      ustring       used_src;
    };

    block_image(tag::symbol_t st) : super(st) {}
    block_image(NO_INIT ni) : super(ni) {}

    static block_image *setup_on(view &v, element *el);

    virtual CTL_TYPE  ctl_type(view &v) override { return CTL_IMAGE; }
    virtual flow_e layout_type() const override { return flow_image; }

    void init(view &v);

    virtual void stray(view &v) override;
    virtual bool is_fore_image_provider(view &v) const { return true; }

    virtual void calc_intrinsic_widths(view &v) override;
    virtual int  layout_width(view &v, int width) override;
    virtual int  layout_height(view &v, int height) override;

    virtual int_v auto_width(view &v) override;
    virtual int_v auto_height(view &v) override;

    virtual image *provide_fore_image(view &v) const override;
    virtual void   accept_image(view &v, const image_ref &ir) override;
    void           set_image(view &v, image *ptr);

    virtual bool default_set_value(view &v, const value &val, bool ignore_text_value) override;
    virtual bool default_get_value(view &v, value &val, bool ignore_text_value) override;

    virtual bool on_set_attr(uint att_sym, const ustring &val)
        override; // return true if it is known attr and some action was made
    virtual bool on_remove_attr(uint att_sym, const ustring &val)
        override; // return true if it is known attr and some action was made

    bool update_state(view *pv, uint64 to_set, uint64 to_clear);

    virtual void draw_content(view &v, graphics *pg, point pos,
                              bool clip = true) override {
      super::draw_foreground(v, pg, pos);
    }
    virtual void draw_foreground(view &v, graphics *pg, point pos) override {
      // do nothing
    }

    //virtual void emit_text(array<wchar> &to, bool verbose = false) override;
  };

  struct text_block;

  enum SELECTION_TYPE {
    NO_SELECTION,
    ONLY_CARET,
    TEXT_RANGE,
    SINGLE_BLOCK,
    CELL_RANGE
  };

  struct selection_ctx : public virtual  resource {

    bookmark anchor; //
    bookmark caret;  //
    bookmark target; // drop target

    bookmark ime_start;
    bookmark ime_end;

    point caret_pos; // caret center pos, view related

    enum_v selection_type;
    enum_v caret_state; // 0 - off, 1 - on/hidden, 2-on/shown

    block_table_body *table;      // current table if CELL_RANGE
    irange            table_rows; // rows selected
    irange            table_cols; // columns selected

    array<helement> selected;

    selection_ctx() : table(0) {}
    selection_ctx(const bookmark &bm) : caret(bm), anchor(bm), table(0) {}
    bool is_valid() const { return caret.valid() || target.valid(); }
    bool has_selection() const { return caret.valid() || target.valid(); }
    bool has_ime_selection() const {
      return ime_start.valid() && ime_end.valid();
    }
    bool has_non_collapsed_selection() const { return has_selection() && (caret != anchor); }
    bool has_collapsed_selection() const { return has_selection() && (caret == anchor); }

    bool is_table_selection() const { return has_selection() && table; }
    bool is_table_range_selection() const {
      return has_selection() && table &&
             (table_rows.length() > 1 || table_cols.length() > 1);
    }
    element *is_selection_in_table_cell() {
      if (!has_selection()) return nullptr;
      if (is_table_selection() && table_rows.length() == 1 &&
          table_cols.length() == 1)
        return table->get_cell_at(uint(table_rows.l), uint(table_cols.l));
      element *table_cell = caret.node->get_element()->nearest_table_cell();
      if (!table_cell) return nullptr;
      if (anchor.valid() &&
          anchor.node->get_element()->nearest_table_cell() != table_cell)
        return nullptr;
      return table_cell;
    }

    bool is_block_selection() const { return selection_type == SINGLE_BLOCK; }

    // clear ime composition chars
    virtual bool clear_comp_chars(view &v) { return false; }

    virtual argb selection_back_color(view &v) { return argb(0, 0, 0); }
    virtual argb selection_fore_color(view &v) {
      return argb(0xff, 0xff, 0xff);
    }
    virtual argb selection_text_color(view &v) { return argb(0, 0, 0); }
    virtual argb selection_caret_color(view &v) { return argb(0, 0, 0); }
    virtual argb selection_tail_back_color(view &v) { return argb(0, 0, 0, 0); }
    virtual bool allow_text_selection_on(text_block *tb) { return false; }

    virtual bool draw_caret(view &v, graphics *pg, const caret_metrics &cm) {
      assert(false);
      return false;
    }

    virtual void           set_caret_to(view &v, bookmark bm, bool keep_anchor);
    virtual SELECTION_TYPE get_selection_type(view &v);

    uint get_range_count(view &v);
    pair<bookmark, bookmark> get_range(view &v, uint n);

    // virtual bool is_selected(view& v, const element* el );

    pair<bookmark, bookmark> normalized() const;

    virtual bool select(view &v, bookmark c, bookmark a) = 0;
    virtual bool selection_each(view & v, function<bool(element *, bool &skip)> visitor) { return false; }

    virtual bool is_on_selection(view &v, bookmark bm) {
      if (!caret.valid() || !anchor.valid()) return false;
      if (is_table_range_selection()) {
        return selection_each(v, [&](element *el, bool &skip) -> bool {
          skip = true;
          return bm.node->belongs_to(el, true);
        });
      }
      return bm.is_between(selection_ctx::normalized());
    }

    virtual element *selection_root() const = 0;

    ustring get_selection_text(view& v) const;
    ustring get_ime_selection_text(view& v) const;

    virtual element *selection_contains(view & v, wchars selector /*:root is base parent*/) { return nullptr; }
    virtual bool     selection_contains(view & v, wchars selector /*:root is base parent*/, array<helement>& list) { return false; }

  };

  struct text_block : public element {
    DEFINE_TYPE_ID_DERIVED(text_block,element);

    enum { LAYOUT_TYPE = flow_text };

    struct layout_data : public tflow::text_flow {
      DEFINE_TYPE_ID(layout_data);
      typedef tflow::text_flow super;
      // virtual flow_e type() const { return flow_text; }

      layout_data(text_block *b) : super(b), spell_checked(false) {}

      //      virtual void drop()
      //      {
      //        super::drop();
      //        text_flow::drop();
      //      }
      // virtual void push(view& v, element* self, element* el ) {
      // assert(false); }
      bool spell_checked;
    };

    text_block(tag::symbol_t t) : super(t) { ldata = new text_block::layout_data(this); }
    text_block(NO_INIT ni) : super(ni) {}
    // virtual void transformed() { ldata = new layout_data; }
    virtual bool is_horizontal_layout() const override { return true; }

    virtual void detach_owner() override { super::detach_owner(); }

    static void setup_on(view &v, element *el, slice<hnode> nodes);
    void        init(view &v, slice<hnode> nodes);

    //virtual void     clear_style() override { super::clear_style(); drop_content_layout(); }
    layout_data*     get_layout_data(view &v);
    virtual void     drop_style(view *pv = 0) override;
    //virtual void     drop_styles(view& v, bool force_all) override { super::drop_styles(v, force_all); /*WRONG: drop_content_layout(&v);*/ }
    virtual element *drop_layout(view *pv = 0) override;
    virtual void     drop_content_layout(view *pv = 0) override;

    /*virtual bool     get_a11y_value(view &v, ustring &text) {
      if (super::get_a11y_value(v, text)) return true;
      text = trim(get_text(v)());
      return text.length() > 0;
    }
    */
    virtual bool a11y_get_name(view &v, ustring &name) override
    {
      CTL_TYPE ct = ctl_type(v);
      if (ct == CTL_PASSWORD || ct == CTL_EDIT) {
        return super::a11y_get_name(v, name);
      }
      if (a11y_is_text() || is_focusable(v)) {
        array<wchar> utext;
        get_ui_text(v, utext);
        name = trim(utext());
        return name.length() > 0;
      }
      return super::a11y_get_name(v, name);
    }

    virtual bool a11y_get_children(array<hnode>& children)
    {
      if (!a11y_is_text())
        return super::a11y_get_children(children);
      children.clear();
      return true;
    }

    virtual bool a11y_is_text() override { 
      if (nodes.size() != 1) return false;
      if (!nodes[0]->is_text()) return false;
      return true;
    }

    virtual flow_e layout_type() const { return flow_text; }
    virtual bool      is_box() const { return true; }
    virtual bool      is_text_box() const { return true; }
    virtual bool      is_anonymous_text_block() const override {
      return tag == tag::T_TEXT && flags.is_synthetic;
    }

    virtual element *nearest_text_box() { return this; }

    bool         is_placeholder() const;
    virtual bool is_empty() const {
      return super::is_empty() || is_placeholder();
    }

    virtual void get_ui_text(view &        v,
                             array<wchar> &to); // returns rendered text

    virtual void calc_intrinsic_widths(view &v);
    virtual int  layout_width(view &v, int width);
    virtual int  layout_height(view &v, int height);
    virtual bool get_first_line_metrics(view &v, int &y, int &height,
                                        int &ascent);
    virtual bool get_last_line_metrics(view &v, int &y, int &height,
                                       int &ascent);

    virtual void draw_content(view &v, graphics *pg, point pos, bool clip);
    void draw_content_scrollable(view &v, graphics *pg, point pos, bool clip);
    void draw_selection(view &v, graphics *pg, point pos, selection_ctx *psi);
    void draw_glyphs(view &v, graphics *pg, point pos);

    virtual element *find_child_element(view &v, point zpos /*zpos is this relative*/,
                                  bool exect = true);
    virtual bookmark find_text_pos(view &v,
                                   point zpos /*at is owner relative*/);
    // void get_caret_rect(view& v, rectf& rect, selection_ctx* psi);
    // bool get_caret_pos_info(view& v, bookmark bm, uint& caret_pos, uint&
    // caret_offset, bool& on_rtl);
    virtual bool get_caret_metrics(view &v, const bookmark &bm,
                                   caret_metrics &gm);

    style *get_style_at(view &v, uint pos);

    virtual bool     is_caret_pos_at(view& v, const bookmark &bm) const;
    virtual bookmark this_pos(bool tail) const {
      /* WRONG, breaks monotonous sequence:  if( this->flags.is_synthetic &&
      this->nodes.size() ) { if( tail ) return last_node()->this_pos(true); else
          return first_node()->this_pos(false);
      }*/
      return bookmark(parent, node_index, tail);
    }

    // virtual bool  advance(view& v, bookmark& bm, ADVANCE_DIR cmd, uint n = 0,
    // point vpt = point());

    // virtual bookmark start_pos() const;
    // virtual bookmark end_pos() const;
    virtual bookmark start_caret_pos(view &v) const override;
    virtual bookmark end_caret_pos(view &v) const override;
    // virtual bool     is_caret_pos(const bookmark& bm) const override
    //{
    //  if( this->is_empty() && bm == start_pos() ) return true;
    //  return super::is_caret_pos(bm);
    //}

    virtual node *first_visible_node();
    virtual node *last_visible_node();

    virtual bool advance_caret_pos(view &v, bookmark &bm, ADVANCE_DIR dir,
                                   array<wchar> *out = 0) override;

    virtual element *clone_element_for_editing(bool and_content = true, bool and_attributes = true) override {
      element * pc = super::clone_element_for_editing(and_content, and_attributes);
      if (!and_content && pc->nodes.length() == 0)
        pc->nodes.push(new text(WCHARS("")));
      return pc;
    }

    virtual bool each_ui_child(function<bool(element *)> func) override;
    virtual bool each_ui_child(function<bool(element *)> func, BACKWARD_E b) override;
    virtual bool each_any_child_node(const function<bool(node *)> &f) override;

    virtual int  paginate(view &v, range page, range &intersection,
                          int &elements_on_page, int page_no) override;
    virtual void drop_pagination(view &v) override;

    virtual void check_spelling(view &v, spell_checker *sc) override;

    void set_default_text_color(color_v v) {
      ldata.ptr_of<layout_data>()->_default_text_color = v;
    }

    void fixup_style(view &v, document *pd, style &s) override {
      if (tag == tag::T__MARKER)
        s.flow = flow_text;
      super::fixup_style(v, pd, s);
    }
  };

  /*struct text_block_scrollable: public text_block
  {
    DEFINE_TYPE_ID(text_block_scrollable);

    typedef text_block super;
    enum { LAYOUT_TYPE = flow_text };

    text_block_scrollable(NO_INIT ni): super(ni) {}
    virtual void draw_content(view& v, graphics* pg, point pos);
  };*/

  inline bool block::each_ui_child(function<bool(element *)> func) {
    handle<layout_data> pld = ldata.ptr_of<layout_data>();
    if (!pld) return false;
    if (style_content && style_content->before && func(style_content->before))
      return true;
    if (pld->blocks.each(func)) return true;
    if (style_content && style_content->after && func(style_content->after))
      return true;
    return false;
  }

  inline bool block::each_ui_child(function<bool(element *)> func,BACKWARD_E) {
    handle<layout_data> pld = ldata.ptr_of<layout_data>();
    if (!pld) return false;

    if (style_content && style_content->after && func(style_content->after))
      return true;
    if (pld->blocks.each_backward(func)) return true;
    if (style_content && style_content->before && func(style_content->before))
      return true;
    return false;
  }
    
  inline bool block::each_any_child_node(const function<bool(node *)> &func) {
    handle<element> holder = this;
    return super::each_any_child_node(func) || each_ui_child_node(func);
  }

  /*inline bool
  block_table_body::each_any_child(const function<bool(element *)> &func) {
    handle<element> holder = this;
    if (each_child(func)) return true;

    handle<layout_data> pld = ldata.ptr_of<layout_data>();
    if (!pld) return false;

    for (uint n = 0; n < pld->rows.length(); ++n) {
      element* rd = pld->rows[n].row;
      //if (nodes.get_index(rd) >= 0) // skip element we've scanned already by each_child
      //  continue;
      if (rd->parent == this)
        continue;
      if (func(rd)) return true;
    }
    return false;

    // return each_child( func ) || each_ui_child( func );
  }*/

  inline bool
  block_table_body::each_any_child_node(const function<bool(node *)> &func) {
    handle<element> holder = this;
    return super::each_any_child_node(func) || each_ui_child_node(func);
  }

  inline bool
  block_table_body::each_ui_child(function<bool(element *)> func) {
    handle<layout_data> pld = ldata.ptr_of<layout_data>();
    for (uint n = 0; n < pld->rows.length(); ++n) {
      helement rd = pld->rows[n].row;
      if (func(rd)) return true;
    }
    return false;
  }

  inline bool
  block_table_body::each_ui_child(function<bool(element *)> func, BACKWARD_E) {
    handle<layout_data> pld = ldata.ptr_of<layout_data>();
    for (int n = pld->rows.last_index(); n >= 0; --n) {
      if (n >= pld->rows.size()) {
        n = pld->rows.size();
        continue;
      }
      helement rd = pld->rows[n].row;
      if (func(rd)) return true;
    }
    return false;
  }

  inline bool
  text_block::each_any_child_node(const function<bool(node *)> &func) {
    handle<element>     holder = this;
    handle<layout_data> pld    = ldata.ptr_of<layout_data>();
    return element::each_any_child_node(func) || pld->_used_nodes.each(func);
  }

  inline bool text_block::each_ui_child(function<bool(element *)> func) {
    handle<element>     holder = this;
    handle<layout_data> pld    = ldata.ptr_of<layout_data>();

    if (style_content && style_content->before && func(style_content->before))
      return true;
    for (int n = 0; n < pld->_used_nodes.size(); ++n) {
      if (!pld->_used_nodes[n]->is_element()) continue;
      if (func(pld->_used_nodes[n].ptr_of<element>())) return true;
    }
    if (style_content && style_content->after && func(style_content->after))
      return true;
    if (style_content && style_content->marker && func(style_content->marker))
      return true;
    if (style_content && style_content->shade && func(style_content->shade))
        return true;
    return false;
  }

  inline bool text_block::each_ui_child(function<bool(element *)> func, BACKWARD_E /*b*/) {
    handle<element>     holder = this;
    handle<layout_data> pld    = ldata.ptr_of<layout_data>();
    if (style_content && style_content->shade && func(style_content->shade))
      return true;
    if (style_content && style_content->marker && func(style_content->marker))
      return true;
    if (style_content && style_content->after && func(style_content->after))
      return true;
    for (int n = pld->_used_nodes.size() - 1; n >= 0; --n) {
      if (!pld->_used_nodes[n]->is_element()) continue;
      if (func(pld->_used_nodes[n].ptr_of<element>())) return true;
    }
    if (style_content && style_content->before && func(style_content->before))
      return true;
    return false;
  }

  element *block_parent(view &v, element *el);
} // namespace html

namespace tool {
  template <>
  inline size_t transfer<html::row_def>(html::row_def *dst, size_t dst_elements,
                                        html::row_def *src, size_t elements) {
    size_t mn = min(dst_elements, elements);
    for (size_t n = 0; n < mn; ++n, ++dst, ++src)
      dst->transfer_from(*src);
    return mn;
  }
} // namespace tool

#endif
