#include "html.h"

namespace html {
  // int_v get_parent_declared_width(view &v, element *b);

  slice<hnode> scan_inlines(view &v, slice<hnode> &nodes,
                            bool children_as_blocks) {
    slice<hnode> out;
    out.start = nodes.start;
    while (nodes.length) {
      node *pn = nodes[0];
      if (pn->is_display_none_node(v))
        ;
      else if (pn->is_element()) {
        element *this_el = static_cast<element *>(pn);
        if (children_as_blocks || !this_el->is_inline_element(v)) break;
      }
      nodes.prune(1);
      ++out.length;
    }
    return out;
  }

  bool is_space_seq(view &v, slice<hnode> inlines) {
    for (uint n = 0; n < inlines.length; ++n) {
      node *pn = inlines[n];
      if (pn->is_space()) continue;
      if (pn->is_display_none_node(v)) continue;
      return false;
    }
    return true; // the sequence contains only spaces or invisible elements.
  }

  // NOTE: this function changes class of the element (by changing VTBL of the
  // instance)
  inline element *classify(view &v, element *that, int flow,
                           layout_data *&pld) {
    element *bc = 0;
    pld         = 0;
    switch (flow) {
      default: bc = block::setup_on(v, that);
#ifdef _DEBUG
        dbg_printf("UNSUPPORTED FLOW TYPE on element %s!\n",
                   tag::symbol_name(that->tag).c_str());
        beep();
        // assert(NOT_YET);
#endif
        break;
      case flow_default: bc = block::setup_on(v, that); break;
      case flow_null:
        bc = null_layout::setup_on(v, that);
        break;
        // case flow_text:
        //   bc = block_text::setup_on(v,that); break;
      case flow_vertical: bc = block_vertical::setup_on(v, that); break;
      case flow_horizontal: bc = block_horizontal::setup_on(v, that); break;
      case flow_h_flow: bc = block_horizontal_wrap::setup_on(v, that); break;
      case flow_v_flow: bc = block_vertical_wrap::setup_on(v, that); break;
      case flow_grid: bc = block_grid::setup_on(v, that); break;
      // case flow_template:
      //  bc = block_template::setup_on(v,that); break;
      case flow_table: bc = block_table::setup_on(v, that); break;
      case flow_table_fixed: bc = block_table_fixed::setup_on(v, that); break;
      case flow_table_body: bc = block_table_body::setup_on(v, that); break;
      case flow_stack: bc = block_stack::setup_on(v, that); break;
      case flow_image: bc = block_image::setup_on(v, that); break;
#if defined(SVG_SUPPORT)
      case flow_svg: bc = block_svg::setup_on(v, that); break;
      case flow_svg_element: bc = block_svg_element::setup_on(v, that); break;
#endif
      case flow_table_row: bc = block_table_row::setup_on(v, that); break;
    }
    bc->flags.layout_ctl_valid = 1;
    bc->on_layout_set(v);
    pld = bc->ldata;
    return bc;
  }

  flow_e element::discover_flow_type(view &v) {
    if (c_style->flow != flow_default) return (flow_e)(int)c_style->flow;
    if (c_style->is_display_none()) return flow_default;
    switch (c_style->display) {
      case display_inline: return flow_default;
      case display_table:
      case display_inline_table:
        if (atts.exist(attr::a_fixedlayout))
          return flow_table_fixed;
        else
          return flow_table;
      case display_table_row: return flow_table_row;
      case display_table_body: return flow_table_body;
      case display_block:
      case display_list_item:
      case display_table_cell:
      case display_inline_block: {
        array<hnode> buf;
        slice<hnode> nodes   = this->get_nodes(v, buf);
        slice<hnode> inlines = scan_inlines(v, nodes);
        if (inlines.length && this->c_style->collapse_ws() &&
            inlines[0]->is_space())
          inlines.prune(1);
        if (nodes.length == 0) {
          if (inlines.length && !is_space_seq(v, inlines))
            return flow_text;
          else
            return flow_default;
        }
        return flow_default;
      }
      default: return flow_default;
    }
  }

  inline void set_nodes(element *el, slice<hnode> nodes) {
    el->nodes = nodes;
#ifdef DEBUG
    if (el->is_id_test() && el->nodes.size() > 1)
      el = el;
#endif
    while (!!nodes) {
      // if( nodes[0]->is_element() )
      nodes[0]->owner = el;
      ++nodes;
    }
  }

  bool is_only_one_inline_block(slice<hnode> nodes) {
    return nodes.length == 1 && nodes[0]->is_element() &&
           nodes[0].ptr_of<element>()->c_style->display == display_inline_block;
  }

  struct in_setup_layout {
    helement _this;
    in_setup_layout(element *t) : _this(t) { _this->flags.in_setup_layout = 1; }
    ~in_setup_layout() {
      _this->flags.in_setup_layout  = 0;
      _this->flags.layout_ctl_valid = 1;
      _this->ldata->is_initialized  = true;
    }
  };

  int_v element::auto_width(view &v) {
    ctl *pc = behavior;
    int  w  = 0;
    while (pc) {
      if (pc->get_auto_width(v, this, w)) return w;
      pc = pc->next;
    }
    return int_v();
  }
  int_v element::auto_height(view &v) {
    ctl *pc = behavior;
    int  h  = 0;
    while (pc) {
      if (pc->get_auto_height(v, this, h)) return h;
      pc = pc->next;
    }
    return int_v();
  }

  bool element::need_ellipsis(view &v) {
    if (!get_style(v)->may_need_ellipsis()) return false;
    return ldata->dim.x < ldata->dim_max.x;
  }
  bool element::need_multiline_ellipsis(view &v) {
    if (!get_style(v)->may_need_multiline_ellipsis()) return false;
    return ldata->dim_min.y > ldata->dim.y;
  }

  bool is_tbody(view &v, element *el);
  bool is_table(view &v, element *el) 
  {
    auto cs = el->get_style(v);
    return cs->display == display_table || cs->display == display_inline_table
        || cs->flow == flow_table || cs->flow == flow_table_fixed;
  }


  void element::setup_layout(view &v) {
    display_e display = c_style->display.val();
    if (c_style->is_display_none()) {
      if (state.popup() || airborn)
        display = display_block;
      else
        return;
    } else if (display == display_inline) {
      if (c_style->get_float() != float_none || oof_positioned(v))
        display = display_inline_block;
      else if (parent && parent->c_style->flow != flow_default)
        display = display_block;
      else if (state.popup())
        display = display_block;
      else
        return; // it has no layout by itself
    } else if (display == display_contents)
      return; // it has no layout by itself

    int flow = c_style->flow;

    if (flags.in_setup_layout) {
      // assert(false);
      return;
    }

    in_setup_layout _(this);

    if (flow == flow_default) {
      switch (display) {
        case display_table:
        case display_inline_table:
          if (atts.exist(attr::a_fixedlayout))
            flow = flow_table_fixed;
          else
            flow = flow_table;
          break;
        case display_table_row:
          parent->check_layout(v);
          if (parent && (parent->is_table() || parent->is_table_body())) {
            flow = flow_table_row;
            block_table_row::setup_on(v, this);
            return;
          } else {
            flow = flow_vertical;
            break;
          }
        case display_table_body: flow = flow_table_body; break;
      }
    }

    // if(ldata) ldata->drop();
    bool layout_auto = true;

    switch (flow) {
      case flow_table: // table must be setup before its children
        block_table::setup_on(v, this);
        flags.layout_ctl_valid = 1;
        layout_auto            = false;
        break;
      case flow_table_fixed: // table must be setup before its children
        block_table_fixed::setup_on(v, this);
        flags.layout_ctl_valid = 1;
        layout_auto            = false;
        break;
      case flow_table_body: // table must be setup before its children
        //if (parent && parent->check_layout(v) && parent->is_table()) 
        if (html::is_table(v,parent))
        {
          block_table_body::setup_on(v, this);
          flags.layout_ctl_valid = 1;
          layout_auto = false;
        }
        else {
          flow = flow_vertical;
          block::setup_on(v, this);
          flags.layout_ctl_valid = 1;
          layout_auto = false;
        }
        break;
      case flow_image: // image
        block_image::setup_on(v, this);
        flags.layout_ctl_valid = 1;
        layout_auto            = false;
        break;
#if defined(SVG_SUPPORT)
      case flow_svg: // SVG
        block_svg::setup_on(v, this);
        flags.layout_ctl_valid = 1;
        layout_auto            = false;
        break;
      case flow_svg_element: // SVG::*
        block_svg_element::setup_on(v, this);
        flags.layout_ctl_valid = 1;
        layout_auto            = false;
        break;
#endif
      case flow_table_row:
        //if (parent && parent->check_layout(v) && parent->is_table_body()) {
        if(is_tbody(v,parent)) {
          flow = flow_table_row;
          block_table_row::setup_on(v, this);
          return;
        } else {
          flow = flow_vertical;
          block::setup_on(v, this);
#ifdef _DEBUG
          parent->dbg_report("wrong table row parent");
#endif // _DEBUG
        }
        // else fall through
      default:
        // for the default layout we must first determine styles of children
        // before calling get_nodes() below.
        each_child([&v](element *el) -> bool {
          if (el->get_style(v)->display == display_inline)
            el->resolve_styles(v);
          return false;
        });
        break;
    }

#ifdef _DEBUG
    // if (tag == tag::T_TD)
    //  display = display;
    if (is_id_test()) display = display;
#endif

    array<hnode> transformed_nodes;
    slice<hnode> nodes = this->get_nodes(v, transformed_nodes);
    slice<hnode> inlines =
        scan_inlines(v, nodes, flow != flow_default && flow != flow_text);

    if (inlines.length > 1 && this->c_style->collapse_ws() &&
        inlines[0]->is_space())
      inlines.prune(1);

    if (flow == flow_text) {
      text_block::setup_on(v, this, inlines);
      // flags.layout_ctl_valid = 1;
      // ldata->is_initialized = true;
      return;
    }

    if (nodes.length == 0) // all nodes are inlines - text container
    {
      /*if( flow == flow_text)
      {
        text_block::setup_on(v,this,inlines);
      }
      else*/
      if (flow == flow_default /* || inlines.length == 0*/) {
        if (inlines.length /*&& !is_space_seq(v,inlines)*/)
          text_block::setup_on(v, this, inlines);
        else
          block::setup_on(v, this);
      } else if (!is_space_seq(v, inlines)) {
        layout_data *pld;
        element *    bc = classify(v, this, flow, pld);
        helement     anonymous_text_block //= new element(tag::T_TEXT);
            = v.get_anonymous_para();
        set_nodes(anonymous_text_block, inlines);
        // text_block::setup_on(v,anonymous_text_block,inlines);
        anonymous_text_block->ldata->is_initialized = false;
        pld->push(v, bc, anonymous_text_block);
      } else if (layout_auto) // only spaces
        block::setup_on(v, this);
      // ldata->is_initialized = true;
      return;
    }

    // otherwise it has blocks

    layout_data *pld;
    helement     bc = classify(v, this, flow, pld);
    if (layout_auto)
      pld->drop(); // !!! but not drop_minmax_dim();
    else
      pld->drop_minmax_dim();

    /*int run_no = 0;
    auto spaces_are_significant = [&]() {
      return ++run_no == 1
            && this->state.content_editable()
            && this->c_style->display == display_list_item;
    };*/

    while (nodes.length || inlines.length) {
      if (inlines.length == 0) // got at least one block
      {
        if (!nodes[0]->is_display_none_node(v))
          pld->push(v, bc, nodes[0].ptr_of<element>());
        nodes.prune(1);
      } else if (!is_space_seq(v, inlines) /* || spaces_are_significant()*/) {
        if (is_only_one_inline_block(inlines)) {
          pld->push(v, bc, inlines[0].ptr_of<element>());
        } else {
          helement anonymous_text_block = v.get_anonymous_para();
          set_nodes(anonymous_text_block, inlines);
          anonymous_text_block->ldata->is_initialized = false;
          pld->push(v, bc, anonymous_text_block);
        }
      }
      inlines =
          scan_inlines(v, nodes, flow != flow_default && flow != flow_text);
    }
    // pld->is_initialized = true;
    bc->fixup_layout(v);
  }

  bool get_auto_width(view &v, element *b, int &w);
  bool get_auto_height(view &v, element *b, int &h);

  int element::computed_height(view &v, int container_height) {
    hstyle cs = get_style(v);

    if (ldata->dim_min.x.is_undefined()) calc_intrinsic_widths(v);

    if (ldata->dim_min.y.is_undefined()) layout_width(v, ldata->dim.x);

    int dimy = ldata->dim_min.y;

    int  max_h            = INT_MAX;
    int  min_h            = 0;
    bool intrinsic_height = false;

    if (airborn && airborn->dim.y.is_defined())
      dimy = airborn->dim.y;
    else if (cs->height.is_defined()) {
      if (cs->height.is_auto() && get_auto_height(v, this, dimy))
        dimy = dimy;
      else if (cs->height.is_min_intrinsic() || cs->height.is_auto()) {
        intrinsic_height = true;
        dimy             = ldata->dim_min.y;
      } else if (cs->height.is_max_intrinsic()) {
        intrinsic_height = true;
        dimy             = ldata->dim_max.y;
      } else if (cs->height.is_spring()) {
        dimy = 0;
        if (cs->overflow_y == overflow_none ||
            cs->overflow_y == overflow_visible)
          dimy = ldata->dim_min.y;
        if (cs->get_float()) max_h = ldata->dim_max.y;
      } else if (cs->height.is_percent()) {
        dimy = pixels(v, this, cs->height).height();
      } else {
        dimy = pixels(v, this, cs->height).height();
      }
    } else {
      dimy = ldata->dim_min.y;
    }

    if (cs->min_height.is_defined()) {
      if (cs->height.is_auto() && get_auto_height(v, this, min_h))
        min_h = min_h;
      if (cs->min_height.is_auto() || cs->min_height.is_min_intrinsic()) {
        min_h = ldata->dim_min.y;
      } else if (cs->min_height.is_max_intrinsic()) {
        min_h = ldata->dim_max.y;
      } else if (get_owner() && cs->min_height.is_percent()) {
        // get_owner()->ldata->content_v_percent_dependent = true;
        if (container_height)
          min_h = pixels(v, this, cs->min_height).height();
      } else
        min_h = pixels(v, this, cs->min_height).height();
    }

    if (cs->max_height.is_defined()) {
      if (cs->max_height.is_auto() || cs->max_height.is_max_intrinsic()) {
        max_h = ldata->dim_max.y;
      } else if (cs->max_height.is_min_intrinsic()) {
        max_h = ldata->dim_min.y;
      } else if (get_owner() && cs->max_height.is_percent()) {
        // get_owner()->ldata->content_v_percent_dependent = true;
        if (container_height)
          max_h = pixels(v, this, cs->max_height).height();
      } else
        max_h = pixels(v, this, cs->max_height).height();
    }

    if ((cs->overflow_y == overflow_none) && (dimy < ldata->dim_min.y))
      dimy = ldata->dim_min.y;

    dimy = limit(dimy, min_h, max_h);

    //if (auto bs = cs->box_sizing_y()) {
    //  measure_borders_y(v, size(container_height));
    //  dimy += ldata->inner_borpad_top() + ldata->inner_borpad_bottom();
    //}

    return dimy;
  }

  int element::computed_width(view &v, int container_width) {

    if (ldata->dim_min.x.is_undefined()) calc_intrinsic_widths(v);

    hstyle cs = get_style(v);

    int dimx = 0;

    dimx = min(ldata->dim_max.x.val(0), container_width - ldata->outer_left() - ldata->outer_right()); // shrink-to-fit
    dimx = max(ldata->dim_min.x.val(0), dimx);

    int max_w = INT_MAX;
    int min_w = 0;

    if (airborn && airborn->dim.x.is_defined())
      dimx = airborn->dim.x;
    else if (cs->width.is_defined()) {
      if (cs->width.is_auto())
        (void)get_auto_width(v, this, dimx);
      else if (cs->width.is_min_intrinsic()) {
        dimx = ldata->dim_min.x;
      } else if (cs->width.is_max_intrinsic()) {
        dimx = ldata->dim_max.x;
      } else if (cs->width.is_spring()) {
        if (cs->get_float()) max_w = ldata->dim_max.x;
      } else {
        dimx = pixels(v, this, cs->width).width();
      }
    }

    if (cs->min_width.is_defined()) {
      if (cs->min_width.is_auto() && get_auto_width(v, this, min_w))
        min_w = min_w;
      else if (cs->min_width.is_auto() || cs->min_width.is_min_intrinsic()) {
        min_w = ldata->dim_min.x;
      } else if (cs->min_width.is_max_intrinsic()) {
        min_w = ldata->dim_max.x;
      } else
        min_w = pixels(v, this, cs->min_width).width();
    }

    if (cs->max_width.is_defined()) {
      if (cs->max_width.is_auto()) {
        max_w = container_width;
      } else if (cs->max_width.is_max_intrinsic()) {
        max_w = ldata->dim_max.x;
      } else if (cs->max_width.is_min_intrinsic()) {
        max_w = ldata->dim_min.x;
      } else
        max_w = pixels(v, this, cs->max_width).width();
    }

    if ((cs->overflow_x == overflow_none) && (dimx < ldata->dim_min.x))
      dimx = ldata->dim_min.x;

    if (dimx > max_w) dimx = max_w;
    if (dimx < min_w) dimx = min_w;

    //if (auto bs = cs->box_sizing_x()) {
    //  measure_borders_x(v, size(container_width));
    //  dimx += ldata->inner_borpad_left() + ldata->inner_borpad_right();
    //}
        
    return dimx;
  }

  int known_height(view &v, element *b) {
    if (!b->parent) return b->ldata->dim.y;
    const style *cs = b->get_style(v);
    size_v       h  = cs->height;

    b->flags.has_percent_heights = 1;

    if (h.is_percent())
      return pixels(v, b, h, known_height(v, b->get_owner())).height();
    else if (h.is_fixed())
      return pixels(v, b, h).height();
    else if (b->ldata->dim.y && b->ldata->dim_min.y.is_defined() && stops_layout_propagation(b))
      return b->ldata->dim.y;
    return known_height(v,b->parent);
  }

  int known_height_of_parent(view &v, element *b) {
    if (b->parent) return known_height(v, b->parent);
    return v.dimension().y;
  }

  int known_width(view &v, element *b)  // used for perecnetage calculation on a child
  {
    if (!b->parent) return b->ldata->dim.x;
    const style *cs = b->get_style(v);
    size_v       w  = cs->width;

    b->flags.has_percent_widths = 1;

    if (w.is_percent())
      return pixels(v, b, w, known_width(v, b->parent)).width();
    else if (w.is_fixed())
      return pixels(v, b, w).width();
    else if(b->ldata->dim.x && b->ldata->dim_min.x.is_defined() && stops_layout_propagation(b))
      return b->ldata->dim.x;  
    return known_width(v,b->parent);
    
  }

  int known_width_of_parent(view &v, element *b) {
    if (b->parent) return known_width(v, b->parent);
    return v.dimension().y;
  }

  bool is_defined_width(view &v, element *b) {
    if (!b->parent) return true;
    const style *cs = b->get_style(v);
    size_v       w  = cs->width;
    if (w.is_percent())
      return is_defined_width(v, b->parent);
    else if (w.is_fixed())
      return true;
    return false;
  }

  bool is_width_of_parent_defined(view &v, element *b) {
    if (b->parent) return is_defined_width(v, b->parent);
    return true;
  }

  bool is_defined_height(view &v, element *b) {
    if (!b->parent) return true;
    const style *cs = b->get_style(v);
    size_v       w  = cs->height;
    if (w.is_percent())
      return is_defined_height(v, b->parent);
    else if (w.is_fixed())
      return true;
    return false;
  }

  bool is_height_of_parent_defined(view &v, element *b) {
    if (b->parent) return is_defined_height(v, b->parent);
    return true;
  }

  static element *pos_parent(element *el) {
    element *p = el->get_owner();
    if (p && p->is_table_row()) return p->get_owner();
    return p;
  }

  static point shift(view &v, element *container, element *t) {
    t = pos_parent(t);
    if (!t) return point();
    point off; // = -t->ldata->offset ;
    if (t != container) off = -t->ldata->offset;
    while (t && t != container) {
      off += t->pos();
      t = pos_parent(t);
      if (t == container) break;
      if (t) off -= t->ldata->offset;
    }
    return off;
  }

  point reposition(view &v, element *bp, element *self) {
    if (!self->parent) return point();

    hstyle cs = self->get_style(v);

    handle<layout_data> ld = self->ldata;

    point pos;
    size  dim;

    rect container = bp->client_rect(v);
    container >>= bp->ldata->padding_width;

    bool is_relative = cs->position == position_relative;

    int l = 0, r = 0;
    int t = 0, b = 0;

    size_v left   = cs->left;
    size_v right  = cs->right;
    size_v top    = cs->top;
    size_v bottom = cs->bottom;

    switch (cs->mapping.u.parts.layout) {
      case mapping_left_to_right: swap(left, right); break;
      case mapping_top_to_right: {
        size_v t = top;
        top      = left;
        left     = bottom;
        bottom   = right;
        right    = t;
      } break;
    }

    size parent_dim = self->get_owner()->dim();
    dim.x = premeasure(v, self, cs, parent_dim);

    // measure_borders(v);
    if (is_relative) {
      pos = self->pos() + shift(v, bp, self);
      if (!left.undefined_or_auto())
        pos.x += pixels(v, self, left).width();
      else if (!right.undefined_or_auto())
        pos.x -= pixels(v, self, right).width();
      if (!top.undefined_or_auto())
        pos.y += pixels(v, self, top).height();
      else if (!bottom.undefined_or_auto())
        pos.y -= pixels(v, self, bottom).height();
      return pos;
    }

    if ((right.undefined_or_auto() && left.undefined_or_auto()) ||
        (top.undefined_or_auto() && bottom.undefined_or_auto()))
      pos = self->pos() + shift(v, bp, self);

    int shape_l = ld->outer_left(), shape_r = ld->outer_right();
    int shape_t = ld->outer_top(), shape_b = ld->outer_bottom();

    if (left.is_spring() || right.is_spring() || cs->width.is_spring()) {
      int width_spring = cs->width.undefined_or_auto() ? 100 : cs->width.flex1000();
      int   min_w = width_spring ? self->min_width(v, parent_dim.x) : dim.x;
      int_v max_w = self->max_width(v, parent_dim.x);
      flex::engine se(7);
      se.add(pixels(v, self, left).width(), int_v(), left.flex1000());
      se.add(ld->border_width.s.x, int_v(),
             cs->border_width[0].flex1000());
      se.add(ld->padding_width.s.x, int_v(),
             cs->used_padding(0).flex1000());
      se.add(min_w, max_w, width_spring);
      se.add(ld->padding_width.e.x, int_v(),
             cs->used_padding(2).flex1000());
      se.add(ld->border_width.e.x, int_v(),
             cs->border_width[2].flex1000());
      se.add(pixels(v, self, right).width(), int_v(), right.flex1000());

      if (se.ptotal == 0) {
        assert(false);
        dim.x = self->computed_width(v, container.width());
      } else {
        se.calc(container.width());
        l                       = se.val(0);
        ld->border_width.s.x  = se.val(1);
        ld->padding_width.s.x = se.val(2);
        dim.x                   = se.val(3);
        ld->padding_width.e.x = se.val(4);
        ld->border_width.e.x  = se.val(5);
        r                     = se.val(6);
        pos.x = l + ld->border_width.s.x + ld->padding_width.s.x;
      }
    } else if (left.is_defined() && right.undefined_or_auto()) {

      l = container.left() + pixels(v, self, left, container.size()).width() + shape_l; // it should be content_left()
                   // but I do not include margins in this calculation
      r     = container.right() - shape_r;
      pos.x = l;
      dim.x = max(self->declared_width(v, container.width()), dim.x);
    } else if (left.undefined_or_auto() && right.is_defined()) {
      r     = container.right() - pixels(v, self, right, container.size()).width() - shape_r;
      dim.x = max(self->declared_width(v, container.width()), dim.x);
      pos.x = r - dim.x + 1;
    } else if (left.undefined_or_auto() && right.undefined_or_auto()) {
      if(!dim.x) dim.x = self->declared_width(v, container.width());
    } else // both defined and are not springs
    {
      l = container.left() + pixels(v, self, left).width() + shape_l;
      r = container.right() - pixels(v, self, right).width() - shape_r;
      pos.x = l;
      dim.x = r - l + 1;
    }

    self->set_width(v, dim.x);

    bool fixed_top_bottom = true;

    if (top.is_spring() || bottom.is_spring() || cs->height.is_spring()) {
      fixed_top_bottom = false;

      int   height_spring = cs->height.flex1000();
      int   min_h         = self->min_height(v, parent_dim.y);
      int_v max_h         = self->max_height(v, parent_dim.y);

      flex::engine se(7);
      se.add(pixels(v, self, top, container.size()).height(), int_v(), top.flex1000());
      se.add(ld->border_width.s.y, int_v(),
             cs->border_width[1].flex1000());
      se.add(ld->padding_width.s.y, int_v(),
             cs->used_padding(1).flex1000());
      se.add(min_h, max_h, height_spring);
      se.add(ld->padding_width.e.y, int_v(),
             cs->used_padding(3).flex1000());
      se.add(ld->border_width.e.y, int_v(),
             cs->border_width[3].flex1000());
      se.add(pixels(v, self, bottom).height(), int_v(), bottom.flex1000());

      if (se.ptotal == 0) {
        assert(false);
        dim.y = self->computed_height(v, container.height());
      } else {
        se.calc(container.height());
        t                     = se.val(0);
        ld->border_width.s.y  = se.val(1);
        ld->padding_width.s.y = se.val(2);
        dim.y                 = se.val(3);
        ld->padding_width.e.y = se.val(4);
        ld->border_width.e.y  = se.val(5);
        b                     = se.val(6);
        pos.y = t + ld->border_width.s.y + ld->padding_width.s.y;
      }
    } else if (top.is_defined() && bottom.undefined_or_auto()) {
      t     = container.top() + pixels(v, self, top, container.size()).height() + shape_t;
      dim.y = self->computed_height(v, container.height());
      pos.y = t;
    } else if (top.undefined_or_auto() && bottom.is_defined()) {
      b     = container.bottom() - pixels(v, self, bottom,container.size()).height() - shape_b;
      dim.y = self->computed_height(v, container.height());
      pos.y = b - dim.y + 1;
    } else if (top.undefined_or_auto() && bottom.undefined_or_auto()) {
      dim.y = self->computed_height(v, container.height());
    } else // both defined and are not springs
    {
      t = container.top() + pixels(v, self, top).height() + shape_t;
      b = container.bottom() - pixels(v, self, bottom).height() - shape_b;

      pos.y    = t;
      dim.y    = b - t + 1;
      int minh = self->min_height(v);
      if (dim.y < minh) dim.y = minh;

      self->set_height(v, dim.y);
      return pos;
    }

    self->set_height(v, dim.y);
    return pos;
  }

  element *element::get_scrollable_container(view &v, bool including_this) {
    for (element *b = including_this ? this : layout_parent(v); b;
         b          = b->layout_parent(v))
      if ((b->get_style(v)->overflow() > overflow_visible) ||
          b->popup_positioned(v))
        return b;
    return doc();
  }
  element *element::get_windowed_container(view &v, bool including_this) {
    element *r = this;
    for (element *b = r = including_this ? this : get_owner(); b;
         b              = b->get_owner()) {
      if (b->window(v)) return b;
      r = b;
    }
    return r;
  }

  iwindow *element::get_window(view &v, bool including_this) {
    element *r = this;
    for (element *b = r = including_this ? this : get_owner(); b;
         b              = b->get_owner()) {
      iwindow *pw = b->window(v);
      if (pw) return pw;
      r = b;
    }
    if (r) return r->pview();
    return pview();
  }

  void element::ensure_valid_layout(view &v) {
    if (!is_layout_valid()) {
      check_layout(v);
      if(auto nb = get_scrollable_container(v))
        nb->commit_measure(v);
      else if (auto pd = doc())
        pd->commit_measure(v);
    }
  }

  bool element::scroll_to_view(view &v, handle<element> child, bool toTop, ENSURE_VISIBLE_MANNER how) {
    child->ensure_valid_layout(v);
    return v.scroll_to_view(this, child->margin_box(v, TO_VIEW), toTop, how);
  }

  bool element::can_be_seen_in_full(view &v) {
    size     osz = margin_box(v).size();
    element *p   = get_owner();
    while (p) {
      size psz = p->client_rect(v).size();
      if (psz.x < osz.x || psz.y < osz.y) return false;
      if (p->airborn) return true;
      p = p->get_owner();
    }
    return true;
  }

  void element::update_scrollbars(view &v) {

    if (flags.virtual_v_scrollbar || flags.virtual_h_scrollbar)
      return;

    int overflow_x = c_style->overflow_x;
    int overflow_y = c_style->overflow_y;

    SB_MODE sbm_v = SBM_NONE;
    switch (overflow_y) {
      case overflow_auto: sbm_v = SBM_OPTIONAL; break;
      case overflow_scroll: sbm_v = SBM_ALWAYS; break;
      case overflow_scroll_indicator: sbm_v = SBM_INDICATOR; break;
    }
    SB_MODE sbm_h = SBM_NONE;
    switch (overflow_x) {
      case overflow_auto: sbm_h = SBM_OPTIONAL; break;
      case overflow_scroll: sbm_h = SBM_ALWAYS; break;
      case overflow_scroll_indicator: sbm_h = SBM_INDICATOR; break;
    }

    if (v.is_printing()) return;

    if (!ldata->sb._hsb && sbm_h == SBM_NONE && !ldata->sb._vsb && sbm_v == SBM_NONE) {
/*#ifdef PLATFORM_HANDHELD
      setup_touch_scroll_handler(v, this);
#endif*/
      return;
    }

    // sb.refresh(v, this);
    bool need_refresh = false;

    size dim = ldata->dim;

    scroll_data scd;
    get_scroll_data(v, scd);

    for (int i = 0; i < 2; ++i) {
      range cx         = scd.content_outline.x();
      bool  relayout_y = sbm_h == SBM_NONE ?
                            ldata->sb.remove_h(v, this) :
                            ldata->sb.set_h(v, this, cx, scd.dim_view.x, sbm_h);
      if (relayout_y) {
        need_refresh = true;
        layout_height(v, dim.y);
        get_scroll_data(v, scd);
        on_hscrollbar_show(v);
      }
      range cy         = scd.content_outline.y();
      bool  relayout_x = sbm_v == SBM_NONE ?
                            ldata->sb.remove_v(v, this) :
                            ldata->sb.set_v(v, this, cy, scd.dim_view.y, sbm_v);
      if (relayout_x) {
        need_refresh = true;
        layout_width(v, dim.x);
        layout_height(v, dim.y);
        get_scroll_data(v, scd);
        on_vscrollbar_show(v);
      } else if (cx == scd.content_outline.x())
        break;
    }
    ldata->inner_dim = client_rect(v).size();
    if (need_refresh) v.refresh(this);

    behavior_h pc = behavior;
    while (pc) {
      if (pc->update_scroll_position(v, this)) break;
      pc = pc->next;
    }

#ifdef PLATFORM_HANDHELD
    setup_touch_scroll_handler(v, this);
#endif 


  }

  void element::measure_oof(view &v, size parent_sz, size max_sz) {
    //!!!! drop_layout(true);
    hstyle cs = get_style(v);

    check_layout(v);

    if (ldata->dim_min.x.is_undefined()) { calc_intrinsic_widths(v); }

    measure_borders_x(v, parent_sz);
    measure_borders_y(v, parent_sz);

    rect border_d = border_distance(v);

    max_sz.y -= border_d.bottom() + border_d.top();
    max_sz.x -= border_d.left() + border_d.right();

    size dim;

    if (!cs->h_flex1000() || (airborn && airborn->dim.x.is_defined())) {
      if (cs->width.undefined_or_auto())
        dim.x = max_width(v, parent_sz.x).val(computed_width(v, parent_sz.x));
      else
        dim.x = computed_width(v, parent_sz.x);
      if (dim.x > max_sz.x) dim.x = max_sz.x;
    } else {
      int   width_spring = cs->width.flex1000();
      int   min_w        = min_width(v, parent_sz.x);
      int_v max_w        = max_width(v, parent_sz.x);
      if (max_sz.x && (max_sz.x < max_w)) max_w = max_sz.x;

      flex::engine se(7);
      se.add(ldata->margin_width.s.x, int_v(), cs->margin[0].flex1000());
      se.add(ldata->border_width.s.x, int_v(),
             cs->border_width[0].flex1000());
      se.add(ldata->padding_width.s.x, int_v(),
             cs->used_padding(0).flex1000());
      se.add(min_w, max_w, width_spring);
      se.add(ldata->padding_width.e.x, int_v(),
             cs->used_padding(2).flex1000());
      se.add(ldata->border_width.e.x, int_v(),
             cs->border_width[2].flex1000());
      se.add(ldata->margin_width.e.x, int_v(), cs->margin[2].flex1000());

      if (se.ptotal == 0) {
        dim.x = computed_width(v, parent_sz.x);
        if (max_sz.x < dim.x) dim.x = max_sz.x;
      } else {
        se.calc(parent_sz.x);
        ldata->margin_width.s.x  = se.val(0);
        ldata->border_width.s.x  = se.val(1);
        ldata->padding_width.s.x = se.val(2);
        dim.x                         = se.val(3);
        ldata->padding_width.e.x = se.val(4);
        ldata->border_width.e.x  = se.val(5);
        ldata->margin_width.e.x  = se.val(6);
      }
    }

    set_width(v, dim.x);

    if (!cs->v_flex1000()) {
      dim.y = computed_height(v, parent_sz.y);
      if (dim.y > max_sz.y) {
        // if(!a_style) a_style = new style();
        // a_style->height = max_sz.y;
        // clear_style();
        // get_style(v);
        dim.y = max_sz.y;
      }
    } else {
      int   height_spring = cs->height.flex1000();
      int   min_h         = min_height(v, parent_sz.y);
      int_v max_h         = max_height(v, parent_sz.y);
      if (max_sz.y < max_h) max_h = max_sz.y;

      flex::engine se(7);
      se.add(ldata->margin_width.s.y, int_v(), cs->margin[1].flex1000());
      se.add(ldata->border_width.s.y, int_v(),
             cs->border_width[1].flex1000());
      se.add(ldata->padding_width.s.y, int_v(),
             cs->used_padding(1).flex1000());
      se.add(min_h, max_h, height_spring);
      se.add(ldata->padding_width.e.y, int_v(),
             cs->used_padding(3).flex1000());
      se.add(ldata->border_width.e.y, int_v(),
             cs->border_width[3].flex1000());
      se.add(ldata->margin_width.e.y, int_v(), cs->margin[3].flex1000());

      if (se.ptotal == 0) {
        dim.y = computed_height(v, parent_sz.y);
        if (max_sz.y < dim.y) dim.y = max_sz.y;
      } else {
        se.calc(parent_sz.y);
        ldata->margin_width.s.y  = se.val(0);
        ldata->border_width.s.y  = se.val(1);
        ldata->padding_width.s.y = se.val(2);
        dim.y                         = se.val(3);
        ldata->padding_width.e.y = se.val(4);
        ldata->border_width.e.y  = se.val(5);
        ldata->margin_width.e.y  = se.val(6);
      }
    }
#ifdef _DEBUG
    // assert( dim.y );
#endif
    set_height(v, dim.y);
  }

  void element::measure_oof(view &v, size forced_dim) {
    //!!!! drop_layout(true);
    hstyle cs = get_style(v);

    check_layout(v);

    if (ldata->dim_min.x.is_undefined()) calc_intrinsic_widths(v);

    measure_borders_x(v, forced_dim);
    measure_borders_y(v, forced_dim);

    set_width(v, forced_dim.x);
    set_height(v, forced_dim.y);
  }

  element *block_parent(view &v, element *el) {
    for (element *p = el; p; p = p->parent) {
      if (p->is_block_element(v) || p->is_inline_block_element(v)) return p;
    }
    return 0;
  }

  pair<bookmark, bookmark> selection_ctx::normalized() const {
    return anchor.valid() && caret.valid() && anchor <= caret ?
               pair<bookmark, bookmark>(anchor, caret) :
               pair<bookmark, bookmark>(caret, anchor);
  }

  void selection_ctx::set_caret_to(view &v, bookmark bm, bool keep_anchor) {
    selection_type.clear();

    if (!bm.valid()) {
      if (!keep_anchor) caret = bookmark();
    } else {
      caret     = bm;
      caret_pos = bm.get_caret_rect(v).pointOf(5);
    }
    if (!keep_anchor) { anchor = caret; }
  }

  SELECTION_TYPE
  selection_ctx::get_selection_type(view &v) {
    if (!selection_type.is_defined()) {

      table = 0;

      array<helement> to_be_selected;

      if (!caret.valid() || !anchor.valid() || target.valid())
        selection_type = NO_SELECTION;
      else
        do {
          auto sel = normalized();
          if (caret.node == anchor.node) 
          {
            if (caret.node->parent->state.content_editable() && caret.node->is_inline_block_element(v)) {
              break; // inline block like <img> in <htmlarea>
            }
            else if (sel.first.at_element_start() && sel.second.at_element_end() && !sel.first.node->get_element()->is_break()) {
              if (sel.first.node->get_element()->is_table_cell())
                goto CELL_SELECTION;
              selection_type = SINGLE_BLOCK;
              to_be_selected.push(sel.first.node->get_element());
              break;
            } else if ((sel.first.at_element_start() || sel.second.at_element_end()) /* && !sel.first.node.ptr_of<element>()->is_table_row()*/) {
              selection_type = SINGLE_BLOCK;
              //selection_type = ONLY_CARET;
              to_be_selected.push(sel.first.node->get_element());
              break;
            }
          } else if (caret.valid() && anchor.valid()) {
          CELL_SELECTION:
            element *cp = node::find_common_owner(caret.node, anchor.node);

            if (!cp) {
              selection_type = NO_SELECTION;
              break;
            }

            if (cp->is_table_row()) cp = cp->get_owner();

            if (cp->is_table_body()) {
             
              selection_type = CELL_RANGE;
              table          = static_cast<block_table_body *>(cp);
              uint ar1, ac1, ar2, ac2;
              uint br1, bc1, br2, bc2;
              if (table->get_cell_rows_cols(caret.node, ar1, ar2, ac1, ac2) &&
                  table->get_cell_rows_cols(anchor.node, br1, br2, bc1, bc2)) {
                table_rows.l = min(ar1, ar2, br1, br2);
                table_rows.h = max(ar1, ar2, br1, br2);
                table_cols.l = min(ac1, ac2, bc1, bc2);
                table_cols.h = max(ac1, ac2, bc1, bc2);

                for (uint r = uint(table_rows.l); r <= uint(table_rows.h); ++r)
                  for (uint c = uint(table_cols.l); c <= uint(table_cols.h);
                       ++c) {
                    element *cell = table->get_cell_at(r, c);
                    if (cell) to_be_selected.push(cell);
                  }
                break;
              }
            }
          }
          if (!anchor.valid() || anchor == caret || target.valid())
            selection_type = ONLY_CARET;
          else
            selection_type = TEXT_RANGE;
        } while (false);

      for (int i = 0; i < selected.size(); ++i) {
        helement pel = selected[i];
        if (to_be_selected.get_index(pel) < 0) pel->state_off(v, S_SELECTED);
      }
      for (int i = 0; i < to_be_selected.size(); ++i) {
        helement nel = to_be_selected[i];
        if (selected.get_index(nel) < 0) nel->state_on(v, S_SELECTED);
      }
      selected.swap(to_be_selected);
    }
    auto sel_type = SELECTION_TYPE(selection_type.val(0));
    // element* proot = selection_root();
    return sel_type;
  }

  /*bool selection_ctx::is_selected( view& v, const element* el )
  {
    SELECTION_TYPE st = get_selection_type(v);
    if( st == SINGLE_BLOCK)
      return caret.node.ptr() == el;
    else if( st == CELL_RANGE && el->is_table_cell() )
    {
      uint r,c;
      if(table->get_cell_row_col(el,r,c))
        return (table_rows && int(r)) && (table_cols && int(c));
    }
    return false;
  }*/

  ustring selection_ctx::get_selection_text(view &v) const {
    if (!anchor.valid() || !caret.valid())
      return ustring();
    pos_iterator it(anchor, caret);
    array<wchar> text;
    view* pv = caret.node->pview();
    if(!pv)
      return ustring();
    for (bookmark bm; it(bm);) {
      if(bm.at_char_pos(*pv) && !bm.after_it)
        text.push(bm.ui_char_code(v));
    }
    return text();
  }
  ustring selection_ctx::get_ime_selection_text(view &v) const {
    if (!anchor.valid() || !caret.valid())
      return ustring();
    view* pv = caret.node->pview();
    if (!pv)
      return ustring();
    pos_iterator it(ime_start, ime_end);
    array<wchar> text;
    for (bookmark bm; it(bm);) {
      if (bm.at_char_pos(*pv) && !bm.after_it)
        text.push(bm.ui_char_code(v));
    }
    return text();
  }

  uint selection_ctx::get_range_count(view &v) {
    SELECTION_TYPE st = get_selection_type(v);
    switch (st) {
      default:
      case NO_SELECTION: return 0;
      case ONLY_CARET: return 1;
      case TEXT_RANGE: return 1;
      case SINGLE_BLOCK: return 1;
      case CELL_RANGE: return (uint)selected.length();
    }
  }
  pair<bookmark, bookmark> selection_ctx::get_range(view &v, uint n) {

    if(n >= get_range_count(v))
      return pair<bookmark, bookmark>();
    SELECTION_TYPE st = get_selection_type(v);
    switch (st) {
    default:
      case NO_SELECTION: return pair<bookmark, bookmark>();
      case ONLY_CARET: return pair<bookmark, bookmark>(caret, caret);
      case TEXT_RANGE: return caret < anchor ? pair<bookmark, bookmark>(caret, anchor) 
                                             : pair<bookmark, bookmark>(anchor, caret);
      case SINGLE_BLOCK: return pair<bookmark, bookmark>(anchor, caret);
      case CELL_RANGE: 
        return pair<bookmark, bookmark>(selected[n]->start_pos(), selected[n]->end_pos());
    }
  }

  void element::drop_pagination(view &v) {
    ldata->page_no_start = 0;
    ldata->page_no_end   = 0;
    each_ui_child([&](element *b) -> bool {
      b->drop_pagination(v);
      return false;
    });
  }

  int element::paginate(view &v, range page, range &intersection,
                        int &elements_on_page, int page_no) {
    point vp  = this->doc_pos(v);
    rect  bb  = margin_box(v) + vp;
    range bby = bb.y();

    const style *cs = get_style(v);

#ifdef _DEBUG
    if (tag == tag::T_BODY) cs = cs;
    if (tag == tag::T_P) cs = cs;

    if (cs->page_break_before.is_defined()) cs = cs;
    if (is_id_test()) cs = cs;

#endif

    if (bby.e < page.s) return 0;

    if (bby.s > page.e) {
      ldata->page_no_start = ldata->page_no_end = 0;
      return 0;
    }

    if (cs->page_break_before.is_defined() && (bby.s > page.s)) {
      int pr = cs->page_break_before;
      if (pr >= 0 && ((bby.s - page.s) > (pr * page.length()) / 100) &&
          elements_on_page > 0) {
        intersection |= bby;
        return 0;
      }
    }

    if (cs->page_break_inside.is_defined() && bby.length() <= page.length() && bby.e >= page.e) {
      int pr = cs->page_break_inside;
      if (pr == page_break_avoid && elements_on_page > 0) {
        intersection.s = min(intersection.s, bby.s);
        return 0;
      }
    }

    if (page.covers(bby)) {
      if (cs->page_break_after.is_defined()) {
        int pr = cs->page_break_after;
        if (pr >= 0 && (bby.e - page.s) > ((pr * page.length()) / 100))
          intersection.s = min(intersection.s, bby.e);
      }

      int c = 0;
      each_ui_child([&](element *b) -> bool {
        c += b->paginate(v, page, intersection, elements_on_page, page_no);
        return false;
      });

      ldata->page_no_start = ldata->page_no_end = uint16(page_no);

      if (c) ldata->page_no_end = uint16(page_no);

      elements_on_page += c;

      return 1;
    }

    if (ldata->page_no_start == 0) ldata->page_no_start = uint16(page_no);

    int c = 0;
    each_ui_child([&](element *b) -> bool {
      c += b->paginate(v, page, intersection, elements_on_page, page_no);
      return false;
    });

    if (c) ldata->page_no_end = uint16(page_no);

    elements_on_page += c;

    return c;
  }

  uint apply_marks(view &v, bookmark start, bookmark end, slice<string> marks) {
    if (!start.valid() || !end.valid()) return 0;
        
    pos_iterator pi(start, end);
    uint         prev_mark_id     = uint(-1);
    uint         modified_mark_id = uint(-1);
    uint         counter          = 0;
    element *    el               = nullptr;

    for (bookmark bm; pi(bm);) {
      uint marks_id = bm.marks();
      if (marks_id == modified_mark_id) continue;

      element *pel = bm.node->nearest_text_box();

      if ((pel != el) && pel) {
        pel->drop_content_layout(&v);
        v.add_to_update(pel, CHANGES_VISUAL);
        el = pel;
      }
      if (prev_mark_id == marks_id)
        bm.marks(v, modified_mark_id);
      else {
        prev_mark_id     = marks_id;
        modified_mark_id = apply_span_class(marks_id, marks);
        bm.marks(v, modified_mark_id);
      }
      ++counter;
    }
    return counter;
  }

  uint clear_marks(view &v, bookmark start, bookmark end, slice<string> marks) {
    if (!start.valid() || !end.valid()) return 0;
      
    pos_iterator pi(start, end);
    uint         prev_mark_id     = uint(-1);
    uint         modified_mark_id = uint(-1);
    uint         counter          = 0;
    element *    el               = nullptr;

    for (bookmark bm; pi(bm);) {
      uint marks_id = bm.marks();
      if (marks_id == modified_mark_id) continue;

      element *pel = bm.node->nearest_text_box();

      if ((pel != el) && pel) {
        pel->drop_content_layout(&v);
        v.add_to_update(pel, CHANGES_VISUAL);
        el = pel;
      }
      if (prev_mark_id == marks_id)
        bm.marks(v, modified_mark_id);
      else {
        prev_mark_id     = marks_id;
        modified_mark_id = remove_span_class(marks_id, marks);
        bm.marks(v, modified_mark_id);
      }
      ++counter;
    }
    return counter;
  }

  uint marks_id_of_range(view &v, bookmark start, bookmark end) {
    if (!start.valid() || !end.valid()) return 0;
    if (start == end)
      return start.marks();

    pos_iterator pi(start, end);
    uint         marks_id = 0;

    for (bookmark bm; pi(bm);) 
      marks_id |= bm.marks();
    return marks_id;
  }

  // start - inout, start of span containing the mark, end - end;
  bool get_marks_span(bookmark &start, bookmark &end, ustring &word,
                      chars mark) {
    if (!start.valid()) return false;

    bookmark current = start;

    if (!mark_id_contains_class(current.marks(), mark)) return false;

    bookmark node_start = current.node->start_pos();
    bookmark node_end   = current.node->end_pos();

    if (!node_start.node->is_text()) return false;

    wchar ch;

    for (bookmark t = current; t.valid() && t.node == current.node;
         t.advance_backward(ch)) {
      if (!mark_id_contains_class(t.marks(), mark)) break;
      start = t;
    }

    for (bookmark t = current; t.valid() && t.node == current.node;
         t.advance_forward(ch)) {
      end = t;
      if (!mark_id_contains_class(t.marks(), mark)) break;
    }

    word = node_start.node.ptr_of<text>()->chars(start.linear_pos(),
                                                 end.linear_pos());

    return true;
  }

  bool element::measure_inplace(view &v) {
    get_style(v);
    element *owner = get_owner();
    if (owner && owner->ldata) {
      size    d   = ldata->dim;
      dim_v_t dmi = ldata->dim_min;
      dim_v_t dma = ldata->dim_max;
      drop_minmax_dim();
      if (d.x && !d.y) {
        set_width(v, d.x);
        set_height(v, computed_height(v, owner->ldata->dim.y));
      } else if (!d.x && !d.y) {
        premeasure(v, this, c_style, owner->ldata->dim);
        set_width(v, computed_width(v, owner->ldata->dim.x));
        set_height(v, computed_height(v, owner->ldata->dim.y));
      } else {
        set_width(v, d.x);
        set_height(v, d.y);
      }
      return dmi != ldata->dim_min || dma != ldata->dim_max;
    }
    return false;
  }
  bool element::try_update_inplace(view &v) {
    hstyle cs = get_style(v);
    if (cs->width_depends_on_intrinsic()) return measure_inplace(v);
    element *owner = get_owner();
    if (owner && owner->ldata) do {
        size d = ldata->dim;
        drop_layout();
        if (d.empty()) {
          premeasure(v, this, c_style, owner->ldata->dim);
          set_width(v, computed_width(v, owner->ldata->dim.x));
          set_height(v, computed_height(v, owner->ldata->dim.y));
        } else {
          set_width(v, d.x);
          set_height(v, d.y);
        }
        if (ldata->dim_min.x > d.x) break;

        if (cs->height_depends_on_intrinsic()) {
          if (ldata->dim_min.y != d.y) break;
        }

        if (cs->v_flex1000()) break;

        return false;
        // return ldata->dim_min.x > d.x || ldata->dim.y != d.y;
        // return dmi != ldata->dim_min || dma != ldata->dim_max;
      } while (false);

    v.add_to_update(this, CHANGES_DIMENSION);

    return false;
  }

} // namespace html