#include "html.h"

namespace html {

  block_vertical *block_vertical::setup_on(view &v, element *el) {
    block_vertical *tb = turn_element_to<block_vertical>(el);
    return tb;
  }

  int block::layout_height_flex(view &v, int height) {
    hstyle              cs = get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

#ifdef _DEBUG
    if (is_id_test())
      height = height;
#endif // _DEBUG

    int i = 0;
    const int subs_size = ld->blocks.size();

    ld->dim.y = height;

    size inner_dim = client_rect(v).size();

    if (subs_size == 0) {
      ld->inner_dim.y = inner_dim.y;
      ld->dim.y       = height;
      return ld->dim.x;
    }

    if (ld->dim_min.y.is_defined() && ld->dim_max.y.is_defined() &&
        ld->inner_dim.y == inner_dim.y)
      return ld->dim.x;

    ld->inner_dim = inner_dim;

    flex::engine sc(subs_size * 6 + 5);
    element *   prevb = 0;
    int         pix = 0, spr = 0;

    cs->inner_used_border_width(1).pixels_n_spring_h(v, this, ld->dim.y, pix, spr);
    sc.add(pix, int_v(), spr);

    cs->inner_used_padding(1).pixels_n_spring_h(v, this, ld->dim.y, pix, spr);
    sc.add(pix, int_v(), spr);

    for (i = 0; i < subs_size; i++) {
      helement b   = ld->blocks[i];
      hstyle   bcs = b->get_style(v);

      if (bcs->is_display_none()) continue;
      if (bcs->visibility == visibility_collapse) continue;
      if (b->oof_positioned(v) || b->popup_positioned(v)) continue;

      h_layout_data bld = b->ldata;

#pragma TODO("out of flow measurement!")
      /*if(b->flags.out_of_flow)
      {
         b->measure(v,d->dim.x,d->dim.y);
         continue;
      }*/

      overlapping_y(v, this, prevb, b, pix, spr);
      sc.add(pix, int_v(), spr);

      bcs->used_border_width(1).pixels_n_spring_h(v, b, ld->dim.y, pix, spr);
      sc.add(pix, int_v(), spr);

      bcs->used_padding(1).pixels_n_spring_h(v, b, ld->dim.y, pix, spr);
      sc.add(pix, int_v(), spr);

      int spring_height = bcs->height.flex1000();

      sc.add(b->computed_height(v, ld->dim.y), b->max_height(v, height), spring_height);

      bcs->used_padding(3).pixels_n_spring_h(v, b, ld->dim.y, pix, spr);
      sc.add(pix, int_v(), spr);

      bcs->used_border_width(3).pixels_n_spring_h(v, b, ld->dim.y, pix, spr);
      sc.add(pix, int_v(), spr);

      prevb = b;
    }

    if (!prevb) return ld->dim.x;

    overlapping_y(v, this, prevb, 0, pix, spr);
    sc.add(pix, int_v(), spr);

    cs->inner_used_padding(3).pixels_n_spring_h(v, this, ld->dim.y, pix, spr);
    sc.add(pix, int_v(), spr);

    cs->inner_used_border_width(3).pixels_n_spring_h(v, this, ld->dim.y, pix, spr);
    sc.add(pix, int_v(), spr);

#ifdef _DEBUG
    if (is_id_test())
      height = height;
#endif // _DEBUG

    int content_height = sc.calc(inner_dim.y);

    if (ld->dim_min.y > content_height) content_height = ld->dim_min.y;

    int freespace_a = ld->dim.y - content_height;

    int freespace = min(sc.freespace, freespace_a);
    if (freespace < 0 && (cs->overflow_y != overflow_hidden && cs->overflow_y != overflow_visible))
      freespace = 0;

    int posy = 0;

    auto valign = cs->get_block_vertical_align();
    if (cs->display == display_inline_block || cs->display == display_inline)
      valign = valign_top;

    switch (valign) {
      case valign_top: 
        break;
      case valign_bottom: 
        posy += freespace; 
        break;
      case valign_middle: 
        posy += freespace / 2; 
        break;
    }

    int n = 0;

    posy += (ld->inner_border_width.s.y = sc.val(n++));
    posy += (ld->inner_padding_width.s.y = sc.val(n++));

    for (i = 0; i < subs_size; i++) {
      helement b   = ld->blocks[i];
      hstyle   bcs = b->get_style(v);

      if (bcs->is_display_none()) continue;
      if (bcs->visibility == visibility_collapse) continue;
      if (b->oof_positioned(v) || b->popup_positioned(v)) continue;

      h_layout_data bld = b->ldata;

      if (bcs->position > position_relative) {
        b->set_pos(bld->outer_left(), posy + bld->outer_top());
        continue;
      }

      int margin = sc.val(n);
      posy += margin;

      bld->margin_width.s.y = margin;
      posy += (bld->border_width.s.y = sc.val(++n));
      posy += (bld->padding_width.s.y = sc.val(++n));
      b->set_y_pos(posy);
      b->set_height(v, sc.val(++n));
      posy += bld->dim.y;
      posy += (bld->padding_width.e.y = sc.val(++n));
      posy += (bld->border_width.e.y = sc.val(++n));
      bld->margin_width.e.y = sc.val(++n);
    }

    posy += (ld->inner_padding_width.e.y = sc.val(++n));
    posy += (ld->inner_border_width.e.y = sc.val(++n));

    return ld->dim.x;
  }

} // namespace html