
#pragma once

#include "tool/tool.h"
#include "gool/gool.h"
#include "html-view.h"
#include "html-dom.h"
#include "html-layout.h"
#include "html-primitives.h"
#include "html-layout-text-flow.h"

namespace html {
  namespace tflow {
    using namespace tool;
    using namespace gool;

    enum _ { BR_CHAR = '\n' };

    class text_analysis : public tool::resource {
    public:
      // A single contiguous run of characters containing the same analysis
      // results. Single text analysis run, which points to the next run.
      struct linked_text_run : text_run {
        linked_text_run() throw() : next_run_index(0) {}

        uint32 next_run_index; // index of next run
      };

      text_analysis();

    protected:
      linked_text_run &fetch_next_run(IN OUT uint32 *text_length);
      void             set_current_run(uint32 text_position);
      void             split_current_run(uint32 split_position);

      // Input
      // (weak references are fine here, since this class is a transient
      // stack-based helper that doesn't need to copy data)
      tool::wchars _text; //
      // const wchar_t* _locale_name;
      // IDWriteNumberSubstitution* _number_substitution;
      READING_DIRECTION _reading_direction;

      // Current processing state
      uint32 _current_position;
      uint32 _current_run_index;

      // Output
      tool::array<linked_text_run> _runs;
      tool::array<LINE_BREAKPOINT> _breakpoints;
    };

    void visible_chars_collapse_ws(
        IN node *pnode, IN wchars span, IN char_marks marks,
        OUT tool::array<wchar> &text,
        const function<void(node *, uint, uint, uint, char_mark_t)>
            &run_generator,
        IN wchars lang);

    void visible_chars_break_nl(
        IN node *pnode, IN wchars span, IN char_marks marks,
        OUT tool::array<wchar> &text,
        IN function<void(node *, uint, uint, uint, char_mark_t)> run_generator,
        IN wchars lang);

    void
    flatten_nodes(view &v, element *pe, slice<hnode> nodes,
                  const function<void(wchars, char_marks, node *)> &receiver);

  } // namespace tflow
} // namespace html
