#include "html.h"
#include "html-layout-text-flow.h"
#include "html-layout-text-analysis.h"
//#include "win/win-application.h"

namespace html {

  bool is_collapsible_space(wchar c) {
    if (c == NBSP_CHAR /*nbsp*/) return false;
    if (c > 0xFF) return false;
    return is_space(c);
  }

  bool is_non_collapsible_space(wchar c) {
    if (!is_space(c)) return false;
    if (c == NBSP_CHAR /*nbsp*/) return true;
    if (c > 0xFF) return true;
    return false;
  }

  namespace tflow {
    using namespace tool;
    using namespace gool;

    ////////////////////////////////////////////////////////////////////////////////
    // run modification.

    text_analysis::text_analysis()
        : _reading_direction(), _current_position(0), _current_run_index(0) {}

    text_analysis::linked_text_run &
    text_analysis::fetch_next_run(IN OUT uint32 *text_length) {
      // Used by the sink setters, this returns a reference to the next run.
      // Position and length are adjusted to now point after the current run
      // being returned.

      uint32 run_index       = _current_run_index;
      uint32 run_text_length = _runs[_current_run_index].text_length;

      // Split the tail if needed (the length remaining is less than the
      // current run's size).
      if (*text_length < run_text_length) {
        run_text_length       = *text_length; // Limit to what's actually left.
        uint32 run_text_start = _runs[_current_run_index].text_start;

        split_current_run(run_text_start + run_text_length);
      } else {
        // Just advance the current run.
        _current_run_index = _runs[_current_run_index].next_run_index;
      }
      *text_length -= run_text_length;

      // Return a reference to the run that was just current.
      return _runs[run_index];
    }

    void text_analysis::set_current_run(uint32 text_position) {
      // Move the current run to the given position.
      // Since the analyzers generally return results in a forward manner,
      // this will usually just return early. If not, find the
      // corresponding run for the text position.

      if (_current_run_index < _runs.length() &&
          _runs[_current_run_index].contains_text_position(text_position)) {
        return;
      }

      auto runs = _runs();
      auto res  = runs.find(text_position);
      if (res.length)
        _current_run_index =
            uint32(runs.find(text_position).start - runs.start);
      else {
        _current_run_index = 0;
        assert(false);
      }

      //
      //_current_run_index = static_cast<uint32>(
      //                        std::find(_runs.head(), _runs.tail(),
      //                        text_position)
      //                        - _runs.head());
    }

    void text_analysis::split_current_run(uint32 split_position) {
      // Splits the current run and adjusts the run values accordingly.

      uint32 run_text_start = _runs[_current_run_index].text_start;

      if (split_position <= run_text_start) return; // no change

      // Grow runs by one.
      size_t total_runs = _runs.size();
      try {
        _runs.length(total_runs + 1);
      } catch (...) {
        return; // Can't increase size. Return same run.
      }

      // Copy the old run to the end.
      linked_text_run &frontHalf = _runs[_current_run_index];
      linked_text_run &backHalf  = _runs.last();
      backHalf                   = frontHalf;

      // Adjust runs' text positions and lengths.
      uint32 split_point = split_position - run_text_start;
      backHalf.text_start += split_point;
      backHalf.text_length -= split_point;
      backHalf.text_node_start += split_point;

      frontHalf.text_length    = split_point;
      frontHalf.next_run_index = static_cast<uint32>(total_runs);
      _current_run_index       = static_cast<uint32>(total_runs);
    }

    inline wchar translate(wchar c, const wchars &lang) {
      if (c == '\\') {
        if (lang.starts_with(WCHARS("ja")))
          return 0xA5 /*yen*/;
        else if (lang.starts_with(WCHARS("ko")))
          return 0x20A9 /*won*/;
      }
      return c;
    }

    bool is_space_to_skip(text *tn) {
      if (!tn->is_space()) return false;
      node *pn = tn->prev_node();
      if (!pn) return true;
      if (pn->is_element() && pn->cast<element>()->tag == tag::T_BR)
        return true;
      return false;
    }

    // flattens DOM subtree into vector of chars

    void
    flatten_nodes(view &v, element *pe, slice<hnode> nodes,
                  const function<void(wchars, char_marks, node *)> &receiver) {
      static wchar zero = 0;

      const style *cs   = pe->get_style(v);
      bool  collapse_ws = pe->c_style->collapse_ws();
      bool  was_br = false;

      for (uint i = 0; i < nodes.length; ++i) {
        hnode n = nodes[i];
        if (n->is_text()) {
          text *tn = n.ptr_of<html::text>();

          if (collapse_ws && is_space_to_skip(tn)) continue;

          if (auto tt = cs->text_transform.val()) {
            array<wchar> transformed_text = tn->chars();
            switch (tt) {
              case text_transform_uppercase:  to_upper(transformed_text.target()); break;
              case text_transform_lowercase:  to_lower(transformed_text.target()); break;
              case text_transform_capitalize: capitalize(transformed_text.target()); break;
              default: assert(false);
            }
            receiver(transformed_text(), char_marks(), n);
          } else if (collapse_ws && was_br) // collapse spaces after the <br>
          {
            was_br               = false;
            wchars original      = tn->chars();
            wchars trimmed       = trim_left(original, is_collapsible_space);
            auto   trimmed_marks = tn->marks();
            trimmed_marks.prune(trimmed.start - original.start);
            receiver(trimmed, trimmed_marks, n);
          } else {
            wchars chars = tn->chars();
            auto   marks = tn->marks();
            if (collapse_ws && (i == nodes.length - 1)) { // trailing space handling
              wchars trimmed = trim_right(chars, is_collapsible_space);
              marks.prune(trimmed.start - chars.start);
              chars = trimmed;
            }
            receiver(chars, marks, n);
          }
          continue;
        }
        if (!n->is_element()) continue;

        if (n->is_display_none_node(v)) continue;

        if (n->is_collapsed_node(v)) continue;

        if (n->is_inline_span_element(
                v)) // that is inline <span>-alike container
        {
          element *e = n.ptr_of<element>();
          // e->owner = ptb;
          array<hnode> transformed_nodes;
          flatten_nodes(v, e, e->get_nodes(v, transformed_nodes), receiver);
        } else if (n->is_element() &&
                   n.ptr_of<element>()->tag ==
                       tag::T_BR) // that is inline box <br>-alike container
        {
          element *e = n.ptr_of<element>();
          e->owner   = pe;
          receiver(wchars(&zero, 1), char_marks(), n);
          was_br = true;
        } else // if( n->is_inline_block_element(v) ) // that is inline box
               // <select>-alike container
        {
          element *e = n.ptr_of<element>();
          e->owner   = pe;
          receiver(wchars(&zero, 1), char_marks(), n);
        }
      }
    }

#if 1

    inline wchars scan_ws(wchars &span, char_marks &marks, OUT char_mark_t &mark,
                          OUT tool::array<wchar> &text, wchars lang) {
      uint total = 0;

      if (!span) return wchars();

      mark = *marks;
      if (is_collapsible_space(*span)) {
        if (text.size() != 0) {
          text.push(' ');
          ++total;
        }
        span.prune(1);
        marks.prune(1);
        while (!!span && is_collapsible_space(*span) && (mark == *marks)) {
          span.prune(1);
          marks.prune(1);
        }
      } else if (is_non_collapsible_space(*span)) {
        while (!!span) {
          text.push(span[0]);
          ++total;
          span.prune(1);
          marks.prune(1);
          if (!is_non_collapsible_space(*span) || (mark != *marks)) break;
        }
      }

      else {
        while (!!span) {
          text.push(translate(span[0], lang));
          ++total;
          span.prune(1);
          marks.prune(1);
          if (is_space(*span) || (mark != *marks)) break;
        }
      }
      return wchars(span.start - total, total);
    }
#else
    inline wchars scan_ws(wchars &span, char_marks &marks, OUT char_mark_t &mark,
      OUT tool::array<wchar> &text, wchars lang) {
      uint total = 0;

      if (!span) return wchars();

      mark = *marks;
      while (!!span) {
        text.push(translate(span[0], lang));
        ++total;
        span.prune(1);
        marks.prune(1);
        if (mark != *marks) break;
      }
      return wchars(span.start - total, total);
    }
#endif

    void visible_chars_collapse_ws(
        IN node *pnode, IN wchars span, IN char_marks marks,
        OUT tool::array<wchar> &text,
        const function<void(node *, uint, uint, uint, char_mark_t)> &run_generator,
        IN wchars lang) {
      uint         start = 0;
      const wchar *org   = pnode->cast<html::text>()->chars.cbegin();
      char_mark_t mark = char_mark_t();
      if (!!marks) mark = *marks;

      while (!!span) {
        start = (uint)text.length();
        // const wchar* t = span.start;
        wchars used_span = scan_ws(span, marks, mark, text, lang);
        if ( used_span.length ) // trailing space 
        {
          run_generator(pnode, start, uint(used_span.length),
                        uint(used_span.start - org), mark);
        }
      }
    }

    inline bool scan_nl(node *pnode, wchars &span, char_marks &marks,
                        OUT char_mark_t &mark, OUT tool::array<wchar> &text,
                        wchars lang) {
      uint cnt = 0;
      mark     = *marks;

      while (!!span) {
        if (mark != *marks) {
          assert(text.length());
          break;
        }

        if (*span == '\r') {
          if (span.length > 1 && span[1] == '\n') span.prune(1);
          text.push('\n');
          span.prune(1);
          marks.prune(1);
          ++cnt;
          break;
        }
        else if (*span == '\n') {
          text.push('\n');
          span.prune(1);
          marks.prune(1);
          ++cnt;
          break;
        } else
          text.push(translate(span[0], lang));
        span.prune(1);
        marks.prune(1);
        ++cnt;
      }
      return cnt != 0;
    }

    void visible_chars_break_nl(
        IN node *pnode, IN wchars span, IN char_marks marks,
        OUT tool::array<wchar> &text,
        IN function<void(node *, uint, uint, uint, char_mark_t)> run_generator,
        IN wchars lang) {
      uint         start = 0;
      const wchar *org   = span.start;
      char_mark_t    mark  = char_mark_t();
      if (!!marks) mark = *marks;

      while (!!span) {
        start          = (uint)text.length();
        const wchar *t = span.start;
        if (scan_nl(pnode, span, marks, mark, text, lang))
          run_generator(pnode, start, uint(text.length() - start),
                        uint(t - org), mark);
      }
    }

    inline bool setup_used_run_font(view &v, style *rs, text_run &r,
                                    wchars run_chars_in, const ustring &lang) {
      handle<font> decl_font = v.get_font(rs);

      wchars run_chars = run_chars_in;

      while (run_chars.length) {
        uint ucp = u16::getc(run_chars);

        if (decl_font->has_glyph_for(ucp)) continue;

        if (!app()->get_used_font(r.used_font, decl_font->name, decl_font, lang,
                                  WS_UNKNOWN, ucp))
          r.used_font = decl_font;
        // r.used_font = mswin::app().get_fallback_font(r.script.script, lang,
        // ucp, r.decl_font->serifs);
        goto CHECK;
      }
      r.used_font = decl_font;
      return true;
    CHECK:
      run_chars = run_chars_in;

      while (run_chars.length) {
        uint ucp = u16::getc(run_chars);

        if (r.used_font->has_glyph_for(ucp)) continue;

        // WRITING_SCRIPT ws = writing_script(ucp);
        // view::debug_printf(OT_DOM, OS_WARNING, "error decl-font:%S
        // used-font:%S script id %d", r.decl_font->name.c_str(),
        // r.used_font->name.c_str(),r.script.script);  assert(false);
        return false;
      }
      return true;
    }
  } // namespace tflow

} // namespace html
